﻿<%@ Page Language="C#" AutoEventWireup="false" CodePage="1200" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Deklaracje" %>
<%@ Import Namespace="Soneta.Deklaracje.PIT" %>
<%@ Import Namespace="System.Collections.Generic" %>
<script runat="server">
    void OnContextLoad(Object sender, EventArgs args) {
        var dek = (PIT11Z_22)dc[typeof(PIT11Z_22)];

        bool osobaFizyczna = (bool)dek.Bloki["B1"]["OsobaFiz"];
        string[] nazwa = Soneta.Deklaracje.PIT.PIT.DaneFirmy((string)dek.Bloki["B1"]["Nazwa"], osobaFizyczna);
        
        if (osobaFizyczna) {
            OsobaNieFizyczna.Visible = false;
            if (nazwa.Length > 0)
                Nazwisko.EditValue = nazwa[0].Trim();
            if (nazwa.Length > 1)
                ImiePierwsze.EditValue = nazwa[1].Trim();
            if (nazwa.Length > 2)
                DataUrodzenia.EditValue = nazwa[2].Trim();
        }
        else {
            OsobaFizyczna.Visible = false;
            if (nazwa.Length > 0)
                NazwaPelna.EditValue = nazwa[0].Trim();
            if (nazwa.Length > 1)
                REGON.EditValue = nazwa[1].Trim();
        }

        var pity = new List<PIT11>();
        foreach (PIT11 pit in dek.Deklaracje)
            if (pit is PIT11_22)
                pity.Add((PIT11)pit);
        PIT_REP.DataSource = pity;
    }

    protected void PIT_11_BeforeRow(object sender, EventArgs e) {
        var dek = (PIT11_22)PIT_REP.CurrentRow;
        
        if (dek.JestPESEL) {
            P10_NIP.Visible = false;
            P10_PESEL.Visible = true;
        }
        else {
            P10_NIP.Visible = true;
            P10_PESEL.Visible = false;
        }
        
        var numerDok = (string)dek.Bloki["C1"]["ZagrNIP"];
        ZagrNrId.Visible = numerDok!="";
        if (ZagrNrId.Visible) {     
            NumerDok.EditValue = numerDok;       
            RodzajDok.EditValue = SplitedItem((string)dek.Bloki["C1"]["RodzajDok"], 1, '/');
            KrajDok.EditValue = SplitedItem((string)dek.Bloki["C1"]["KrajDok"], 1, '/');
        }
        else {
            NumerDok.EditValue = "";       
            RodzajDok.EditValue = "";
            KrajDok.EditValue = "";
        }

        var miejsc = (string)dek.Bloki["C2"]["Miejsc"];
        AdresZamieszkania.Visible = miejsc!="";

        if ((bool)dek.Bloki["D"]["Jeden"])
            P28.EditValue = 1;
        else if ((bool)dek.Bloki["D"]["Wiecej"])
            P28.EditValue = 2;
        else if ((bool)dek.Bloki["D"]["JedenPodw"])
            P28.EditValue = 3;
        else if ((bool)dek.Bloki["D"]["WiecejPodw"])
            P28.EditValue = 4;
        else
            P28.EditValue = 1;

        P76.EditValue = (bool)dek.Bloki["F"]["PITR"] ? 1 : 2;

        var pityr = new List<PITR_17>();
        foreach (Deklaracja z in dek.Deklaracje)
            if (z is PITR_17)
                pityr.Add((PITR_17)z);
        PIT_R.DataSource = pityr;
    }

    string SplitedItem(string s, int item, params char[] separator) {
        string[] ss = s.Split(separator);
        return ss.Length<item ? "" : ss[item];
    }

    protected void PIT_R_BeforeRow(object sender, EventArgs e) {
    }

    static void AddMap(XmlDataLabel label, string key, string value, int maxLen) {
        label.ValuesMap.Add(new ValuesPair(key, Soneta.Core.Tools.Left(value, maxLen)));
    }

</script>
<ea:datacontext id="dc" runat="server" TypeName="Soneta.Deklaracje.PIT.PIT11Z_22,Soneta.Deklaracje" OnContextLoad="OnContextLoad"></ea:datacontext>
<?xml version="1.0" encoding="UTF-8"?>
<tns:Deklaracja 
    xsi:schemaLocation="http://crd.gov.pl/wzor/2015/02/23/2097/ http://crd.gov.pl/wzor/2015/02/23/2097/schemat.xsd" 
    xmlns:tns="http://crd.gov.pl/wzor/2015/02/23/2097/" 
    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" 
    xmlns:etd="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2011/06/21/eD/DefinicjeTypy/"
    xmlns:zr="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2014/12/01/eD/PITR/">    
    <tns:Naglowek>
        <tns:KodFormularza kodSystemowy="PIT-11 (22)" kodPodatku="PIT" rodzajZobowiazania="Z" wersjaSchemy="2-0E">PIT-11Z</tns:KodFormularza>
        <tns:WariantFormularza>22</tns:WariantFormularza>		
        <tns:CelZlozenia poz="P_6"><ea:XmlDataLabel runat="server" DataMember="A.Korekta"><ValuesMap><ea:ValuesPair Key="False" Value="1" /><ea:ValuesPair Key="True" Value="2"/></ValuesMap></ea:XmlDataLabel></tns:CelZlozenia>
        <ea:XmlDataLabel ElementName="tns:Rok" runat="server" DataMember="0.Rok" XSDType="TCalkowity" />
        <tns:KodUrzedu>0000</tns:KodUrzedu>		
    </tns:Naglowek>
    <tns:Podmiot1 rola="Płatnik">
        <ea:Section ID="OsobaFizyczna" runat="server"><etd:OsobaFizyczna>
            <ea:XmlDataLabel ElementName="etd:NIP" runat="server" DataMember="0.Nip" XSDType="TNrNIP"/>
            <ea:XmlDataLabel ElementName="etd:ImiePierwsze" ID="ImiePierwsze" runat="server" XSDType="TImie"></ea:XmlDataLabel>
            <ea:XmlDataLabel ElementName="etd:Nazwisko" ID="Nazwisko" runat="server" XSDType="TNazwisko"></ea:XmlDataLabel>
            <ea:XmlDataLabel ElementName="etd:DataUrodzenia" ID="DataUrodzenia" runat="server" XSDType="TData"></ea:XmlDataLabel>
        </etd:OsobaFizyczna></ea:Section>
        <ea:Section ID="OsobaNieFizyczna" runat="server"><etd:OsobaNiefizyczna>
            <ea:XmlDataLabel ElementName="etd:NIP" runat="server" DataMember="0.Nip" XSDType="TNrNIP"/>
            <ea:XmlDataLabel ElementName="etd:PelnaNazwa" ID="NazwaPelna" runat="server" XSDType="TZnakowy" />
            <ea:XmlDataLabel ElementName="etd:REGON" ID="REGON" runat="server" XSDType="TNrREGON" />
        </etd:OsobaNiefizyczna></ea:Section>
    </tns:Podmiot1>	
    <ea:DataRepeater ID="PIT_REP" runat="server" WithSections="False" OnBeforeRow="PIT_11_BeforeRow">
    <tns:Pozycja typ="G">
    <ea:XmlDataLabel ElementName="tns:KodUrzeduP" runat="server" DataMember="X.KodUrzeduSkarbowego" />
    <tns:Podmiot2 rola="Podatnik">
        <tns:OsobaFizyczna>
            <ea:XmlDataLabel ElementName="etd:NIP" ID="P10_NIP" runat="server" DataMember="C1.NIP" XSDType="TNrNIP" />
            <ea:XmlDataLabel ElementName="etd:PESEL" ID="P10_PESEL" runat="server" DataMember="C1.PESEL" XSDType="TNrPESEL" />
            <ea:XmlDataLabel ElementName="etd:ImiePierwsze" runat="server" DataMember="C1.Imię" XSDType="TImie"/>
            <ea:XmlDataLabel ElementName="etd:Nazwisko" runat="server" DataMember="C1.Nazwisko" XSDType="TNazwisko"/>
            <ea:XmlDataLabel ElementName="etd:DataUrodzenia" runat="server" DataMember="C1.DataUrodz" XSDType="TData"/>
            <ea:Section ID="ZagrNrId" runat="server">
                <tns:NrId poz="P_12"><ea:XmlDataLabel ID="NumerDok" runat="server"/></tns:NrId>
                <tns:RodzajNrId poz="P_13"><ea:XmlDataLabel ID="RodzajDok" runat="server"/></tns:RodzajNrId>
                <tns:KodKrajuWydania poz="P_14A"><ea:XmlDataLabel ID="KrajDok" runat="server"/></tns:KodKrajuWydania>
            </ea:Section>
        </tns:OsobaFizyczna>
        <ea:Section ID="AdresZamieszkania" runat="server">
        <tns:AdresZamieszkania>
            <tns:KodKraju poz="P_18A"><ea:XmlDataLabel runat="server" DataMember="X.KodKraju" XSDType="TTekstowy"><ValuesMap><ea:ValuesPair Key="" Value="PL" /></ValuesMap></ea:XmlDataLabel></tns:KodKraju>
            <ea:XmlDataLabel ElementName="tns:Wojewodztwo" ID="pit_wojew" runat="server" DataMember="C2.Wojew" XSDType="TJednAdmin" HideEmptyOrZero="true"/>
            <ea:XmlDataLabel ElementName="tns:Powiat" ID="pit_powiat" runat="server" DataMember="C2.Powiat" XSDType="TJednAdmin" HideEmptyOrZero="true"/>
            <ea:XmlDataLabel ElementName="tns:Gmina" ID="pit_gmina" runat="server" DataMember="C2.Gmina" XSDType="TJednAdmin" HideEmptyOrZero="true"/>
            <ea:XmlDataLabel ElementName="tns:Ulica" PozAttribute="P_22" runat="server" DataMember="C2.Ulica" XSDType="TUlica" HideEmptyOrZero="true"/>
            <ea:XmlDataLabel ElementName="tns:NrDomu" PozAttribute="P_23" ID="pit_nrDomu" runat="server" DataMember="C2.NrDomu" XSDType="TNrBudynku" HideEmptyOrZero="true"/>
            <ea:XmlDataLabel ElementName="tns:NrLokalu" PozAttribute="P_24" runat="server" DataMember="C2.NrLokalu" XSDType="TNrLokalu" HideEmptyOrZero="true"/>
            <ea:XmlDataLabel ElementName="tns:Miejscowosc" PozAttribute="P_25" ID="pit_miejsc" runat="server" DataMember="C2.Miejsc" XSDType="TMiejscowosc"/>
            <ea:XmlDataLabel ElementName="tns:KodPocztowy" PozAttribute="P_26" ID="pit_kodPoczt" runat="server" DataMember="C2.KodPoczt" XSDType="TKodPocztowy" HideEmptyOrZero="true"/>
            <ea:XmlDataLabel ElementName="tns:Poczta" ID="pit_poczta" runat="server" DataMember="C2.Poczta" XSDType="TMiejscowosc" HideEmptyOrZero="true"/>
        </tns:AdresZamieszkania>
        </ea:Section>
    </tns:Podmiot2>
    <tns:PozycjeSzczegolowe>
        <tns:P_10><ea:XmlDataLabel runat="server" DataMember="C1.Rezydent"><ValuesMap><ea:ValuesPair Key="False" Value="2" /><ea:ValuesPair Key="True" Value="1"/></ValuesMap></ea:XmlDataLabel></tns:P_10>        

        <ea:XmlDataLabel ElementName="tns:P_28" ID="P28" runat="server" XSDType="TCalkowity" HideEmptyOrZero="true"/>

        <ea:XmlDataLabel ElementName="tns:P_29" runat="server" DataMember="E.1aPrzychód" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="tns:P_30" runat="server" DataMember="E.1aKoszty" XSDType="TKwota2" HideEmptyOrZero="true"/>
        <ea:XmlDataLabel ElementName="tns:P_31" runat="server" DataMember="E.1Dochód" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="tns:P_32" runat="server" DataMember="E.1Zwolniony" XSDType="TKwota2" HideEmptyOrZero="true"/>
        <ea:XmlDataLabel ElementName="tns:P_33" runat="server" DataMember="E.1Zaliczka" XSDType="TKwotaC"/>
        <ea:XmlDataLabel ElementName="tns:P_34" runat="server" DataMember="E.1bPrzychód" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="tns:P_35" runat="server" DataMember="E.1bKoszty" XSDType="TKwota2"/>
		
        <ea:XmlDataLabel ElementName="tns:P_36" runat="server" DataMember="E.2Przychód" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="tns:P_37" runat="server" DataMember="E.2Dochód" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="tns:P_38" runat="server" DataMember="E.2Zaliczka" XSDType="TKwotaC"/>
		
        <ea:XmlDataLabel ElementName="tns:P_39" runat="server" DataMember="E.3Przychód" XSDType="TKwota2"/>		
        <ea:XmlDataLabel ElementName="tns:P_40" runat="server" DataMember="E.3Dochód" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="tns:P_41" runat="server" DataMember="E.3Zwolniony" XSDType="TKwota2" HideEmptyOrZero="true"/>
        <ea:XmlDataLabel ElementName="tns:P_42" runat="server" DataMember="E.3Zaliczka" XSDType="TKwotaC"/>
		
        <ea:XmlDataLabel ElementName="tns:P_43" runat="server" DataMember="E.4Przychód" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="tns:P_44" runat="server" DataMember="E.4Dochód" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="tns:P_45" runat="server" DataMember="E.4Zaliczka" XSDType="TKwotaC"/>
		
        <ea:XmlDataLabel ElementName="tns:P_46" runat="server" DataMember="E.5Przychód" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="tns:P_47" runat="server" DataMember="E.5Dochód" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="tns:P_48" runat="server" DataMember="E.5Zaliczka" XSDType="TKwotaC"/>
		
        <ea:XmlDataLabel ElementName="tns:P_49" runat="server" DataMember="E.6Przychód" XSDType="TKwota2"/>		
        <ea:XmlDataLabel ElementName="tns:P_50" runat="server" DataMember="E.6Koszty" XSDType="TKwota2" HideEmptyOrZero="true"/>
        <ea:XmlDataLabel ElementName="tns:P_51" runat="server" DataMember="E.6Dochód" XSDType="TKwota2"/>		
        <ea:XmlDataLabel ElementName="tns:P_52" runat="server" DataMember="E.6Zaliczka" XSDType="TKwotaC"/>		

        <ea:XmlDataLabel ElementName="tns:P_53" runat="server" DataMember="E.7Przychód" XSDType="TKwota2"/>		
        <ea:XmlDataLabel ElementName="tns:P_54" runat="server" DataMember="E.7Koszty" XSDType="TKwota2" HideEmptyOrZero="true"/>		
        <ea:XmlDataLabel ElementName="tns:P_55" runat="server" DataMember="E.7Dochód" XSDType="TKwota2"/>		
        <ea:XmlDataLabel ElementName="tns:P_56" runat="server" DataMember="E.7Zaliczka" XSDType="TKwotaC"/>

        <ea:XmlDataLabel ElementName="tns:P_57" runat="server" DataMember="E.8Przychód" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="tns:P_58" runat="server" DataMember="E.8Dochód" XSDType="TKwota2"/>		
        <ea:XmlDataLabel ElementName="tns:P_59" runat="server" DataMember="E.8Zaliczka" XSDType="TKwotaC"/>
        <ea:XmlDataLabel ElementName="tns:P_60" runat="server" DataMember="E.8bPrzychód" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="tns:P_61" runat="server" DataMember="E.8Koszty" XSDType="TKwota2"/>

        <ea:XmlDataLabel ElementName="tns:P_62" runat="server" DataMember="E.9Przychód" XSDType="TKwota2"/>		
        <ea:XmlDataLabel ElementName="tns:P_63" runat="server" DataMember="E.9Koszty" XSDType="TKwota2" HideEmptyOrZero="true"/>
        <ea:XmlDataLabel ElementName="tns:P_64" runat="server" DataMember="E.9Dochód" XSDType="TKwota2"/>		
        <ea:XmlDataLabel ElementName="tns:P_65" runat="server" DataMember="E.9Zaliczka" XSDType="TKwotaC"/>

        <ea:XmlDataLabel ElementName="tns:P_66" runat="server" DataMember="E.10Przychód" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="tns:P_67" runat="server" DataMember="E.10Dochód" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="tns:P_68" runat="server" DataMember="E.10Zwolniony" XSDType="TKwota2" HideEmptyOrZero="true"/>
        <ea:XmlDataLabel ElementName="tns:P_69" runat="server" DataMember="E.10Zaliczka" XSDType="TKwotaC"/>

        <ea:XmlDataLabel ElementName="tns:P_70" runat="server" DataMember="E.Społeczne" XSDType="TKwota2"/>		
        <ea:XmlDataLabel ElementName="tns:P_71" runat="server" DataMember="E.SpołeczneZagr" XSDType="TKwota2" HideEmptyOrZero="true"/>				
        <ea:XmlDataLabel ElementName="tns:P_72" runat="server" DataMember="E.ZdrDoOdlicz" XSDType="TKwota2"/>		
        <ea:XmlDataLabel ElementName="tns:P_73" runat="server" DataMember="E.ZdrDoOdliczZagr" XSDType="TKwota2" HideEmptyOrZero="true"/>		

        <ea:XmlDataLabel ElementName="tns:P_74" runat="server" DataMember="F.ZZagranicy" XSDType="TKwota2" HideEmptyOrZero="true"/>
        <ea:XmlDataLabel ElementName="tns:P_75" runat="server" DataMember="F.PomocBezzwrotna" XSDType="TKwota2" HideEmptyOrZero="true"/>

        <ea:XmlDataLabel ElementName="tns:P_76" ID="P76" runat="server" DataMember="F.PITR"><ValuesMap><ea:ValuesPair Key="True" Value="1" /><ea:ValuesPair Key="False" Value="2"/></ValuesMap></ea:XmlDataLabel>
    </tns:PozycjeSzczegolowe>
    <tns:Zalaczniki>
    <ea:DataRepeater ID="PIT_R" runat="server" WithSections="False" OnBeforeRow="PIT_R_BeforeRow">
    <zr:Zalacznik_PIT-R>
    <zr:Naglowek>
        <zr:KodFormularza kodSystemowy="PIT-R (17)" wersjaSchemy="1-0E">PIT-R</zr:KodFormularza>
        <zr:WariantFormularza>17</zr:WariantFormularza>
    </zr:Naglowek>
    <zr:PozycjeSzczegolowe>
        <ea:XmlDataLabel ElementName="zr:P_12" runat="server" DataMember="D.01_b" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="zr:P_13" runat="server" DataMember="D.01_c" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="zr:P_14" runat="server" DataMember="D.01_d" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="zr:P_15" runat="server" DataMember="D.01_e" XSDType="TKwota2"/>		

        <ea:XmlDataLabel ElementName="zr:P_16" runat="server" DataMember="D.02_b" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="zr:P_17" runat="server" DataMember="D.02_c" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="zr:P_18" runat="server" DataMember="D.02_d" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="zr:P_19" runat="server" DataMember="D.02_e" XSDType="TKwota2"/>		

        <ea:XmlDataLabel ElementName="zr:P_20" runat="server" DataMember="D.03_b" XSDType="TKwota2"/>		
        <ea:XmlDataLabel ElementName="zr:P_21" runat="server" DataMember="D.03_c" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="zr:P_22" runat="server" DataMember="D.03_d" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="zr:P_23" runat="server" DataMember="D.03_e" XSDType="TKwota2"/>		

        <ea:XmlDataLabel ElementName="zr:P_24" runat="server" DataMember="D.04_b" XSDType="TKwota2"/>		
        <ea:XmlDataLabel ElementName="zr:P_25" runat="server" DataMember="D.04_c" XSDType="TKwota2"/>		
        <ea:XmlDataLabel ElementName="zr:P_26" runat="server" DataMember="D.04_d" XSDType="TKwota2"/>		
        <ea:XmlDataLabel ElementName="zr:P_27" runat="server" DataMember="D.04_e" XSDType="TKwota2"/>				

        <ea:XmlDataLabel ElementName="zr:P_28" runat="server" DataMember="D.05_b" XSDType="TKwota2"/>		
        <ea:XmlDataLabel ElementName="zr:P_29" runat="server" DataMember="D.05_c" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="zr:P_30" runat="server" DataMember="D.05_d" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="zr:P_31" runat="server" DataMember="D.05_e" XSDType="TKwota2"/>		

        <ea:XmlDataLabel ElementName="zr:P_32" runat="server" DataMember="D.06_b" XSDType="TKwota2"/>		
        <ea:XmlDataLabel ElementName="zr:P_33" runat="server" DataMember="D.06_c" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="zr:P_34" runat="server" DataMember="D.06_d" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="zr:P_35" runat="server" DataMember="D.06_e" XSDType="TKwota2"/>		

        <ea:XmlDataLabel ElementName="zr:P_36" runat="server" DataMember="D.07_b" XSDType="TKwota2"/>		
        <ea:XmlDataLabel ElementName="zr:P_37" runat="server" DataMember="D.07_c" XSDType="TKwota2"/>		
        <ea:XmlDataLabel ElementName="zr:P_38" runat="server" DataMember="D.07_d" XSDType="TKwota2"/>		
        <ea:XmlDataLabel ElementName="zr:P_39" runat="server" DataMember="D.07_e" XSDType="TKwota2"/>				

        <ea:XmlDataLabel ElementName="zr:P_40" runat="server" DataMember="D.08_b" XSDType="TKwota2"/>		
        <ea:XmlDataLabel ElementName="zr:P_41" runat="server" DataMember="D.08_c" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="zr:P_42" runat="server" DataMember="D.08_d" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="zr:P_43" runat="server" DataMember="D.08_e" XSDType="TKwota2"/>		

        <ea:XmlDataLabel ElementName="zr:P_44" runat="server" DataMember="D.09_b" XSDType="TKwota2"/>		
        <ea:XmlDataLabel ElementName="zr:P_45" runat="server" DataMember="D.09_c" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="zr:P_46" runat="server" DataMember="D.09_d" XSDType="TKwota2"/>		
        <ea:XmlDataLabel ElementName="zr:P_47" runat="server" DataMember="D.09_e" XSDType="TKwota2"/>		

        <ea:XmlDataLabel ElementName="zr:P_48" runat="server" DataMember="D.10_b" XSDType="TKwota2"/>		
        <ea:XmlDataLabel ElementName="zr:P_49" runat="server" DataMember="D.10_c" XSDType="TKwota2"/>		
        <ea:XmlDataLabel ElementName="zr:P_50" runat="server" DataMember="D.10_d" XSDType="TKwota2"/>		
        <ea:XmlDataLabel ElementName="zr:P_51" runat="server" DataMember="D.10_e" XSDType="TKwota2"/>				

        <ea:XmlDataLabel ElementName="zr:P_52" runat="server" DataMember="D.11_b" XSDType="TKwota2"/>		
        <ea:XmlDataLabel ElementName="zr:P_53" runat="server" DataMember="D.11_c" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="zr:P_54" runat="server" DataMember="D.11_d" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="zr:P_55" runat="server" DataMember="D.11_e" XSDType="TKwota2"/>		

        <ea:XmlDataLabel ElementName="zr:P_56" runat="server" DataMember="D.12_b" XSDType="TKwota2"/>		
        <ea:XmlDataLabel ElementName="zr:P_57" runat="server" DataMember="D.12_c" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="zr:P_58" runat="server" DataMember="D.12_d" XSDType="TKwota2"/>		
        <ea:XmlDataLabel ElementName="zr:P_59" runat="server" DataMember="D.12_e" XSDType="TKwota2"/>		

        <ea:XmlDataLabel ElementName="zr:P_60" runat="server" DataMember="D.razem_e" XSDType="TKwota2"/>
    </zr:PozycjeSzczegolowe>
    </zr:Zalacznik_PIT-R>
    </ea:DataRepeater>
    </tns:Zalaczniki>
    </tns:Pozycja>
    </ea:DataRepeater>
    <tns:Pouczenie>Za uchybienie obowiązkom płatnika grozi odpowiedzialność przewidziana w Kodeksie karnym skarbowym.</tns:Pouczenie>
</tns:Deklaracja>
