﻿<%@ Page Language="C#" AutoEventWireup="false" CodePage="1200" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Deklaracje" %>
<%@ Import Namespace="Soneta.Deklaracje.PIT" %>
<%@ Import Namespace="System.Collections.Generic" %>
<script runat="server">

    void OnContextLoad(Object sender, EventArgs args) {
        Soneta.Deklaracje.PIT.PIT40_19 dek = (PIT40_19)dc[typeof(PIT40_19)];

        bool osobaFizyczna = (bool)dek.Bloki["B1"]["OsobaFiz"];
        string[] nazwa = Soneta.Deklaracje.PIT.PIT.DaneFirmy((string)dek.Bloki["B1"]["Nazwa"], osobaFizyczna);

        if (osobaFizyczna) {
            OsobaNieFizyczna.Visible = false;
            if (nazwa.Length > 0)
                Nazwisko.EditValue = nazwa[0].Trim();
            if (nazwa.Length > 1)
                ImiePierwsze.EditValue = nazwa[1].Trim();
            if (nazwa.Length > 2)
                DataUrodzenia.EditValue = nazwa[2].Trim();
        }
        else {
            OsobaFizyczna.Visible = false;
            if (nazwa.Length > 0)
                NazwaPelna.EditValue = nazwa[0].Trim();
            if (nazwa.Length > 1)
                REGON.EditValue = nazwa[1].Trim();
        }

        string kodKraju = ((string)dek.Bloki["X"]["KodKraju"]).ToUpper();
        if (kodKraju == "" || kodKraju=="PL")
            AdresZagr.Visible = false;
        else
            AdresPol.Visible = false;

        if (dek.JestPESEL)
            P9_NIP.Visible = false;
        else
            P9_PESEL.Visible = false;
                
        if ((bool)dek.Bloki["E"]["Jeden"])
            P24.EditValue = 1;
        else if ((bool)dek.Bloki["E"]["Wiecej"])
            P24.EditValue = 2;
        else if ((bool)dek.Bloki["E"]["JedenPodw"])
            P24.EditValue = 3;
        else if ((bool)dek.Bloki["E"]["WiecejPodw"])
            P24.EditValue = 4;
        else if ((bool)dek.Bloki["E"]["Rachunki"])
            P24.EditValue = 5;
        else
            P24.EditValue = 1;

        G_InneKwota.Visible = (decimal)dek.Bloki["G"]["InneKwota"] != 0;
        H2_InneKwota.Visible = (decimal)dek.Bloki["H2"]["InneKwota"] != 0;

        bool nadpłata = (decimal)dek.Bloki["H3"]["Nadpłata"] != 0;
        H3_Nadpłata.Visible = nadpłata;
        H3_DoZapłaty.Visible = !nadpłata;
        
        ORD_ZU.Visible = dek.TreśćUzasadnienia != "";
        
        List<PITR_16> pityr = new List<PITR_16>();
        foreach (Deklaracja z in dek.Deklaracje)
            if (z is PITR_16)
                pityr.Add((PITR_16)z);
        PIT_R_16.DataSource = pityr;

        string brakDanych = dek.Module.Config.PIT.Ogólne.UzupełnienieAdresuNaEDeklaracji;
        if (brakDanych != "") {
            AddMap(pit_wojew, "", brakDanych, 36);
            AddMap(pit_powiat, "", brakDanych, 36);
            AddMap(pit_gmina, "", brakDanych, 36);
            AddMap(pit_nrDomu, "", brakDanych, 9);
            AddMap(pit_miejsc, "", brakDanych, 56);
            AddMap(pit_kodPoczt, "", brakDanych, 8);
            AddMap(pit_kodPoczt, "0", brakDanych, 8);
            AddMap(pit_poczta, "", brakDanych, 56);
            AddMap(pit_miejscZagr, "", brakDanych, 56);
        }
    }

    static void AddMap(XmlDataLabel label, string key, string value, int maxLen) {
        label.ValuesMap.Add(new ValuesPair(key, Soneta.Core.Tools.Left(value, maxLen)));
    }
    
    protected void PIT_R_16_BeforeRow(object sender, EventArgs e) {
    }

    static void Msg(object value) {
    }

</script>
<ea:datacontext id="dc" runat="server" TypeName="Soneta.Deklaracje.PIT.PIT40_19,Soneta.Deklaracje" OnContextLoad="OnContextLoad"></ea:datacontext>
<?xml version="1.0" encoding="UTF-8"?>
<Deklaracja 
    xmlns:xsd="http://www.w3.org/2001/XMLSchema"
    xmlns="http://crd.gov.pl/wzor/2013/11/25/1389/"
    xmlns:etd="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2011/06/21/eD/DefinicjeTypy/"
    xmlns:zr="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2013/09/18/eD/PITR/"
    xmlns:zzu="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2011/10/07/eD/ORDZU/">
    <Naglowek>
        <KodFormularza kodSystemowy="PIT-40 (19)" kodPodatku="PIT" rodzajZobowiazania="Z" wersjaSchemy="1-0E">PIT-40</KodFormularza>
        <WariantFormularza>19</WariantFormularza>		
        <CelZlozenia poz="P_6"><ea:XmlDataLabel ID="DataLabel1" runat="server" DataMember="A.Korekta"><ValuesMap><ea:ValuesPair Key="False" Value="1" /><ea:ValuesPair Key="True" Value="2"/></ValuesMap></ea:XmlDataLabel></CelZlozenia>
        <ea:XmlDataLabel ElementName="Rok" runat="server" DataMember="0.Rok" />
        <ea:XmlDataLabel ElementName="KodUrzedu" runat="server" DataMember="X.KodUrzeduSkarbowego" />
    </Naglowek>
    <Podmiot1 rola="Płatnik">
        <ea:Section ID="OsobaFizyczna" runat="server"><etd:OsobaFizyczna>
            <ea:XmlDataLabel ElementName="etd:NIP" runat="server" DataMember="0.Nip" XSDType="TNrNIP"/>
            <ea:XmlDataLabel ElementName="etd:ImiePierwsze" ID="ImiePierwsze" runat="server" XSDType="TImie"></ea:XmlDataLabel>
            <ea:XmlDataLabel ElementName="etd:Nazwisko" ID="Nazwisko" runat="server" XSDType="TNazwisko"></ea:XmlDataLabel>
            <ea:XmlDataLabel ElementName="etd:DataUrodzenia" ID="DataUrodzenia" runat="server" XSDType="TData"></ea:XmlDataLabel>
        </etd:OsobaFizyczna></ea:Section>
        <ea:Section ID="OsobaNieFizyczna" runat="server"><etd:OsobaNiefizyczna>
            <ea:XmlDataLabel ElementName="etd:NIP" runat="server" DataMember="0.Nip" XSDType="TNrNIP"/>
            <ea:XmlDataLabel ElementName="etd:PelnaNazwa" ID="NazwaPelna" runat="server" XSDType="TZnakowy" />
            <ea:XmlDataLabel ElementName="etd:REGON" ID="REGON" runat="server" XSDType="TNrREGON" />
        </etd:OsobaNiefizyczna></ea:Section>
    </Podmiot1>	
    <Podmiot2 rola="Podatnik" poz="P_9A">
        <etd:OsobaFizyczna>
            <ea:XmlDataLabel ElementName="etd:NIP" ID="P9_NIP" runat="server" DataMember="C1.NIP" XSDType="TNrNIP" />
            <ea:XmlDataLabel ElementName="etd:PESEL" ID="P9_PESEL" runat="server" DataMember="C1.PESEL" XSDType="TNrPESEL" />
            <ea:XmlDataLabel ElementName="etd:ImiePierwsze" runat="server" DataMember="C1.Imię" XSDType="TImie"/>
            <ea:XmlDataLabel ElementName="etd:Nazwisko" runat="server" DataMember="C1.Nazwisko" XSDType="TNazwisko"/>
            <ea:XmlDataLabel ElementName="etd:DataUrodzenia" runat="server" DataMember="C1.DataUrodz" XSDType="TData"/>
        </etd:OsobaFizyczna>
        <etd:AdresZamieszkania rodzajAdresu="RAD">
            <ea:Section ID="AdresPol" runat="server">
            <etd:AdresPol>
                <etd:KodKraju>PL</etd:KodKraju>
                <ea:XmlDataLabel ElementName="etd:Wojewodztwo" ID="pit_wojew" runat="server" DataMember="C2.Wojew" XSDType="TJednAdmin"/>
                <ea:XmlDataLabel ElementName="etd:Powiat" ID="pit_powiat" runat="server" DataMember="C2.Powiat" XSDType="TJednAdmin"/>
                <ea:XmlDataLabel ElementName="etd:Gmina" ID="pit_gmina" runat="server" DataMember="C2.Gmina" XSDType="TJednAdmin"/>
                <ea:XmlDataLabel ElementName="etd:Ulica" runat="server" DataMember="C2.Ulica" XSDType="TUlica" HideEmptyOrZero="true"/>
                <ea:XmlDataLabel ElementName="etd:NrDomu" ID="pit_nrDomu" runat="server" DataMember="C2.NrDomu" XSDType="TNrBudynku"/>
                <ea:XmlDataLabel ElementName="etd:NrLokalu" runat="server" DataMember="C2.NrLokalu" XSDType="TNrLokalu" HideEmptyOrZero="true"/>
                <ea:XmlDataLabel ElementName="etd:Miejscowosc" ID="pit_miejsc" runat="server" DataMember="C2.Miejsc" XSDType="TMiejscowosc"/>
                <ea:XmlDataLabel ElementName="etd:KodPocztowy" ID="pit_kodPoczt" runat="server" DataMember="C2.KodPoczt" XSDType="TKodPocztowy"/>
                <ea:XmlDataLabel ElementName="etd:Poczta" ID="pit_poczta" runat="server" DataMember="C2.Poczta" XSDType="TMiejscowosc"/>
            </etd:AdresPol>
            </ea:Section>
            <ea:Section ID="AdresZagr" runat="server">
            <etd:AdresZagr>
                <ea:XmlDataLabel ElementName="etd:KodKraju" runat="server" DataMember="X.KodKraju" XSDType="TTekstowy"/>
                <ea:XmlDataLabel ElementName="etd:KodPocztowy" runat="server" DataMember="C2.KodPoczt" XSDType="TKodPocztowy" HideEmptyOrZero="true"/>
                <ea:XmlDataLabel ElementName="etd:Miejscowosc" ID="pit_miejscZagr" runat="server" DataMember="C2.Miejsc" XSDType="TMiejscowosc"/>
                <ea:XmlDataLabel ElementName="etd:Ulica" runat="server" DataMember="C2.Ulica" XSDType="TUlica" HideEmptyOrZero="true"/>
                <ea:XmlDataLabel ElementName="etd:NrDomu" runat="server" DataMember="C2.NrDomu" XSDType="TNrBudynku" HideEmptyOrZero="true"/>
                <ea:XmlDataLabel ElementName="etd:NrLokalu" runat="server" DataMember="C2.NrLokalu" XSDType="TNrLokalu" HideEmptyOrZero="true"/>
            </etd:AdresZagr>
            </ea:Section>
        </etd:AdresZamieszkania>
    </Podmiot2>
    <PozycjeSzczegolowe>	
        <ea:XmlDataLabel ElementName="P_23" runat="server" DataMember="D.PIT_R" XSDType="TCalkowity" HideEmptyOrZero="true"><ValuesMap><ea:ValuesPair Key="False" Value="0" /><ea:ValuesPair Key="True" Value="1"/></ValuesMap></ea:XmlDataLabel>	
        <ea:XmlDataLabel ElementName="P_24" ID="P24" runat="server" XSDType="TCalkowity"/>

        <ea:XmlDataLabel ElementName="P_25" runat="server" DataMember="F.1aPrzychód" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="P_26" runat="server" DataMember="F.1aKoszty" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="P_27" runat="server" DataMember="F.1Dochód" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="P_28" runat="server" DataMember="F.1Zaliczka" XSDType="TKwotaC"/>
        <ea:XmlDataLabel ElementName="P_29" runat="server" DataMember="F.1bPrzychód" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="P_30" runat="server" DataMember="F.1bKoszty" XSDType="TKwota2"/>
		
        <ea:XmlDataLabel ElementName="P_31" runat="server" DataMember="F.2Przychód" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="P_32" runat="server" DataMember="F.2Dochód" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="P_33" runat="server" DataMember="F.2Zaliczka" XSDType="TKwotaC"/>
		
        <ea:XmlDataLabel ElementName="P_34" runat="server" DataMember="F.3Przychód" XSDType="TKwota2"/>		
        <ea:XmlDataLabel ElementName="P_35" runat="server" DataMember="F.3Dochód" XSDType="TKwota2"/>		
        <ea:XmlDataLabel ElementName="P_36" runat="server" DataMember="F.3Zaliczka" XSDType="TKwotaC"/>		
		
        <ea:XmlDataLabel ElementName="P_37" runat="server" DataMember="F.4Przychód" XSDType="TKwota2"/>		
        <ea:XmlDataLabel ElementName="P_38" runat="server" DataMember="F.4Dochód" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="P_39" runat="server" DataMember="F.4Zaliczka" XSDType="TKwotaC"/>
		
        <ea:XmlDataLabel ElementName="P_40" runat="server" DataMember="F.5Przychód" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="P_41" runat="server" DataMember="F.5Koszty" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="P_42" runat="server" DataMember="F.5Dochód" XSDType="TKwota2"/>		
        <ea:XmlDataLabel ElementName="P_43" runat="server" DataMember="F.5Zaliczka" XSDType="TKwotaC"/>
		
        <ea:XmlDataLabel ElementName="P_44" runat="server" DataMember="F.6Przychód" XSDType="TKwota2"/>		
        <ea:XmlDataLabel ElementName="P_45" runat="server" DataMember="F.6Dochód" XSDType="TKwota2"/>		
        <ea:XmlDataLabel ElementName="P_46" runat="server" DataMember="F.6Zaliczka" XSDType="TKwotaC"/>		
        <ea:XmlDataLabel ElementName="P_47" runat="server" DataMember="F.6bPrzychód" XSDType="TKwota2"/>		
        <ea:XmlDataLabel ElementName="P_48" runat="server" DataMember="F.6Koszty" XSDType="TKwota2"/>
		
        <ea:XmlDataLabel ElementName="P_49" runat="server" DataMember="F.7Przychód" XSDType="TKwota2"/>		
        <ea:XmlDataLabel ElementName="P_50" runat="server" DataMember="F.7Koszty" XSDType="TKwota2"/>		
        <ea:XmlDataLabel ElementName="P_51" runat="server" DataMember="F.7Dochód" XSDType="TKwota2"/>		
        <ea:XmlDataLabel ElementName="P_52" runat="server" DataMember="F.7Zaliczka" XSDType="TKwotaC"/>
		
        <ea:XmlDataLabel ElementName="P_53" runat="server" DataMember="F.Przychód" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="P_54" runat="server" DataMember="F.Koszty" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="P_55" runat="server" DataMember="F.Dochód" XSDType="TKwota2"/>		
        <ea:XmlDataLabel ElementName="P_56" runat="server" DataMember="F.Zaliczka" XSDType="TKwotaC"/>
		
        <ea:XmlDataLabel ElementName="P_57" runat="server" DataMember="G.ZUS" XSDType="TKwota2"/>		
        <ea:XmlDataLabel ElementName="P_58" runat="server" DataMember="G.ZUSZagr" XSDType="TKwota2" HideEmptyOrZero="true"/>				
        <ea:XmlDataLabel ElementName="P_59" runat="server" DataMember="G.ZwrotŚwiadczeń" XSDType="TKwota2" HideEmptyOrZero="true"/>	

		<ea:Section ID="G_InneKwota" runat="server">
        <ea:XmlDataLabel ElementName="P_60" runat="server" DataMember="G.InneOpis" XSDType="TTekstowy"/>
        <ea:XmlDataLabel ElementName="P_61" runat="server" DataMember="G.InneKwota" XSDType="TKwota2"/>
        </ea:Section>

        <ea:XmlDataLabel ElementName="P_62" runat="server" DataMember="H1.Podstawa" XSDType="TKwotaC"/>
        <ea:XmlDataLabel ElementName="P_63" runat="server" DataMember="H1.Obliczony" XSDType="TKwota2"/>		
        <ea:XmlDataLabel ElementName="P_64" runat="server" DataMember="H1.Doliczenie" XSDType="TKwota2" HideEmptyOrZero="true"/>		
        <ea:XmlDataLabel ElementName="P_65" runat="server" DataMember="H1.Podatek" XSDType="TKwota2"/>		
				
        <ea:XmlDataLabel ElementName="P_66" runat="server" DataMember="H2.Zdrowotne" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="P_67" runat="server" DataMember="H2.ZdrowotneZagr" XSDType="TKwota2" HideEmptyOrZero="true"/>
        <ea:XmlDataLabel ElementName="P_68" runat="server" DataMember="H2.DoOdliczenia" XSDType="TKwota2"/>

        <ea:Section ID="H2_InneKwota" runat="server">
        <ea:XmlDataLabel ElementName="P_69" runat="server" DataMember="H2.InneOpis" XSDType="TTekstowy"/>
        <ea:XmlDataLabel ElementName="P_70" runat="server" DataMember="H2.InneKwota" XSDType="TKwota2"/>
        </ea:Section>
        		
        <ea:XmlDataLabel ElementName="P_71" runat="server" DataMember="H3.Należny" XSDType="TKwotaC"/>
        <ea:XmlDataLabel ElementName="P_72" ID="H3_DoZapłaty" runat="server" DataMember="H3.DoZapłaty" XSDType="TKwotaC"/>
        <ea:XmlDataLabel ElementName="P_73" ID="H3_Nadpłata" runat="server" DataMember="H3.Nadpłata" XSDType="TKwotaC"/>		
    </PozycjeSzczegolowe>
    <Pouczenie>Za uchybienie obowiązkom płatnika grozi odpowiedzialność przewidziana w Kodeksie karnym skarbowym.</Pouczenie>
    <Zalaczniki>
    <ea:DataRepeater ID="PIT_R_16" runat="server" WithSections="False" OnBeforeRow="PIT_R_16_BeforeRow">
    <zr:Zalacznik_PIT-R 
        xmlns:zr="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2013/09/18/eD/PITR/" 
        xmlns:etd="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2011/06/21/eD/DefinicjeTypy/" 
        xmlns:xsd="http://www.w3.org/2001/XMLSchema">
    <zr:Naglowek>
        <zr:KodFormularza kodSystemowy="PIT-R (16)" wersjaSchemy="1-0E">PIT-R</zr:KodFormularza>
        <zr:WariantFormularza>16</zr:WariantFormularza>
    </zr:Naglowek>
    <zr:PozycjeSzczegolowe>
        <ea:XmlDataLabel ElementName="zr:P_12" runat="server" DataMember="D.01_b" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="zr:P_13" runat="server" DataMember="D.01_c" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="zr:P_14" runat="server" DataMember="D.01_d" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="zr:P_15" runat="server" DataMember="D.01_e" XSDType="TKwota2"/>		

        <ea:XmlDataLabel ElementName="zr:P_16" runat="server" DataMember="D.02_b" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="zr:P_17" runat="server" DataMember="D.02_c" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="zr:P_18" runat="server" DataMember="D.02_d" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="zr:P_19" runat="server" DataMember="D.02_e" XSDType="TKwota2"/>		

        <ea:XmlDataLabel ElementName="zr:P_20" runat="server" DataMember="D.03_b" XSDType="TKwota2"/>		
        <ea:XmlDataLabel ElementName="zr:P_21" runat="server" DataMember="D.03_c" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="zr:P_22" runat="server" DataMember="D.03_d" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="zr:P_23" runat="server" DataMember="D.03_e" XSDType="TKwota2"/>		

        <ea:XmlDataLabel ElementName="zr:P_24" runat="server" DataMember="D.04_b" XSDType="TKwota2"/>		
        <ea:XmlDataLabel ElementName="zr:P_25" runat="server" DataMember="D.04_c" XSDType="TKwota2"/>		
        <ea:XmlDataLabel ElementName="zr:P_26" runat="server" DataMember="D.04_d" XSDType="TKwota2"/>		
        <ea:XmlDataLabel ElementName="zr:P_27" runat="server" DataMember="D.04_e" XSDType="TKwota2"/>				

        <ea:XmlDataLabel ElementName="zr:P_28" runat="server" DataMember="D.05_b" XSDType="TKwota2"/>		
        <ea:XmlDataLabel ElementName="zr:P_29" runat="server" DataMember="D.05_c" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="zr:P_30" runat="server" DataMember="D.05_d" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="zr:P_31" runat="server" DataMember="D.05_e" XSDType="TKwota2"/>		

        <ea:XmlDataLabel ElementName="zr:P_32" runat="server" DataMember="D.06_b" XSDType="TKwota2"/>		
        <ea:XmlDataLabel ElementName="zr:P_33" runat="server" DataMember="D.06_c" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="zr:P_34" runat="server" DataMember="D.06_d" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="zr:P_35" runat="server" DataMember="D.06_e" XSDType="TKwota2"/>		

        <ea:XmlDataLabel ElementName="zr:P_36" runat="server" DataMember="D.07_b" XSDType="TKwota2"/>		
        <ea:XmlDataLabel ElementName="zr:P_37" runat="server" DataMember="D.07_c" XSDType="TKwota2"/>		
        <ea:XmlDataLabel ElementName="zr:P_38" runat="server" DataMember="D.07_d" XSDType="TKwota2"/>		
        <ea:XmlDataLabel ElementName="zr:P_39" runat="server" DataMember="D.07_e" XSDType="TKwota2"/>				

        <ea:XmlDataLabel ElementName="zr:P_40" runat="server" DataMember="D.08_b" XSDType="TKwota2"/>		
        <ea:XmlDataLabel ElementName="zr:P_41" runat="server" DataMember="D.08_c" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="zr:P_42" runat="server" DataMember="D.08_d" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="zr:P_43" runat="server" DataMember="D.08_e" XSDType="TKwota2"/>		

        <ea:XmlDataLabel ElementName="zr:P_44" runat="server" DataMember="D.09_b" XSDType="TKwota2"/>		
        <ea:XmlDataLabel ElementName="zr:P_45" runat="server" DataMember="D.09_c" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="zr:P_46" runat="server" DataMember="D.09_d" XSDType="TKwota2"/>		
        <ea:XmlDataLabel ElementName="zr:P_47" runat="server" DataMember="D.09_e" XSDType="TKwota2"/>		

        <ea:XmlDataLabel ElementName="zr:P_48" runat="server" DataMember="D.10_b" XSDType="TKwota2"/>		
        <ea:XmlDataLabel ElementName="zr:P_49" runat="server" DataMember="D.10_c" XSDType="TKwota2"/>		
        <ea:XmlDataLabel ElementName="zr:P_50" runat="server" DataMember="D.10_d" XSDType="TKwota2"/>		
        <ea:XmlDataLabel ElementName="zr:P_51" runat="server" DataMember="D.10_e" XSDType="TKwota2"/>				

        <ea:XmlDataLabel ElementName="zr:P_52" runat="server" DataMember="D.11_b" XSDType="TKwota2"/>		
        <ea:XmlDataLabel ElementName="zr:P_53" runat="server" DataMember="D.11_c" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="zr:P_54" runat="server" DataMember="D.11_d" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="zr:P_55" runat="server" DataMember="D.11_e" XSDType="TKwota2"/>		

        <ea:XmlDataLabel ElementName="zr:P_56" runat="server" DataMember="D.12_b" XSDType="TKwota2"/>		
        <ea:XmlDataLabel ElementName="zr:P_57" runat="server" DataMember="D.12_c" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="zr:P_58" runat="server" DataMember="D.12_d" XSDType="TKwota2"/>		
        <ea:XmlDataLabel ElementName="zr:P_59" runat="server" DataMember="D.12_e" XSDType="TKwota2"/>		

        <ea:XmlDataLabel ElementName="zr:P_60" runat="server" DataMember="D.razem_e" XSDType="TKwota2"/>
    </zr:PozycjeSzczegolowe>
    </zr:Zalacznik_PIT-R>
    </ea:DataRepeater>
    <ea:Section ID="ORD_ZU" runat="server">
    <zzu:Zalacznik_ORD-ZU 
        xsi:schemaLocation="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2011/06/21/eD/DefinicjeTypy/ http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2011/06/21/eD/DefinicjeTypy/StrukturyDanych_v3-0E.xsd" 
        xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" 
        xmlns:etd="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2011/06/21/eD/DefinicjeTypy/"
        xmlns:zzu="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2011/10/07/eD/ORDZU/" >
        <zzu:Naglowek>
            <zzu:KodFormularza kodSystemowy="ORD-ZU (2)" wersjaSchemy="2-0E">ORD-ZU</zzu:KodFormularza>
            <zzu:WariantFormularza>2</zzu:WariantFormularza>
        </zzu:Naglowek>
        <zzu:PozycjeSzczegolowe>
            <ea:XmlDataLabel ElementName="zzu:P_13" runat="server" DataMember="TreśćUzasadnienia" XSDType="TTekstowy"/>
        </zzu:PozycjeSzczegolowe>
    </zzu:Zalacznik_ORD-ZU>
    </ea:Section>
    </Zalaczniki>
</Deklaracja>
