﻿<%@ Page Language="C#" AutoEventWireup="false" CodePage="1200" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Deklaracje" %>
<script runat="server">
    Soneta.Deklaracje.PIT.PIT8AR_3 dek;

    void OnContextLoad(Object sender, EventArgs args) {
        dek = (Soneta.Deklaracje.PIT.PIT8AR_3)dc[typeof(Soneta.Deklaracje.PIT.PIT8AR_3)];

        bool osobaFizyczna = (bool)dek.Bloki["B1"]["OsobaFiz"];
        string[] nazwa = Soneta.Deklaracje.PIT.PIT.DaneFirmy((string)dek.Bloki["B1"]["Nazwa"], osobaFizyczna);
        
        if (osobaFizyczna) {
            OsobaNieFizyczna.Visible = false;
            if (nazwa.Length > 0)
                Nazwisko.EditValue = nazwa[0].Trim();
            if (nazwa.Length > 1)
                ImiePierwsze.EditValue = nazwa[1].Trim();
            if (nazwa.Length > 2)
                DataUrodzenia.EditValue = nazwa[2].Trim();
        }
        else {
            OsobaFizyczna.Visible = false;
            if (nazwa.Length > 0)
                NazwaPelna.EditValue = nazwa[0].Trim();
            if (nazwa.Length > 1)
                REGON.EditValue = nazwa[1].Trim();
        }
        
        ORD_ZU.Visible = dek.TreśćUzasadnienia != "";
    }
	
</script>
<ea:datacontext id="dc" runat="server" TypeName="Soneta.Deklaracje.PIT.PIT8AR_3,Soneta.Deklaracje" OnContextLoad="OnContextLoad"></ea:datacontext>
<?xml version="1.0" encoding="UTF-8"?>
<Deklaracja 
    xsi:schemaLocation="http://crd.gov.pl/wzor/2013/10/10/1320/ http://crd.gov.pl/wzor/2013/10/10/1320/schemat.xsd" 
    xmlns="http://crd.gov.pl/wzor/2013/10/10/1320/" 
    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" 
    xmlns:etd="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2011/06/21/eD/DefinicjeTypy/">
    <Naglowek>
        <KodFormularza kodSystemowy="PT-8AR (3)" kodPodatku="PPR" rodzajZobowiazania="P" wersjaSchemy="1-0E">PIT-8AR</KodFormularza>
        <WariantFormularza>3</WariantFormularza>		
        <CelZlozenia poz="P_6"><ea:XmlDataLabel runat="server" DataMember="A.Korekta"><ValuesMap><ea:ValuesPair Key="False" Value="1" /><ea:ValuesPair Key="True" Value="2"/></ValuesMap></ea:XmlDataLabel></CelZlozenia>
        <ea:XmlDataLabel ElementName="Rok" runat="server" DataMember="0.Rok" />
        <ea:XmlDataLabel ElementName="KodUrzedu" runat="server" DataMember="X.KodUrzeduSkarbowego" />
    </Naglowek>
    <Podmiot1 rola="Płatnik">
        <ea:Section ID="OsobaFizyczna" runat="server"><etd:OsobaFizyczna>
            <ea:XmlDataLabel ElementName="etd:NIP" runat="server" DataMember="0.Nip" XSDType="TNrNIP"/>
            <ea:XmlDataLabel ElementName="etd:ImiePierwsze" ID="ImiePierwsze" runat="server" XSDType="TImie"></ea:XmlDataLabel>
            <ea:XmlDataLabel ElementName="etd:Nazwisko" ID="Nazwisko" runat="server" XSDType="TNazwisko"></ea:XmlDataLabel>
            <ea:XmlDataLabel ElementName="etd:DataUrodzenia" ID="DataUrodzenia" runat="server" XSDType="TData"></ea:XmlDataLabel>
        </etd:OsobaFizyczna></ea:Section>
        <ea:Section ID="OsobaNieFizyczna" runat="server"><etd:OsobaNiefizyczna>
            <ea:XmlDataLabel ElementName="etd:NIP" runat="server" DataMember="0.Nip" XSDType="TNrNIP"/>
            <ea:XmlDataLabel ElementName="etd:PelnaNazwa" ID="NazwaPelna" runat="server" XSDType="TZnakowy" />
            <ea:XmlDataLabel ElementName="etd:REGON" ID="REGON" runat="server" XSDType="TNrREGON" />
        </etd:OsobaNiefizyczna></ea:Section>
    </Podmiot1>	
	<PozycjeSzczegolowe>
		<ea:XmlDataLabel ElementName="P_9" runat="server" DataMember="C1.1Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_10" runat="server" DataMember="C1.2Podatek" XSDType="TKwotaC"/>	
		<ea:XmlDataLabel ElementName="P_11" runat="server" DataMember="C1.3Podatek" XSDType="TKwotaC"/>	
		<ea:XmlDataLabel ElementName="P_12" runat="server" DataMember="C1.4Podatek" XSDType="TKwotaC"/>	
		<ea:XmlDataLabel ElementName="P_13" runat="server" DataMember="C1.5Podatek" XSDType="TKwotaC"/>	
		<ea:XmlDataLabel ElementName="P_14" runat="server" DataMember="C1.6Podatek" XSDType="TKwotaC"/>	
		<ea:XmlDataLabel ElementName="P_15" runat="server" DataMember="C1.7Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_16" runat="server" DataMember="C1.8Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_17" runat="server" DataMember="C1.9Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_18" runat="server" DataMember="C1.10Podatek" XSDType="TKwotaC"/>		
		<ea:XmlDataLabel ElementName="P_19" runat="server" DataMember="C1.11Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_20" runat="server" DataMember="C1.12Podatek" XSDType="TKwotaC"/>

		<ea:XmlDataLabel ElementName="P_21" runat="server" DataMember="C2.1Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_22" runat="server" DataMember="C2.2Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_23" runat="server" DataMember="C2.3Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_24" runat="server" DataMember="C2.4Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_25" runat="server" DataMember="C2.5Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_26" runat="server" DataMember="C2.6Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_27" runat="server" DataMember="C2.7Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_28" runat="server" DataMember="C2.8Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_29" runat="server" DataMember="C2.9Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_30" runat="server" DataMember="C2.10Podatek" XSDType="TKwotaC"/>	
		<ea:XmlDataLabel ElementName="P_31" runat="server" DataMember="C2.11Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_32" runat="server" DataMember="C2.12Podatek" XSDType="TKwotaC"/>

		<ea:XmlDataLabel ElementName="P_33" runat="server" DataMember="C3.1Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_34" runat="server" DataMember="C3.2Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_35" runat="server" DataMember="C3.3Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_36" runat="server" DataMember="C3.4Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_37" runat="server" DataMember="C3.5Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_38" runat="server" DataMember="C3.6Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_39" runat="server" DataMember="C3.7Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_40" runat="server" DataMember="C3.8Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_41" runat="server" DataMember="C3.9Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_42" runat="server" DataMember="C3.10Podatek" XSDType="TKwotaC"/>	
		<ea:XmlDataLabel ElementName="P_43" runat="server" DataMember="C3.11Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_44" runat="server" DataMember="C3.12Podatek" XSDType="TKwotaC"/>
		
		<ea:XmlDataLabel ElementName="P_45" runat="server" DataMember="C4.1Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_46" runat="server" DataMember="C4.2Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_47" runat="server" DataMember="C4.3Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_48" runat="server" DataMember="C4.4Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_49" runat="server" DataMember="C4.5Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_50" runat="server" DataMember="C4.6Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_51" runat="server" DataMember="C4.7Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_52" runat="server" DataMember="C4.8Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_53" runat="server" DataMember="C4.9Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_54" runat="server" DataMember="C4.10Podatek" XSDType="TKwotaC"/>	
		<ea:XmlDataLabel ElementName="P_55" runat="server" DataMember="C4.11Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_56" runat="server" DataMember="C4.12Podatek" XSDType="TKwotaC"/>
		
		<ea:XmlDataLabel ElementName="P_57" runat="server" DataMember="C5.1Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_58" runat="server" DataMember="C5.2Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_59" runat="server" DataMember="C5.3Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_60" runat="server" DataMember="C5.4Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_61" runat="server" DataMember="C5.5Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_62" runat="server" DataMember="C5.6Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_63" runat="server" DataMember="C5.7Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_64" runat="server" DataMember="C5.8Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_65" runat="server" DataMember="C5.9Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_66" runat="server" DataMember="C5.10Podatek" XSDType="TKwotaC"/>	
		<ea:XmlDataLabel ElementName="P_67" runat="server" DataMember="C5.11Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_68" runat="server" DataMember="C5.12Podatek" XSDType="TKwotaC"/>
		
		<ea:XmlDataLabel ElementName="P_69" runat="server" DataMember="C6.1Podatek" XSDType="TKwota2"/>
		<ea:XmlDataLabel ElementName="P_70" runat="server" DataMember="C6.2Podatek" XSDType="TKwota2"/>
		<ea:XmlDataLabel ElementName="P_71" runat="server" DataMember="C6.3Podatek" XSDType="TKwota2"/>
		<ea:XmlDataLabel ElementName="P_72" runat="server" DataMember="C6.4Podatek" XSDType="TKwota2"/>
		<ea:XmlDataLabel ElementName="P_73" runat="server" DataMember="C6.5Podatek" XSDType="TKwota2"/>
		<ea:XmlDataLabel ElementName="P_74" runat="server" DataMember="C6.6Podatek" XSDType="TKwota2"/>
		<ea:XmlDataLabel ElementName="P_75" runat="server" DataMember="C6.7Podatek" XSDType="TKwota2"/>
		<ea:XmlDataLabel ElementName="P_76" runat="server" DataMember="C6.8Podatek" XSDType="TKwota2"/>
		<ea:XmlDataLabel ElementName="P_77" runat="server" DataMember="C6.9Podatek" XSDType="TKwota2"/>
		<ea:XmlDataLabel ElementName="P_78" runat="server" DataMember="C6.10Podatek" XSDType="TKwota2"/>	
		<ea:XmlDataLabel ElementName="P_79" runat="server" DataMember="C6.11Podatek" XSDType="TKwota2"/>
		<ea:XmlDataLabel ElementName="P_80" runat="server" DataMember="C6.12Podatek" XSDType="TKwota2"/>
		
		<ea:XmlDataLabel ElementName="P_81" runat="server" DataMember="C7.1Podatek" XSDType="TKwota2"/>
		<ea:XmlDataLabel ElementName="P_82" runat="server" DataMember="C7.2Podatek" XSDType="TKwota2"/>	
		<ea:XmlDataLabel ElementName="P_83" runat="server" DataMember="C7.3Podatek" XSDType="TKwota2"/>	
		<ea:XmlDataLabel ElementName="P_84" runat="server" DataMember="C7.4Podatek" XSDType="TKwota2"/>			
		<ea:XmlDataLabel ElementName="P_85" runat="server" DataMember="C7.5Podatek" XSDType="TKwota2"/>
		<ea:XmlDataLabel ElementName="P_86" runat="server" DataMember="C7.6Podatek" XSDType="TKwota2"/>	
		<ea:XmlDataLabel ElementName="P_87" runat="server" DataMember="C7.7Podatek" XSDType="TKwota2"/>	
		<ea:XmlDataLabel ElementName="P_88" runat="server" DataMember="C7.8Podatek" XSDType="TKwota2"/>	
		<ea:XmlDataLabel ElementName="P_89" runat="server" DataMember="C7.9Podatek" XSDType="TKwota2"/>	
		<ea:XmlDataLabel ElementName="P_90" runat="server" DataMember="C7.10Podatek" XSDType="TKwota2"/>	
		<ea:XmlDataLabel ElementName="P_91" runat="server" DataMember="C7.11Podatek" XSDType="TKwota2"/>
		<ea:XmlDataLabel ElementName="P_92" runat="server" DataMember="C7.12Podatek" XSDType="TKwota2"/>

		<ea:XmlDataLabel ElementName="P_93" runat="server" DataMember="C8.1Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_94" runat="server" DataMember="C8.2Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_95" runat="server" DataMember="C8.3Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_96" runat="server" DataMember="C8.4Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_97" runat="server" DataMember="C8.5Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_98" runat="server" DataMember="C8.6Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_99" runat="server" DataMember="C8.7Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_100" runat="server" DataMember="C8.8Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_101" runat="server" DataMember="C8.9Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_102" runat="server" DataMember="C8.10Podatek" XSDType="TKwotaC"/>	
		<ea:XmlDataLabel ElementName="P_103" runat="server" DataMember="C8.11Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_104" runat="server" DataMember="C8.12Podatek" XSDType="TKwotaC"/>
		
		<ea:XmlDataLabel ElementName="P_105" runat="server" DataMember="C9.1Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_106" runat="server" DataMember="C9.2Podatek" XSDType="TKwotaC"/>		
		<ea:XmlDataLabel ElementName="P_107" runat="server" DataMember="C9.3Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_108" runat="server" DataMember="C9.4Podatek" XSDType="TKwotaC"/>		
		<ea:XmlDataLabel ElementName="P_109" runat="server" DataMember="C9.5Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_110" runat="server" DataMember="C9.6Podatek" XSDType="TKwotaC"/>		
		<ea:XmlDataLabel ElementName="P_111" runat="server" DataMember="C9.7Podatek" XSDType="TKwotaC"/>		
		<ea:XmlDataLabel ElementName="P_112" runat="server" DataMember="C9.8Podatek" XSDType="TKwotaC"/>		
		<ea:XmlDataLabel ElementName="P_113" runat="server" DataMember="C9.9Podatek" XSDType="TKwotaC"/>		
		<ea:XmlDataLabel ElementName="P_114" runat="server" DataMember="C9.10Podatek" XSDType="TKwotaC"/>	
		<ea:XmlDataLabel ElementName="P_115" runat="server" DataMember="C9.11Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_116" runat="server" DataMember="C9.12Podatek" XSDType="TKwotaC"/>
		
		<ea:XmlDataLabel ElementName="P_117" runat="server" DataMember="C10.1Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_118" runat="server" DataMember="C10.2Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_119" runat="server" DataMember="C10.3Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_120" runat="server" DataMember="C10.4Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_121" runat="server" DataMember="C10.5Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_122" runat="server" DataMember="C10.6Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_123" runat="server" DataMember="C10.7Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_124" runat="server" DataMember="C10.8Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_125" runat="server" DataMember="C10.9Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_126" runat="server" DataMember="C10.10Podatek" XSDType="TKwotaC"/>	
		<ea:XmlDataLabel ElementName="P_127" runat="server" DataMember="C10.11Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_128" runat="server" DataMember="C10.12Podatek" XSDType="TKwotaC"/>
		
		<ea:XmlDataLabel ElementName="P_129" runat="server" DataMember="C11.1Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_130" runat="server" DataMember="C11.2Podatek" XSDType="TKwotaC"/>	
		<ea:XmlDataLabel ElementName="P_131" runat="server" DataMember="C11.3Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_132" runat="server" DataMember="C11.4Podatek" XSDType="TKwotaC"/>	
		<ea:XmlDataLabel ElementName="P_133" runat="server" DataMember="C11.5Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_134" runat="server" DataMember="C11.6Podatek" XSDType="TKwotaC"/>	
		<ea:XmlDataLabel ElementName="P_135" runat="server" DataMember="C11.7Podatek" XSDType="TKwotaC"/>	
		<ea:XmlDataLabel ElementName="P_136" runat="server" DataMember="C11.8Podatek" XSDType="TKwotaC"/>	
		<ea:XmlDataLabel ElementName="P_137" runat="server" DataMember="C11.9Podatek" XSDType="TKwotaC"/>	
		<ea:XmlDataLabel ElementName="P_138" runat="server" DataMember="C11.10Podatek" XSDType="TKwotaC"/>	
		<ea:XmlDataLabel ElementName="P_139" runat="server" DataMember="C11.11Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_140" runat="server" DataMember="C11.12Podatek" XSDType="TKwotaC"/>
		
		<ea:XmlDataLabel ElementName="P_141" runat="server" DataMember="C12.1Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_142" runat="server" DataMember="C12.2Podatek" XSDType="TKwotaC"/>	
		<ea:XmlDataLabel ElementName="P_143" runat="server" DataMember="C12.3Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_144" runat="server" DataMember="C12.4Podatek" XSDType="TKwotaC"/>	
		<ea:XmlDataLabel ElementName="P_145" runat="server" DataMember="C12.5Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_146" runat="server" DataMember="C12.6Podatek" XSDType="TKwotaC"/>	
		<ea:XmlDataLabel ElementName="P_147" runat="server" DataMember="C12.7Podatek" XSDType="TKwotaC"/>	
		<ea:XmlDataLabel ElementName="P_148" runat="server" DataMember="C12.8Podatek" XSDType="TKwotaC"/>	
		<ea:XmlDataLabel ElementName="P_149" runat="server" DataMember="C12.9Podatek" XSDType="TKwotaC"/>	
		<ea:XmlDataLabel ElementName="P_150" runat="server" DataMember="C12.10Podatek" XSDType="TKwotaC"/>	
		<ea:XmlDataLabel ElementName="P_151" runat="server" DataMember="C12.11Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_152" runat="server" DataMember="C12.12Podatek" XSDType="TKwotaC"/>
		
		<ea:XmlDataLabel ElementName="P_153" runat="server" DataMember="C13.1Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_154" runat="server" DataMember="C13.2Podatek" XSDType="TKwotaC"/>		
		<ea:XmlDataLabel ElementName="P_155" runat="server" DataMember="C13.3Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_156" runat="server" DataMember="C13.4Podatek" XSDType="TKwotaC"/>		
		<ea:XmlDataLabel ElementName="P_157" runat="server" DataMember="C13.5Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_158" runat="server" DataMember="C13.6Podatek" XSDType="TKwotaC"/>		
		<ea:XmlDataLabel ElementName="P_159" runat="server" DataMember="C13.7Podatek" XSDType="TKwotaC"/>		
		<ea:XmlDataLabel ElementName="P_160" runat="server" DataMember="C13.8Podatek" XSDType="TKwotaC"/>		
		<ea:XmlDataLabel ElementName="P_161" runat="server" DataMember="C13.9Podatek" XSDType="TKwotaC"/>		
		<ea:XmlDataLabel ElementName="P_162" runat="server" DataMember="C13.10Podatek" XSDType="TKwotaC"/>		
		<ea:XmlDataLabel ElementName="P_163" runat="server" DataMember="C13.11Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_164" runat="server" DataMember="C13.12Podatek" XSDType="TKwotaC"/>

		<ea:XmlDataLabel ElementName="P_165" runat="server" DataMember="C14.1Podatek" XSDType="TKwota2"/>
		<ea:XmlDataLabel ElementName="P_166" runat="server" DataMember="C14.2Podatek" XSDType="TKwota2"/>	
		<ea:XmlDataLabel ElementName="P_167" runat="server" DataMember="C14.3Podatek" XSDType="TKwota2"/>
		<ea:XmlDataLabel ElementName="P_168" runat="server" DataMember="C14.4Podatek" XSDType="TKwota2"/>
		<ea:XmlDataLabel ElementName="P_169" runat="server" DataMember="C14.5Podatek" XSDType="TKwota2"/>
		<ea:XmlDataLabel ElementName="P_170" runat="server" DataMember="C14.6Podatek" XSDType="TKwota2"/>	
		<ea:XmlDataLabel ElementName="P_171" runat="server" DataMember="C14.7Podatek" XSDType="TKwota2"/>
		<ea:XmlDataLabel ElementName="P_172" runat="server" DataMember="C14.8Podatek" XSDType="TKwota2"/>
		<ea:XmlDataLabel ElementName="P_173" runat="server" DataMember="C14.9Podatek" XSDType="TKwota2"/>
		<ea:XmlDataLabel ElementName="P_174" runat="server" DataMember="C14.10Podatek" XSDType="TKwota2"/>
		<ea:XmlDataLabel ElementName="P_175" runat="server" DataMember="C14.11Podatek" XSDType="TKwota2"/>
		<ea:XmlDataLabel ElementName="P_176" runat="server" DataMember="C14.12Podatek" XSDType="TKwota2"/>
		
		<ea:XmlDataLabel ElementName="P_177" runat="server" DataMember="C15.1Wynagrodzenie" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_178" runat="server" DataMember="C15.2Wynagrodzenie" XSDType="TKwotaC"/>	
		<ea:XmlDataLabel ElementName="P_179" runat="server" DataMember="C15.3Wynagrodzenie" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_180" runat="server" DataMember="C15.4Wynagrodzenie" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_181" runat="server" DataMember="C15.5Wynagrodzenie" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_182" runat="server" DataMember="C15.6Wynagrodzenie" XSDType="TKwotaC"/>	
		<ea:XmlDataLabel ElementName="P_183" runat="server" DataMember="C15.7Wynagrodzenie" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_184" runat="server" DataMember="C15.8Wynagrodzenie" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_185" runat="server" DataMember="C15.9Wynagrodzenie" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_186" runat="server" DataMember="C15.10Wynagrodzenie" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_187" runat="server" DataMember="C15.11Wynagrodzenie" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_188" runat="server" DataMember="C15.12Wynagrodzenie" XSDType="TKwotaC"/>
		
		<ea:XmlDataLabel ElementName="P_189" runat="server" DataMember="C16.1DoWpłaty" XSDType="TKwota2"/>
		<ea:XmlDataLabel ElementName="P_190" runat="server" DataMember="C16.2DoWpłaty" XSDType="TKwota2"/>	
		<ea:XmlDataLabel ElementName="P_191" runat="server" DataMember="C16.3DoWpłaty" XSDType="TKwota2"/>
		<ea:XmlDataLabel ElementName="P_192" runat="server" DataMember="C16.4DoWpłaty" XSDType="TKwota2"/>
		<ea:XmlDataLabel ElementName="P_193" runat="server" DataMember="C16.5DoWpłaty" XSDType="TKwota2"/>
		<ea:XmlDataLabel ElementName="P_194" runat="server" DataMember="C16.6DoWpłaty" XSDType="TKwota2"/>	
		<ea:XmlDataLabel ElementName="P_195" runat="server" DataMember="C16.7DoWpłaty" XSDType="TKwota2"/>
		<ea:XmlDataLabel ElementName="P_196" runat="server" DataMember="C16.8DoWpłaty" XSDType="TKwota2"/>
		<ea:XmlDataLabel ElementName="P_197" runat="server" DataMember="C16.9DoWpłaty" XSDType="TKwota2"/>
		<ea:XmlDataLabel ElementName="P_198" runat="server" DataMember="C16.10DoWpłaty" XSDType="TKwota2"/>
		<ea:XmlDataLabel ElementName="P_199" runat="server" DataMember="C16.11DoWpłaty" XSDType="TKwota2"/>
		<ea:XmlDataLabel ElementName="P_200" runat="server" DataMember="C16.12DoWpłaty" XSDType="TKwota2"/>
				
	</PozycjeSzczegolowe>
	<Pouczenie1>W przypadku niewpłacenia w obowiązującym terminie kwot z poz. od 189 do 200 lub wpłacenia ich w niepełnej wysokości niniejsza deklaracja stanowi podstawę do wystawienia tytułu wykonawczego, zgodnie z przepisami ustawy z dnia 17 czerwca 1966 r. o postępowaniu egzekucyjnym w administracji (Dz.  U. z 2012 r. poz. 1015, z późn. zm.).</Pouczenie1>
	<Pouczenie2>Za uchybienie obowiązkom płatnika grozi odpowiedzialność przewidziana w Kodeksie karnym skarbowym.</Pouczenie2>
	<Zalaczniki>
    <ea:Section ID="ORD_ZU" runat="server"><zzu:Zalacznik_ORD-ZU 
        xsi:schemaLocation="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2011/06/21/eD/DefinicjeTypy/StrukturyDanych_v3-0E.xsd" 
        xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" 
        xmlns:etd="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2011/06/21/eD/DefinicjeTypy/"
        xmlns:zzu="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2011/10/07/eD/ORDZU/" >
        <zzu:Naglowek>
            <zzu:KodFormularza kodSystemowy="ORD-ZU (2)" wersjaSchemy="2-0E">ORD-ZU</zzu:KodFormularza>
            <zzu:WariantFormularza>2</zzu:WariantFormularza>
        </zzu:Naglowek>
        <zzu:PozycjeSzczegolowe>
            <ea:XmlDataLabel ElementName="zzu:P_13" runat="server" DataMember="TreśćUzasadnienia" XSDType="TTekstowy"/>
        </zzu:PozycjeSzczegolowe>
    </zzu:Zalacznik_ORD-ZU></ea:Section>	
	</Zalaczniki>
</Deklaracja>
