﻿<%@ Page Language="C#" AutoEventWireup="false" CodePage="1200" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Deklaracje" %>
<%@ Import Namespace="Soneta.Deklaracje.PIT" %>
<%@ Import Namespace="System.Collections.Generic" %>
<script runat="server">
    Soneta.Deklaracje.PIT.PIT8C_3 dek;

    void OnContextLoad(Object sender, EventArgs args) {
        dek = (PIT8C_3)dc[typeof(PIT8C_3)];

        bool osobaFizyczna = (bool)dek.Bloki["B1"]["OsobaFiz"];
        string[] nazwa = Soneta.Deklaracje.PIT.PIT.DaneFirmy((string)dek.Bloki["B1"]["Nazwa"], osobaFizyczna);
        
        if (osobaFizyczna) {
            OsobaNieFizyczna.Visible = false;
            Nazwisko.EditValue = nazwa[0].Trim();
            ImiePiersze.EditValue = nazwa[1].Trim();
            DataUrodzenia.EditValue = nazwa[2].Trim();
            PESEL.EditValue = nazwa[3].Trim();
        }
        else {
            OsobaFizyczna.Visible = false;
            NazwaPelna.EditValue = nazwa[0].Trim();
            REGON.EditValue = nazwa[1].Trim();
        }

        string kodKraju = ((string)dek.Bloki["X"]["KodKraju"]).ToUpper();
        if (kodKraju == "" || kodKraju=="PL")
            AdresZagr.Visible = false;
        else
            AdresPol.Visible = false;


        ORD_ZU.Visible = dek.TreśćUzasadnienia != "";
        decimal strata = (decimal)dek.Bloki["E"]["Strata"];
        Plus.Visible = strata==0;
        Minus.Visible = strata != 0;
    }

    static void Msg(object value) {
    }

</script>
<ea:datacontext id="dc" runat="server" TypeName="Soneta.Deklaracje.PIT.PIT8C_3,Soneta.Deklaracje" OnContextLoad="OnContextLoad"></ea:datacontext>
<?xml version="1.0" encoding="UTF-8"?>
<Deklaracja xsi:noNamespaceSchemaLocation="http://www.e-deklaracje.mf.gov.pl/Repozytorium/Deklaracje/PIT/PIT-8C(3)_v1-0.xsd" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:usr="urn:the-xml-files:xslt" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
	<Naglowek>
        <KodFormularza kodSystemowy="PIT-8C (3)" kodPodatku="PIT" rodzajZobowiazania="Z">PIT-8C</KodFormularza>
        <WariantFormularza>3</WariantFormularza>		
        <CelZlozenia poz="P_6"><ea:XmlDataLabel ID="DataLabel1" runat="server" DataMember="A.Korekta"><ValuesMap><ea:ValuesPair Key="False" Value="1" /><ea:ValuesPair Key="True" Value="2"/></ValuesMap></ea:XmlDataLabel></CelZlozenia>
        <Rok><ea:XmlDataLabel ID="Rok" runat="server" DataMember="0.Rok"></ea:XmlDataLabel></Rok>
        <KodUrzedu><ea:XmlDataLabel ID="DataLabel4" runat="server" DataMember="X.KodUrzeduSkarbowego"></ea:XmlDataLabel></KodUrzedu>
	</Naglowek>
	<Podmiot1 rola="Płatnik">
		<ea:Section ID="OsobaFizyczna" runat="server"><OsobaFizyczna>
			<ea:XmlDataLabel ID="XmlDataLabel1" runat="server" ElementName="NIP" DataMember="0.Nip" XSDType="TNrNIP"></ea:XmlDataLabel>
			<ImiePierwsze><ea:XmlDataLabel ID="ImiePiersze" runat="server" XSDType="TImie"></ea:XmlDataLabel></ImiePierwsze>
			<Nazwisko><ea:XmlDataLabel ID="Nazwisko" runat="server" XSDType="TNazwisko"></ea:XmlDataLabel></Nazwisko>
			<DataUrodzenia><ea:XmlDataLabel ID="DataUrodzenia" runat="server" XSDType="TData"></ea:XmlDataLabel></DataUrodzenia>
            <ea:XmlDataLabel ID="PESEL" runat="server" ElementName="PESEL" HideEmptyOrZero="true"></ea:XmlDataLabel>
		</OsobaFizyczna></ea:Section>
		<ea:Section ID="OsobaNieFizyczna" runat="server"><OsobaNiefizyczna>
			<ea:XmlDataLabel ID="XmlDataLabel2" runat="server" ElementName="NIP" DataMember="0.Nip" XSDType="TNrNIP"></ea:XmlDataLabel>
			<PelnaNazwa><ea:XmlDataLabel ID="NazwaPelna" runat="server" XSDType="TZnakowy"></ea:XmlDataLabel></PelnaNazwa>
			<REGON><ea:XmlDataLabel ID="REGON" runat="server" XSDType="TNrREGON"></ea:XmlDataLabel></REGON>
		</OsobaNiefizyczna></ea:Section>
		<AdresZamieszkaniaSiedziby rodzajAdresu="RAD">
			<AdresPol>
				<KodKraju>PL</KodKraju>
				<Wojewodztwo><ea:XmlDataLabel ID="XmlDataLabel3" runat="server" DataMember="B2.Wojew" XSDType="TJednAdmin"></ea:XmlDataLabel></Wojewodztwo>
				<Powiat><ea:XmlDataLabel ID="XmlDataLabel4" runat="server" DataMember="B2.Powiat" XSDType="TJednAdmin"></ea:XmlDataLabel></Powiat>
				<Gmina><ea:XmlDataLabel ID="XmlDataLabel5" runat="server" DataMember="B2.Gmina" XSDType="TJednAdmin"></ea:XmlDataLabel></Gmina>
				<ea:XmlDataLabel ID="XmlDataLabel6" runat="server" ElementName="Ulica" HideEmptyOrZero="true" DataMember="B2.Ulica" XSDType="TUlica"></ea:XmlDataLabel>
				<NrDomu><ea:XmlDataLabel ID="XmlDataLabel7" runat="server" DataMember="B2.NrDomu" XSDType="TNrBudynku"></ea:XmlDataLabel></NrDomu>
				<ea:XmlDataLabel ID="XmlDataLabel8" runat="server" ElementName="NrLokalu" HideEmptyOrZero="true" DataMember="B2.NrLokalu" XSDType="TNrLokalu"></ea:XmlDataLabel>
				<Miejscowosc><ea:XmlDataLabel ID="XmlDataLabel9" runat="server" DataMember="B2.Miejsc" XSDType="TMiejscowosc"></ea:XmlDataLabel></Miejscowosc>
				<KodPocztowy><ea:XmlDataLabel ID="XmlDataLabel10" runat="server" DataMember="B2.KodPoczt" XSDType="TKodPocztowy"></ea:XmlDataLabel></KodPocztowy>
				<Poczta><ea:XmlDataLabel ID="XmlDataLabel11" runat="server" DataMember="B2.Poczta" XSDType="TMiejscowosc"></ea:XmlDataLabel></Poczta>
			</AdresPol>
		</AdresZamieszkaniaSiedziby>
	</Podmiot1>	
	<Podmiot2 rola="Podatnik">
	    <OsobaFizyczna>
	        <NIP><ea:XmlDataLabel ID="P20" runat="server" DataMember="C1.NIP" XSDType="TNrNIP"/></NIP>
    	    <ImiePierwsze><ea:XmlDataLabel ID="P22" runat="server" DataMember="C1.Imię" XSDType="TImie"/></ImiePierwsze>
	        <Nazwisko><ea:XmlDataLabel ID="P21" runat="server" DataMember="C1.Nazwisko" XSDType="TNazwisko"/></Nazwisko>
	        <DataUrodzenia><ea:XmlDataLabel ID="P23" runat="server" DataMember="C1.DataUrodz" XSDType="TData"/></DataUrodzenia>
	        <PESEL><ea:XmlDataLabel ID="P24" runat="server" DataMember="C1.PESEL" XSDType="TNrPESEL"/></PESEL>
	    </OsobaFizyczna>
        <AdresZamieszkania rodzajAdresu="RAD">
            <ea:Section ID="AdresPol" runat="server"><AdresPol>
                <KodKraju>PL</KodKraju>
                <Wojewodztwo><ea:XmlDataLabel ID="P25" runat="server" DataMember="C2.Wojew" XSDType="TJednAdmin"/></Wojewodztwo>
                <Powiat><ea:XmlDataLabel ID="P26" runat="server" DataMember="C2.Powiat" XSDType="TJednAdmin"/></Powiat>
                <Gmina><ea:XmlDataLabel ID="P27" runat="server" DataMember="C2.Gmina" XSDType="TJednAdmin"/></Gmina>
                <ea:XmlDataLabel ID="P28" runat="server" ElementName="Ulica" DataMember="C2.Ulica" XSDType="TUlica" HideEmptyOrZero="true"/>
                <NrDomu><ea:XmlDataLabel ID="P29" runat="server" DataMember="C2.NrDomu" XSDType="TNrBudynku"/></NrDomu>
                <ea:XmlDataLabel ID="P30" runat="server" ElementName="NrLokalu" DataMember="C2.NrLokalu" XSDType="TNrLokalu" HideEmptyOrZero="true"/>
                <Miejscowosc><ea:XmlDataLabel ID="P31" runat="server" DataMember="C2.Miejsc" XSDType="TMiejscowosc"/></Miejscowosc>
                <KodPocztowy><ea:XmlDataLabel ID="P32" runat="server" DataMember="C2.KodPoczt" XSDType="TKodPocztowy"/></KodPocztowy>
                <Poczta><ea:XmlDataLabel ID="P33" runat="server" DataMember="C2.Poczta" XSDType="TMiejscowosc"/></Poczta>
            </AdresPol></ea:Section><ea:Section ID="AdresZagr" runat="server"><AdresZagr>
                <KodKraju><ea:XmlDataLabel ID="P25z" runat="server" DataMember="X.KodKraju" XSDType="TTekstowy"/></KodKraju>
                <KodPocztowy><ea:XmlDataLabel ID="P32z" runat="server" DataMember="C2.KodPoczt" XSDType="TKodPocztowy"/></KodPocztowy>
                <Miejscowosc><ea:XmlDataLabel ID="P31z" runat="server" DataMember="C2.Miejsc" XSDType="TMiejscowosc"/></Miejscowosc>
                <ea:XmlDataLabel ID="P28z" runat="server" ElementName="Ulica" DataMember="C2.Ulica" XSDType="TUlica" HideEmptyOrZero="true"/>
                <NrDomu><ea:XmlDataLabel ID="P29z" runat="server" DataMember="C2.NrDomu" XSDType="TNrBudynku"/></NrDomu>
                <ea:XmlDataLabel ID="P30z" runat="server" ElementName="NrLokalu" DataMember="C2.NrLokalu" XSDType="TNrLokalu" HideEmptyOrZero="true"/>
            </AdresZagr></ea:Section>
        </AdresZamieszkania>
	</Podmiot2>
	<PozycjeSzczegolowe>
		<P_34><ea:XmlDataLabel ID="P34" runat="server" DataMember="D.1Opis" XSDType="TZnakowy"/> </P_34>
		<P_35><ea:XmlDataLabel ID="P35" runat="server" DataMember="D.1Przychód" XSDType="TKwota2"/></P_35>
		<P_36><ea:XmlDataLabel ID="P36" runat="server" DataMember="D.2Opis" XSDType="TZnakowy"/> </P_36>			
		<P_37><ea:XmlDataLabel ID="P37" runat="server" DataMember="D.2Przychód" XSDType="TKwota2"/></P_37>
		<P_38><ea:XmlDataLabel ID="P38" runat="server" DataMember="D.3Opis" XSDType="TZnakowy"/> </P_38>
		<P_39><ea:XmlDataLabel ID="P39" runat="server" DataMember="D.3Przychód" XSDType="TKwota2"/></P_39>		
		<P_40><ea:XmlDataLabel ID="P40" runat="server" DataMember="D.4Opis" XSDType="TZnakowy"/> </P_40>
		<P_41><ea:XmlDataLabel ID="P41" runat="server" DataMember="D.4Przychód" XSDType="TKwota2"/></P_41>				
		<P_42><ea:XmlDataLabel ID="P42" runat="server" DataMember="D.Przychód" XSDType="TKwota2"/></P_42>		
		
		<P_43><ea:XmlDataLabel ID="P43" runat="server" DataMember="E.1Przychód" XSDType="TKwota2"/></P_43>
		<P_44><ea:XmlDataLabel ID="P44" runat="server" DataMember="E.1Koszty" XSDType="TKwota2"/></P_44>
		<P_45><ea:XmlDataLabel ID="P45" runat="server" DataMember="E.2Przychód" XSDType="TKwota2"/></P_45>				
		<P_46><ea:XmlDataLabel ID="P46" runat="server" DataMember="E.2Koszty" XSDType="TKwota2"/></P_46>		
		<P_47><ea:XmlDataLabel ID="P47" runat="server" DataMember="E.3Przychód" XSDType="TKwota2"/></P_47>		
		<P_48><ea:XmlDataLabel ID="P48" runat="server" DataMember="E.3Koszty" XSDType="TKwota2"/></P_48>		
		<P_49><ea:XmlDataLabel ID="P49" runat="server" DataMember="E.4Przychód" XSDType="TKwota2"/></P_49>				
		<P_50><ea:XmlDataLabel ID="P50" runat="server" DataMember="E.4Koszty" XSDType="TKwota2"/></P_50>		
		<P_51><ea:XmlDataLabel ID="P51" runat="server" DataMember="E.5Przychód" XSDType="TKwota2"/></P_51>
		<P_52><ea:XmlDataLabel ID="P52" runat="server" DataMember="E.5Koszty" XSDType="TKwota2"/></P_52>		
		<P_53><ea:XmlDataLabel ID="P53" runat="server" DataMember="E.Przychód" XSDType="TKwota2"/></P_53>
		<P_54><ea:XmlDataLabel ID="P54" runat="server" DataMember="E.Koszty" XSDType="TKwota2"/></P_54>				
		<ea:Section ID="Plus" runat="server"><P_55><ea:XmlDataLabel ID="P55" runat="server" DataMember="E.Dochód" XSDType="TKwota2"/></P_55></ea:Section>
		<ea:Section ID="Minus" runat="server"><P_56><ea:XmlDataLabel ID="P56" runat="server" DataMember="E.Strata" XSDType="TKwota2"/></P_56></ea:Section>
		<P_57><ea:XmlDataLabel ID="P57" runat="server" DataMember="F.Przychód" XSDType="TKwota2"/></P_57>
	</PozycjeSzczegolowe>
	<Oswiadczenie>Oświadczam, że są mi znane przepisy Kodeksu karnego skarbowego o odpowiedzialności za podanie danych niezgodnie z rzeczywistością i przez to narażenie na uszczuplenie podatku.</Oswiadczenie>
	<Zalaczniki><ea:Section ID="ORD_ZU" runat="server">
    <Zalacznik_ORD-ZU xsi:noNamespaceSchemaLocation="http://e-deklaracje.mf.gov.pl/Repozytorium/Deklaracje/ZalacznikiOgolne/ORD-ZU(2)_v1-0.xsd" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:usr="urn:the-xml-files:xslt" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
	    <Naglowek>
            <KodFormularza kodSystemowy="ORD-ZU (2)">ORD-ZU</KodFormularza>
            <WariantFormularza>2</WariantFormularza>
	    </Naglowek>
	    <PozycjeSzczegolowe>
	        <P_13><ea:XmlDataLabel runat="server" DataMember="TreśćUzasadnienia" XSDType="TTekstowy"/></P_13>
	    </PozycjeSzczegolowe>
	</Zalacznik_ORD-ZU></ea:Section>
	</Zalaczniki>
</Deklaracja>
