﻿<%@ Page Language="C#" AutoEventWireup="false" CodePage="1200" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Deklaracje" %>
<%@ Import Namespace="Soneta.Deklaracje.PIT" %>
<%@ Import Namespace="System.Collections.Generic" %>
<script runat="server">

    void OnContextLoad(Object sender, EventArgs args) {
        var dek = (PIT8CZ_11)dc[typeof(PIT8CZ_11)];

        bool osobaFizyczna = (bool)dek.Bloki["B1"]["OsobaFiz"];
        string[] nazwa = Soneta.Deklaracje.PIT.PIT.DaneFirmy((string)dek.Bloki["B1"]["Nazwa"], osobaFizyczna);

        if (osobaFizyczna) {
            OsobaNieFizyczna.Visible = false;
            if (nazwa.Length > 0)
                Nazwisko.EditValue = nazwa[0].Trim();
            if (nazwa.Length > 1)
                ImiePierwsze.EditValue = nazwa[1].Trim();
            if (nazwa.Length > 2)
                DataUrodzenia.EditValue = nazwa[2].Trim();
        }
        else {
            OsobaFizyczna.Visible = false;
            if (nazwa.Length > 0)
                NazwaPelna.EditValue = nazwa[0].Trim();
            //if (nazwa.Length > 1)
            //    REGON.EditValue = nazwa[1].Trim();
        }

        InitBrakDanych(dek);        

        var pity = new List<PIT8C>();
        foreach (Deklaracja pit in dek.Deklaracje)
            if (pit is PIT8C_11)
                pity.Add((PIT8C_11)pit);
        PIT_REP.DataSource = pity;
    }

    protected void PIT_BeforeRow(object sender, EventArgs e) {
        var dek = (PIT8C_11)PIT_REP.CurrentRow;

        string kodKraju = ((string)dek.Bloki["X"]["KodKraju"]).ToUpper();
        if (kodKraju == "" || kodKraju=="PL") {
            AdresZagr.Visible = false;
            AdresPol.Visible = true;
        }
        else {
            AdresZagr.Visible = true;
            AdresPol.Visible = false;
        }

        if (dek.JestPESEL) {
            P10_PESEL.Visible = true;        
            P10_NIP.Visible = false;
        }
        else {
            P10_PESEL.Visible = false;        
            P10_NIP.Visible = true;
        }
        
        decimal strata = (decimal)dek.Bloki["D"]["Strata"];
        Plus.Visible = strata==0;
        Minus.Visible = strata != 0;
    }

    void InitBrakDanych(Deklaracja dek) {
        string brakDanych = dek.Module.Config.PIT.Ogólne.UzupełnienieAdresuNaEDeklaracji;
        if (brakDanych != "") {
            AddMap(pit_wojew, "", brakDanych, 36);
            AddMap(pit_powiat, "", brakDanych, 36);
            AddMap(pit_gmina, "", brakDanych, 36);
            AddMap(pit_nrDomu, "", brakDanych, 9);
            AddMap(pit_miejsc, "", brakDanych, 56);
            AddMap(pit_kodPoczt, "", brakDanych, 8);
            AddMap(pit_kodPoczt, "0", brakDanych, 8);
            //AddMap(pit_poczta, "", brakDanych, 56);
            AddMap(pit_miejscZagr, "", brakDanych, 56);
        }
    }

    static void AddMap(XmlDataLabel label, string key, string value, int maxLen) {
        label.ValuesMap.Add(new ValuesPair(key, Soneta.Core.Tools.Left(value, maxLen)));
    }

</script>
<ea:datacontext id="dc" runat="server" TypeName="Soneta.Deklaracje.PIT.PIT8CZ_11,Soneta.Deklaracje" OnContextLoad="OnContextLoad"></ea:datacontext>
<?xml version="1.0" encoding="UTF-8"?>
<Deklaracja 
    xsi:schemaLocation="http://crd.gov.pl/wzor/2022/11/09/11889/ http://crd.gov.pl/wzor/2022/11/09/11889/schemat.xsd" 
    xmlns="http://crd.gov.pl/wzor/2022/11/09/11889/" 
    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
    xmlns:kusex="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2021/12/23/eD/KodyUrzedowSkarbowychExWUS/"
    xmlns:etd="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2022/03/15/eD/DefinicjeTypy/">
    <Naglowek>
        <KodFormularza kodSystemowy="PIT-8C (11)" kodPodatku="PIT" rodzajZobowiazania="Z" wersjaSchemy="2-0E">PIT-8CZ</KodFormularza>
        <WariantFormularza>11</WariantFormularza>		
        <CelZlozenia poz="P_6"><ea:XmlDataLabel ID="DataLabel1" runat="server" DataMember="A.Korekta"><ValuesMap><ea:ValuesPair Key="False" Value="1" /><ea:ValuesPair Key="True" Value="2"/></ValuesMap></ea:XmlDataLabel></CelZlozenia>
        <ea:XmlDataLabel ElementName="Rok" runat="server" DataMember="0.Rok" />
        <KodUrzedu>0000</KodUrzedu>		
    </Naglowek>
    <Podmiot1 rola="Składający">
        <ea:Section ID="OsobaFizyczna" runat="server"><etd:OsobaFizyczna>
            <ea:XmlDataLabel ElementName="etd:NIP" runat="server" DataMember="0.Nip" XSDType="TNrNIP"/>
            <ea:XmlDataLabel ElementName="etd:ImiePierwsze" ID="ImiePierwsze" runat="server" XSDType="TImie"></ea:XmlDataLabel>
            <ea:XmlDataLabel ElementName="etd:Nazwisko" ID="Nazwisko" runat="server" XSDType="TNazwisko"></ea:XmlDataLabel>
            <ea:XmlDataLabel ElementName="etd:DataUrodzenia" ID="DataUrodzenia" runat="server" XSDType="TData"></ea:XmlDataLabel>
        </etd:OsobaFizyczna></ea:Section>
        <ea:Section ID="OsobaNieFizyczna" runat="server"><etd:OsobaNiefizyczna>
            <ea:XmlDataLabel ElementName="etd:NIP" runat="server" DataMember="0.Nip" XSDType="TNrNIP"/>
            <ea:XmlDataLabel ElementName="etd:PelnaNazwa" ID="NazwaPelna" runat="server" XSDType="TZnakowy" />
        </etd:OsobaNiefizyczna></ea:Section>
    </Podmiot1>	
    <ea:DataRepeater ID="PIT_REP" runat="server" WithSections="False" OnBeforeRow="PIT_BeforeRow">
    <Pozycja typ="G">	
    <ea:XmlDataLabel ElementName="KodUrzeduP" runat="server" DataMember="X.KodUrzeduSkarbowego" />
    <Podmiot2 rola="Podatnik">
        <etd:OsobaFizyczna>
            <ea:XmlDataLabel ElementName="etd:NIP" ID="P10_NIP" runat="server" DataMember="C1.NIP" XSDType="TNrNIP" />
            <ea:XmlDataLabel ElementName="etd:PESEL" ID="P10_PESEL" runat="server" DataMember="C1.PESEL" XSDType="TNrPESEL" />
            <ea:XmlDataLabel ID="XmlDataLabel1" ElementName="etd:ImiePierwsze" runat="server" DataMember="C1.Imię" XSDType="TImie"/>
            <ea:XmlDataLabel ID="XmlDataLabel2" ElementName="etd:Nazwisko" runat="server" DataMember="C1.Nazwisko" XSDType="TNazwisko"/>
            <ea:XmlDataLabel ID="XmlDataLabel3" ElementName="etd:DataUrodzenia" runat="server" DataMember="C1.DataUrodz" XSDType="TData"/>
        </etd:OsobaFizyczna>
        <etd:AdresZamieszkania rodzajAdresu="RAD">
            <ea:Section ID="AdresPol" runat="server">
            <etd:AdresPol>
                <etd:KodKraju>PL</etd:KodKraju>
                <ea:XmlDataLabel ElementName="etd:Wojewodztwo" ID="pit_wojew" runat="server" DataMember="C2.Wojew" XSDType="TJednAdmin"/>
                <ea:XmlDataLabel ElementName="etd:Powiat" ID="pit_powiat" runat="server" DataMember="C2.Powiat" XSDType="TJednAdmin"/>
                <ea:XmlDataLabel ElementName="etd:Gmina" ID="pit_gmina" runat="server" DataMember="C2.Gmina" XSDType="TJednAdmin"/>
                <ea:XmlDataLabel ElementName="etd:Ulica" runat="server" DataMember="C2.Ulica" XSDType="TUlica" HideEmptyOrZero="true"/>
                <ea:XmlDataLabel ElementName="etd:NrDomu" ID="pit_nrDomu" runat="server" DataMember="C2.NrDomu" XSDType="TNrBudynku"/>
                <ea:XmlDataLabel ElementName="etd:NrLokalu" runat="server" DataMember="C2.NrLokalu" XSDType="TNrLokalu" HideEmptyOrZero="true"/>
                <ea:XmlDataLabel ElementName="etd:Miejscowosc" ID="pit_miejsc" runat="server" DataMember="C2.Miejsc" XSDType="TMiejscowosc"/>
                <ea:XmlDataLabel ElementName="etd:KodPocztowy" ID="pit_kodPoczt" runat="server" DataMember="C2.KodPoczt" XSDType="TKodPocztowy"/>
            </etd:AdresPol>
            </ea:Section>
            <ea:Section ID="AdresZagr" runat="server">
            <etd:AdresZagr>
                <ea:XmlDataLabel ElementName="etd:KodKraju" runat="server" DataMember="X.KodKraju" XSDType="TTekstowy"/>
                <ea:XmlDataLabel ElementName="etd:KodPocztowy" runat="server" DataMember="C2.KodPoczt" XSDType="TKodPocztowy" HideEmptyOrZero="true"/>
                <ea:XmlDataLabel ElementName="etd:Miejscowosc" ID="pit_miejscZagr" runat="server" DataMember="C2.Miejsc" XSDType="TMiejscowosc"/>
                <ea:XmlDataLabel ElementName="etd:Ulica" runat="server" DataMember="C2.Ulica" XSDType="TUlica" HideEmptyOrZero="true"/>
                <ea:XmlDataLabel ElementName="etd:NrDomu" runat="server" DataMember="C2.NrDomu" XSDType="TNrBudynku" HideEmptyOrZero="true"/>
                <ea:XmlDataLabel ElementName="etd:NrLokalu" runat="server" DataMember="C2.NrLokalu" XSDType="TNrLokalu" HideEmptyOrZero="true"/>
            </etd:AdresZagr>
            </ea:Section>
        </etd:AdresZamieszkania>
    </Podmiot2>
    <PozycjeSzczegolowe>
        <ea:XmlDataLabel ElementName="P_23" runat="server" DataMember="D.1Przychód" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="P_24" runat="server" DataMember="D.1Koszty" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="P_25" runat="server" DataMember="D.2Przychód" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="P_26" runat="server" DataMember="D.2Koszty" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="P_27" runat="server" DataMember="D.3Przychód" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="P_28" runat="server" DataMember="D.3Koszty" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="P_29" runat="server" DataMember="D.4Przychód" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="P_30" runat="server" DataMember="D.4Koszty" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="P_31" runat="server" DataMember="D.5Przychód" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="P_32" runat="server" DataMember="D.5Koszty" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="P_33" runat="server" DataMember="D.Przychód" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="P_34" runat="server" DataMember="D.Koszty" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="P_35" ID="Plus" runat="server" DataMember="D.Dochód" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="P_36" ID="Minus" runat="server" DataMember="D.Strata" XSDType="TKwota2"/>

        <ea:XmlDataLabel ElementName="P_37" runat="server" DataMember="E.Przychód" XSDType="TKwota2"/>
    </PozycjeSzczegolowe>
</Pozycja>
</ea:DataRepeater>
<Pouczenie>1</Pouczenie>
</Deklaracja>
