﻿<%@ Page Language="C#" AutoEventWireup="false" CodePage="1200" %>

<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>

<%@ Import Namespace="System.Globalization" %>
<%@ Import Namespace="System.Linq" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Deklaracje" %>
<%@ Import Namespace="Soneta.Deklaracje.VAT" %>


<script runat="server">

	private VAT27_1 dek;


	void OnContextLoad(Object sender, EventArgs args)
	{
		dek = (VAT27_1)dc[typeof(VAT27_1)];

		var nazwa = Soneta.Deklaracje.PIT.PIT.DaneFirmy((string)dek.Bloki["B1"]["Nazwa"], (bool)dek.Bloki["B1"]["OsobaFiz"]);
		if ((bool)dek.Bloki["B1"]["OsobaFiz"])
		{
			OsobaNieFizyczna.Visible = false;
			if (nazwa.Length > 0)
				IdNazwisko.EditValue = nazwa[0].Trim();
			if (nazwa.Length > 1)
				IdImiePierwsze.EditValue = nazwa[1].Trim();
			if (nazwa.Length > 2)
				IdDataUrodzenia.EditValue = nazwa[2].Trim();
		}
		else
		{
			OsobaFizyczna.Visible = false;
			if (nazwa.Length > 0)
				NazwaPelna.EditValue = nazwa[0].Trim();
			if (nazwa.Length > 1)
				REGON.EditValue = nazwa[1].Trim();
		}

		var edeklHelper = dek.GetEDekleracjaHelper();
		if (edeklHelper.ItemsC.Count > 0)
		{
			BlokC.Visible = true;
			GroupC.DataSource = edeklHelper.ItemsC;
			SumGroupC.EditValue = edeklHelper.ItemsC.Sum(i => i.Value);
		}

		if (edeklHelper.ItemsD.Count > 0)
		{
			BlokD.Visible = true;
			GroupD.DataSource = edeklHelper.ItemsD;
			SumGroupD.EditValue = edeklHelper.ItemsD.Sum(i => i.Value);
		}
	}


</script>


<ea:datacontext id="dc" runat="server" typename="Soneta.Deklaracje.VAT.VAT27_1,Soneta.Deklaracje" oncontextload="OnContextLoad" />
<?xml version="1.0" encoding="UTF-8" ?>
<Deklaracja xmlns="http://crd.gov.pl/wzor/2015/07/01/2441/" xmlns:etd="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2011/06/21/eD/DefinicjeTypy/" xmlns:tns="http://crd.gov.pl/wzor/2015/07/01/2441/">
<Naglowek>
	<KodFormularza kodSystemowy="VAT-27 (1)" kodPodatku="VAT" rodzajZobowiazania="Z" wersjaSchemy="1-0E" >VAT-27</KodFormularza>
	<WariantFormularza>1</WariantFormularza>
	<CelZlozenia poz="P_8"><ea:XmlDataLabel runat="server" DataMember="Korekta"><ValuesMap><ea:ValuesPair Key="False" Value="1" /><ea:ValuesPair Key="True" Value="2"/></ValuesMap></ea:XmlDataLabel></CelZlozenia>
	<ea:XmlDataLabel runat="server" ElementName="Rok" DataMember="0.Rok" />
	<ea:XmlDataLabel runat="server" ElementName="Miesiac" DataMember="0.Miesiac" />
	<ea:XmlDataLabel runat="server" ElementName="KodUrzedu" DataMember="DOD.KodUrzeduSkarbowego" />
</Naglowek>

<Podmiot1 rola="Podatnik">
	<ea:Section ID="OsobaFizyczna" runat="server">
		<OsobaFizyczna>
			<ea:XmlDataLabel runat="server" ElementName="NIP" DataMember="0.Nip" XSDType="TNrNIP" />
			<ea:XmlDataLabel runat="server" ElementName="ImiePierwsze" ID="IdImiePierwsze" XSDType="TImie" />
			<ea:XmlDataLabel runat="server" ElementName="Nazwisko" ID="IdNazwisko" XSDType="TNazwisko" />
			<ea:XmlDataLabel runat="server" ElementName="DataUrodzenia" ID="IdDataUrodzenia" XSDType="TData" />
		</OsobaFizyczna>
	</ea:Section>
	<ea:Section ID="OsobaNieFizyczna" runat="server">
		<OsobaNiefizyczna>
			<ea:XmlDataLabel runat="server" ElementName="NIP" DataMember="0.Nip" XSDType="TNrNIP" />
			<ea:XmlDataLabel ElementName="PelnaNazwa" ID="NazwaPelna" runat="server" XSDType="TZnakowy" />
			<ea:XmlDataLabel ID="REGON" runat="server" ElementName="REGON" XSDType="TNrREGON" HideEmptyOrZero="true" />
		</OsobaNiefizyczna>
	</ea:Section>
</Podmiot1>	
	
<PozycjeSzczegolowe>
	<ea:Section ID="BlokC" runat="server" Visible="false">
		<ea:DataRepeater runat="server" WithSections="false" ID="GroupC" >
			<Grupa_C typ="G" >
				<ea:XmlDataLabel runat="server" ID="P_C1" ElementName="P_C1" DataMember="Changed" XSDType="TWybor1" HideEmptyOrZero="true" />
				<ea:XmlDataLabel runat="server" ID="P_C2" ElementName="P_C2" DataMember="Name" />
				<ea:XmlDataLabel runat="server" ID="P_C3" ElementName="P_C3" DataMember="NIP" XSDType="TNrNIP" />
				<ea:XmlDataLabel runat="server" ID="P_C4" ElementName="P_C4" DataMember="Value" XSDType="TKwota2" />
			</Grupa_C>
		</ea:DataRepeater>
		<ea:XmlDataLabel runat="server" ID="SumGroupC" XSDType="TKwota2" ElementName="P_11" />
	</ea:Section>
	<ea:Section ID="BlokD" runat="server" Visible="false">
		<ea:DataRepeater runat="server" WithSections="false" ID="GroupD" >
			<Grupa_D typ="G" >
				<ea:XmlDataLabel runat="server" ID="P_D1" ElementName="P_D1" DataMember="Changed" XSDType="TWybor1" HideEmptyOrZero="true" />
				<ea:XmlDataLabel runat="server" ID="P_D2" ElementName="P_D2" DataMember="Name" />
				<ea:XmlDataLabel runat="server" ID="P_D3" ElementName="P_D3" DataMember="NIP" XSDType="TNrNIP" />
				<ea:XmlDataLabel runat="server" ID="P_D4" ElementName="P_D4" DataMember="Value" XSDType="TKwota2"  />
			</Grupa_D>
		</ea:DataRepeater>
		<ea:XmlDataLabel runat="server" ID="SumGroupD" XSDType="TKwota2" ElementName="P_12" />
	</ea:Section>
	<ea:XmlDataLabel runat="server" ElementName="P_15" DataMember="ETelefon" XSDType="TZnakowy"  HideEmptyOrZero="true" />
	<ea:XmlDataLabel runat="server" ElementName="P_16" DataMember="EData" XSDType="TData" />
</PozycjeSzczegolowe>
	
<Pouczenie>Za podanie nieprawdy lub zatajenie prawdy grozi odpowiedzialność przewidziana w Kodeksie karnym skarbowym.</Pouczenie>

	 
</Deklaracja>
