﻿<%@ Page Language="C#" AutoEventWireup="false" CodePage="1200" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Deklaracje" %>
<script runat="server">
	Soneta.Deklaracje.VAT.VAT7_12 dek = null;
	
	void OnContextLoad(Object sender, EventArgs args) {
		dek = (Soneta.Deklaracje.VAT.VAT7_12)dc[typeof(Soneta.Deklaracje.VAT.VAT7_12)];
		ORD_ZU.Visible = dek.TreśćUzasadnienia != "";
		VAT_ZT.Visible = dek.VATZT_Visible;
		VAT_ZZ.Visible = dek.VATZZ_Visible;
		NAD_ZP.Visible = dek.NADZP_Visible;			
		
		//Nagłówek
		if (dek.TypDeklaracjiVAT7==Soneta.Deklaracje.VAT.TypDeklaracjiVAT7.VAT7) {
			WariantFormularza.EditValue = 12;
			MiesiacKwartal.ElementName = "Miesiac";
			MiesiacKwartal.EditValue = dek.Bloki["0"]["Miesiąc"];
		} else if(dek.TypDeklaracjiVAT7==Soneta.Deklaracje.VAT.TypDeklaracjiVAT7.VAT7K){
			WariantFormularza.EditValue = 6;
			MiesiacKwartal.ElementName = "Kwartal";
			MiesiacKwartal.EditValue = dek.Okres.To.Quarter;
		} else if (dek.TypDeklaracjiVAT7 == Soneta.Deklaracje.VAT.TypDeklaracjiVAT7.VAT7D) {
			WariantFormularza.EditValue = 3;
			MiesiacKwartal.ElementName = "Kwartal";
			MiesiacKwartal.EditValue = dek.Okres.To.Quarter;
		}
		
		string[] nazwa = Soneta.Deklaracje.PIT.PIT.DaneFirmy((string)dek.Bloki["B1"]["Nazwa"], (bool)dek.Bloki["B1"]["OsobaFiz"]);
		if((bool)dek.Bloki["B1"]["OsobaFiz"]){
			OsobaNieFizyczna.Visible = false;
			if (nazwa.Length > 0)
				Nazwisko.EditValue = nazwa[0].Trim();
			if (nazwa.Length > 1)
				ImiePiersze.EditValue = nazwa[1].Trim();
			if (nazwa.Length > 2)
				DataUrodzenia.EditValue = nazwa[2].Trim();
      if (nazwa.Length > 3)
        PESEL.EditValue = nazwa[3].Trim();						      
		}else{
			OsobaFizyczna.Visible = false;
			if (nazwa.Length > 0)
				NazwaPelna.EditValue = nazwa[0].Trim();
			if (nazwa.Length > 1)
				REGON.EditValue = nazwa[1].Trim();			
		}

		string kraj = (string)dek.Bloki["B2"]["Kraj"];
		if (!string.IsNullOrEmpty(kraj) && kraj.ToLower() != "polska") {
			AdresPolski.Visible = false;
            AdresZagranicznyKodKraju.EditValue = Soneta.Core.Adres.KodKrajuWgNazwy(kraj, dc.Session);
		}
		else
			AdresZagraniczny.Visible = false;		
	}
	
</script>
<ea:datacontext id="dc" runat="server" TypeName="Soneta.Deklaracje.VAT.VAT7_12,Soneta.Deklaracje" OnContextLoad="OnContextLoad"></ea:datacontext>
<?xml version="1.0" encoding="UTF-8"?>
<%if (dek.TypDeklaracjiVAT7==Soneta.Deklaracje.VAT.TypDeklaracjiVAT7.VAT7) {
%><Deklaracja xsi:noNamespaceSchemaLocation="http://www.e-deklaracje.mf.gov.pl/Repozytorium/Deklaracje/VAT/VAT-7(12)_v1-0.xsd" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:usr="urn:the-xml-files:xslt" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
	<Naglowek>
		<KodFormularza kodSystemowy="VAT-7 (12)" kodPodatku="VAT" rodzajZobowiazania="Z" wersjaSchemy="1-0">VAT-7</KodFormularza><%}
else if (dek.TypDeklaracjiVAT7==Soneta.Deklaracje.VAT.TypDeklaracjiVAT7.VAT7K)  {
%><Deklaracja xsi:noNamespaceSchemaLocation="http://www.e-deklaracje.mf.gov.pl/Repozytorium//Deklaracje/VAT/VAT-7K(6)_v1-1.xsd" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:usr="urn:the-xml-files:xslt" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
	<Naglowek>
		<KodFormularza kodSystemowy="VAT-7K (6)" kodPodatku="VAT" rodzajZobowiazania="Z" wersjaSchemy="1-1">VAT-7K</KodFormularza><%} 
else if (dek.TypDeklaracjiVAT7==Soneta.Deklaracje.VAT.TypDeklaracjiVAT7.VAT7D)  {
%><Deklaracja xsi:noNamespaceSchemaLocation="http://www.e-deklaracje.mf.gov.pl/Repozytorium/Deklaracje/VAT/VAT-7D(3)_v1-0.xsd" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:usr="urn:the-xml-files:xslt" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
	<Naglowek>
		<KodFormularza kodSystemowy="VAT-7D (3)" kodPodatku="VAT" rodzajZobowiazania="Z" wersjaSchemy="1-0">VAT-7D</KodFormularza><%} %>			
		<ea:XmlDataLabel ID="WariantFormularza" ElementName="WariantFormularza" runat="server"></ea:XmlDataLabel>		
		<CelZlozenia poz="P_7"><ea:XmlDataLabel ID="DataLabel1" runat="server" DataMember="A.Korekta"><ValuesMap><ea:ValuesPair Key="False" Value="1" /><ea:ValuesPair Key="True" Value="2"/></ValuesMap></ea:XmlDataLabel></CelZlozenia>
		<Rok><ea:XmlDataLabel ID="DataLabel2" runat="server" DataMember="0.Rok"></ea:XmlDataLabel></Rok>
		<ea:XmlDataLabel ID="MiesiacKwartal" runat="server"></ea:XmlDataLabel>
		<KodUrzedu><ea:XmlDataLabel ID="DataLabel4" runat="server" DataMember="DOD.KodUrzeduSkarbowego"></ea:XmlDataLabel></KodUrzedu>
	</Naglowek>
	<Podmiot1 rola="Podatnik">
		<ea:Section ID="OsobaFizyczna" runat="server"><OsobaFizyczna>
			<ea:XmlDataLabel ID="XmlDataLabel1" runat="server" ElementName="NIP" DataMember="0.Nip" XSDType="TNrNIP"></ea:XmlDataLabel>
			<ImiePierwsze><ea:XmlDataLabel ID="ImiePiersze" runat="server" XSDType="TImie"></ea:XmlDataLabel></ImiePierwsze>
			<Nazwisko><ea:XmlDataLabel ID="Nazwisko" runat="server" XSDType="TNazwisko"></ea:XmlDataLabel></Nazwisko>
			<DataUrodzenia><ea:XmlDataLabel ID="DataUrodzenia" runat="server" XSDType="TData"></ea:XmlDataLabel></DataUrodzenia>
      <ea:XmlDataLabel ID="PESEL" runat="server" ElementName="PESEL" HideEmptyOrZero="true"></ea:XmlDataLabel>
    </OsobaFizyczna></ea:Section>
		<ea:Section ID="OsobaNieFizyczna" runat="server"><OsobaNiefizyczna>
			<ea:XmlDataLabel ID="XmlDataLabel2" runat="server" ElementName="NIP" DataMember="0.Nip" XSDType="TNrNIP"></ea:XmlDataLabel>
			<PelnaNazwa><ea:XmlDataLabel ID="NazwaPelna" runat="server" XSDType="TZnakowy"></ea:XmlDataLabel></PelnaNazwa>
			<REGON><ea:XmlDataLabel ID="REGON" runat="server" XSDType="TNrREGON"></ea:XmlDataLabel></REGON>
		</OsobaNiefizyczna></ea:Section>
		<AdresZamieszkaniaSiedziby rodzajAdresu="RAD">
			<ea:Section ID="AdresPolski" runat="server"><AdresPol>
				<KodKraju>PL</KodKraju>
				<Wojewodztwo><ea:XmlDataLabel ID="XmlDataLabel3" runat="server" DataMember="B2.Wojew" XSDType="TJednAdmin"></ea:XmlDataLabel></Wojewodztwo>
				<Powiat><ea:XmlDataLabel ID="XmlDataLabel4" runat="server" DataMember="B2.Powiat" XSDType="TJednAdmin"></ea:XmlDataLabel></Powiat>
				<Gmina><ea:XmlDataLabel ID="XmlDataLabel5" runat="server" DataMember="B2.Gmina" XSDType="TJednAdmin"></ea:XmlDataLabel></Gmina>
				<ea:XmlDataLabel ID="XmlDataLabel6" runat="server" ElementName="Ulica" HideEmptyOrZero="true" DataMember="B2.Ulica" XSDType="TUlica"></ea:XmlDataLabel>
				<NrDomu><ea:XmlDataLabel ID="XmlDataLabel7" runat="server" DataMember="B2.NrDomu" XSDType="TNrBudynku"></ea:XmlDataLabel></NrDomu>
				<ea:XmlDataLabel ID="XmlDataLabel8" runat="server" ElementName="NrLokalu" HideEmptyOrZero="true" DataMember="B2.NrLokalu" XSDType="TNrLokalu"></ea:XmlDataLabel>
				<Miejscowosc><ea:XmlDataLabel ID="XmlDataLabel9" runat="server" DataMember="B2.Miejsc" XSDType="TMiejscowosc"></ea:XmlDataLabel></Miejscowosc>
				<KodPocztowy><ea:XmlDataLabel ID="XmlDataLabel10" runat="server" DataMember="B2.KodPoczt" XSDType="TKodPocztowy"></ea:XmlDataLabel></KodPocztowy>
				<Poczta><ea:XmlDataLabel ID="XmlDataLabel11" runat="server" DataMember="B2.Poczta" XSDType="TMiejscowosc"></ea:XmlDataLabel></Poczta>
			</AdresPol></ea:Section>
			<ea:Section ID="AdresZagraniczny" runat="server"><AdresZagr>
				<KodKraju><ea:XmlDataLabel ID="AdresZagranicznyKodKraju" runat="server"></ea:XmlDataLabel></KodKraju>
				<KodPocztowy><ea:XmlDataLabel runat="server" DataMember="B2.KodPoczt" XSDType="TKodPocztowy"></ea:XmlDataLabel></KodPocztowy>
				<Miejscowosc><ea:XmlDataLabel runat="server" DataMember="B2.Miejsc" XSDType="TMiejscowosc"></ea:XmlDataLabel></Miejscowosc>
				<ea:XmlDataLabel runat="server" ElementName="Ulica" HideEmptyOrZero="true" DataMember="B2.Ulica" XSDType="TUlica"></ea:XmlDataLabel>
				<ea:XmlDataLabel runat="server" ElementName="NrDomu" HideEmptyOrZero="true" DataMember="B2.NrDomu" XSDType="TNrBudynku"></ea:XmlDataLabel>
				<ea:XmlDataLabel runat="server" ElementName="NrLokalu" HideEmptyOrZero="true" DataMember="B2.NrLokalu" XSDType="TNrLokalu"></ea:XmlDataLabel>
			</AdresZagr></ea:Section>
		</AdresZamieszkaniaSiedziby>
	</Podmiot1>	
	<PozycjeSzczegolowe>
		<P_20><ea:XmlDataLabel ID="DataLabel5" runat="server" DataMember="C.Zwolnione" XSDType="TKwotaC"></ea:XmlDataLabel></P_20>
		<P_21><ea:XmlDataLabel ID="DataLabel6" runat="server" DataMember="C.DostawaPozaKrajem" XSDType="TKwotaC"></ea:XmlDataLabel></P_21>
		<P_22><ea:XmlDataLabel ID="DataLabel47" runat="server" DataMember="C.DostawaPozaKrajemUslugiUnia" XSDType="TKwotaC"></ea:XmlDataLabel></P_22>		
		<P_23><ea:XmlDataLabel ID="DataLabel7" runat="server" DataMember="C.0%Netto" XSDType="TKwotaC"></ea:XmlDataLabel></P_23>
		<P_24><ea:XmlDataLabel ID="DataLabel8" runat="server" DataMember="C.0%NettoArt129" XSDType="TKwotaC"></ea:XmlDataLabel></P_24>
		<P_25><ea:XmlDataLabel ID="DataLabel9" runat="server" DataMember="C.3%Netto" XSDType="TKwotaC"></ea:XmlDataLabel></P_25>
		<P_26><ea:XmlDataLabel ID="DataLabel10" runat="server" DataMember="C.3%VAT" XSDType="TKwotaC"></ea:XmlDataLabel></P_26>
		<P_27><ea:XmlDataLabel ID="DataLabel11" runat="server" DataMember="C.7%Netto" XSDType="TKwotaC"></ea:XmlDataLabel></P_27>
		<P_28><ea:XmlDataLabel ID="DataLabel12" runat="server" DataMember="C.7%VAT" XSDType="TKwotaC"></ea:XmlDataLabel></P_28>
		<P_29><ea:XmlDataLabel ID="DataLabel13" runat="server" DataMember="C.22%Netto" XSDType="TKwotaC"></ea:XmlDataLabel></P_29>
		<P_30><ea:XmlDataLabel ID="DataLabel14" runat="server" DataMember="C.22%VAT" XSDType="TKwotaC"></ea:XmlDataLabel></P_30>
		<P_31><ea:XmlDataLabel ID="DataLabel15" runat="server" DataMember="C.UniaDostawa" XSDType="TKwotaC"></ea:XmlDataLabel></P_31>
		<P_32><ea:XmlDataLabel ID="DataLabel16" runat="server" DataMember="C.Eksport" XSDType="TKwotaC"></ea:XmlDataLabel></P_32>
		<P_33><ea:XmlDataLabel ID="DataLabel17" runat="server" DataMember="C.UniaNabycieNetto" XSDType="TKwotaC"></ea:XmlDataLabel></P_33>
		<P_34><ea:XmlDataLabel ID="DataLabel18" runat="server" DataMember="C.UniaNabycieVAT" XSDType="TKwotaC"></ea:XmlDataLabel></P_34>
		<P_35><ea:XmlDataLabel ID="XmlDataLabel13" runat="server" DataMember="DOD.ImportTowarowNetto" XSDType="TKwotaC"></ea:XmlDataLabel></P_35>
		<P_36><ea:XmlDataLabel ID="XmlDataLabel14" runat="server" DataMember="DOD.ImportTowarowVAT" XSDType="TKwotaC"></ea:XmlDataLabel></P_36>
		<P_37><ea:XmlDataLabel ID="DataLabel19" runat="server" DataMember="C.ImportUslugNetto" XSDType="TKwotaC"></ea:XmlDataLabel></P_37>
		<P_38><ea:XmlDataLabel ID="DataLabel20" runat="server" DataMember="C.ImportUslugVAT" XSDType="TKwotaC"></ea:XmlDataLabel></P_38>
		<P_39><ea:XmlDataLabel ID="DataLabel48" runat="server" DataMember="C.ImportUslugNettoUnia" XSDType="TKwotaC"></ea:XmlDataLabel></P_39>
		<P_40><ea:XmlDataLabel ID="DataLabel49" runat="server" DataMember="C.ImportUslugVATUnia" XSDType="TKwotaC"></ea:XmlDataLabel></P_40>		
		<P_41><ea:XmlDataLabel ID="DataLabel21" runat="server" DataMember="C.DostawaTowarowNetto" XSDType="TKwotaC"></ea:XmlDataLabel></P_41>
		<P_42><ea:XmlDataLabel ID="DataLabel22" runat="server" DataMember="C.DostawaTowarowVAT" XSDType="TKwotaC"></ea:XmlDataLabel></P_42>
		<P_43><ea:XmlDataLabel ID="DataLabel23" runat="server" DataMember="C.Spis" XSDType="TKwotaC"></ea:XmlDataLabel></P_43>
		<P_44><ea:XmlDataLabel ID="DataLabel24" runat="server" DataMember="C.SrodkiTransportu" XSDType="TKwotaC"></ea:XmlDataLabel></P_44>
		<P_45><ea:XmlDataLabel ID="DataLabel25" runat="server" DataMember="C.Netto" XSDType="TKwotaC"></ea:XmlDataLabel></P_45>
		<P_46><ea:XmlDataLabel ID="DataLabel26" runat="server" DataMember="C.VAT" XSDType="TKwotaC"></ea:XmlDataLabel></P_46>
		<P_47><ea:XmlDataLabel ID="DataLabel27" runat="server" DataMember="D1.Nadwyzka" XSDType="TKwotaC"></ea:XmlDataLabel></P_47>
		<P_48><ea:XmlDataLabel ID="DataLabel28" runat="server" DataMember="D1.Spis" XSDType="TKwotaC"></ea:XmlDataLabel></P_48>
		<P_49><ea:XmlDataLabel ID="DataLabel29" runat="server" DataMember="D2.SrodkiTrwaleNetto" XSDType="TKwotaC"></ea:XmlDataLabel></P_49>
		<P_50><ea:XmlDataLabel ID="DataLabel30" runat="server" DataMember="D2.SrodkiTrwaleVAT" XSDType="TKwotaC"></ea:XmlDataLabel></P_50>
		<P_51><ea:XmlDataLabel ID="DataLabel31" runat="server" DataMember="D2.PozostaleNetto" XSDType="TKwotaC"></ea:XmlDataLabel></P_51>
		<P_52><ea:XmlDataLabel ID="DataLabel32" runat="server" DataMember="D2.PozostaleVAT" XSDType="TKwotaC"></ea:XmlDataLabel></P_52>
		<P_53><ea:XmlDataLabel ID="DataLabel33" runat="server" DataMember="D3.SrodkiTrwale" XSDType="TKwotaC"></ea:XmlDataLabel></P_53>
		<P_54><ea:XmlDataLabel ID="DataLabel34" runat="server" DataMember="D3.Pozostale" XSDType="TKwotaC"></ea:XmlDataLabel></P_54>
		<P_55><ea:XmlDataLabel ID="DataLabel35" runat="server" DataMember="D3.Razem" XSDType="TKwotaC"></ea:XmlDataLabel></P_55>
		<P_56><ea:XmlDataLabel ID="DataLabel36" runat="server" DataMember="E.KasyOdliczenia" XSDType="TKwotaC"></ea:XmlDataLabel></P_56>
		<P_57><ea:XmlDataLabel ID="DataLabel37" runat="server" DataMember="E.Zaniechanie" XSDType="TKwotaC"></ea:XmlDataLabel></P_57>
		<P_58><ea:XmlDataLabel ID="DataLabel38" runat="server" DataMember="E.DoZaplaty" XSDType="TKwotaC"></ea:XmlDataLabel></P_58>
<%if (dek.TypDeklaracjiVAT7 == Soneta.Deklaracje.VAT.TypDeklaracjiVAT7.VAT7D) {
%>	<P_59><ea:XmlDataLabel ID="XmlDataLabel33" runat="server" DataMember="DOD.SumaZaliczekZaKwartal" XSDType="TKwotaC"></ea:XmlDataLabel></P_59>
		<P_60><ea:XmlDataLabel ID="XmlDataLabel34" runat="server" DataMember="DOD.NadplataZaPoprzedniKwartal" XSDType="TKwotaC"></ea:XmlDataLabel></P_60>
		<P_61><ea:XmlDataLabel ID="XmlDataLabel35" runat="server" DataMember="DOD.DoZaplatyZaliczki" XSDType="TKwotaC"></ea:XmlDataLabel></P_61>				
<%if ((decimal)dek.Bloki["DOD"]["NadplataZaliczki"]>0) {
%>	<P_62><ea:XmlDataLabel ID="XmlDataLabel36" runat="server" DataMember="DOD.NadplataZaliczki" XSDType="TKwotaC"></ea:XmlDataLabel></P_62>				
		<P_63><ea:XmlDataLabel ID="XmlDataLabel38" runat="server" DataMember="DOD.NadplataNaPrzyszle"><ValuesMap><ea:ValuesPair Key="True" Value="1" /><ea:ValuesPair Key="False" Value="2"/></ValuesMap></ea:XmlDataLabel></P_63>		
		<P_64><ea:XmlDataLabel ID="XmlDataLabel37" runat="server" DataMember="DOD.NadplataNaPrzyszleKwota" XSDType="TKwotaC"></ea:XmlDataLabel></P_64>						
<%}
%>	<P_65><ea:XmlDataLabel ID="DataLabel39" runat="server" DataMember="E.KasyZwrot" XSDType="TKwotaC"></ea:XmlDataLabel></P_65>
		<P_66><ea:XmlDataLabel ID="DataLabel40" runat="server" DataMember="E.DoZwrotu" XSDType="TKwotaC"></ea:XmlDataLabel></P_66>
		<P_67><ea:XmlDataLabel ID="DataLabel41" runat="server" DataMember="E.NaKonto" XSDType="TKwotaC"></ea:XmlDataLabel></P_67>
		<P_68><ea:XmlDataLabel ID="XmlDataLabel15" runat="server" DataMember="DOD.NaKonto25" XSDType="TKwotaC"></ea:XmlDataLabel></P_68>		
		<P_69><ea:XmlDataLabel ID="DataLabel42" runat="server" DataMember="E.NaKonto60" XSDType="TKwotaC"></ea:XmlDataLabel></P_69>
		<P_70><ea:XmlDataLabel ID="DataLabel43" runat="server" DataMember="E.NaKonto180" XSDType="TKwotaC"></ea:XmlDataLabel></P_70>
		<P_71><ea:XmlDataLabel ID="DataLabel44" runat="server" DataMember="E.DoPrzeniesienia" XSDType="TKwotaC"></ea:XmlDataLabel></P_71>
		<ea:XmlDataLabel ID="XmlDataLabel16" runat="server" ElementName="P_72" DataMember="F.Czynnosc1" HideEmptyOrZero="true"><ValuesMap><ea:ValuesPair Key="True" Value="1" /><ea:ValuesPair Key="False" Value="0"/></ValuesMap></ea:XmlDataLabel>		
		<ea:XmlDataLabel ID="XmlDataLabel17" runat="server" ElementName="P_73" DataMember="F.Czynnosc2" HideEmptyOrZero="true"><ValuesMap><ea:ValuesPair Key="True" Value="1" /><ea:ValuesPair Key="False" Value="0"/></ValuesMap></ea:XmlDataLabel>		
		<ea:XmlDataLabel ID="XmlDataLabel18" runat="server" ElementName="P_74" DataMember="F.Czynnosc3" HideEmptyOrZero="true"><ValuesMap><ea:ValuesPair Key="True" Value="1" /><ea:ValuesPair Key="False" Value="0"/></ValuesMap></ea:XmlDataLabel>		
		<ea:XmlDataLabel ID="XmlDataLabel19" runat="server" ElementName="P_75" DataMember="F.Czynnosc4" HideEmptyOrZero="true"><ValuesMap><ea:ValuesPair Key="True" Value="1" /><ea:ValuesPair Key="False" Value="0"/></ValuesMap></ea:XmlDataLabel>						
		<P_76><ea:XmlDataLabel ID="DataLabel45" runat="server" DataMember="G.Zwrot"><ValuesMap><ea:ValuesPair Key="True" Value="1" /><ea:ValuesPair Key="False" Value="2"/></ValuesMap></ea:XmlDataLabel></P_76>
		<P_77><ea:XmlDataLabel ID="DataLabel46" runat="server" DataMember="G.Przyspieszenie"><ValuesMap><ea:ValuesPair Key="True" Value="1" /><ea:ValuesPair Key="False" Value="2"/></ValuesMap></ea:XmlDataLabel></P_77>
<%} else {
%><P_59><ea:XmlDataLabel ID="XmlDataLabel20" runat="server" DataMember="E.KasyZwrot" XSDType="TKwotaC"></ea:XmlDataLabel></P_59>
		<P_60><ea:XmlDataLabel ID="XmlDataLabel21" runat="server" DataMember="E.DoZwrotu" XSDType="TKwotaC"></ea:XmlDataLabel></P_60>
		<P_61><ea:XmlDataLabel ID="XmlDataLabel22" runat="server" DataMember="E.NaKonto" XSDType="TKwotaC"></ea:XmlDataLabel></P_61>
		<P_62><ea:XmlDataLabel ID="XmlDataLabel23" runat="server" DataMember="DOD.NaKonto25" XSDType="TKwotaC"></ea:XmlDataLabel></P_62>		
		<P_63><ea:XmlDataLabel ID="XmlDataLabel24" runat="server" DataMember="E.NaKonto60" XSDType="TKwotaC"></ea:XmlDataLabel></P_63>
		<P_64><ea:XmlDataLabel ID="XmlDataLabel25" runat="server" DataMember="E.NaKonto180" XSDType="TKwotaC"></ea:XmlDataLabel></P_64>
		<P_65><ea:XmlDataLabel ID="XmlDataLabel26" runat="server" DataMember="E.DoPrzeniesienia" XSDType="TKwotaC"></ea:XmlDataLabel></P_65>
		<ea:XmlDataLabel ID="XmlDataLabel27" runat="server" ElementName="P_66" DataMember="F.Czynnosc1" HideEmptyOrZero="true"><ValuesMap><ea:ValuesPair Key="True" Value="1" /><ea:ValuesPair Key="False" Value="0"/></ValuesMap></ea:XmlDataLabel>		
		<ea:XmlDataLabel ID="XmlDataLabel28" runat="server" ElementName="P_67" DataMember="F.Czynnosc2" HideEmptyOrZero="true"><ValuesMap><ea:ValuesPair Key="True" Value="1" /><ea:ValuesPair Key="False" Value="0"/></ValuesMap></ea:XmlDataLabel>		
		<ea:XmlDataLabel ID="XmlDataLabel29" runat="server" ElementName="P_68" DataMember="F.Czynnosc3" HideEmptyOrZero="true"><ValuesMap><ea:ValuesPair Key="True" Value="1" /><ea:ValuesPair Key="False" Value="0"/></ValuesMap></ea:XmlDataLabel>		
		<ea:XmlDataLabel ID="XmlDataLabel30" runat="server" ElementName="P_69" DataMember="F.Czynnosc4" HideEmptyOrZero="true"><ValuesMap><ea:ValuesPair Key="True" Value="1" /><ea:ValuesPair Key="False" Value="0"/></ValuesMap></ea:XmlDataLabel>						
		<P_70><ea:XmlDataLabel ID="XmlDataLabel31" runat="server" DataMember="G.Zwrot"><ValuesMap><ea:ValuesPair Key="True" Value="1" /><ea:ValuesPair Key="False" Value="2"/></ValuesMap></ea:XmlDataLabel></P_70>
		<P_71><ea:XmlDataLabel ID="XmlDataLabel32" runat="server" DataMember="G.Przyspieszenie"><ValuesMap><ea:ValuesPair Key="True" Value="1" /><ea:ValuesPair Key="False" Value="2"/></ValuesMap></ea:XmlDataLabel></P_71><%} %>		
	</PozycjeSzczegolowe>
<%if (dek.TypDeklaracjiVAT7 == Soneta.Deklaracje.VAT.TypDeklaracjiVAT7.VAT7D) {
%><Pouczenie>W przypadku niewpłacenia w obowiązującym terminie kwoty z poz.61 lub wpłacenia jej w niepełnej wysokości, niniejsza deklaracja stanowi podstawę do wystawienia tytułu wykonawczego, zgodnie z przepisami ustawy z dnia 17 czerwca 1966 r. o postępowaniu egzekucyjnym w administracji (Dz.U. z 2005 r. Nr 229, poz.1954, z późn. zm.).</Pouczenie>
<%} else if (dek.TypDeklaracjiVAT7 == Soneta.Deklaracje.VAT.TypDeklaracjiVAT7.VAT7K) {
%><Pouczenie>W przypadku niewpłacenia w obowiązującym terminie kwoty z poz.58 lub wpłacenia jej w niepełnej wysokości, niniejsza deklaracja stanowi podstawę do wystawienia tytułu wykonawczego, zgodnie z przepisami ustawy z dnia 17 czerwca 1966 r. o postępowaniu egzekucyjnym w administracji (Dz.U. z 2005 r. Nr 229, poz.1954, z późn. zm.).</Pouczenie>
<%} else if (dek.TypDeklaracjiVAT7 == Soneta.Deklaracje.VAT.TypDeklaracjiVAT7.VAT7) {
%><Pouczenie>W przypadku niewpłacenia w obowiązującym terminie kwoty z poz.58 lub wpłacenia jej w niepełnej wysokości, niniejsza deklaracja stanowi podstawę do wystawienia tytułu wykonawczego, zgodnie z przepisami ustawy z dnia 17 czerwca 1966 r. o postępowaniu egzekucyjnym w administracji (Dz.U. z 2005 r. Nr 229, poz.1954, z późn. zm.).</Pouczenie><%} %>		
	<Oswiadczenie>Oświadczam, że są mi znane przepisy Kodeksu karnego skarbowego o odpowiedzialności za podanie danych niezgodnych z rzeczywistością.</Oswiadczenie>	
	<Zalaczniki>
		<ea:Section ID="VAT_ZT" runat="server"><Wniosek_VAT-ZT xsi:noNamespaceSchemaLocation="http://e-deklaracje.mf.gov.pl/Repozytorium/Deklaracje/VAT/Zalaczniki/VAT-ZT(5)_v1-0.xsd" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:usr="urn:the-xml-files:xslt" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
				<Naglowek>
							<KodFormularza kodSystemowy="VAT-ZT (5)">VAT-ZT</KodFormularza>
							<WariantFormularza>5</WariantFormularza>
				</Naglowek>
				<PozycjeSzczegolowe>
						<P_10><ea:XmlDataLabel runat="server" DataMember="VATZT_Kwota" XSDType="TKwotaC"/></P_10>
						<P_11><ea:XmlDataLabel runat="server" DataMember="VATZT_Tresc" XSDType="TTekstowy"/></P_11>						
				</PozycjeSzczegolowe>
		</Wniosek_VAT-ZT></ea:Section>		
		<ea:Section ID="VAT_ZZ" runat="server"><Wniosek_VAT-ZZ xsi:noNamespaceSchemaLocation="http://e-deklaracje.mf.gov.pl/Repozytorium/Deklaracje/VAT/Zalaczniki/VAT-ZZ(5)_v1-0.xsd" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:usr="urn:the-xml-files:xslt" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
				<Naglowek>
							<KodFormularza kodSystemowy="VAT-ZZ (5)">VAT-ZZ</KodFormularza>
							<WariantFormularza>5</WariantFormularza>
				</Naglowek>
				<PozycjeSzczegolowe>
						<P_8><ea:XmlDataLabel runat="server" DataMember="VATZZ_PowodZwrotu_Int"/></P_8>				
						<P_9><ea:XmlDataLabel runat="server" DataMember="VATZZ_Kwota" XSDType="TKwotaC"/></P_9>
						<P_10><ea:XmlDataLabel runat="server" DataMember="VATZZ_Tresc" XSDType="TTekstowy"/></P_10>						
				</PozycjeSzczegolowe>
		</Wniosek_VAT-ZZ></ea:Section>				
		<ea:Section ID="NAD_ZP" runat="server"><Wniosek_NAD-ZP xsi:noNamespaceSchemaLocation="http://e-deklaracje.mf.gov.pl/Repozytorium/Deklaracje/VAT/Zalaczniki/NAD-ZP(2)_v1-0.xsd" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:usr="urn:the-xml-files:xslt" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
				<Naglowek>
							<KodFormularza kodSystemowy="NAD-ZP (2)">NAD-ZP</KodFormularza>
							<WariantFormularza>2</WariantFormularza>
				</Naglowek>
				<PozycjeSzczegolowe>
						<P_8><ea:XmlDataLabel runat="server" DataMember="NADZP_Kwota" XSDType="TKwotaC"/></P_8>
						<P_9><ea:XmlDataLabel runat="server" DataMember="NADZP_Tresc" XSDType="TTekstowy"/></P_9>						
				</PozycjeSzczegolowe>
		</Wniosek_NAD-ZP></ea:Section>
		<ea:Section ID="ORD_ZU" runat="server"><Zalacznik_ORD-ZU xsi:noNamespaceSchemaLocation="http://e-deklaracje.mf.gov.pl/Repozytorium/Deklaracje/ZalacznikiOgolne/ORD-ZU(2)_v1-0.xsd" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:usr="urn:the-xml-files:xslt" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
				<Naglowek>
							<KodFormularza kodSystemowy="ORD-ZU (2)">ORD-ZU</KodFormularza>
							<WariantFormularza>2</WariantFormularza>
				</Naglowek>
				<PozycjeSzczegolowe>
						<P_13><ea:XmlDataLabel ID="XmlDataLabel12" runat="server" DataMember="TreśćUzasadnienia" XSDType="TTekstowy"/></P_13>
				</PozycjeSzczegolowe>
		</Zalacznik_ORD-ZU></ea:Section>
	</Zalaczniki>	
</Deklaracja>
