﻿<%@ Page Language="C#" AutoEventWireup="false" CodePage="1200" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Deklaracje" %>
<script runat="server">
	Soneta.Deklaracje.VAT.VAT7_14 dek = null;
	
	void OnContextLoad(Object sender, EventArgs args) {
		dek = (Soneta.Deklaracje.VAT.VAT7_14)dc[typeof(Soneta.Deklaracje.VAT.VAT7_14)];
		ORD_ZU.Visible = dek.TreśćUzasadnienia != "";
		VAT_ZT.Visible = dek.VATZT_Visible;
		VAT_ZZ.Visible = dek.VATZZ_Visible;
		NAD_ZP.Visible = dek.NADZP_Visible;
        VAT_ZD.Visible = dek.VATZD_Visible;
        ZAL.Visible = ORD_ZU.Visible || VAT_ZT.Visible || VAT_ZZ.Visible || NAD_ZP.Visible || VAT_ZD.Visible;

        if (VAT_ZD.Visible) {
            var agregacjaKorekt = new Soneta.Deklaracje.VAT.VAT7.AgregacjaZalacznikowVATZD(dek);
            VATZD_Elementy.DataSource = agregacjaKorekt.Elementy;
            VATZD_KorektaPodstawy.EditValue = agregacjaKorekt.RazemKwotaPodstawy;
            VATZD_KorektaPodatku.EditValue = agregacjaKorekt.RazemKwotaPodatku;
        }
          
		//Nagłówek
		if (dek.TypDeklaracjiVAT7==Soneta.Deklaracje.VAT.TypDeklaracjiVAT7.VAT7) {
			WariantFormularza.EditValue = 14;
			MiesiacKwartal.ElementName = "Miesiac";
			MiesiacKwartal.EditValue = dek.Bloki["0"]["Miesiąc"];
		} else if(dek.TypDeklaracjiVAT7==Soneta.Deklaracje.VAT.TypDeklaracjiVAT7.VAT7K){
			WariantFormularza.EditValue = 8;
			MiesiacKwartal.ElementName = "Kwartal";
			MiesiacKwartal.EditValue = dek.Okres.To.Quarter;
		} else if (dek.TypDeklaracjiVAT7 == Soneta.Deklaracje.VAT.TypDeklaracjiVAT7.VAT7D) {
			WariantFormularza.EditValue = 5;
			MiesiacKwartal.ElementName = "Kwartal";
			MiesiacKwartal.EditValue = dek.Okres.To.Quarter;
		}
		
		string[] nazwa = Soneta.Deklaracje.PIT.PIT.DaneFirmy((string)dek.Bloki["B1"]["Nazwa"], (bool)dek.Bloki["B1"]["OsobaFiz"]);
		if((bool)dek.Bloki["B1"]["OsobaFiz"]){
			OsobaNieFizyczna.Visible = false;
			if (nazwa.Length > 0)
				Nazwisko.EditValue = nazwa[0].Trim();
			if (nazwa.Length > 1)
				ImiePiersze.EditValue = nazwa[1].Trim();
			if (nazwa.Length > 2)
				DataUrodzenia.EditValue = nazwa[2].Trim();
      if (nazwa.Length > 3)
        PESEL.EditValue = nazwa[3].Trim();						      
		}else{
			OsobaFizyczna.Visible = false;
			if (nazwa.Length > 0)
				NazwaPelna.EditValue = nazwa[0].Trim();
			if (nazwa.Length > 1)
				REGON.EditValue = nazwa[1].Trim();			
		}


    if ((decimal)dek.Bloki["C"]["3%Netto"] == 0 && (decimal)dek.Bloki["C"]["3%VAT"] == 0)
      S_15_16.Visible = false;
    if ((decimal)dek.Bloki["C"]["7%Netto"] == 0 && (decimal)dek.Bloki["C"]["7%VAT"] == 0)
      S_17_18.Visible = false;    
    if ((decimal)dek.Bloki["C"]["22%Netto"] == 0 && (decimal)dek.Bloki["C"]["22%VAT"] == 0)
      S_19_20.Visible = false;
    if ((decimal)dek.Bloki["C"]["UniaNabycieNetto"] == 0 && (decimal)dek.Bloki["C"]["UniaNabycieVAT"] == 0)
      S_23_24.Visible = false;      
    if ((decimal)dek.Bloki["DOD"]["ImportTowarowNetto"] == 0 && (decimal)dek.Bloki["DOD"]["ImportTowarowVAT"] == 0)
      S_25_26.Visible = false;
    if ((decimal)dek.Bloki["C"]["ImportUslugNetto"] == 0 && (decimal)dek.Bloki["C"]["ImportUslugVAT"] == 0)
      S_27_28.Visible = false;
    if ((decimal)dek.Bloki["C"]["ImportUslugNettoUnia"] == 0 && (decimal)dek.Bloki["C"]["ImportUslugVATUnia"] == 0)
      S_29_30.Visible = false;
    if ((decimal)dek.Bloki["C"]["DostawaTowarowNetto"] == 0 && (decimal)dek.Bloki["C"]["DostawaTowarowVAT"] == 0)
      S_31_32.Visible = false;
    if ((decimal)dek.Bloki["D2"]["SrodkiTrwaleNetto"] == 0 && (decimal)dek.Bloki["D2"]["SrodkiTrwaleVAT"] == 0)
      S_39_40.Visible = false;
	if ((decimal)dek.Bloki["D2"]["PozostaleNetto"] == 0 && (decimal)dek.Bloki["D2"]["PozostaleVAT"] == 0)
		S_41_42.Visible = false;
    if (!(bool)dek.Bloki["DOD"]["G_ZawiadomienieKorektaNaleznego"])
        S_63_64.Visible = S_70_71.Visible = false;
    
    
	}
	
</script>
<ea:datacontext id="dc" runat="server" TypeName="Soneta.Deklaracje.VAT.VAT7_14,Soneta.Deklaracje" OnContextLoad="OnContextLoad"></ea:datacontext>
<?xml version="1.0" encoding="UTF-8"?>
<%if (dek.TypDeklaracjiVAT7==Soneta.Deklaracje.VAT.TypDeklaracjiVAT7.VAT7) {
%><Deklaracja 
	xmlns="http://crd.gov.pl/wzor/2013/04/09/1113/" 
	xmlns:etd="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2011/06/21/eD/DefinicjeTypy/"
	xmlns:vzz="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2012/08/28/eD/VATZZ/" 
	xmlns:vzt="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2012/08/28/eD/VATZT/" 
    xmlns:vzd="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2013/01/10/eD/VATZD/"
	xmlns:zzu="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2011/10/07/eD/ORDZU/">
	<Naglowek>
		<KodFormularza kodSystemowy="VAT-7 (14)" kodPodatku="VAT" rodzajZobowiazania="Z" wersjaSchemy="1-0E">VAT-7</KodFormularza><%}
else if (dek.TypDeklaracjiVAT7==Soneta.Deklaracje.VAT.TypDeklaracjiVAT7.VAT7K)  {
%><Deklaracja 
	xmlns="http://crd.gov.pl/wzor/2013/04/09/1114/"
	xmlns:etd="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2011/06/21/eD/DefinicjeTypy/"
	xmlns:vzz="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2012/08/28/eD/VATZZ/" 
	xmlns:vzt="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2012/08/28/eD/VATZT/" 
    xmlns:vzd="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2013/01/10/eD/VATZD/"
	xmlns:zzu="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2011/10/07/eD/ORDZU/">
	<Naglowek>
		<KodFormularza kodSystemowy="VAT-7K (8)" kodPodatku="VAT" rodzajZobowiazania="Z" wersjaSchemy="1-0E">VAT-7K</KodFormularza><%} 
else if (dek.TypDeklaracjiVAT7==Soneta.Deklaracje.VAT.TypDeklaracjiVAT7.VAT7D)  {
%><Deklaracja 
	xmlns="http://crd.gov.pl/wzor/2013/04/09/1112/"
	xmlns:etd="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2011/06/21/eD/DefinicjeTypy/"
	xmlns:vzz="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2012/08/28/eD/VATZZ/"
	xmlns:vzt="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2012/08/28/eD/VATZT/"
	xmlns:znzp="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2012/08/28/eD/NADZP/"
    xmlns:vzd="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2013/01/10/eD/VATZD/"
	xmlns:zzu="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2011/10/07/eD/ORDZU/">
	<Naglowek>
		<KodFormularza kodSystemowy="VAT-7D (5)" kodPodatku="VAT" rodzajZobowiazania="Z" wersjaSchemy="1-0E">VAT-7D</KodFormularza>
<%} %>			
		<ea:XmlDataLabel ID="WariantFormularza" ElementName="WariantFormularza" runat="server"></ea:XmlDataLabel>		
		<CelZlozenia poz="P_7"><ea:XmlDataLabel ID="DataLabel1" runat="server" DataMember="A.Korekta"><ValuesMap><ea:ValuesPair Key="False" Value="1" /><ea:ValuesPair Key="True" Value="2"/></ValuesMap></ea:XmlDataLabel></CelZlozenia>
		<Rok><ea:XmlDataLabel ID="DataLabel2" runat="server" DataMember="0.Rok"></ea:XmlDataLabel></Rok>
		<ea:XmlDataLabel ID="MiesiacKwartal" runat="server"></ea:XmlDataLabel>
		<KodUrzedu><ea:XmlDataLabel ID="DataLabel4" runat="server" DataMember="DOD.KodUrzeduSkarbowego"></ea:XmlDataLabel></KodUrzedu>
	</Naglowek>
	<Podmiot1 rola="Podatnik">
		<ea:Section ID="OsobaFizyczna" runat="server"><etd:OsobaFizyczna>
			<ea:XmlDataLabel ID="XmlDataLabel1" runat="server" ElementName="etd:NIP" DataMember="0.Nip" XSDType="TNrNIP"></ea:XmlDataLabel>
			<etd:ImiePierwsze><ea:XmlDataLabel ID="ImiePiersze" runat="server" XSDType="TImie"></ea:XmlDataLabel></etd:ImiePierwsze>
			<etd:Nazwisko><ea:XmlDataLabel ID="Nazwisko" runat="server" XSDType="TNazwisko"></ea:XmlDataLabel></etd:Nazwisko>
			<etd:DataUrodzenia><ea:XmlDataLabel ID="DataUrodzenia" runat="server" XSDType="TData"></ea:XmlDataLabel></etd:DataUrodzenia>
      <ea:XmlDataLabel ID="PESEL" runat="server" ElementName="etd:PESEL" HideEmptyOrZero="true"></ea:XmlDataLabel>
        </etd:OsobaFizyczna></ea:Section>
		<ea:Section ID="OsobaNieFizyczna" runat="server"><etd:OsobaNiefizyczna>
			<ea:XmlDataLabel ID="XmlDataLabel2" runat="server" ElementName="etd:NIP" DataMember="0.Nip" XSDType="TNrNIP"></ea:XmlDataLabel>
			<etd:PelnaNazwa><ea:XmlDataLabel ID="NazwaPelna" runat="server" XSDType="TZnakowy"></ea:XmlDataLabel></etd:PelnaNazwa>
			<ea:XmlDataLabel ID="REGON" runat="server" ElementName="etd:REGON" XSDType="TNrREGON" HideEmptyOrZero="true"></ea:XmlDataLabel>
		</etd:OsobaNiefizyczna></ea:Section>
	</Podmiot1>	
	<PozycjeSzczegolowe>
		<ea:XmlDataLabel ElementName="P_10" ID="DataLabel5" runat="server" DataMember="C.Zwolnione" HideEmptyOrZero="true" XSDType="TKwotaC"></ea:XmlDataLabel>
		<ea:XmlDataLabel ElementName="P_11" ID="DataLabel6" runat="server" DataMember="C.DostawaPozaKrajem" HideEmptyOrZero="true" XSDType="TKwotaC"></ea:XmlDataLabel>
		<ea:XmlDataLabel ElementName="P_12" ID="DataLabel47" runat="server" DataMember="C.DostawaPozaKrajemUslugiUnia" HideEmptyOrZero="true" XSDType="TKwotaC"></ea:XmlDataLabel>
		<ea:XmlDataLabel ElementName="P_13" ID="DataLabel7" runat="server" DataMember="C.0%Netto" HideEmptyOrZero="true" XSDType="TKwotaC"></ea:XmlDataLabel>
		<ea:XmlDataLabel ElementName="P_14" ID="DataLabel8" runat="server" DataMember="C.0%NettoArt129" HideEmptyOrZero="true" XSDType="TKwotaC"></ea:XmlDataLabel>
    <ea:Section ID="S_15_16" runat="server">
		  <ea:XmlDataLabel ElementName="P_15" ID="DataLabel9" runat="server" DataMember="C.3%Netto" XSDType="TKwotaC"></ea:XmlDataLabel>
		  <ea:XmlDataLabel ElementName="P_16" ID="DataLabel10" runat="server" DataMember="C.3%VAT" XSDType="TKwotaC"></ea:XmlDataLabel>
    </ea:Section>
    <ea:Section ID="S_17_18" runat="server">
		  <ea:XmlDataLabel ElementName="P_17" ID="DataLabel11" runat="server" DataMember="C.7%Netto" XSDType="TKwotaC"></ea:XmlDataLabel>
		  <ea:XmlDataLabel ElementName="P_18" ID="DataLabel12" runat="server" DataMember="C.7%VAT" XSDType="TKwotaC"></ea:XmlDataLabel>
    </ea:Section>
    <ea:Section ID="S_19_20" runat="server">
		  <ea:XmlDataLabel ElementName="P_19" ID="DataLabel13" runat="server" DataMember="C.22%Netto" XSDType="TKwotaC"></ea:XmlDataLabel>
		  <ea:XmlDataLabel ElementName="P_20" ID="DataLabel14" runat="server" DataMember="C.22%VAT" XSDType="TKwotaC"></ea:XmlDataLabel>
    </ea:Section>
		<ea:XmlDataLabel ElementName="P_21" ID="DataLabel15" runat="server" DataMember="C.UniaDostawa" HideEmptyOrZero="true" XSDType="TKwotaC"></ea:XmlDataLabel>
		<ea:XmlDataLabel ElementName="P_22" ID="DataLabel16" runat="server" DataMember="C.Eksport" HideEmptyOrZero="true" XSDType="TKwotaC"></ea:XmlDataLabel>
    <ea:Section ID="S_23_24" runat="server">
		  <ea:XmlDataLabel ElementName="P_23" ID="DataLabel17" runat="server" DataMember="C.UniaNabycieNetto" XSDType="TKwotaC"></ea:XmlDataLabel>
		  <ea:XmlDataLabel ElementName="P_24" ID="DataLabel18" runat="server" DataMember="C.UniaNabycieVAT" XSDType="TKwotaC"></ea:XmlDataLabel>
    </ea:Section>
    <ea:Section ID="S_25_26" runat="server">
		  <ea:XmlDataLabel ElementName="P_25" ID="XmlDataLabel13" runat="server" DataMember="DOD.ImportTowarowNetto" XSDType="TKwotaC"></ea:XmlDataLabel>
		  <ea:XmlDataLabel ElementName="P_26" ID="XmlDataLabel14" runat="server" DataMember="DOD.ImportTowarowVAT" XSDType="TKwotaC"></ea:XmlDataLabel>
    </ea:Section>
    <ea:Section ID="S_27_28" runat="server">
		  <ea:XmlDataLabel ElementName="P_27" ID="DataLabel19" runat="server" DataMember="C.ImportUslugNetto" XSDType="TKwotaC"></ea:XmlDataLabel>
		  <ea:XmlDataLabel ElementName="P_28" ID="DataLabel20" runat="server" DataMember="C.ImportUslugVAT" XSDType="TKwotaC"></ea:XmlDataLabel>
    </ea:Section>
    <ea:Section ID="S_29_30" runat="server">
		  <ea:XmlDataLabel ElementName="P_29" ID="DataLabel48" runat="server" DataMember="C.ImportUslugNettoUnia" XSDType="TKwotaC"></ea:XmlDataLabel>
		  <ea:XmlDataLabel ElementName="P_30" ID="DataLabel49" runat="server" DataMember="C.ImportUslugVATUnia" XSDType="TKwotaC"></ea:XmlDataLabel>
    </ea:Section>
    <ea:Section ID="S_31_32" runat="server">
		  <ea:XmlDataLabel ElementName="P_31" ID="DataLabel21" runat="server" DataMember="C.DostawaTowarowNetto" XSDType="TKwotaC"></ea:XmlDataLabel>
		  <ea:XmlDataLabel ElementName="P_32" ID="DataLabel22" runat="server" DataMember="C.DostawaTowarowVAT" XSDType="TKwotaC"></ea:XmlDataLabel>
    </ea:Section>
		<ea:XmlDataLabel ElementName="P_33" ID="DataLabel23" runat="server" DataMember="C.Spis" HideEmptyOrZero="true" XSDType="TKwotaC"></ea:XmlDataLabel>
		<ea:XmlDataLabel ElementName="P_34" ID="DataLabel24" runat="server" DataMember="C.SrodkiTransportu" HideEmptyOrZero="true" XSDType="TKwotaC"></ea:XmlDataLabel>
		<ea:XmlDataLabel ElementName="P_35" ID="DataLabel25" runat="server" DataMember="C.Netto" XSDType="TKwotaC"></ea:XmlDataLabel>
		<ea:XmlDataLabel ElementName="P_36" ID="DataLabel26" runat="server" DataMember="C.VAT" XSDType="TKwotaC"></ea:XmlDataLabel>
		<ea:XmlDataLabel ElementName="P_37" ID="DataLabel27" runat="server" DataMember="D1.Nadwyzka" HideEmptyOrZero="true" XSDType="TKwotaC"></ea:XmlDataLabel>
		<ea:XmlDataLabel ElementName="P_38" ID="DataLabel28" runat="server" DataMember="D1.Spis" HideEmptyOrZero="true" XSDType="TKwotaC"></ea:XmlDataLabel>
	<ea:Section ID="S_39_40" runat="server">
		<ea:XmlDataLabel ElementName="P_39" ID="DataLabel29" runat="server" DataMember="D2.SrodkiTrwaleNetto" XSDType="TKwotaC"></ea:XmlDataLabel>
		<ea:XmlDataLabel ElementName="P_40" ID="DataLabel30" runat="server" DataMember="D2.SrodkiTrwaleVAT" XSDType="TKwotaC"></ea:XmlDataLabel>
	</ea:Section>
	<ea:Section ID="S_41_42" runat="server">
		<ea:XmlDataLabel ElementName="P_41" ID="DataLabel31" runat="server" DataMember="D2.PozostaleNetto" XSDType="TKwotaC"></ea:XmlDataLabel>
		<ea:XmlDataLabel ElementName="P_42" ID="DataLabel32" runat="server" DataMember="D2.PozostaleVAT" XSDType="TKwotaC"></ea:XmlDataLabel>
	</ea:Section>
		<ea:XmlDataLabel ElementName="P_43" ID="DataLabel33" runat="server" DataMember="D3.SrodkiTrwale" HideEmptyOrZero="true" XSDType="TKwotaC"></ea:XmlDataLabel>
		<ea:XmlDataLabel ElementName="P_44" ID="DataLabel34" runat="server" DataMember="D3.Pozostale" HideEmptyOrZero="true" XSDType="TKwotaC"></ea:XmlDataLabel>
		<ea:XmlDataLabel ElementName="P_45" ID="DataLabel35" runat="server" DataMember="D3.Razem" XSDType="TKwotaC"></ea:XmlDataLabel>
		<ea:XmlDataLabel ElementName="P_46" ID="DataLabel36" runat="server" DataMember="E.KasyOdliczenia" HideEmptyOrZero="true" XSDType="TKwotaC"></ea:XmlDataLabel>
		<ea:XmlDataLabel ElementName="P_47" ID="DataLabel37" runat="server" DataMember="E.Zaniechanie" HideEmptyOrZero="true" XSDType="TKwotaC"></ea:XmlDataLabel>
		<ea:XmlDataLabel ElementName="P_48" ID="DataLabel38" runat="server" DataMember="E.DoZaplaty" XSDType="TKwotaC"></ea:XmlDataLabel>
<%if (dek.TypDeklaracjiVAT7 == Soneta.Deklaracje.VAT.TypDeklaracjiVAT7.VAT7D) {
%>	<ea:XmlDataLabel ElementName="P_49" ID="XmlDataLabel33" runat="server" DataMember="DOD.SumaZaliczekZaKwartal" XSDType="TKwotaC"></ea:XmlDataLabel>
		<ea:XmlDataLabel ElementName="P_50" ID="XmlDataLabel34" runat="server" DataMember="DOD.NadplataZaPoprzedniKwartal" HideEmptyOrZero="true" XSDType="TKwotaC"></ea:XmlDataLabel>
		<ea:XmlDataLabel ElementName="P_51" ID="XmlDataLabel35" runat="server" DataMember="DOD.DoZaplatyZaliczki" XSDType="TKwotaC"></ea:XmlDataLabel>
<%if ((decimal)dek.Bloki["DOD"]["NadplataZaliczki"]>0) {
%>	<ea:XmlDataLabel ElementName="P_52" ID="XmlDataLabel36" runat="server" DataMember="DOD.NadplataZaliczki" XSDType="TKwotaC"></ea:XmlDataLabel>
		<ea:XmlDataLabel ElementName="P_53" ID="XmlDataLabel38" runat="server" DataMember="DOD.NadplataNaPrzyszle"><ValuesMap><ea:ValuesPair Key="True" Value="1" /><ea:ValuesPair Key="False" Value="2"/></ValuesMap></ea:XmlDataLabel>
		<ea:XmlDataLabel ElementName="P_54" ID="XmlDataLabel37" runat="server" DataMember="DOD.NadplataNaPrzyszleKwota" XSDType="TKwotaC"></ea:XmlDataLabel>
<%}
%>	<ea:XmlDataLabel ElementName="P_55" ID="DataLabel39" runat="server" DataMember="E.KasyZwrot" HideEmptyOrZero="true" XSDType="TKwotaC"></ea:XmlDataLabel>
		<ea:XmlDataLabel ElementName="P_56" ID="DataLabel40" runat="server" DataMember="E.DoZwrotu" XSDType="TKwotaC"></ea:XmlDataLabel>
		<ea:XmlDataLabel ElementName="P_57" ID="DataLabel41" runat="server" DataMember="E.NaKonto" XSDType="TKwotaC"></ea:XmlDataLabel>
		<ea:XmlDataLabel ElementName="P_58" ID="XmlDataLabel15" runat="server" DataMember="DOD.NaKonto25" HideEmptyOrZero="true" XSDType="TKwotaC"></ea:XmlDataLabel>
		<ea:XmlDataLabel ElementName="P_59" ID="DataLabel42" runat="server" DataMember="E.NaKonto60" HideEmptyOrZero="true" XSDType="TKwotaC"></ea:XmlDataLabel>
		<ea:XmlDataLabel ElementName="P_60" ID="DataLabel43" runat="server" DataMember="E.NaKonto180" HideEmptyOrZero="true" XSDType="TKwotaC"></ea:XmlDataLabel>
		<ea:XmlDataLabel ElementName="P_61" ID="DataLabel44" runat="server" DataMember="E.DoPrzeniesienia" XSDType="TKwotaC"></ea:XmlDataLabel>
		<ea:XmlDataLabel ElementName="P_62" ID="XmlDataLabel16" runat="server" DataMember="F.Czynnosc1" HideEmptyOrZero="true"><ValuesMap><ea:ValuesPair Key="True" Value="1" /><ea:ValuesPair Key="False" Value="0"/></ValuesMap></ea:XmlDataLabel>		
		<ea:XmlDataLabel ElementName="P_63" ID="XmlDataLabel17" runat="server" DataMember="F.Czynnosc2" HideEmptyOrZero="true"><ValuesMap><ea:ValuesPair Key="True" Value="1" /><ea:ValuesPair Key="False" Value="0"/></ValuesMap></ea:XmlDataLabel>		
		<ea:XmlDataLabel ElementName="P_64" ID="XmlDataLabel18" runat="server" DataMember="F.Czynnosc3" HideEmptyOrZero="true"><ValuesMap><ea:ValuesPair Key="True" Value="1" /><ea:ValuesPair Key="False" Value="0"/></ValuesMap></ea:XmlDataLabel>		
		<ea:XmlDataLabel ElementName="P_65" ID="XmlDataLabel19" runat="server" DataMember="F.Czynnosc4" HideEmptyOrZero="true"><ValuesMap><ea:ValuesPair Key="True" Value="1" /><ea:ValuesPair Key="False" Value="0"/></ValuesMap></ea:XmlDataLabel>
        <ea:XmlDataLabel ElementName="P_66" ID="XmlDataLabel40" runat="server" DataMember="DOD.F_ZwiększenieNaliczonego" HideEmptyOrZero="true"><ValuesMap><ea:ValuesPair Key="True" Value="1" /><ea:ValuesPair Key="False" Value="2"/></ValuesMap></ea:XmlDataLabel>
		<ea:XmlDataLabel ElementName="P_67" ID="DataLabel45" runat="server" DataMember="G.Zwrot" HideEmptyOrZero="true"><ValuesMap><ea:ValuesPair Key="True" Value="1" /><ea:ValuesPair Key="False" Value="0"/></ValuesMap></ea:XmlDataLabel>
		<ea:XmlDataLabel ElementName="P_68" ID="DataLabel46" runat="server" DataMember="G.Przyspieszenie" HideEmptyOrZero="true"><ValuesMap><ea:ValuesPair Key="True" Value="1" /><ea:ValuesPair Key="False" Value="0"/></ValuesMap></ea:XmlDataLabel>
		<ea:XmlDataLabel ElementName="P_69" ID="DataLabel50" runat="server" DataMember="DOD.WniosekZaliczenieNadplaty" HideEmptyOrZero="true"><ValuesMap><ea:ValuesPair Key="True" Value="1" /><ea:ValuesPair Key="False" Value="0"/></ValuesMap></ea:XmlDataLabel>
        <ea:Section ID="S_70_71" runat="server">
    		<ea:XmlDataLabel ElementName="P_70" ID="XmlDataLabel43" runat="server" DataMember="DOD.G_ZawiadomienieKorektaNaleznego" HideEmptyOrZero="true"><ValuesMap><ea:ValuesPair Key="True" Value="1" /><ea:ValuesPair Key="False" Value="0"/></ValuesMap></ea:XmlDataLabel>
        </ea:Section>
        <ea:XmlDataLabel ElementName="P_75" ID="XmlDataLabel5" runat="server" DataMember="H.Telefon" XSDType="TZnakowy" HideEmptyOrZero="true"></ea:XmlDataLabel>
        <ea:XmlDataLabel ElementName="P_76" ID="XmlDataLabel6" runat="server" DataMember="H.Data" XSDType="TData"></ea:XmlDataLabel>
<%} else {
%>	<ea:XmlDataLabel ElementName="P_49" ID="XmlDataLabel20" runat="server" DataMember="E.KasyZwrot" HideEmptyOrZero="true" XSDType="TKwotaC"></ea:XmlDataLabel>
		<ea:XmlDataLabel ElementName="P_50" ID="XmlDataLabel21" runat="server" DataMember="E.DoZwrotu" XSDType="TKwotaC"></ea:XmlDataLabel>
		<ea:XmlDataLabel ElementName="P_51" ID="XmlDataLabel22" runat="server" DataMember="E.NaKonto" XSDType="TKwotaC"></ea:XmlDataLabel>
		<ea:XmlDataLabel ElementName="P_52" ID="XmlDataLabel23" runat="server" DataMember="DOD.NaKonto25" HideEmptyOrZero="true" XSDType="TKwotaC"></ea:XmlDataLabel>
		<ea:XmlDataLabel ElementName="P_53" ID="XmlDataLabel24" runat="server" DataMember="E.NaKonto60" HideEmptyOrZero="true" XSDType="TKwotaC"></ea:XmlDataLabel>
		<ea:XmlDataLabel ElementName="P_54" ID="XmlDataLabel25" runat="server" DataMember="E.NaKonto180" HideEmptyOrZero="true" XSDType="TKwotaC"></ea:XmlDataLabel>
		<ea:XmlDataLabel ElementName="P_55" ID="XmlDataLabel26" runat="server" DataMember="E.DoPrzeniesienia" XSDType="TKwotaC"></ea:XmlDataLabel>
		<ea:XmlDataLabel ElementName="P_56" ID="XmlDataLabel27" runat="server" DataMember="F.Czynnosc1" HideEmptyOrZero="true"><ValuesMap><ea:ValuesPair Key="True" Value="1" /><ea:ValuesPair Key="False" Value="0"/></ValuesMap></ea:XmlDataLabel>		
		<ea:XmlDataLabel ElementName="P_57" ID="XmlDataLabel28" runat="server" DataMember="F.Czynnosc2" HideEmptyOrZero="true"><ValuesMap><ea:ValuesPair Key="True" Value="1" /><ea:ValuesPair Key="False" Value="0"/></ValuesMap></ea:XmlDataLabel>		
		<ea:XmlDataLabel ElementName="P_58" ID="XmlDataLabel29" runat="server" DataMember="F.Czynnosc3" HideEmptyOrZero="true"><ValuesMap><ea:ValuesPair Key="True" Value="1" /><ea:ValuesPair Key="False" Value="0"/></ValuesMap></ea:XmlDataLabel>		
		<ea:XmlDataLabel ElementName="P_59" ID="XmlDataLabel30" runat="server" DataMember="F.Czynnosc4" HideEmptyOrZero="true"><ValuesMap><ea:ValuesPair Key="True" Value="1" /><ea:ValuesPair Key="False" Value="0"/></ValuesMap></ea:XmlDataLabel>						
		<ea:XmlDataLabel ElementName="P_60" ID="XmlDataLabel39" runat="server" DataMember="DOD.F_ZwiększenieNaliczonego" HideEmptyOrZero="true"><ValuesMap><ea:ValuesPair Key="True" Value="1" /><ea:ValuesPair Key="False" Value="2"/></ValuesMap></ea:XmlDataLabel>
		<ea:XmlDataLabel ElementName="P_61" ID="XmlDataLabel31" runat="server" DataMember="G.Zwrot" HideEmptyOrZero="true"><ValuesMap><ea:ValuesPair Key="True" Value="1" /><ea:ValuesPair Key="False" Value="0"/></ValuesMap></ea:XmlDataLabel>
		<ea:XmlDataLabel ElementName="P_62" ID="XmlDataLabel32" runat="server" DataMember="G.Przyspieszenie" HideEmptyOrZero="true"><ValuesMap><ea:ValuesPair Key="True" Value="1" /><ea:ValuesPair Key="False" Value="0"/></ValuesMap></ea:XmlDataLabel>
        <ea:Section ID="S_63_64" runat="server">
    		<ea:XmlDataLabel ElementName="P_63" ID="XmlDataLabel41" runat="server" DataMember="DOD.G_ZawiadomienieKorektaNaleznego" HideEmptyOrZero="true"><ValuesMap><ea:ValuesPair Key="True" Value="1" /><ea:ValuesPair Key="False" Value="0"/></ValuesMap></ea:XmlDataLabel>
        </ea:Section>
        <ea:XmlDataLabel ElementName="P_68" ID="XmlDataLabel3" runat="server" DataMember="H.Telefon" XSDType="TZnakowy" HideEmptyOrZero="true"></ea:XmlDataLabel>
        <ea:XmlDataLabel ElementName="P_69" ID="XmlDataLabel4" runat="server" DataMember="H.Data" XSDType="TData"></ea:XmlDataLabel>
<%} %>		
	</PozycjeSzczegolowe>
<%if (dek.TypDeklaracjiVAT7 == Soneta.Deklaracje.VAT.TypDeklaracjiVAT7.VAT7D) {
%><Pouczenie>W przypadku niewpłacenia w obowiązującym terminie kwoty z poz.51 lub wpłacenia jej w niepełnej wysokości, niniejsza deklaracja stanowi podstawę do wystawienia tytułu wykonawczego, zgodnie z przepisami ustawy z dnia 17 czerwca 1966 r. o postępowaniu egzekucyjnym w administracji (Dz.U. z 2012 r. poz.1015, z późn. zm.).</Pouczenie>
<%} else if (dek.TypDeklaracjiVAT7 == Soneta.Deklaracje.VAT.TypDeklaracjiVAT7.VAT7K) {
%><Pouczenie>W przypadku niewpłacenia w obowiązującym terminie kwoty z poz.48 lub wpłacenia jej w niepełnej wysokości, niniejsza deklaracja stanowi podstawę do wystawienia tytułu wykonawczego, zgodnie z przepisami ustawy z dnia 17 czerwca 1966 r. o postępowaniu egzekucyjnym w administracji (Dz.U. z 2012 r. poz. 1015, z późn. zm.).</Pouczenie>
<%} else if (dek.TypDeklaracjiVAT7 == Soneta.Deklaracje.VAT.TypDeklaracjiVAT7.VAT7) {
%><Pouczenie>W przypadku niewpłacenia w obowiązującym terminie kwoty z poz.48 lub wpłacenia jej w niepełnej wysokości, niniejsza deklaracja stanowi podstawę do wystawienia tytułu wykonawczego, zgodnie z przepisami ustawy z dnia 17 czerwca 1966 r. o postępowaniu egzekucyjnym w administracji (Dz.U. z 2012 r. poz. 1015, z późn. zm.).</Pouczenie><%} %>		
	<Oswiadczenie>Oświadczam, że są mi znane przepisy Kodeksu karnego skarbowego o odpowiedzialności za podanie danych niezgodnych z rzeczywistością.</Oswiadczenie>	
	<ea:Section ID="ZAL" runat="server"><Zalaczniki>
		<ea:Section ID="VAT_ZZ" runat="server">
			<vzz:Wniosek_VAT-ZZ>
				<vzz:Naglowek>
							<vzz:KodFormularza kodSystemowy="VAT-ZZ (5)" wersjaSchemy="1-0E">VAT-ZZ</vzz:KodFormularza>
							<vzz:WariantFormularza>5</vzz:WariantFormularza>
				</vzz:Naglowek>
				<vzz:PozycjeSzczegolowe>
						<vzz:P_8><ea:XmlDataLabel runat="server" DataMember="VATZZ_PowodZwrotu_Int"/></vzz:P_8>				
						<vzz:P_9><ea:XmlDataLabel runat="server" DataMember="VATZZ_Kwota" XSDType="TKwotaC"/></vzz:P_9>
						<vzz:P_10><ea:XmlDataLabel runat="server" DataMember="VATZZ_Tresc" XSDType="TTekstowy"/></vzz:P_10>						
				</vzz:PozycjeSzczegolowe>
		</vzz:Wniosek_VAT-ZZ></ea:Section>				
		<ea:Section ID="VAT_ZT" runat="server">
			<vzt:Wniosek_VAT-ZT>
				<vzt:Naglowek>
							<vzt:KodFormularza kodSystemowy="VAT-ZT (5)" wersjaSchemy="1-0E">VAT-ZT</vzt:KodFormularza>
							<vzt:WariantFormularza>5</vzt:WariantFormularza>
				</vzt:Naglowek>
				<vzt:PozycjeSzczegolowe>
						<vzt:P_10><ea:XmlDataLabel runat="server" DataMember="VATZT_Kwota" XSDType="TKwotaC"/></vzt:P_10>
						<vzt:P_11><ea:XmlDataLabel runat="server" DataMember="VATZT_Tresc" XSDType="TTekstowy"/></vzt:P_11>						
				</vzt:PozycjeSzczegolowe>
		</vzt:Wniosek_VAT-ZT></ea:Section>		
		<ea:Section ID="NAD_ZP" runat="server">
			<znzp:Wniosek_NAD-ZP>
				<znzp:Naglowek>
							<znzp:KodFormularza kodSystemowy="NAD-ZP (2)" wersjaSchemy="1-0E">NAD-ZP</znzp:KodFormularza>
							<znzp:WariantFormularza>2</znzp:WariantFormularza>
				</znzp:Naglowek>
				<znzp:PozycjeSzczegolowe>
						<znzp:P_8><ea:XmlDataLabel runat="server" DataMember="NADZP_Kwota" XSDType="TKwotaC"/></znzp:P_8>
						<znzp:P_9><ea:XmlDataLabel runat="server" DataMember="NADZP_Tresc" XSDType="TTekstowy"/></znzp:P_9>						
				</znzp:PozycjeSzczegolowe>
		</znzp:Wniosek_NAD-ZP></ea:Section>
		<ea:Section ID="VAT_ZD" runat="server">
			<vzd:Wniosek_VAT-ZD>
				<vzd:Naglowek>
							<vzd:KodFormularza kodSystemowy="VAT-ZD (1)" wersjaSchemy="1-0E">VAT-ZD</vzd:KodFormularza>
							<vzd:WariantFormularza>1</vzd:WariantFormularza>
				</vzd:Naglowek>
				<vzd:PozycjeSzczegolowe>
                    <ea:DataRepeater ID="VATZD_Elementy" runat="server" WithSections="False">
                        <vzd:P_B typ="G">
                            <vzd:P_BB><ea:XmlDataLabel runat="server" DataMember="NazwaPodatnika" XSDType="TTekstowy"/></vzd:P_BB>
                            <vzd:P_BC><ea:XmlDataLabel runat="server" DataMember="NIP" XSDType="TNrNIP"/></vzd:P_BC>
                            <vzd:P_BD1><ea:XmlDataLabel runat="server" DataMember="NrFaktury" XSDType="TTekstowy"/></vzd:P_BD1>
                            <vzd:P_BD2><ea:XmlDataLabel runat="server" DataMember="DataWystawienia" XSDType="TData"/></vzd:P_BD2>
                            <vzd:P_BE><ea:XmlDataLabel runat="server" DataMember="TerminPlatnosci" XSDType="TData"/></vzd:P_BE>
                            <vzd:P_BF><ea:XmlDataLabel runat="server" DataMember="KorektaPodstawy" XSDType="TKwota2"/></vzd:P_BF>
                            <vzd:P_BG><ea:XmlDataLabel runat="server" DataMember="KorektaPodatku" XSDType="TKwota2"/></vzd:P_BG>
                        </vzd:P_B>
                    </ea:DataRepeater>
					<vzd:P_10><ea:XmlDataLabel ID="VATZD_KorektaPodstawy" runat="server" XSDType="TKwotaC"/></vzd:P_10>
					<vzd:P_11><ea:XmlDataLabel ID="VATZD_KorektaPodatku" runat="server" XSDType="TKwotaC"/></vzd:P_11>						
				</vzd:PozycjeSzczegolowe>
		</vzd:Wniosek_VAT-ZD></ea:Section>
		<ea:Section ID="ORD_ZU" runat="server">
			<zzu:Zalacznik_ORD-ZU>
				<zzu:Naglowek>
							<zzu:KodFormularza kodSystemowy="ORD-ZU (2)"  wersjaSchemy="2-0E">ORD-ZU</zzu:KodFormularza>
							<zzu:WariantFormularza>2</zzu:WariantFormularza>
				</zzu:Naglowek>
				<zzu:PozycjeSzczegolowe>
						<zzu:P_13><ea:XmlDataLabel ID="XmlDataLabel12" runat="server" DataMember="TreśćUzasadnienia" XSDType="TTekstowy"/></zzu:P_13>
				</zzu:PozycjeSzczegolowe>
		</zzu:Zalacznik_ORD-ZU></ea:Section>
	</Zalaczniki></ea:Section>
</Deklaracja>