﻿<%@ Page Language="C#" AutoEventWireup="false" CodePage="1200" %>

<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Deklaracje" %>


<script runat="server">
	Soneta.Deklaracje.VAT.VAT7_19 dek;

	void OnContextLoad(Object sender, EventArgs args)
	{
		dek = (Soneta.Deklaracje.VAT.VAT7_19)dc[typeof(Soneta.Deklaracje.VAT.VAT7_19)];

		ORD_ZU.Visible = dek.TreśćUzasadnienia != "";
		VAT_ZD.Visible = dek.VATZD_Visible;
		ZAL.Visible = ORD_ZU.Visible || VAT_ZD.Visible;

		if (VAT_ZD.Visible)
		{
			var agregacjaKorekt = new Soneta.Deklaracje.VAT.VAT7.AgregacjaZalacznikowVATZD(dek);
			VATZD_Elementy.DataSource = agregacjaKorekt.Elementy;
			VATZD_KorektaPodstawy.EditValue = agregacjaKorekt.RazemKwotaPodstawy;
			VATZD_KorektaPodatku.EditValue = agregacjaKorekt.RazemKwotaPodatku;
		}

		if (dek.TypDeklaracjiVAT7==Soneta.Deklaracje.VAT.TypDeklaracjiVAT7.VAT7)
		{
			WariantFormularza.EditValue = 19;
			MiesiacKwartal.ElementName = "Miesiac";
			MiesiacKwartal.EditValue = dek.Bloki["0"]["Miesiąc"];
		}
		else if (dek.TypDeklaracjiVAT7==Soneta.Deklaracje.VAT.TypDeklaracjiVAT7.VAT7K)
		{
			WariantFormularza.EditValue = 13;
			MiesiacKwartal.ElementName = "Kwartal";
			MiesiacKwartal.EditValue = dek.Okres.To.Quarter;
		}

		string[] nazwa = Soneta.Deklaracje.PIT.PIT.DaneFirmy((string)dek.Bloki["B1"]["Nazwa"], (bool)dek.Bloki["B1"]["OsobaFiz"]);
		if((bool)dek.Bloki["B1"]["OsobaFiz"])
		{
			OsobaNieFizyczna.Visible = false;
			if (nazwa.Length > 0)
				Nazwisko.EditValue = nazwa[0].Trim();
			if (nazwa.Length > 1)
				ImiePiersze.EditValue = nazwa[1].Trim();
			if (nazwa.Length > 2)
				DataUrodzenia.EditValue = nazwa[2].Trim();
		}
		else
		{
			OsobaFizyczna.Visible = false;
			if (nazwa.Length > 0)
				NazwaPelna.EditValue = nazwa[0].Trim();
		}


	if ((decimal)dek.Bloki["C"]["3%Netto"] == 0 && (decimal)dek.Bloki["C"]["3%VAT"] == 0)
	  S_15_16.Visible = false;
	if ((decimal)dek.Bloki["C"]["7%Netto"] == 0 && (decimal)dek.Bloki["C"]["7%VAT"] == 0)
	  S_17_18.Visible = false;
	if ((decimal)dek.Bloki["C"]["22%Netto"] == 0 && (decimal)dek.Bloki["C"]["22%VAT"] == 0)
	  S_19_20.Visible = false;
	if ((decimal)dek.Bloki["C"]["UniaNabycieNetto"] == 0 && (decimal)dek.Bloki["C"]["UniaNabycieVAT"] == 0)
	  S_23_24.Visible = false;
	if ((decimal)dek.Bloki["C"]["ImportTowarowNetto"] == 0 && (decimal)dek.Bloki["C"]["ImportTowarowVAT"] == 0)
	  S_25_26.Visible = false;
	if ((decimal)dek.Bloki["C"]["ImportUslugNettoNieUnia"] == 0 && (decimal)dek.Bloki["C"]["ImportUslugVATNieUnia"] == 0)
	  S_27_28.Visible = false;
	if ((decimal)dek.Bloki["C"]["ImportUslugNettoUnia"] == 0 && (decimal)dek.Bloki["C"]["ImportUslugVATUnia"] == 0)
	  S_29_30.Visible = false;
	if ((decimal)dek.Bloki["C"]["DostawaTowarowNettoZagranica"] == 0 && (decimal)dek.Bloki["C"]["DostawaTowarowVATZagranica"] == 0)
	  S_32_33.Visible = false;
	if ((decimal)dek.Bloki["C"]["DostawaTowarowNettoKraj"] == 0 && (decimal)dek.Bloki["C"]["DostawaTowarowVATKraj"] == 0)
	  S_34_35.Visible = false;
	if ((decimal)dek.Bloki["D2"]["SrodkiTrwaleNetto"] == 0 && (decimal)dek.Bloki["D2"]["SrodkiTrwaleVAT"] == 0)
	  S_42_43.Visible = false;
	if ((decimal)dek.Bloki["D2"]["PozostaleNetto"] == 0 && (decimal)dek.Bloki["D2"]["PozostaleVAT"] == 0)
	  S_44_45.Visible = false;

    if ((decimal)dek.Bloki["E"]["NaKontoVAT"] == 0)
      S_58_68.Visible = false;

    if ((decimal)dek.Bloki["E"]["NaKonto25"] == 0)
      S_59_70.Visible = false;
}
</script>


<ea:datacontext id="dc" runat="server" typename="Soneta.Deklaracje.VAT.VAT7_19,Soneta.Deklaracje" oncontextload="OnContextLoad" />
<?xml version="1.0" encoding="UTF-8" ?>
<%if (dek.TypDeklaracjiVAT7==Soneta.Deklaracje.VAT.TypDeklaracjiVAT7.VAT7) { %>
<Deklaracja
	xmlns="http://crd.gov.pl/wzor/2019/02/11/7013/"
	xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
	xsi:schemaLocation="http://crd.gov.pl/wzor/2019/02/11/7013/ http://crd.gov.pl/wzor/2019/02/11/7013/schemat.xsd"
	xmlns:etd="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2018/08/24/eD/DefinicjeTypy/"
	xmlns:vzd="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2019/02/07/eD/VATZD/"
	xmlns:zzu="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2018/08/24/eD/ORDZU/">
	<Naglowek>
		<KodFormularza kodSystemowy="VAT-7 (19)" kodPodatku="VAT" rodzajZobowiazania="Z" wersjaSchemy="1-0E">VAT-7</KodFormularza>
<%} else if (dek.TypDeklaracjiVAT7==Soneta.Deklaracje.VAT.TypDeklaracjiVAT7.VAT7K) { %>
<Deklaracja
	xmlns="http://crd.gov.pl/wzor/2019/02/11/7012/"
	xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
	xsi:schemaLocation="http://crd.gov.pl/wzor/2019/02/11/7012/ http://crd.gov.pl/wzor/2019/02/11/7012/schemat.xsd"
	xmlns:etd="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2018/08/24/eD/DefinicjeTypy/"
	xmlns:vzd="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2019/02/07/eD/VATZD/"
	xmlns:zzu="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2018/08/24/eD/ORDZU/">
	<Naglowek>
		<KodFormularza kodSystemowy="VAT-7K (13)" kodPodatku="VAT" rodzajZobowiazania="Z" wersjaSchemy="1-0E">VAT-7K</KodFormularza>
<%} %>

	<ea:XmlDataLabel ID="WariantFormularza" ElementName="WariantFormularza" runat="server" />
	<CelZlozenia poz="P_7"><ea:XmlDataLabel runat="server" DataMember="A.Korekta"><ValuesMap><ea:ValuesPair Key="False" Value="1" /><ea:ValuesPair Key="True" Value="2"/></ValuesMap></ea:XmlDataLabel></CelZlozenia>
	<Rok><ea:XmlDataLabel runat="server" DataMember="0.Rok" /></Rok>
	<ea:XmlDataLabel ID="MiesiacKwartal" runat="server" />
	<KodUrzedu><ea:XmlDataLabel runat="server" DataMember="DOD.KodUrzeduSkarbowego" /></KodUrzedu>
</Naglowek>

<Podmiot1 rola="Podatnik">
	<ea:Section ID="OsobaFizyczna" runat="server">
		<OsobaFizyczna>
			<ea:XmlDataLabel runat="server" ElementName="etd:NIP" DataMember="0.Nip" XSDType="TNrNIP" />
			<etd:ImiePierwsze><ea:XmlDataLabel ID="ImiePiersze" runat="server" XSDType="TImie" /></etd:ImiePierwsze>
			<etd:Nazwisko><ea:XmlDataLabel ID="Nazwisko" runat="server" XSDType="TNazwisko" /></etd:Nazwisko>
			<etd:DataUrodzenia><ea:XmlDataLabel ID="DataUrodzenia" runat="server" XSDType="TData" /></etd:DataUrodzenia>
		</OsobaFizyczna>
	</ea:Section>
	<ea:Section ID="OsobaNieFizyczna" runat="server">
		<OsobaNiefizyczna>
			<ea:XmlDataLabel runat="server" ElementName="NIP" DataMember="0.Nip" XSDType="TNrNIP" />
			<ea:XmlDataLabel runat="server" ElementName="PelnaNazwa" ID="NazwaPelna"  XSDType="TZnakowy" />
		</OsobaNiefizyczna>
	</ea:Section>
</Podmiot1>

<PozycjeSzczegolowe>
	<ea:XmlDataLabel ElementName="P_10" runat="server" DataMember="C.Zwolnione" HideEmptyOrZero="true" XSDType="TKwotaC" />
	<ea:XmlDataLabel ElementName="P_11" runat="server" DataMember="C.DostawaPozaKrajem" HideEmptyOrZero="true" XSDType="TKwotaC" />
	<ea:XmlDataLabel ElementName="P_12" runat="server" DataMember="C.DostawaPozaKrajemUslugiUnia" HideEmptyOrZero="true" XSDType="TKwotaC" />
	<ea:XmlDataLabel ElementName="P_13" runat="server" DataMember="C.0%Netto" HideEmptyOrZero="true" XSDType="TKwotaC" />
	<ea:XmlDataLabel ElementName="P_14" runat="server" DataMember="C.0%NettoArt129" HideEmptyOrZero="true" XSDType="TKwotaC" />
	<ea:Section ID="S_15_16" runat="server">
		  <ea:XmlDataLabel ElementName="P_15" runat="server" DataMember="C.3%Netto" XSDType="TKwotaC" />
		  <ea:XmlDataLabel ElementName="P_16" runat="server" DataMember="C.3%VAT" XSDType="TKwotaC" />
	</ea:Section>
	<ea:Section ID="S_17_18" runat="server">
		  <ea:XmlDataLabel ElementName="P_17" runat="server" DataMember="C.7%Netto" XSDType="TKwotaC" />
		  <ea:XmlDataLabel ElementName="P_18" runat="server" DataMember="C.7%VAT" XSDType="TKwotaC" />
	</ea:Section>
	<ea:Section ID="S_19_20" runat="server">
		  <ea:XmlDataLabel ElementName="P_19" runat="server" DataMember="C.22%Netto" XSDType="TKwotaC" />
		  <ea:XmlDataLabel ElementName="P_20" runat="server" DataMember="C.22%VAT" XSDType="TKwotaC" />
	</ea:Section>
	<ea:XmlDataLabel ElementName="P_21" runat="server" DataMember="C.UniaDostawa" HideEmptyOrZero="true" XSDType="TKwotaC" />
	<ea:XmlDataLabel ElementName="P_22" runat="server" DataMember="C.Eksport" HideEmptyOrZero="true" XSDType="TKwotaC" />
	<ea:Section ID="S_23_24" runat="server">
		  <ea:XmlDataLabel ElementName="P_23" runat="server" DataMember="C.UniaNabycieNetto" XSDType="TKwotaC" />
		  <ea:XmlDataLabel ElementName="P_24" runat="server" DataMember="C.UniaNabycieVAT" XSDType="TKwotaC" />
	</ea:Section>
	<ea:Section ID="S_25_26" runat="server">
		  <ea:XmlDataLabel ElementName="P_25" runat="server" DataMember="C.ImportTowarowNetto" XSDType="TKwotaC" />
		  <ea:XmlDataLabel ElementName="P_26" runat="server" DataMember="C.ImportTowarowVAT" XSDType="TKwotaC" />
	</ea:Section>
	<ea:Section ID="S_27_28" runat="server">
		  <ea:XmlDataLabel ElementName="P_27" runat="server" DataMember="C.ImportUslugNettoNieUnia" XSDType="TKwotaC" />
		  <ea:XmlDataLabel ElementName="P_28" runat="server" DataMember="C.ImportUslugVATNieUnia" XSDType="TKwotaC" />
	</ea:Section>
	<ea:Section ID="S_29_30" runat="server">
		  <ea:XmlDataLabel ElementName="P_29" runat="server" DataMember="C.ImportUslugNettoUnia" XSDType="TKwotaC" />
		  <ea:XmlDataLabel ElementName="P_30" runat="server" DataMember="C.ImportUslugVATUnia" XSDType="TKwotaC" />
	</ea:Section>
	<ea:XmlDataLabel ElementName="P_31" runat="server" DataMember="C.DostawaTowarowNettoDostawca" HideEmptyOrZero="true" XSDType="TKwotaC" />
	<ea:Section ID="S_32_33" runat="server">
		  <ea:XmlDataLabel ElementName="P_32" runat="server" DataMember="C.DostawaTowarowNettoZagranica" XSDType="TKwotaC" />
		  <ea:XmlDataLabel ElementName="P_33" runat="server" DataMember="C.DostawaTowarowVATZagranica" XSDType="TKwotaC" />
	</ea:Section>
	<ea:Section ID="S_34_35" runat="server">
		  <ea:XmlDataLabel ElementName="P_34" runat="server" DataMember="C.DostawaTowarowNettoKraj" XSDType="TKwotaC" />
		  <ea:XmlDataLabel ElementName="P_35" runat="server" DataMember="C.DostawaTowarowVATKraj" XSDType="TKwotaC" />
	</ea:Section>
	<ea:XmlDataLabel ElementName="P_36" runat="server" DataMember="C.Spis" HideEmptyOrZero="true" XSDType="TKwotaC" />
    <ea:XmlDataLabel ElementName="P_37" runat="server" DataMember="C.ZwrotZakupKas" HideEmptyOrZero="true" XSDType="TKwotaC" />
 	<ea:XmlDataLabel ElementName="P_38" runat="server" DataMember="C.SrodkiTransportu" HideEmptyOrZero="true" XSDType="TKwotaC" />
 	<ea:XmlDataLabel ElementName="P_39" runat="server" DataMember="C.NabyciePaliw" HideEmptyOrZero="true" XSDType="TKwotaC" />
	<ea:XmlDataLabel ElementName="P_40" runat="server" DataMember="C.Netto" XSDType="TKwotaC" HideEmptyOrZero="true" />
	<ea:XmlDataLabel ElementName="P_41" runat="server" DataMember="C.VAT" XSDType="TKwotaC" />
	<ea:XmlDataLabel ElementName="P_42" runat="server" DataMember="D1.Nadwyzka" HideEmptyOrZero="true" XSDType="TKwotaC" />
	<ea:Section ID="S_42_43" runat="server">
		<ea:XmlDataLabel ElementName="P_43" runat="server" DataMember="D2.SrodkiTrwaleNetto" XSDType="TKwotaC" />
		<ea:XmlDataLabel ElementName="P_44" runat="server" DataMember="D2.SrodkiTrwaleVAT" XSDType="TKwotaC" />
	</ea:Section>
	<ea:Section ID="S_44_45" runat="server">
		<ea:XmlDataLabel ElementName="P_45" runat="server" DataMember="D2.PozostaleNetto" XSDType="TKwotaC" />
		<ea:XmlDataLabel ElementName="P_46" runat="server" DataMember="D2.PozostaleVAT" XSDType="TKwotaC" />
	</ea:Section>
	<ea:XmlDataLabel ElementName="P_47" runat="server" DataMember="D3SrodkiTrwale" HideEmptyOrZero="true" XSDType="TKwotaC" />
	<ea:XmlDataLabel ElementName="P_48" runat="server" DataMember="D3Pozostale" HideEmptyOrZero="true" XSDType="TKwotaC" />
	<ea:XmlDataLabel ElementName="P_49" runat="server" DataMember="D3KasoweZleDlugi" HideEmptyOrZero="true" XSDType="TKwotaC" />
	<ea:XmlDataLabel ElementName="P_50" runat="server" DataMember="D3KasoweZleDlugiZaplacone" HideEmptyOrZero="true" XSDType="TKwotaC" />
	<ea:XmlDataLabel ElementName="P_51" runat="server" DataMember="D3.Razem" XSDType="TKwotaC" HideEmptyOrZero="true" />
	<ea:XmlDataLabel ElementName="P_52" runat="server" DataMember="E.KasyOdliczenia" HideEmptyOrZero="true" XSDType="TKwotaC" />
	<ea:XmlDataLabel ElementName="P_53" runat="server" DataMember="E.Zaniechanie" HideEmptyOrZero="true" XSDType="TKwotaC" />
	<ea:XmlDataLabel ElementName="P_54" runat="server" DataMember="E.DoZaplaty" XSDType="TKwotaC" />
	<ea:XmlDataLabel ElementName="P_55" runat="server" DataMember="E.KasyZwrot" HideEmptyOrZero="true" XSDType="TKwotaC" />
	<ea:XmlDataLabel ElementName="P_56" runat="server" DataMember="E.DoZwrotu" HideEmptyOrZero="true" XSDType="TKwotaC" />

    <ea:Section runat="server">
        <ea:XmlDataLabel ElementName="P_57" runat="server" DataMember="E.NaKonto" XSDType="TKwotaC" />
        <ea:Section ID="S_58_68" runat="server">
            <ea:XmlDataLabel ElementName="P_58" runat="server" DataMember="E.NaKontoVAT" XSDType="TKwotaC" />
            <P_68>1</P_68>
        </ea:Section>
        <ea:Section ID="S_59_70" runat="server">
            <ea:XmlDataLabel ElementName="P_59" runat="server" DataMember="E.NaKonto25" HideEmptyOrZero="true" XSDType="TKwotaC" />
        </ea:Section>
        <ea:XmlDataLabel ElementName="P_60" runat="server" DataMember="E.NaKonto60" HideEmptyOrZero="true" XSDType="TKwotaC" />
	    <ea:XmlDataLabel ElementName="P_61" runat="server" DataMember="E.NaKonto180" HideEmptyOrZero="true" XSDType="TKwotaC" />
    </ea:Section>

    <ea:XmlDataLabel ElementName="P_62" runat="server" DataMember="E.DoPrzeniesienia" HideEmptyOrZero="true" XSDType="TKwotaC" />
	<ea:XmlDataLabel ElementName="P_63" runat="server" DataMember="F.Czynnosc1" HideEmptyOrZero="true"><ValuesMap><ea:ValuesPair Key="True" Value="1" /><ea:ValuesPair Key="False" Value="0"/></ValuesMap></ea:XmlDataLabel>
	<ea:XmlDataLabel ElementName="P_64" runat="server" DataMember="F.Czynnosc2" HideEmptyOrZero="true"><ValuesMap><ea:ValuesPair Key="True" Value="1" /><ea:ValuesPair Key="False" Value="0"/></ValuesMap></ea:XmlDataLabel>
	<ea:XmlDataLabel ElementName="P_65" runat="server" DataMember="F.Czynnosc3" HideEmptyOrZero="true"><ValuesMap><ea:ValuesPair Key="True" Value="1" /><ea:ValuesPair Key="False" Value="0"/></ValuesMap></ea:XmlDataLabel>
	<ea:XmlDataLabel ElementName="P_66" runat="server" DataMember="F.Czynnosc4" HideEmptyOrZero="true"><ValuesMap><ea:ValuesPair Key="True" Value="1" /><ea:ValuesPair Key="False" Value="0"/></ValuesMap></ea:XmlDataLabel>
	<ea:XmlDataLabel ElementName="P_67" runat="server" DataMember="F.Obnizenie108D" HideEmptyOrZero="true"><ValuesMap><ea:ValuesPair Key="True" Value="1" /><ea:ValuesPair Key="False" Value="0"/></ValuesMap></ea:XmlDataLabel>
    <ea:XmlDataLabel ElementName="P_69" runat="server" DataMember="DOD.G_ZawiadomienieKorektaNaleznego" HideEmptyOrZero="true"><ValuesMap><ea:ValuesPair Key="True" Value="1" /><ea:ValuesPair Key="False" Value="0"/></ValuesMap></ea:XmlDataLabel>
    <ea:XmlDataLabel ElementName="P_72" runat="server" DataMember="H.Email" XSDType="TZnakowy" HideEmptyOrZero="true" />
	<ea:XmlDataLabel ElementName="P_73" runat="server" DataMember="H.Telefon" XSDType="TZnakowy" HideEmptyOrZero="true" />
	<ea:XmlDataLabel ElementName="P_74" runat="server" DataMember="H.Data" XSDType="TData" />
</PozycjeSzczegolowe>

<Pouczenia>1</Pouczenia>

<ea:Section ID="ZAL" runat="server">
	<Zalaczniki>
	<ea:Section ID="VAT_ZD" runat="server">
		<vzd:Wniosek_VAT-ZD>
			<vzd:Naglowek>
				<vzd:KodFormularza kodSystemowy="VAT-ZD (1)" wersjaSchemy="3-0E">VAT-ZD</vzd:KodFormularza>
				<vzd:WariantFormularza>1</vzd:WariantFormularza>
			</vzd:Naglowek>
			<vzd:PozycjeSzczegolowe>
				<ea:DataRepeater ID="VATZD_Elementy" runat="server" WithSections="False">
					<vzd:P_B typ="G">
						<vzd:P_BB><ea:XmlDataLabel runat="server" DataMember="NazwaPodatnika" XSDType="TTekstowy"/></vzd:P_BB>
						<vzd:P_BC><ea:XmlDataLabel runat="server" DataMember="NIP" XSDType="TNrNIP"/></vzd:P_BC>
						<vzd:P_BD1><ea:XmlDataLabel runat="server" DataMember="NrFaktury" XSDType="TTekstowy"/></vzd:P_BD1>
						<vzd:P_BD2><ea:XmlDataLabel runat="server" DataMember="DataWystawienia" XSDType="TData"/></vzd:P_BD2>
						<vzd:P_BE><ea:XmlDataLabel runat="server" DataMember="TerminPlatnosci" XSDType="TData"/></vzd:P_BE>
						<vzd:P_BF><ea:XmlDataLabel runat="server" DataMember="KorektaPodstawy" XSDType="TKwota2"/></vzd:P_BF>
						<vzd:P_BG><ea:XmlDataLabel runat="server" DataMember="KorektaPodatku" XSDType="TKwota2"/></vzd:P_BG>
					</vzd:P_B>
				</ea:DataRepeater>
				<vzd:P_10><ea:XmlDataLabel ID="VATZD_KorektaPodstawy" runat="server" XSDType="TKwotaC"/></vzd:P_10>
				<vzd:P_11><ea:XmlDataLabel ID="VATZD_KorektaPodatku" runat="server" XSDType="TKwotaC"/></vzd:P_11>
			</vzd:PozycjeSzczegolowe>
		</vzd:Wniosek_VAT-ZD>
	</ea:Section>
	<ea:Section ID="ORD_ZU" runat="server">
		<zzu:Zalacznik_ORD-ZU>
			<zzu:Naglowek>
				<zzu:KodFormularza kodSystemowy="ORD-ZU (3)"  wersjaSchemy="2-0E">ORD-ZU</zzu:KodFormularza>
				<zzu:WariantFormularza>3</zzu:WariantFormularza>
			</zzu:Naglowek>
			<zzu:PozycjeSzczegolowe>
				<zzu:P_13><ea:XmlDataLabel runat="server" DataMember="TreśćUzasadnienia" XSDType="TTekstowy"/></zzu:P_13>
			</zzu:PozycjeSzczegolowe>
		</zzu:Zalacznik_ORD-ZU>
	</ea:Section>
</Zalaczniki>
</ea:Section>
</Deklaracja>
