﻿<%@ Page Language="C#" AutoEventWireup="false" CodePage="1200" %>

<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Deklaracje" %>


<script runat="server">
	Soneta.Deklaracje.VAT.VAT9M_8 dek;

	void OnContextLoad(Object sender, EventArgs args)
	{
		dek = (Soneta.Deklaracje.VAT.VAT9M_8)dc[typeof(Soneta.Deklaracje.VAT.VAT9M_8)];

		ORD_ZU.Visible = dek.TreśćUzasadnienia != "";
		ZAL.Visible = ORD_ZU.Visible;
        WariantFormularza.EditValue = 8;
	
		string[] nazwa = Soneta.Deklaracje.PIT.PIT.DaneFirmy((string)dek.Bloki["B1"]["Nazwa"], (bool)dek.Bloki["B1"]["OsobaFiz"]);
		if((bool)dek.Bloki["B1"]["OsobaFiz"])
		{
			OsobaNieFizyczna.Visible = false;
			if (nazwa.Length > 0)
				Nazwisko.EditValue = nazwa[0].Trim();
			if (nazwa.Length > 1)
				ImiePiersze.EditValue = nazwa[1].Trim();
			if (nazwa.Length > 2)
				DataUrodzenia.EditValue = nazwa[2].Trim();
		}
		else
		{
			OsobaFizyczna.Visible = false;
			if (nazwa.Length > 0)
				NazwaPelna.EditValue = nazwa[0].Trim();
		}

	if ((decimal)dek.Bloki["C"]["ImportUslugNettoNieUnia"] == 0 && (decimal)dek.Bloki["C"]["ImportUslugVATNieUnia"] == 0)
	  S_10_11.Visible = false;
	if ((decimal)dek.Bloki["C"]["ImportUslugNettoUnia"] == 0 && (decimal)dek.Bloki["C"]["ImportUslugVATUnia"] == 0)
	  S_12_13.Visible = false;
	if ((decimal)dek.Bloki["C"]["DostawaTowarowNettoZagranica"] == 0 && (decimal)dek.Bloki["C"]["DostawaTowarowVATZagranica"] == 0)
	  S_14_15.Visible = false;
	if ((decimal)dek.Bloki["C"]["DostawaTowarowNettoKraj"] == 0 && (decimal)dek.Bloki["C"]["DostawaTowarowVATKraj"] == 0)
	  S_16_17.Visible = false;
    }
</script>


<ea:datacontext id="dc" runat="server" typename="Soneta.Deklaracje.VAT.VAT9M_8,Soneta.Deklaracje" oncontextload="OnContextLoad" />
<?xml version="1.0" encoding="UTF-8" ?>
<Deklaracja
	xmlns="http://crd.gov.pl/wzor/2018/05/17/5379/"
	xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
	xsi:schemaLocation="http://crd.gov.pl/wzor/2018/05/17/5379/ http://crd.gov.pl/wzor/2018/05/17/5379/schemat.xsd"
	xmlns:etd="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2016/01/25/eD/DefinicjeTypy/"
	xmlns:zzu="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2016/02/05/eD/ORDZU/" >
	<Naglowek>
		<KodFormularza kodSystemowy="VAT-9M (8)" kodPodatku="VAT" rodzajZobowiazania="Z" wersjaSchemy="1-0E">VAT-9M</KodFormularza>


	<ea:XmlDataLabel ID="WariantFormularza" ElementName="WariantFormularza" runat="server" />
	<CelZlozenia poz="P_7"><ea:XmlDataLabel runat="server" DataMember="A.Korekta"><ValuesMap><ea:ValuesPair Key="False" Value="1" /><ea:ValuesPair Key="True" Value="2"/></ValuesMap></ea:XmlDataLabel></CelZlozenia>
	<Rok><ea:XmlDataLabel runat="server" DataMember="0.Rok" /></Rok>
	<Miesiac><ea:XmlDataLabel runat="server" DataMember="0.Miesiąc" /></Miesiac>
	<KodUrzedu><ea:XmlDataLabel runat="server" DataMember="DOD.KodUrzeduSkarbowego" /></KodUrzedu>
</Naglowek>

<Podmiot1 rola="Podatnik">
	<ea:Section ID="OsobaFizyczna" runat="server">
		<OsobaFizyczna>
			<ea:XmlDataLabel runat="server" ElementName="etd:NIP" DataMember="0.Nip" XSDType="TNrNIP" />
			<etd:ImiePierwsze><ea:XmlDataLabel ID="ImiePiersze" runat="server" XSDType="TImie" /></etd:ImiePierwsze>
			<etd:Nazwisko><ea:XmlDataLabel ID="Nazwisko" runat="server" XSDType="TNazwisko" /></etd:Nazwisko>
			<etd:DataUrodzenia><ea:XmlDataLabel ID="DataUrodzenia" runat="server" XSDType="TData" /></etd:DataUrodzenia>
		</OsobaFizyczna>
	</ea:Section>
	<ea:Section ID="OsobaNieFizyczna" runat="server">
		<OsobaNiefizyczna>
			<ea:XmlDataLabel runat="server" ElementName="NIP" DataMember="0.Nip" XSDType="TNrNIP" />
			<ea:XmlDataLabel runat="server" ElementName="PelnaNazwa" ID="NazwaPelna"  XSDType="TZnakowy" />
		</OsobaNiefizyczna>
	</ea:Section>
</Podmiot1>

<PozycjeSzczegolowe>
	<ea:Section ID="S_10_11" runat="server">
		  <ea:XmlDataLabel ElementName="P_10" runat="server" DataMember="C.ImportUslugNettoNieUnia" XSDType="TKwotaC" />
		  <ea:XmlDataLabel ElementName="P_11" runat="server" DataMember="C.ImportUslugVATNieUnia" XSDType="TKwotaC" />
	</ea:Section>
	<ea:Section ID="S_12_13" runat="server">
		  <ea:XmlDataLabel ElementName="P_12" runat="server" DataMember="C.ImportUslugNettoUnia" XSDType="TKwotaC" />
		  <ea:XmlDataLabel ElementName="P_13" runat="server" DataMember="C.ImportUslugVATUnia" XSDType="TKwotaC" />
	</ea:Section>
	<ea:Section ID="S_14_15" runat="server">
		  <ea:XmlDataLabel ElementName="P_14" runat="server" DataMember="C.DostawaTowarowNettoZagranica" XSDType="TKwotaC" />
		  <ea:XmlDataLabel ElementName="P_15" runat="server" DataMember="C.DostawaTowarowVATZagranica" XSDType="TKwotaC" />
	</ea:Section>
	<ea:Section ID="S_16_17" runat="server">
		  <ea:XmlDataLabel ElementName="P_16" runat="server" DataMember="C.DostawaTowarowNettoKraj" XSDType="TKwotaC" />
		  <ea:XmlDataLabel ElementName="P_17" runat="server" DataMember="C.DostawaTowarowVATKraj" XSDType="TKwotaC" />
	</ea:Section>
	
	<ea:XmlDataLabel ElementName="P_18" runat="server" DataMember="C.VAT" XSDType="TKwotaC" />
    <ea:XmlDataLabel ElementName="P_19" runat="server" DataMember="D.Obnizenie108D" HideEmptyOrZero="true"><ValuesMap><ea:ValuesPair Key="True" Value="1" /><ea:ValuesPair Key="False" Value="0"/></ValuesMap></ea:XmlDataLabel>
    <ea:XmlDataLabel ElementName="P_22" runat="server" DataMember="E.Email" XSDType="TZnakowy" HideEmptyOrZero="true" />
	<ea:XmlDataLabel ElementName="P_23" runat="server" DataMember="E.Telefon" XSDType="TZnakowy" HideEmptyOrZero="true" />
	<ea:XmlDataLabel ElementName="P_24" runat="server" DataMember="E.Data" XSDType="TData" HideEmptyOrZero="true" />
</PozycjeSzczegolowe>

<Pouczenia>1</Pouczenia>

<ea:Section ID="ZAL" runat="server">
	<Zalaczniki>
	<ea:Section ID="ORD_ZU" runat="server">
		<zzu:Zalacznik_ORD-ZU>
			<zzu:Naglowek>
				<zzu:KodFormularza kodSystemowy="ORD-ZU (3)"  wersjaSchemy="1-0E">ORD-ZU</zzu:KodFormularza>
				<zzu:WariantFormularza>3</zzu:WariantFormularza>
			</zzu:Naglowek>
			<zzu:PozycjeSzczegolowe>
				<zzu:P_13><ea:XmlDataLabel runat="server" DataMember="TreśćUzasadnienia" XSDType="TTekstowy"/></zzu:P_13>
			</zzu:PozycjeSzczegolowe>
		</zzu:Zalacznik_ORD-ZU>
	</ea:Section>
</Zalaczniki>
</ea:Section>
</Deklaracja>
