﻿<%@ Page Language="C#" AutoEventWireup="false" CodePage="1200" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Deklaracje" %>
<script runat="server">
	Soneta.Deklaracje.VAT.VATUE_1 dek = null;

	public class Grupa {
		readonly string kod; readonly string nip; readonly decimal kwota; readonly bool trojstronna;
		public Grupa(string kod, string nip, decimal kwota, bool trojstronna){
			this.kod = kod;
			this.nip = nip;
			this.kwota = kwota;
			this.trojstronna = trojstronna;
		}

		public string Kod {
			get { return kod; }
		}

		public string NIP {
			get { return nip; }
		}

		public decimal Kwota {
			get { return kwota; }
		}

		public bool Trojstronna{
			get { return trojstronna; }
		}						
	}
	
	public class KGrupa {
		readonly string bkod; readonly string bnip; readonly decimal bkwota; readonly bool btrojstronna;
		readonly string jkod; readonly string jnip; readonly decimal jkwota; readonly bool jtrojstronna;		
		public KGrupa(
			string bkod, string bnip, decimal bkwota, bool btrojstronna,
			string jkod, string jnip, decimal jkwota, bool jtrojstronna			
			){
			this.bkod = bkod;
			this.bnip = bnip;
			this.bkwota = bkwota;
			this.btrojstronna = btrojstronna;
			
			this.jkod = jkod;
			this.jnip = jnip;
			this.jkwota = jkwota;
			this.jtrojstronna = jtrojstronna;			
		}

		public string BKod {
			get { return bkod; }
		}

		public string BNIP {
			get { return bnip; }
		}

		public decimal BKwota {
			get { return bkwota; }
		}

		public bool BTrojstronna{
			get { return btrojstronna; }
		}						
		
		public string JKod {
			get { return jkod; }
		}

		public string JNIP {
			get { return jnip; }
		}

		public decimal JKwota {
			get { return jkwota; }
		}

		public bool JTrojstronna{
			get { return jtrojstronna; }
		}								
	}	
	
	void OnContextLoad(Object sender, EventArgs args) {
		dek = (Soneta.Deklaracje.VAT.VATUE_1)dc[typeof(Soneta.Deklaracje.VAT.VATUE_1)];
		
		//Nagłówek
		Kwartal.EditValue = dek.Okres.To.Quarter;
		
		string[] nazwa = Soneta.Deklaracje.PIT.PIT.DaneFirmy((string)dek.Bloki["B1"]["Nazwa"], (bool)dek.Bloki["B1"]["OsobaFiz"]);
		if((bool)dek.Bloki["B1"]["OsobaFiz"]){
			OsobaNieFizyczna.Visible = false;
			if (nazwa.Length > 0)
				Nazwisko.EditValue = nazwa[0].Trim();
			if (nazwa.Length > 1)
				ImiePiersze.EditValue = nazwa[1].Trim();
			if (nazwa.Length > 2)
				DataUrodzenia.EditValue = nazwa[2].Trim();						
		}else{
			OsobaFizyczna.Visible = false;
			if (nazwa.Length > 0)
				NazwaPelna.EditValue = nazwa[0].Trim();
			if (nazwa.Length > 1)
				REGON.EditValue = nazwa[1].Trim();			
		}
		
		if(dek.Korekta){
			Grupa1.Visible = false;
			Grupa2.Visible = false;	
			
			Soneta.Deklaracje.VAT.VATUEK kor = null;
			BlokDeklaracji blok = null;
			System.Collections.Generic.List<KGrupa> grupyKDostawy = new System.Collections.Generic.List<KGrupa>();			
			System.Collections.Generic.List<KGrupa> grupyKNabycia = new System.Collections.Generic.List<KGrupa>();					
			

			foreach(Deklaracja d in dek.Deklaracje){
				kor = d as Soneta.Deklaracje.VAT.VATUEK;
				if(kor==null)
					continue;
				
				//Grupa1
				blok = kor.Bloki["CKorekta"];
				for (int i = 1; i <= 6; i++) {
					if ((decimal)blok[string.Format("BKwota{0}", i)] == 0 && (decimal)blok[string.Format("JKwota{0}", i)] == 0)
						break;
					grupyKDostawy.Add(
						new KGrupa(
							(string)blok[string.Format("BKod{0}", i)],
							(string)blok[string.Format("BNIP{0}", i)],
							(decimal)blok[string.Format("BKwota{0}", i)],
							(bool)blok[string.Format("BTrojstronna{0}", i)],
							(string)blok[string.Format("JKod{0}", i)],
							(string)blok[string.Format("JNIP{0}", i)],
							(decimal)blok[string.Format("JKwota{0}", i)],
							(bool)blok[string.Format("JTrojstronna{0}", i)]));
				}
				
				//Grupa2
				blok = kor.Bloki["DKorekta"];
				for (int i = 1; i <= 6; i++) {
					if ((decimal)blok[string.Format("BKwota{0}", i)] == 0 && (decimal)blok[string.Format("JKwota{0}", i)] == 0)
						break;
					grupyKNabycia.Add(
						new KGrupa(
							(string)blok[string.Format("BKod{0}", i)],
							(string)blok[string.Format("BNIP{0}", i)],
							(decimal)blok[string.Format("BKwota{0}", i)],
							(bool)blok[string.Format("BTrojstronna{0}", i)],
							(string)blok[string.Format("JKod{0}", i)],
							(string)blok[string.Format("JNIP{0}", i)],
							(decimal)blok[string.Format("JKwota{0}", i)],
							(bool)blok[string.Format("JTrojstronna{0}", i)]));
				}	
			}
			
			KGrupa1.DataSource = grupyKDostawy;
			KGrupa2.DataSource = grupyKNabycia;			
		}
		else{
			KGrupa1.Visible = false;
			KGrupa2.Visible = false;			
			//Grupa1
			System.Collections.Generic.List<Grupa> grupyDostawy = new System.Collections.Generic.List<Grupa>();
			BlokDeklaracji blok = dek.Bloki["C"];
			for (int i = 1; i <= 12; i++) {
				if ((decimal)blok[string.Format("Kwota{0}", i)] == 0)
					break;
				grupyDostawy.Add(
					new Grupa(
						(string)blok[string.Format("Kod{0}", i)],
						(string)blok[string.Format("NIP{0}", i)],
						(decimal)blok[string.Format("Kwota{0}", i)],
						(bool)blok[string.Format("Trojstronna{0}", i)]));
			}
			
			//Grupa2
			System.Collections.Generic.List<Grupa> grupyNabycia = new System.Collections.Generic.List<Grupa>();		
			blok = dek.Bloki["D"];
			for (int i = 1; i <= 12; i++) {
				if ((decimal)blok[string.Format("Kwota{0}", i)] == 0)
					break;
				grupyNabycia.Add(
					new Grupa(
						(string)blok[string.Format("Kod{0}", i)],
						(string)blok[string.Format("NIP{0}", i)],
						(decimal)blok[string.Format("Kwota{0}", i)],
						(bool)blok[string.Format("Trojstronna{0}", i)]));
			}
			
			//załączniki
			System.Collections.Generic.List<Grupa> grupy = null;
			foreach (Soneta.Deklaracje.VAT.VATUEAB zal in dek.Deklaracje) {
				grupy = zal is Soneta.Deklaracje.VAT.VATUEA ? grupyDostawy : grupyNabycia;
				blok = zal.Bloki["B"];
				for (int i = 1; i <= 53; i++) {
					if ((decimal)blok[string.Format("Kwota{0}", i)] == 0)
						break;
					grupy.Add(
						new Grupa(
							(string)blok[string.Format("Kod{0}", i)],
							(string)blok[string.Format("NIP{0}", i)],
							(decimal)blok[string.Format("Kwota{0}", i)],
							(bool)blok[string.Format("Trojstronna{0}", i)]));
				}
				
			}

			Grupa1.DataSource = grupyDostawy;
			Grupa2.DataSource = grupyNabycia;		
		}	
	}
	
</script>
<ea:datacontext id="dc" runat="server" TypeName="Soneta.Deklaracje.VAT.VATUE_1,Soneta.Deklaracje" OnContextLoad="OnContextLoad"></ea:datacontext>
<?xml version="1.0" encoding="UTF-8"?>
<%if (dek.Korekta) {%>
<Deklaracja xsi:noNamespaceSchemaLocation="http://www.e-deklaracje.mf.gov.pl/Repozytorium/Deklaracje/VAT/VAT-UEK(1)_v2-0.xsd" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:usr="urn:the-xml-files:xslt" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
<%} else {%>
<Deklaracja xsi:noNamespaceSchemaLocation="http://www.e-deklaracje.mf.gov.pl/Repozytorium/Deklaracje/VAT/VAT-UE(1)_v2-0.xsd" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:usr="urn:the-xml-files:xslt" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
<%} %>
	<Naglowek>
<%if (dek.Korekta) {%>	
		<KodFormularza kodSystemowy="VATUEK(1)">VAT-UEK</KodFormularza>
<%} else {%>		
		<KodFormularza kodSystemowy="VAT-UE(1)">VAT-UE</KodFormularza>		
<%} %>		
		<WariantFormularza>1</WariantFormularza>
		<Rok><ea:XmlDataLabel ID="DataLabel2" runat="server" DataMember="0.Rok"></ea:XmlDataLabel></Rok>		
<%if (!dek.Korekta) {%>			
		<CelZlozenia>1</CelZlozenia>
<%} %>				
		<Kwartal><ea:XmlDataLabel ID="Kwartal" runat="server"></ea:XmlDataLabel></Kwartal>
		<KodUrzedu><ea:XmlDataLabel ID="DataLabel4" runat="server" DataMember="DOD.KodUrzeduSkarbowego"></ea:XmlDataLabel></KodUrzedu>
	</Naglowek>
	<Podmiot1 rola="Podatnik">
		<ea:Section ID="OsobaFizyczna" runat="server"><OsobaFizyczna>
			<ea:XmlDataLabel ID="XmlDataLabel1" runat="server" ElementName="NIP" DataMember="0.Nip" XSDType="TNrNIP"></ea:XmlDataLabel>
			<ImiePierwsze><ea:XmlDataLabel ID="ImiePiersze" runat="server" XSDType="TImie"></ea:XmlDataLabel></ImiePierwsze>
			<Nazwisko><ea:XmlDataLabel ID="Nazwisko" runat="server" XSDType="TNazwisko"></ea:XmlDataLabel></Nazwisko>
			<DataUrodzenia><ea:XmlDataLabel ID="DataUrodzenia" runat="server" XSDType="TData"></ea:XmlDataLabel></DataUrodzenia>
		</OsobaFizyczna></ea:Section>
		<ea:Section ID="OsobaNieFizyczna" runat="server"><OsobaNiefizyczna>
			<ea:XmlDataLabel ID="XmlDataLabel2" runat="server" ElementName="NIP" DataMember="0.Nip" XSDType="TNrNIP"></ea:XmlDataLabel>
			<PelnaNazwa><ea:XmlDataLabel ID="NazwaPelna" runat="server" XSDType="TZnakowy"></ea:XmlDataLabel></PelnaNazwa>
			<REGON><ea:XmlDataLabel ID="REGON" runat="server" XSDType="TNrREGON"></ea:XmlDataLabel></REGON>
		</OsobaNiefizyczna></ea:Section>
		<AdresZamieszkaniaSiedziby rodzajAdresu="RAD">
			<AdresPol>
				<KodKraju>PL</KodKraju>
				<Wojewodztwo><ea:XmlDataLabel ID="XmlDataLabel3" runat="server" DataMember="B2.Wojew" XSDType="TJednAdmin"></ea:XmlDataLabel></Wojewodztwo>
				<Powiat><ea:XmlDataLabel ID="XmlDataLabel4" runat="server" DataMember="B2.Powiat" XSDType="TJednAdmin"></ea:XmlDataLabel></Powiat>
				<Gmina><ea:XmlDataLabel ID="XmlDataLabel5" runat="server" DataMember="B2.Gmina" XSDType="TJednAdmin"></ea:XmlDataLabel></Gmina>
				<ea:XmlDataLabel ID="XmlDataLabel6" runat="server" ElementName="Ulica" HideEmptyOrZero="true" DataMember="B2.Ulica" XSDType="TUlica"></ea:XmlDataLabel>
				<NrDomu><ea:XmlDataLabel ID="XmlDataLabel7" runat="server" DataMember="B2.NrDomu" XSDType="TNrBudynku"></ea:XmlDataLabel></NrDomu>
				<ea:XmlDataLabel ID="XmlDataLabel8" runat="server" ElementName="NrLokalu" HideEmptyOrZero="true" DataMember="B2.NrLokalu" XSDType="TNrLokalu"></ea:XmlDataLabel>
				<Miejscowosc><ea:XmlDataLabel ID="XmlDataLabel9" runat="server" DataMember="B2.Miejsc" XSDType="TMiejscowosc"></ea:XmlDataLabel></Miejscowosc>
				<KodPocztowy><ea:XmlDataLabel ID="XmlDataLabel10" runat="server" DataMember="B2.KodPoczt" XSDType="TKodPocztowy"></ea:XmlDataLabel></KodPocztowy>
				<Poczta><ea:XmlDataLabel ID="XmlDataLabel11" runat="server" DataMember="B2.Poczta" XSDType="TMiejscowosc"></ea:XmlDataLabel></Poczta>
			</AdresPol>
		</AdresZamieszkaniaSiedziby>
	</Podmiot1>	
	<PozycjeSzczegolowe>
		<ea:DataRepeater ID="Grupa1" runat="server" WithSections="False">
			<Grupa1>
				<P_Da><ea:XmlDataLabel ID="Grupa1Kod" runat="server" DataMember="Kod" XSDType="TZnakowy"></ea:XmlDataLabel></P_Da> 
				<P_Db><ea:XmlDataLabel ID="Grupa1NIP" runat="server" DataMember="NIP" XSDType="TNrVatUE"></ea:XmlDataLabel></P_Db> 
				<P_Dc><ea:XmlDataLabel ID="Grupa1Kwota" runat="server" DataMember="Kwota"  XSDType="TKwotaC"></ea:XmlDataLabel></P_Dc> 
				<P_Dd><ea:XmlDataLabel ID="Grupa1Trojstronna" runat="server" DataMember="Trojstronna"><ValuesMap><ea:ValuesPair Key="False" Value="1" /><ea:ValuesPair Key="True" Value="2"/></ValuesMap></ea:XmlDataLabel></P_Dd> 
			</Grupa1>
		</ea:DataRepeater>
		<ea:DataRepeater ID="Grupa2" runat="server" WithSections="False">
			<Grupa2>
				<P_Na><ea:XmlDataLabel ID="Grupa2Kod" runat="server" DataMember="Kod" XSDType="TZnakowy"></ea:XmlDataLabel></P_Na> 
				<P_Nb><ea:XmlDataLabel ID="Grupa2NIP" runat="server" DataMember="NIP" XSDType="TNrVatUE"></ea:XmlDataLabel></P_Nb> 
				<P_Nc><ea:XmlDataLabel ID="Grupa2Kwota" runat="server" DataMember="Kwota"  XSDType="TKwotaC"></ea:XmlDataLabel></P_Nc> 
				<P_Nd><ea:XmlDataLabel ID="Grupa2Trojstronna" runat="server" DataMember="Trojstronna"><ValuesMap><ea:ValuesPair Key="False" Value="1" /><ea:ValuesPair Key="True" Value="2"/></ValuesMap></ea:XmlDataLabel></P_Nd> 
			</Grupa2>
		</ea:DataRepeater>		
		<ea:DataRepeater ID="KGrupa1" runat="server" WithSections="False">
			<Grupa1>
				<P_DBa><ea:XmlDataLabel ID="KGrupa1BKod" runat="server" DataMember="BKod" XSDType="TZnakowy"></ea:XmlDataLabel></P_DBa> 
				<P_DBb><ea:XmlDataLabel ID="KGrupa1BNIP" runat="server" DataMember="BNIP" XSDType="TNrVatUE"></ea:XmlDataLabel></P_DBb> 
				<P_DBc><ea:XmlDataLabel ID="KGrupa1BKwota" runat="server" DataMember="BKwota"  XSDType="TKwotaC"></ea:XmlDataLabel></P_DBc> 
				<P_DBd><ea:XmlDataLabel ID="KGrupa1BTrojstronna" runat="server" DataMember="BTrojstronna"><ValuesMap><ea:ValuesPair Key="False" Value="1" /><ea:ValuesPair Key="True" Value="2"/></ValuesMap></ea:XmlDataLabel></P_DBd> 
				<P_DJa><ea:XmlDataLabel ID="KGrupa1JKod" runat="server" DataMember="JKod" XSDType="TZnakowy"></ea:XmlDataLabel></P_DJa> 
				<P_DJb><ea:XmlDataLabel ID="KGrupa1JNIP" runat="server" DataMember="JNIP" XSDType="TNrVatUE"></ea:XmlDataLabel></P_DJb> 
				<P_DJc><ea:XmlDataLabel ID="KGrupa1JKwota" runat="server" DataMember="JKwota"  XSDType="TKwotaC"></ea:XmlDataLabel></P_DJc> 
				<P_DJd><ea:XmlDataLabel ID="KGrupa1JTrojstronna" runat="server" DataMember="JTrojstronna"><ValuesMap><ea:ValuesPair Key="False" Value="1" /><ea:ValuesPair Key="True" Value="2"/></ValuesMap></ea:XmlDataLabel></P_DJd> 				
			</Grupa1>
		</ea:DataRepeater>
		<ea:DataRepeater ID="KGrupa2" runat="server" WithSections="False">
			<Grupa2>
				<P_NBa><ea:XmlDataLabel ID="KGrupa2BKod" runat="server" DataMember="BKod" XSDType="TZnakowy"></ea:XmlDataLabel></P_NBa> 
				<P_NBb><ea:XmlDataLabel ID="KGrupa2BNIP" runat="server" DataMember="BNIP" XSDType="TNrVatUE"></ea:XmlDataLabel></P_NBb> 
				<P_NBc><ea:XmlDataLabel ID="KGrupa2BKwota" runat="server" DataMember="BKwota"  XSDType="TKwotaC"></ea:XmlDataLabel></P_NBc> 
				<P_NBd><ea:XmlDataLabel ID="KGrupa2BTrojstronna" runat="server" DataMember="BTrojstronna"><ValuesMap><ea:ValuesPair Key="False" Value="1" /><ea:ValuesPair Key="True" Value="2"/></ValuesMap></ea:XmlDataLabel></P_NBd> 
				<P_NJa><ea:XmlDataLabel ID="KGrupa2JKod" runat="server" DataMember="JKod" XSDType="TZnakowy"></ea:XmlDataLabel></P_NJa> 
				<P_NJb><ea:XmlDataLabel ID="KGrupa2JNIP" runat="server" DataMember="JNIP" XSDType="TNrVatUE"></ea:XmlDataLabel></P_NJb> 
				<P_NJc><ea:XmlDataLabel ID="KGrupa2JKwota" runat="server" DataMember="JKwota"  XSDType="TKwotaC"></ea:XmlDataLabel></P_NJc> 
				<P_NJd><ea:XmlDataLabel ID="KGrupa2JTrojstronna" runat="server" DataMember="JTrojstronna"><ValuesMap><ea:ValuesPair Key="False" Value="1" /><ea:ValuesPair Key="True" Value="2"/></ValuesMap></ea:XmlDataLabel></P_NJd> 				
			</Grupa2>
		</ea:DataRepeater>				
	</PozycjeSzczegolowe>
	<Oswiadczenie>Oświadczam, że są mi znane przepisy Kodeksu karnego skarbowego o odpowiedzialności za podanie danych niezgodnych z rzeczywistością.</Oswiadczenie>	
</Deklaracja>
