﻿<%@ Page Language="c#" CodePage="1200" %>

<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Import Namespace="Soneta.Core" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Business.App" %>
<%@ Import Namespace="Soneta.Handel" %>
<%@ Import Namespace="Soneta.Kasa" %>
<%@ Import Namespace="Soneta.Magazyny" %>
<%@ Import Namespace="Soneta.Waluty" %>
<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Tools" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<html>
<head>
    <title>Inwentaryzacja - braki</title>

    <script runat="server">

        void OnContextLoad(Object sender, EventArgs args) {
            DokumentHandlowy dokument = (DokumentHandlowy)dc[typeof(DokumentHandlowy)];

            //Składamy opis do dokumentu
            string opis = "";
            if (dokument.Opis != "")
                opis += "<p>" + dokument.Opis + "</p>";
            if (dokument.Wydruk.OpisWydruku != "")
                opis += "<p>" + dokument.Wydruk.OpisWydruku + "</p>";
            Opis.EditValue = opis;

            //Formatujemy podpisy
            stPodpis.Caption = "<font size=2>" + dokument.Session.Login.Operator.FullName + "</font><br><br><font size=1>..................................................<br>Podpis osoby uprawnionej do wystawienia dokumentu</font>";
            stOsoba.Caption = "<font size=2>" + dokument.Osoba + "</font><br><br><font size=1>..................................................<br>Podpis osoby upoważnionej do otrzymania dokumentu</font>";

        }
    
        </script>

    <meta content="Microsoft Visual Studio 7.0" name="GENERATOR">
    <meta content="C#" name="CODE_LANGUAGE">
    <meta content="JavaScript" name="vs_defaultClientScript">
    <meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
</head>
<body>
    <form id="Sprzedaż" method="post" runat="server">
        <ea:DataContext ID="dc" runat="server" TypeName="Soneta.Handel.DokumentHandlowy,Soneta.Handel"
            OnContextLoad="OnContextLoad"></ea:DataContext>
        <ea:SectionMarker ID="SectionMarker1" runat="server">
        </ea:SectionMarker>
        <p>
            <ea:PageBreak ID="PageBreak1" runat="server" BreakFirstTimes="False">
            </ea:PageBreak>
            <cc1:ReportHeader ID="ReportHeader1" Title="Brak pokrycia strat inwentaryzacyjnych|</STRONG>Dokument: <STRONG>{0}|</STRONG>Magazyn: <STRONG>{1}|</STRONG>Data i miejsce wystawienia: <STRONG>{2}, {3}"
                runat="server" DataMember0="."
                DataMember1="Magazyn.Nazwa" DataMember2="Data" DataMember3="Session.Core.Config.Firma.AdresSiedziby.Miejscowosc">
            </cc1:ReportHeader>
        </p>
        <p>
            <ea:Grid ID="Grid" runat="server" Filter="Workers.InwentaryzacjaPozycji.Kierunek='Rozchód'"
                DataMember="Pozycje" RowTypeName="Soneta.Handel.PozycjaDokHandlowego,Soneta.Handel">
                <Columns>
                    <ea:GridColumn Width="4" Align="Right" DataMember="#" Caption="Lp." EncodeHTML="True"
                        runat="server">
                    </ea:GridColumn>
                    <ea:GridColumn Width="18" DataMember="Towar.Kod" Caption="Kod" EncodeHTML="True"
                        runat="server">
                    </ea:GridColumn>
                    <ea:GridColumn DataMember="Towar.Nazwa" Caption="Nazwa towaru" EncodeHTML="True"
                        runat="server">
                    </ea:GridColumn>
                    <ea:GridColumn Width="18" Align="Right" DataMember="Workers.InwentaryzacjaPozycji.BrakPokryciaStrat"
                        Caption="Brak" EncodeHTML="True" runat="server">
                    </ea:GridColumn>
                    <ea:GridColumn Width="18" Align="Right" DataMember="Towar.OstatniaCenaZakupu.Netto"
                        Total="Info" Caption="Cena zakupu" Format="{0:n}" EncodeHTML="True"
                        runat="server">
                    </ea:GridColumn>
                </Columns>
            </ea:Grid>
        </p>
        <p>
            <ea:DataLabel ID="Opis" runat="server" Bold="False" EncodeHTML="False">
            </ea:DataLabel>
            <cc1:ReportFooter ID="ReportFooter1" runat="server" Height="105px" TheEnd="False">
                <Subtitles>
                    <cc1:FooterSubtitle runat="server" Caption="Operator" ID="stPodpis" SubtitleType="CenterText" Width="50">
                    </cc1:FooterSubtitle>
                    <cc1:FooterSubtitle runat="server" Caption="Osoba" ID="stOsoba" SubtitleType="CenterText" Width="50">
                    </cc1:FooterSubtitle>
                </Subtitles>
            </cc1:ReportFooter>
        </p>
        <ea:SectionMarker ID="SectionMarker6" runat="server" SectionType="Footer">
        </ea:SectionMarker>
    </form>
</body>
</html>

