﻿<%@ Page Language="c#" CodePage="1200" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ import Namespace="Soneta.Core" %>
<%@ import Namespace="Soneta.Business" %>
<%@ import Namespace="Soneta.Business.App" %>
<%@ import Namespace="Soneta.Handel" %>
<%@ import Namespace="Soneta.Kasa" %>
<%@ import Namespace="Soneta.Magazyny" %>
<%@ import Namespace="Soneta.Waluty" %>
<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="Soneta.Tools" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
    <HEAD>
        <title>Zmiany inwntaryzacji</title>
        <script runat="server">

public class ParametryContext : ContextBase { 
    public ParametryContext(Context cx) : base(cx) {
    }
    
    bool nadwyżki = true;
    
    [Priority(1)]
    public bool Nadwyżki {
        get { return nadwyżki; }
        set { nadwyżki = value; }
    }
    
    bool straty = true;
    
    [Priority(2)]
    public bool Straty {
        get { return straty; }
        set { straty = value; }
    }
}

ParametryContext parametry;

[Context]
public ParametryContext Parametry {
    get { return parametry; }
    set { parametry = value; }
}

    void OnContextLoad(Object sender, EventArgs args) {
        DokumentHandlowy dokument = (DokumentHandlowy)dc[typeof(DokumentHandlowy)];
    
        //Składamy opis do dokumentu
        string opis = "";
        if (dokument.Opis!="")
            opis += "<p>" + dokument.Opis + "</p>";
        if (dokument.Wydruk.OpisWydruku!="")
            opis += "<p>" + dokument.Wydruk.OpisWydruku + "</p>";
        Opis.EditValue = opis;
    
        //Formatujemy podpisy
        stPodpis.Caption = "<font size=2>"+dokument.Session.Login.Operator.FullName+"</font><br><br><font size=1>..................................................<br>Podpis osoby uprawnionej do wystawienia dokumentu</font>";
        stOsoba.Caption = "<font size=2>"+dokument.Osoba+"</font><br><br><font size=1>..................................................<br>Podpis osoby upoważnionej do otrzymania dokumentu</font>";
        
        SectionNad.Visible = Parametry.Nadwyżki;
        SectionStr.Visible = Parametry.Straty;
    }
    
        </script>
        <meta content="Microsoft Visual Studio 7.0" name="GENERATOR">
        <meta content="C#" name="CODE_LANGUAGE">
        <meta content="JavaScript" name="vs_defaultClientScript">
        <meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
    </HEAD>
    <body>
        <form id="Sprzedaż" method="post" runat="server">
            <ea:datacontext id="dc" runat="server" TypeName="Soneta.Handel.DokumentHandlowy,Soneta.Handel" oncontextload="OnContextLoad"></ea:datacontext>
            <ea:SectionMarker id="SectionMarker1" runat="server"></ea:SectionMarker>
            <P>
                <ea:PageBreak id="PageBreak1" runat="server" BreakFirstTimes="False"></ea:PageBreak>
                <cc1:ReportHeader id="ReportHeader1" title="{0}|{1}|</STRONG>Dokument: <STRONG>{2}|</STRONG>Magazyn: <STRONG>{3}|</STRONG>Data i miejsce wystawienia: <STRONG>{4}, {5}"
                    runat="server" DataMember0="Definicja.TytulWydruku" DataMember1="Wydruk.OpisStanu" DataMember2="Numer" DataMember3="Magazyn.Nazwa"
                    DataMember4="Data" DataMember5="Session.Core.Config.Firma.AdresSiedziby.Miejscowosc"></cc1:ReportHeader></P>
            <P>
                <ea:Section id="SectionNad" runat="server">Nadwyżki: 
<ea:Grid id="Grid1" runat="server" Filter="Workers.InwentaryzacjaPozycji.Kierunek='Przychód'"
                        RowsInRow="2" DataMember="Pozycje" RowTypeName="Soneta.Handel.PozycjaDokHandlowego,Soneta.Handel">
                        <Columns>
                            <ea:GridColumn Width="4" Align="Right" DataMember="#" Caption="Lp." RowSpan="2" runat="server" EncodeHTML="True"></ea:GridColumn>
                            <ea:GridColumn Width="15" DataMember="Towar.Kod" Caption="Kod" EncodeHTML="True" runat="server"></ea:GridColumn>
                            <ea:GridColumn ColSpan="2" DataMember="Towar.Nazwa" Caption="Nazwa towaru" runat="server" EncodeHTML="True"></ea:GridColumn>
                            <ea:GridColumn DataMember="Towar.NumerKatalogowy" Caption="Numer katalogowy" runat="server" EncodeHTML="True"></ea:GridColumn>
                            <ea:GridColumn Width="10" Align="Right" DataMember="Workers.InwentaryzacjaPozycji.IlośćŁączna.Value"
                                Caption="Ilość~spisana" runat="server" EncodeHTML="True"></ea:GridColumn>
                            <ea:GridColumn Width="10" Align="Right" DataMember="Workers.InwentaryzacjaPozycji.StanZamknięcia.Value"
                                Caption="przed" runat="server" EncodeHTML="True"></ea:GridColumn>
                            <ea:GridColumn Width="10" Align="Right" DataMember="Workers.InwentaryzacjaPozycji.R&#243;żnicaIlości.Value"
                                Caption="Ilość~r&#243;żnica" runat="server" EncodeHTML="True"></ea:GridColumn>
                            <ea:GridColumn runat="server" EncodeHTML="True"></ea:GridColumn>
                            <ea:GridColumn Width="5" Align="Center" DataMember="Ilosc.Symbol" Caption="jm." RowSpan="2" runat="server" EncodeHTML="True"></ea:GridColumn>
                            <ea:GridColumn Width="12" Align="Right" DataMember="Workers.InwentaryzacjaPozycji.CenaR&#243;żnicy"
                                Total="Info" Caption="Cena|godziwa" Format="{0:n}" RowSpan="2" runat="server" EncodeHTML="True"></ea:GridColumn>
                            <ea:GridColumn Width="11" Align="Right" DataMember="Workers.InwentaryzacjaPozycji.WartośćZamknięcia"
                                Total="Sum" Caption="Wartość|przed" Format="{0:n}" RowSpan="2" runat="server" EncodeHTML="True"></ea:GridColumn>
                            <ea:GridColumn Width="11" Align="Right" DataMember="Workers.InwentaryzacjaPozycji.R&#243;żnicaWartości"
                                Total="Sum" Caption="Wartość|zmiana" Format="{0:n}" RowSpan="2" runat="server" EncodeHTML="True"></ea:GridColumn>
                            <ea:GridColumn Width="11" Align="Right" DataMember="Workers.InwentaryzacjaPozycji.WartośćPoInwentaryzacji"
                                Total="Sum" Caption="Wartość|po" Format="{0:n}" RowSpan="2" runat="server" EncodeHTML="True"></ea:GridColumn>
                        </Columns>
                    </ea:Grid></ea:Section></P>
            <P>
                <ea:Section id="SectionStr" runat="server">Straty: 
<ea:Grid id="Grid2" runat="server" Filter="Workers.InwentaryzacjaPozycji.Kierunek='Rozchód'"
                        RowsInRow="2" DataMember="Pozycje" RowTypeName="Soneta.Handel.PozycjaDokHandlowego,Soneta.Handel">
                        <Columns>
                            <ea:GridColumn Width="4" Align="Right" DataMember="#" Caption="Lp." RowSpan="2" EncodeHTML="True" runat="server"></ea:GridColumn>
                            <ea:GridColumn Width="15" DataMember="Towar.Kod" Caption="Kod" EncodeHTML="True" runat="server"></ea:GridColumn>
                            <ea:GridColumn ColSpan="2" DataMember="Towar.Nazwa" Caption="Nazwa towaru" EncodeHTML="True" runat="server"></ea:GridColumn>
                            <ea:GridColumn DataMember="Towar.NumerKatalogowy" Caption="Numer katalogowy" EncodeHTML="True" runat="server"></ea:GridColumn>
                            <ea:GridColumn Width="10" Align="Right" DataMember="Workers.InwentaryzacjaPozycji.IlośćŁączna.Value"
                                Caption="Ilość~spisana" EncodeHTML="True" runat="server"></ea:GridColumn>
                            <ea:GridColumn Width="10" Align="Right" DataMember="Workers.InwentaryzacjaPozycji.StanZamknięcia.Value"
                                Caption="przed" EncodeHTML="True" runat="server"></ea:GridColumn>
                            <ea:GridColumn Width="10" Align="Right" DataMember="Workers.InwentaryzacjaPozycji.R&#243;żnicaIlości.Value"
                                Caption="Ilość~r&#243;żnica" EncodeHTML="True" runat="server"></ea:GridColumn>
                            <ea:GridColumn EncodeHTML="True" runat="server"></ea:GridColumn>
                            <ea:GridColumn Width="5" Align="Center" DataMember="Ilosc.Symbol" Caption="jm." RowSpan="2" EncodeHTML="True" runat="server"></ea:GridColumn>
                            <ea:GridColumn Width="12" Align="Right" DataMember="Workers.InwentaryzacjaPozycji.CenaR&#243;żnicy"
                                Total="Info" Caption="Cena|zakupu" Format="{0:n}" RowSpan="2" EncodeHTML="True" runat="server"></ea:GridColumn>
                            <ea:GridColumn Width="11" Align="Right" DataMember="Workers.InwentaryzacjaPozycji.WartośćZamknięcia"
                                Total="Sum" Caption="Wartość|przed" Format="{0:n}" RowSpan="2" EncodeHTML="True" runat="server"></ea:GridColumn>
                            <ea:GridColumn Width="11" Align="Right" DataMember="Workers.InwentaryzacjaPozycji.R&#243;żnicaWartości"
                                Total="Sum" Caption="Wartość|zmiana" Format="{0:n}" RowSpan="2" EncodeHTML="True" runat="server"></ea:GridColumn>
                            <ea:GridColumn Width="11" Align="Right" DataMember="Workers.InwentaryzacjaPozycji.WartośćPoInwentaryzacji"
                                Total="Sum" Caption="Wartość|po" Format="{0:n}" RowSpan="2" EncodeHTML="True" runat="server"></ea:GridColumn>
                        </Columns>
                    </ea:Grid></ea:Section></P>
            <P>
                <ea:DataLabel id="Opis" runat="server" Bold="False" EncodeHTML="False"></ea:DataLabel>
                <cc1:ReportFooter id="ReportFooter1" runat="server" Height="105px" TheEnd="False">
                    <Subtitles>
                        <cc1:FooterSubtitle Caption="Operator" ID="stPodpis" SubtitleType="CenterText" Width="50"></cc1:FooterSubtitle>
                        <cc1:FooterSubtitle Caption="Osoba" ID="stOsoba" SubtitleType="CenterText" Width="50"></cc1:FooterSubtitle>
                    </Subtitles>
                </cc1:ReportFooter></P>
            <ea:SectionMarker id="SectionMarker6" runat="server" SectionType="Footer"></ea:SectionMarker>
        </form>
    </body>
</HTML>

