﻿<%@ import Namespace="Soneta.Magazyny" %>
<%@ import Namespace="Soneta.Handel" %>
<%@ import Namespace="Soneta.Business" %>
<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="System.Collections.Generic" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Page Language="c#" autoeventwireup="false" CodePage="1200" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<html xmlns="http://www.w3.org/1999/xhtml">
	<head>
		<title>Dokumenty sprzedaży</title>
		<meta content="C#" name="CODE_LANGUAGE" />
		<meta content="JavaScript" name="vs_defaultClientScript" />
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema" />
	</head>
	<script runat="server">
		
        public class RkzParamBase : ContextBase {


            private Magazyn _magazyn;

            [Soneta.Tools.Priority(1)]
            [Context(Required=false)]
            public Magazyn Magazyn {
                get { return _magazyn; }
                set { 
                    _magazyn = value;		   
                }
            }


            private FromTo _okres = FromTo.Month(Date.Now); 
            [Soneta.Tools.Priority(5)]
            [Context(Required=false)]
            public FromTo Okres {
                get { return _okres; }
                set { _okres = value; }
            }
            
            bool _ignorujZaliczkowe = false;			
            [Soneta.Tools.Priority( 10 )]
            public bool IgnorujZaliczkowe {
                get {
                    return this._ignorujZaliczkowe;
                }
                set {
                    this._ignorujZaliczkowe = value;
                    OnChanged( EventArgs.Empty );
                }
            }

			[Soneta.Tools.Priority(20)]
			public bool IgnorujDuplikaty
			{
				get
				{
					return true;
				}
			}

			[Soneta.Tools.Priority(30)]
			[Caption("Korekty kosztu (KWPZ)")]
			public bool KWPZ
			{
				get
				{
					return true;
				}
			}

			[Soneta.Tools.Priority(40)]
			[Caption(@"Niezafakturowane WZ")]
			public bool NiefakturowaneRozchody
			{
				get { return true; }
			}
            

            public RkzParamBase(Context context)
                : base(context) 
			{
				context.Set(this);
			}
        }

        public static class RkzTools {
            /// <summary>
            /// Zwraca wartość wskazującą na to, czy dokument zostanie uwzględniony w raporcie RKZ.
            /// </summary>
            /// <param name="dokument">Dokument badany.</param>
            /// <remarks>Jeśli dokument jest magazynowy to warunkiem uwzględnienia w raporcie jest obecność dokumentu handlowego.
            /// Aby dokument mógł być uwzględniony w raporcie musi być zatwierdzony.</remarks>
            public static bool IsVisible(RkzParamBase param, DokumentHandlowy dokument) {
                bool v = dokument.Stan == StanDokumentuHandlowego.Zatwierdzony ||
                         dokument.Stan == StanDokumentuHandlowego.Zablokowany;

                if (v && IsMagazynowy(dokument) && dokument.KierunekMagazynu == Soneta.Magazyny.KierunekPartii.Rozchód) {
                    if ((v = param.NiefakturowaneRozchody)) {
                        DokumentHandlowy[] dok = new DokumentHandlowy[] 
					{
						dokument.Nadrzędne[TypRelacjiHandlowej.HandlowoMagazynowa],
						dokument.Podrzędne[TypRelacjiHandlowej.HandlowoMagazynowa]
					};
                        for (int i = 0; i < dok.Length; i++) {
                            if (v && dok[i] != null) {
                                v = false;
                            }
                        }
                    }
                }
                return v;
            }

            /// <summary>
            /// Zwraca wartość wskazującą na to czy dokument jest dokumentem magazynowym w rozumieniu raportu RKZ.
            /// </summary>
            /// <param name="dok">Dokument badany.</param>
            public static bool IsMagazynowy(DokumentHandlowy dok) {
                return (dok.Stan == StanDokumentuHandlowego.Zatwierdzony ||
                        dok.Stan == StanDokumentuHandlowego.Zablokowany) &&
                       dok.TypPartii == Soneta.Magazyny.TypPartii.Magazynowy;
            }
        }
	       
		private RkzParamBase _params;

		[Context]
		public RkzParamBase Params
		{
			get { return _params; }
			set { _params = value; }
		}
        		
        HandelModule hm;

        // public Soneta.Handel.Forms.DokHandloweViewInfo.WParams pars;
	       
        void dc_ContextLoad(object sender, EventArgs args) {
	    string title= String.Format("Rozliczenie Kosztów Zakupu RKZ|</STRONG>Okres:<STRONG> {0}|</STRONG>Magazyn:<STRONG> {1}</STRONG>|<span style='font-size: 7pt;'>Data wydruku: {2}</span>" , Params.Okres, Params.Magazyn, Date.Today);
	    ReportHeader.Title = title;

            //dlTimeStart.EditValue = Date.Now.ToShortDateString() + ", " + Date.Now.ToShortTimeString();
            
			// TASK: 3501. [5.1.2]
			const string cat = @"Kategoria"; 
			
			dc.Context.Set(Soneta.Types.Date.Today);
	        hm = HandelModule.GetInstance(dc);
        		
	        SubTable st;

            Magazyn magazyn = Params.Magazyn;
	        if (magazyn==null)
		        st = hm.DokHandlowe.WgDaty;
	        else
		        st = hm.DokHandlowe.WgMagazyn[magazyn];
        	
	        //pars = (Soneta.Handel.Forms.DokHandloweViewInfo.WParams)
		  //      dc[typeof(Soneta.Handel.Forms.DokHandloweViewInfo.WParams)];

            RowCondition cond = new FieldCondition.Contain("Data", Params.Okres);
            cond &= new FieldCondition.Contain("Kategoria",
                KategoriaHandlowa.HandelPierwszy, KategoriaHandlowa.HandelOstatni);
	        cond &= new FieldCondition.Equal("Definicja.DuplikatWartosci", false);
	        cond &= new FieldCondition.NotEqual("Stan", StanDokumentuHandlowego.Anulowany);
            cond &= new FieldCondition.NotEqual("Stan", StanDokumentuHandlowego.Bufor);
            //cond &= new FieldCondition.NotEqual("Definicja.EdycjaWartosci", EdycjaWartosciDokumentu.PozwalajNaMniejsząKwotę);
	        cond &= new FieldCondition.Equal("Definicja.KierunekMagazynu", KierunekPartii.Rozchód);

            SubTable stG = st[cond];
            stG.ForceAllRows();
	        Grid.DataSource = stG;

            RowCondition cond1 = new FieldCondition.Contain("Data", Params.Okres);
            cond1 &=
                new FieldCondition.Equal(cat, KategoriaHandlowa.WydanieMagazynowe) |
                new FieldCondition.Equal(cat, KategoriaHandlowa.KorektaWydaniaMagazynowego);
            cond1 &= new FieldCondition.Equal("Definicja.DuplikatWartosci", false);
            cond1 &= new FieldCondition.NotEqual("Stan", StanDokumentuHandlowego.Anulowany);
            cond1 &= new FieldCondition.NotEqual("Stan", StanDokumentuHandlowego.Bufor);
            cond1 &= new FieldCondition.Equal("Definicja.KierunekMagazynu", KierunekPartii.Rozchód);

            SubTable stG1 = st[cond1];
            stG1.ForceAllRows();
            Grid1.DataSource = stG1;

	        RowCondition condK = new FieldCondition.Contain("Data", Params.Okres) &
                                 new FieldCondition.Equal("Definicja", hm.DefDokHandlowych.KorektaPZWZ);

            SubTable stGK = st[condK];
            stGK.ForceAllRows();
            GridKor.DataSource = stGK;
            GridKor1.DataSource = stGK;

            sWydaniaNiefakturowane.Visible = Params.NiefakturowaneRozchody;
            sKorektyKosztuWydanNiefakturowanych.Visible = Params.NiefakturowaneRozchody;
			sIgnorujZaliczkowe.Visible = Params.IgnorujZaliczkowe;
        }

        private bool HandlowyLubNadrzędny (DokumentHandlowy d, FromTo o) {
            if (d == null)
                return false;
            if (JestHandlowy(d) && o.Contains(d.Data))
                return true;
            bool r = false;
            foreach (RelacjaHandlowa rel in d.Module.RelacjeHandlowe.WgPodrzedny[d]) {
                if(rel.Typ == TypRelacjiHandlowej.HandlowoMagazynowa 
					|| rel.Typ == TypRelacjiHandlowej.Korekta
					// TASK: 7903. [7.3] /sbm
					|| rel.Typ == TypRelacjiHandlowej.KorektaPWZ)
                   r |= HandlowyLubNadrzędny(rel.Nadrzedny, o);
            }
            return r;
        }
   
        private bool HandlowyLubPodrzędny(DokumentHandlowy d, FromTo o) {
            if (d == null)
                return false;
            if (JestHandlowy(d) && o.Contains(d.Data))
                return true;
            bool r = false;
            foreach (RelacjaHandlowa rel in d.Module.RelacjeHandlowe.WgNadrzedny[d]) {
                if (rel.Typ == TypRelacjiHandlowej.HandlowoMagazynowa
					|| rel.Typ == TypRelacjiHandlowej.Korekta
					// TASK: 7903. [7.3] /sbm
					|| rel.Typ == TypRelacjiHandlowej.KorektaPWZ)
                    r |= HandlowyLubPodrzędny(rel.Podrzedny, o);
            }
            return r;
        }

        IEnumerable<DokumentHandlowy> WyszukajDokumentyMagazynowe(DokumentHandlowy dok) {
            foreach (DokumentHandlowy mag in dok.DokumentyMagazynowe)
                if (mag != dok) {
                    if (mag.Korekta) {
                        foreach (DokumentHandlowy kor in mag.DokumentyKorygowane) {
                            if (kor != mag) {
                                foreach (DokumentHandlowy korm in WyszukajDokumentyMagazynowe(kor)) {                                                                        
                                    yield return korm;
                                }
                                yield return kor;
                            }
                        }
                    }
                    else {
                        foreach (DokumentHandlowy mag2 in WyszukajDokumentyMagazynowe(mag))
                            yield return mag2;
                    }                    
                    yield return mag;
                }
        }

		// TASK: 7903. [7.3] /sbm			
		private static void DodajKWPZ(ref decimal zakup, DokumentHandlowy kwpz, Date data)
		{
			if (kwpz != null && kwpz.Data < data)
			{
				zakup += kwpz.WartośćWCenieZakupu;
				DodajKWPZ(ref zakup, kwpz.Podrzędne[TypRelacjiHandlowej.KorektaPWZ], data);
			}
		}
            
	    void Grid_BeforeRow(Object sender, RowEventArgs args) {
	        DokumentHandlowy dok = (DokumentHandlowy)args.Row;
	        DokumentHandlowy mag = dok.DokumentMagazynowyGłówny;

            bool visible = HandlowyLubPodrzędny(dok, Params.Okres) || HandlowyLubNadrzędny(dok, Params.Okres);
            
            args.VisibleRow = visible &&
                              RkzTools.IsVisible(this.Params, dok) &&
    		                  !mag.Definicja.Wewnetrzny;

            if( Params.IgnorujZaliczkowe )
                args.VisibleRow = !dok.JestDokZaliczkowy();
                                    
	        if (!args.VisibleRow) return;

            IEnumerable<DokumentHandlowy> mags = null;
            
            decimal wartoscZakupu = dok.Bufor ? dok.WartośćWCenieZakupuBufor : dok.WartośćWCenieZakupu;

        /*
            if (dok.Korekta) {
                wartoscZakupu = dok.WartośćWCenieZakupu;
            }
            else {
                if(mags == null)
                    mags = WyszukajDokumentyMagazynowe(dok);
				foreach (DokumentHandlowy m in mags)
				{
					wartoscZakupu += m.WartośćWCenieZakupu;
					// TASK: 7903. [7.3] /sbm			
					foreach (RelacjaHandlowa rh in m.PodrzedneRelacje)
					{
						if (rh.Typ == TypRelacjiHandlowej.KorektaPWZ)
						{
							DodajKWPZ(ref wartoscZakupu, m.Podrzędne[TypRelacjiHandlowej.KorektaPWZ], Params.Okres.From);
						}
					}
				}
            }
*/
            
            ColZakupNetto.EditValue = wartoscZakupu;

            /*
            bool wyróżnić = wartoscZakupu != dok.WartośćWCenieZakupu;
            
            ColZakupNetto.Format = wyróżnić ? "<strong>{0}</strong>" : string.Empty;
            ColZakupNetto.EncodeHTML = !wyróżnić;
            */
            
            ColSprzedazNetto.EditValue = dok.Suma.Netto;
            // ColSprzedazBrutto.EditValue = dok.Suma.Brutto;
            
            /*
            ObrotyDokumentuWorker odw = new ObrotyDokumentuWorker();
            odw.Dokument = dok;
            odw.IgnorujZaliczkowe = true;

            bool wyróżnićSp = (decimal)ColSprzedazNetto.EditValue != odw.WartośćSprzedaży;

            ColSprzedazNetto.Format = wyróżnićSp ? "<strong>{0}</strong>" : string.Empty;
            ColSprzedazNetto.EncodeHTML = !wyróżnićSp;

            ColSprzedazBrutto.Format = wyróżnićSp ? "<strong>{0}</strong>" : string.Empty;
            ColSprzedazBrutto.EncodeHTML = !wyróżnićSp;            
            */
            
            ColZyskWartosc.EditValue =
                (decimal)ColSprzedazNetto.EditValue - wartoscZakupu;


            if ((decimal)ColSprzedazNetto.EditValue!=0)
                ColMarzaProcent.EditValue = new Percent(
                    (decimal)ColZyskWartosc.EditValue / (decimal)ColSprzedazNetto.EditValue);
            else
                ColMarzaProcent.EditValue = Percent.Blank;
            if (dok.Numer.NumerPelny == dok.DokumentMagazynowyNumer) {
                colDokHanNumer.EditValue = string.Empty;
                colDokHanData.EditValue = Date.Empty;
            } else {
                colDokHanNumer.EditValue = dok.Numer.NumerPelny;
                colDokHanData.EditValue = dok.Data;     
            }

            if (mags == null)
                mags = WyszukajDokumentyMagazynowe(dok);
            foreach (DokumentHandlowy m in mags) {
                colDokMagNumer.EditValue += ((string)colDokMagNumer.EditValue != string.Empty ? " " : "")
                                         + m.Numer.Pelny;
                colDokMagData.EditValue += ((string)colDokMagData.EditValue != string.Empty ? " " : "")
                                         + m.Data.ToString("yyyy-MM-dd");
            }

            mags = null;
        }

        void Grid1_BeforeRow (Object sender, RowEventArgs args) {
            DokumentHandlowy dok = (DokumentHandlowy)args.Row;
            DokumentHandlowy mag = dok.DokumentMagazynowyGłówny;

            bool visible = !HandlowyLubPodrzędny(dok, Params.Okres) && !HandlowyLubNadrzędny(dok, Params.Okres);
            
            args.VisibleRow = visible &&
                              //RkzTools.IsVisible(this.Params, dok) &&
                              !mag.Definicja.Wewnetrzny;
            
            if(!args.VisibleRow) return;
            
            ColZakupNetto1.EditValue = mag.WartośćWCenieZakupu;

            ColSprzedazNetto1.EditValue = dok.Suma.Netto;
            // ColSprzedazBrutto1.EditValue = dok.Suma.Brutto;            
            
            ColZyskWartosc1.EditValue =
                (decimal)ColSprzedazNetto1.EditValue - (decimal)ColZakupNetto1.EditValue;

            if((decimal)ColSprzedazNetto1.EditValue != 0)
                ColMarzaProcent1.EditValue = new Percent(
                    (decimal)ColZyskWartosc1.EditValue / (decimal)ColSprzedazNetto1.EditValue);
            else
                ColMarzaProcent1.EditValue = Percent.Blank;
            if(dok.Numer.NumerPelny == dok.DokumentMagazynowyNumer) {
                colDokHanNumer1.EditValue = string.Empty;
                colDokHanData1.EditValue = Date.Empty;
            }
            else {
                colDokHanNumer1.EditValue = dok.Numer.NumerPelny;
                colDokHanData1.EditValue = dok.Data;
            }

             
            colDokMagNumer1.EditValue += mag.Numer.Pelny;
            colDokMagData1.EditValue += mag.Data.ToString("yyyy-MM-dd");
            /*
            bool wyróżnić = FakturowanyLubPodrzędny(mag, FromTo.All) || FakturowanyLubNadrzędny(mag, FromTo.All);

            colDokMagNumer1.Format = wyróżnić ? "<strong>{0}</strong>" : string.Empty;
            colDokMagNumer1.EncodeHTML = !wyróżnić;
            */
        }
   
        bool testDok(DokumentHandlowy dok) {
            foreach (DokumentHandlowy wz in dok.Nadrzędne) {
                if (wz.Definicja==hm.DefDokHandlowych.KorektaPZWZ) {
                    if (testDok(wz)) return true;
                }  
                else if (wz.KierunekMagazynu==KierunekPartii.Rozchód &&
                        !wz.Definicja.Wewnetrzny) {
                    
					if (JestHandlowy(wz) ||
                        RkzTools.IsVisible(this.Params, wz) ||
                        wz.DokumentyHandlowe.Length > 0)
                        return true;
                }
            }
            return false; 
        }         

        protected void GridKor_BeforeRow(object sender, RowEventArgs args) {
            DokumentHandlowy dok = (DokumentHandlowy)args.Row;
            if (!testDok(dok)) 
                args.VisibleRow = false;
            
            if (!args.VisibleRow) return;

            bool v = false;
            foreach (RelacjaHandlowa reln in dok.NadrzedneRelacje) {
                if (reln.Typ == TypRelacjiHandlowej.KorektaPWZ && reln.Nadrzedny.KierunekMagazynu == KierunekPartii.Rozchód) {
                    v |= HandlowyLubNadrzędny(reln.Nadrzedny, FromTo.All) || HandlowyLubPodrzędny(reln.Nadrzedny, FromTo.All);
                    if (v) break;
                }
            }

            if(!v)
                foreach (RelacjaHandlowa reln in dok.PodrzedneRelacje) {
                    if (reln.Typ == TypRelacjiHandlowej.KorektaPWZ && reln.Podrzedny.KierunekMagazynu == KierunekPartii.Rozchód) {
                        v |= HandlowyLubNadrzędny(reln.Podrzedny, FromTo.All) || HandlowyLubPodrzędny(reln.Podrzedny, FromTo.All);
                        if (v) break;
                    }
                }

            args.VisibleRow = v;
        }

        protected void GridKor1_BeforeRow(object sender, RowEventArgs args) {
            DokumentHandlowy dok = (DokumentHandlowy)args.Row;

            if (!testDok(dok))
                args.VisibleRow = false;

            if (!args.VisibleRow) return;

            bool v = true;
            foreach (RelacjaHandlowa reln in dok.NadrzedneRelacje) {
                if (reln.Typ == TypRelacjiHandlowej.KorektaPWZ && reln.Nadrzedny.KierunekMagazynu == KierunekPartii.Rozchód) {
                    v &= !HandlowyLubNadrzędny(reln.Nadrzedny, FromTo.All) && !HandlowyLubPodrzędny(reln.Nadrzedny, FromTo.All);
                    if (!v) break;
                }
            }

            if (v)
                foreach (RelacjaHandlowa reln in dok.PodrzedneRelacje) {
                    if (reln.Typ == TypRelacjiHandlowej.KorektaPWZ && reln.Podrzedny.KierunekMagazynu == KierunekPartii.Rozchód) {
                        v &= !HandlowyLubNadrzędny(reln.Podrzedny, FromTo.All) && !HandlowyLubPodrzędny(reln.Podrzedny, FromTo.All);
                        if (!v) break;
                    }
                }

            args.VisibleRow = v;
        } 
                
        private static bool JestHandlowy(DokumentHandlowy dok)
        {
            return KategoriaHandlowa.HandelPierwszy<=dok.Kategoria && dok.Kategoria<=KategoriaHandlowa.HandelOstatni;
        }

        public class Total {
            readonly int _lp;
            readonly string _key;
            readonly decimal _value;
            public Total(int lp, string key, decimal value) {
                _lp = lp;
                _key = key;
                _value = value;
            }
            public int Lp { get { return _lp;} }
            public string Key { get { return _key; } }
            public decimal Value { get { return _value; } }
        }
	       
	    void GridKor1_AfterRender(Object sender, EventArgs args) {
            ArrayList arr = new ArrayList();
            decimal v;
            int lp = 1;

            if (sWydaniaFakturowane.Visible) {
                v = ColZakupNetto.TotalValue == null ? 0.00m : (decimal)ColZakupNetto.TotalValue;
                arr.Add(new Total(lp++, @"Wydania fakturowane", v));
            }

            if (sKorektyKosztuWydanFakturowanych.Visible) {
                v = ColZakupNettoK.TotalValue == null ? 0.00m : (decimal)ColZakupNettoK.TotalValue;
                arr.Add(new Total(lp++, @"Korekty kosztu sprzedaży (wynikające z korekt zakupu)", v));
            }
            
            if (sWydaniaNiefakturowane.Visible) {
                v = ColZakupNetto1.TotalValue == null ? 0.00m : (decimal)ColZakupNetto1.TotalValue;
                arr.Add(new Total(lp++, @"Wydania niefakturowane", v));
            }

            if (sKorektyKosztuWydanNiefakturowanych.Visible) {
                v = ColZakupNettoK1.TotalValue == null ? 0.00m : (decimal)ColZakupNettoK1.TotalValue;
                arr.Add(new Total(lp++, @"Korekty kosztu wydań niefakturowanych", v));
            }
            
            GridTotal.DataSource = arr;
            /*
	        decimal vs = ColSprzedazNetto.TotalValue==null ? 0 : (decimal)ColSprzedazNetto.TotalValue;
            vs += ColSprzedazNetto1.TotalValue == null ? 0 : (decimal)ColSprzedazNetto1.TotalValue;
	        ZyskRazemLabel.EditValue = vs-v;
        	
            if (vs!=0)
                MarzaRazemLabel.EditValue = new Percent((vs-v) / vs);
            else
                MarzaRazemLabel.EditValue = Percent.Blank;
        	
            if (v!=0)
                NarzutRazemLabel.EditValue = new Percent((vs-v) / v);
            else
                NarzutRazemLabel.EditValue = Percent.Blank;
            */
            //dlTimeStop.EditValue = Date.Now.ToShortDateString() + ", " + Date.Now.ToShortTimeString();
        }

</script>
	<body>
		<form id="Form1" runat="server">
			<p>
				<ea:datacontext id="dc" runat="server" OnContextLoad="dc_ContextLoad"></ea:datacontext>				
				<eb:reportheader id="ReportHeader" runat="server" ></eb:reportheader>
				<font face="Verdana" size="2">Raport nie uwzględnia duplikatów wartości.</font>
				<br />
				<ea:Section runat="server" ID="sIgnorujZaliczkowe">
					<font face="Verdana" size="2">Raport nie uwzględnia faktur zaliczkowych.</font>
					<br />
				</ea:Section>
				<ea:Section runat="server" ID="sWydaniaFakturowane">
					<font face="Verdana" size="2">Wydania fakturowane (tabela może zawierać wydania z poprzedniego okresu fakturowane w bieżącym)</font>
					<br />
					<ea:grid id="Grid" runat="server" OnBeforeRow="Grid_BeforeRow" 
                            RowTypeName="Soneta.Handel.DokumentHandlowy,Soneta.Handel">
					<Columns>
						<ea:GridColumn runat="server" Width="4" Align="Right" DataMember="#" Caption="LP." EncodeHTML="True"></ea:GridColumn>
						<ea:GridColumn runat="server" ID="colDokHanNumer" Align="Left" Caption="Dokument handlowy~Numer" EncodeHTML="True"></ea:GridColumn>
						<ea:GridColumn runat="server" ID="colDokHanData" Width="10" Align="Center" Caption="Dokument handlowy~Data" EncodeHTML="True"></ea:GridColumn>
						<ea:GridColumn runat="server" ID="colDokMagNumer" Caption="Dokument magazynowy~Numer" EncodeHTML="True"></ea:GridColumn>
						<ea:GridColumn runat="server" Width="10" ID="colDokMagData" Caption="Dokument magazynowy~Data" EncodeHTML="True"></ea:GridColumn>
						<ea:GridColumn runat="server" Width="14" Align="Right" Total="Sum" Caption="Koszt własny|sprzedaży" Format="{0:n}" ID="ColZakupNetto" EncodeHTML="True"></ea:GridColumn>
						<ea:GridColumn runat="server" Width="14" Align="Right" Total="Sum" Caption="Wartość|sprzedaży|netto" Format="{0:n}" ID="ColSprzedazNetto" EncodeHTML="True"></ea:GridColumn>
						<ea:GridColumn runat="server" Width="14" Align="Right" Total="Sum" Caption="Marża~Wartość" Format="{0:n}" ID="ColZyskWartosc" EncodeHTML="True"></ea:GridColumn>
						<ea:GridColumn runat="server" Width="8" Align="Right" Caption="Marża~Marża%" ID="ColMarzaProcent" EncodeHTML="True"></ea:GridColumn>
					</Columns>
				    </ea:grid>
				    </ea:Section>
				    <br />
				    <ea:Section runat="server" ID="sKorektyKosztuWydanFakturowanych">
					<font face="Verdana" size="2">Korekty kosztu sprzedaży (wynikające z korekt zakupu)</font>
					<br />
					<ea:grid id="GridKor" runat="server" RowTypeName="Soneta.Handel.DokumentHandlowy,Soneta.Handel"
						OnBeforeRow="GridKor_BeforeRow">
						<Columns>
							<ea:GridColumn ID="GridColumn2" runat="server" Width="4" Align="Right" DataMember="#" Caption="LP." EncodeHTML="True"></ea:GridColumn>
							<ea:GridColumn ID="GridColumn3" runat="server" Width="40" DataMember="DokumentMagazynowyNumer" Caption="Dokument magazynowy~Numer" EncodeHTML="True"></ea:GridColumn>
							<ea:GridColumn ID="GridColumn4" runat="server" Width="15" DataMember="DokumentMagazynowyData" Caption="Dokument magazynowy~Data" EncodeHTML="True"></ea:GridColumn>
							<ea:GridColumn runat="server" Width="20" Align="Right" DataMember="WartośćWCenieZakupu" Total="Sum" Caption="Korekta kosztu|własnego|sprzedaży"
								Format="{0:n}" ID="ColZakupNettoK" EncodeHTML="True"></ea:GridColumn>
						</Columns>
					</ea:grid>
					</ea:Section>
					<br />
					<ea:Section runat="server" ID="sWydaniaNiefakturowane">
					<font face="Verdana" size="2">Wydania niefakturowane</font>
					<ea:grid id="Grid1" runat="server" OnBeforeRow="Grid1_BeforeRow" RowTypeName="Soneta.Handel.DokumentHandlowy,Soneta.Handel">
						<Columns>
							<ea:GridColumn ID="GridColumn5" runat="server" Width="4" Align="Right" DataMember="#" Caption="LP." EncodeHTML="True"></ea:GridColumn>
							<ea:GridColumn runat="server" ID="colDokHanNumer1" Align="Left" Caption="Dokument handlowy~Numer" EncodeHTML="True"></ea:GridColumn>
							<ea:GridColumn runat="server" ID="colDokHanData1" Width="10" Align="Center" Caption="Dokument handlowy~Data" EncodeHTML="True"></ea:GridColumn>
							<ea:GridColumn runat="server" ID="colDokMagNumer1" Caption="Dokument magazynowy~Numer" EncodeHTML="True"></ea:GridColumn>
							<ea:GridColumn runat="server" Width="10" ID="colDokMagData1" Caption="Dokument magazynowy~Data" EncodeHTML="True"></ea:GridColumn>
							<ea:GridColumn runat="server" Width="14" Align="Right" Total="Sum" Caption="Koszt|własny|sprzedaży" Format="{0:n}" ID="ColZakupNetto1" EncodeHTML="True"></ea:GridColumn>
							<ea:GridColumn runat="server" Width="14" Align="Right" Total="Sum" Caption="Wartość|sprzedaży|netto" Format="{0:n}" ID="ColSprzedazNetto1" EncodeHTML="True"></ea:GridColumn>
							<ea:GridColumn runat="server" Width="14" Align="Right" Total="Sum" Caption="Marża~Wartość" Format="{0:n}" ID="ColZyskWartosc1" EncodeHTML="True"></ea:GridColumn>
							<ea:GridColumn runat="server" Width="8" Align="Right" Caption="Marża~Marża%" ID="ColMarzaProcent1" EncodeHTML="True"></ea:GridColumn>
						</Columns>
					</ea:grid>
					</ea:Section>
					<br />					
					<ea:Section runat="server" ID="sKorektyKosztuWydanNiefakturowanych">
					<font face="Verdana" size="2">Korekty kosztu wydań niefakturowanych</font>
					<ea:grid id="GridKor1" runat="server" RowTypeName="Soneta.Handel.DokumentHandlowy,Soneta.Handel"
						OnAfterRender="GridKor1_AfterRender" OnBeforeRow="GridKor1_BeforeRow">
						<Columns>
							<ea:GridColumn ID="GridColumn1" runat="server" Width="4" Align="Right" DataMember="#" Caption="LP." EncodeHTML="True"></ea:GridColumn>
							<ea:GridColumn ID="GridColumn6" runat="server" Width="40" DataMember="DokumentMagazynowyNumer" Caption="Dokument magazynowy~Numer" EncodeHTML="True"></ea:GridColumn>
							<ea:GridColumn ID="GridColumn7" runat="server" Width="15" DataMember="DokumentMagazynowyData" Caption="Dokument magazynowy~Data" EncodeHTML="True"></ea:GridColumn>
							<ea:GridColumn runat="server" Width="20" Align="Right" DataMember="WartośćWCenieZakupu" Total="Sum" Caption="Korekta kosztu|własnego|sprzedaży"
								Format="{0:n}" ID="ColZakupNettoK1" EncodeHTML="True"></ea:GridColumn>
					</Columns>
					</ea:grid>					
					</ea:Section>
					<br />
					<font face="Verdana" size="2">Podsumowanie</font>
					<ea:grid id="GridTotal" runat="server">
						<Columns>
							<ea:GridColumn runat="server" Width="4" Align="Right" DataMember="Lp" Caption="LP." EncodeHTML="True"></ea:GridColumn>
							<ea:GridColumn runat="server" Width="50" DataMember="Key" Caption="Tabela" EncodeHTML="True"></ea:GridColumn>
							<ea:GridColumn runat="server" Width="25" DataMember="Value" Caption="Koszt własny sprzedaży" EncodeHTML="True" Align="Right"></ea:GridColumn>
						</Columns>
					</ea:grid>
					<br />
				<eb:reportfooter id="ReportFooter" runat="server" TheEnd="False"></eb:reportfooter></p>
				<!--
				<br />
				<ea:DataLabel id="dlTimeStart" runat="server"></ea:DataLabel>
				<br />
				<ea:DataLabel id="dlTimeStop" runat="server"></ea:DataLabel>
				-->
		</form> 	
	</body>     	
</html>         	