﻿<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Page language="c#" AutoEventWireup="false" codePage="1200" %>
<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Handel" %>
<%@ Import Namespace="Soneta.Towary" %>
<%@ Import Namespace="Soneta.Magazyny" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<script runat="server">
    
    DokumentyParams pars;

    [Context]
    public DokumentyParams Pars {
        get { return pars; }
        set { pars = value; }
    }

    Towar towar;

    [Context]
    public Towar Towar {
        get { return towar; }
        set { towar = value; }
    }

    protected void dc_ContextLoading(object sender, EventArgs e) {
        if (!dc.Context.Contains(typeof(DokumentyParams)))
            throw new InvalidOperationException("Raport dostępny po uzupełnieniu parametrów na zakładace pozycji towaru.");
    }

    protected void dc_ContextLoad(object sender, EventArgs e) {
        SubTable st = Towar.Pozycje;
        if (pars.OkresDat != FromTo.All)
            st = new SubTable(st, pars.OkresDat);

        Soneta.Business.View view = st.CreateView();

        pars.AddKierunekSeriaDefinicja(view, "Dokument.", true);

        view.Condition &= new FieldCondition.Contain("Dokument.Kategoria",
			KategoriaHandlowa.HandelPierwszy, KategoriaHandlowa.HandelOstatni);

        if (pars.Magazyn != null)
            view.Condition &= new FieldCondition.Equal("Dokument.Magazyn", pars.Magazyn);

        if (!pars.Duplikaty)
            view.Condition &= new FieldCondition.Equal("Dokument.Definicja.DuplikatWartosci", false);

        Grid.DataSource = view;
    }

</script>
<HTML>
	<HEAD>
		<TITLE>Pozycje handlowe towaru</TITLE>
		<META content="C#" name="CODE_LANGUAGE">
		<META content="JavaScript" name="vs_defaultClientScript">
		<META content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<BODY>
		<FORM method="post" runat="server">
			<ea:DataContext ID="dc" runat="server" TypeName="Soneta.Towary.Towar,Soneta.Handel" OnContextLoad="dc_ContextLoad" OnContextLoading="dc_ContextLoading"></ea:DataContext>
			<eb:ReportHeader id="ReportHeader" runat="server" title="Towar {0} w dokumentach|Nazwa towaru: {1}|Magazyn: {2}|Okres: {3}" DataMember0="Kod" DataMember1="Nazwa" DataMember2="Context.Magazyn" DataMember3="Context.FromTo" ></eb:ReportHeader>
			<ea:Grid id="Grid" runat="server" RowTypeName="Soneta.Handel.PozycjaDokHandlowego,Soneta.Handel">
				<Columns>
                    <ea:GridColumn runat="server" Align="Right" Caption="Lp." DataMember="#" Width="4" EncodeHTML="True">
                    </ea:GridColumn>
					<ea:GridColumn Width="10" DataMember="Data" Runat="server" Align="Center" Caption="Dokument~data" EncodeHTML="True"></ea:GridColumn>
					<ea:GridColumn DataMember="Dokument" Runat="server" Caption="Dokument~numer" EncodeHTML="True"></ea:GridColumn>
                    <ea:GridColumn runat="server" Caption="Dokument~numer obcy" DataMember="Dokument.Obcy.Numer"
                        Width="15" EncodeHTML="True">
                    </ea:GridColumn>
                    <ea:GridColumn runat="server" Caption="Kontrahent" DataMember="Dokument.Kontrahent.Nazwa"
                        Width="30" Total="Info" EncodeHTML="True">
                    </ea:GridColumn>
                    <ea:GridColumn Runat="server" DataMember="Ilosc" Width="13" Align="Right" Total="Sum" Caption="Ilość" EncodeHTML="True"></ea:GridColumn>
                    <ea:GridColumn Runat="server" DataMember="Cena" Width="13" Align="Right" EncodeHTML="True"></ea:GridColumn>
                    <ea:GridColumn Runat="server" Align="Right" DataMember="WartoscCy" Width="13" Total="Sum" Caption="Wartość" EncodeHTML="True"></ea:GridColumn>
				</Columns>
			</ea:Grid>
			<eb:ReportFooter id="ReportFooter" runat="server"></eb:ReportFooter>
		</FORM>
	</BODY>
</HTML>

