﻿<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>

<%@ Page Language="c#" AutoEventWireup="false" CodePage="1200" %>


<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Core" %>
<%@ Import Namespace="Soneta.Deklaracje" %>
<%@ Import Namespace="Soneta.CRM" %>
<%@ Import Namespace="System.IO" %>
<%@ Import Namespace="System.Xml" %>
<%@ Import Namespace="System.Xml.XPath" %>


<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<html>
<head>
    <title>Potwierdzenie odbioru</title>

    <script runat="server">


		private string GetNazwaUrzedu(ISessionable session, string kod)
		{
			kod = (kod ?? string.Empty).Trim();
			var urzad =(UrzadSkarbowy) CRMModule.GetInstance(session).UrzedySkarbowe.WgKoduUrzedu[kod].GetNext();
			return urzad != null ? string.Format("{0} ({1})", urzad.Nazwa, kod) : kod;
		}


		void OnContextLoad(Object sender, EventArgs args)
		{
		
		var jpk = (JednolityPK)dc[typeof(JednolityPK)];
		if (jpk.StatusJPK != StatusPlikuJPK.Finished)
			throw new InvalidOperationException("Brak potwierdzenia odbioru pliku JPK przez bramkę MF.");
   
		var document = new XmlDocument();
		document.LoadXml(jpk.UPO);
		
		var nm = new XmlNamespaceManager(document.NameTable);
		nm.AddNamespace("ds", "http://www.w3.org/2000/09/xmldsig#");
		nm.AddNamespace("xades", "http://uri.etsi.org/01903/v1.3.2#");
		nm.AddNamespace("etsi", "http://uri.etsi.org/01903/v1.3.2#");

		XmlNode node, nodeToFind;

				
		nodeToFind = document.SelectSingleNode("//Potwierdzenie/NazwaPodmiotuPrzyjmujacego", nm);
		if (nodeToFind != null)
		{
			node = document.SelectSingleNode("//Potwierdzenie/NazwaPodmiotuPrzyjmujacego/text()", nm);
			FrameLabel18.EditValue = node.Value;
		}
			   
		nodeToFind = document.SelectSingleNode("//Potwierdzenie/NumerReferencyjny", nm);
		if (nodeToFind != null)
		{
			node = document.SelectSingleNode("//Potwierdzenie/NumerReferencyjny/text()", nm);
			FrameLabel36.EditValue = node.Value;
		}

		nodeToFind = document.SelectSingleNode("//Potwierdzenie/DataWplyniecia", nm);
		if (nodeToFind != null)
		{
			node = document.SelectSingleNode("//Potwierdzenie/DataWplyniecia/text()", nm);
			FrameLabel37.EditValue = node.Value;
		}

		nodeToFind = document.SelectSingleNode("//Potwierdzenie/SkrotDokumentu", nm);
		if (nodeToFind != null)
		{
			node = document.SelectSingleNode("//Potwierdzenie/SkrotDokumentu/text()", nm);
			FrameLabel38.EditValue = node.Value;
		}

		nodeToFind = document.SelectSingleNode("//Potwierdzenie/SkrotZlozonejStruktury", nm);
		if (nodeToFind != null)
		{
			node = document.SelectSingleNode("//Potwierdzenie/SkrotZlozonejStruktury/text()", nm);
			FrameLabel39.EditValue = node.Value;
		}

		nodeToFind = document.SelectSingleNode("//Potwierdzenie/NazwaStrukturyLogicznej", nm);
		if (nodeToFind != null)
		{
			node = document.SelectSingleNode("//Potwierdzenie/NazwaStrukturyLogicznej/text()", nm);
			FrameLabel40.EditValue = node.Value;
		}

		nodeToFind = document.SelectSingleNode("//Potwierdzenie/NIP1", nm);
		if (nodeToFind != null)
		{
			node = document.SelectSingleNode("//Potwierdzenie/NIP1/text()", nm);
			FrameLabel42.EditValue = "NIP " + node.Value;
		}

		nodeToFind = document.SelectSingleNode("//Potwierdzenie/PESEL1", nm);
		if (nodeToFind != null)
		{
			node = document.SelectSingleNode("//Potwierdzenie/PESEL1/text()", nm);
			FrameLabel42.EditValue = "PESEL " + node.Value;
		}
		
        nodeToFind = document.SelectSingleNode("//Potwierdzenie/NIP2", nm);
		if (nodeToFind != null)
		{
			node = document.SelectSingleNode("//Potwierdzenie/NIP2/text()", nm);
			FrameLabel41.EditValue = "NIP " + node.Value;
		}
		
        nodeToFind = document.SelectSingleNode("//Potwierdzenie/PESEL2", nm);
		if (nodeToFind != null)
		{
			node = document.SelectSingleNode("//Potwierdzenie/PESEL2/text()", nm);
			FrameLabel41.EditValue = "PESEL " + node.Value;
		}

		nodeToFind = document.SelectSingleNode("//Potwierdzenie/KodUrzedu", nm);
		if (nodeToFind != null)
		{
			node = document.SelectSingleNode("//Potwierdzenie/KodUrzedu/text()", nm);
			FrameLabel1.EditValue = GetNazwaUrzedu(jpk,node.Value);
		}					
			
		nodeToFind = document.SelectSingleNode("//Potwierdzenie/StempelCzasu", nm);
		if (nodeToFind != null)
		{
			node = document.SelectSingleNode("//Potwierdzenie/StempelCzasu/text()", nm);
			FrameLabel4.EditValue = node.Value;
		}
			   
		nodeToFind = document.SelectSingleNode("//Potwierdzenie/Signatures/ds:Signature/ds:Object/xades:QualifyingProperties/xades:SignedProperties/xades:SignedSignatureProperties/xades:SigningTime", nm);
		if (nodeToFind != null)
		{
			node = document.SelectSingleNode("//Potwierdzenie/Signatures/ds:Signature/ds:Object/xades:QualifyingProperties/xades:SignedProperties/xades:SignedSignatureProperties/xades:SigningTime/text()", nm);
			FrameLabel43.EditValue = node.Value;
		}

		nodeToFind = document.SelectSingleNode("//Potwierdzenie/Signatures/ds:Signature/ds:Object/etsi:QualifyingProperties/etsi:SignedProperties/etsi:SignedSignatureProperties/etsi:SigningTime", nm);
		if (nodeToFind != null)
		{
			node = document.SelectSingleNode("//Potwierdzenie/Signatures/ds:Signature/ds:Object/etsi:QualifyingProperties/etsi:SignedProperties/etsi:SignedSignatureProperties/etsi:SigningTime/text()", nm);
			FrameLabel43.EditValue = node.Value;
		}

		nodeToFind = document.SelectSingleNode("//ds:Signature/ds:Object/etsi:QualifyingProperties/etsi:SignedProperties/etsi:SignedSignatureProperties/etsi:SigningTime", nm);
		if (nodeToFind != null) 
        {
			node = document.SelectSingleNode("//ds:Signature/ds:Object/etsi:QualifyingProperties/etsi:SignedProperties/etsi:SignedSignatureProperties/etsi:SigningTime/text()", nm);
			FrameLabel43.EditValue = node.Value;
		}					                                                                                                                                                   				
	}
		
    </script>
    
    

</head>
<body leftmargin="0" rightmargin="0">
    <form id="potwierdzenie" method="post" runat="server">
        <ea:datacontext id="dc" style="z-index: 202; left: 189px; position: absolute; top: 0px" runat="server"
            PageZoom="106.74%" PageHeight="980" LeftMargin="13" TypeName="Soneta.Core.JednolityPK,Soneta.Core"
            oncontextload="OnContextLoad">
        </ea:datacontext>
        <ea:framelabel id="FrameLabel34" style="z-index: 101; left: 160px; position: absolute; top: 30px; height: 19px; width: 305px;"
            runat="server" Text="URZĘDOWE POŚWIADCZENIE ODBIORU" HorizontalAlign="Center"
            FrameStyle="BigBold" FrameBorderStyle="None">
        </ea:framelabel>
        <ea:framelabel id="FrameLabel35" style="z-index: 102; left: 166px; position: absolute; top: 71px; width: 306px;"
            runat="server" Text="DOKUMENTU ELEKTRONICZNEGO" Height="14px" FrameStyle="BigBold"
            FrameBorderStyle="None" HorizontalAlign="Center">
        </ea:framelabel>
        <ea:framelabel id="FrameLabel17" style="z-index: 100; left: 0px; position: absolute; top: 134px"
            runat="server" Width="653px"
            Text="A. NAZWA PEŁNA PODMIOTU, KTÓREMU DORĘCZONO DOKUMENT ELEKTRONICZNY"
            Height="64px" FrameStyle="BigYellowBold"
            FrameBorderStyle="DoubleHeader">
        </ea:framelabel>
        <ea:framelabel id="FrameLabel18" style="z-index: 119; left: 28px; position: absolute; top: 169px; width: 621px; height: 31px;"
            runat="server" Font-Size="Large" HorizontalAlign="Center" VerticalAlign="Middle"
            ValueStyle="Center">
        </ea:framelabel>
        <ea:framelabel id="FrameLabel2" style="z-index: 104; left: 0px; position: absolute; top: 196px; height: 343px;"
            runat="server" Width="653px" Text="B. INFORMACJA O DOKUMENCIE"
            FrameStyle="BigYellowBold" FrameBorderStyle="DoubleHeader">
        </ea:framelabel>
        <ea:framelabel id="FrameLabel3" style="z-index: 106; left: 28px; position: absolute; top: 223px; height: 22px;"
            runat="server" Width="621px"
            Text="&amp;nbsp Dokument został zarejestrowany w systemie teleinformatycznym Ministerstwa Finansów"
            FrameStyle="MiddleBoldYellow">
        </ea:framelabel>
        <ea:framelabel id="FrameLabel40" style="z-index: 105; left: 28px; position: absolute; top: 328px; height: 29px;"
            runat="server" Width="625px"
            Text="&amp;nbsp Dokument zweryfikowano pod względem zgodności ze strukturą logiczną:"
            ValueStyle="Center">
        </ea:framelabel>
        <ea:framelabel id="FrameLabel39" style="z-index: 105; left: 28px; position: absolute; top: 300px; height: 29px;"
            runat="server" Width="625px"
            Text="&amp;nbsp Skrót dokumentu w postaci otrzymanej przez system (łącznie z podpisem elektronicznym):"
            ValueStyle="Center">
        </ea:framelabel>
        <ea:framelabel id="FrameLabel43" style="z-index: 105; left: 28px; position: absolute; top: 510px; height: 31px;"
            runat="server" Width="625px"
            Text="&amp;nbsp Dokument wystawiony automatycznie przez system teleinformatyczny Ministerstwa Finansów|&amp;nbsp Data i czas wystawienia dokumentu:"
            ValueStyle="Center">
        </ea:framelabel>
        <ea:framelabel id="FrameLabel1" style="z-index: 105; left: 28px; position: absolute; top: 384px; height: 29px;"
            runat="server" Width="625px"
            Text="&amp;nbsp Urząd skarbowy, do którego został złożony dokument:"
            ValueStyle="Center">
        </ea:framelabel>
        <ea:framelabel id="FrameLabel38" style="z-index: 105; left: 28px; position: absolute; top: 272px; height: 29px;"
            runat="server" Width="625px"
            Text="&amp;nbsp Skrót złożonego dokumentu-identyczny z wartością użytą do podpisu dokumentu:"
            ValueStyle="Center">
        </ea:framelabel>
        <ea:framelabel id="FrameLabel4" style="z-index: 105; left: 28px; position: absolute; top: 412px; height: 99px;"
            runat="server" Width="625px"
            Text="&amp;nbsp Stempel czasu:" ValueStyle="Left">
        </ea:framelabel>
        <ea:framelabel id="FrameLabel42" style="z-index: 115; left: 28px; position: absolute; top: 356px; width: 317px; right: 611px;"
            runat="server"
            Text="&amp;nbsp Identyfikator podatkowy podmiotu występującego jako pierwszy na dokumencie:"
            Height="28px" ValueStyle="Center">
        </ea:framelabel>
        <ea:framelabel id="FrameLabel36" style="z-index: 115; left: 28px; position: absolute; top: 244px; width: 317px;"
            runat="server" Text="&amp;nbsp Identyfikator dokumentu:" Height="28px">
        </ea:framelabel>
        <ea:framelabel id="FrameLabel41" style="z-index: 115; left: 342px; position: absolute; top: 356px; width: 310px;"
            runat="server" Text="&amp;nbsp Identyfikator podatkowy podmiotu występującego jako drugi na dokumencie:"
            Height="28px" ValueStyle="Center">
        </ea:framelabel>
        <ea:framelabel id="FrameLabel37" style="z-index: 115; left: 342px; position: absolute; top: 244px; width: 310px;"
            runat="server" Text="&amp;nbsp Dnia (data, czas):" Height="28px">
        </ea:framelabel>
        <ea:deklaracjafooter id="DeklaracjaFooter1" style="z-index: 132; left: 522px; position: absolute; top: 942px"
            runat="server" Width="56px" Height="15px" Symbol="UPO" PageNumber="1" PageTotal="1"
            Version="6">
        </ea:deklaracjafooter>
    </form>
</body>
</html>

