﻿using System;
using System.Collections;
using System.Web.UI;
using Soneta.Kadry;
using Soneta.Business;
using Soneta.Core;
using Soneta.Types;
using Soneta.Tools;
using Soneta.Kasa;
using Soneta.Place;
using Soneta.Kalend;
using System.Diagnostics;
using System.Collections.Generic;
using Soneta.Web;
using System.Xml;
using Soneta.Deklaracje;
using Soneta.Deklaracje.PIT;
using System.Web.UI.HtmlControls;

namespace ASP {

    public partial class PIT_11_23_2018 : System.Web.UI.Page {

        public string Str_PITWatermark = "Tylko do celów poglądowych";
        public static string Str_PITVerifier = "Wydruk PIT-11 (23) może być drukowany wyłącznie dla deklaracji PIT-11 w wersji 23.";

        public class SrParams : SerializableContextBase {

            public SrParams(Context context) : base(context) {
            }

            bool watermark = true;
            [Caption("Znak wodny")]
            public bool Watermark {
                get { return watermark; }
                set {
                    watermark = value;
                    OnChanged(EventArgs.Empty);
                }
            }
        }

        SrParams srpars;
        [SettingsContext]
        public SrParams SrPars {
            get { return srpars; }
            set { srpars = value; }
        }

        protected void OnContextLoad(object sender, System.EventArgs e) {
            Deklaracja pit = (Deklaracja)dc[typeof(Deklaracja)];
            if (pit as PIT11_23 == null)
                throw new InvalidOperationException(Str_PITVerifier);
            PIT11_23 pit11 = (PIT11_23)pit;
            if (!pit.Module.Config.PIT.Ogólne.DanePodatnikaWStopce)
                flDanePodatnika.Text = "";
            else {
                flDanePodatnika.Text = string.Format("{0}, {1}: {2}",
                    pit11.Podmiot.ToString(),
                    pit11.JestPESEL ? "PESEL" : "NIP",
                    pit11.IdentyfikatorPodatnika);
            }
            if (pit11.JestPESEL) {
                flPeselNip.Text = "<strike>Identyfikator podatkowy NIP</strike>/Numer PESEL <.Indexup>(niepotrzebne skreślić))";
                flPeselNip.ValueStyle = ValueStyles.WideText;
            }
            else {
                flPeselNip.Text = "Identyfikator podatkowy NIP/<strike>Numer PESEL</strike> <.Indexup>(niepotrzebne skreślić))";
                flPeselNip.ValueStyle = ValueStyles.nip_w;
            }
            watermark.Visible = srpars.Watermark;

            if (!dc.OverPrint) {
                string upo = (pit.Deklaracja ?? pit).GetNumerUpo();
                if (upo != "") {
                    Resize(FrameNIPPlatnika, -64, 0);
                    Move(FrameNrDokumentu, 0, -64);
                    Resize(FrameNrDokumentu, 64, 0);
                    FrameNrDokumentu.EditValue = upo;
                }
            }
        }

        void Resize(System.Web.UI.WebControls.WebControl fl, int dwidth, int dheight) {
            if (dwidth != 0)
                fl.Style["width"] = (ParsePx(fl.Style["width"]) + dwidth) + "px";
            if (dheight != 0)
                fl.Style["height"] = (ParsePx(fl.Style["height"]) + dheight) + "px";
        }

        void Move(System.Web.UI.WebControls.WebControl fl, int dtop, int dleft) {
            if (dtop != 0)
                fl.Style["TOP"] = (ParsePx(fl.Style["TOP"]) + dtop) + "px";
            if (dleft != 0)
                fl.Style["LEFT"] = (ParsePx(fl.Style["LEFT"]) + dleft) + "px";
        }

        int ParsePx(string px) {
            return int.Parse(px.Substring(0, px.Length - 2));
        }

    }
}
