﻿


using System;
using System.Collections.Generic;
using Soneta.Business;
using Soneta.Types;
using Soneta.Tools;
using Soneta.Core;
using Soneta.Kasa;
using Soneta.Delegacje;



namespace ASP
{
	public partial class Delegacja_PWS_365 : System.Web.UI.Page
	{
		protected void OnContextLoad(Object sender, EventArgs args)
		{
			Delegacja delegacja = (Delegacja)dc[typeof(Delegacja)];
			IdDelegowanyTxt.Text = delegacja.Delegowany.Nazwa;
			IdKrajTxt.Text = delegacja.KrajDocelowy != null ? delegacja.KrajDocelowy.ToString() : "-";
			IdCzasPlanowanyTxt.Text = String.Format("{0} - {1}", (Date)(DateTime)delegacja.DataRozpoczeciaPlanowana, (Date)(DateTime)delegacja.DataZakonczeniaPlanowana);
			IdNumerTxt.Text = delegacja.Numer.ToString();

			GridZaliczkiReq.DataSource = GetZaliczki(delegacja, zaplata => zaplata == null);
			GridZaliczkiReady.DataSource = GetZaliczki(delegacja, zaplata => zaplata != null);
		}


		private IEnumerable<Currency> GetZaliczki(Delegacja delegacja, Func<Zaplata, Boolean> filter)
		{
			Boolean plnFound = false;
			foreach (ZaliczkaDelegacji z in delegacja.Zaliczki)
				if (filter(z.DokWyplaty))
				{
					plnFound = true;
					yield return z.Kwota;
				}

			if (!plnFound)
				yield return Currency.Zero;
		}
	}
}
