﻿


using System;
using System.Collections.Generic;
using Soneta.Business;
using Soneta.Ksiega;
using Soneta.Types;
using Soneta.Tools;
using Soneta.Core;
using Soneta.Kasa;
using Soneta.Delegacje;



namespace ASP
{
	public partial class Delegacja_Rozl_365 : System.Web.UI.Page
	{
		public String STR_DoWplaty = "Do wpłaty";
		public String STR_DoWyplaty = "Do wypłaty";
        public String STR_Del_NoReportForUnreported = "Nie można drukować rozliczeń dla delegacji, które nie zostały jeszcze rozliczone. ({0})";



        protected void OnContextLoad(Object sender, EventArgs args)
		{
			Delegacja delegacja = (Delegacja)dc[typeof(Delegacja)];

			if (delegacja.StatusRownyLubWczesniejszy(StatusDelegacji.Naliczona, true))
				throw new ApplicationException(String.Format(STR_Del_NoReportForUnreported, delegacja.Numer));

			IdLabelKurier.Format = Bool2Txt(delegacja.KurierDyplomatyczny);

			GridKosztyDelegacji.DataSource = GetKosztyDelegacji(delegacja, k => k.DokPrzejazd == null && k.Rodzaj != RodzajKosztuDelegacji.InnyNierozliczany);
			GridKosztyNierozliczone.DataSource = GetKosztyDelegacji(delegacja, k => k.DokPrzejazd == null && k.Rodzaj == RodzajKosztuDelegacji.InnyNierozliczany);
			GridPrzejazdy.DataSource = GetKosztyDelegacji(delegacja, k => k.DokPrzejazd != null);

			GridRk.DataSource = CalculateRk(delegacja);
		}


		protected void Before_Etap(Object sender, Soneta.Web.RowEventArgs args)
		{
			EtapDelegacji etap = (EtapDelegacji)args.Row;
			colEtapPelneWyzywienie.EditValue = Bool2Txt(etap.PelneWyzywienie);
		}


		protected void Before_Koszt(Object sender, Soneta.Web.RowEventArgs args)
		{
			KosztDelegacji koszt = (KosztDelegacji)args.Row;

			colKosztRodzaj.EditValue = CaptionAttribute.EnumToString(koszt.Rodzaj);
			colKosztNumer.EditValue = koszt.DokEwidencja != null ? koszt.DokEwidencja.NumerDokumentu : String.Empty;
			colKosztPodmiot.EditValue = koszt.DokEwidencja != null ? koszt.DokEwidencja.Podmiot : (Object)String.Empty;
			colKosztData.EditValue = koszt.DokEwidencja != null ? koszt.DokEwidencja.DataDokumentu : (Object)String.Empty;
		}


		protected void Before_Koszt_Nr(Object sender, Soneta.Web.RowEventArgs args)
		{
			KosztDelegacji koszt = (KosztDelegacji)args.Row;

			colKosztRodzajNr.EditValue = CaptionAttribute.EnumToString(koszt.Rodzaj);
			colKosztNumerNr.EditValue = koszt.DokEwidencja != null ? koszt.DokEwidencja.NumerDokumentu : String.Empty;
			colKosztPodmiotNr.EditValue = koszt.DokEwidencja != null ? koszt.DokEwidencja.Podmiot : (Object)String.Empty;
			colKosztDataNr.EditValue = koszt.DokEwidencja != null ? koszt.DokEwidencja.DataDokumentu : (Object)String.Empty;
		}


		protected void Before_Naliczenie(Object sender, Soneta.Web.RowEventArgs args)
		{
			NaliczenieDelegacji naliczenie = (NaliczenieDelegacji)args.Row;

			colNalWydWgRachunkow.EditValue = naliczenie.ObliczPodsumowaniaKosztow(null, true);
			colNalKosztyPrzejazdow.EditValue = naliczenie.ObliczPodsumowaniaKosztow(RodzajKosztuDelegacji.TransportSamochod, null);


			String kursStr = String.Empty;
			foreach (KwotaNaliczeniaDelegacji kn in naliczenie.Kwoty)
			{
				if (!String.IsNullOrEmpty(kursStr))
				{
					kursStr = "(różne)";
					break;
				}

				kursStr = kn.Kurs.ToString("F4");
			}

			colNalKurs.EditValue = kursStr;
		}


		protected void Before_Platnosc(Object sender, Soneta.Web.RowEventArgs args)
		{
			Platnosc platnosc = (Platnosc)args.Row;
			args.VisibleRow = platnosc.Podmiot == platnosc.Dokument.Podmiot;
		}


		protected virtual String Bool2Txt(Boolean bl)
		{ return bl ? "TAK" : "NIE"; }


		private Currency ZobowiazanieDoRozliczenia(Platnosc platnosc)
		{ return platnosc.Kierunek == KierunekPlatnosci.Rozchod ? platnosc.DoRozliczenia : -platnosc.DoRozliczenia; }


		private IEnumerable<KosztDelegacji> GetKosztyDelegacji(Delegacja d, Func<KosztDelegacji, Boolean> selector)
		{
			foreach (EtapDelegacji etap in d.Etapy)
				foreach (KosztDelegacji koszt in etap.Koszty)
					if (selector(koszt))
						yield return koszt;
		}


		public class RK
		{
			private String waluta;
			private Currency zobowiazanie;
			private Delegacja_Rozl_365 parent;


			public String Waluta
			{ get { return waluta; } }

			public Currency Zobowiazanie
			{ get { return zobowiazanie; } }

			public Currency Kwota
			{ get { return Currency.Abs(zobowiazanie); } }

			public String Kierunek
			{ get { return zobowiazanie > Currency.Zero ? parent.STR_DoWyplaty : parent.STR_DoWplaty; } }


			internal RK(String waluta, Currency zobowiazanie, Delegacja_Rozl_365 parent)
			{
				this.waluta = waluta;
				this.zobowiazanie = zobowiazanie;
				this.parent = parent;
			}
		}


		private IEnumerable<RK> CalculateRk(Delegacja delegacja)
		{
			Dictionary<String, Currency> dict = new Dictionary<String, Currency>();

			foreach (Platnosc platnosc in delegacja.Platnosci)
				if (platnosc.Podmiot == platnosc.Dokument.Podmiot && platnosc.DoRozliczenia > Currency.Zero)
					AddToRkDict(dict, platnosc);

			List<RK> rkList = new List<RK>();

			foreach (KeyValuePair<String, Currency> kv in dict)
				if (kv.Value != Currency.Zero)
					rkList.Add(new RK(kv.Key, kv.Value, this));

			return rkList;
		}


		private void AddToRkDict(Dictionary<String, Currency> dict, Platnosc platnosc)
		{
			if (dict.ContainsKey(platnosc.DoRozliczenia.Symbol))
				dict[platnosc.DoRozliczenia.Symbol] += ZobowiazanieDoRozliczenia(platnosc);
			else
				dict[platnosc.DoRozliczenia.Symbol] = ZobowiazanieDoRozliczenia(platnosc);
		}
	}
}
