﻿<%@ Page Language="c#" CodePage="1200" AutoEventWireup="false" %>

<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>

<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Core" %>
<%@ Import Namespace="Soneta.Ksiega" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="System.Collections.Generic" %>
<%@ Import Namespace="System.Linq" %>


<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<html>
<head>
    <title>Dekrety ewidencji</title>
    <script runat="server">



        private void OnLoad(object sender, EventArgs args)
        {
            var ewidencje = (DokEwidencji[])DataContext1.Get(typeof(DokEwidencji[]));
            if (ewidencje == null || ewidencje.Length == 0)
                throw new Exception("Nie wybrano żadnych dokumentów ewidencji.");

            var dekrety = ewidencje.SelectMany(ew => ew.Dekrety.Cast<DekretBase>()).ToList();
            if (dekrety.Count == 0)
                throw new Exception("Wybrane dokumenty ewidencji nie posadają żadnych dekretów.");

            DataRepeater1.DataContext = DataContext1;
            DataRepeater1.DataSource = dekrety;
        }


        private void OnNewDekret(object sender, EventArgs eventArgs)
        {
            var dekret = (DekretBase)DataRepeater1.CurrentRow;

            const string format = "{0} | Numer: {1}, Data: {2},  Bufor : {3} | Numer ewidencji: {4} | Nr dokumentu: {5}, Data dokumentu: {6} | Opis: {7} | Winien: {8}, Ma: {9}";
            var tytul = dekret.Typ == TypDziennika.BO ?"Dekrety BO dla ewidencji": "Dekrety dla ewidencji";

            ReportHeader1.Title = string.Format(format, tytul, dekret.Numer, dekret.Data, dekret.Bufor ? "Tak" : "Nie", dekret.Ewidencja.Numer , dekret.Ewidencja.NumerDokumentu, dekret.Ewidencja.DataDokumentu, dekret.Opis, dekret.Winien, dekret.Ma);


            List<ReportItem> list = new List<ReportItem>();

            ReportItem bSum = new ReportItem() { Symbol = "Suma:", Bold = true };
            ReportItem pbSum = new ReportItem() { Symbol = "Suma pozabilansowych:", Bold = true };

            foreach (ZapisKsiegowy zapis in dekret.Zapisy)
            {
                list.Add(new ReportItem()
                {
                    Lp = zapis.Lp.ToString(),
                    Grupa = zapis.Grupa.ToString(),
                    Symbol = zapis.Konto.Symbol,
                    Winien = zapis.Winien.Value,
                    Ma = zapis.Ma.Value,
                    Opis = zapis.Opis
                });
                if (zapis.Konto.PozaBilansowe)
                {
                    pbSum.Winien += zapis.Winien.Value;
                    pbSum.Ma += zapis.Ma.Value;
                }
                else
                {
                    bSum.Winien += zapis.Winien.Value;
                    bSum.Ma += zapis.Ma.Value;
                }
            }

            if (bSum.Winien != 0 || bSum.Ma != 0)
                list.Add(bSum);
            if (pbSum.Winien != 0 || pbSum.Ma != 0)
                list.Add(pbSum);

            Grid1.DataSource = list;
        }


        public class ReportItem
        {
            public bool Bold { get; set; }
            public string Lp { get; set; }
            public string Grupa { get; set; }
            public string Symbol { get; set; }
            public decimal Winien { get; set; }
            public decimal Ma { get; set; }
            public string Opis { get; set; }
        }


        protected void Grid1_BeforeRow(object sender, RowEventArgs args)
        {
            var item = (ReportItem)args.Row;

            if (item.Bold)
            {
                ColSymbol.EditValue = "<b>" + item.Symbol + "</b>";
                ColWinien.EditValue = "<b>" + string.Format(ColWinien.Format, item.Winien) + "</b>";
                ColMa.EditValue = "<b>" + string.Format(ColWinien.Format, item.Ma) + "</b>";
            }
            else
            {
                ColSymbol.EditValue = item.Symbol;
                ColWinien.EditValue = string.Format(ColWinien.Format, item.Winien);
                ColMa.EditValue = string.Format(ColWinien.Format, item.Ma);
            }
        }


    </script>



</head>
<body>
    <form id="Dekret" method="post" runat="server">
        <ea:datacontext runat="server" ID="DataContext1" OnContextLoad="OnLoad"></ea:datacontext>
        <ea:datarepeater runat="server" ID="DataRepeater1" OnBeforeRow="OnNewDekret" Width="100%" >
            <ea:PageBreak runat="server" ResetPageCounter="True"></ea:PageBreak>
            <cc1:ReportHeader ID="ReportHeader1" Title="" Width="100%" runat="server"></cc1:ReportHeader>
                 
            <ea:grid id="Grid1" runat="server" OnBeforeRow="Grid1_BeforeRow" >
					<Columns>
						<ea:GridColumn Width="7" Align="Center" DataMember="Lp" Caption="Lp."></ea:GridColumn>
						<ea:GridColumn ID="ColSymbol" Width="30" Caption="Symbol konta"></ea:GridColumn>
						<ea:GridColumn ID="ColWinien" Width="20" Align="Right" Caption="Winien" Format="{0:n}"></ea:GridColumn>
						<ea:GridColumn ID="ColMa" Width="20" Align="Right" Caption="Ma" Format="{0:n}"></ea:GridColumn>
						<ea:GridColumn DataMember="Opis"></ea:GridColumn>
					</Columns>
				</ea:grid>
            
                           
       <cc1:ReportFooter id="ReportFooter1" runat="server">
            <Subtitles>
						<cc1:FooterSubtitle SubtitleType="Operator"></cc1:FooterSubtitle>
					</Subtitles>
       </cc1:ReportFooter>
  
        </ea:datarepeater>
    </form>
</body>
</html>

