﻿
<%@ Page language="c#" AutoEventWireup="false" CodePage="1200" %>

<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>

<%@ Import Namespace="Soneta.Kasa" %>
<%@ Import Namespace="Soneta.Ksiega" %>
<%@ Import Namespace="Soneta.Core" %>
<%@ Import Namespace="Soneta.CRM" %>
<%@ Import Namespace="Soneta.Business" %>


<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >

<script runat="server">
	
	
	//
	// BEGIN: DOSTOSOWANIE WYDRUKU 
	//
	
	
	// nazwa cechy przypiętej do dokumentu ewidencji ktora bedzie zawierac kontrahenta jesli nie zostanie znaleziony w platnosciach
	private const String NazwaCechyKontrahenta = "Kontrahent";
	
	// opis jakie zostanie zastosowany dla danych podmiotu jesli nie zostanie on odnaleziony ani w platnosci ani wskazanej cesze
	private const String OpisBrakuKontrahenta = "(brak danych)";

	
	//
	// END: DOSTOSOWANIE WYDRUKU 
	//
	

	protected void Grid2_BeforeRow(object sender, RowEventArgs args)
	{
		var p = (Platnosc)args.Row;

		var tyt = (p is Naleznosc ? "Obciążamy kwotą: " : "Uznajemy kwotę: ") + p.Kwota;
		var slo = String.Format("  (słownie: {0:t})", p.Kwota);
		var opi = HttpUtility.HtmlEncode(p.Opis);

		IdTytulem.EditValue = String.Format("{0}<br/>{1}<br/>{2}", tyt, slo, opi);
	}


	protected void dc_ContextLoad(object sender, EventArgs e)
	{
		var dok = (PKEwidencja)dc.Context[typeof(PKEwidencja)];
		IPodmiotKasowy podmiot = null;

		var platnosc =(Platnosc) dok.Platnosci.GetNext();
		if (platnosc != null)
			podmiot = platnosc.Podmiot;
		
		if(podmiot==null && dok.Features.Definitions.Contains(NazwaCechyKontrahenta))
			podmiot = (Kontrahent)dok.Features[NazwaCechyKontrahenta];

		if (podmiot != null)
		{
			IdLabelNazwa.EditValue = podmiot.Nazwa;
			IdLabelAdres.EditValue = podmiot.Adres;

			if (podmiot.NIP == "" && platnosc.Podmiot is Kontrahent)
				IdLabelNip.EditValue = ((Kontrahent)podmiot).EuVAT;
			else
				IdLabelNip.EditValue = podmiot.NIP;
		}
		else
		{
			IdLabelNazwa.EditValue = OpisBrakuKontrahenta;
			IdLabelAdres.EditValue = OpisBrakuKontrahenta;
			IdLabelNip.EditValue = OpisBrakuKontrahenta;
		}
	}
	
	
</script>

<html>
	<head>
		<title>PKEwidencja - Nota księgowa</title>
	</head>
	<body>
		<form method="post" runat="server" ID="form">
			<ea:DataContext id="dc" runat="server" TypeName="Soneta.Core.DokEwidencji,Soneta.Core" oncontextload="dc_ContextLoad"></ea:DataContext>
			<eb:reportheader id="ReportHeader1" title="Nota księgowa|</strong>Numer: <strong>{0}</strong>|Data:<strong>{1}" DataMember0="Numer" DataMember1="DataDokumentu" runat="server"  />

			<div style="font-family:Tahoma;margin-top:0.5cm;margin-bottom:0.5cm;">
				<table width="100%" style="font-size:10pt">
					<tr>
						<td width="25%" align="right">Nazwa kontrahenta:</td>
						<td>&nbsp;</td>
						<td><ea:DataLabel runat="server" ID="IdLabelNazwa" /></td>
					</tr>
					<tr>
						<td align="right">Adres kontrahenta:</td>
						<td>&nbsp;</td>
						<td><ea:DataLabel runat="server" ID="IdLabelAdres" /></td>
					</tr>
					<tr>
						<td align="right">NIP:</td>
						<td>&nbsp;</td>
						<td><ea:DataLabel runat="server" ID="IdLabelNip" /></td>
					</tr>
				</table>
			</div>

			<ea:grid id="Grid2" runat="server" DataMember="Platnosci" 
				RowTypeName="Soneta.Kasa.Platnosc,Soneta.Kasa" ShowSum="Always" SumText="Razem" onbeforerow="Grid2_BeforeRow" >
				<Columns>
					<ea:GridColumn ID="GridColumn6" runat="server" Caption="Obciążamy" Width="17" Align="Right" DataMember="Należność" HideZero="True" Format="{0:n}" Total="Sum" />
					<ea:GridColumn ID="IdTytulem" runat="server" Caption="Tytułem"   Width="0"  Align="Left"  Total="Info" />
					<ea:GridColumn ID="GridColumn7" runat="server" Caption="Uznajemy"  Width="20" Align="Right" DataMember="Zobowiązanie" HideZero="True" Format="{0:n}" Total="Sum"/>
				</Columns>
			</ea:grid>

			<eb:reportfooter id="ReportFooter1" runat="server" />
		</form>
	</body>
</html>
