﻿
<%@ Page language="c#" AutoEventWireup="false" CodePage="1200" %>

<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>

<%@ Import Namespace="Soneta.Business.Licence" %>
<%@ Import Namespace="Soneta.Core" %>
<%@ Import Namespace="Soneta.Ksiega" %>
<%@ Import Namespace="Soneta.EwidencjaVat" %>
<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="System.Collections.Generic" %>
<%@ Import Namespace="System.Linq" %>


<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >

<script runat="server">

    protected void dc_ContextLoad(object sender, EventArgs e)
    {
        DokEwidencji dok = (DokEwidencji)dc.Context[typeof(DokEwidencji)];
        Boolean ksiegowosc = !dc.Session.Login.IsLicence(LicencjeModułu.KPiR);

        ReportHeaderKs.Visible = ksiegowosc;
        ReportFooterKs.Visible = ksiegowosc;
        DataRepeaterKs.Visible = ksiegowosc;
        DekretyTitleKs.Visible = ksiegowosc;

        IdSectionRozrachunki.Visible = ksiegowosc && !dok.Platnosci.IsEmpty;

        ReportHeaderKp.Visible = !ksiegowosc;
        ReportFooterKp.Visible = !ksiegowosc;
        DataRepeaterKp.Visible = !ksiegowosc;

        List<DekretItem> dekrety = new List<DekretItem>();

        foreach (Dekret dekret in dok.Dekrety)
        {
            DekretItem dekretItem = new DekretItem { Numer = dekret.Numer, Data = dekret.Data };
            ReportItem bSum = new ReportItem() { Symbol = "Suma:", Bold = true };
            ReportItem pbSum = new ReportItem() { Symbol = "Suma pozabilansowych:", Bold = true };
            foreach (ZapisKsiegowy zapis in dekret.Zapisy)
            {
                dekretItem.Items.Add(new ReportItem()
                {
                    Lp = zapis.Lp.ToString(),
                    Grupa = zapis.Grupa.ToString(),
                    Symbol = zapis.Konto.Symbol,
                    Winien = zapis.Winien.Value,
                    Ma = zapis.Ma.Value,
                    Opis = zapis.Opis,
                    Numer = zapis.Numer.ToString()
                });
                if (zapis.Konto.PozaBilansowe)
                {
                    pbSum.Winien += zapis.Winien.Value;
                    pbSum.Ma += zapis.Ma.Value;
                }
                else
                {
                    bSum.Winien += zapis.Winien.Value;
                    bSum.Ma += zapis.Ma.Value;
                }
            }
            if (bSum.Winien != 0 || bSum.Ma != 0) dekretItem.Items.Add(bSum);
            if (pbSum.Winien != 0 || pbSum.Ma != 0) dekretItem.Items.Add(pbSum);
            dekrety.Add(dekretItem);
        }
        //Grid1.DataSource = list;
        DataRepeaterKs.DataSource = dekrety;
    }


    private readonly KPiR.KPiRWorker worker = new KPiR.KPiRWorker();

    protected void GridZapisyKp_BeforeRow(object sender, RowEventArgs args)
    {
        ZapisKsiegowy zapis = (ZapisKsiegowy)args.Row;

        if (zapis.Konto.Kolumna == NrKolumnyKPiR.Zaszłości)
        {
            worker.Dekret = zapis.Dekret;
            args.VisibleRow = !worker.Remanent;
        }
    }

    protected void Grid1_BeforeRow(object sender, RowEventArgs args)
    {
        var item = args.Row as ReportItem;
        if (item.Bold) {
            ColSymbol.EditValue = "<b>" + item.Symbol + "</b>";
            ColWinien.EditValue = "<b>" + String.Format(ColWinien.Format, item.Winien) + "</b>";
            ColMa.EditValue = "<b>" + String.Format(ColWinien.Format, item.Ma) + "</b>";
        }
        else {
            ColSymbol.EditValue = item.Symbol;
            ColWinien.EditValue = String.Format(ColWinien.Format, item.Winien);
            ColMa.EditValue = String.Format(ColWinien.Format, item.Ma);
        }
    }

    public class DekretItem
    {
        public DekretItem()
        {
            Items = new List<ReportItem>();
        }

        public NumerDokumentu Numer { get; set; }
        public Date Data { get; set; }
        public List<ReportItem> Items { get; private set; }
        
    }

    public class ReportItem
    {
        public ReportItem()
        {
            Winien = Ma = 0m;
        }

        public bool Bold { get; set; }
        public string Numer { get; set; }
        public string Lp { get; set; }
        public string Grupa { get; set; }
        public string Symbol { get; set; }
        public decimal Winien { get; set; }
        public decimal Ma { get; set; }
        public string Opis { get; set; }
    }
</script>

<html>
	<head>
		<title>PK - Płatności - Dekrety</title>
	</head>
	<body>
		<form method="post" runat="server" ID="form">
			<ea:DataContext id="dc" runat="server" TypeName="Soneta.Core.DokEwidencji,Soneta.Core" oncontextload="dc_ContextLoad" ></ea:DataContext>

			<eb:ReportHeader id="ReportHeaderKs" runat="server" Title="Polecenie księgowania|</strong>Numer: <strong>{0}</strong>|Data:<strong>{1}</strong>|Opis:<strong>{2}"
				DataMember0="Numer" DataMember1="DataDokumentu" DataMember2="Opis"  />
			<eb:ReportHeader id="ReportHeaderKp" runat="server" Title="Dowód wewnętrzny: {0} | Numer ewidencji: {1} |Data dokumentu: {2}, Data księgowania: {3} |Opis: {4}"
				DataMember0="NumerDokumentu" DataMember1="Numer.NumerPelny" DataMember2="DataDokumentu" DataMember3="DataKsiegowania" DataMember4="Opis" />

			<ea:Section runat="server" ID="IdSectionRozrachunki" >
				<p style="font-weight:bold; font-family:Tahoma; font-size:10pt;">Rozrachunki</p>
				<ea:grid id="Grid2" runat="server" DataMember="Platnosci" RowTypeName="Soneta.Kasa.Platnosc,Soneta.Kasa" WithSections="true" >
					<Columns>
						<ea:GridColumn ID="GridColumn1" runat="server" Width="4" DataMember="#" Caption="Lp" />
						<ea:GridColumn ID="GridColumn2" runat="server" Width="12" DataMember="DataDokumentu" Caption="Data" />
						<ea:GridColumn ID="GridColumn3" runat="server" Width="0" DataMember="NumerDokumentu" Caption="Numer" EncodeHTML="true"></ea:GridColumn>
						<ea:GridColumn ID="GridColumn8" runat="server" Width="0" DataMember="Podmiot" Caption="Podmiot"></ea:GridColumn>
						<ea:GridColumn ID="GridColumn6" runat="server" Width="17" Align="Right" DataMember="Należność" Caption="Należność" HideZero="True" Format="{0:n}"></ea:GridColumn>
						<ea:GridColumn ID="GridColumn7" runat="server" Width="17" Align="Right" DataMember="Zobowiązanie" Caption="Zobowiązanie" HideZero="True" Format="{0:n}"></ea:GridColumn>
					</Columns>
				</ea:grid>
			</ea:Section>
			
			<ea:Section runat="server" ID="DekretyTitleKs" >
				<p style="font-weight:bold; font-family:Tahoma; font-size:10pt;">Dekrety</p>
			</ea:Section>

			<ea:DataRepeater ID="DataRepeaterKs" runat="server" Height="101px" Width="782px" Font-Size="10px" WithSections="false" >
                <p style="font-family:Tahoma; font-size:9pt;">Numer dekretu:&nbsp;<ea:DataLabel runat="server" DataMember="Numer" EncodeHtml="true" />&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Data:&nbsp;<ea:DataLabel runat="server" DataMember="Data" /></p>
				<ea:Grid ID="Grid1" runat="server" OnBeforeRow="Grid1_BeforeRow" DataMember="Items" >
                    <Columns>
                        <ea:GridColumn ID="GridColumn4" runat="server" Align="Center" Caption="Lp." DataMember="Lp" Width="5" />
                        <ea:GridColumn ID="ColNumer" runat="server" Align="Left" Caption="Numer zapisu" DataMember="Numer" Width="22" />
                        <ea:GridColumn ID="ColSymbol" runat="server" Caption="Symbol konta" Width="24"/> 
                        <ea:GridColumn ID="ColWinien" runat="server" Align="Right" Caption="Winien" Format="{0:n}" Width="13" />
                        <ea:GridColumn ID="ColMa" runat="server" Align="Right" Caption="Ma" Format="{0:n}" Width="13" /> 
                        <ea:GridColumn ID="GridColumn12" runat="server" Align="Left" DataMember="Opis" />
                    </Columns>
                </ea:Grid>
        		<p />
                <ea:PageBreak ID="PageBreak1" runat="server" Required="False" />
			 </ea:DataRepeater>
			
			<ea:DataRepeater ID="DataRepeaterKp" runat="server" DataMember="Dekrety" Height="101px" Width="782px" RowTypeName="Soneta.Ksiega.Dekret,Soneta.Ksiega" WithSections="false">
				<ea:Grid ID="GridZapisyKp" runat="server" DataMember="Zapisy" RowTypeName="Soneta.Ksiega.ZapisKsiegowy,Soneta.Ksiega"  Sort="Konto.Symbol" ShowAgrSum="True" ShowPageSum="True" ShowPrevAgrSum="InFooter" OnBeforeRow="GridZapisyKp_BeforeRow" >
					<Columns>
						<ea:GridColumn ID="GridColumn13" runat="server" Align="Center" Caption="Lp." DataMember="#" Width="5" />
						<ea:GridColumn ID="GridColumn14" runat="server" Caption="Kolumna" DataMember="Konto.Kolumna" Width="20" Total="Info" />
						<ea:GridColumn ID="GridColumn15" runat="server" Align="Right" Caption="Przychód" DataMember="Ma.Value" Width="13" Format="{0:n}" Total="Sum" />
						<ea:GridColumn ID="GridColumn16" runat="server" Align="Right" Caption="Koszt" DataMember="Winien.Value" Width="13" Format="{0:n}" Total="Sum" />
						<ea:GridColumn ID="GridColumn17" runat="server" Caption="Nazwa towaru opłaty lub tytuł i cel przychodu lub wydatku" DataMember="Opis" />
					</Columns>
				</ea:Grid>
	       		<p />
                <ea:PageBreak ID="PageBreak2" runat="server" Required="False" />
 			</ea:DataRepeater>

		   <eb:ReportFooter id="ReportFooterKs" runat="server" >
				<Subtitles>
					<eb:FooterSubtitle ID="FooterSubtitle3" runat="server" SubtitleType="OperatorCzas" Width="50" />
					<eb:FooterSubtitle ID="FooterSubtitle4" runat="server" SubtitleType="Podpis" Width="50" />
				</Subtitles>
			</eb:ReportFooter>

			<eb:ReportFooter id="ReportFooterKp" runat="server">
                <Subtitles>
                    <eb:FooterSubtitle ID="FooterSubtitle1" runat="server" Caption="Dokonał przychód/wydatek:" SubtitleType="Podpis" Width="35" />
                    <eb:FooterSubtitle ID="FooterSubtitle2" runat="server" Caption="Sporządził/Zaksięgował:" SubtitleType="Podpis" Width="35" />
                </Subtitles>
            </eb:ReportFooter>
		</form>
	</body>
</html>
