﻿<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Page language="c#" AutoEventWireup="false" codePage="1200" %>
<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="Soneta.Business" %>
<%@ import Namespace="Soneta.Zadania" %>
<%@ import Namespace="Soneta.Business.App" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<TITLE>Statystyka aktywności CRM</TITLE>
		<META content="C#" name="CODE_LANGUAGE">
		<META content="JavaScript" name="vs_defaultClientScript">
		<META content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
		<script runat="server">
		    
		// Parametry wejściowe
		
            public enum GrupujWg
            {
                [Caption("Operatorów")]
                operatorow = 1,
                [Caption("Kontrahentów")]
                kontrahentow = 2
            };
    
            public enum SortujWg
            {
                [Caption("Alfabetycznie")]
                alfabetycznie = 1,
                [Caption("Wg aktywności")]
                wgaktywnosci = 2,
                [Caption("Wg aktywności malejąco")]
                wgaktywnoscidesc = 3

            };

            public class Params : ContextBase
            {
                public Params(Context cx)
                    : base(cx) { }
                
                SortujWg sortowanie = SortujWg.wgaktywnoscidesc;
                GrupujWg grupowanie = GrupujWg.operatorow;
                int pokazpierwszych = 0;
                bool procentowo = false;

                [Soneta.Types.Caption("Według")]
                [Soneta.Types.DefaultWidth(25)]
                [Soneta.Tools.Priority(5)]
                public GrupujWg Grupowanie
                {
                    get { return grupowanie; }
                    set { grupowanie = value; }
                }
                [Soneta.Types.Caption("Sortowanie")]
                [Soneta.Types.DefaultWidth(25)]
                [Soneta.Tools.Priority(10)]
                public SortujWg Sortowanie
                {
                    get { return sortowanie; }
                    set { sortowanie = value; }
                }
                [Soneta.Types.Caption("Pierwszych (0-wszyscy)")]
                [Soneta.Tools.Priority(20)]
                public int PokazPierwszych
                {
                    get { return pokazpierwszych; }
                    set { pokazpierwszych = value; }
                }

                [Soneta.Types.Caption("Wyniki procentowe")]
                [Soneta.Tools.Priority(30)]
                public bool Procentowo
                {
                    get { return procentowo; }
                    set { procentowo = value; }
                }

            }

            Params param = null;
            
            [Context]
            public Params Param
            {
                get { return param; }
                set { param = value; }
            }
    
		        
            Hashtable definicje = new Hashtable();
            Hashtable lista = new Hashtable();
            ArrayList deflista;
		    
		// Klasa wyniku 
            class Wynik
            {
                int liczba = 0;
                public Wynik() { liczba = 1; }
                public void Dodaj()
                {
                    liczba++;
                }
                public int Liczba
                {
                    get { return liczba; }
                }
            }    
		    
		// Klasa dla pojedynczego wiersza w tabeli
		// Zwraca klucz, oraz wystawia metodę zwracającą ilości zadań wg poszczególnych definicji        
            class Item
            {

                Hashtable wyniki = new Hashtable();
                Hashtable definicje;
                object klucz;
                public Item(object klucz)
                {
                    this.klucz = klucz;
                }
                public void DodajZadanie(Zadanie zadanie)
                {
                    if (wyniki.ContainsKey(zadanie.Definicja))
                        ((Wynik)wyniki[zadanie.Definicja]).Dodaj();
                    else
                        wyniki.Add(zadanie.Definicja, new Wynik());
                }
                public object Klucz
                {
                    get { return klucz; }
                }
                public Hashtable Definicje
                {
                    set { definicje = value; }
                }
                public int IloscZadan(DefZadania definicja)
                {
                    if (wyniki.ContainsKey(definicja))
                        return ((Wynik)wyniki[definicja]).Liczba;
                    else
                        return 0;
                }
                public int IloscZadanRazem
                {
                    get
                    {
                        int razem = 0;
                        foreach (Wynik wynik in wyniki.Values)
                            razem += wynik.Liczba;
                        return razem;
                    }
                }
                public Percent IloscZadanProcent(DefZadania definicja)
                {
                    if (definicje != null)
                        if (definicje.ContainsKey(definicja))
                        {
                            int ilezadan = this.IloscZadan(definicja);
                            int razem = ((Wynik)definicje[definicja]).Liczba;
                            if (razem != 0)
                                return new Percent(ilezadan, razem);
                        }
                    return Percent.Blank;
                }
                public Percent IloscZadanRazemProcent
                {
                    get
                    {
                        if (definicje != null)
                        {
                            int ilezadan = this.IloscZadanRazem;
                            int razem = 0;
                            foreach (Wynik wynik in definicje.Values)
                                razem += wynik.Liczba;

                            if (razem != 0)
                                return new Percent(ilezadan, razem);
                        }
                        return Percent.Blank;
                    }

                }

            }
		
		// Metoda aktualizująca listę użytych definicji oraz tablicę z wynikami        
            void DodajZadanie(Zadanie zadanie, object klucz)
            {
                if (zadanie == null || klucz == null)
                    return;
                // Aktualizacja listy głównej
                if (lista.ContainsKey(klucz))
                {
                    Item item = (Item)lista[klucz];
                    item.DodajZadanie(zadanie);
                }
                else
                {
                    Item item = new Item(klucz);
                    item.DodajZadanie(zadanie);
                    lista.Add(klucz, item);
                }
                // aktualizacja listy definicji
                if (definicje.ContainsKey(zadanie.Definicja))
                    ((Wynik)definicje[zadanie.Definicja]).Dodaj();
                else
                    definicje.Add(zadanie.Definicja, new Wynik());
            }
		// Metoda dodająca kolumnę do grida    
            void DodajKolumne(string opis)
            {
                GridColumn col = new GridColumn();
                col.Caption = opis;
                col.Align = HorizontalAlign.Right;
                //if (!Param.Procentowo)
                    col.Total = Total.Sum;
                Grid.Columns.Add(col);
            }    
		    // Klasa do posortowania definicji
            class DefinicjaComparer : IComparer
            {
                public DefinicjaComparer() { }
                public int Compare(object x, object y)
                {
                    DefZadania d1 = (DefZadania)x;
                    DefZadania d2 = (DefZadania)y;
                    return (d1.Rodzaj == d2.Rodzaj ? d1.Symbol.CompareTo(d2.Symbol) : d1.Rodzaj.CompareTo(d2.Rodzaj));
                }
            }    
		// Klasa do posortowania listy głównej
            class ItemComparer : IComparer
            {
                SortujWg sortowanie = SortujWg.alfabetycznie;
 
                public ItemComparer() { }
                public ItemComparer(SortujWg sortowanie)
                {
                    this.sortowanie = sortowanie;
                }
                public int Compare(object x, object y)
                {
                    Item i1 = (Item)x;
                    Item i2 = (Item)y;
                    switch (sortowanie)
                    {
                        case SortujWg.wgaktywnosci:
                            if (i1.IloscZadanRazem != i2.IloscZadanRazem)
                                return i1.IloscZadanRazem.CompareTo(i2.IloscZadanRazem);
                            break;
                        case SortujWg.wgaktywnoscidesc:
                            if (i1.IloscZadanRazem != i2.IloscZadanRazem)
                                return i2.IloscZadanRazem.CompareTo(i1.IloscZadanRazem);
                            break;
                    }
                    return ((IComparable)(i1.Klucz)).CompareTo((IComparable)(i2.Klucz));
                }
            }

            void OnContextLoad(Object sender, EventArgs args)
            {
                AktywnosciParams param = (AktywnosciParams)dc[typeof(AktywnosciParams)];
                
                // Sposób grupowania operatorzy/kontrahenci
                ReportHeader["WG"] = (Param.Grupowanie == GrupujWg.operatorow ? "operatorów" : "wg kontrahentów");

                // Rodzaje zadań
                string subtitle = "";
                if (param.ZadBool) subtitle += (subtitle == "" ? "" : "+") + "zadania";
                if (param.ZdarzBool) subtitle += (subtitle == "" ? "" : "+") + "zdarzenia";
                if (param.ZlecBool) subtitle += (subtitle == "" ? "" : "+") + "zlecenia";
                if (param.WypBool) subtitle += (subtitle == "" ? "" : "+") + "wypożyczenia";
                ReportHeader["RODZAJ"] = subtitle;
                
                // Okres
                subtitle = "";
                if (param.Okres == Soneta.Types.FromTo.All)
                    subtitle = "Okres: wszystko";
                else
                {
                    subtitle = "Wg";
                    switch (param.WgDaty)
                    {
                        case AktywnosciParams.WedlugDaty.DatyRozpoczęcia: subtitle += " daty rozpoczęcia"; break;
                        case AktywnosciParams.WedlugDaty.DatyZakończenia: subtitle += " daty zakończenia"; break;
                        case AktywnosciParams.WedlugDaty.Okresu: subtitle += " okresu"; break;
                    }
                    subtitle += ": " + param.Okres.ToString();
                }
                ReportHeader["OKRES"] = subtitle;

                // Stan realizacji
                ReportHeader["STAN"] = String.Format("Stan: {0}", param.StanRealizacji);
                
                // Kontrahent
                ReportHeader["KONTRAHENT"] = (param.Kontrahent!=null||param.Przedstawiciel!=null ? "|" : "")
                    + (param.Kontrahent != null ? String.Format("Kontrahent: {0}, ", param.Kontrahent.Kod) : "")
                    + (param.Przedstawiciel != null ? String.Format("Przedstawiciel: {0}", param.Przedstawiciel) : "");

                ReportHeader["OPERATOR"] = (param.Prowadzacy != null || param.Wykonujacy != null ? "|" : "")
                    + (param.Prowadzacy != null ? String.Format("Prowadzący: {0}, ", param.Prowadzacy) : "")
                    + (param.Wykonujacy != null ? String.Format("Wykonujący: {0}", param.Wykonujacy) : "");
                
                
                // Parametry dla kolumny z "kluczem"
                if (!Param.Procentowo)
                    colKlucz.Total = Total.Info;
                switch (Param.Grupowanie)
                {
                    case GrupujWg.operatorow:
                        colKlucz.DataMember = "Klucz";
                        colKlucz.Caption = "Operator";
                        break;
                    case GrupujWg.kontrahentow:
                        colKlucz.DataMember = "Klucz.Kod";
                        colKlucz.Caption = "Kontrahent";
                        break;
                }

                Row[] rows = (Row[])dc[typeof(Row[])];
                foreach (Zadanie zadanie in rows)
                    switch (Param.Grupowanie)
                    {
                        case GrupujWg.operatorow:
                            DodajZadanie(zadanie, zadanie.Wykonujacy);
                            break;
                        case GrupujWg.kontrahentow:
                            DodajZadanie(zadanie, zadanie.Kontrahent);
                            break;
                    }

                deflista = new ArrayList(definicje.Keys);
                deflista.Sort(new DefinicjaComparer());
                foreach (DefZadania definicja in deflista)
                {
                    DodajKolumne(definicja.Rodzaj.ToString() + "~" + definicja.Symbol);
                }
                DodajKolumne("RAZEM");

                ArrayList gridlista = new ArrayList(lista.Values);
                gridlista.Sort(new ItemComparer(Param.Sortowanie));
                Grid.DataSource = gridlista;
            }
            void Grid_BeforeRow(Object sender, RowEventArgs args)
            {
                if (Param.PokazPierwszych != 0 && args.RowCounter >= Param.PokazPierwszych)
                {
                    args.VisibleRow = false;
                    return;
                }
                Item item = (Item)args.Row;
                int colnr = 1;
                int otwarte = 0;
                int zamkniete = 0;
                if (Param.Procentowo)
                    item.Definicje = definicje;
                foreach (DefZadania definicja in deflista)
                {
                    colnr++;
                    if (Param.Procentowo)
                        Grid.Columns[colnr].EditValue = item.IloscZadanProcent(definicja);
                    else
                        Grid.Columns[colnr].EditValue = item.IloscZadan(definicja);
                }
                colnr++;
                if (Param.Procentowo)
                    Grid.Columns[colnr].EditValue = item.IloscZadanRazemProcent;
                else
                    Grid.Columns[colnr].EditValue = item.IloscZadanRazem;
            }    
    
            void Msg(object o)
            {
            }    
		</script>
	</HEAD>
	<BODY>
		<FORM method="post" runat="server">
			<ea:DataContext id="dc" runat="server" OnContextLoad="OnContextLoad"></ea:DataContext>
			<eb:ReportHeader id="ReportHeader" runat="server" title="Aktywność %WG%|%RODZAJ%|%OKRES%|%STAN%%KONTRAHENT%%OPERATOR%"></eb:ReportHeader>
			<ea:Grid id="Grid" runat="server" OnBeforeRow="Grid_BeforeRow">
				<Columns>
				    <ea:GridColumn ID="colLp" runat="server" Align="Right" DataMember="#" Caption="Lp." Width="8"></ea:GridColumn>
					<ea:GridColumn ID="colKlucz" runat="server" Align="Left" DataMember="Klucz" Caption="Operator" Width="12"></ea:GridColumn>
				</Columns>
			</ea:Grid>
			<eb:ReportFooter id="ReportFooter" runat="server"></eb:ReportFooter>
		</FORM>
	</BODY>
</HTML>

