﻿<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Import Namespace="Soneta.CzlonkowieSzkolenia" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Types" %>
<%@ Page language="c#" AutoEventWireup="false" codePage="1200" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<TITLE>SalaSzkol</TITLE>
		<META content="C#" name="CODE_LANGUAGE">
		<META content="JavaScript" name="vs_defaultClientScript">
		<META content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
        <script runat="server"> 
        void OnContextLoad(object sender, EventArgs args)
        {
            Soneta.Types.FromTo okres;
            bool czyKontekst = true;
            try
            {
                okres = (FromTo)dc[typeof(FromTo)];
            }
            catch
            {
                okres = new FromTo(new Date(1900, 1, 1), new Date(2100, 12, 31));
                czyKontekst = false;
            }
            SalaSzkol ss = (SalaSzkol)dc[typeof(SalaSzkol)];
            Soneta.CzlonkowieSzkolenia.CzlonkowieSzkoleniaModule csm = CzlonkowieSzkoleniaModule.GetInstance(dc.Session);
            ArrayList listaZajec = new ArrayList();
            
            foreach (ZajecieSala zw in csm.ZajeciaSale)
            {
                if (okres.ToString() == "(pusty)")
                {
                    if (zw.Zajecie.Sala == ss)
                        listaZajec.Add(zw);
                }
                    
                else if (okres.Contains(zw.Zajecie.Data) && zw.Sala == ss)
                    listaZajec.Add(zw); 
            }
            grid1.DataSource = listaZajec;
            ReportHeader["okres"] = czyKontekst ? okres.ToString() : "nieokreślony";

        }
    </script>
	</HEAD>
	<BODY>
		<FORM method="post" runat="server" ID="form">
			<ea:DataContext id="dc" runat="server" TypeName="Soneta.CzlonkowieSzkolenia.SalaSzkol,Soneta.CzlonkowieSzkolenia" OnContextLoad="OnContextLoad"></ea:DataContext>
			<eb:ReportHeader id="ReportHeader" runat="server" title="Harmonogram zajęć|{0}|okres: %okres%" DataMember0="."></eb:ReportHeader>


<div style="FONT-WEIGHT: bold; FONT-SIZE: 8pt; WIDTH: 100%; BORDER-BOTTOM: thin solid; FONT-FAMILY: Verdana; FONT-VARIANT: small-caps">
	Harmonogram zajęć
</div>
	<ea:Grid runat="server" ID="grid1" DataMember="Zajecia" RowTypeName="Soneta.CzlonkowieSzkolenia.ZajecieSzkolBase,Soneta.CzlonkowieSzkolenia">
		<Columns>
			<ea:GridColumn Width="4" Align="Right" DataMember="#" Caption="LP."></ea:GridColumn>
			<ea:GridColumn Align="Left" DataMember="Zajecie.PrzedmiotSzkol" 
                Caption="Przedmiot realizowany na zajęciach"></ea:GridColumn>
			<ea:GridColumn Width="10" Align="Left" DataMember="Zajecie.Data" Caption="Data zajęcia"></ea:GridColumn>
			<ea:GridColumn Width="12" Align="Left" DataMember="Zajecie.CzasOd" 
                Caption="Godzina rozpoczęcia"></ea:GridColumn>
			<ea:GridColumn Width="12" Align="Left" DataMember="Zajecie.CzasDo" 
                Caption="Godzina zakończenia"></ea:GridColumn>
			<ea:GridColumn Width="8" Align="Right" DataMember="Zajecie.IloscGodzin" 
                Caption="Liczba godzin"></ea:GridColumn>
			<ea:GridColumn Width="14" Align="Left" DataMember="Zajecie.GrupaSzkol" Caption="Grupa szkol"></ea:GridColumn>
			<ea:GridColumn Width="10" Align="Left" DataMember="Zajecie.ZespolSzkol" 
                Caption="Zespol szkol"></ea:GridColumn>
			<ea:GridColumn Width="15" Align="Left" DataMember="Zajecie.Wykladowca" Caption="Wykładowca"></ea:GridColumn>
		</Columns>
	</ea:Grid>
			<eb:ReportFooter id="ReportFooter" runat="server"></eb:ReportFooter>
		</FORM>
	</BODY>
</HTML>

