﻿<%@ Page Language="c#" CodePage="1200" AutoEventWireup="false" %>

<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>


<%@ Import Namespace="System.Linq" %>
<%@ Import Namespace="System.Collections.Generic" %>

<%@ Import Namespace="Soneta.Deklaracje.VAT" %>
<%@ Import Namespace="Soneta.Tools" %>
<%@ Import Namespace="Soneta.Deklaracje.UI.Printing" %>
<%@ Import Namespace="Soneta.EwidencjaVat" %>
<%@ Import Namespace="Soneta.Core" %>
<%@ Import Namespace="Soneta.Business" %>



<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<html>
<head>
	<title>VAT-7(17) Info</title>
	<meta http-equiv="Content-Type" content="text/html; charset=unicode">
	<script runat="server">

	
		private void VAT_7_17_Info_OnLoad(Object sender, EventArgs args)
		{
			var dek = (VAT7_17)DataContext1[typeof(VAT7_17)];

			SectionOfBlokC1.Visible = Params.PrintBlokC();
			SectionOfBlokC2.Visible = Params.PrintBlokC();
			SectionOfBlokD1.Visible = Params.PrintBlokD2();
			SectionOfBlokD2.Visible = Params.PrintBlokD2();
			SectionOfBlokD3.Visible = Params.PrintBlokD3();
			SectionOfBlokD4.Visible = Params.PrintBlokD3();

			var gSusp = new List<ElemRozliczeniaVAT>();

			if (Params.PrintBlokC())
			{
				var g10 = new GridClass { Name = "Pole 10", Visible = Params.Pole10 };
				var g11 = new GridClass { Name = "Pole 11", Visible = Params.Pole11 };
				var g12 = new GridClass { Name = "Pole 12", Visible = Params.Pole12 };
				var g13 = new GridClass { Name = "Pole 13", Visible = Params.Pole13 };
				var g14 = new GridClass { Name = "Pole 14", Visible = Params.Pole14 };
				var g15 = new GridClass { Name = "Pole 15, 16", Visible = Params.Pole1516 };
				var g17 = new GridClass { Name = "Pole 17, 18", Visible = Params.Pole1718 };
				var g19 = new GridClass { Name = "Pole 19, 20", Visible = Params.Pole1920 };
				var g21 = new GridClass { Name = "Pole 21", Visible = Params.Pole21 };
				var g22 = new GridClass { Name = "Pole 22", Visible = Params.Pole22 };
				var g23 = new GridClass { Name = "Pole 23, 24", Visible = Params.Pole2324 };
				var g25 = new GridClass { Name = "Pole 25, 26", Visible = Params.Pole2526 };
				var g27 = new GridClass { Name = "Pole 27, 28", Visible = Params.Pole2728 };
				var g29 = new GridClass { Name = "Pole 29, 30", Visible = Params.Pole2930 };
				var g31 = new GridClass { Name = "Pole 31", Visible = Params.Pole31 };
				var g32 = new GridClass { Name = "Pole 32, 33", Visible = Params.Pole3233 };
				var g34 = new GridClass { Name = "Pole 34, 35", Visible = Params.Pole3435 };
				var g36 = new GridClass { Name = "Pole 36", Visible = Params.Pole36 };
				var g37 = new GridClass { Name = "Pole 37", Visible = Params.Pole37 };
				var g38 = new GridClass { Name = "Pole 38", Visible = Params.Pole38 };
				var g39 = new GridClass { Name = "Pole 39", Visible = Params.Pole39 };
				var gArr = new[] { g10, g11, g12, g13, g14, g15, g17, g19, g21, g22, g23, g25, g27, g29, g31, g32, g34, g36, g37, g38, g39 };

				foreach (ElemRozliczeniaVAT elem in dek.GetElementyNalezny())
				{
					if (elem.Rodzaj.AnyOf(RodzajZakupuVAT.SpisZNatury, RodzajZakupuVAT.KasyRejestrujace, RodzajZakupuVAT.WntPaliw, RodzajZakupuVAT.WntSrodkowTransportu))
					{
						var wnt = elem.Rodzaj == RodzajZakupuVAT.WntSrodkowTransportu || elem.Rodzaj == RodzajZakupuVAT.WntPaliw;
						if(!IsKorektaSprzedazyOK(elem, wnt))
							gSusp.Add(elem);
						else
							switch (elem.Rodzaj)
							{
								case RodzajZakupuVAT.SpisZNatury:
									g36.Add(elem);
									break;

								case RodzajZakupuVAT.KasyRejestrujace:
									g37.Add(elem);
									break;

								case RodzajZakupuVAT.WntSrodkowTransportu:
									g38.Add(elem);
									break;

								case RodzajZakupuVAT.WntPaliw:
									g39.Add(elem);
									break;
							}

						continue;
					}
							
					if (elem.Element.Naglowek.Ewidencja.Typ != TypDokumentu.FWUENabyciaNależnyEwidencja && (elem.Stawka.Status == StatusStawkiVat.NiePodlega || elem.Stawka.Status == StatusStawkiVat.Brak) &&
						!VAT7.IsNabywcaPodatnikTowarLubUsluga(elem) && (VAT7.IsKraj(elem) || elem.Rodzaj != RodzajZakupuVAT.VATMarza))
					{
						if (!VAT7.IsUnia(elem) && elem.RodzajPodmiotu != RodzajPodmiotu.Eksportowy)
							continue;

						g11.Add(elem);
						if (VAT7.IsUnia(elem) && elem.Rodzaj == RodzajZakupuVAT.Usługi)
							g12.Add(elem);
					}
					else if (VAT7.IsZwolnione(elem))
					{
						g10.Add(elem);
					}
					else if (VAT7.Is0(elem) || VAT7.IsEksportPodrozny(elem) || VAT7.Is0Usluga(elem) &&
						!(elem.Element.Naglowek.Ewidencja.Typ == TypDokumentu.FWUENabyciaNależnyEwidencja && (elem.RodzajPodmiotu == RodzajPodmiotu.Unijny || elem.RodzajPodmiotu == RodzajPodmiotu.Eksportowy)))
					{
						g13.Add(elem);
						if (VAT7.IsEksportPodrozny(elem))
							g14.Add(elem);
					}
					else if (VAT7.Is3(elem) || VAT7.Is5(elem))
						g15.Add(elem);
					else if (VAT7.Is7(elem) || VAT7.Is8(elem))
						g17.Add(elem);
					else if (VAT7.Is22(elem) || VAT7.Is23(elem))
						g19.Add(elem);
					else if (VAT7.IsUniaDostawa(elem))
						g21.Add(elem);
					else if (VAT7.IsEksport(elem) && elem.Element.Naglowek.Ewidencja.Typ != TypDokumentu.FWUENabyciaNależnyEwidencja)
						g22.Add(elem);
					else if (VAT7.IsUniaNabycieWew(elem))
						g23.Add(elem);
					else if (VAT7.IsImportTowarow(elem))
						g25.Add(elem);
					else if (VAT7.IsImportUslug(elem))
					{
						if (VAT7.IsUnia(elem) || VAT7.Is0Usluga(elem) && !VAT7.IsEksport(elem))
							g29.Add(elem);
						else
							g27.Add(elem);
					}
					else if (VAT7.IsNabywcaPodatnik(elem) && elem.Element.Naglowek.Ewidencja.Typ == TypDokumentu.SprzedażEwidencja)
						g31.Add(elem);
					else if (VAT7.IsNabywcaPodatnik(elem) && elem.RodzajPodmiotu == RodzajPodmiotu.Krajowy)
						g34.Add(elem);
					else if (VAT7.IsNabywcaPodatnik(elem) && elem.Rodzaj == RodzajZakupuVAT.NabywcaPodatnik)
						g32.Add(elem);
					else
						gSusp.Add(elem);
				}

				SectionOfBlokC2.DataSource = gArr.Where(IsGroupVisible);
			}

			if (Params.PrintBlokD2() || Params.PrintBlokD3()) 
			{
				var g41 = new GridClass { Name = "Pole 43, 44 - działalność TAK, odliczenia TAK", Visible = Params.Pole4344 };

				var g41VrDz     = new GridClass { Name = "działalność MIESZANA, odliczenia TAK - środki trwałe VAT rok", Visible = Params.Pole4344 };
				var g41VrOdl    = new GridClass { Name = "działalność TAK, odliczenia WARUNKOWO - środki trwałe VAT rok", Visible = Params.Pole4344 };
				var g41VrDzOdl  = new GridClass { Name = "działalność MIESZANA, odliczenia WARUNKOWO - środki trwałe VAT rok", Visible = Params.Pole4344 };
		
				var g41STDz     = new GridClass { Name = "działalność MIESZANA, odliczenia TAK - środki trwałe", Visible = Params.Pole4344 };
				var g41STOdl    = new GridClass { Name = "działalność TAK, odliczenia WARUNKOWO - środki trwałe", Visible = Params.Pole4344 };
				var g41STDzOdl  = new GridClass { Name = "działalność MIESZANA, odliczenia WARUNKOWO - środki trwałe", Visible = Params.Pole4344 };
		
				var g41NrDz     = new GridClass { Name = "działalność MIESZANA, odliczenia TAK - nieruchomości", Visible = Params.Pole4344 };
				var g41NrOdl    = new GridClass { Name = "działalność TAK, odliczenia WARUNKOWO - nieruchomości", Visible = Params.Pole4344 };
				var g41NrDzOdl  = new GridClass { Name = "działalność MIESZANA, odliczenia WARUNKOWO - nieruchomości", Visible = Params.Pole4344 };

				var g43         = new GridClass { Name = "Pole 45, 46 - działalność TAK, odliczenia TAK", Visible = Params.Pole4546 };
				var g43Dz       = new GridClass { Name = "działalność MIESZANA, odliczenia TAK", Visible = Params.Pole4546 };
				var g43Odl      = new GridClass { Name = "działalność TAK, odliczenia WARUNKOWO", Visible = Params.Pole4546 };
				var g43DzOdl    = new GridClass { Name = "działalność MIESZANA, odliczenia WARUNKOWO", Visible = Params.Pole4546 };

				var g47         = new GridClass { Name = "Korekta podatku naliczonego od nabycia środków trwałych", Visible = Params.Pole47 };
				var g48         = new GridClass { Name = "Korekta podatku naliczonego od pozostałych nabyć", Visible = Params.Pole48 };
				var g49         = new GridClass { Name = "Korekta podatku naliczonego, o której mowa w art. 89b ust. 1 ustawy", Visible = Params.Pole4950 };
				var g50         = new GridClass { Name = "Korekta podatku naliczonego, o której mowa w art. 89b ust. 4 ustawy", Visible = Params.Pole4950 };

				var gArrD2 = new[] {g41, g41VrDz, g41VrOdl, g41VrDzOdl, g41STDz, g41STOdl, g41STDzOdl, g41NrDz, g41NrOdl, g41NrDzOdl, g43, g43Dz, g43Odl, g43DzOdl };
				var gArrD3 = new[] { g47, g48, g49, g50};

				foreach (ElemRozliczeniaVAT elem in dek.GetElementyNaliczony())
				{
					if (elem.Rodzaj == RodzajZakupuVAT.KorektaST || elem.Rodzaj == RodzajZakupuVAT.KorektaPozostale)
					{
						if (!IsKorektaZakupuOK(elem))
							gSusp.Add(elem);
						else
							switch (elem.Rodzaj)
							{
								case RodzajZakupuVAT.KorektaST:
									g47.Add(elem);
									break;
								case RodzajZakupuVAT.KorektaPozostale:
									g48.Add(elem);
									break;
							}

						continue;
					}

					if (elem.Stawka.Procent == 0m && (elem.Naglowek.Naglowek.RodzajPodmiotu == RodzajPodmiotu.Unijny || elem.Naglowek.Naglowek.RodzajPodmiotu == RodzajPodmiotu.UnijnyTrójstronny) && elem.Naglowek.Naglowek.Ewidencja.Typ == TypDokumentu.ZakupEwidencja)
						continue; // -> nie uwzględniamy nabyc wewnątrz wspólnotowych
					if (elem.Odliczenia == OdliczeniaVAT.Nie || elem.DzialalnoscGosp == DzialalnoscGospodarcza.Nie)
						continue; // -> wyłączenie elementów nie podlegających odliczeniom
					if (elem.Stawka.Status == StatusStawkiVat.NiePodlega || elem.Stawka.Status == StatusStawkiVat.Brak)
						continue; // -> wyłączenie ze zliczania zakupów o stawce NP
					if (!dek.VAT.Ogólne.UwzględniaćZakupy0 && elem.Stawka.Status == StatusStawkiVat.Opodatkowana && elem.Stawka.Procent == 0m)
						continue; // -> wyłączenie ze zliczania zakupów o stawce 0%
					if (!dek.VAT.Ogólne.UwzględniaćZakupyZW && elem.Stawka.Status == StatusStawkiVat.Zwolniona)
						continue; // -> wyłączenie ze zliczania zakupów o stawce ZW

					if (elem.Naglowek.ZleDlugiKasowe())
						g50.Add(elem);
					else if (elem.Naglowek.Typ == TypRozliczeniaVAT.KasoweZłeDługi || elem.Naglowek.Typ == TypRozliczeniaVAT.KasoweZłeDługiKorekta)
						g49.Add(elem);
					else if (dek.IsSrodkiTrwaleOgolnieOdliczeniaV15(elem) || dek.IsPozostaleOdliczeniaV15(elem))
					{
						if(dek.IsSrodkiTrwaleOgolnieOdliczeniaV15(elem))
							g41.Add(elem);
						if(dek.IsPozostaleOdliczeniaV15(elem))
							g43.Add(elem);
					}
					else if (dek.IsSrodkiTrwaleVRWarunkowoV15(elem))
						AddElem(elem,g41VrDz, g41VrOdl, g41VrDzOdl);
					else if (dek.IsSrodkiTrwaleWarunkowoV15(elem))
						AddElem(elem,g41STDz, g41STOdl, g41STDzOdl);
					else if (dek.IsNieruchomosciWarunkowoV15(elem))
						AddElem(elem,g41NrDz, g41NrOdl, g41NrDzOdl);
					else if (dek.IsPozostaleWarunkowoV15(elem))
						AddElem(elem,g43Dz, g43Odl, g43DzOdl);
					else
						gSusp.Add(elem);
				}

				SectionOfBlokD2.DataSource = gArrD2.Where(IsGroupVisible);
				SectionOfBlokD4.DataSource = gArrD3.Where(IsGroupVisible);
			}

			if (gSusp.Count > 0 )
			{
				var log = new Log("VAT-7 - podejrzane elementy nie uwzględnione na deklaracji", true);
				foreach (var elem in gSusp)
					log.WriteLine("{0}({1});{2};{3};{4};{5};{6};{7};{8};{9}", elem.NumerEwidencji, elem.NumerDokumentu, elem.Lp, elem.Stawka, elem.Netto, elem.VAT, elem.Rodzaj, elem.Odliczenia, elem.RodzajPodmiotu, elem.StatusPodmiotu);
			}
		}


		private void AddElem(ElemRozliczeniaVAT elem, GridClass dz, GridClass odl, GridClass dzOdl)
		{
			if(elem.DzialalnoscGosp == DzialalnoscGospodarcza.Tak && elem.Odliczenia == OdliczeniaVAT.Warunkowo)
				odl.Add(elem);
			else if(elem.DzialalnoscGosp == DzialalnoscGospodarcza.CelMieszany && elem.Odliczenia == OdliczeniaVAT.Tak)
				dz.Add(elem);
			else
				dzOdl.Add(elem);
		}

			
		private bool IsGroupVisible(GridClass g)
		{ return g.Visible && ( g.Elems.Count > 0 || !Params.HideEmpty ); }

		private static bool IsKorektaSprzedazyOK(ElemRozliczeniaVAT elem, bool wnt)
		{ return (elem.RodzajPodmiotu == RodzajPodmiotu.Krajowy || wnt && elem.RodzajPodmiotu == RodzajPodmiotu.Unijny) && elem.Element.Naglowek.Ewidencja.Typ == TypDokumentu.FWUENabyciaNależnyEwidencja && elem.Stawka.Status == StatusStawkiVat.Brak; }

		private static bool IsKorektaZakupuOK(ElemRozliczeniaVAT elem)
		{ return elem.RodzajPodmiotu == RodzajPodmiotu.Krajowy && elem.Element.Naglowek.Ewidencja.Typ == TypDokumentu.FWUENabyciaNaliczonyEwidencja && elem.Stawka.Status == StatusStawkiVat.Brak && elem.Odliczenia == OdliczeniaVAT.Tak; }


		public class GridClass
		{
			private List<ElemRozliczeniaVAT> _elems = new List<ElemRozliczeniaVAT>();

			public String Name { get; set; }
			public Boolean Visible { get; set; }

			public List<ElemRozliczeniaVAT> Elems
			{
				get { return _elems; }
				set { _elems = value; }
			}

			public void Add(ElemRozliczeniaVAT elem)
			{ _elems.Add(elem); }
		}


		[Context, Required]
		public VAT7_17_InfoParams Params { get; set; }


	

		
	</script>
</head>
<body>
	<form id="VAT_7_17_Info" method="post" runat="server">
		<ea:DataContext ID="DataContext1" runat="server" OnContextLoad="VAT_7_17_Info_OnLoad" TypeName="Soneta.Deklaracje.VAT.VAT7_17,Soneta.Deklaracje"></ea:DataContext>
		<cc1:reportheader id="ReportHeader1" title="Zestawienie VAT-7(17) {0}" runat="server" datamember0="Numer.NumerPelny"></cc1:reportheader>

		<ea:Section ID="SectionOfBlokC1" runat="server" Width="100%">
			<span style='font-size: 11pt; font-weight: bold; display: block; margin: 5mm 0'>Blok C</span>
		</ea:Section>

		<ea:DataRepeater ID="SectionOfBlokC2" WithSections="False" runat="server">
			<span style="font-size: 9pt; font-weight: normal; display: block; margin: 3mm 0 1mm 0;">
				<ea:DataLabel runat="server" DataMember="Name" Bold="False" />
			</span>

			<ea:Grid runat="server" RowTypeName="Soneta.EwidencjaVat.ElemRozliczeniaVAT,Soneta.Ksiega" DataMember="Elems">
				<Columns>
					<ea:GridColumn Width="5" DataMember="#" Caption="Lp." />
					<ea:GridColumn DataMember="NumerEwidencji" Caption="Ewidencja" />
					<ea:GridColumn DataMember="NumerDokumentu" Caption="Dokument" />
					<ea:GridColumn Width="10" DataMember="Data" Caption="Data" Total="Info" />
					<ea:GridColumn Width="25" Align="Right" DataMember="Netto.Value" Caption="Netto" Format="{0:n}" Total="Sum" />
					<ea:GridColumn Width="20" Align="Right" DataMember="VAT.Value" Caption="VAT" Format="{0:n}" Total="Sum" />
				</Columns>
			</ea:Grid>
		</ea:DataRepeater>

		<ea:Section ID="SectionOfBlokD1" runat="server" Width="100%">
			<span style='font-size: 11pt; font-weight: bold; display: block; margin: 5mm 0'>Blok D.2</span>
		</ea:Section>

		<ea:DataRepeater ID="SectionOfBlokD2" WithSections="False" runat="server">
			<span style="font-size: 9pt; font-weight: normal; display: block; margin: 3mm 0 1mm 0;">
				<ea:DataLabel runat="server" DataMember="Name" Bold="False" />
			</span>

			<ea:Grid runat="server" RowTypeName="Soneta.EwidencjaVat.ElemRozliczeniaVAT,Soneta.Ksiega" DataMember="Elems">
				<Columns>
					<ea:GridColumn Width="5" DataMember="#" Caption="Lp." />
					<ea:GridColumn DataMember="NumerEwidencji" Caption="Ewidencja" />
					<ea:GridColumn DataMember="NumerDokumentu" Caption="Dokument" />
					<ea:GridColumn Width="10" DataMember="Data" Caption="Data" Total="Info" />
					<ea:GridColumn Width="25" Align="Right" DataMember="Netto.Value" Caption="Netto" Format="{0:n}" Total="Sum" />
					<ea:GridColumn Width="20" Align="Right" DataMember="VAT.Value" Caption="VAT" Format="{0:n}" Total="Sum" />
				</Columns>
			</ea:Grid>
		</ea:DataRepeater>

		<ea:Section ID="SectionOfBlokD3" runat="server" Width="100%">
			<span style='font-size: 11pt; font-weight: bold; display: block; margin: 5mm 0'>Blok D.3</span>
		</ea:Section>

		<ea:DataRepeater ID="SectionOfBlokD4" WithSections="False" runat="server">
			<span style="font-size: 9pt; font-weight: normal; display: block; margin: 3mm 0 1mm 0;">
				<ea:DataLabel runat="server" DataMember="Name" Bold="False" />
			</span>

			<ea:Grid runat="server" RowTypeName="Soneta.EwidencjaVat.ElemRozliczeniaVAT,Soneta.Ksiega" DataMember="Elems">
				<Columns>
					<ea:GridColumn Width="5" DataMember="#" Caption="Lp." />
					<ea:GridColumn DataMember="NumerEwidencji" Caption="Ewidencja" />
					<ea:GridColumn DataMember="NumerDokumentu" Caption="Dokument" />
					<ea:GridColumn Width="10" DataMember="Data" Caption="Data" Total="Info" />
					<ea:GridColumn Width="25" Align="Right" DataMember="Netto.Value" Caption="Netto" Format="{0:n}" Total="Sum" />
					<ea:GridColumn Width="20" Align="Right" DataMember="VAT.Value" Caption="VAT" Format="{0:n}" Total="Sum" />
				</Columns>
			</ea:Grid>
		</ea:DataRepeater>

		<cc1:reportfooter runat="server">
			<subtitles>
				<cc1:FooterSubtitle SubtitleType="Operator" />
			</subtitles>
		</cc1:reportfooter>
	</form>
</body>
</html>
