﻿<%@ Page Language="C#" AutoEventWireup="false" CodePage="1200" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>

<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Deklaracje" %>
<%@ Import Namespace="Soneta.Deklaracje.PIT" %>
<%@ Import Namespace="Soneta.Deklaracje.CIT" %>
<%@ Import Namespace="System.Collections.Generic" %>

<script runat="server">

	private int TakNie(bool value)
    	{
        	return value ? 1 : 2;
    	}

	private void OnContextLoad(Object sender, EventArgs args)
	{
		var dek = (CIT8ST_1)dc[typeof(CIT8ST_1)];


		string kodKraju = ((string)dek.Bloki["X"]["KodKrajuPl"]).ToUpper();
		if (kodKraju == "" || kodKraju == "PL")
			AdresZagr.Visible = false;
		else
			AdresPol.Visible = false;

		var oddziały = new List<CIT8ST_1_Multi>();
		var sta = new List<CIT8STA_1>();

		foreach (Deklaracja pit in dek.Deklaracje)
			if (pit is CIT8ST_1_Multi)
				oddziały.Add((CIT8ST_1_Multi)pit);
			else if (pit is CIT8STA_1)
				sta.Add((CIT8STA_1)pit);

		CITSTM_REP.DataSource = oddziały;
		CITSTA_REP.DataSource = sta;

		ORD_ZU.Visible = dek.TreśćUzasadnienia != "";
		P_17.EditValue = TakNie((bool)dek.Bloki["C"]["ZobowiazanieCITATak"]);
	}


	protected void CITSTA_BeforeRow(object sender, EventArgs e)
	{
		var dek = (CIT8STA_1)CITSTA_REP.CurrentRow;
		CITSTAM_REP.DataSource = dek.Deklaracje;
	}


	protected void CITSTM_BeforeRow(object sender, EventArgs e)
	{
	}

	protected void CITSTAM_BeforeRow(object sender, EventArgs e)
	{
	}

</script>


<ea:DataContext ID="dc" runat="server" TypeName="Soneta.Deklaracje.CIT.CIT8ST_1,Soneta.Deklaracje" OnContextLoad="OnContextLoad"></ea:DataContext>
<?xml version="1.0" encoding="UTF-8" ?>
<Deklaracja 
	xmlns="http://crd.gov.pl/wzor/2025/04/23/13745/" 
	xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
    xsi:schemaLocation="http://crd.gov.pl/wzor/2025/04/23/13745/ http://crd.gov.pl/wzor/2025/04/23/13745/schemat.xsd"
	xmlns:cstam="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2024/01/03/eD/CITA/" 
	xmlns:etd="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2022/09/13/eD/DefinicjeTypy/" 
	xmlns:kgm="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2025/01/02/eD/KodyGMIN/" 
	xmlns:tns="http://crd.gov.pl/wzor/2025/04/23/13745/" 
	xmlns:zzu="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2022/09/13/eD/ORDZU/" >
	<Naglowek>
		<KodFormularza kodSystemowy="CIT8ST (1)" kodPodatku="CIT" rodzajZobowiazania="Z" wersjaSchemy="4-0E">CIT-8ST</KodFormularza>
		<WariantFormularza>1</WariantFormularza>		
		<CelZlozenia poz="P_6"><ea:XmlDataLabel ID="DataLabel1" runat="server" DataMember="A.Korekta"><ValuesMap><ea:ValuesPair Key="False" Value="1" /><ea:ValuesPair Key="True" Value="2"/></ValuesMap></ea:XmlDataLabel></CelZlozenia>
		<Rok><ea:XmlDataLabel ID="DataLabel2" runat="server" DataMember="Rok" XSDType="TZnakowy"></ea:XmlDataLabel></Rok>
		<ea:XmlDataLabel ElementName="KodUrzedu" runat="server" DataMember="X.KodUrzeduSkarbowego" />
	</Naglowek>
	<Podmiot1 rola="Podatnik">
		<tns:OsobaNiefizyczna>
			<ea:XmlDataLabel ElementName="etd:NIP" runat="server" DataMember="0.Nip" XSDType="TNrNIP"/>
			<ea:XmlDataLabel ElementName="etd:PelnaNazwa" runat="server" DataMember="B1.Nazwa" XSDType="TZnakowy" />
		</tns:OsobaNiefizyczna>
		<tns:AdresSiedziby rodzajAdresu="RAD">
			<ea:Section ID="AdresPol" runat="server">
				<tns:AdresPol>
					<tns:KodKraju>PL</tns:KodKraju>
					<ea:XmlDataLabel ElementName="tns:Wojewodztwo" ID="pit_wojew" runat="server" DataMember="B2.Wojew" XSDType="TJednAdmin"/>
					<ea:XmlDataLabel ElementName="tns:Powiat" ID="pit_powiat" runat="server" DataMember="B2.Powiat" XSDType="TJednAdmin"/>
					<ea:XmlDataLabel ElementName="tns:Gmina" ID="pit_gmina" runat="server" DataMember="B2.Gmina" XSDType="TJednAdmin"/>
					<ea:XmlDataLabel ElementName="tns:Ulica" runat="server" DataMember="B2.Ulica" XSDType="TUlica" HideEmptyOrZero="true"/>
					<ea:XmlDataLabel ElementName="tns:NrDomu" ID="pit_nrDomu" runat="server" DataMember="B2.NrDomu" XSDType="TNrBudynku"/>
					<ea:XmlDataLabel ElementName="tns:NrLokalu" runat="server" DataMember="B2.NrLokalu" XSDType="TNrLokalu" HideEmptyOrZero="true"/>
					<ea:XmlDataLabel ElementName="tns:Miejscowosc" ID="pit_miejsc" runat="server" DataMember="B2.Miejsc" XSDType="TMiejscowosc"/>
					<ea:XmlDataLabel ElementName="tns:KodPocztowy" ID="pit_kodPoczt" runat="server" DataMember="B2.KodPoczt" XSDType="TKodPocztowy"/>
				</tns:AdresPol>
			</ea:Section>
			<ea:Section ID="AdresZagr" runat="server">
				<tns:AdresZagr>
					<ea:XmlDataLabel ElementName="tns:KodKraju" runat="server" DataMember="X.KodKraju" XSDType="TTekstowy"/>
					<ea:XmlDataLabel ElementName="tns:KodPocztowy" runat="server" DataMember="B2.KodPoczt" XSDType="TKodPocztowy" HideEmptyOrZero="true"/>
					<ea:XmlDataLabel ElementName="tns:Miejscowosc" ID="pit_miejscZagr" runat="server" DataMember="B2.Miejsc" XSDType="TMiejscowosc"/>
					<ea:XmlDataLabel ElementName="tns:Ulica" runat="server" DataMember="B2.Ulica" XSDType="TUlica" HideEmptyOrZero="true"/>
					<ea:XmlDataLabel ElementName="tns:NrDomu" runat="server" DataMember="B2.NrDomu" XSDType="TNrBudynku" HideEmptyOrZero="true"/>
					<ea:XmlDataLabel ElementName="tns:NrLokalu" runat="server" DataMember="B2.NrLokalu" XSDType="TNrLokalu" HideEmptyOrZero="true"/>
				</tns:AdresZagr>
			</ea:Section>
		</tns:AdresSiedziby>
	</Podmiot1>
	<PozycjeSzczegolowe>
		<ea:XmlDataLabel runat="server" ElementName="P_17" ID="P_17"/>			
		<ea:DataRepeater ID="CITSTM_REP" runat="server" WithSections="False" OnBeforeRow="CITSTM_BeforeRow">
			<P_E typ="G">	
				<ea:XmlDataLabel ElementName="P_EA" runat="server" DataMember="Wojew" XSDType="TJednAdmin"/>
				<ea:XmlDataLabel ElementName="P_EB" runat="server" DataMember="Powiat" XSDType="TJednAdmin"/>
				<ea:XmlDataLabel ElementName="P_EC" runat="server" DataMember="Gmina" XSDType="TJednAdmin"/>
				<ea:XmlDataLabel ElementName="P_ED" runat="server" DataMember="D.KodGminy" XSDType="TJednAdmin"/>
				<ea:XmlDataLabel ElementName="P_EE" runat="server" DataMember="D.NazwaOddziału" XSDType="TTekstowy"/>
				<ea:XmlDataLabel ElementName="P_EF" runat="server" DataMember="D.NIP" XSDType="TNrNIP" HideEmptyOrZero="true"/>
				<ea:XmlDataLabel ElementName="P_EG" runat="server" DataMember="D.LiczbaZatrudnionych" XSDType="TCalkowity"/>
			</P_E>
		</ea:DataRepeater>
		<ea:XmlDataLabel ElementName="P_18" runat="server" DataMember="D.LiczbaZatrudnionych" XSDType="TCalkowity" />
		<ea:XmlDataLabel ElementName="P_75" runat="server" DataMember="F.ImieNazwisko" XSDType="TZnakowy" />
		<ea:XmlDataLabel ElementName="P_76" runat="server" DataMember="F.Data" XSDType="TData" />	
	</PozycjeSzczegolowe>
	<Pouczenie>1</Pouczenie>
	<Zalaczniki>
		<ea:DataRepeater ID="CITSTA_REP" runat="server" WithSections="False" OnBeforeRow="CITSTA_BeforeRow">
			<Zalacznik_CIT_A xmlns="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2024/01/03/eD/CITA/">
				<Naglowek>
					<KodFormularza kodSystemowy="CIT/A (1)" wersjaSchemy="2-0E">CIT/A</KodFormularza>
					<WariantFormularza>1</WariantFormularza>
				</Naglowek>
				<PozycjeSzczegolowe>
					<ea:DataRepeater ID="CITSTAM_REP" runat="server" WithSections="False" OnBeforeRow="CITSTAM_BeforeRow">
						<P_B typ="G">
							<ea:XmlDataLabel ElementName="P_B4" runat="server" DataMember="B1.Nazwa" XSDType="TTekstowy"/>
							<ea:XmlDataLabel ElementName="P_B5" runat="server" DataMember="B1.NazwaSkrócona" XSDType="TTekstowy" HideEmptyOrZero="true"/>
							<ea:XmlDataLabel ElementName="P_B6" runat="server" DataMember="B1.NIP" XSDType="TNrNIP" HideEmptyOrZero="true"/>
							<ea:XmlDataLabel ElementName="P_B7" runat="server" DataMember="B1.DataRozpoczęciaDziałalności" XSDType="TData" HideEmptyOrZero="true"/>
							<ea:XmlDataLabel ElementName="P_B8A" runat="server" DataMember="X.KodKraju" XSDType="TTekstowy"><ValuesMap><ea:ValuesPair Key="" Value="PL" /></ValuesMap></ea:XmlDataLabel>
							<ea:XmlDataLabel ElementName="P_B9" runat="server" DataMember="B2.Wojew" XSDType="TJednAdmin" HideEmptyOrZero="true"/>
							<ea:XmlDataLabel ElementName="P_B10" runat="server" DataMember="B2.Powiat" XSDType="TJednAdmin" HideEmptyOrZero="true"/>
							<ea:XmlDataLabel ElementName="P_B11" runat="server" DataMember="B2.Gmina" XSDType="TJednAdmin" HideEmptyOrZero="true"/>
							<ea:XmlDataLabel ElementName="P_B12" runat="server" DataMember="B2.Ulica" XSDType="TUlica" HideEmptyOrZero="true"/>
							<ea:XmlDataLabel ElementName="P_B13" runat="server" DataMember="B2.NrDomu" XSDType="TNrBudynku" HideEmptyOrZero="true"/>
							<ea:XmlDataLabel ElementName="P_B14" runat="server" DataMember="B2.NrLokalu" XSDType="TNrLokalu" HideEmptyOrZero="true"/>
							<ea:XmlDataLabel ElementName="P_B15" runat="server" DataMember="B2.Miejsc" XSDType="TMiejscowosc"/>
							<ea:XmlDataLabel ElementName="P_B16" runat="server" DataMember="B2.KodPoczt" XSDType="TKodPocztowy" HideEmptyOrZero="true"/>
						</P_B>
					</ea:DataRepeater>
				</PozycjeSzczegolowe>
			</Zalacznik_CIT_A>
		</ea:DataRepeater>
		<ea:Section ID="ORD_ZU" runat="server">
			<Zalacznik_ORD-ZU xmlns="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2022/09/13/eD/ORDZU/">
				<Naglowek>
					<KodFormularza kodSystemowy="ORD-ZU (3)" wersjaSchemy="10-0E">ORD-ZU</KodFormularza>
					<WariantFormularza>3</WariantFormularza>
				</Naglowek>
				<PozycjeSzczegolowe>
					<ea:XmlDataLabel ElementName="P_13" runat="server" DataMember="TreśćUzasadnienia" XSDType="TTekstowy"/>
				</PozycjeSzczegolowe>
			</Zalacznik_ORD-ZU>
		</ea:Section>
	</Zalaczniki>

</Deklaracja>
