<%@ Page Language="C#" AutoEventWireup="false" CodePage="1200" %>

<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Deklaracje" %>
<%@ Import Namespace="System.Diagnostics" %>
<script runat="server">
    bool ift1R;

    void OnContextLoad(Object sender, EventArgs args) {
        Soneta.Deklaracje.PIT.IFT1 dek = (Soneta.Deklaracje.PIT.IFT1)dc[typeof(Soneta.Deklaracje.PIT.IFT1)];
        if (dek is Soneta.Deklaracje.PIT.IFT1R_18) {
            ift1R = true;
            ORD_ZU.Visible = ((Soneta.Deklaracje.PIT.IFT1R_18)dek).TreśćUzasadnienia != "";
        }
        else if (dek is Soneta.Deklaracje.PIT.IFT1_18) {
            ift1R = false;
            ORD_ZU.Visible = ((Soneta.Deklaracje.PIT.IFT1_18)dek).TreśćUzasadnienia != "";
        }
        else
            throw new RowException(dek, "Wzór tylko dla deklaracji IFT1(18) oraz IFT1R(18).");

        bool osobaFizyczna = (bool)dek.Bloki["B1"]["OsobaFiz"];

        if (osobaFizyczna) {
            OsobaNieFizyczna.Visible = false;
            string[] nazwa = Soneta.Deklaracje.PIT.PIT.DaneFirmy((string)dek.Bloki["B1"]["Nazwa"], 3);
            Debug.Assert(nazwa.Length == 3);

            Nazwisko.EditValue = nazwa[0].Trim();
            ImiePierwsze.EditValue = nazwa[1].Trim();
            DataUrodzenia.EditValue = nazwa[2].Trim();
        }
        else
            OsobaFizyczna.Visible = false;

        string kodKraju = ((string)dek.Bloki["X"]["KodKrajuPl"]).ToUpper();
        if (kodKraju == "" || kodKraju == "PL")
            AdresZagrPl.Visible = false;
        else
            AdresPolPl.Visible = false;

        DataZłożenia.Visible = !ift1R;

        InitBrakDanych(dek);
    }

    void InitBrakDanych(Deklaracja dek) {
        string brakDanych = dek.Module.Config.PIT.Ogólne.UzupełnienieAdresuNaEDeklaracji;
        if (brakDanych != "") {
            AddMap(pit_miejscZagr, "", brakDanych, 56);
            AddMap(pit_miejscUrodz, "", brakDanych, 56);
        }
    }

    static void AddMap(XmlDataLabel label, string key, string value, int maxLen) {
        label.ValuesMap.Add(new ValuesPair(key, Soneta.Core.Tools.Left(value, maxLen)));
    }

</script>
<ea:datacontext id="dc" runat="server" TypeName="Soneta.Deklaracje.PIT.IFT1,Soneta.Deklaracje" OnContextLoad="OnContextLoad"></ea:datacontext>
<?xml version="1.0" encoding="UTF-8" ?>
<%if (ift1R) { %>
<Deklaracja              
    xsi:schemaLocation="http://crd.gov.pl/wzor/2025/10/27/13949/ http://crd.gov.pl/wzor/2025/10/27/13949/schemat.xsd"
    xmlns="http://crd.gov.pl/wzor/2025/10/27/13949/"
    xmlns:xsd="http://www.w3.org/2001/XMLSchema"
    xmlns:etd="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2022/09/13/eD/DefinicjeTypy/"
    xmlns:zzu="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2022/09/13/eD/ORDZU/"
    xmlns:kusex="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2021/12/23/eD/KodyUrzedowSkarbowychExWUS/"
    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
<%} else {%>
<Deklaracja 
    xsi:schemaLocation="http://crd.gov.pl/wzor/2025/10/27/13950/ http://crd.gov.pl/wzor/2025/10/27/13950/schemat.xsd" 
    xmlns="http://crd.gov.pl/wzor/2025/10/27/13950/" 
    xmlns:xsd="http://www.w3.org/2001/XMLSchema" 
    xmlns:etd="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2022/09/13/eD/DefinicjeTypy/" 
    xmlns:zzu="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2022/09/13/eD/ORDZU/"
    xmlns:kusex="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2021/12/23/eD/KodyUrzedowSkarbowychExWUS/"
    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
<%}%>
    <Naglowek>
<%if (ift1R) { %>
        <KodFormularza kodSystemowy="IFT-1R (18)" kodPodatku="PIT" rodzajZobowiazania="Z" wersjaSchemy="1-0E">IFT-1/IFT-1R</KodFormularza>
<%} else {%>
        <KodFormularza kodSystemowy="IFT-1 (18)" kodPodatku="PIT" rodzajZobowiazania="Z" wersjaSchemy="1-0E">IFT-1/IFT-1R</KodFormularza>
<%}%>
        <WariantFormularza>18</WariantFormularza>
        <CelZlozenia poz="P_7"><ea:XmlDataLabel runat="server" DataMember="A.Korekta"><ValuesMap><ea:ValuesPair Key="False" Value="1" /><ea:ValuesPair Key="True" Value="2"/></ValuesMap></ea:XmlDataLabel></CelZlozenia>
        <OkresOd poz="P_4"><ea:XmlDataLabel runat="server" DataMember="0.Od" XSDType="TData"></ea:XmlDataLabel></OkresOd>
        <OkresDo poz="P_5"><ea:XmlDataLabel runat="server" DataMember="0.Do" XSDType="TData"></ea:XmlDataLabel></OkresDo>
        <ea:XmlDataLabel ElementName="KodUrzedu" runat="server" DataMember="X.KodUrzeduSkarbowego" />
    </Naglowek>
    <Podmiot1 rola="Płatnik/Podmiot Wypłacający">
        <ea:Section ID="OsobaFizyczna" runat="server"><OsobaFizyczna>
            <ea:XmlDataLabel ElementName="etd:NIP" runat="server" DataMember="0.Nip" XSDType="TNrNIP"/>
            <ea:XmlDataLabel ElementName="etd:ImiePierwsze" ID="ImiePierwsze" runat="server" XSDType="TImie" />
            <ea:XmlDataLabel ElementName="etd:Nazwisko" ID="Nazwisko" runat="server" XSDType="TNazwisko" />
            <ea:XmlDataLabel ElementName="etd:DataUrodzenia" ID="DataUrodzenia" runat="server" XSDType="TData" />
        </OsobaFizyczna></ea:Section>
        <ea:Section ID="OsobaNieFizyczna" runat="server"><OsobaNiefizyczna>
            <ea:XmlDataLabel ElementName="NIP" runat="server" DataMember="0.Nip" XSDType="TNrNIP"/>
            <ea:XmlDataLabel ElementName="PelnaNazwa" ID="NazwaPelna" runat="server" DataMember="B1.Nazwa" XSDType="TZnakowy" />
        </OsobaNiefizyczna></ea:Section>
        <AdresZamieszkaniaSiedziby rodzajAdresu="RAD">
            <ea:Section ID="AdresPolPl" runat="server">
            <AdresPol>
                <KodKraju>PL</KodKraju>
                <ea:XmlDataLabel ElementName="Wojewodztwo" runat="server" DataMember="B2.Wojew" XSDType="TJednAdmin" />
                <ea:XmlDataLabel ElementName="Powiat" runat="server" DataMember="B2.Powiat" XSDType="TJednAdmin"/>
                <ea:XmlDataLabel ElementName="Gmina" runat="server" DataMember="B2.Gmina" XSDType="TJednAdmin"/>
                <ea:XmlDataLabel ElementName="Ulica" runat="server" HideEmptyOrZero="true" DataMember="B2.Ulica" XSDType="TUlica"/>
                <ea:XmlDataLabel ElementName="NrDomu" runat="server" DataMember="B2.NrDomu" XSDType="TNrBudynku"/>
                <ea:XmlDataLabel ElementName="NrLokalu" runat="server" HideEmptyOrZero="true" DataMember="B2.NrLokalu" XSDType="TNrLokalu"/>
                <ea:XmlDataLabel ElementName="Miejscowosc" runat="server" DataMember="B2.Miejsc" XSDType="TMiejscowosc"/>
                <ea:XmlDataLabel ElementName="KodPocztowy" runat="server" DataMember="B2.KodPoczt" XSDType="TKodPocztowy"/>
            </AdresPol>
            </ea:Section>
            <ea:Section ID="AdresZagrPl" runat="server">
            <AdresZagr>
                <ea:XmlDataLabel ElementName="KodKraju" runat="server" DataMember="X.KodKrajuPl" XSDType="TTekstowy"/>
                <ea:XmlDataLabel ElementName="KodPocztowy" runat="server" DataMember="B2.KodPoczt" XSDType="TKodPocztowy" HideEmptyOrZero="true"/>
                <ea:XmlDataLabel ElementName="Miejscowosc" runat="server" DataMember="B2.Miejsc" XSDType="TMiejscowosc"/>
                <ea:XmlDataLabel ElementName="Ulica" runat="server" DataMember="B2.Ulica" XSDType="TUlica" HideEmptyOrZero="true"/>
                <ea:XmlDataLabel ElementName="NrDomu" runat="server" DataMember="B2.NrDomu" XSDType="TNrBudynku" HideEmptyOrZero="true"/>
                <ea:XmlDataLabel ElementName="NrLokalu" runat="server" DataMember="B2.NrLokalu" XSDType="TNrLokalu" HideEmptyOrZero="true"/>
            </AdresZagr>
            </ea:Section>
        </AdresZamieszkaniaSiedziby>
    </Podmiot1>	
    <Podmiot2 rola="Odbiorca Należności">
        <OsobaFizZagr>
            <ea:XmlDataLabel ElementName="ImiePierwsze" runat="server" DataMember="C1.Imię" XSDType="TImie"/>
            <ea:XmlDataLabel ElementName="Nazwisko" runat="server" DataMember="C1.Nazwisko" XSDType="TNazwisko"/>
            <ea:XmlDataLabel ElementName="DataUrodzenia" runat="server" DataMember="C1.DataUrodz" XSDType="TData"/>
            <ea:XmlDataLabel ElementName="MiejsceUrodzenia" ID="pit_miejscUrodz" runat="server" DataMember="C1.MiejsceUrodz" XSDType="TMiejscowosc"/>
            <ea:XmlDataLabel ElementName="ImieOjca" runat="server" DataMember="C1.ImięOjca" XSDType="TImie" HideEmptyOrZero="true"/>
            <ea:XmlDataLabel ElementName="ImieMatki" runat="server" DataMember="C1.ImięMatki" XSDType="TImie" HideEmptyOrZero="true"/>
            <NrId poz="P_26"><ea:XmlDataLabel runat="server" DataMember="C1.Dokument" XSDType="TZnakowy"/></NrId>
            <RodzajNrId poz="P_27"><ea:XmlDataLabel runat="server" DataMember="X.RodzajNumeruPodatnika" XSDType="TZnakowy"/></RodzajNrId>
            <KodKrajuWydania poz="P_28A"><ea:XmlDataLabel runat="server" DataMember="X.DokumentKodKraju" XSDType="TZnakowy"/></KodKrajuWydania>
        </OsobaFizZagr>
        <AdresZamieszkania rodzajAdresu="RAD">
            <ea:XmlDataLabel ElementName="KodKraju" runat="server" DataMember="X.KodKraju" XSDType="TTekstowy"/>
            <ea:XmlDataLabel ElementName="KodPocztowy" runat="server" DataMember="C2.KodPoczt" XSDType="TKodPocztowy" HideEmptyOrZero="true"/>
            <ea:XmlDataLabel ElementName="Miejscowosc" ID="pit_miejscZagr" runat="server" DataMember="C2.Miejsc" XSDType="TMiejscowosc"/>
            <ea:XmlDataLabel ElementName="Ulica" runat="server" DataMember="C2.Ulica" XSDType="TUlica" HideEmptyOrZero="true"/>
            <ea:XmlDataLabel ElementName="NrDomu" runat="server" DataMember="C2.NrDomu" XSDType="TNrBudynku" HideEmptyOrZero="true"/>
            <ea:XmlDataLabel ElementName="NrLokalu" runat="server" DataMember="C2.NrLokalu" XSDType="TNrLokalu" HideEmptyOrZero="true"/>
        </AdresZamieszkania>
    </Podmiot2>
    <PozycjeSzczegolowe>

        <P_10>
            <ea:XmlDataLabel runat="server" DataMember="C1.PodatnikPłatnikSąPowiązani">
                <ValuesMap>
                    <ea:ValuesPair Key="False" Value="1" />
                    <ea:ValuesPair Key="True" Value="2"/>
                </ValuesMap>
            </ea:XmlDataLabel>
        </P_10>

        <ea:XmlDataLabel ElementName="P_35" runat="server" DataMember="D.8Zwolniony" XSDType="TKwotaC" />
        <ea:XmlDataLabel ElementName="P_36" runat="server" DataMember="D.8Kwota" XSDType="TKwotaC" />
        <ea:XmlDataLabel ElementName="P_37" runat="server" DataMember="D.8Podatek" XSDType="TKwotaC" />

        <P_E typ="G">
            <P_E1><ea:XmlDataLabel runat="server" DataMember="E.1Stawka" XSDType="TProcentowy" /></P_E1>
            <P_E2><ea:XmlDataLabel runat="server" DataMember="E.1Zwolniony" XSDType="TKwotaC" /></P_E2>
            <P_E3><ea:XmlDataLabel runat="server" DataMember="E.1Kwota" XSDType="TKwotaC" /></P_E3>
            <P_E4><ea:XmlDataLabel runat="server" DataMember="E.1Podatek" XSDType="TKwotaC" /></P_E4>
        </P_E>
		
        <ea:XmlDataLabel ElementName="P_38" runat="server" DataMember="D.10Zwolniony" XSDType="TKwotaC" />
        <ea:XmlDataLabel ElementName="P_39" runat="server" DataMember="D.10Kwota" XSDType="TKwotaC" />
        <ea:XmlDataLabel ElementName="P_40" runat="server" DataMember="D.10Podatek" XSDType="TKwotaC" />

        <P_F typ="G">
            <P_F1><ea:XmlDataLabel runat="server" DataMember="F.1Stawka" XSDType="TProcentowy" /></P_F1>
            <P_F2><ea:XmlDataLabel runat="server" DataMember="F.1Zwolniony" XSDType="TKwotaC" /></P_F2>
            <P_F3><ea:XmlDataLabel runat="server" DataMember="F.1Kwota" XSDType="TKwotaC" /></P_F3>
            <P_F4><ea:XmlDataLabel runat="server" DataMember="F.1Podatek" XSDType="TKwotaC" /></P_F4>
        </P_F>

        <ea:XmlDataLabel ElementName="P_41" runat="server" DataMember="D.11Zwolniony" XSDType="TKwota2" />		
        <ea:XmlDataLabel ElementName="P_42" runat="server" DataMember="D.11Kwota" XSDType="TKwota2" />
        <ea:XmlDataLabel ElementName="P_43" runat="server" DataMember="D.11Podatek" XSDType="TKwota2" />

        <P_G typ="G">
            <P_G1><ea:XmlDataLabel runat="server" DataMember="G.1Stawka" XSDType="TProcentowy" /></P_G1>
            <P_G2><ea:XmlDataLabel runat="server" DataMember="G.1Zwolniony" XSDType="TKwota2" /></P_G2>
            <P_G3><ea:XmlDataLabel runat="server" DataMember="G.1Kwota" XSDType="TKwota2" /></P_G3>
            <P_G4><ea:XmlDataLabel runat="server" DataMember="G.1Podatek" XSDType="TKwota2" /></P_G4>
        </P_G>

        <ea:XmlDataLabel ElementName="P_44" runat="server" DataMember="D.12Zwolniony" XSDType="TKwotaC" />
        <ea:XmlDataLabel ElementName="P_45" runat="server" DataMember="D.12Kwota" XSDType="TKwotaC" />
        <ea:XmlDataLabel ElementName="P_46" runat="server" DataMember="D.12Podatek" XSDType="TKwotaC" />

        <P_H typ="G">
            <P_H1><ea:XmlDataLabel runat="server" DataMember="H.1Stawka" XSDType="TProcentowy" /></P_H1>
            <P_H2><ea:XmlDataLabel runat="server" DataMember="H.1Zwolniony" XSDType="TKwotaC" /></P_H2>
            <P_H3><ea:XmlDataLabel runat="server" DataMember="H.1Kwota" XSDType="TKwotaC" /></P_H3>
            <P_H4><ea:XmlDataLabel runat="server" DataMember="H.1Podatek" XSDType="TKwotaC" /></P_H4>
        </P_H>

        <ea:XmlDataLabel ElementName="P_47" runat="server" DataMember="D.14Zwolniony" XSDType="TKwotaC" />
        <ea:XmlDataLabel ElementName="P_48" runat="server" DataMember="D.14Kwota" XSDType="TKwotaC" />
        <ea:XmlDataLabel ElementName="P_49" runat="server" DataMember="D.14Podatek" XSDType="TKwotaC" />

        <P_I typ="G">
            <P_I1><ea:XmlDataLabel runat="server" DataMember="I.1Stawka" XSDType="TProcentowy" /></P_I1>
            <P_I2><ea:XmlDataLabel runat="server" DataMember="I.1Zwolniony" XSDType="TKwotaC" /></P_I2>
            <P_I3><ea:XmlDataLabel runat="server" DataMember="I.1Kwota" XSDType="TKwotaC" /></P_I3>
            <P_I4><ea:XmlDataLabel runat="server" DataMember="I.1Podatek" XSDType="TKwotaC" /></P_I4>
        </P_I>

        <ea:XmlDataLabel ElementName="P_50" runat="server" DataMember="D.16Zwolniony" XSDType="TKwotaC" />
        <ea:XmlDataLabel ElementName="P_51" runat="server" DataMember="D.16Kwota" XSDType="TKwotaC" />
        <ea:XmlDataLabel ElementName="P_52" runat="server" DataMember="D.16Podatek" XSDType="TKwotaC" />

        <P_J typ="G">
            <P_J1><ea:XmlDataLabel runat="server" DataMember="J.1Stawka" XSDType="TProcentowy" /></P_J1>
            <P_J2><ea:XmlDataLabel runat="server" DataMember="J.1Zwolniony" XSDType="TKwotaC" /></P_J2>
            <P_J3><ea:XmlDataLabel runat="server" DataMember="J.1Kwota" XSDType="TKwotaC" /></P_J3>
            <P_J4><ea:XmlDataLabel runat="server" DataMember="J.1Podatek" XSDType="TKwotaC" /></P_J4>
        </P_J>

        <ea:XmlDataLabel ElementName="P_53" runat="server" DataMember="D.17Zwolniony" XSDType="TKwotaC" />
        <ea:XmlDataLabel ElementName="P_54" runat="server" DataMember="D.17Kwota" XSDType="TKwotaC" />
        <ea:XmlDataLabel ElementName="P_55" runat="server" DataMember="D.17Podatek" XSDType="TKwotaC" />

        <P_K typ="G">
            <P_K1><ea:XmlDataLabel runat="server" DataMember="K.1Stawka" XSDType="TProcentowy" /></P_K1>
            <P_K2><ea:XmlDataLabel runat="server" DataMember="K.1Zwolniony" XSDType="TKwotaC" /></P_K2>
            <P_K3><ea:XmlDataLabel runat="server" DataMember="K.1Kwota" XSDType="TKwotaC" /></P_K3>
            <P_K4><ea:XmlDataLabel runat="server" DataMember="K.1Podatek" XSDType="TKwotaC" /></P_K4>
        </P_K>

        <ea:XmlDataLabel ElementName="P_56" runat="server" DataMember="D.18Zwolniony" XSDType="TKwotaC" />
        <ea:XmlDataLabel ElementName="P_57" runat="server" DataMember="D.18Kwota" XSDType="TKwotaC" />
        <ea:XmlDataLabel ElementName="P_58" runat="server" DataMember="D.18Podatek" XSDType="TKwotaC" />

        <P_L typ="G">
            <P_L1><ea:XmlDataLabel runat="server" DataMember="L.1Stawka" XSDType="TProcentowy" /></P_L1>
            <P_L2><ea:XmlDataLabel runat="server" DataMember="L.1Zwolniony" XSDType="TKwotaC" /></P_L2>
            <P_L3><ea:XmlDataLabel runat="server" DataMember="L.1Kwota" XSDType="TKwotaC" /></P_L3>
            <P_L4><ea:XmlDataLabel runat="server" DataMember="L.1Podatek" XSDType="TKwotaC" /></P_L4>
        </P_L>

        <ea:XmlDataLabel ElementName="P_59" runat="server" DataMember="D.21Zwolniony" XSDType="TKwotaC" />
        <ea:XmlDataLabel ElementName="P_60" runat="server" DataMember="D.21Kwota" XSDType="TKwotaC" />
        <ea:XmlDataLabel ElementName="P_61" runat="server" DataMember="D.21Podatek" XSDType="TKwotaC" />

        <P_M typ="G">
            <P_M1><ea:XmlDataLabel runat="server" DataMember="M.1Stawka" XSDType="TProcentowy" /></P_M1>
            <P_M2><ea:XmlDataLabel runat="server" DataMember="M.1Zwolniony" XSDType="TKwotaC" /></P_M2>
            <P_M3><ea:XmlDataLabel runat="server" DataMember="M.1Kwota" XSDType="TKwotaC" /></P_M3>
            <P_M4><ea:XmlDataLabel runat="server" DataMember="M.1Podatek" XSDType="TKwotaC" /></P_M4>
        </P_M>
		
        <ea:XmlDataLabel ElementName="P_62" runat="server" DataMember="D.99_29Zwolniony" XSDType="TKwota2" />
        <ea:XmlDataLabel ElementName="P_63" runat="server" DataMember="D.99_29Kwota" XSDType="TKwota2" />
        <ea:XmlDataLabel ElementName="P_64" runat="server" DataMember="D.99_29Podatek" XSDType="TKwota2" />
        <ea:XmlDataLabel ElementName="P_65" runat="server" DataMember="D.65Podatek" XSDType="TKwota2" />

        <P_N typ="G">
            <P_N1><ea:XmlDataLabel runat="server" DataMember="N.1Stawka" XSDType="TProcentowy" /></P_N1>
            <P_N2><ea:XmlDataLabel runat="server" DataMember="N.1Zwolniony" XSDType="TKwota2" /></P_N2>
            <P_N3><ea:XmlDataLabel runat="server" DataMember="N.1Kwota" XSDType="TKwota2" /></P_N3>
            <P_N4><ea:XmlDataLabel runat="server" DataMember="N.1Podatek" XSDType="TKwota2" /></P_N4>
            <P_N5><ea:XmlDataLabel runat="server" DataMember="N.1WTymWysokoscPodatku" XSDType="TKwota2" /></P_N5>
        </P_N>

        <ea:XmlDataLabel ElementName="P_66" runat="server" DataMember="D.99_30Zwolniony" XSDType="TKwota2" />		
        <ea:XmlDataLabel ElementName="P_67" runat="server" DataMember="D.99_30Kwota" XSDType="TKwota2" />
        <ea:XmlDataLabel ElementName="P_68" runat="server" DataMember="D.99_30Podatek" XSDType="TKwota2" />

        <P_O typ="G">
            <P_O1><ea:XmlDataLabel runat="server" DataMember="O.1Stawka" XSDType="TProcentowy" /></P_O1>
            <P_O2><ea:XmlDataLabel runat="server" DataMember="O.1Zwolniony" XSDType="TKwota2" /></P_O2>
            <P_O3><ea:XmlDataLabel runat="server" DataMember="O.1Kwota" XSDType="TKwota2" /></P_O3>
            <P_O4><ea:XmlDataLabel runat="server" DataMember="O.1Podatek" XSDType="TKwota2" /></P_O4>
        </P_O>

        <ea:XmlDataLabel ElementName="P_69" runat="server" DataMember="D.99_30aZwolniony" XSDType="TKwota2" />
        <ea:XmlDataLabel ElementName="P_70" runat="server" DataMember="D.99_30aKwota" XSDType="TKwota2" />
        <ea:XmlDataLabel ElementName="P_71" runat="server" DataMember="D.99_30aPodatek" XSDType="TKwota2" />
        <ea:XmlDataLabel ElementName="P_72" runat="server" DataMember="D.72Podatek" XSDType="TKwota2" />

        <P_P typ="G">
            <P_P1><ea:XmlDataLabel runat="server" DataMember="P.1Stawka" XSDType="TProcentowy" /></P_P1>
            <P_P2><ea:XmlDataLabel runat="server" DataMember="P.1Zwolniony" XSDType="TKwota2" /></P_P2>
            <P_P3><ea:XmlDataLabel runat="server" DataMember="P.1Kwota" XSDType="TKwota2" /></P_P3>
            <P_P4><ea:XmlDataLabel runat="server" DataMember="P.1Podatek" XSDType="TKwota2" /></P_P4>
            <P_P5><ea:XmlDataLabel runat="server" DataMember="P.1WTymWysokoscPodatku" XSDType="TKwota2" /></P_P5>
        </P_P>

<%if (!ift1R) { %>
        <ea:XmlDataLabel ElementName="P_73" ID="DataZłożenia" runat="server" DataMember="Q.DataZłożenia" XSDType="TData" />
    <%}%>

        <ea:XmlDataLabel ElementName="P_74" runat="server" DataMember="Q.DataPrzekazania" XSDType="TData" />
        <ea:XmlDataLabel ElementName="P_80" runat="server" DataMember="S.NumerTelefonu" XSDType="TZnakowy" MaxLength="16" MinLength="1"/>
        <ea:XmlDataLabel ElementName="P_81" runat="server" DataMember="S.AdresEmail" XSDType="TZnakowy" />


    </PozycjeSzczegolowe>
    <Pouczenie>1</Pouczenie>
    <ea:Section ID="ORD_ZU" runat="server">
    <Zalaczniki>
    <zzu:Zalacznik_ORD-ZU>
        <zzu:Naglowek>
            <zzu:KodFormularza kodSystemowy="ORD-ZU (3)" wersjaSchemy="10-0E">ORD-ZU</zzu:KodFormularza>
            <zzu:WariantFormularza>3</zzu:WariantFormularza>
        </zzu:Naglowek>
        <zzu:PozycjeSzczegolowe>
            <ea:XmlDataLabel ElementName="zzu:P_13" runat="server" DataMember="TreśćUzasadnienia" XSDType="TTekstowy"/>
        </zzu:PozycjeSzczegolowe>
    </zzu:Zalacznik_ORD-ZU>
    </Zalaczniki>
    </ea:Section>
</Deklaracja>
