﻿<%@ Page Language="C#" AutoEventWireup="false" CodePage="1200" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="System.Diagnostics" %>
<%@ Import Namespace="Soneta.Deklaracje" %>
<script runat="server">
    Soneta.Deklaracje.PIT.PIT8AR_12 dek;

    void OnContextLoad(Object sender, EventArgs args) {
        dek = (Soneta.Deklaracje.PIT.PIT8AR_12)dc[typeof(Soneta.Deklaracje.PIT.PIT8AR_12)];

        if ((bool)dek.Bloki["A"]["RodzajKorektyArt81"]) {
            RodzajKorekty.Visible = true;
            Rodzaj.EditValue = "1";
        }
        else if ((bool)dek.Bloki["A"]["RodzajKorektyArt81b1a"]) {
            RodzajKorekty.Visible = true;
            Rodzaj.EditValue = "2";
        }
        else
            RodzajKorekty.Visible = false;

        bool osobaFizyczna = (bool)dek.Bloki["B1"]["OsobaFiz"];        
        
        if (osobaFizyczna) {
            OsobaNieFizyczna.Visible = false;
			string[] nazwa = Soneta.Deklaracje.PIT.PIT.DaneFirmy((string)dek.Bloki["B1"]["Nazwa"], 3);
			Debug.Assert(nazwa.Length == 3);

			Nazwisko.EditValue = nazwa[0].Trim();
            ImiePierwsze.EditValue = nazwa[1].Trim();
            DataUrodzenia.EditValue = nazwa[2].Trim();
        }
        else 
            OsobaFizyczna.Visible = false;
        
        ORD_ZU.Visible = dek.TreśćUzasadnienia != "";
    }
	
</script>
<ea:datacontext id="dc" runat="server" TypeName="Soneta.Deklaracje.PIT.PIT8AR_12,Soneta.Deklaracje" OnContextLoad="OnContextLoad"></ea:datacontext>
<?xml version="1.0" encoding="UTF-8"?>
<Deklaracja 
    xsi:schemaLocation="http://crd.gov.pl/wzor/2022/04/15/11486/ http://crd.gov.pl/wzor/2022/04/15/11486/schemat.xsd" 
    xmlns="http://crd.gov.pl/wzor/2022/04/15/11486/" 
    xmlns:zzu="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2022/03/14/eD/ORDZU/"
    xmlns:etd="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2022/01/05/eD/DefinicjeTypy/"
    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
    <Naglowek>
        <KodFormularza kodSystemowy="PT-8AR (12)" kodPodatku="PPR" rodzajZobowiazania="P" wersjaSchemy="1-0E">PIT-8AR</KodFormularza>
        <WariantFormularza>12</WariantFormularza>		
        <CelZlozenia poz="P_6"><ea:XmlDataLabel runat="server" DataMember="A.Korekta"><ValuesMap><ea:ValuesPair Key="False" Value="1" /><ea:ValuesPair Key="True" Value="2"/></ValuesMap></ea:XmlDataLabel></CelZlozenia>
        <ea:XmlDataLabel ElementName="Rok" runat="server" DataMember="0.Rok" />
        <ea:XmlDataLabel ElementName="KodUrzedu" runat="server" DataMember="X.KodUrzeduSkarbowego" />
    </Naglowek>
    <Podmiot1 rola="Płatnik">
        <ea:Section ID="OsobaFizyczna" runat="server"><OsobaFizyczna>
            <ea:XmlDataLabel ElementName="etd:NIP" runat="server" DataMember="0.Nip" XSDType="TNrNIP"/>
            <ea:XmlDataLabel ElementName="etd:ImiePierwsze" ID="ImiePierwsze" runat="server" XSDType="TImie"></ea:XmlDataLabel>
            <ea:XmlDataLabel ElementName="etd:Nazwisko" ID="Nazwisko" runat="server" XSDType="TNazwisko"></ea:XmlDataLabel>
            <ea:XmlDataLabel ElementName="etd:DataUrodzenia" ID="DataUrodzenia" runat="server" XSDType="TData"></ea:XmlDataLabel>
        </OsobaFizyczna></ea:Section>
        <ea:Section ID="OsobaNieFizyczna" runat="server"><OsobaNiefizyczna>
            <ea:XmlDataLabel ElementName="NIP" runat="server" DataMember="0.Nip" XSDType="TNrNIP"/>
            <ea:XmlDataLabel ElementName="PelnaNazwa" ID="NazwaPelna" runat="server" DataMember="B1.Nazwa" XSDType="TZnakowy" />
        </OsobaNiefizyczna></ea:Section>
    </Podmiot1>	
	<PozycjeSzczegolowe>
        <ea:Section ID="RodzajKorekty" runat="server">
		    <ea:XmlDataLabel ElementName="P_7" runat="server" ID="Rodzaj" XSDType="TCalkowity"/>
        </ea:Section>

		<ea:XmlDataLabel ElementName="P_10" runat="server" DataMember="C1.1Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_11" runat="server" DataMember="C1.2Podatek" XSDType="TKwotaC"/>	
		<ea:XmlDataLabel ElementName="P_12" runat="server" DataMember="C1.3Podatek" XSDType="TKwotaC"/>	
		<ea:XmlDataLabel ElementName="P_13" runat="server" DataMember="C1.4Podatek" XSDType="TKwotaC"/>	
		<ea:XmlDataLabel ElementName="P_14" runat="server" DataMember="C1.5Podatek" XSDType="TKwotaC"/>	
		<ea:XmlDataLabel ElementName="P_15" runat="server" DataMember="C1.6Podatek" XSDType="TKwotaC"/>	
		<ea:XmlDataLabel ElementName="P_16" runat="server" DataMember="C1.7Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_17" runat="server" DataMember="C1.8Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_18" runat="server" DataMember="C1.9Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_19" runat="server" DataMember="C1.10Podatek" XSDType="TKwotaC"/>		
		<ea:XmlDataLabel ElementName="P_20" runat="server" DataMember="C1.11Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_21" runat="server" DataMember="C1.12Podatek" XSDType="TKwotaC"/>

		<ea:XmlDataLabel ElementName="P_22" runat="server" DataMember="C2.1Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_23" runat="server" DataMember="C2.2Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_24" runat="server" DataMember="C2.3Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_25" runat="server" DataMember="C2.4Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_26" runat="server" DataMember="C2.5Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_27" runat="server" DataMember="C2.6Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_28" runat="server" DataMember="C2.7Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_29" runat="server" DataMember="C2.8Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_30" runat="server" DataMember="C2.9Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_31" runat="server" DataMember="C2.10Podatek" XSDType="TKwotaC"/>	
		<ea:XmlDataLabel ElementName="P_32" runat="server" DataMember="C2.11Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_33" runat="server" DataMember="C2.12Podatek" XSDType="TKwotaC"/>

		<ea:XmlDataLabel ElementName="P_34" runat="server" DataMember="C3.1Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_35" runat="server" DataMember="C3.2Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_36" runat="server" DataMember="C3.3Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_37" runat="server" DataMember="C3.4Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_38" runat="server" DataMember="C3.5Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_39" runat="server" DataMember="C3.6Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_40" runat="server" DataMember="C3.7Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_41" runat="server" DataMember="C3.8Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_42" runat="server" DataMember="C3.9Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_43" runat="server" DataMember="C3.10Podatek" XSDType="TKwotaC"/>	
		<ea:XmlDataLabel ElementName="P_44" runat="server" DataMember="C3.11Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_45" runat="server" DataMember="C3.12Podatek" XSDType="TKwotaC"/>
		
		<ea:XmlDataLabel ElementName="P_46" runat="server" DataMember="C4.1Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_47" runat="server" DataMember="C4.2Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_48" runat="server" DataMember="C4.3Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_49" runat="server" DataMember="C4.4Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_50" runat="server" DataMember="C4.5Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_51" runat="server" DataMember="C4.6Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_52" runat="server" DataMember="C4.7Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_53" runat="server" DataMember="C4.8Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_54" runat="server" DataMember="C4.9Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_55" runat="server" DataMember="C4.10Podatek" XSDType="TKwotaC"/>	
		<ea:XmlDataLabel ElementName="P_56" runat="server" DataMember="C4.11Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_57" runat="server" DataMember="C4.12Podatek" XSDType="TKwotaC"/>
		
		<ea:XmlDataLabel ElementName="P_58" runat="server" DataMember="C5.1Świadczenia" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_59" runat="server" DataMember="C5.2Świadczenia" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_60" runat="server" DataMember="C5.3Świadczenia" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_61" runat="server" DataMember="C5.4Świadczenia" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_62" runat="server" DataMember="C5.5Świadczenia" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_63" runat="server" DataMember="C5.6Świadczenia" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_64" runat="server" DataMember="C5.7Świadczenia" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_65" runat="server" DataMember="C5.8Świadczenia" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_66" runat="server" DataMember="C5.9Świadczenia" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_67" runat="server" DataMember="C5.10Świadczenia" XSDType="TKwotaC"/>	
		<ea:XmlDataLabel ElementName="P_68" runat="server" DataMember="C5.11Świadczenia" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_69" runat="server" DataMember="C5.12Świadczenia" XSDType="TKwotaC"/>
		
		<ea:XmlDataLabel ElementName="P_70" runat="server" DataMember="C6.1Należności" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_71" runat="server" DataMember="C6.2Należności" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_72" runat="server" DataMember="C6.3Należności" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_73" runat="server" DataMember="C6.4Należności" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_74" runat="server" DataMember="C6.5Należności" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_75" runat="server" DataMember="C6.6Należności" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_76" runat="server" DataMember="C6.7Należności" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_77" runat="server" DataMember="C6.8Należności" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_78" runat="server" DataMember="C6.9Należności" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_79" runat="server" DataMember="C6.10Należności" XSDType="TKwotaC"/>	
		<ea:XmlDataLabel ElementName="P_80" runat="server" DataMember="C6.11Należności" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_81" runat="server" DataMember="C6.12Należności" XSDType="TKwotaC"/>
		
		<ea:XmlDataLabel ElementName="P_82" runat="server" DataMember="C7.1Oszczędności" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_83" runat="server" DataMember="C7.2Oszczędności" XSDType="TKwotaC"/>	
		<ea:XmlDataLabel ElementName="P_84" runat="server" DataMember="C7.3Oszczędności" XSDType="TKwotaC"/>	
		<ea:XmlDataLabel ElementName="P_85" runat="server" DataMember="C7.4Oszczędności" XSDType="TKwotaC"/>			
		<ea:XmlDataLabel ElementName="P_86" runat="server" DataMember="C7.5Oszczędności" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_87" runat="server" DataMember="C7.6Oszczędności" XSDType="TKwotaC"/>	
		<ea:XmlDataLabel ElementName="P_88" runat="server" DataMember="C7.7Oszczędności" XSDType="TKwotaC"/>	
		<ea:XmlDataLabel ElementName="P_89" runat="server" DataMember="C7.8Oszczędności" XSDType="TKwotaC"/>	
		<ea:XmlDataLabel ElementName="P_90" runat="server" DataMember="C7.9Oszczędności" XSDType="TKwotaC"/>	
		<ea:XmlDataLabel ElementName="P_91" runat="server" DataMember="C7.10Oszczędności" XSDType="TKwotaC"/>	
		<ea:XmlDataLabel ElementName="P_92" runat="server" DataMember="C7.11Oszczędności" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_93" runat="server" DataMember="C7.12Oszczędności" XSDType="TKwotaC"/>

		<ea:XmlDataLabel ElementName="P_94" runat="server" DataMember="C8.1Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_95" runat="server" DataMember="C8.2Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_96" runat="server" DataMember="C8.3Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_97" runat="server" DataMember="C8.4Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_98" runat="server" DataMember="C8.5Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_99" runat="server" DataMember="C8.6Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_100" runat="server" DataMember="C8.7Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_101" runat="server" DataMember="C8.8Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_102" runat="server" DataMember="C8.9Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_103" runat="server" DataMember="C8.10Podatek" XSDType="TKwotaC"/>	
		<ea:XmlDataLabel ElementName="P_104" runat="server" DataMember="C8.11Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_105" runat="server" DataMember="C8.12Podatek" XSDType="TKwotaC"/>
		
		<ea:XmlDataLabel ElementName="P_106" runat="server" DataMember="C9.1Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_107" runat="server" DataMember="C9.2Podatek" XSDType="TKwotaC"/>		
		<ea:XmlDataLabel ElementName="P_108" runat="server" DataMember="C9.3Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_109" runat="server" DataMember="C9.4Podatek" XSDType="TKwotaC"/>		
		<ea:XmlDataLabel ElementName="P_110" runat="server" DataMember="C9.5Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_111" runat="server" DataMember="C9.6Podatek" XSDType="TKwotaC"/>		
		<ea:XmlDataLabel ElementName="P_112" runat="server" DataMember="C9.7Podatek" XSDType="TKwotaC"/>		
		<ea:XmlDataLabel ElementName="P_113" runat="server" DataMember="C9.8Podatek" XSDType="TKwotaC"/>		
		<ea:XmlDataLabel ElementName="P_114" runat="server" DataMember="C9.9Podatek" XSDType="TKwotaC"/>		
		<ea:XmlDataLabel ElementName="P_115" runat="server" DataMember="C9.10Podatek" XSDType="TKwotaC"/>	
		<ea:XmlDataLabel ElementName="P_116" runat="server" DataMember="C9.11Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_117" runat="server" DataMember="C9.12Podatek" XSDType="TKwotaC"/>
		
		<ea:XmlDataLabel ElementName="P_118" runat="server" DataMember="C10.1Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_119" runat="server" DataMember="C10.2Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_120" runat="server" DataMember="C10.3Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_121" runat="server" DataMember="C10.4Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_122" runat="server" DataMember="C10.5Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_123" runat="server" DataMember="C10.6Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_124" runat="server" DataMember="C10.7Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_125" runat="server" DataMember="C10.8Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_126" runat="server" DataMember="C10.9Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_127" runat="server" DataMember="C10.10Podatek" XSDType="TKwotaC"/>	
		<ea:XmlDataLabel ElementName="P_128" runat="server" DataMember="C10.11Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_129" runat="server" DataMember="C10.12Podatek" XSDType="TKwotaC"/>
		
		<ea:XmlDataLabel ElementName="P_130" runat="server" DataMember="C11.1Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_131" runat="server" DataMember="C11.2Podatek" XSDType="TKwotaC"/>	
		<ea:XmlDataLabel ElementName="P_132" runat="server" DataMember="C11.3Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_133" runat="server" DataMember="C11.4Podatek" XSDType="TKwotaC"/>	
		<ea:XmlDataLabel ElementName="P_134" runat="server" DataMember="C11.5Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_135" runat="server" DataMember="C11.6Podatek" XSDType="TKwotaC"/>	
		<ea:XmlDataLabel ElementName="P_136" runat="server" DataMember="C11.7Podatek" XSDType="TKwotaC"/>	
		<ea:XmlDataLabel ElementName="P_137" runat="server" DataMember="C11.8Podatek" XSDType="TKwotaC"/>	
		<ea:XmlDataLabel ElementName="P_138" runat="server" DataMember="C11.9Podatek" XSDType="TKwotaC"/>	
		<ea:XmlDataLabel ElementName="P_139" runat="server" DataMember="C11.10Podatek" XSDType="TKwotaC"/>	
		<ea:XmlDataLabel ElementName="P_140" runat="server" DataMember="C11.11Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_141" runat="server" DataMember="C11.12Podatek" XSDType="TKwotaC"/>
		
		<ea:XmlDataLabel ElementName="P_142" runat="server" DataMember="C12.1Podatek" XSDType="TKwota2"/>
		<ea:XmlDataLabel ElementName="P_143" runat="server" DataMember="C12.2Podatek" XSDType="TKwota2"/>	
		<ea:XmlDataLabel ElementName="P_144" runat="server" DataMember="C12.3Podatek" XSDType="TKwota2"/>
		<ea:XmlDataLabel ElementName="P_145" runat="server" DataMember="C12.4Podatek" XSDType="TKwota2"/>	
		<ea:XmlDataLabel ElementName="P_146" runat="server" DataMember="C12.5Podatek" XSDType="TKwota2"/>
		<ea:XmlDataLabel ElementName="P_147" runat="server" DataMember="C12.6Podatek" XSDType="TKwota2"/>	
		<ea:XmlDataLabel ElementName="P_148" runat="server" DataMember="C12.7Podatek" XSDType="TKwota2"/>	
		<ea:XmlDataLabel ElementName="P_149" runat="server" DataMember="C12.8Podatek" XSDType="TKwota2"/>	
		<ea:XmlDataLabel ElementName="P_150" runat="server" DataMember="C12.9Podatek" XSDType="TKwota2"/>	
		<ea:XmlDataLabel ElementName="P_151" runat="server" DataMember="C12.10Podatek" XSDType="TKwota2"/>	
		<ea:XmlDataLabel ElementName="P_152" runat="server" DataMember="C12.11Podatek" XSDType="TKwota2"/>
		<ea:XmlDataLabel ElementName="P_153" runat="server" DataMember="C12.12Podatek" XSDType="TKwota2"/>
		
		<ea:XmlDataLabel ElementName="P_154" runat="server" DataMember="C13.1Podatek" XSDType="TKwota2"/>
		<ea:XmlDataLabel ElementName="P_155" runat="server" DataMember="C13.2Podatek" XSDType="TKwota2"/>		
		<ea:XmlDataLabel ElementName="P_156" runat="server" DataMember="C13.3Podatek" XSDType="TKwota2"/>
		<ea:XmlDataLabel ElementName="P_157" runat="server" DataMember="C13.4Podatek" XSDType="TKwota2"/>		
		<ea:XmlDataLabel ElementName="P_158" runat="server" DataMember="C13.5Podatek" XSDType="TKwota2"/>
		<ea:XmlDataLabel ElementName="P_159" runat="server" DataMember="C13.6Podatek" XSDType="TKwota2"/>		
		<ea:XmlDataLabel ElementName="P_160" runat="server" DataMember="C13.7Podatek" XSDType="TKwota2"/>		
		<ea:XmlDataLabel ElementName="P_161" runat="server" DataMember="C13.8Podatek" XSDType="TKwota2"/>		
		<ea:XmlDataLabel ElementName="P_162" runat="server" DataMember="C13.9Podatek" XSDType="TKwota2"/>		
		<ea:XmlDataLabel ElementName="P_163" runat="server" DataMember="C13.10Podatek" XSDType="TKwota2"/>		
		<ea:XmlDataLabel ElementName="P_164" runat="server" DataMember="C13.11Podatek" XSDType="TKwota2"/>
		<ea:XmlDataLabel ElementName="P_165" runat="server" DataMember="C13.12Podatek" XSDType="TKwota2"/>

		<ea:XmlDataLabel ElementName="P_166" runat="server" DataMember="C14.1Podatek" XSDType="TKwota2"/>
		<ea:XmlDataLabel ElementName="P_167" runat="server" DataMember="C14.2Podatek" XSDType="TKwota2"/>	
		<ea:XmlDataLabel ElementName="P_168" runat="server" DataMember="C14.3Podatek" XSDType="TKwota2"/>
		<ea:XmlDataLabel ElementName="P_169" runat="server" DataMember="C14.4Podatek" XSDType="TKwota2"/>
		<ea:XmlDataLabel ElementName="P_170" runat="server" DataMember="C14.5Podatek" XSDType="TKwota2"/>
		<ea:XmlDataLabel ElementName="P_171" runat="server" DataMember="C14.6Podatek" XSDType="TKwota2"/>	
		<ea:XmlDataLabel ElementName="P_172" runat="server" DataMember="C14.7Podatek" XSDType="TKwota2"/>
		<ea:XmlDataLabel ElementName="P_173" runat="server" DataMember="C14.8Podatek" XSDType="TKwota2"/>
		<ea:XmlDataLabel ElementName="P_174" runat="server" DataMember="C14.9Podatek" XSDType="TKwota2"/>
		<ea:XmlDataLabel ElementName="P_175" runat="server" DataMember="C14.10Podatek" XSDType="TKwota2"/>
		<ea:XmlDataLabel ElementName="P_176" runat="server" DataMember="C14.11Podatek" XSDType="TKwota2"/>
		<ea:XmlDataLabel ElementName="P_177" runat="server" DataMember="C14.12Podatek" XSDType="TKwota2"/>
		
		<ea:XmlDataLabel ElementName="P_178" runat="server" DataMember="C15.1Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_179" runat="server" DataMember="C15.2Podatek" XSDType="TKwotaC"/>	
		<ea:XmlDataLabel ElementName="P_180" runat="server" DataMember="C15.3Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_181" runat="server" DataMember="C15.4Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_182" runat="server" DataMember="C15.5Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_183" runat="server" DataMember="C15.6Podatek" XSDType="TKwotaC"/>	
		<ea:XmlDataLabel ElementName="P_184" runat="server" DataMember="C15.7Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_185" runat="server" DataMember="C15.8Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_186" runat="server" DataMember="C15.9Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_187" runat="server" DataMember="C15.10Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_188" runat="server" DataMember="C15.11Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_189" runat="server" DataMember="C15.12Podatek" XSDType="TKwotaC"/>
		
		<ea:XmlDataLabel ElementName="P_190" runat="server" DataMember="C16.1Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_191" runat="server" DataMember="C16.2Podatek" XSDType="TKwotaC"/>	
		<ea:XmlDataLabel ElementName="P_192" runat="server" DataMember="C16.3Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_193" runat="server" DataMember="C16.4Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_194" runat="server" DataMember="C16.5Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_195" runat="server" DataMember="C16.6Podatek" XSDType="TKwotaC"/>	
		<ea:XmlDataLabel ElementName="P_196" runat="server" DataMember="C16.7Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_197" runat="server" DataMember="C16.8Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_198" runat="server" DataMember="C16.9Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_199" runat="server" DataMember="C16.10Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_200" runat="server" DataMember="C16.11Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_201" runat="server" DataMember="C16.12Podatek" XSDType="TKwotaC"/>

        <ea:XmlDataLabel ElementName="P_202" runat="server" DataMember="C17.1Dochód" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_203" runat="server" DataMember="C17.2Dochód" XSDType="TKwotaC"/>	
		<ea:XmlDataLabel ElementName="P_204" runat="server" DataMember="C17.3Dochód" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_205" runat="server" DataMember="C17.4Dochód" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_206" runat="server" DataMember="C17.5Dochód" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_207" runat="server" DataMember="C17.6Dochód" XSDType="TKwotaC"/>	
		<ea:XmlDataLabel ElementName="P_208" runat="server" DataMember="C17.7Dochód" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_209" runat="server" DataMember="C17.8Dochód" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_210" runat="server" DataMember="C17.9Dochód" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_211" runat="server" DataMember="C17.10Dochód" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_212" runat="server" DataMember="C17.11Dochód" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_213" runat="server" DataMember="C17.12Dochód" XSDType="TKwotaC"/>

        <ea:XmlDataLabel ElementName="P_214" runat="server" DataMember="C18.1Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_215" runat="server" DataMember="C18.2Podatek" XSDType="TKwotaC"/>	
		<ea:XmlDataLabel ElementName="P_216" runat="server" DataMember="C18.3Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_217" runat="server" DataMember="C18.4Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_218" runat="server" DataMember="C18.5Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_219" runat="server" DataMember="C18.6Podatek" XSDType="TKwotaC"/>	
		<ea:XmlDataLabel ElementName="P_220" runat="server" DataMember="C18.7Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_221" runat="server" DataMember="C18.8Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_222" runat="server" DataMember="C18.9Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_223" runat="server" DataMember="C18.10Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_224" runat="server" DataMember="C18.11Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_225" runat="server" DataMember="C18.12Podatek" XSDType="TKwotaC"/>

        <ea:XmlDataLabel ElementName="P_226" runat="server" DataMember="C19.1Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_227" runat="server" DataMember="C19.2Podatek" XSDType="TKwotaC"/>	
		<ea:XmlDataLabel ElementName="P_228" runat="server" DataMember="C19.3Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_229" runat="server" DataMember="C19.4Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_230" runat="server" DataMember="C19.5Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_231" runat="server" DataMember="C19.6Podatek" XSDType="TKwotaC"/>	
		<ea:XmlDataLabel ElementName="P_232" runat="server" DataMember="C19.7Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_233" runat="server" DataMember="C19.8Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_234" runat="server" DataMember="C19.9Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_235" runat="server" DataMember="C19.10Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_236" runat="server" DataMember="C19.11Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_237" runat="server" DataMember="C19.12Podatek" XSDType="TKwotaC"/>

        <ea:XmlDataLabel ElementName="P_238" runat="server" DataMember="C20.1Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_239" runat="server" DataMember="C20.2Podatek" XSDType="TKwotaC"/>	
		<ea:XmlDataLabel ElementName="P_240" runat="server" DataMember="C20.3Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_241" runat="server" DataMember="C20.4Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_242" runat="server" DataMember="C20.5Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_243" runat="server" DataMember="C20.6Podatek" XSDType="TKwotaC"/>	
		<ea:XmlDataLabel ElementName="P_244" runat="server" DataMember="C20.7Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_245" runat="server" DataMember="C20.8Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_246" runat="server" DataMember="C20.9Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_247" runat="server" DataMember="C20.10Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_248" runat="server" DataMember="C20.11Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_249" runat="server" DataMember="C20.12Podatek" XSDType="TKwotaC"/>

        <ea:XmlDataLabel ElementName="P_250" runat="server" DataMember="C21.1KwotyWypEmeryt" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_251" runat="server" DataMember="C21.2KwotyWypEmeryt" XSDType="TKwotaC"/>	
		<ea:XmlDataLabel ElementName="P_252" runat="server" DataMember="C21.3KwotyWypEmeryt" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_253" runat="server" DataMember="C21.4KwotyWypEmeryt" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_254" runat="server" DataMember="C21.5KwotyWypEmeryt" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_255" runat="server" DataMember="C21.6KwotyWypEmeryt" XSDType="TKwotaC"/>	
		<ea:XmlDataLabel ElementName="P_256" runat="server" DataMember="C21.7KwotyWypEmeryt" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_257" runat="server" DataMember="C21.8KwotyWypEmeryt" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_258" runat="server" DataMember="C21.9KwotyWypEmeryt" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_259" runat="server" DataMember="C21.10KwotyWypEmeryt" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_260" runat="server" DataMember="C21.11KwotyWypEmeryt" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_261" runat="server" DataMember="C21.12KwotyWypEmeryt" XSDType="TKwotaC"/>

        <ea:XmlDataLabel ElementName="P_262" runat="server" DataMember="C22.1KwotyWypZUS" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_263" runat="server" DataMember="C22.2KwotyWypZUS" XSDType="TKwotaC"/>	
		<ea:XmlDataLabel ElementName="P_264" runat="server" DataMember="C22.3KwotyWypZUS" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_265" runat="server" DataMember="C22.4KwotyWypZUS" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_266" runat="server" DataMember="C22.5KwotyWypZUS" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_267" runat="server" DataMember="C22.6KwotyWypZUS" XSDType="TKwotaC"/>	
		<ea:XmlDataLabel ElementName="P_268" runat="server" DataMember="C22.7KwotyWypZUS" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_269" runat="server" DataMember="C22.8KwotyWypZUS" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_270" runat="server" DataMember="C22.9KwotyWypZUS" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_271" runat="server" DataMember="C22.10KwotyWypZUS" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_272" runat="server" DataMember="C22.11KwotyWypZUS" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_273" runat="server" DataMember="C22.12KwotyWypZUS" XSDType="TKwotaC"/>

        <ea:XmlDataLabel ElementName="P_274" runat="server" DataMember="C23.1DochódOszcz" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_275" runat="server" DataMember="C23.2DochódOszcz" XSDType="TKwotaC"/>	
		<ea:XmlDataLabel ElementName="P_276" runat="server" DataMember="C23.3DochódOszcz" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_277" runat="server" DataMember="C23.4DochódOszcz" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_278" runat="server" DataMember="C23.5DochódOszcz" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_279" runat="server" DataMember="C23.6DochódOszcz" XSDType="TKwotaC"/>	
		<ea:XmlDataLabel ElementName="P_280" runat="server" DataMember="C23.7DochódOszcz" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_281" runat="server" DataMember="C23.8DochódOszcz" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_282" runat="server" DataMember="C23.9DochódOszcz" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_283" runat="server" DataMember="C23.10DochódOszcz" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_284" runat="server" DataMember="C23.11DochódOszcz" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_285" runat="server" DataMember="C23.12DochódOszcz" XSDType="TKwotaC"/>

        <ea:XmlDataLabel ElementName="P_286" runat="server" DataMember="C24.1DochódOszczPRac" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_287" runat="server" DataMember="C24.2DochódOszczPRac" XSDType="TKwotaC"/>	
		<ea:XmlDataLabel ElementName="P_288" runat="server" DataMember="C24.3DochódOszczPRac" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_289" runat="server" DataMember="C24.4DochódOszczPRac" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_290" runat="server" DataMember="C24.5DochódOszczPRac" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_291" runat="server" DataMember="C24.6DochódOszczPRac" XSDType="TKwotaC"/>	
		<ea:XmlDataLabel ElementName="P_292" runat="server" DataMember="C24.7DochódOszczPRac" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_293" runat="server" DataMember="C24.8DochódOszczPRac" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_294" runat="server" DataMember="C24.9DochódOszczPRac" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_295" runat="server" DataMember="C24.10DochódOszczPRac" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_296" runat="server" DataMember="C24.11DochódOszczPRac" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_297" runat="server" DataMember="C24.12DochódOszczPRac" XSDType="TKwotaC"/>

		<ea:XmlDataLabel ElementName="P_298" runat="server" DataMember="C25.1DochódPPK" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_299" runat="server" DataMember="C25.2DochódPPK" XSDType="TKwotaC"/>	
		<ea:XmlDataLabel ElementName="P_300" runat="server" DataMember="C25.3DochódPPK" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_301" runat="server" DataMember="C25.4DochódPPK" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_302" runat="server" DataMember="C25.5DochódPPK" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_303" runat="server" DataMember="C25.6DochódPPK" XSDType="TKwotaC"/>	
		<ea:XmlDataLabel ElementName="P_304" runat="server" DataMember="C25.7DochódPPK" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_305" runat="server" DataMember="C25.8DochódPPK" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_306" runat="server" DataMember="C25.9DochódPPK" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_307" runat="server" DataMember="C25.10DochódPPK" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_308" runat="server" DataMember="C25.11DochódPPK" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_309" runat="server" DataMember="C25.12DochódPPK" XSDType="TKwotaC"/>

		<ea:XmlDataLabel ElementName="P_310" runat="server" DataMember="C26.1DochódPPK" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_311" runat="server" DataMember="C26.2DochódPPK" XSDType="TKwotaC"/>	
		<ea:XmlDataLabel ElementName="P_312" runat="server" DataMember="C26.3DochódPPK" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_313" runat="server" DataMember="C26.4DochódPPK" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_314" runat="server" DataMember="C26.5DochódPPK" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_315" runat="server" DataMember="C26.6DochódPPK" XSDType="TKwotaC"/>	
		<ea:XmlDataLabel ElementName="P_316" runat="server" DataMember="C26.7DochódPPK" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_317" runat="server" DataMember="C26.8DochódPPK" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_318" runat="server" DataMember="C26.9DochódPPK" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_319" runat="server" DataMember="C26.10DochódPPK" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_320" runat="server" DataMember="C26.11DochódPPK" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_321" runat="server" DataMember="C26.12DochódPPK" XSDType="TKwotaC"/>

		<ea:XmlDataLabel ElementName="P_322" runat="server" DataMember="C27.1DochódPPK" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_323" runat="server" DataMember="C27.2DochódPPK" XSDType="TKwotaC"/>	
		<ea:XmlDataLabel ElementName="P_324" runat="server" DataMember="C27.3DochódPPK" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_325" runat="server" DataMember="C27.4DochódPPK" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_326" runat="server" DataMember="C27.5DochódPPK" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_327" runat="server" DataMember="C27.6DochódPPK" XSDType="TKwotaC"/>	
		<ea:XmlDataLabel ElementName="P_328" runat="server" DataMember="C27.7DochódPPK" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_329" runat="server" DataMember="C27.8DochódPPK" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_330" runat="server" DataMember="C27.9DochódPPK" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_331" runat="server" DataMember="C27.10DochódPPK" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_332" runat="server" DataMember="C27.11DochódPPK" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_333" runat="server" DataMember="C27.12DochódPPK" XSDType="TKwotaC"/>

		<ea:XmlDataLabel ElementName="P_334" runat="server" DataMember="C28.1DochódPPK" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_335" runat="server" DataMember="C28.2DochódPPK" XSDType="TKwotaC"/>	
		<ea:XmlDataLabel ElementName="P_336" runat="server" DataMember="C28.3DochódPPK" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_337" runat="server" DataMember="C28.4DochódPPK" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_338" runat="server" DataMember="C28.5DochódPPK" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_339" runat="server" DataMember="C28.6DochódPPK" XSDType="TKwotaC"/>	
		<ea:XmlDataLabel ElementName="P_340" runat="server" DataMember="C28.7DochódPPK" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_341" runat="server" DataMember="C28.8DochódPPK" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_342" runat="server" DataMember="C28.9DochódPPK" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_343" runat="server" DataMember="C28.10DochódPPK" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_344" runat="server" DataMember="C28.11DochódPPK" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_345" runat="server" DataMember="C28.12DochódPPK" XSDType="TKwotaC"/>

		<ea:XmlDataLabel ElementName="P_346" runat="server" DataMember="C29.1DochódPPK" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_347" runat="server" DataMember="C29.2DochódPPK" XSDType="TKwotaC"/>	
		<ea:XmlDataLabel ElementName="P_348" runat="server" DataMember="C29.3DochódPPK" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_349" runat="server" DataMember="C29.4DochódPPK" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_350" runat="server" DataMember="C29.5DochódPPK" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_351" runat="server" DataMember="C29.6DochódPPK" XSDType="TKwotaC"/>	
		<ea:XmlDataLabel ElementName="P_352" runat="server" DataMember="C29.7DochódPPK" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_353" runat="server" DataMember="C29.8DochódPPK" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_354" runat="server" DataMember="C29.9DochódPPK" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_355" runat="server" DataMember="C29.10DochódPPK" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_356" runat="server" DataMember="C29.11DochódPPK" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_357" runat="server" DataMember="C29.12DochódPPK" XSDType="TKwotaC"/>

		<ea:XmlDataLabel ElementName="P_358" runat="server" DataMember="C30.1DochódPPK" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_359" runat="server" DataMember="C30.2DochódPPK" XSDType="TKwotaC"/>	
		<ea:XmlDataLabel ElementName="P_360" runat="server" DataMember="C30.3DochódPPK" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_361" runat="server" DataMember="C30.4DochódPPK" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_362" runat="server" DataMember="C30.5DochódPPK" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_363" runat="server" DataMember="C30.6DochódPPK" XSDType="TKwotaC"/>	
		<ea:XmlDataLabel ElementName="P_364" runat="server" DataMember="C30.7DochódPPK" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_365" runat="server" DataMember="C30.8DochódPPK" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_366" runat="server" DataMember="C30.9DochódPPK" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_367" runat="server" DataMember="C30.10DochódPPK" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_368" runat="server" DataMember="C30.11DochódPPK" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_369" runat="server" DataMember="C30.12DochódPPK" XSDType="TKwotaC"/>

        <ea:XmlDataLabel ElementName="P_370" runat="server" DataMember="C31.1KwotaWypGwarant" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_371" runat="server" DataMember="C31.2KwotaWypGwarant" XSDType="TKwotaC"/>	
		<ea:XmlDataLabel ElementName="P_372" runat="server" DataMember="C31.3KwotaWypGwarant" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_373" runat="server" DataMember="C31.4KwotaWypGwarant" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_374" runat="server" DataMember="C31.5KwotaWypGwarant" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_375" runat="server" DataMember="C31.6KwotaWypGwarant" XSDType="TKwotaC"/>	
		<ea:XmlDataLabel ElementName="P_376" runat="server" DataMember="C31.7KwotaWypGwarant" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_377" runat="server" DataMember="C31.8KwotaWypGwarant" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_378" runat="server" DataMember="C31.9KwotaWypGwarant" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_379" runat="server" DataMember="C31.10KwotaWypGwarant" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_380" runat="server" DataMember="C31.11KwotaWypGwarant" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_381" runat="server" DataMember="C31.12KwotaWypGwarant" XSDType="TKwotaC"/>

        <ea:XmlDataLabel ElementName="P_382" runat="server" DataMember="C32.1DochódMajSpółki" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_383" runat="server" DataMember="C32.2DochódMajSpółki" XSDType="TKwotaC"/>	
		<ea:XmlDataLabel ElementName="P_384" runat="server" DataMember="C32.3DochódMajSpółki" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_385" runat="server" DataMember="C32.4DochódMajSpółki" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_386" runat="server" DataMember="C32.5DochódMajSpółki" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_387" runat="server" DataMember="C32.6DochódMajSpółki" XSDType="TKwotaC"/>	
		<ea:XmlDataLabel ElementName="P_388" runat="server" DataMember="C32.7DochódMajSpółki" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_389" runat="server" DataMember="C32.8DochódMajSpółki" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_390" runat="server" DataMember="C32.9DochódMajSpółki" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_391" runat="server" DataMember="C32.10DochódMajSpółki" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_392" runat="server" DataMember="C32.11DochódMajSpółki" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_393" runat="server" DataMember="C32.12DochódMajSpółki" XSDType="TKwotaC"/>

        <ea:XmlDataLabel ElementName="P_394" runat="server" DataMember="C33.1Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_395" runat="server" DataMember="C33.2Podatek" XSDType="TKwotaC"/>	
		<ea:XmlDataLabel ElementName="P_396" runat="server" DataMember="C33.3Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_397" runat="server" DataMember="C33.4Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_398" runat="server" DataMember="C33.5Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_399" runat="server" DataMember="C33.6Podatek" XSDType="TKwotaC"/>	
		<ea:XmlDataLabel ElementName="P_400" runat="server" DataMember="C33.7Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_401" runat="server" DataMember="C33.8Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_402" runat="server" DataMember="C33.9Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_403" runat="server" DataMember="C33.10Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_404" runat="server" DataMember="C33.11Podatek" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_405" runat="server" DataMember="C33.12Podatek" XSDType="TKwotaC"/>

        <ea:XmlDataLabel ElementName="P_406" runat="server" DataMember="C34.1Podatek" XSDType="TKwota2"/>
		<ea:XmlDataLabel ElementName="P_407" runat="server" DataMember="C34.2Podatek" XSDType="TKwota2"/>	
		<ea:XmlDataLabel ElementName="P_408" runat="server" DataMember="C34.3Podatek" XSDType="TKwota2"/>
		<ea:XmlDataLabel ElementName="P_409" runat="server" DataMember="C34.4Podatek" XSDType="TKwota2"/>
		<ea:XmlDataLabel ElementName="P_410" runat="server" DataMember="C34.5Podatek" XSDType="TKwota2"/>
		<ea:XmlDataLabel ElementName="P_411" runat="server" DataMember="C34.6Podatek" XSDType="TKwota2"/>	
		<ea:XmlDataLabel ElementName="P_412" runat="server" DataMember="C34.7Podatek" XSDType="TKwota2"/>
		<ea:XmlDataLabel ElementName="P_413" runat="server" DataMember="C34.8Podatek" XSDType="TKwota2"/>
		<ea:XmlDataLabel ElementName="P_414" runat="server" DataMember="C34.9Podatek" XSDType="TKwota2"/>
		<ea:XmlDataLabel ElementName="P_415" runat="server" DataMember="C34.10Podatek" XSDType="TKwota2"/>
		<ea:XmlDataLabel ElementName="P_416" runat="server" DataMember="C34.11Podatek" XSDType="TKwota2"/>
		<ea:XmlDataLabel ElementName="P_417" runat="server" DataMember="C34.12Podatek" XSDType="TKwota2"/>

		<ea:XmlDataLabel ElementName="P_418" runat="server" DataMember="C35.1Wynagrodzenie" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_419" runat="server" DataMember="C35.2Wynagrodzenie" XSDType="TKwotaC"/>	
		<ea:XmlDataLabel ElementName="P_420" runat="server" DataMember="C35.3Wynagrodzenie" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_421" runat="server" DataMember="C35.4Wynagrodzenie" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_422" runat="server" DataMember="C35.5Wynagrodzenie" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_423" runat="server" DataMember="C35.6Wynagrodzenie" XSDType="TKwotaC"/>	
		<ea:XmlDataLabel ElementName="P_424" runat="server" DataMember="C35.7Wynagrodzenie" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_425" runat="server" DataMember="C35.8Wynagrodzenie" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_426" runat="server" DataMember="C35.9Wynagrodzenie" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_427" runat="server" DataMember="C35.10Wynagrodzenie" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_428" runat="server" DataMember="C35.11Wynagrodzenie" XSDType="TKwotaC"/>
		<ea:XmlDataLabel ElementName="P_429" runat="server" DataMember="C35.12Wynagrodzenie" XSDType="TKwotaC"/>

		<ea:XmlDataLabel ElementName="P_430" runat="server" DataMember="C36.1DoWpłaty" XSDType="TKwota2"/>
		<ea:XmlDataLabel ElementName="P_431" runat="server" DataMember="C36.2DoWpłaty" XSDType="TKwota2"/>	
		<ea:XmlDataLabel ElementName="P_432" runat="server" DataMember="C36.3DoWpłaty" XSDType="TKwota2"/>
		<ea:XmlDataLabel ElementName="P_433" runat="server" DataMember="C36.4DoWpłaty" XSDType="TKwota2"/>
		<ea:XmlDataLabel ElementName="P_434" runat="server" DataMember="C36.5DoWpłaty" XSDType="TKwota2"/>
		<ea:XmlDataLabel ElementName="P_435" runat="server" DataMember="C36.6DoWpłaty" XSDType="TKwota2"/>	
		<ea:XmlDataLabel ElementName="P_436" runat="server" DataMember="C36.7DoWpłaty" XSDType="TKwota2"/>
		<ea:XmlDataLabel ElementName="P_437" runat="server" DataMember="C36.8DoWpłaty" XSDType="TKwota2"/>
		<ea:XmlDataLabel ElementName="P_438" runat="server" DataMember="C36.9DoWpłaty" XSDType="TKwota2"/>
		<ea:XmlDataLabel ElementName="P_439" runat="server" DataMember="C36.10DoWpłaty" XSDType="TKwota2"/>
		<ea:XmlDataLabel ElementName="P_440" runat="server" DataMember="C36.11DoWpłaty" XSDType="TKwota2"/>
		<ea:XmlDataLabel ElementName="P_441" runat="server" DataMember="C36.12DoWpłaty" XSDType="TKwota2"/>

		<ea:XmlDataLabel ElementName="P_442" runat="server" DataMember="D.I" HideEmptyOrZero="true"><ValuesMap><ea:ValuesPair Key="False" Value="0" /><ea:ValuesPair Key="True" Value="1"/></ValuesMap></ea:XmlDataLabel>
		<ea:XmlDataLabel ElementName="P_443" runat="server" DataMember="D.II" HideEmptyOrZero="true"><ValuesMap><ea:ValuesPair Key="False" Value="0" /><ea:ValuesPair Key="True" Value="1"/></ValuesMap></ea:XmlDataLabel>
		<ea:XmlDataLabel ElementName="P_444" runat="server" DataMember="D.III" HideEmptyOrZero="true"><ValuesMap><ea:ValuesPair Key="False" Value="0" /><ea:ValuesPair Key="True" Value="1"/></ValuesMap></ea:XmlDataLabel>
		<ea:XmlDataLabel ElementName="P_445" runat="server" DataMember="D.IV" HideEmptyOrZero="true"><ValuesMap><ea:ValuesPair Key="False" Value="0" /><ea:ValuesPair Key="True" Value="1"/></ValuesMap></ea:XmlDataLabel>
		<ea:XmlDataLabel ElementName="P_446" runat="server" DataMember="D.V" HideEmptyOrZero="true"><ValuesMap><ea:ValuesPair Key="False" Value="0" /><ea:ValuesPair Key="True" Value="1"/></ValuesMap></ea:XmlDataLabel>
		<ea:XmlDataLabel ElementName="P_447" runat="server" DataMember="D.VI" HideEmptyOrZero="true"><ValuesMap><ea:ValuesPair Key="False" Value="0" /><ea:ValuesPair Key="True" Value="1"/></ValuesMap></ea:XmlDataLabel>
		<ea:XmlDataLabel ElementName="P_448" runat="server" DataMember="D.VII" HideEmptyOrZero="true"><ValuesMap><ea:ValuesPair Key="False" Value="0" /><ea:ValuesPair Key="True" Value="1"/></ValuesMap></ea:XmlDataLabel>
		<ea:XmlDataLabel ElementName="P_449" runat="server" DataMember="D.VIII" HideEmptyOrZero="true"><ValuesMap><ea:ValuesPair Key="False" Value="0" /><ea:ValuesPair Key="True" Value="1"/></ValuesMap></ea:XmlDataLabel>
		<ea:XmlDataLabel ElementName="P_450" runat="server" DataMember="D.IX" HideEmptyOrZero="true"><ValuesMap><ea:ValuesPair Key="False" Value="0" /><ea:ValuesPair Key="True" Value="1"/></ValuesMap></ea:XmlDataLabel>
		<ea:XmlDataLabel ElementName="P_451" runat="server" DataMember="D.X" HideEmptyOrZero="true"><ValuesMap><ea:ValuesPair Key="False" Value="0" /><ea:ValuesPair Key="True" Value="1"/></ValuesMap></ea:XmlDataLabel>
		<ea:XmlDataLabel ElementName="P_452" runat="server" DataMember="D.XI" HideEmptyOrZero="true"><ValuesMap><ea:ValuesPair Key="False" Value="0" /><ea:ValuesPair Key="True" Value="1"/></ValuesMap></ea:XmlDataLabel>
		<ea:XmlDataLabel ElementName="P_453" runat="server" DataMember="D.XII" HideEmptyOrZero="true"><ValuesMap><ea:ValuesPair Key="False" Value="0" /><ea:ValuesPair Key="True" Value="1"/></ValuesMap></ea:XmlDataLabel>
	</PozycjeSzczegolowe>
    <Pouczenia>1</Pouczenia>
    <ea:Section ID="ORD_ZU" runat="server">
	<Zalaczniki>
    <zzu:Zalacznik_ORD-ZU>
        <zzu:Naglowek>
            <zzu:KodFormularza kodSystemowy="ORD-ZU (3)" wersjaSchemy="8-0E">ORD-ZU</zzu:KodFormularza>
            <zzu:WariantFormularza>3</zzu:WariantFormularza>
        </zzu:Naglowek>
        <zzu:PozycjeSzczegolowe>
            <ea:XmlDataLabel ElementName="zzu:P_13" runat="server" DataMember="TreśćUzasadnienia" XSDType="TTekstowy"/>
        </zzu:PozycjeSzczegolowe>
    </zzu:Zalacznik_ORD-ZU>
	</Zalaczniki>
    </ea:Section>	
</Deklaracja>
