<%@ Page Language="C#" AutoEventWireup="false" CodePage="1200" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Deklaracje" %>
<%@ Import Namespace="Soneta.Deklaracje.PIT" %>
<%@ Import Namespace="System.Diagnostics" %>
<%@ Import Namespace="System.Collections.Generic" %>
<script runat="server">

    void OnContextLoad(Object sender, EventArgs args) {
        var dek = (PIT8C_13)dc[typeof(PIT8C_13)];

        bool osobaFizyczna = (bool)dek.Bloki["B1"]["OsobaFiz"];        

        if (osobaFizyczna) {
            OsobaNieFizyczna.Visible = false;
            string[] nazwa = Soneta.Deklaracje.PIT.PIT.DaneFirmy((string)dek.Bloki["B1"]["Nazwa"], 3);
			Debug.Assert(nazwa.Length == 3);

            Nazwisko.EditValue = nazwa[0].Trim();
            ImiePierwsze.EditValue = nazwa[1].Trim();
            DataUrodzenia.EditValue = nazwa[2].Trim();
        }
        else 
            OsobaFizyczna.Visible = false;            

        string kodKraju = ((string)dek.Bloki["X"]["KodKraju"]).ToUpper();
        if (kodKraju == "" || kodKraju=="PL")
            AdresZagr.Visible = false;
        else
            AdresPol.Visible = false;

        if (dek.JestPESEL)
            P10_NIP.Visible = false;
        else
            P10_PESEL.Visible = false;

        ORD_ZU.Visible = dek.TreśćUzasadnienia != "";       

        InitBrakDanych(dek);        
    }

    void InitBrakDanych(Deklaracja dek) {
        string brakDanych = dek.Module.Config.PIT.Ogólne.UzupełnienieAdresuNaEDeklaracji;
        if (brakDanych != "") {
            AddMap(pit_wojew, "", brakDanych, 36);
            AddMap(pit_powiat, "", brakDanych, 36);
            AddMap(pit_gmina, "", brakDanych, 36);
            AddMap(pit_nrDomu, "", brakDanych, 9);
            AddMap(pit_miejsc, "", brakDanych, 56);
            AddMap(pit_kodPoczt, "", brakDanych, 8);
            AddMap(pit_kodPoczt, "0", brakDanych, 8);
            //AddMap(pit_poczta, "", brakDanych, 56);
            AddMap(pit_miejscZagr, "", brakDanych, 56);
        }
    }

    static void AddMap(XmlDataLabel label, string key, string value, int maxLen) {
        label.ValuesMap.Add(new ValuesPair(key, Soneta.Core.Tools.Left(value, maxLen)));
    }
        
    static void Msg(object value) {
    }

</script>
<ea:datacontext id="dc" runat="server" TypeName="Soneta.Deklaracje.PIT.PIT8C_13,Soneta.Deklaracje" OnContextLoad="OnContextLoad"></ea:datacontext>
<?xml version="1.0" encoding="UTF-8"?>
<Deklaracja 
    xsi:schemaLocation="http://crd.gov.pl/wzor/2025/10/10/13918/ http://crd.gov.pl/wzor/2025/10/10/13918/schemat.xsd" 
    xmlns="http://crd.gov.pl/wzor/2025/10/10/13918/" 
    xmlns:zzu="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2024/07/08/eD/ORDZU/"
    xmlns:etd="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2024/07/08/eD/DefinicjeTypy/"
    xmlns:kusex="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2021/12/23/eD/KodyUrzedowSkarbowychExWUS/"
    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
    <Naglowek>
        <KodFormularza kodSystemowy="PIT-8C (13)" kodPodatku="PIT" rodzajZobowiazania="Z" wersjaSchemy="1-0E">PIT-8C</KodFormularza>
        <WariantFormularza>13</WariantFormularza>		
        <CelZlozenia poz="P_6"><ea:XmlDataLabel ID="DataLabel1" runat="server" DataMember="A.Korekta"><ValuesMap><ea:ValuesPair Key="False" Value="1" /><ea:ValuesPair Key="True" Value="2"/></ValuesMap></ea:XmlDataLabel></CelZlozenia>
        <ea:XmlDataLabel ElementName="Rok" runat="server" DataMember="0.Rok" />
        <ea:XmlDataLabel ElementName="KodUrzedu" runat="server" DataMember="X.KodUrzeduSkarbowego" />
    </Naglowek>
    <Podmiot1 rola="Składający">
        <ea:Section ID="OsobaFizyczna" runat="server">
            <etd:OsobaFizyczna>
            <ea:XmlDataLabel ElementName="etd:NIP" runat="server" DataMember="0.Nip" XSDType="TNrNIP"/>
            <ea:XmlDataLabel ElementName="etd:ImiePierwsze" ID="ImiePierwsze" runat="server" XSDType="TImie"></ea:XmlDataLabel>
            <ea:XmlDataLabel ElementName="etd:Nazwisko" ID="Nazwisko" runat="server" XSDType="TNazwisko"></ea:XmlDataLabel>
            <ea:XmlDataLabel ElementName="etd:DataUrodzenia" ID="DataUrodzenia" runat="server" XSDType="TData"></ea:XmlDataLabel>
            </etd:OsobaFizyczna>
        </ea:Section>
        <ea:Section ID="OsobaNieFizyczna" runat="server"><etd:OsobaNiefizyczna>
            <ea:XmlDataLabel ElementName="etd:NIP" runat="server" DataMember="0.Nip" XSDType="TNrNIP"/>
            <ea:XmlDataLabel ElementName="etd:PelnaNazwa" ID="NazwaPelna" runat="server" DataMember="B1.Nazwa" XSDType="TZnakowy" />
        </etd:OsobaNiefizyczna></ea:Section>
    </Podmiot1>	
    <Podmiot2 rola="Podatnik">
        <OsobaFizyczna>
            <ea:XmlDataLabel ElementName="NIP" ID="P10_NIP" runat="server" DataMember="C1.NIP" XSDType="TNrNIP" />
            <ea:XmlDataLabel ElementName="PESEL" ID="P10_PESEL" runat="server" DataMember="C1.PESEL" XSDType="TNrPESEL" />
            <ea:XmlDataLabel ID="XmlDataLabel1" ElementName="ImiePierwsze" runat="server" DataMember="C1.Imię" XSDType="TImie"/>
            <ea:XmlDataLabel ID="XmlDataLabel2" ElementName="Nazwisko" runat="server" DataMember="C1.Nazwisko" XSDType="TNazwisko"/>
            <ea:XmlDataLabel ID="XmlDataLabel3" ElementName="DataUrodzenia" runat="server" DataMember="C1.DataUrodz" XSDType="TData"/>
        </OsobaFizyczna>
        <AdresZamieszkania rodzajAdresu="RAD">
            <ea:Section ID="AdresPol" runat="server">
            <AdresPol>
                <KodKraju>PL</KodKraju>
                <ea:XmlDataLabel ElementName="Wojewodztwo" ID="pit_wojew" runat="server" DataMember="C2.Wojew" XSDType="TJednAdmin"/>
                <ea:XmlDataLabel ElementName="Powiat" ID="pit_powiat" runat="server" DataMember="C2.Powiat" XSDType="TJednAdmin"/>
                <ea:XmlDataLabel ElementName="Gmina" ID="pit_gmina" runat="server" DataMember="C2.Gmina" XSDType="TJednAdmin"/>
                <ea:XmlDataLabel ElementName="Ulica" runat="server" DataMember="C2.Ulica" XSDType="TUlica" HideEmptyOrZero="true"/>
                <ea:XmlDataLabel ElementName="NrDomu" ID="pit_nrDomu" runat="server" DataMember="C2.NrDomu" XSDType="TNrBudynku"/>
                <ea:XmlDataLabel ElementName="NrLokalu" runat="server" DataMember="C2.NrLokalu" XSDType="TNrLokalu" HideEmptyOrZero="true"/>
                <ea:XmlDataLabel ElementName="Miejscowosc" ID="pit_miejsc" runat="server" DataMember="C2.Miejsc" XSDType="TMiejscowosc"/>
                <ea:XmlDataLabel ElementName="KodPocztowy" ID="pit_kodPoczt" runat="server" DataMember="C2.KodPoczt" XSDType="TKodPocztowy"/>
            </AdresPol>
            </ea:Section>
            <ea:Section ID="AdresZagr" runat="server">
            <etd:AdresZagr>
                <ea:XmlDataLabel ElementName="etd:KodKraju" runat="server" DataMember="X.KodKraju" XSDType="TTekstowy"/>
                <ea:XmlDataLabel ElementName="etd:KodPocztowy" runat="server" DataMember="C2.KodPoczt" XSDType="TKodPocztowy" HideEmptyOrZero="true"/>
                <ea:XmlDataLabel ElementName="etd:Miejscowosc" ID="pit_miejscZagr" runat="server" DataMember="C2.Miejsc" XSDType="TMiejscowosc"/>
                <ea:XmlDataLabel ElementName="etd:Ulica" runat="server" DataMember="C2.Ulica" XSDType="TUlica" HideEmptyOrZero="true"/>
                <ea:XmlDataLabel ElementName="etd:NrDomu" runat="server" DataMember="C2.NrDomu" XSDType="TNrBudynku" HideEmptyOrZero="true"/>
                <ea:XmlDataLabel ElementName="etd:NrLokalu" runat="server" DataMember="C2.NrLokalu" XSDType="TNrLokalu" HideEmptyOrZero="true"/>
            </etd:AdresZagr>
            </ea:Section>
        </AdresZamieszkania>
    </Podmiot2>
    <PozycjeSzczegolowe>
        <ea:XmlDataLabel ElementName="P_23" runat="server" DataMember="D.1Przychód" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="P_24" runat="server" DataMember="D.1Koszty" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="P_25" runat="server" DataMember="D.2Przychód" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="P_26" runat="server" DataMember="D.2Koszty" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="P_27" runat="server" DataMember="D.3Przychód" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="P_28" runat="server" DataMember="D.3Koszty" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="P_29" runat="server" DataMember="D.4Przychód" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="P_30" runat="server" DataMember="D.4Koszty" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="P_31" runat="server" DataMember="D.5Przychód" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="P_32" runat="server" DataMember="D.5Koszty" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="P_33" runat="server" DataMember="D.6Przychód" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="P_34" runat="server" DataMember="D.6Koszty" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="P_35" runat="server" DataMember="D.Przychód" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="P_36" runat="server" DataMember="D.Koszty" XSDType="TKwota2"/>

        <ea:XmlDataLabel ElementName="P_37" runat="server" DataMember="E.Przychód" XSDType="TKwota2"/>
    </PozycjeSzczegolowe>
    <Pouczenie>1</Pouczenie>
    <ea:Section ID="ORD_ZU" runat="server">
    <Zalaczniki>
    <zzu:Zalacznik_ORD-ZU>
        <zzu:Naglowek>
            <zzu:KodFormularza kodSystemowy="ORD-ZU (3)" wersjaSchemy="11-0E">ORD-ZU</zzu:KodFormularza>
            <zzu:WariantFormularza>3</zzu:WariantFormularza>
        </zzu:Naglowek>
        <zzu:PozycjeSzczegolowe>
            <ea:XmlDataLabel ElementName="zzu:P_13" runat="server" DataMember="TreśćUzasadnienia" XSDType="TTekstowy"/>
        </zzu:PozycjeSzczegolowe>
    </zzu:Zalacznik_ORD-ZU>
    </Zalaczniki>
    </ea:Section>
</Deklaracja>
