﻿<%@ Page Language="C#" AutoEventWireup="false" CodePage="1200" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Deklaracje" %>
<%@ Import Namespace="Soneta.Deklaracje.PIT" %>
<%@ Import Namespace="System.Collections.Generic" %>
<script runat="server">
    Soneta.Deklaracje.PIT.PITR_15 dek;

    void OnContextLoad(Object sender, EventArgs args) {
        dek = (PITR_15)dc[typeof(PITR_15)];

        string[] nazwa = ((string)dek.Bloki["B1"]["Nazwa"]).Split(',');
        if (nazwa.Length > 0)
            PelnaNazwa.EditValue = nazwa[0].Trim();
        if (nazwa.Length > 1)
            REGON.EditValue = nazwa[1].Trim();

        string kodKraju = ((string)dek.Bloki["X"]["KodKraju"]).ToUpper();
        if (kodKraju == "" || kodKraju == "PL")
            AdresZagr.Visible = false;
        else
            AdresPol.Visible = false;

        if (dek.JestPESEL)
            P18_NIP.Visible = false;
        else
            P18_PESEL.Visible = false;
                
        ORD_ZU.Visible = dek.TreśćUzasadnienia != "";

        InitBrakDanych();        
    }

    void InitBrakDanych() {
        string brakDanych = dek.Module.Config.PIT.Ogólne.UzupełnienieAdresuNaEDeklaracji;
        if (brakDanych != "") {
            AddMap(pit_wojew, "", brakDanych, 36);
            AddMap(pit_powiat, "", brakDanych, 36);
            AddMap(pit_gmina, "", brakDanych, 36);
            AddMap(pit_nrDomu, "", brakDanych, 9);
            AddMap(pit_miejsc, "", brakDanych, 56);
            AddMap(pit_kodPoczt, "", brakDanych, 8);
            AddMap(pit_kodPoczt, "0", brakDanych, 8);
            AddMap(pit_poczta, "", brakDanych, 56);
            AddMap(pit_miejscZagr, "", brakDanych, 56);
        }
    }
    
    static void AddMap(XmlDataLabel label, string key, string value, int maxLen) {
        label.ValuesMap.Add(new ValuesPair(key, Soneta.Core.Tools.Left(value, maxLen)));
    }
            
    static void Msg(object value) {
    }

</script>
<ea:datacontext id="dc" runat="server" TypeName="Soneta.Deklaracje.PIT.PITR_15,Soneta.Deklaracje" OnContextLoad="OnContextLoad"></ea:datacontext>
<?xml version="1.0" encoding="UTF-8"?>
<Deklaracja
    xmlns:xsd="http://www.w3.org/2001/XMLSchema" 
    xmlns="http://crd.gov.pl/wzor/2011/12/12/724/" 
    xmlns:etd="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2011/06/21/eD/DefinicjeTypy/">
    <Naglowek>
        <KodFormularza kodSystemowy="PIT-R1 (15)" kodPodatku="PIT" rodzajZobowiazania="Z" wersjaSchemy="1-0E">PIT-R</KodFormularza>
        <WariantFormularza>15</WariantFormularza>		
        <CelZlozenia poz="P_6"><ea:XmlDataLabel ID="DataLabel1" runat="server" DataMember="A.Korekta"><ValuesMap><ea:ValuesPair Key="False" Value="1" /><ea:ValuesPair Key="True" Value="2"/></ValuesMap></ea:XmlDataLabel></CelZlozenia>
        <ea:XmlDataLabel ElementName="Rok" runat="server" DataMember="0.Rok" XSDType="TCalkowity" />
        <ea:XmlDataLabel ElementName="KodUrzedu" runat="server" DataMember="X.KodUrzeduSkarbowego" />
    </Naglowek>
    <Podmiot1 rola="Płatnik">
        <OsobaNiefizyczna>
            <ea:XmlDataLabel ID="XmlDataLabel1" ElementName="etd:NIP" runat="server" DataMember="0.Nip" XSDType="TNrNIP" />
            <ea:XmlDataLabel ElementName="etd:PelnaNazwa" ID="PelnaNazwa" runat="server" XSDType="TZnakowy"/>
            <ea:XmlDataLabel ElementName="etd:REGON" ID="REGON" runat="server" XSDType="TNrREGON"/>
        </OsobaNiefizyczna>
        <AdresSiedziby rodzajAdresu="RAD">
            <etd:KodKraju>PL</etd:KodKraju>
            <ea:XmlDataLabel ElementName="etd:Wojewodztwo" runat="server" DataMember="B2.Wojew" XSDType="TJednAdmin" />
            <ea:XmlDataLabel ElementName="etd:Powiat" runat="server" DataMember="B2.Powiat" XSDType="TJednAdmin"/>
            <ea:XmlDataLabel ElementName="etd:Gmina" runat="server" DataMember="B2.Gmina" XSDType="TJednAdmin"/>
            <ea:XmlDataLabel ElementName="etd:Ulica" runat="server" HideEmptyOrZero="true" DataMember="B2.Ulica" XSDType="TUlica"/>
            <ea:XmlDataLabel ElementName="etd:NrDomu" runat="server" DataMember="B2.NrDomu" XSDType="TNrBudynku"/>
            <ea:XmlDataLabel ElementName="etd:NrLokalu" runat="server" HideEmptyOrZero="true" DataMember="B2.NrLokalu" XSDType="TNrLokalu"/>
            <ea:XmlDataLabel ElementName="etd:Miejscowosc" runat="server" DataMember="B2.Miejsc" XSDType="TMiejscowosc"/>
            <ea:XmlDataLabel ElementName="etd:KodPocztowy" runat="server" DataMember="B2.KodPoczt" XSDType="TKodPocztowy"/>
            <ea:XmlDataLabel ElementName="etd:Poczta" runat="server" DataMember="B2.Poczta" XSDType="TMiejscowosc"/>
        </AdresSiedziby>
    </Podmiot1>	
    <Podmiot2 rola="Podatnik" poz="P_18A">
        <etd:OsobaFizyczna>
            <ea:XmlDataLabel ElementName="etd:NIP" ID="P18_NIP" runat="server" DataMember="C1.NIP" XSDType="TNrNIP"/>
            <ea:XmlDataLabel ElementName="etd:PESEL" ID="P18_PESEL" runat="server" DataMember="C1.PESEL" XSDType="TNrPESEL"/>
            <ea:XmlDataLabel ElementName="etd:ImiePierwsze" runat="server" DataMember="C1.Imię" XSDType="TImie"/>
            <ea:XmlDataLabel ElementName="etd:Nazwisko" runat="server" DataMember="C1.Nazwisko" XSDType="TNazwisko"/>
            <ea:XmlDataLabel ElementName="etd:DataUrodzenia" runat="server" DataMember="C1.DataUrodz" XSDType="TData"/>
        </etd:OsobaFizyczna>
        <etd:AdresZamieszkania rodzajAdresu="RAD">
            <ea:Section ID="AdresPol" runat="server">
            <etd:AdresPol>
                <etd:KodKraju>PL</etd:KodKraju>
                <ea:XmlDataLabel ElementName="etd:Wojewodztwo" ID="pit_wojew" runat="server" DataMember="C2.Wojew" XSDType="TJednAdmin"/>
                <ea:XmlDataLabel ElementName="etd:Powiat" ID="pit_powiat" runat="server" DataMember="C2.Powiat" XSDType="TJednAdmin"/>
                <ea:XmlDataLabel ElementName="etd:Gmina" ID="pit_gmina" runat="server" DataMember="C2.Gmina" XSDType="TJednAdmin"/>
                <ea:XmlDataLabel ElementName="etd:Ulica" runat="server" DataMember="C2.Ulica" XSDType="TUlica" HideEmptyOrZero="true"/>
                <ea:XmlDataLabel ElementName="etd:NrDomu" ID="pit_nrDomu" runat="server" DataMember="C2.NrDomu" XSDType="TNrBudynku"/>
                <ea:XmlDataLabel ElementName="etd:NrLokalu" runat="server" DataMember="C2.NrLokalu" XSDType="TNrLokalu" HideEmptyOrZero="true"/>
                <ea:XmlDataLabel ElementName="etd:Miejscowosc" ID="pit_miejsc" runat="server" DataMember="C2.Miejsc" XSDType="TMiejscowosc"/>
                <ea:XmlDataLabel ElementName="etd:KodPocztowy" ID="pit_kodPoczt" runat="server" DataMember="C2.KodPoczt" XSDType="TKodPocztowy"/>
                <ea:XmlDataLabel ElementName="etd:Poczta" ID="pit_poczta" runat="server" DataMember="C2.Poczta" XSDType="TMiejscowosc"/>
            </etd:AdresPol>
            </ea:Section>
            <ea:Section ID="AdresZagr" runat="server">
            <etd:AdresZagr>
                <ea:XmlDataLabel ElementName="etd:KodKraju" runat="server" DataMember="X.KodKraju" XSDType="TTekstowy"/>
                <ea:XmlDataLabel ElementName="etd:KodPocztowy" runat="server" DataMember="C2.KodPoczt" XSDType="TKodPocztowy" HideEmptyOrZero="true"/>
                <ea:XmlDataLabel ElementName="etd:Miejscowosc" ID="pit_miejscZagr" runat="server" DataMember="C2.Miejsc" XSDType="TMiejscowosc"/>
                <ea:XmlDataLabel ElementName="etd:Ulica" runat="server" DataMember="C2.Ulica" XSDType="TUlica" HideEmptyOrZero="true"/>
                <ea:XmlDataLabel ElementName="etd:NrDomu" runat="server" DataMember="C2.NrDomu" XSDType="TNrBudynku" HideEmptyOrZero="true"/>
                <ea:XmlDataLabel ElementName="etd:NrLokalu" runat="server" DataMember="C2.NrLokalu" XSDType="TNrLokalu" HideEmptyOrZero="true"/>
            </etd:AdresZagr>
            </ea:Section>
        </etd:AdresZamieszkania>
    </Podmiot2>
    <PozycjeSzczegolowe>
        <ea:XmlDataLabel ElementName="P_32" runat="server" DataMember="D.01_b" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="P_33" runat="server" DataMember="D.01_c" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="P_34" runat="server" DataMember="D.01_d" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="P_35" runat="server" DataMember="D.01_e" XSDType="TKwota2"/>		

        <ea:XmlDataLabel ElementName="P_36" runat="server" DataMember="D.02_b" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="P_37" runat="server" DataMember="D.02_c" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="P_38" runat="server" DataMember="D.02_d" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="P_39" runat="server" DataMember="D.02_e" XSDType="TKwota2"/>		

        <ea:XmlDataLabel ElementName="P_40" runat="server" DataMember="D.03_b" XSDType="TKwota2"/>		
        <ea:XmlDataLabel ElementName="P_41" runat="server" DataMember="D.03_c" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="P_42" runat="server" DataMember="D.03_d" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="P_43" runat="server" DataMember="D.03_e" XSDType="TKwota2"/>		

        <ea:XmlDataLabel ElementName="P_44" runat="server" DataMember="D.04_b" XSDType="TKwota2"/>		
        <ea:XmlDataLabel ElementName="P_45" runat="server" DataMember="D.04_c" XSDType="TKwota2"/>		
        <ea:XmlDataLabel ElementName="P_46" runat="server" DataMember="D.04_d" XSDType="TKwota2"/>		
        <ea:XmlDataLabel ElementName="P_47" runat="server" DataMember="D.04_e" XSDType="TKwota2"/>				

        <ea:XmlDataLabel ElementName="P_48" runat="server" DataMember="D.05_b" XSDType="TKwota2"/>		
        <ea:XmlDataLabel ElementName="P_49" runat="server" DataMember="D.05_c" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="P_50" runat="server" DataMember="D.05_d" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="P_51" runat="server" DataMember="D.05_e" XSDType="TKwota2"/>		

        <ea:XmlDataLabel ElementName="P_52" runat="server" DataMember="D.06_b" XSDType="TKwota2"/>		
        <ea:XmlDataLabel ElementName="P_53" runat="server" DataMember="D.06_c" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="P_54" runat="server" DataMember="D.06_d" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="P_55" runat="server" DataMember="D.06_e" XSDType="TKwota2"/>		

        <ea:XmlDataLabel ElementName="P_56" runat="server" DataMember="D.07_b" XSDType="TKwota2"/>		
        <ea:XmlDataLabel ElementName="P_57" runat="server" DataMember="D.07_c" XSDType="TKwota2"/>		
        <ea:XmlDataLabel ElementName="P_58" runat="server" DataMember="D.07_d" XSDType="TKwota2"/>		
        <ea:XmlDataLabel ElementName="P_59" runat="server" DataMember="D.07_e" XSDType="TKwota2"/>				

        <ea:XmlDataLabel ElementName="P_60" runat="server" DataMember="D.08_b" XSDType="TKwota2"/>		
        <ea:XmlDataLabel ElementName="P_61" runat="server" DataMember="D.08_c" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="P_62" runat="server" DataMember="D.08_d" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="P_63" runat="server" DataMember="D.08_e" XSDType="TKwota2"/>		

        <ea:XmlDataLabel ElementName="P_64" runat="server" DataMember="D.09_b" XSDType="TKwota2"/>		
        <ea:XmlDataLabel ElementName="P_65" runat="server" DataMember="D.09_c" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="P_66" runat="server" DataMember="D.09_d" XSDType="TKwota2"/>		
        <ea:XmlDataLabel ElementName="P_67" runat="server" DataMember="D.09_e" XSDType="TKwota2"/>		

        <ea:XmlDataLabel ElementName="P_68" runat="server" DataMember="D.10_b" XSDType="TKwota2"/>		
        <ea:XmlDataLabel ElementName="P_69" runat="server" DataMember="D.10_c" XSDType="TKwota2"/>		
        <ea:XmlDataLabel ElementName="P_70" runat="server" DataMember="D.10_d" XSDType="TKwota2"/>		
        <ea:XmlDataLabel ElementName="P_71" runat="server" DataMember="D.10_e" XSDType="TKwota2"/>				

        <ea:XmlDataLabel ElementName="P_72" runat="server" DataMember="D.11_b" XSDType="TKwota2"/>		
        <ea:XmlDataLabel ElementName="P_73" runat="server" DataMember="D.11_c" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="P_74" runat="server" DataMember="D.11_d" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="P_75" runat="server" DataMember="D.11_e" XSDType="TKwota2"/>		

        <ea:XmlDataLabel ElementName="P_76" runat="server" DataMember="D.12_b" XSDType="TKwota2"/>		
        <ea:XmlDataLabel ElementName="P_77" runat="server" DataMember="D.12_c" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="P_78" runat="server" DataMember="D.12_d" XSDType="TKwota2"/>		
        <ea:XmlDataLabel ElementName="P_79" runat="server" DataMember="D.12_e" XSDType="TKwota2"/>		

        <ea:XmlDataLabel ElementName="P_80" runat="server" DataMember="D.razem_e" XSDType="TKwota2"/>
    </PozycjeSzczegolowe>
    <Oswiadczenie>Oświadczam, że są mi znane przepisy Kodeksu karnego skarbowego o odpowiedzialności za uchybienie obowiązkom płatnika.</Oswiadczenie>
    <Zalaczniki>
    <ea:Section ID="ORD_ZU" runat="server">
    <zzu:Zalacznik_ORD-ZU 
        xsi:schemaLocation="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2011/06/21/eD/DefinicjeTypy/ http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2011/06/21/eD/DefinicjeTypy/StrukturyDanych_v3-0E.xsd" 
        xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" 
        xmlns:etd="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2011/06/21/eD/DefinicjeTypy/"
        xmlns:zzu="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2011/10/07/eD/ORDZU/" >
        <zzu:Naglowek>
            <zzu:KodFormularza kodSystemowy="ORD-ZU (2)" wersjaSchemy="2-0E">ORD-ZU</zzu:KodFormularza>
            <zzu:WariantFormularza>2</zzu:WariantFormularza>
        </zzu:Naglowek>
        <zzu:PozycjeSzczegolowe>
            <ea:XmlDataLabel ElementName="zzu:P_13" runat="server" DataMember="TreśćUzasadnienia" XSDType="TTekstowy"/>
        </zzu:PozycjeSzczegolowe>
    </zzu:Zalacznik_ORD-ZU>
    </ea:Section>
    </Zalaczniki>
</Deklaracja>
