﻿<%@ Page Language="C#" AutoEventWireup="false" CodePage="1200" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Deklaracje" %>
<%@ Import Namespace="Soneta.Deklaracje.PIT" %>
<%@ Import Namespace="System.Collections.Generic" %>
<script runat="server">
    void OnContextLoad(Object sender, EventArgs args) {
        var dek = (PITRZ_22)dc[typeof(PITRZ_22)];

        string[] nazwa = ((string)dek.Bloki["B1"]["Nazwa"]).Split(',');
        if (nazwa.Length > 0)
            PelnaNazwa.EditValue = nazwa[0].Trim();
        //if (nazwa.Length > 1)
        //    REGON.EditValue = nazwa[1].Trim();

        var pity = new List<PITR>();
        foreach (Deklaracja pit in dek.Deklaracje)
            if (pit is PITR_22)
                pity.Add((PITR_22)pit);
        PIT_REP.DataSource = pity;
    }

    protected void PIT_BeforeRow(object sender, EventArgs e) {
        var dek = (PITR_22)PIT_REP.CurrentRow;
        if (dek.JestPESEL) {
            P18_NIP.Visible = false;
            P18_PESEL.Visible = true;
        }
        else {
            P18_NIP.Visible = true;
            P18_PESEL.Visible = false;
        }

        var kraj = ((string)dek.Bloki["C2"]["Kraj"]).ToUpper();
	    if (kraj == "" || kraj == "POLSKA")
		    AdresZagrPl.Visible = false;
	    else
		    AdresPolPl.Visible = false;
    }

</script>
<ea:datacontext id="dc" runat="server" TypeName="Soneta.Deklaracje.PIT.PITRZ_22,Soneta.Deklaracje" OnContextLoad="OnContextLoad"></ea:datacontext>
<?xml version="1.0" encoding="UTF-8"?>
<Deklaracja
    xsi:schemaLocation="http://crd.gov.pl/wzor/2024/10/15/13538/ http://crd.gov.pl/wzor/2024/10/15/13538/schemat.xsd" 
    xmlns="http://crd.gov.pl/wzor/2024/10/15/13538/" 
    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" 
    xmlns:etd="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2024/07/08/eD/DefinicjeTypy/"
    xmlns:kusex="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2021/12/23/eD/KodyUrzedowSkarbowychExWUS/">
    <Naglowek>
        <KodFormularza kodSystemowy="PIT-R1 (22)" kodPodatku="PIT" rodzajZobowiazania="Z" wersjaSchemy="2-0E">PIT-RZ</KodFormularza>
        <WariantFormularza>22</WariantFormularza>		
        <CelZlozenia poz="P_6"><ea:XmlDataLabel ID="DataLabel1" runat="server" DataMember="A.Korekta"><ValuesMap><ea:ValuesPair Key="False" Value="1" /><ea:ValuesPair Key="True" Value="2"/></ValuesMap></ea:XmlDataLabel></CelZlozenia>
        <ea:XmlDataLabel ElementName="Rok" runat="server" DataMember="0.Rok" XSDType="TCalkowity" />
        <KodUrzedu>0000</KodUrzedu>		
    </Naglowek>
    <Podmiot1 rola="Płatnik">
        <OsobaNiefizyczna>
            <ea:XmlDataLabel ID="XmlDataLabel1" ElementName="etd:NIP" runat="server" DataMember="0.Nip" XSDType="TNrNIP" />
            <ea:XmlDataLabel ElementName="etd:PelnaNazwa" ID="PelnaNazwa" runat="server" XSDType="TZnakowy"/>
        </OsobaNiefizyczna>
    </Podmiot1>	
    <ea:DataRepeater ID="PIT_REP" runat="server" WithSections="False" OnBeforeRow="PIT_BeforeRow">
    <Pozycja typ="G">	
    <ea:XmlDataLabel ElementName="KodUrzeduP" runat="server" DataMember="X.KodUrzeduSkarbowego" />
    <Podmiot2 rola="Podatnik">
        <OsobaFizyczna>
            <ea:XmlDataLabel ElementName="NIP" ID="P18_NIP" runat="server" DataMember="C1.NIP" XSDType="TNrNIP"/>
            <ea:XmlDataLabel ElementName="PESEL" ID="P18_PESEL" runat="server" DataMember="C1.PESEL" XSDType="TNrPESEL"/>
            <ea:XmlDataLabel ElementName="ImiePierwsze" runat="server" DataMember="C1.Imię" XSDType="TImie"/>
            <ea:XmlDataLabel ElementName="Nazwisko" runat="server" DataMember="C1.Nazwisko" XSDType="TNazwisko"/>
            <ea:XmlDataLabel ElementName="DataUrodzenia" runat="server" DataMember="C1.DataUrodz" XSDType="TData"/>
        </OsobaFizyczna>
        <ea:Section ID="AdresZamieszkania" runat="server">
        <AdresZamieszkania rodzajAdresu="RAD">
           <ea:Section ID="AdresPolPl" runat="server">
			    <AdresPol>
				    <KodKraju>PL</KodKraju>
				    <ea:XmlDataLabel ElementName="Wojewodztwo" runat="server" DataMember="C2.Wojew" XSDType="TJednAdmin" />
				    <ea:XmlDataLabel ElementName="Powiat" runat="server" DataMember="C2.Powiat" XSDType="TJednAdmin"/>
				    <ea:XmlDataLabel ElementName="Gmina" runat="server" DataMember="C2.Gmina" XSDType="TJednAdmin"/>
				    <ea:XmlDataLabel ElementName="Ulica" runat="server" HideEmptyOrZero="true" DataMember="C2.Ulica" XSDType="TUlica"/>
				    <ea:XmlDataLabel ElementName="NrDomu" runat="server" DataMember="C2.NrDomu" XSDType="TNrBudynku"/>
				    <ea:XmlDataLabel ElementName="NrLokalu" runat="server" HideEmptyOrZero="true" DataMember="C2.NrLokalu" XSDType="TNrLokalu"/>
				    <ea:XmlDataLabel ElementName="Miejscowosc" runat="server" DataMember="C2.Miejsc" XSDType="TMiejscowosc"/>
				    <ea:XmlDataLabel ElementName="KodPocztowy" runat="server" DataMember="C2.KodPoczt" XSDType="TKodPocztowy"/>
			    </AdresPol>
			</ea:Section>
			<ea:Section ID="AdresZagrPl" runat="server">
			    <AdresZagr>
				    <ea:XmlDataLabel ElementName="KodKraju" runat="server" DataMember="X.KodKraju" XSDType="TTekstowy"/>
				    <ea:XmlDataLabel ElementName="KodPocztowy" runat="server" DataMember="C2.KodPoczt" XSDType="TKodPocztowy" HideEmptyOrZero="true"/>
				    <ea:XmlDataLabel ElementName="Miejscowosc" runat="server" DataMember="C2.Miejsc" XSDType="TMiejscowosc"/>
				    <ea:XmlDataLabel ElementName="Ulica" runat="server" DataMember="C2.Ulica" XSDType="TUlica" HideEmptyOrZero="true"/>
				    <ea:XmlDataLabel ElementName="NrDomu" runat="server" DataMember="C2.NrDomu" XSDType="TNrBudynku" HideEmptyOrZero="true"/>
				    <ea:XmlDataLabel ElementName="NrLokalu" runat="server" DataMember="C2.NrLokalu" XSDType="TNrLokalu" HideEmptyOrZero="true"/>
			    </AdresZagr>
			</ea:Section>
        </AdresZamieszkania>
       </ea:Section>
    </Podmiot2>
    <PozycjeSzczegolowe>
        <P_8>
            <ea:XmlDataLabel runat="server" DataMember="C1.Rezydent">
                 <ValuesMap>
                     <ea:ValuesPair Key="False" Value="2" />
                     <ea:ValuesPair Key="True" Value="1"/>
                 </ValuesMap>
            </ea:XmlDataLabel>
        </P_8>
        
        <ea:XmlDataLabel ElementName="P_25" runat="server" DataMember="D.01_b" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="P_26" runat="server" DataMember="D.01_c" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="P_27" runat="server" DataMember="D.01_d" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="P_28" runat="server" DataMember="D.01_e" XSDType="TKwota2"/>		

        <ea:XmlDataLabel ElementName="P_29" runat="server" DataMember="D.02_b" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="P_30" runat="server" DataMember="D.02_c" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="P_31" runat="server" DataMember="D.02_d" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="P_32" runat="server" DataMember="D.02_e" XSDType="TKwota2"/>		

        <ea:XmlDataLabel ElementName="P_33" runat="server" DataMember="D.03_b" XSDType="TKwota2"/>		
        <ea:XmlDataLabel ElementName="P_34" runat="server" DataMember="D.03_c" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="P_35" runat="server" DataMember="D.03_d" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="P_36" runat="server" DataMember="D.03_e" XSDType="TKwota2"/>		

        <ea:XmlDataLabel ElementName="P_37" runat="server" DataMember="D.04_b" XSDType="TKwota2"/>		
        <ea:XmlDataLabel ElementName="P_38" runat="server" DataMember="D.04_c" XSDType="TKwota2"/>		
        <ea:XmlDataLabel ElementName="P_39" runat="server" DataMember="D.04_d" XSDType="TKwota2"/>		
        <ea:XmlDataLabel ElementName="P_40" runat="server" DataMember="D.04_e" XSDType="TKwota2"/>				

        <ea:XmlDataLabel ElementName="P_41" runat="server" DataMember="D.05_b" XSDType="TKwota2"/>		
        <ea:XmlDataLabel ElementName="P_42" runat="server" DataMember="D.05_c" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="P_43" runat="server" DataMember="D.05_d" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="P_44" runat="server" DataMember="D.05_e" XSDType="TKwota2"/>		

        <ea:XmlDataLabel ElementName="P_45" runat="server" DataMember="D.06_b" XSDType="TKwota2"/>		
        <ea:XmlDataLabel ElementName="P_46" runat="server" DataMember="D.06_c" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="P_47" runat="server" DataMember="D.06_d" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="P_48" runat="server" DataMember="D.06_e" XSDType="TKwota2"/>		

        <ea:XmlDataLabel ElementName="P_49" runat="server" DataMember="D.07_b" XSDType="TKwota2"/>		
        <ea:XmlDataLabel ElementName="P_50" runat="server" DataMember="D.07_c" XSDType="TKwota2"/>		
        <ea:XmlDataLabel ElementName="P_51" runat="server" DataMember="D.07_d" XSDType="TKwota2"/>		
        <ea:XmlDataLabel ElementName="P_52" runat="server" DataMember="D.07_e" XSDType="TKwota2"/>				

        <ea:XmlDataLabel ElementName="P_53" runat="server" DataMember="D.08_b" XSDType="TKwota2"/>		
        <ea:XmlDataLabel ElementName="P_54" runat="server" DataMember="D.08_c" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="P_55" runat="server" DataMember="D.08_d" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="P_56" runat="server" DataMember="D.08_e" XSDType="TKwota2"/>		

        <ea:XmlDataLabel ElementName="P_57" runat="server" DataMember="D.09_b" XSDType="TKwota2"/>		
        <ea:XmlDataLabel ElementName="P_58" runat="server" DataMember="D.09_c" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="P_59" runat="server" DataMember="D.09_d" XSDType="TKwota2"/>		
        <ea:XmlDataLabel ElementName="P_60" runat="server" DataMember="D.09_e" XSDType="TKwota2"/>		

        <ea:XmlDataLabel ElementName="P_61" runat="server" DataMember="D.10_b" XSDType="TKwota2"/>		
        <ea:XmlDataLabel ElementName="P_62" runat="server" DataMember="D.10_c" XSDType="TKwota2"/>		
        <ea:XmlDataLabel ElementName="P_63" runat="server" DataMember="D.10_d" XSDType="TKwota2"/>		
        <ea:XmlDataLabel ElementName="P_64" runat="server" DataMember="D.10_e" XSDType="TKwota2"/>				

        <ea:XmlDataLabel ElementName="P_65" runat="server" DataMember="D.11_b" XSDType="TKwota2"/>		
        <ea:XmlDataLabel ElementName="P_66" runat="server" DataMember="D.11_c" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="P_67" runat="server" DataMember="D.11_d" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="P_68" runat="server" DataMember="D.11_e" XSDType="TKwota2"/>		

        <ea:XmlDataLabel ElementName="P_69" runat="server" DataMember="D.12_b" XSDType="TKwota2"/>		
        <ea:XmlDataLabel ElementName="P_70" runat="server" DataMember="D.12_c" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="P_71" runat="server" DataMember="D.12_d" XSDType="TKwota2"/>		
        <ea:XmlDataLabel ElementName="P_72" runat="server" DataMember="D.12_e" XSDType="TKwota2"/>		

        <ea:XmlDataLabel ElementName="P_73" runat="server" DataMember="D.razem_e" XSDType="TKwota2"/>
    </PozycjeSzczegolowe>
</Pozycja>
</ea:DataRepeater>
    <Pouczenie>1</Pouczenie>
</Deklaracja>
