﻿<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="Soneta.Waluty" %>
<%@ import Namespace="Soneta.Magazyny" %>
<%@ import Namespace="Soneta.Kasa" %>
<%@ import Namespace="Soneta.Handel" %>
<%@ import Namespace="Soneta.Business.App" %>
<%@ import Namespace="Soneta.Business" %>
<%@ import Namespace="Soneta.Core" %>
<%@ import Namespace="Soneta.Towary" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Page Language="c#" CodePage="1200" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
    <HEAD>
        <title>Inwentaryzacja</title>
        <script runat="server">
public class Total {
    readonly PozycjaDokHandlowego pozycja;
    InwentaryzacjaPozycjiWorker ipw = new InwentaryzacjaPozycjiWorker();
    public Total(PozycjaDokHandlowego pozycja) {
        this.pozycja = pozycja;
        ipw.Pozycja = pozycja;
    }
    public PozycjaDokHandlowego Pozycja {
        get { return pozycja; }
    }
    public InwentaryzacjaPozycjiWorker IPW {
        get { return ipw; }
    }
    public Towar Towar {
        get { return pozycja.Towar; }
    }
}
        
void OnContextLoad(Object sender, EventArgs args) {
    DokumentHandlowy dokument = (DokumentHandlowy)dc[typeof(DokumentHandlowy)];

    //Składamy opis do dokumentu
    string opis = "";
    if (dokument.Opis!="")
        opis += "<p>" + dokument.Opis + "</p>";
    if (dokument.Wydruk.OpisWydruku!="")
        opis += "<p>" + dokument.Wydruk.OpisWydruku + "</p>";
    Opis.EditValue = opis;

    //Formatujemy podpisy
    stPodpis.Caption = "<font size=2>"+dokument.Session.Login.Operator.FullName+"</font><br><br><font size=1>..................................................<br>Podpis osoby uprawnionej do wystawienia dokumentu</font>";
    stOsoba.Caption = "<font size=2>"+dokument.Osoba+"</font><br><br><font size=1>..................................................<br>Podpis osoby upoważnionej do otrzymania dokumentu</font>";

    ArrayList arrTotal = new ArrayList();
    foreach (PozycjaDokHandlowego pozycja in dokument.Pozycje) {
        arrTotal.Add(new Total(pozycja));
    }

    Hashtable htPodsumowanieIlościPrzed = new Hashtable();
    Hashtable htPodsumowanieIlościPo = new Hashtable();

    foreach(Total t in arrTotal) {
        if (!t.IPW.Pierwsza) continue;
        object v;
        v = htPodsumowanieIlościPrzed[t.IPW.StanZamknięcia.Symbol];
        if(v == null)
            v = t.IPW.StanZamknięcia.Value;
        else
            v = (double)v + t.IPW.StanZamknięcia.Value;
        htPodsumowanieIlościPrzed[t.IPW.StanZamknięcia.Symbol] = v;

        v = htPodsumowanieIlościPo[t.IPW.StanPoInwentaryzacji.Symbol];
        if(v == null)
            v = t.IPW.StanPoInwentaryzacji.Value;
        else
            v = (double)v + t.IPW.StanPoInwentaryzacji.Value;
        htPodsumowanieIlościPo[t.IPW.StanPoInwentaryzacji.Symbol] = v;
    }

    StringBuilder sbPrzed = new StringBuilder();
    foreach(DictionaryEntry de in htPodsumowanieIlościPrzed) {
        if(sbPrzed.Length > 0) sbPrzed.Append(' ');
        sbPrzed.Append(new Quantity((double)de.Value, (string)de.Key).ToString());
    }

    StringBuilder sbPo = new StringBuilder();
    foreach(DictionaryEntry de in htPodsumowanieIlościPo) {
        if(sbPo.Length > 0) sbPo.Append(' ');
        sbPo.Append(new Quantity((double)de.Value, (string)de.Key).ToString());
    }

    dlPodsumowanieIlosciPrzed.EditValue = sbPrzed.ToString();
    dlPodsumowanieIlosciPo.EditValue = sbPo.ToString();
            
    Grid1.DataSource = arrTotal;
}

protected void Grid1_BeforeRow(object sender, RowEventArgs args) {
    bool b = (bool)colPierwsza.EditValue;
    colWartosc1.SumRow = b;
    colWartosc1.Format = b ? "{0:n}" : "[{0:n}]";
    //colWartosc2.SumRow = b;
    //colWartosc2.Format = b ? "{0:n}" : "[{0:n}]";
    colWartosc3.SumRow = b;
    colWartosc3.Format = b || (decimal)colWartosc3.EditValue == Soneta.Tools.Math.BlankDecimal ? "{0:n}" : "[{0:n}]";
    //colWartosc4.SumRow = b;
    //colWartosc4.Format = b ? "{0:n}" : "[{0:n}]";
    colWartosc5.SumRow = b;
    colWartosc5.Format = b || (decimal)colWartosc5.EditValue == Soneta.Tools.Math.BlankDecimal ? "{0:n}" : "[{0:n}]";
    colWartosc6.SumRow = b;
    colWartosc6.Format = b ? "{0:n}" : "[{0:n}]";
    colStan1.SumRow = b;
    colStan1.Format = b ? "{0:n}" : "[{0:n}]";
    colStan2.SumRow = b;
    colStan2.Format = b ? "{0:n}" : "[{0:n}]";
    colStan3.SumRow = b;
    colStan3.Format = b || (Quantity)colStan3.EditValue == Quantity.Empty ? "{0:n}" : "[{0:n}]";
    colStan4.SumRow = b;
    colStan4.Format = b || (Quantity)colStan4.EditValue == Quantity.Empty ? "{0:n}" : "[{0:n}]";
    colStan5.SumRow = b;
    colStan5.Format = b ? "{0:n}" : "[{0:n}]";
}

protected void Grid1_AfterRow(object sender, RowEventArgs args) {
    colWartosc1.Format = "{0:n}";
    //colWartosc2.Format = "{0:n}";
    colWartosc3.Format = "{0:n}";
    //colWartosc4.Format = "{0:n}";
    colWartosc5.Format = "{0:n}";
    colWartosc6.Format = "{0:n}";    
}
</script>
        <meta content="Microsoft Visual Studio 7.0" name="GENERATOR">
        <meta content="C#" name="CODE_LANGUAGE">
        <meta content="JavaScript" name="vs_defaultClientScript">
        <meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
    </HEAD>
    <body>
        <form id="Sprzedaż" method="post" runat="server">
            <ea:datacontext id="dc" runat="server" TypeName="Soneta.Handel.DokumentHandlowy,Soneta.Handel" oncontextload="OnContextLoad" Landscape="false"></ea:datacontext>
            <ea:SectionMarker id="SectionMarker1" runat="server"></ea:SectionMarker>
            <P>
                <ea:PageBreak id="PageBreak1" runat="server" BreakFirstTimes="False"></ea:PageBreak>
                <cc1:ReportHeader id="ReportHeader1" title="Inwentaryzacja - pozycje|{0}|</STRONG>Dokument: <STRONG>{1}|</STRONG>Magazyn: <STRONG>{2}|</STRONG>Data i miejsce wystawienia: <STRONG>{3}, {4}"
                    runat="server" DataMember0="Wydruk.OpisStanu" DataMember1="Numer" DataMember2="Magazyn.Nazwa"
                    DataMember3="Data" DataMember4="Session.Core.Config.Firma.AdresSiedziby.Miejscowosc"></cc1:ReportHeader></P>
            <P>
                <ea:Grid id="Grid1" runat="server" RowTypeName="Soneta.Handel.PozycjaDokHandlowego,Soneta.Handel"
                    RowsInRow="3" onbeforerow="Grid1_BeforeRow" 
                    onafterrow="Grid1_AfterRow">
                    <Columns>
                        <ea:GridColumn Width="4" Align="Right" DataMember="#" Caption="Lp." RowSpan="3" runat="server" EncodeHTML="True"></ea:GridColumn>
                        
                        <ea:GridColumn Width="15" DataMember="Towar.Kod" Caption="Kod" RowSpan="2" runat="server" EncodeHTML="True"></ea:GridColumn>
                        <ea:GridColumn DataMember="Towar.Nazwa" Total="Info" Caption="Nazwa towaru" ColSpan="3" runat="server" EncodeHTML="True"></ea:GridColumn>
                        <ea:GridColumn DataMember="Towar.NumerKatalogowy" Caption="Numer katalogowy" RowSpan="2" runat="server" EncodeHTML="True"></ea:GridColumn>						
                        <ea:GridColumn Width="15" DataMember="IPW.Arkusz" Caption="Nr arkusza inwent./Nr pozycj" runat="server" EncodeHTML="True" RowSpan="2"></ea:GridColumn>
                        
                        <ea:GridColumn runat="server" Caption="Magazyn przed inw." EncodeHTML="true" BottomBorder="Single"></ea:GridColumn>
                        <ea:GridColumn Align="Right" Width="10" ID="colStan1" DataMember="IPW.StanZamknięcia" Caption="Ilość" EncodeHTML="true" runat="server" Total="Sum"></ea:GridColumn>
                        <ea:GridColumn Align="Right" Width="10" ID="colWartosc1" DataMember="IPW.WartośćZamknięcia" Caption="Wartość" EncodeHTML="true" runat="server" Format="{0:n}" Total="Sum"></ea:GridColumn>

                        <ea:GridColumn runat="server" Caption="Ilość faktyczna" EncodeHTML="true" BottomBorder="Single"></ea:GridColumn>
                        <ea:GridColumn Align="Right" Width="10" DataMember="Pozycja.Ilosc" Caption="Pozycji" EncodeHTML="true" runat="server"></ea:GridColumn>
                        <ea:GridColumn Align="Right" Width="10" ID="colStan2" DataMember="IPW.IlośćŁączna" Caption="Łączna" EncodeHTML="true" runat="server"></ea:GridColumn>

                        <ea:GridColumn runat="server" Caption="Strata łączna" EncodeHTML="true" BottomBorder="Single"></ea:GridColumn>
                        <ea:GridColumn Align="Right" Width="10" ID="colStan3" DataMember="IPW.StanStraty" Caption="Ilość" EncodeHTML="true" runat="server"></ea:GridColumn>
                        <ea:GridColumn Align="Right" Width="10" ID="colWartosc3" DataMember="IPW.WartośćStraty" Caption="Wartość" EncodeHTML="true" runat="server" Format="{0:n}" Total="Sum"></ea:GridColumn>

                        <ea:GridColumn runat="server" Caption="Nadwyżka łączna" EncodeHTML="true" BottomBorder="Single"></ea:GridColumn>
                        <ea:GridColumn Align="Right" Width="10" ID="colStan4" DataMember="IPW.StanNadwyżki" Caption="Ilość" EncodeHTML="true" runat="server"></ea:GridColumn>
                        <ea:GridColumn Align="Right" Width="10" ID="colWartosc5" DataMember="IPW.WartośćNadwyżki" Caption="Wartość" EncodeHTML="true" runat="server" Format="{0:n}" Total="Sum"></ea:GridColumn>						

                        <ea:GridColumn runat="server" Caption="Magazyn po inw." EncodeHTML="true" BottomBorder="Single"></ea:GridColumn>
                        <ea:GridColumn Align="Right" Width="10" ID="colStan5" DataMember="IPW.StanPoInwentaryzacji" Caption="Ilość" EncodeHTML="true" runat="server" Total="Sum"></ea:GridColumn>
                        <ea:GridColumn Align="Right" Width="10" ID="colWartosc6" DataMember="IPW.WartośćPoInwentaryzacji" Caption="Wartość" EncodeHTML="true" runat="server" Format="{0:n}" Total="Sum"></ea:GridColumn>

                        <ea:GridColumn Width="1" DataMember="IPW.Pierwsza" ID="colPierwsza" Visible="False" RowSpan="3" runat="server" EncodeHTML="True"></ea:GridColumn>						
                    </Columns>
                </ea:Grid>
                <br />
                Podsumowanie ilości przed inwentaryzacją:
                <ea:DataLabel id="dlPodsumowanieIlosciPrzed" runat="server" Bold="False">
                </ea:DataLabel>
                <br />
                Podsumowanie ilości po inwentaryzacji:
                <ea:DataLabel id="dlPodsumowanieIlosciPo" runat="server" Bold="False">
                </ea:DataLabel>
                <br /></P>
            <P>
                <ea:DataLabel id="Opis" runat="server" Bold="False" EncodeHTML="False"></ea:DataLabel>
                <cc1:ReportFooter id="ReportFooter1" runat="server" Height="105px" TheEnd="False">
                    <Subtitles>
                        <cc1:FooterSubtitle runat="server" Caption="Operator" ID="stPodpis" SubtitleType="CenterText" Width="50"></cc1:FooterSubtitle>
                        <cc1:FooterSubtitle runat="server" Caption="Osoba" ID="stOsoba" SubtitleType="CenterText" Width="50"></cc1:FooterSubtitle>
                    </Subtitles>
                </cc1:ReportFooter></P>
            <ea:SectionMarker id="SectionMarker6" runat="server" SectionType="Footer"></ea:SectionMarker>
        </form>
    </body>
</HTML>

