﻿<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Waluty" %>
<%@ Import Namespace="Soneta.Kasa" %>
<%@ Import Namespace="Soneta.Handel" %>
<%@ Import Namespace="Soneta.Business.App" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Core" %>
<%@ Import Namespace="System.Linq" %>

<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>

<%@ Page Language="c#" CodePage="1200" %>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<html>
<head>
    <title>Zakup</title>
    <meta content="Microsoft Visual Studio 7.0" name="GENERATOR">
    <meta content="C#" name="CODE_LANGUAGE">
    <meta content="JavaScript" name="vs_defaultClientScript">
    <meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
</head>

<script runat="server">

    ParametryWydrukuDokumentu parametry;
    [Context]
    public ParametryWydrukuDokumentu Parametry
    {
        get
        {
            return parametry;
        }
        set
        {
            parametry = value;
        }
    }

    void OnContextLoad( Object sender, EventArgs args )
    {
        DataRepeater1.DataSource = ( IEnumerable ) Parametry;
        DokumentHandlowy dokument = Parametry.Dokument;

        platnik.Visible = dokument.InnyPłatnik;
		
		if(dokument.Definicja.KodKreskowyZNumeremDok != KodKreskowyZNumeremDok.Brak)
        {
            DataLabel15.WithBarcode = true;
            DataLabel15.BarcodeFontSize = 22;
            DataLabel15.BarcodeFontType = (SKKFontType) dokument.Definicja.KodKreskowyZNumeremDok;
            DataLabel15.BarcodeMethodGeneration = BarcodeGenerator.ZXing;
        }

        if( dokument.DaneKontrahenta == null
            || dokument.DaneKontrahenta.RodzajPodmiotu == RodzajPodmiotu.Krajowy
            || dokument.RachunekBankowy == null
            || dokument.RachunekBankowy.Rachunek.SWIFT == "" )
            labelSwift.Visible = false;

        //Wybieramy bloki do wydruku --> inne dla korekty a inne dla sprzedaży
        //i ukrywany nieużywane kolumny
        if( dokument.DokumentKorygowany != null )
        {
            DataRepeater2.Visible = false;
            DataRepeater3.DataSource = new object[] { dokument };

            rabatprzed.Visible = dokument.JestRabat || dokument.DokumentKorygowany.JestRabat;
            swwprzed.Visible = dokument.JestSWW || dokument.DokumentKorygowany.JestSWW;
            rabatpo.Visible = rabatprzed.Visible;
            swwpo.Visible = swwprzed.Visible;
        }
        else
        {
            DataRepeater2.DataSource = new object[] { dokument };
            DataRepeater3.Visible = false;

            rabat.Visible = dokument.JestRabat;
            sww.Visible = dokument.JestSWW;
        }

        //Ukrywamy tabelkę VAT i kolumny VAT dla dokumentów nie VAT
        //Dostosowujemy nazwy kolumn
        string nazwa;
        if( dokument.Definicja.SumyVAT != SposobLiczeniaSumVAT.NieLiczyć )
        {
            DataRepeater4.DataSource = new object[] { dokument };
            nazwa = "faktury";
        }
        else
        {
            DataRepeater4.Visible = false;
            vat.Visible = false;
            vatprzed.Visible = false;
            vatpo.Visible = false;
            nazwa = "rachunku";
        }

        //Jeżeli dokumenty liczone od brutto, to wymieniamy nagłówki
        if( dokument.OdBrutto )
        {
            cena.Caption = "Cena brutto";
            wartosc.Caption = "Wartość brutto";
            cenaprzed.Caption = "Cena brutto";
            wartoscprzed.Caption = "Wartość brutto";
            cenapo.Caption = "Cena brutto";
        }

        //Formatujemy podpisy
        stPodpis.Caption = "<font size=1>Dokument wystawił: </font><font size=2>"+dokument.Wydruk.UprawnionyDoWystawienia.FullName+"</font><br><br><font size=1>..................................................<br>Podpis osoby uprawnionej do wystawienia "+nazwa+"</font>";
        stOsoba.Caption = "<font size=2>" + dokument.Osoba + "</font><br><br><font size=1>..................................................<br>Podpis osoby upoważnionej do otrzymania " + nazwa + "</font>";

        sectionOdbiorca.Visible = dokument.Wydruk.JestOdbiorca;

        IPieczątkaFirmy pieczątka = ReportHeader.GetPieczątka( dc, null, false);
        var BDO = pieczątka.BDO;
        NazwaFirmy.EditValue = pieczątka.NazwaFormatowana;
        AdresLinia1.EditValue = pieczątka.Adres.Linia1;
        AdresLinia2.EditValue = pieczątka.Adres.Linia2;
        NipFirmy.EditValue = pieczątka.NIP;
        BDOFirmyS.EditValue = "BDO: " + BDO;

        if(String.IsNullOrWhiteSpace(BDO))
            BDOFirmyS.Visible = false;

        lDataEtykieta.Visible = lData.Visible = dokument.Wydruk.DatyDokumentu.IsVisibleData;
        lDataDostawyEtykieta.Visible = lDataDostawy.Visible = dokument.Wydruk.DatyDokumentu.IsVisibleDataDostawy;
        lDataOperacjiEtykieta.Visible = lDataOperacji.Visible = dokument.Wydruk.DatyDokumentu.IsVisibleDataOperacji;
        lDataOtrzymaniaEtykieta.Visible = lDataOtrzymania.Visible = dokument.Wydruk.DatyDokumentu.IsVisibleDataOtrzymania;

        ObcyKorygowany.Visible = dokument.DokumentyKorygowanePierwsze.Any(x => !string.IsNullOrEmpty(x.Obcy.Numer));

        if (dokument.Definicja.DrukowanieZestawieniaMagazynowych)
            Grid_Magazynowe.DataSource = dokument.Wydruk.DokumentyPowiazane(dokument, false, true, new TypRelacjiHandlowej[] { TypRelacjiHandlowej.HandlowoMagazynowa, TypRelacjiHandlowej.Korekta  });
    }


    void Grid3_BeforeRow( Object sender, RowEventArgs args )
    {
        PozycjaDokHandlowego pozycja = ( PozycjaDokHandlowego ) args.Row;
        if( !pozycja.Dokument.Definicja.DrukujTylkoRoznicePrzedKorekta )
            return;

        args.VisibleRow = pozycja.Korygowana;
    }

    void Grid4_BeforeRow( Object sender, RowEventArgs args )
    {
        PozycjaDokHandlowego pozycja = ( PozycjaDokHandlowego ) args.Row;
        if( !pozycja.Dokument.Definicja.DrukujTylkoRoznicePoKorekcie )
            return;
        
        args.VisibleRow = pozycja.Korygowana;
    }

    void niezapłacone_BeforeRow( Object sender, RowEventArgs args )
    {
        WydrukDokumentu.NiezapłaconeInfo p = ( WydrukDokumentu.NiezapłaconeInfo ) args.Row;
        if( p.Płatność.Podmiot != p.Płatność.Dokument.Podmiot )
        {
            platnik.AddLine( p.Płatność.Podmiot.Nazwa );
            platnik.AddLine( p.Płatność.Podmiot.Adres );
        }
    }
 
    void gridMagazynowe_BeforeRow(object sender, RowEventArgs args)
    {
        var han = (DokumentHandlowy)dc.Context[typeof(DokumentHandlowy)];
        var mag = (DokumentHandlowy)args.Row;
        MagWartCol.EditValue = han.OdBrutto ? mag.Suma.BruttoCy : mag.Suma.NettoCy;
    } 

    void DataRepeater1_BeforeRow(Object sender, EventArgs args) {
        KopiaDokumentu kopia = (KopiaDokumentu)DataRepeater1.CurrentRow;
        DokumentHandlowy dokument = kopia.Dokument;
        string td1 = dokument.Definicja.TytulWydruku + " {0}";
        string td2 = kopia.KopiaCaption;
        string title = "<table style=\"font-size: 9pt; width: 100%; margin: 0px; padding: 0px;  \"><tr><td align=\"left\"><b>"+td1+"</b></td><td width=\"100px\" align=\"right\">"+td2+"</td></tr></table>";        
        ReportHeader.Title = title;      
    }
</script>

<body>
    <form id="Sprzedaż" method="post" runat="server">
    <ea:DataContext ID="dc" runat="server" TypeName="Soneta.Handel.DokumentHandlowy,Soneta.Handel"
        OnContextLoad="OnContextLoad"></ea:DataContext>
    <ea:DataRepeater ID="DataRepeater1" runat="server" onbeforerow="DataRepeater1_BeforeRow" RowTypeName="Soneta.Handel.KopiaDokumentu,Soneta.Handel"
        Width="100%" Height="161px">
        <ea:SectionMarker ID="SectionMarker1" runat="server">
        </ea:SectionMarker>
        <ea:PageBreak ID="PageBreak1" runat="server" BreakFirstTimes="False">
        </ea:PageBreak>
        <cc1:reportheader id="ReportHeader" 
                runat="server" DataMember0="Dokument.Numer" FirstHeader="False"></cc1:reportheader>
        <div style="border-top: 1px solid; width: 100%; border-bottom: 1px solid">
            <table id="Table4" style="font-size: 10px; font-family: Tahoma" width="100%">
                <tr>
                    <td style="font-weight: bold; font-size: 18px;" valign="top" align="left">
                        <ea:DataLabel ID="DataLabel19" runat="server" DataMember="Dokument.Definicja.TytulWydruku">
                        </ea:DataLabel>
                        <ea:DataLabel ID="DataLabel20" runat="server" DataMember="Dokument.Wydruk.MalyPodatnik_Do_20130101">
                            <ValuesMap>
                                <ea:ValuesPair Key="False" Value=""></ea:ValuesPair>
                                <ea:ValuesPair Key="True" Value=" MP "></ea:ValuesPair>
                            </ValuesMap>
                        </ea:DataLabel>
                        nr
						<ea:DataLabel ID="DataLabel15" runat="server" DataMember="Dokument.Numer" WithBarcode="False">
                        </ea:DataLabel>

                        <ea:DataLabel ID="DataLabel43" runat="server" DataMember="Dokument.Wydruk.MalyPodatnik_Od_20130101" >
                            <ValuesMap>
                                <ea:ValuesPair Key="False" Value=""></ea:ValuesPair>
                                <ea:ValuesPair Key="True" Value="<br /><span style='font-size: 13px;'>metoda kasowa</span>"></ea:ValuesPair>
                            </ValuesMap>
                        </ea:DataLabel>

                        <ea:DataLabel ID="DataLabel18" runat="server" DataMember="Dokument.Stan">
                            <ValuesMap>
                                <ea:ValuesPair Key="Anulowany" Value="&lt;br&gt;Dokument został anulowany"></ea:ValuesPair>
                                <ea:ValuesPair Key="Bufor" Value="&lt;br&gt;Dokument nie został zatwierdzony"></ea:ValuesPair>
                                <ea:ValuesPair Key="Zablokowany" Value=""></ea:ValuesPair>
                                <ea:ValuesPair Key="Zatwierdzony" Value=""></ea:ValuesPair>
                            </ValuesMap>
                        </ea:DataLabel>
                        <br>
                        <span style="font-weight: normal; font-size: 13px;">Dokument obcy nr:
                            <ea:DataLabel ID="DataLabel28" runat="server" DataMember="Dokument.Obcy.Numer" EncodeHTML="True">
                            </ea:DataLabel>
                        </span>
                    </td>
                    <td valign="top" align="right">
                            <ea:DataLabel ID="lDataEtykieta" runat="server" DataMember="Dokument.Wydruk.DatyDokumentu.DataEtykieta" Bold="False" EncodeHTML="True"></ea:DataLabel> 
                            <br/>
                            <ea:DataLabel ID="lDataOperacjiEtykieta" runat="server" DataMember="Dokument.Wydruk.DatyDokumentu.DataOperacjiEtykieta" Bold="False" EncodeHTML="True"></ea:DataLabel>
                            <br/>
                            <ea:DataLabel ID="lDataOtrzymaniaEtykieta" runat="server" DataMember="Dokument.Wydruk.DatyDokumentu.DataOtrzymaniaEtykieta" Bold="False" EncodeHTML="True"></ea:DataLabel>
                            <br/>
                            <ea:DataLabel ID="lDataDostawyEtykieta" runat="server" DataMember="Dokument.Wydruk.DatyDokumentu.DataDostawyEtykieta" Bold="False" EncodeHTML="True"></ea:DataLabel>
                    </td>
                    <td width="10">
                    </td>
                    <td valign="top" align="right">
                            <ea:DataLabel ID="lData" runat="server" DataMember="Dokument.Wydruk.DatyDokumentu.Data" EncodeHTML="True"> </ea:DataLabel>
                            <br/>
                            <ea:DataLabel ID="lDataOperacji" runat="server" DataMember="Dokument.Wydruk.DatyDokumentu.DataOperacji" EncodeHTML="True"> </ea:DataLabel>
                            <br/>
                            <ea:DataLabel ID="lDataOtrzymania" runat="server" DataMember="Dokument.Wydruk.DatyDokumentu.DataOtrzymania" EncodeHTML="True"> </ea:DataLabel>
                            <br/>
                            <ea:DataLabel ID="lDataDostawy" runat="server" DataMember="Dokument.Wydruk.DatyDokumentu.DataDostawy" EncodeHTML="True"> </ea:DataLabel>
                            <br/>
                    </td>
                </tr>
            </table>
        </div>
        <table id="Table1" width="100%">
            <tr>
                <td valign="top" colspan="2">
                    <ea:Section ID="Section5" runat="server" Width="100%" DataMember="Dokument.DokumentKorygowany"
                        ConditionValue="IS NOT NULL">
                        <em><u>Dokument korygowany:</u></em>
                        <div style="font-size: 13px; left: 10px; font-family: Tahoma; position: relative">
                            <ea:datarepeater runat="server" rowtypename="Soneta.Handel.DokumentHandlowy,Soneta.Handel" DataMember="Dokument.DokumentyKorygowanePierwsze">
                                    <ea:DataLabel runat="server" DataMember="Numer" EncodeHTML="True"> </ea:DataLabel>
                              
                                        <ea:Section  ID="ObcyKorygowany" runat="server" EncodeHTML="True">
                                            <br />
                                            <span style="font-weight: normal; font-size: 13px;" >
                                                Dokument obcy nr:                                          
                                            <ea:DataLabel runat="server" DataMember="Obcy.Numer" EncodeHTML="True">
                                            </ea:DataLabel>
                                            </span>
                                        </ea:Section>                               
                                    
                                    <br/>
                                    <ea:DataLabel runat="server" DataMember="Wydruk.DatyDokumentu.DataEtykieta" Bold="False" EncodeHTML="True"> </ea:DataLabel>
                                    <ea:DataLabel runat="server" DataMember="Wydruk.DatyDokumentu.Data" EncodeHTML="True"> </ea:DataLabel>
                                    <br/>
                                    <ea:DataLabel runat="server" DataMember="Wydruk.DatyDokumentu.DataOperacjiEtykieta" Bold="False" EncodeHTML="True"> </ea:DataLabel>
                                    <ea:DataLabel runat="server" DataMember="Wydruk.DatyDokumentu.DataOperacji" EncodeHTML="True"> </ea:DataLabel>
                                    <br />
                            </ea:DataRepeater>
                        </div>
                    </ea:Section>
                </td>
            </tr>
            <tr>
                <td valign="top" width="50%">
                    <em><u>Nabywca:</u></em>
                    <div style="font-size: 13px; left: 10px; font-family: Tahoma; position: relative">
                        <ea:DataLabel ID="NazwaFirmy" runat="server" EncodeHTML="True"> </ea:DataLabel>
                        <br>
                        <ea:DataLabel ID="AdresLinia1" runat="server" Bold="False" EncodeHTML="True"> </ea:DataLabel>
                        <br>
                        <ea:DataLabel ID="AdresLinia2" runat="server" Bold="False" EncodeHTML="True"> </ea:DataLabel>
                        <br>
                        NIP:
                        <ea:DataLabel ID="NipFirmy" runat="server" Bold="False" EncodeHTML="True"> </ea:DataLabel>
                        <br>
                        <ea:DataLabel ID="BDOFirmyS" runat="server" Bold="False" EncodeHTML="True" />
                    </div>
                    <div>
                        <ea:Section ID="sectionOdbiorca" runat="server">
                            <em><u>Dostawca:</u></em>
                            <div style="font-size: 13px; left: 10px; font-family: Tahoma; position: relative">
                                <ea:DataLabel ID="DataLabel10" runat="server" DataMember="Dokument.DaneOdbiorcy.NazwaFormatowana"
                                    EncodeHTML="True">
                                </ea:DataLabel>
                                <br>
                                <ea:DataLabel ID="DataLabel9" runat="server" DataMember="Dokument.DaneOdbiorcy.Adres.Linia1"
                                    Bold="False" EncodeHTML="True">
                                </ea:DataLabel>
                                <br>
                                <ea:DataLabel ID="DataLabel8" runat="server" DataMember="Dokument.DaneOdbiorcy.Adres.Linia2"
                                    Bold="False" EncodeHTML="True">
                                </ea:DataLabel>
                                <br>
                                NIP:
                                <ea:DataLabel ID="DataLabel7" runat="server" DataMember="Dokument.DaneOdbiorcy.EuVAT"
                                    Bold="False" EncodeHTML="True">
                                </ea:DataLabel>
                            </div>
                        </ea:Section>
                    </div>
                </td>
                <td valign="top">
                    <em><u>Sprzedawca:</u></em>
                    <div style="font-size: 13px; left: 10px; font-family: Tahoma; position: relative">
                        <ea:DataLabel ID="DataLabel1" runat="server" DataMember="Dokument.DaneKontrahenta.NazwaFormatowana"
                            EncodeHTML="True">
                        </ea:DataLabel>
                        <br>
                        <ea:DataLabel ID="DataLabel2" runat="server" DataMember="Dokument.DaneKontrahenta.Adres.Linia1"
                            Bold="False" EncodeHTML="True">
                        </ea:DataLabel>
                        <br>
                        <ea:DataLabel ID="DataLabel3" runat="server" DataMember="Dokument.DaneKontrahenta.Adres.Linia2"
                            Bold="False" EncodeHTML="True">
                        </ea:DataLabel>
                        <br>
                        NIP:
                        <ea:DataLabel ID="DataLabel11" runat="server" DataMember="Dokument.DaneKontrahenta.EuVAT"
                            Bold="False" EncodeHTML="True">
                        </ea:DataLabel>
                        <br>
                    </div>
                    <em><u>Konto bankowe:</u></em>
                    <div style="font-size: 13px; left: 10px; font-family: Tahoma; position: relative">
                        <ea:DataLabel ID="labelBank" runat="server" DataMember="Dokument.Kontrahent.DomyslnyRachunek.Rachunek.Bank.Nazwa"
                            Bold="False" Format="{0}<br>">
                        </ea:DataLabel>
                        <ea:DataLabel ID="labelSwift" runat="server" DataMember="Dokument.Kontrahent.DomyslnyRachunek.Rachunek.SWIFT"
                            Bold="False" Format="SWIFT: {0}<br>">
                        </ea:DataLabel>
                        <ea:DataLabel ID="DataLabel35" runat="server" DataMember="Dokument.Kontrahent.DomyslnyRachunek.Rachunek.Numer"
                            Bold="False">
                        </ea:DataLabel>
                    </div>
                </td>
            </tr>
        </table>
        <ea:Section ID="KursSection" runat="server" DataMember="Dokument.Wydruk.JestWaluta"
            Width="100%">
            <font size="2">Kurs <strong>1 </strong>
                <ea:DataLabel ID="DataLabel31" runat="server" DataMember="Dokument.BruttoCy.Symbol"
                    EncodeHTML="True">
                </ea:DataLabel>
                &nbsp;=
                <ea:DataLabel ID="KursWaluty" runat="server" DataMember="Dokument.KursWaluty" EncodeHTML="True">
                </ea:DataLabel>
                <strong>&nbsp;PLN</strong> z dnia
                <ea:DataLabel ID="DataLabel32" runat="server" DataMember="Dokument.DataOgłoszeniaKursu"
                    EncodeHTML="True">
                </ea:DataLabel>
                &nbsp;(
                <ea:DataLabel ID="DataLabel33" runat="server" DataMember="Dokument.TabelaKursowa"
                    EncodeHTML="True">
                </ea:DataLabel>
                )</font>
        </ea:Section>
        <ea:Section ID="KorektaKursuSection" runat="server" Width="100%" DataMember="Dokument.Wydruk.JestKorektaKursu">
                <em><u>Korekta kursu:</u></em>
                <div style="font-size: 13px">
                     Kurs przed korektą: <strong>1</strong> <ea:DataLabel ID="DataLabel53" runat="server" DataMember="Dokument.DokumentKorygowany.BruttoCy.Symbol" EncodeHTML="True" />
                     &nbsp;=&nbsp;<ea:DataLabel ID="DataLabel54" runat="server" DataMember="Dokument.DokumentKorygowany.KursWaluty" EncodeHTML="True" /><strong>&nbsp;PLN</strong> z dnia
                     <ea:DataLabel ID="DataLabel55" runat="server" DataMember="Dokument.DokumentKorygowany.DataOgłoszeniaKursu" EncodeHTML="True" />
                     &nbsp;(<ea:DataLabel ID="DataLabel56" runat="server" DataMember="Dokument.DokumentKorygowany.TabelaKursowa" EncodeHTML="True" />)
                     <br />
                     Kurs po korekcie: <strong>1</strong> <ea:DataLabel ID="DataLabel46" runat="server" DataMember="Dokument.BruttoCy.Symbol" EncodeHTML="True" />
                     &nbsp;=&nbsp;<ea:DataLabel ID="DataLabel49" runat="server" DataMember="Dokument.KursWaluty" EncodeHTML="True" /><strong>&nbsp;PLN</strong> z dnia
                     <ea:DataLabel ID="DataLabel52" runat="server" DataMember="Dokument.DataOgłoszeniaKursu" EncodeHTML="True" />
                     &nbsp;(<ea:DataLabel ID="DataLabel57" runat="server" DataMember="Dokument.TabelaKursowa" EncodeHTML="True" />)</div>
        </ea:Section>
        <br />
        <ea:DataRepeater ID="DataRepeater2" runat="server" Width="100%">
            <ea:SectionMarker ID="SectionMarker2" runat="server">
            </ea:SectionMarker>
            <ea:Grid ID="Grid1" runat="server" RowTypeName="Soneta.Handel.PozycjaDokHandlowego,Soneta.Handel"
                DataMember="Wydruk.PozycjeRazem" RowsInRow="2" GroupData0="Workers.WydrukPozycji.SekcjaDokumentu"
                GroupLine="{0}" >
                <Columns>
                    <ea:GridColumn runat="server" Width="4" Align="Right" DataMember="#" Caption="Lp."
                        RowSpan="2" EncodeHTML="True">
                    </ea:GridColumn>
                    <ea:GridColumn runat="server" DataMember="NazwaPierwszaLinia" Caption="Nazwa towaru/usługi"
                        EncodeHTML="True" ID="KolumnaNazwa">
                    </ea:GridColumn>
                    <ea:GridColumn runat="server" DataMember="NazwaResztaLinii" Caption=" " EncodeHTML="True">
                    </ea:GridColumn>
                    <ea:GridColumn runat="server" Width="15" Align="Right" DataMember="Cena" Caption="Cena netto"
                        ID="cena" RowSpan="2" EncodeHTML="True">
                    </ea:GridColumn>
                    <ea:GridColumn runat="server" Width="10" RightBorder="None" Align="Right" DataMember="Ilosc.Value"
                        Caption="Ilość" RowSpan="2" EncodeHTML="True">
                    </ea:GridColumn>
                    <ea:GridColumn runat="server" Width="5" Align="Center" DataMember="Ilosc.Symbol"
                        Caption="jm." RowSpan="2" EncodeHTML="True">
                    </ea:GridColumn>
                    <ea:GridColumn runat="server" Width="8" Align="Right" DataMember="Rabat" Caption="Rabat"
                        ID="rabat" RowSpan="2" EncodeHTML="True">
                    </ea:GridColumn>
                    <ea:GridColumn runat="server" Width="16" Align="Right" DataMember="WartoscCy" Caption="Wartość netto"
                        Format="&lt;b&gt;{0}&lt;/b&gt;" ID="wartosc" RowSpan="2">
                    </ea:GridColumn>
                    <ea:GridColumn runat="server" Width="10" Align="Right" DataMember="DefinicjaStawki"
                        Caption="Stawka VAT" ID="vat" RowSpan="2" EncodeHTML="True">
                    </ea:GridColumn>
                    <ea:GridColumn runat="server" Width="15" DataMember="SWW" Caption="SWW/PKWiU" ID="sww"
                        RowSpan="2" EncodeHTML="True">
                    </ea:GridColumn>
                </Columns>
            </ea:Grid>
            <ea:SectionMarker ID="SectionMarker3" runat="server" SectionType="Footer">
            </ea:SectionMarker>
        </ea:DataRepeater>
        <ea:DataRepeater ID="DataRepeater3" runat="server" Width="100%">
            <ea:SectionMarker ID="SectionMarker4" runat="server">
            </ea:SectionMarker>
            <em>Przed korektą:</em>
            <ea:Grid ID="Grid3" runat="server" DataMember="Pozycje" RowsInRow="2"
                RowTypeName="Soneta.Handel.PozycjaDokHandlowego,Soneta.Handel" OnBeforeRow="Grid3_BeforeRow" >
                <Columns>
                    <ea:GridColumn runat="server" Width="4" Align="Right" DataMember="#" Caption="Lp."
                        RowSpan="2" EncodeHTML="True">
                    </ea:GridColumn>
                    <ea:GridColumn runat="server" DataMember="PozycjaKorygowana.NazwaPierwszaLinia" Caption="Nazwa towaru/usługi"
                        EncodeHTML="True">
                    </ea:GridColumn>
                    <ea:GridColumn runat="server" DataMember="PozycjaKorygowana.NazwaResztaLinii" Caption=" "
                        EncodeHTML="True">
                    </ea:GridColumn>
                    <ea:GridColumn runat="server" Width="15" Align="Right" DataMember="PozycjaKorygowana.Cena"
                        Caption="Cena netto" ID="cenaprzed" RowSpan="2" EncodeHTML="True">
                    </ea:GridColumn>
                    <ea:GridColumn runat="server" Width="10" RightBorder="None" Align="Right" DataMember="PozycjaKorygowana.Ilosc.Value"
                        Caption="Ilość" RowSpan="2" EncodeHTML="True">
                    </ea:GridColumn>
                    <ea:GridColumn runat="server" Width="5" Align="Center" DataMember="PozycjaKorygowana.Ilosc.Symbol"
                        Caption="jm." RowSpan="2" EncodeHTML="True">
                    </ea:GridColumn>
                    <ea:GridColumn runat="server" Width="8" Align="Right" DataMember="PozycjaKorygowana.Rabat"
                        Caption="Rabat" ID="rabatprzed" RowSpan="2" EncodeHTML="True">
                    </ea:GridColumn>
                    <ea:GridColumn runat="server" Width="16" Align="Right" DataMember="PozycjaKorygowana.WartoscCy"
                        Caption="Wartość netto" ID="wartoscprzed" RowSpan="2" EncodeHTML="True">
                    </ea:GridColumn>
                    <ea:GridColumn runat="server" Width="10" Align="Right" DataMember="PozycjaKorygowana.DefinicjaStawki"
                        Caption="Stawka VAT" ID="vatprzed" RowSpan="2" EncodeHTML="True">
                    </ea:GridColumn>
                    <ea:GridColumn runat="server" Width="15" DataMember="PozycjaKorygowana.SWW" Caption="SWW/PKWiU"
                        ID="swwprzed" RowSpan="2" EncodeHTML="True">
                    </ea:GridColumn>
                </Columns>
            </ea:Grid>
            <em>Korekta:</em>
            <ea:Grid ID="Grid4" runat="server" DataMember="Pozycje" RowsInRow="2" RowTypeName="Soneta.Handel.PozycjaDokHandlowego,Soneta.Handel"
                OnBeforeRow="Grid4_BeforeRow">
                <Columns>
                    <ea:GridColumn runat="server" Width="4" Align="Right" DataMember="#" Caption="Lp."
                        RowSpan="2" EncodeHTML="True">
                    </ea:GridColumn>
                    <ea:GridColumn runat="server" DataMember="NazwaPierwszaLinia" Caption="Nazwa towaru/usługi"
                        EncodeHTML="True">
                    </ea:GridColumn>
                    <ea:GridColumn runat="server" DataMember="NazwaResztaLinii" Caption=" " EncodeHTML="True">
                    </ea:GridColumn>
                    <ea:GridColumn runat="server" Width="15" Align="Right" DataMember="Cena" Caption="Cena netto"
                        ID="cenapo" RowSpan="2" EncodeHTML="True">
                    </ea:GridColumn>
                    <ea:GridColumn runat="server" Width="10" RightBorder="None" Align="Right" DataMember="ZmianaIlości.Value"
                        Caption="Zmiana ilości" RowSpan="2" EncodeHTML="True">
                    </ea:GridColumn>
                    <ea:GridColumn runat="server" Width="5" Align="Center" DataMember="Ilosc.Symbol"
                        Caption="jm." RowSpan="2" EncodeHTML="True">
                    </ea:GridColumn>
                    <ea:GridColumn runat="server" Width="8" Align="Right" DataMember="Rabat" Caption="Rabat"
                        ID="rabatpo" RowSpan="2" EncodeHTML="True">
                    </ea:GridColumn>
                    <ea:GridColumn runat="server" Width="16" Align="Right" DataMember="ZmianaWartościCy"
                        Caption="Zmiana wartości" RowSpan="2" EncodeHTML="True">
                    </ea:GridColumn>
                    <ea:GridColumn runat="server" Width="10" Align="Right" DataMember="DefinicjaStawki"
                        Caption="Stawka VAT" ID="vatpo" RowSpan="2" EncodeHTML="True">
                    </ea:GridColumn>
                    <ea:GridColumn runat="server" Width="15" DataMember="SWW" Caption="SWW/PKWiU" ID="swwpo"
                        RowSpan="2" EncodeHTML="True">
                    </ea:GridColumn>
                </Columns>
            </ea:Grid>
            <ea:SectionMarker ID="SectionMarker5" runat="server" SectionType="Footer">
            </ea:SectionMarker>
        </ea:DataRepeater>
        <ea:DataRepeater ID="DataRepeater4" runat="server" Width="100%">
            <ea:SectionMarker ID="SectionMarker6" runat="server">
            </ea:SectionMarker>
            <table cellpadding="0" cellspacing="0" border="0">
                <tr>
                    <td width="100%" style="font-size: 10px;">
                        <ea:DataLabel ID="DataLabel24" runat="server" DataMember="Wydruk.InfoKorekty1" Bold="False"
                            EncodeHTML="True">
                        </ea:DataLabel>
                        <br />
                        <ea:DataLabel ID="DataLabel23" runat="server" DataMember="Wydruk.InfoKorekty3" Bold="False"
                            EncodeHTML="True">
                        </ea:DataLabel>
                    </td>
                    <td align="right">
                        <ea:Grid ID="Grid5" runat="server" DataMember="SumyVAT" RowTypeName="Soneta.Handel.SumaVAT,Soneta.Handel"
                            WithSections="False">
                            <Columns>
                                <ea:GridColumn runat="server" Width="15" Align="Right" DataMember="DefinicjaStawki"
                                    Total="Info" Caption="Stawka VAT" EncodeHTML="True">
                                </ea:GridColumn>
                                <ea:GridColumn runat="server" Width="17" Align="Right" DataMember="Suma.Netto" Format="{0:n}"
                                    Total="Sum" Caption="Netto" EncodeHTML="True">
                                </ea:GridColumn>
                                <ea:GridColumn runat="server" Width="17" Align="Right" DataMember="Suma.VAT" Format="{0:n}"
                                    Total="Sum" Caption="Kwota VAT" EncodeHTML="True">
                                </ea:GridColumn>
                                <ea:GridColumn runat="server" Width="17" Align="Right" DataMember="Suma.Brutto" Format="{0:n}"
                                    Total="Sum" Caption="Brutto" EncodeHTML="True">
                                </ea:GridColumn>
                            </Columns>
                        </ea:Grid>
                    </td>
                </tr>
            </table>
            <ea:SectionMarker ID="SectionMarker7" runat="server" SectionType="Footer">
            </ea:SectionMarker>
        </ea:DataRepeater>
		
        <ea:Section ID="Section4" runat="server" DataMember="Dokument.Wydruk.JestSumaPozycji" Width="100%">
			<div style="margin: 0px 0px 5px 0px">
				<em>Suma&nbsp;brutto dokumentu:</em>
				<ea:DataLabel ID="DataLabel34" runat="server" DataMember="Dokument.SumaPozycji.Brutto" EncodeHTML="True">
				</ea:DataLabel>
				&nbsp;PLN
			</div>
        </ea:Section>
		
        <ea:Section ID="sectionZaliczki" runat="server" DataMember="Dokument.DokumentyZaliczkowe">
            <em>Faktury zaliczkowe:<br>
            </em>
            <ea:Grid ID="gridZaliczki" runat="server" DataMember="Dokument.Wydruk.DokumentyZaliczkowe"
                RowTypeName="Soneta.Handel.DokumentHandlowy,Soneta.Handel" WithSections="False">
                <Columns>
                    <ea:GridColumn runat="server" Width="4" Align="Right" DataMember="#" Caption="Lp."
                        EncodeHTML="True">
                    </ea:GridColumn>
                    <ea:GridColumn runat="server" Width="30" DataMember="Numer" EncodeHTML="True">
                    </ea:GridColumn>
                    <ea:GridColumn runat="server" Width="15" Align="Center" DataMember="Data" EncodeHTML="True">
                    </ea:GridColumn>
                    <ea:GridColumn runat="server" Width="18" Align="Right" DataMember="BruttoCy" Caption="Wartość"
                        EncodeHTML="True">
                    </ea:GridColumn>
                </Columns>
            </ea:Grid>
            <br>
        </ea:Section>
		
        <table id="Table3" cellspacing="0" cellpadding="0" width="90%">
            <tr>
                <td style="width: 151px; height: 22px;" align="right" width="151">
                </td>
                <td style="width: 145px; border-bottom: black 1px solid; height: 22px;" valign="bottom"
                    align="left" width="145" colspan="1" rowspan="1">
                    <ea:DataLabel ID="doZaplaty" runat="server" DataMember="Dokument.Wydruk.KierunekZapłaty"
                        Bold="False" Format="{0}:" EncodeHTML="True">
                    </ea:DataLabel>
                </td>
                <td style="font-weight: bold; font-size: 18px; border-bottom: black 1px solid;
                    height: 22px" valign="bottom" align="right">
                    <ea:DataLabel ID="DataLabel5" runat="server" DataMember="Dokument.BruttoCy" Bold="False"
                        Format="{0:+u}" EncodeHTML="True">
                    </ea:DataLabel>
                </td>
            </tr>
            <tr>
                <td style="width: 151px" align="right">
                </td>
                <td style="width: 145px" align="left">
                    <font size="2"><em>Słownie:</em></font>
                </td>
                <td align="right">
                    <font size="2"><em>
                        <ea:DataLabel ID="DataLabel6" runat="server" DataMember="Dokument.BruttoCy" Bold="False"
                            Format="{0:+t}" EncodeHTML="True">
                        </ea:DataLabel>
                    </em></font>
                </td>
            </tr>
        </table>
		
        <ea:Section ID="sectionWplaty" runat="server" DataMember="Dokument.Zaliczki">
            <em>Rozliczone zaliczki:<br>
            </em>
            <ea:Grid ID="Grid2" runat="server" DataMember="Dokument.Zaliczki" RowTypeName="Soneta.Handel.RelacjaZaliczki,Soneta.Handel"
                WithSections="False">
                <Columns>
                    <ea:GridColumn runat="server" Width="4" Align="Right" DataMember="#" Caption="Lp."
                        EncodeHTML="True">
                    </ea:GridColumn>
                    <ea:GridColumn runat="server" Width="20" DataMember="Zaplata.SposobZaplaty" Caption="Spos&#243;b zapłaty"
                        EncodeHTML="True">
                    </ea:GridColumn>
                    <ea:GridColumn runat="server" Width="15" Align="Center" DataMember="Zaplata.DataDokumentu"
                        Caption="Data zapłaty" EncodeHTML="True">
                    </ea:GridColumn>
                    <ea:GridColumn runat="server" Width="20" Align="Right" DataMember="Kwota" EncodeHTML="True">
                    </ea:GridColumn>
                    <ea:GridColumn runat="server" Width="25" DataMember="Zaplata.NumerDokumentu" Caption="Numer"
                        EncodeHTML="True">
                    </ea:GridColumn>
                </Columns>
            </ea:Grid>
			<br>
        </ea:Section>
		
        <ea:Section ID="Section1" runat="server" DataMember="Dokument.Wydruk.ZapłataCzęściowa">
            <em>
                <ea:DataLabel ID="DataLabel26" runat="server" DataMember="Dokument.Wydruk.Zapłacono"
                    Bold="False" EncodeHTML="True">
                </ea:DataLabel>
                <ea:DataLabel ID="DataLabel29" runat="server" DataMember="Dokument.Zapłata.SposobZaplaty.Biernik"
                    Bold="False" EncodeHTML="True">
                </ea:DataLabel>
                : <strong>
                    <ea:DataLabel ID="DataLabel12" runat="server" DataMember="Dokument.Zapłata.SłownieUpr"
                        Bold="False" EncodeHTML="True">
                    </ea:DataLabel>
                </strong>
			</em>
        </ea:Section>
		
        <ea:Section ID="Section2" runat="server" DataMember="Dokument.Wydruk.ZapłataCałkowita">
            <em>
                <ea:DataLabel ID="DataLabel4" runat="server" DataMember="Dokument.Wydruk.Zapłacono" EncodeHTML="True">
                </ea:DataLabel>
                <ea:DataLabel ID="DataLabel30" runat="server" DataMember="Dokument.Zapłata.SposobZaplaty.Biernik" EncodeHTML="True">
                </ea:DataLabel>
            </em>
        </ea:Section>
		
        <ea:Section ID="sectionNiezaplacone" runat="server" DataMember="Dokument.Wydruk.SąNiezapłacone">
			<em>Pozostało do zapłaty:</em>
			<ea:Grid ID="niezapłacone" runat="server" DataMember="Dokument.Wydruk.Niezapłacone"
				RowTypeName="Soneta.Kasa.Platnosc,Soneta.Kasa" OnBeforeRow="niezapłacone_BeforeRow" WithSections="False">
				<Columns>
					<ea:GridColumn runat="server" Width="4" Align="Right" DataMember="#" Caption="Lp." EncodeHTML="True">
					</ea:GridColumn>
					<ea:GridColumn runat="server" Width="20" DataMember="Płatność.SposobZaplaty" Caption="Spos&#243;b zapłaty" EncodeHTML="True">
					</ea:GridColumn>
					<ea:GridColumn runat="server" Width="15" Align="Center" DataMember="Płatność.Termin" Caption="Termin" EncodeHTML="True">
					</ea:GridColumn>
					<ea:GridColumn runat="server" Width="20" Align="Right" DataMember="Kwota" EncodeHTML="True">
					</ea:GridColumn>
					<ea:GridColumn runat="server" Caption="Płatnik" Format="{0:H}" ID="platnik" EncodeHTML="True">
					</ea:GridColumn>
				</Columns>
			</ea:Grid>
        </ea:Section>
		
		<ea:Section ID="sectionNumeryNadrzednych" runat="server" DataMember="Dokument.Wydruk.CzyDrukowacNumeryPowiazanych">
			<div style="margin: 5px 0px 5px 0px">
				<em>Dokumenty powiązane:</em>
				<div style="font-size: 13px; left: 10px; font-family: Tahoma; position: relative">
					<ea:DataLabel ID="labelNumeryNadrzednych" runat="server" DataMember="Dokument.Wydruk.NumeryNadrzędneZK" Bold="False"></ea:DataLabel>
					<ea:DataLabel ID="labelNumeryPodrzednych" runat="server" DataMember="Dokument.Wydruk.NumeryPodrzędneBK" Bold="False"></ea:DataLabel>
				</div>
			</div>
		</ea:Section>
		
		 <ea:Section runat="server" DataMember="Dokument.Wydruk.CzyDrukowacNumeryKorekt">
		 	<div style="margin: 5px 0px 5px 0px">
				<em>Poprzednie korekty:</em>
				<div style="font-size: 13px; left: 10px; font-family: Tahoma; position: relative">
					<ea:DataLabel runat="server" DataMember="Dokument.Wydruk.NumeryPoprzednichKorekt" Bold="false"></ea:DataLabel>
				</div>
			</div>
		</ea:Section>
	
		<ea:Section runat="server" DataMember="Dokument.Definicja.DrukowanieZestawieniaMagazynowych">
			<div style="margin: 5px 0px 5px 0px">
				<em>Powiązane dokumenty magazynowe:</em>
				<ea:Grid ID="Grid_Magazynowe" runat="server" RowTypeName="Soneta.Handel.DokumentHandlowy,Soneta.Handel" onBeforeRow="gridMagazynowe_BeforeRow">
					<Columns>
						<ea:GridColumn id="MagNumerCol" DataMember="Numer.NumerPelny" Caption="Dokument" runat="server" Width="20" Align="Center"></ea:GridColumn>
						<ea:GridColumn id="MagDataCol" DataMember="Data" Caption="Data wystawienia" runat="server" Width="20" Align="Center"></ea:GridColumn>
						<ea:GridColumn id="MagDataDostawyCol" DataMember="Dostawa.Termin" Caption="Data dostawy" runat="server" Width="20" Align="Center"></ea:GridColumn>
						<ea:GridColumn id="MagWartCol" Caption="Wartość" runat="server" Width="20" Align="Center"></ea:GridColumn>
					</Columns>
				</ea:Grid>
			</div>
		</ea:Section>
			
        <p style="font-family: Tahoma, Arial; font-size: 13px;">
            <ea:DataLabel ID="OpisDok" runat="server" DataMember="Dokument.Opis" Bold="False"> </ea:DataLabel>
        </p>
        <p style="font-family: Tahoma, Arial; font-size: 13px;">
            <ea:DataLabel ID="OpisWydruku" runat="server" DataMember="Dokument.Wydruk.OpisWydruku" Bold="False"> </ea:DataLabel>
        </p>
        <cc1:ReportFooter ID="ReportFooter1" runat="server" Height="105px" TheEnd="False">
            <Subtitles>
                <cc1:FooterSubtitle ID="stPodpis" runat="server" Caption="Operator" SubtitleType="CenterText"
                    Width="50">
                </cc1:FooterSubtitle>
                <cc1:FooterSubtitle ID="stOsoba" runat="server" Caption="Osoba" SubtitleType="CenterText"
                    Width="50">
                </cc1:FooterSubtitle>
            </Subtitles>
        </cc1:ReportFooter>
        <ea:SectionMarker ID="SectionMarker8" runat="server" SectionType="Footer">
        </ea:SectionMarker>
    </ea:DataRepeater>   
    </form>
</body>
</html>

