﻿<%@ Page language="c#" AutoEventWireup="false" codePage="1200" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Import Namespace="Soneta.Kadry" %>
<%@ Import Namespace="Soneta.Kadry.UI" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Tools" %>
<%@ Import Namespace="Soneta.Core" %>
<%@ Import Namespace="Soneta.Core.DbTuples" %>
<%@ Import Namespace="Soneta.Business.Db" %>
<%@ Import Namespace="System.Linq" %>
<%@ Import Namespace="System.IO" %>
<%@ Import Namespace="System.Collections.Generic" %>
<%@ Import Namespace="Microsoft.Extensions.DependencyInjection" %>
<%@ Import Namespace="Soneta.KadryPlace.Kadry.Workers" %>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<title>Teczka pracownicza</title>
		<script runat="server">

            public class ElementyStrukturyOrganizacyjnejLookupFlatViewInfo : ViewInfo {
                public ElementyStrukturyOrganizacyjnejLookupFlatViewInfo() {
                    ResourceName = "ElementyStrukturyOrganizacyjnejLookupFlatViewInfo";
                    CreateView += ElementyStrukturyOrganizacyjnejViewInfo_CreateView;
                }

                void ElementyStrukturyOrganizacyjnejViewInfo_CreateView(object sender, CreateViewEventArgs args) {
                    args.View.Condition &= GetCondition(args.Session);
                }

                public static RowCondition GetCondition(ISessionable session) {
                    ElementStrukturyOrganizacyjnej aktaD = TeczkaPracowniczaTools.WgNazwy(Wzor(session), "Akta osobowe");
                    ElementStrukturyOrganizacyjnej pozostaleD = TeczkaPracowniczaTools.WgNazwy(Wzor(session), "Pozostała dokumentacja");
                    IEnumerable<ElementStrukturyOrganizacyjnej> list = aktaD.SubDrzewo.Where(e => !e.Definicja.Warunek1).
                        Concat(pozostaleD.SubDrzewo.Where(e => !e.Definicja.Warunek1));
                    return new FieldCondition.In("ID", list.Select(e => (object)e.ID).ToArray());
                }
            }

            public class Params : ContextBase {
                public Params(Context context) : base(context) {
                    calosc = true;
                    zalaczniki = false;
                }

                bool calosc;
                [Priority(1)]
                [Caption("Pełna dokumentacja")]
                public bool Calosc {
                    get { return calosc; }
                    set {
                        calosc = value;
                        if (value)
                            zalaczniki = false;
                        OnChanged(EventArgs.Empty);
                    }
                }

                ElementStrukturyOrganizacyjnej[] katalog;
                [Caption("Wybrane części")]
                [Priority(2)]
                public ElementStrukturyOrganizacyjnej[] Katalog {
                    get { return katalog; }
                    set {
                        katalog = value;
                        OnChanged(EventArgs.Empty);
                    }
                }

                public bool IsReadOnlyKatalog() {
                    return calosc;
                }

                public object GetListKatalog() {
                    return new LookupInfo.TableItem(GetKatalogi()) {
                        ViewInfoType = typeof(ElementyStrukturyOrganizacyjnejLookupFlatViewInfo),
                        ComboBox = true
                    };
                }

                public Soneta.Business.View GetKatalogi() {
                    Soneta.Business.View view = CoreModule.GetInstance(Session).ElementyStrOrg.CreateView();
                    view.Condition &= ElementyStrukturyOrganizacyjnejLookupFlatViewInfo.GetCondition(Session);
                    view.Sort = "Nazwa";
                    return view;
                }

                bool zalaczniki;
                [Priority(3)]
                [Caption("Tylko załączniki")]
                public bool Zalaczniki {
                    get { return zalaczniki; }
                    set {
                        zalaczniki = value;
                        OnChanged(EventArgs.Empty);
                    }
                }
            }

            Params pars;
            [Context]
            public Params Pars {
                get { return pars; }
                set { pars = value; }
            }

            void OnContextLoad(Object sender, EventArgs args) {
                if (!pars.Calosc && (pars.Katalog == null || pars.Katalog.Length == 0))
                    throw new Exception("Wybierz katalogi z teczki pracowniczej");

                Pracownik pracownik = (Pracownik)dc.Context[typeof(Pracownik)];
                ElementStrukturyOrganizacyjnej aktaD = pracownik.Dokumenty.DefinicjaAktaOsobowe;
                ElementStrukturyOrganizacyjnej pozostaleD = pracownik.Dokumenty.DefinicjaPozostałeDokumenty;
                ElementStrukturyOrganizacyjnej akta = pracownik.Dokumenty.KatalogWgWzorcowy(aktaD, false);
                ElementStrukturyOrganizacyjnej pozostale = pracownik.Dokumenty.KatalogWgWzorcowy(pozostaleD, false);

                NumerTeczki.EditValue = pracownik.Last.NumerAkt;
                Imie.EditValue = pracownik.Imie;
                Nazwisko.EditValue = pracownik.Nazwisko;

                List<ElementStrukturyOrganizacyjnej> list = new List<ElementStrukturyOrganizacyjnej>();
                IEnumerable<ElementStrukturyOrganizacyjnej> lista = (!pars.Calosc) ?
                    pars.Katalog.ToArray<ElementStrukturyOrganizacyjnej>() :
                    pars.GetKatalogi().ToArray<ElementStrukturyOrganizacyjnej>();
                foreach (ElementStrukturyOrganizacyjnej wzor in lista) {
                    ElementStrukturyOrganizacyjnej root = pracownik.Dokumenty.KatalogWgWzorcowy(wzor, false);
                    if (root != null) {
                        var elements = root.SubDrzewo.Where(e => !e.Definicja.Warunek1).Concat(KatalogiWielokrotne(root));
                        foreach (ElementStrukturyOrganizacyjnej element in elements)
                            if (!list.Contains(element))
                                list.Add(element);
                    }
                    else
                        list.Add(wzor);
                }
                if (list.Contains(akta)) list.Remove(akta);
                if (list.Contains(pozostale)) list.Remove(pozostale);
                if (list.Contains(pozostaleD)) list.Remove(pozostaleD);
                if (!list.Contains(aktaD)) list.Add(aktaD);
                lista = list.OrderBy(p => p.Nazwa);

                string czesci = "";
                foreach (ElementStrukturyOrganizacyjnej element in lista)
                    if (element.Guid != aktaD.Guid)
                        czesci += (czesci != "" ? "<br/>" : "") + element.Nazwa;
                Czesci.EditValue = czesci;

                DataRepeater1.DataSource = lista.ToArray();
            }

            IEnumerable<ElementStrukturyOrganizacyjnej> KatalogiWielokrotne(ElementStrukturyOrganizacyjnej root) {
                if (root != null)
                    foreach (ElementStrukturyOrganizacyjnej e in root.WszystkieSubElementy.Where(s => s.Definicja.Warunek1))
                        yield return e;
            }

            ArrayList al = new ArrayList();
            ArrayList al2 = new ArrayList();

            void DataRepeater1_BeforeRow(Object sender, EventArgs args) {
                Pracownik pracownik = (Pracownik)dc.Context[typeof(Pracownik)];
                ElementStrukturyOrganizacyjnej aktaD = pracownik.Dokumenty.DefinicjaAktaOsobowe;
                ElementStrukturyOrganizacyjnej katalog = (ElementStrukturyOrganizacyjnej)DataRepeater1.CurrentRow;
                bool start = (aktaD != null && katalog != null) ? aktaD.Guid == katalog.Guid : false;

                SectionInfo.Visible = start;
                if (pars.Zalaczniki) {
                    SectionData.Visible = false;
                    SectionOnlyAttachments.Visible = true;
                    SectionAttachments.Visible = true;
                }
                else {
                    SectionData.Visible = !start;
                    SectionOnlyAttachments.Visible = false;
                    SectionAttachments.Visible = true;
                }

                al.Clear();
                al2.Clear();
                if (!start) {
                    Katalog.EditValue = katalog.Nazwa;

                    Soneta.Business.View view = CoreModule.GetInstance(dc).Tuples.CreateView();
                    view.Condition &= new FieldCondition.Equal("Host", pracownik);
                    view.Condition &= new RowCondition.Exists("PowiazaniaStrOrg", "Zrodlo",
                        new FieldCondition.Equal("Element", katalog));
                    foreach (DbTuple dokument in view) {
                        al.Add(dokument);
                        var ds = new List<GetMetaDataFromDbTupleWorker.DbTupleMetaData>();
                        GetMetaDataFromDbTupleWorker mdw = new GetMetaDataFromDbTupleWorker();
                        mdw.DbTuple = dokument;
                        al2.Add(mdw.MetaData);
                    }
                    Grid1.DataSource = al;
                    Grid2.DataSource = al2;
                }

                Attachments.SetRenderMethodDelegate(RenderAttachments);
            }

            void Grid1_OnBeforeRow(Object sender, RowEventArgs args) {
                //DbTuple dokument = (DbTuple)args.Row;
            }

            void Grid2_OnBeforeRow(Object sender, RowEventArgs args) {
                //DbTuple dokument = (DbTuple)args.Row;
            }

            private IOcrToolsService OcrService(ISessionable sessionable) {
                return sessionable.Session.GetService<IOcrToolsService>();
            }

            public void RenderAttachments(HtmlTextWriter output, System.Web.UI.Control parameterContainer) {
                string html = "";
                foreach (DbTuple dokument in al)
                    foreach (Attachment at in dokument.Attachments) {
                        if (!at.Name.ToLower().EndsWith(".pdf"))
                            continue;
                        try {
                            Stream reader = at.SaveToStream();
                            byte[] buffer = new byte[reader.Length];
                            reader.Read(buffer, 0, buffer.Length);
                            foreach (Soneta.Drawing.Img img in OcrService(dokument).ConvertPdfFileToImages(buffer, 1200)) {
                                string plik = Path.Combine(Path.GetTempPath(), Path.GetRandomFileName());
                                img.Save(plik);
                                html += string.Format("<p style='page-break-before: always'><img src='{0}' Width='100%'/></p>", plik);
                            }
                            reader.Close();
                        }
                        catch { }
                    }
                output.Write(html);
            }

            public static ElementStrukturyOrganizacyjnej Wzor(ISessionable session) {
                return KadryModule.GetInstance(session).Config.TeczkiPracownicze.WzórTeczkiPracowniczej;
            }

		</script>

		<meta content="Microsoft Visual Studio 7.0" name="GENERATOR">
		<meta content="C#" name="CODE_LANGUAGE">
		<meta content="JavaScript" name="vs_defaultClientScript">
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<body>
		<form id="ETeczka" method="post" runat="server">
			<ea:datacontext id="dc" runat="server" oncontextload="OnContextLoad" RightMargin="-1" LeftMargin="-1"></ea:datacontext>
            <ea:DataRepeater ID="DataRepeater1" runat="server" Width="100%" OnBeforeRow="DataRepeater1_BeforeRow">
                <ea:SectionMarker ID="SectionMarker9" runat="server"></ea:SectionMarker>
		        <ea:PageBreak ID="PageBreak1" runat="server" BreakFirstTimes="False"></ea:PageBreak>
                <ea:Section ID="SectionInfo" runat="server">
                    <table id="Table1" style="FONT-SIZE: 10pt; FONT-FAMILY: Tahoma; BORDER-COLLAPSE: collapse" width="100%" border="0">
				        <tr>
					        <td align="center" width="50%">
                                ..............................
                                <br />
                                pieczątka firmy
					        </td>
					        <td align="center" width="50%">
                                <ea:datalabel id="NumerTeczki" runat="server"></ea:datalabel>
                                <br />
                                ..............................
                                <br />
                                numer teczki
					        </td>
                        </tr>
                    </table>
                    <br /><br /><br /><br /><br /><br /><br /><br />
		            <p align="center">
                        <font face="Tahoma" size="8">Teczka</font>
                        <br />
		                <font face="Tahoma" size="5">akt osobowych</font>
                        <ea:Section ID="SectionOnlyAttachments" runat="server">
                            <br /><br />
		                    <font face="Tahoma" size="4">Tylko załączniki</font>
                        </ea:Section>
                    </p>
		            <p align="center">
                        <font face="Tahoma" size="3">
                            <ea:datalabel id="Czesci" runat="server"></ea:datalabel>
                        </font>
                    </p>
                    <br />
		            <p align="center">
                        <font face="Tahoma" size="3">
                            <ea:datalabel id="Imie" runat="server"></ea:datalabel>
                            <br />
                            ............................................................
                            <br />
                            Imię
                            <br /><br /><br /><br />
                            <ea:datalabel id="Nazwisko" runat="server"></ea:datalabel>
                            <br />
                            ............................................................
                            <br />
                            Nazwisko
                        </font>
                    </p>
                </ea:Section>
                <ea:Section ID="SectionAll" runat="server">
		            <font face="Tahoma" size="3">
                        <p align="center">
                            <ea:datalabel id="Katalog" runat="server"></ea:datalabel>
                        </p>
                    </font>
                    <br />
                    <ea:Section ID="SectionData" runat="server">
                        <ea:grid id="Grid1" runat="server" onbeforerow="Grid1_OnBeforeRow" ColumnTextFontSize="12" ColumnHeaderFontSize="12">
				            <Columns>
					            <ea:GridColumn runat="server" Width="10" Align="Center" DataMember="#" Caption="Lp" NoWrap="True" VAlign="Top"></ea:GridColumn>
					            <ea:GridColumn runat="server" Align="Left" DataMember="Nazwa" Caption="Dokument" NoWrap="True" VAlign="Top"></ea:GridColumn>
				            </Columns>
			            </ea:grid>
                        <br />
		                <font face="Tahoma" size="2">Metryka</font>
                        <ea:grid id="Grid2" runat="server" onbeforerow="Grid2_OnBeforeRow">
				            <Columns>
                                <ea:GridColumn runat="server" Caption="Lp" Width="4" DataMember="#"></ea:GridColumn>
                                <ea:GridColumn runat="server" Caption="Identyfikator dokumentu" DataMember="Dokument.IdentyfikatorDokumentu"></ea:GridColumn>
                                <ea:GridColumn runat="server" Caption="Identyfikator dokumentacji" DataMember="IdentyfikatorDokumentacji"></ea:GridColumn>
                                <ea:GridColumn runat="server" Caption="Rodzaj dokumentu" DataMember="Dokument.OpisDokumentu"></ea:GridColumn>
                                <ea:GridColumn runat="server" Caption="Data powstania dokumentu" DataMember="Dokument.DataUtworzeniaDokumentu"></ea:GridColumn>
                                <ea:GridColumn runat="server" Caption="Data podpisu" DataMember="Dokument.DataPieczeci"></ea:GridColumn>
                                <ea:GridColumn runat="server" Caption="Numer Pesel/Dokument tożsamości" DataMember="IdentyfikatorPracownika"></ea:GridColumn>
                                <ea:GridColumn runat="server" Caption="Imię i nazwisko pracownika" DataMember="PracownikImieNazwisko"></ea:GridColumn>
                                <ea:GridColumn runat="server" Caption="Nazwa pracodawcy" DataMember="NazwaPracodawcy"></ea:GridColumn>
                                <ea:GridColumn runat="server" Caption="Data utworzenia" DataMember="DataEksportu"></ea:GridColumn>
				            </Columns>
                        </ea:grid>
                    </ea:Section>
                </ea:Section>
                <ea:Section ID="SectionAttachments" runat="server">
                    <ea:Section runat="server" ID="Attachments" />
                </ea:Section>
		        <ea:SectionMarker ID="SectionMarker8" runat="server" SectionType="Footer"></ea:SectionMarker>
            </ea:DataRepeater>
        </form>
	</body>
</HTML>
