﻿<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Page language="c#" AutoEventWireup="false" codePage="1200" %>
<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="Soneta.Business" %>
<%@ import Namespace="Soneta.Business.App" %>
<%@ import Namespace="Soneta.CRM" %>
<%@ import Namespace="Soneta.Zadania" %>
<%@ import Namespace="Soneta.Tools" %>
<%@ import Namespace="Soneta.Core" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<TITLE>Kalendarz operatora</TITLE>
		<META content="C#" name="CODE_LANGUAGE">
		<META content="JavaScript" name="vs_defaultClientScript">
		<META content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
		<script runat="server">

			
		            
    // Klasa pojedynczego zadania drukowanego w kalendarzu
            class ZadanieCell : IComparable
            {
               
                string opis = "";
                string status = "";
                FromTo okres;
                Time godz_od;
                Time godz_do;
                public ZadanieCell(string nazwa, Time godzOd, Time godzDo)
                {
                    opis = nazwa;
                    godz_od = godzOd;
                    godz_do = godzDo;
                }
                public ZadanieCell(string nazwa, Time godzOd, Time godzDo, string stan)
                {
                    opis = nazwa;
                    status = stan;
                    godz_od = godzOd;
                    godz_do = godzDo;
                }

                public string Opis
                {
                    get { return opis; }
                }
                public string Status
                {
                    get { return status; }
                }
                public Time CzasOd
                {
                    get { return godz_od; }
                }
                public Time CzasDo
                {
                    get { return godz_do; }
                }


                public int CompareTo(object obj)
                {
                    ZadanieCell zadanie = (ZadanieCell)obj;
                    return godz_od.CompareTo(zadanie.CzasOd);
                }

            }
		    // Klasa pojedynczego wiersza drukowanego w kalendarzu
		    // Wiersz zawierać może wiele zadań, nie zachodzących na siebie
		    class ZadanieRow
            {
                ArrayList zadania;
                Time godz_od;
                Time godz_do;
                KalendarzTable kal;
                 
                public ZadanieRow(KalendarzTable kalendarz, Time godzOd, Time godzDo)
                {
                    zadania = new ArrayList();
                    godz_od = godzOd;
                    godz_do = godzDo;
                    kal = kalendarz;
                }
                public void DodajZadanie(ZadanieCell zadanie)
                {
                    zadania.Add(zadanie);
                    zadania.Sort();
                }
                public ArrayList Zadania
                {
                    get { return zadania; }
                }
                public string Tabela
                {
                    get
                    {
                        string pustakomorka = "<td style='" + kal.StylKolor(false) + "'>&nbsp;</td>";
                        string retVal = "<EA:SECTION TYPE=\"BODY\" /><tr>";
                        Time t0 = new Time(0);
                        foreach (ZadanieCell z in zadania)
                        {
                            if (z.CzasOd > t0 && t0.TotalMinutes == 0 && godz_od.TotalMinutes > 0)
                            {
                                //dodajemy pierwszą kratkę
                                retVal += pustakomorka;
                                t0 = godz_od;
                            }
                            // dodajemy puste kratki przed zadaniem
                            for (Time t = t0; t < z.CzasOd; t = new Time(t.TotalMinutes + 15))
                            {
                                retVal += pustakomorka;
                            }
                            // dodajemy kratkę z zadaniem
                            int dlugosc = ((z.CzasDo > godz_do ? godz_do.TotalMinutes : z.CzasDo.TotalMinutes) - (z.CzasOd < godz_od ? godz_od.TotalMinutes : z.CzasOd.TotalMinutes)) / 15
                                + (z.CzasDo > godz_do ? 1 : 0) + (z.CzasOd < godz_od ? 1 : 0);

                            retVal += "<td align=center colspan=" + dlugosc.ToString() + " style='" + kal.StylKolor(z.Status) + "'>"
                                + z.Opis + "</td>";

                            t0 = z.CzasDo;
                        }
                        //dodajemy puste kratki po zadaniu
                        for (Time t = t0; t < godz_do; t = new Time(t.TotalMinutes + 15))
                        {
                            retVal += pustakomorka;
                        }
                        if (t0 < new Time(24, 0) && godz_do < new Time(24, 0))
                        {
                            //dodajemy ostatnią kratkę
                            retVal += pustakomorka;
                        }

                        retVal += "</tr>";
                        return retVal;
                    }
                }
            }    

		    // klasa danych dnia
		    class DzienTable
            {
                ArrayList wiersze = new ArrayList();
                Date dzien;
                Time godzOd;
                Time godzDo;
                KalendarzTable kal;
                public DzienTable(KalendarzTable kalendarz, Date data, Time godz_od, Time godz_do)
                {
                    dzien = data;
                    godzOd = godz_od;
                    godzDo = godz_do;
                    kal = kalendarz;
                }
                public void DodajZadanie(string opis, Date data_od, Time czas_od, Date data_do, Time czas_do, string status)
                {
                    if (data_od > dzien) return;
                    if (data_do < dzien) return;
                    if (data_od < dzien || data_od == dzien && czas_od < godzOd) czas_od = new Time(0);
                    if (data_do > dzien || data_do == dzien && czas_do > godzDo) czas_do = new Time(24, 0);
                    if (czas_od.TotalMinutes < 0) czas_od = new Time(0);
                    if (czas_do.TotalMinutes <= 0) czas_do = new Time(24, 0);

                    czas_od = kal.ZaokraglijCzas(czas_od);
                    czas_do = kal.ZaokraglijCzas(czas_do);
                    if (data_od > data_do)
                        throw new Exception("Data początkowa zadania nie może być większa od daty końcowej");


                    ZadanieCell zadanie = new ZadanieCell(opis, czas_od, czas_do, status);
                    bool added = false;
                    foreach (ZadanieRow w in wiersze)
                    {
                        Time t0 = new Time(0);
                        foreach (ZadanieCell z in w.Zadania)
                        {
                            if (zadanie.CzasOd>=t0 && zadanie.CzasDo <= z.CzasOd)
                            {
                                w.DodajZadanie(zadanie);
                                added = true;
                            }
                            if (added) break;
                            t0 = z.CzasDo;
                        }
                        if (!added && zadanie.CzasOd >= t0)
                        {
                            w.DodajZadanie(zadanie);
                            added = true;
                        }
                        if (added) break;
                    }
                    if (!added)
                    {
                        ZadanieRow w = new ZadanieRow(kal, godzOd, godzDo);
                        w.DodajZadanie(zadanie);
                        wiersze.Add(w);
                    }
                }
                public Date Dzien
                {
                    get { return dzien; }
                }
              
                public ArrayList Wiersze
                {
                    get { return wiersze; }
                }
                public string Tabela
                {
                    get
                    {
                        if (wiersze.Count == 0 && !kal.DrukowacPuste)
                            return "";

                        string headertd = "<th style='" + kal.StylKolor(true) + "' ";
                        string retVal = "<EA:SECTION TYPE=\"BODY\" /><EA:SECTION TYPE=\"HEADER\" /><table cellspacing=0 cellpadding=1 border=1 cellspacing=0 cellpadding=0 style='FONT-SIZE: 7pt; FONT-FAMILY: Tahoma; BORDER-COLLAPSE: collapse; overflow: hidden; table-layout: fixed; width=100%'>";
                        //wiersz nagłówkowy
                        int dlugosc = (godzDo.TotalMinutes - godzOd.TotalMinutes) / 15
                            + (godzOd.TotalMinutes > 0 ? 1 : 0) + (godzDo < new Time (24, 0) ? 1 : 0);
                        retVal += "<tr>" + headertd + "align=center colspan=" + dlugosc.ToString() + ">"
                            + "<b>" + dzien.ToString("dddd") + ", " + dzien.ToString() + "</b></th></tr>";

                        retVal += "<tr>";
                        // nagłówek z godzinami
                        if (godzOd.TotalMinutes > 0)
                            retVal += headertd + ">...</th>";

                        dlugosc = 0;
                        string godzina = "";
                        for (Time t = godzOd; t < godzDo; t = new Time(t.TotalMinutes + 15))
                        {
                            dlugosc++;
                            if (dlugosc == 1)
                            {
                                godzina = t.ToString();
                            }
                            if (t.TotalMinutes % 60 == 45)
                            {
                                retVal += headertd + " colspan=" + dlugosc.ToString() + ">" + godzina + "</th>";
                                dlugosc = 0;
                            }
                        }
                        if (dlugosc > 0)
                        {
                            retVal += headertd + " colspan=" + dlugosc.ToString() + ">" + godzina + "</th>";
                        }

                        if (godzDo < new Time(24, 0))
                            retVal += headertd + ">...</th>";

                        foreach (ZadanieRow z in wiersze)
                        {
                            retVal += z.Tabela;
                        }
                        retVal += "<EA:SECTION TYPE=\"FOOTER\" /></table><br/>";
                        return retVal;
                    }
                }
            }  
		    
		    // Klasa kalendarza
            class KalendarzTable
            {
                Date dataOd;
                Date dataDo;
                Time czasOd;
                Time czasDo;
                ArrayList listaDni = new ArrayList();
                ArrayList listaStanow = new ArrayList();
                bool drukowackolory = false;
                bool drukowacpuste = false;
                bool ustawionoDaty = false;
                
                public KalendarzTable(Date data_od, Time czas_od, Date data_do, Time czas_do)
                {
                    
                    dataOd = data_od;
                    dataDo = data_do;
                    czasOd = ZaokraglijCzas(czas_od);
                    czasDo = ZaokraglijCzas(czas_do);
                    SprawdzDaty(true);   
                    for (Date d = data_od; d <= data_do; d++)
                    {
                        listaDni.Add(new DzienTable(this, d, czas_od, czas_do));
                    }
                }
                private void SprawdzDaty(bool throwerror)
                {
                    if (dataOd == Date.MinValue
                        || dataOd == Date.MaxValue
                        || dataDo == Date.MinValue
                        || dataDo == Date.MaxValue)
                    {
                        if (throwerror)
                            throw new Exception("Daty dla kalendarza muszą być określone");
                        else
                            ustawionoDaty = false;
                    }                            
                }
                private int SprawdzStan(string status)
                {
                    if (status == "") return -1;
                    bool found = false;
                    int i = 0;
                    foreach (string s in listaStanow)
                    {
                        if (s == status)
                        {
                            found = true;
                            break;
                        }
                        i++;
                    }
                    if (found)
                        return i;
                    else
                    {
                        listaStanow.Add(status);
                        return listaStanow.Count - 1;
                    }
                }
                public string StylKolor(string status)
                {
                    if (!drukowackolory)
                        return "";

                    int kod = System.Math.Abs(status.GetHashCode()) % (256 * 256 * 256);
                    string styl = kod.ToString("x");
                    while (styl.Length < 6) styl = "0" + styl;
                    styl = "background-color: #" + styl;
                    //na ciemnym tle drukujemy białe litery
                    int jasnosc = (kod % 256) + 2*(((kod - kod % 256) / 256) % 256) + (((kod - kod % (256 * 256)) / (256 * 256)) % 256);
                    if (jasnosc < 512)//((kod % 256) + 2 * (((kod - kod % 256) / 256) % 256) + 2 * (((kod - kod % (256 * 256)) / (256 * 256)) % 256) < 768)
                        styl += "; color: White";
                    return styl ;
                }
                public string StylKolor(bool naglowek)
                {
                    if (!drukowackolory)
                        return "";
                    if (naglowek)
                        return "background-color: #ffffa0;";
                    else
                        return "background-color: LightYellow;";
                }

                public Time ZaokraglijCzas(Time czas)
                {
                    int zaokr = 15;
                    int odciecie = zaokr / 2;
                    int koncowka = czas.TotalMinutes % 15;
                    Time retVal;
                    if (koncowka <= odciecie)
                        retVal = new Time(czas.TotalMinutes - koncowka);
                    else
                        retVal = new Time(czas.TotalMinutes - koncowka + zaokr);
                    return retVal;

                }
                
                public bool DrukowacKolory
                {
                    set { drukowackolory = value; }
                    get { return drukowackolory; }
                }
                public bool DrukowacPuste
                {
                    set { drukowacpuste = value; }
                    get { return drukowacpuste; }
                }
                        
                public void DodajZadanie(string opis, Date data_od, Time czas_od, Date data_do, Time czas_do)
                {
                     DodajZadanie(opis, data_od, czas_od, data_do, czas_do, "");
                }
                public void DodajZadanie(string opis, Date data_od, Time czas_od, Date data_do, Time czas_do, string stan)
                {
                    foreach (DzienTable dt in listaDni)
                    {
                        dt.DodajZadanie(opis, data_od, czas_od, data_do, czas_do, stan);
                        int i = SprawdzStan(stan);
                    }
                }

                public string Tabela
                {
                    get
                    {

                        string retVal = "";
                        foreach (DzienTable dt in listaDni)
                        {
                            retVal += dt.Tabela;
                        }

                        if (drukowackolory && listaStanow.Count > 0)
                        {
                            retVal += "<EA:SECTION TYPE=\"BODY\" />"
                                + "<p style='font-size: 8pt; font-family: Tahoma; margin-bottom:0; margin-top:6px;'>Legenda:</p>"
                                + "<table cellspacing=0 cellpadding=1 border=1 cellspacing=0 cellpadding=0 style='FONT-SIZE: 7pt; FONT-FAMILY: Tahoma; BORDER-COLLAPSE: collapse; overflow: hidden; table-layout: fixed; width=30%'>";
                            listaStanow.Sort();
                            foreach (string stan in listaStanow)
                                retVal += "<tr><td style='" + StylKolor(stan) + "'>" + Soneta.HTML.HtmlParser.HtmlEncode(stan) + "</td></tr>";
                            retVal += "</table>";


                        }
                        
                        return retVal;
                    }
                }
            }

            /////////////////////////////////////////////////////////////////		    
            public enum KoloryWgEnum
            {
                [Caption("Brak")]
                Brak = 1,
                [Caption("Wg stanu")]
                WgStanu = 2,
                [Caption("Wg priorytetu")]
                WgPriorytetu = 3,
                [Caption("Wg operatora")]
                WgOperatora = 4
            };

            public class Params : ContextBase
            {
                

                public Params(Context cx)
                    : base(cx)
                {
                }

                Time czasOd = new Time(9, 0);
                [Caption("Od godziny:")]
                [Priority(2)]
                public Time CzasOd
                {
                    get { return czasOd; }
                    set { czasOd = value; }
                }
                Time czasDo = new Time(17, 0);
                [Caption("Do godziny:")]
                [Priority(3)]
                public Time CzasDo
                {
                    get { return czasDo; }
                    set { czasDo = value; }
                }

                bool drukujpuste = false;
                [Caption("Dni bez zadań:")]
                [Priority(4)]
                public bool DrukujPuste
                {
                    get { return drukujpuste; }
                    set { drukujpuste = value; }
                }

                KoloryWgEnum kolorywg = KoloryWgEnum.Brak;

                [Caption("Drukowanie kolorów:")]
                [Priority(5)]
                public KoloryWgEnum KoloryWg
                {
                    get { return kolorywg; }
                    set { kolorywg = value; }
                }
            }

            Params param = null;
            [Context]
            public Params Param
            {
                get { return param; }
                set { param = value; }
            }

            /////////////////////////////////////////////////////////////////		    
            /////////////////////////////////////////////////////////////////		    

            void OnContextLoad(Object sender, EventArgs args)
            {
                ZadaniaParams ZadaniaParametry = null;
                ZadaniaParametry = (ZadaniaParams)dc[typeof(ZadaniaParams)];

                ReportHeader.Title = String.Format("Zadania {0}|okres: {1}|stan realizacji: {2}",
                    (ZadaniaParametry.Kontrahent == null ? "" : "kontrahenta " + ZadaniaParametry.Kontrahent.Kod),
                    ZadaniaParametry.Okres,
                    ZadaniaParametry.StanRealizacji);

                Row[] rows = (Row[])dc[typeof(Row[])];

                // ustalenie dat
                Date data_od = ZadaniaParametry.Okres.From;
                Date data_do = ZadaniaParametry.Okres.To;
                if (data_od == Date.MaxValue
                    || data_od == Date.MinValue
                    || data_do == Date.MaxValue
                    || data_do == Date.MinValue)
                {
                    foreach (object o in rows)
                    {
                        if (o.GetType() == typeof(Zadanie))
                        {
                            Zadanie z = (Zadanie)o;
                            if (z.DataOd > Date.MinValue && (z.DataOd < data_od || data_od == Date.MinValue))
                            {
                                data_od = z.DataOd;
                            }
                            if (z.DataDo < Date.MaxValue && (z.DataDo > data_do || data_do == Date.MaxValue))
                            {
                                data_do = z.DataDo;
                            }
                        }
                        else if (o.GetType() == typeof(Kontrahent))
                        {
                            Kontrahent k = (Kontrahent)o;
                            foreach (Zadanie z in k.Zadania)
                            {
                                if (z.Rodzaj == RodzajZadania.Zdarzenie
                                    || ZadaniaParametry.StanRealizacji == StanyRealizacjiZadania.Otwarte && !z.Aktywny
                                    || ZadaniaParametry.StanRealizacji == StanyRealizacjiZadania.Zamknięte && z.Aktywny)
                                    continue;

                                if (z.DataOd > Date.MinValue && (z.DataOd < data_od || data_od == Date.MinValue))
                                {
                                    data_od = z.DataOd;
                                }
                                if (z.DataDo < Date.MaxValue && (z.DataDo > data_do || data_do == Date.MaxValue))
                                {
                                    data_do = z.DataDo;
                                }
                            }
                        }


                    }
                    rows.GetEnumerator().Reset();

                }
                KalendarzTable kalendarz = new KalendarzTable(data_od, Param.CzasOd, data_do, Param.CzasDo);// (ZadaniaParametry.Okres);
                kalendarz.DrukowacPuste = Param.DrukujPuste;
                kalendarz.DrukowacKolory = (Param.KoloryWg == KoloryWgEnum.Brak ? false : true);


                foreach (object o in rows)
                {
                    if (o.GetType() == typeof(Zadanie))
                    {
                        Zadanie z = (Zadanie)o;
                        kalendarz.DodajZadanie(
                            z.Nazwa + (z.Kontrahent == null ? "" : " (" + z.Kontrahent.Kod + ")"),
                            z.DataOd,
                            z.CzasOd,
                            z.DataDo,
                            z.CzasDo,
                            Param.KoloryWg == KoloryWgEnum.WgStanu && z.StanZadania != null ? z.StanZadania.Kod : (Param.KoloryWg == KoloryWgEnum.WgPriorytetu && z.PriorytetZadania != null ? z.PriorytetZadania.Kod : (Param.KoloryWg == KoloryWgEnum.WgOperatora && z.Wykonujacy != null ? z.Wykonujacy.FullName : ""))
                        );
                            
                    }
                    else if (o.GetType() == typeof(Kontrahent))
                    {
                        Kontrahent k = (Kontrahent)o;
                        foreach (Zadanie z in k.Zadania)
                        {
                            if (z.Rodzaj == RodzajZadania.Zdarzenie
                                || ZadaniaParametry.StanRealizacji == StanyRealizacjiZadania.Otwarte && !z.Aktywny
                                || ZadaniaParametry.StanRealizacji == StanyRealizacjiZadania.Zamknięte && z.Aktywny)
                                continue;
                            kalendarz.DodajZadanie(
                                z.Nazwa + (z.Wykonujacy == null ? "" : " (" + z.Wykonujacy.Name + ")"),
                                z.DataOd,
                                z.CzasOd,
                                z.DataDo,
                                z.CzasDo,
                                Param.KoloryWg == KoloryWgEnum.WgStanu && z.StanZadania != null ? z.StanZadania.Kod : (Param.KoloryWg == KoloryWgEnum.WgPriorytetu && z.PriorytetZadania != null ? z.PriorytetZadania.Kod : (Param.KoloryWg == KoloryWgEnum.WgOperatora && z.Wykonujacy != null ? z.Wykonujacy.FullName : ""))
                            );
                        }
                    }


                }
                DataLabelKalendarz.EditValue = kalendarz.Tabela;
            }
		    
            void Msg(object o)
            {
            }    
        </script>
	</HEAD>
	<BODY>
		<FORM method="post" runat="server">
			<ea:DataContext id="dc" runat="server" OnContextLoad="OnContextLoad"></ea:DataContext>
			<eb:ReportHeader id="ReportHeader" runat="server" title="Kalendarz operatora|MojeZadania: {0}|ZleconePrzezeMnie: {1}" DataMember0="ZadaniaParams.MojeZadania" DataMember1="ZadaniaParams.ZleconePrzezeMnie"></eb:ReportHeader>
            <ea:DataLabel ID="DataLabelKalendarz" runat="server" Font-Names="Tahoma" Font-Size="8pt"></ea:DataLabel>
			<eb:ReportFooter id="ReportFooter" runat="server"></eb:ReportFooter>
		</FORM>
	</BODY>
</HTML>

