﻿<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Page language="c#" AutoEventWireup="false" codePage="1200" %>
<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="Soneta.Business" %>
<%@ import Namespace="Soneta.Business.App" %>
<%@ import Namespace="Soneta.CRM" %>
<%@ import Namespace="Soneta.Zadania" %>
<%@ import Namespace="Soneta.Tools" %>
<%@ import Namespace="Soneta.Core" %>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<TITLE>Zadania</TITLE>
		<META content="C#" name="CODE_LANGUAGE">
		<META content="JavaScript" name="vs_defaultClientScript">
		<META content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
		<script runat="server">

            // Klasa pojedynczego zadania drukowanego w kalendarzu
            class ZadanieCell : IComparable
            {
                string opis = "";
                string status = "";
                FromTo okres;
                public ZadanieCell(string nazwa, FromTo od_do)
                {
                    opis = nazwa;
                    okres = od_do;
                }
                public ZadanieCell(string nazwa, Date data_od, Date data_do)
                {
                    opis = nazwa;
                    okres = new FromTo(data_od, data_do);
                }
                public ZadanieCell(string nazwa, Date data_od, Date data_do, string stan)
                {
                    opis = nazwa;
                    okres = new FromTo(data_od, data_do);
                    status = stan;
                }

                public string Opis
                {
                    get { return opis; }
                }
                public string Status
                {
                    get { return status; }
                }
                public FromTo Okres
                {
                    get { return okres; }
                }
                public Date DataOd
                {
                    get { return okres.From; }
                }
                public Date DataDo
                {
                    get { return okres.To; }
                }

                public int CompareTo(object obj)
                {
                    ZadanieCell zadanie = (ZadanieCell)obj;
                    return okres.From.CompareTo(zadanie.DataOd);
                }

            }
            // Klasa pojedynczego wiersza drukowanego w kalendarzu
            // Wiersz zawierać może wiele zadań, nie zachodzących na siebie
            class ZadanieRow
            {
                ArrayList zadania;
                public ZadanieRow()
                {
                    zadania = new ArrayList();
                }
                public void DodajZadanie(ZadanieCell zadanie)
                {
                    zadania.Add(zadanie);
                    zadania.Sort();
                }
                public ArrayList Zadania
                {
                    get { return zadania; }
                }
            }

            // klasa danych obiektu z wierszami zawierającymi zadania
            class ObiektRow
            {
                ArrayList wiersze = new ArrayList();
                object obiekt;
                public ObiektRow(object o)
                {
                    obiekt = o;
                }
                public void DodajZadanie(ZadanieCell zadanie)
                {
                    bool added = false;
                    foreach (ZadanieRow w in wiersze)
                    {
                        Date d0 = Date.MinValue;
                        foreach (ZadanieCell z in w.Zadania)
                        {
                            if (zadanie.DataOd > d0 && zadanie.DataDo < z.DataOd)
                            {
                                w.DodajZadanie(zadanie);
                                //w.Zadania.Add(zadanie);

                                added = true;
                            }
                            if (added) break;
                            d0 = z.DataDo;
                        }
                        if (!added && zadanie.DataOd > d0)
                        {
                            w.DodajZadanie(zadanie);
                            //w.Zadania.Add(zadanie);
                            added = true;
                        }
                        if (added) break;
                    }
                    if (!added)
                    {
                        ZadanieRow w = new ZadanieRow();
                        w.DodajZadanie(zadanie);
                        //w.Zadania.Add(zadanie);
                        wiersze.Add(w);
                    }
                }
                public object Obiekt
                {
                    get { return obiekt; }
                }
                public ArrayList Wiersze
                {
                    get { return wiersze; }
                }
            }

            // Klasa kalendarza
            class KalendarzTable
            {
                Date DataOd;
                Date DataDo;
                Hashtable ListaOperatorow = new Hashtable();
                string naglowek = "Zasób";
                ArrayList listaStanow = new ArrayList();
                bool drukowackolory = false;
                bool ustawionoDaty;

                public KalendarzTable(Date data_od, Date data_do)
                {
                    DataOd = data_od;
                    DataDo = data_do;
                    SprawdzDaty(false);                    
                }
                public KalendarzTable(FromTo okres)
                {
                    DataOd = okres.From;
                    DataDo = okres.To;
                    SprawdzDaty(false);
                }
                
                private void SprawdzDaty(bool throwerror)
                {
                    if (DataOd == Date.MinValue
                        || DataOd == Date.MaxValue
                        || DataDo == Date.MinValue
                        || DataDo == Date.MaxValue)
                    {
                        if (throwerror)
                            throw new Exception("Daty dla kalendarza muszą być określone");
                        else
                            ustawionoDaty = false;
                    }
                    else
                        ustawionoDaty = true;
                }
                private int SprawdzStan(string status)
                {
                    if (status == "") return -1;
                    bool found = false;
                    int i = 0;
                    foreach (string s in listaStanow)
                    {
                        if (s == status)
                        {
                            found = true;
                            break;
                        }
                        i++;
                    }
                    if (found)
                        return i;
                    else
                    {
                        listaStanow.Add(status);
                        return listaStanow.Count - 1;
                    }
                }
                public string StylKolor(string status)
                {
                    if (!drukowackolory)
                        return "";

                    int kod = System.Math.Abs(status.GetHashCode()) % (256 * 256 * 256);
                    string styl = kod.ToString("x");
                    while (styl.Length < 6) styl = "0" + styl;
                    styl = "background-color: #" + styl;
                    //na ciemnym tle drukujemy białe litery
                    if ((kod % 256) + 2*(((kod - kod % 256) / 256) % 256) + (((kod - kod % (256 * 256)) / (256 * 256)) % 256) < 512)
                        styl += "; color: White";
                    return styl;
                }
                public string StylKolor(bool naglowek)
                {
                    if (!drukowackolory)
                        return "";
                    if (naglowek)
                        return "background-color: #ffffa0;";
                    else
                        return "background-color: LightYellow;";
                }

                public string NazwaObiektu
                {
                    set { naglowek = value; }
                    get { return naglowek; }
                }
                public bool DrukowacKolory
                {
                    set { drukowackolory = value; }
                    get { return drukowackolory; }
                }

                public void DodajZadanie(object o, string opis, Date data_od, Date data_do)
                {
                    DodajZadanie(o, new ZadanieCell(opis, data_od, data_do));
                }
                public void DodajZadanie(object o, string opis, Date data_od, Date data_do, string stan)
                {

                    DodajZadanie(o, new ZadanieCell(opis, data_od, data_do, stan));
                }
                public void DodajZadanie(object o, ZadanieCell zadanie)
                {

                    ObiektRow wiersz_obiektu = (ObiektRow)ListaOperatorow[o];
                    if (wiersz_obiektu == null)
                        ListaOperatorow.Add(o, wiersz_obiektu = new ObiektRow(o));
                    wiersz_obiektu.DodajZadanie(zadanie);

                    int i = SprawdzStan(zadanie.Status);
                    if (!ustawionoDaty)
                    {
                        
                        if (zadanie.DataOd > Date.MinValue && (zadanie.DataOd < DataOd || DataOd == Date.MinValue))
                        {
                            DataOd = zadanie.DataOd;
                        }
                        if (zadanie.DataDo < Date.MaxValue && (zadanie.DataDo > DataDo || DataDo == Date.MaxValue))
                        {
                            DataDo = zadanie.DataDo;
                        }
                    }

                }

                public string Tabela
                {
                    get
                    {
                        SprawdzDaty(true);
                        
                        // ustalenie szerokości pojedynczej komórki z datą
                        int szerokosc = 90 / ((int)(DataDo - DataOd) + 1);

                        string pustaKomorka = "<td style='" + StylKolor(false) + "'>&nbsp;</td>";

                        // utworzenie nagłówka tabeli
                        string tab = "<EA:SECTION TYPE=\"BODY\" /><EA:SECTION TYPE=\"HEADER\" /><table cellspacing=0 cellpadding=1 border=1 cellspacing=0 cellpadding=0 style='FONT-SIZE: 7pt; FONT-FAMILY: Tahoma; BORDER-COLLAPSE: collapse; overflow: hidden; table-layout: fixed; width=100%'>";

                        // nagłowek tabeli
                        tab += "<tr><th style='" + StylKolor(true) + "' rowspan=2 width=10%><b>" + Soneta.HTML.HtmlParser.HtmlEncode(naglowek) + "</b></th>";

                        // nagłówek - miesiące
                        Date d0 = DataOd;
                        do
                        {
                            int dlugosc;

                            if (DataDo > d0.LastDayMonth())
                                dlugosc = (int)(d0.LastDayMonth() - d0) + 1;
                            else
                                dlugosc = (int)(DataDo - d0) + 1;


                            tab += "<th style='" + StylKolor(true) + "' align=center colspan=" + dlugosc.ToString() + "><b>"
                            + d0.ToString("MMMM")
                            + "</b></th>";
                            d0 = d0.LastDayMonth() + 1;
                        } while (d0 <= DataDo);
                        tab += "</tr>";

                        // nagłówek - dni
                        tab += "<tr>";
                        for (Date d = DataOd; d <= DataDo; d++)
                            tab += "<th style='" + StylKolor(true) + "' align=center><b>" + d.Day.ToString() + "</b></th>";


                        tab += "</tr>";

                        foreach (ObiektRow o in ListaOperatorow.Values)
                        {
                            tab += "<EA:SECTION TYPE=\"BODY\" /><tr><td style='" + StylKolor(true) + "' rowspan=" + o.Wiersze.Count.ToString() + ">"
                                + "<b>" + Soneta.HTML.HtmlParser.HtmlEncode(o.Obiekt.ToString()) + "</b></td>";

                            int wiersznr = 1;
                            foreach (ZadanieRow w in o.Wiersze)
                            {
                                if (wiersznr > 1)
                                    tab += "<tr>";
                                d0 = DataOd;

                                foreach (ZadanieCell z in w.Zadania)
                                {
                                    if (z.DataOd > d0)
                                    {
                                        // dodajemy "puste" kratki
                                        for (Date d = d0; d < z.DataOd; d++)
                                            tab += pustaKomorka;
                                    }
                                    Date zadanieOd = (z.DataOd < DataOd ? DataOd : z.DataOd);
                                    Date zadanieDo = (z.DataDo > DataDo ? DataDo : z.DataDo);

                                    // dodajemy kratkę na zadanie
                                    int dlugosc = (int)(zadanieDo - zadanieOd) + 1;
                                    tab += "<td align='center' colspan=" + dlugosc.ToString() + " style='" + StylKolor(z.Status) + "'>"
                                        + Soneta.HTML.HtmlParser.HtmlEncode(z.Opis) + "</td>";

                                    d0 = zadanieDo + 1;
                                }
                                // uzupełnienie pustych kratek z prawej
                                if (d0 <= DataDo)
                                    for (Date d = d0; d <= DataDo; d++)
                                        tab += pustaKomorka;

                                tab += "</tr>";
                            }

                        }
                        tab += "<EA:SECTION TYPE=\"FOOTER\" /></table>";

                        if (drukowackolory && listaStanow.Count > 0)
                        {
                            tab += "<p style='font-size: 8pt; font-family: Tahoma; margin-bottom:0; margin-top:6px;'>Legenda:</p>"
                                + "<table cellspacing=0 cellpadding=1 border=1 cellspacing=0 cellpadding=0 style='FONT-SIZE: 7pt; FONT-FAMILY: Tahoma; BORDER-COLLAPSE: collapse; overflow: hidden; table-layout: fixed; width=30%'>";
                            listaStanow.Sort();
                            foreach (string stan in listaStanow)
                                tab += "<tr><td style='" + StylKolor(stan) + "'>" + Soneta.HTML.HtmlParser.HtmlEncode(stan) + "</td></tr>";
                            tab += "</table>";


                        }
                        return tab;
                    }
                }
            }

            /////////////////////////////////////////////////////////////////		    
            public enum KoloryWgEnum
            {
                [Caption("Brak")]
                Brak = 1,
                [Caption("Wg stanu")]
                WgStanu = 2,
                [Caption("Wg priorytetu")]
                WgPriorytetu = 3
            };


            public class Params : ContextBase
            {

                public Params(Context cx)
                    : base(cx)
                {
                }

                KoloryWgEnum kolorywg = KoloryWgEnum.Brak;
                [Caption("Drukowanie kolorów:")]
                [Priority(1)]
                public KoloryWgEnum KoloryWg
                {
                    get { return kolorywg; }
                    set { kolorywg = value; }
                }

            }

            Params param = null;
            [Context]
            public Params Param
            {
                get { return param; }
                set { param = value; }
            }

            /////////////////////////////////////////////////////////////////		    
    		
            void OnContextLoad(Object sender, EventArgs args)
            {
                ZadaniaParams ZadaniaParametry = null;
                    ZadaniaParametry = (ZadaniaParams)dc[typeof(ZadaniaParams)];
                
                    ReportHeader.Title = String.Format("Zadania {0}|okres: {1}|stan realizacji: {2}",
                        (ZadaniaParametry.Kontrahent==null?"":"kontrahenta " + ZadaniaParametry.Kontrahent.Kod),
                        ZadaniaParametry.Okres,
                        ZadaniaParametry.StanRealizacji);
                
                Row[] rows = (Row[])dc[typeof(Row[])];

                KalendarzTable kalendarz = new KalendarzTable(ZadaniaParametry.Okres);
                kalendarz.NazwaObiektu = "Operator";
                kalendarz.DrukowacKolory = (Param.KoloryWg == KoloryWgEnum.Brak ? false : true);
                

                foreach (object o in rows)
                {
                    if (o.GetType() == typeof(Zadanie))
                    {
                        Zadanie z = (Zadanie)o;
                        kalendarz.DodajZadanie(
                            z.Wykonujacy.FullName + " (" + z.Wykonujacy + ")",
                            z.Nazwa + (z.Kontrahent == null ? "" : " (" + z.Kontrahent.Kod + ")"),
                            z.DataOd,
                            z.DataDo,
                            Param.KoloryWg == KoloryWgEnum.WgStanu && z.StanZadania != null ? z.StanZadania.Kod : (Param.KoloryWg == KoloryWgEnum.WgPriorytetu && z.PriorytetZadania != null ? z.PriorytetZadania.Kod : "")
                            );
                    }
                    else if (o.GetType() == typeof(Kontrahent))
                    {
                        Kontrahent k = (Kontrahent)o;
                        foreach (Zadanie z in k.Zadania)
                        {
                            if (z.Rodzaj == RodzajZadania.Zdarzenie
                                || ZadaniaParametry.StanRealizacji == StanyRealizacjiZadania.Otwarte && !z.Aktywny
                                || ZadaniaParametry.StanRealizacji == StanyRealizacjiZadania.Zamknięte && z.Aktywny) 
                                continue;
                            kalendarz.DodajZadanie(
                                z.Wykonujacy.FullName + " (" + z.Wykonujacy + ")",
                                z.Nazwa,
                                z.DataOd,
                                z.DataDo,
                                Param.KoloryWg == KoloryWgEnum.WgStanu && z.StanZadania != null ? z.StanZadania.Kod : (Param.KoloryWg == KoloryWgEnum.WgPriorytetu && z.PriorytetZadania != null ? z.PriorytetZadania.Kod : "")
                                );
                        }
                    }
                    
                    
                }
                DataLabel1.EditValue = kalendarz.Tabela;
            }
            void Msg(object o)
            {
            }    
        </script>
	</HEAD>
	<BODY>
		<FORM method="post" runat="server">
			<ea:DataContext id="dc" runat="server" OnContextLoad="OnContextLoad" Landscape="true"></ea:DataContext>
			<eb:ReportHeader id="ReportHeader" runat="server" title="Zadania|Okres: {0}|StanRealizacji: {1}" DataMember0="ZadaniaParams.Okres" DataMember1="ZadaniaParams.StanRealizacji"></eb:ReportHeader>
            <ea:DataLabel ID="DataLabel1" runat="server">
            </ea:DataLabel>
            &nbsp;<br />
			<eb:ReportFooter id="ReportFooter" runat="server"></eb:ReportFooter>
		</FORM>

	</BODY>
</HTML>

