﻿<%@ import Namespace="Soneta.CzlonkowieSzkolenia" %>
<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="Soneta.Handel" %>
<%@ import Namespace="Soneta.Kasa" %>
<%@ import Namespace="Soneta.Business" %>
<%@ import Namespace="Soneta.Tools" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Page language="c#" AutoEventWireup="false" codePage="1200" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<TITLE>Rozliczenie faktur i wpłat</TITLE>
		<META content="C#" name="CODE_LANGUAGE">
		<META content="JavaScript" name="vs_defaultClientScript">
		<META content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
		<script runat="server">
            public class Item
            {
                int lp;
                string imienazwisko;
                string platnik;
                Currency wartosc;
                string nrfa;
                Date data;
                string nrkp;
                Currency zafakturowane;
                Currency zaplacowne;
                Currency dozaplaty;
                Currency dozafakturowania;
                public Item(   int lp,
                               string imienazwisko,
                               string platnik,
                               Currency wartosc,
                               string nrfa,
                               Date data,
                               string nrkp,
                               Currency zafakturowane,
                               Currency zaplacowne,
                               Currency dozaplaty,
                               Currency dozafakturowania
                    )
                {
                    this.lp = lp;
                    this.imienazwisko = imienazwisko;
                    this.platnik = platnik;
                    this.wartosc = wartosc;
                    this.nrfa = nrfa;
                    this.data = data;
                    this.nrkp = nrkp;
                    this.zafakturowane = zafakturowane;
                    this.zaplacowne = zaplacowne;
                    this.dozaplaty = dozaplaty;
                    this.dozafakturowania = dozafakturowania;
                }

                public string Lp
                {
                    // 1+ - osoba, 0 - dokument, -1 - suma osoby, -2 suma total
                    get { return lp <= 0 ? "" : String.Format("<b>{0}</b>", lp); }
                }
                public string ImieNazwisko
                {
                    get { return lp <= 0 ? "" : String.Format("<b>{0}</b>", imienazwisko.ToUpper()); }
                }
                public string Platnik
                {
                    get { return lp > 0 ? String.Format("<b>{0}</b>", platnik) : (lp==-2 ? "<b>RAZEM:</b>" : ""); }
                }
                public string Wartosc
                {
                    get { return lp <= 0 && lp>=-1 ? "" : String.Format("<b>{0}</b>", wartosc); }
                }
                public string NrFa
                {
                    get { return lp != 0 ? "" : String.Format("{0}", nrfa); }
                }
                public string Data
                {
                    get { return lp != 0 ? "" : String.Format("{0}", data); }
                }
                public string NrKp
                {
                    get { return lp == 0 ? String.Format("{0}", nrkp) : (lp==-1 ? "<b>RAZEM:<b>" : ""); }
                }
                public string Zafakturowane
                {
                    get { return lp > 0 ? "" : String.Format((lp == 0 ? "{0}" : "<b>{0}</b>"), zafakturowane); }
                }
                public string Zaplacone
                {
                    get { return lp > 0 ? "" : String.Format((lp == 0 ? "{0}" : "<b>{0}</b>"), zaplacowne); }
                }
                public string DoZaplaty
                {
                    get { return lp > 0 ? "" : String.Format((lp == 0 ? "{0}" : "<b>{0}</b>"), dozaplaty); }
                }
                public string DoZafakturowania
                {
                    get { return lp > 0 ? "" : lp == 0 ? "" : String.Format("<b>{0}</b>", dozafakturowania); }
                }
            }

		    int lp = 0;

            void SetUEHeader()
            {
                Soneta.CzlonkowieSzkolenia.GrupaSzkol grupa = dc[typeof(Soneta.CzlonkowieSzkolenia.GrupaSzkol)] as Soneta.CzlonkowieSzkolenia.GrupaSzkol;
                if (grupa != null && (bool)grupa.RodzajSzkol.Unijne)
                {
                    ReportHeader.LeftPictureFile = "";
                    ReportHeader.HeaderPictureFile = "W:\\ASPX\\unia.jpg";
                    ReportHeader.HeaderPictureAlignment = HorizontalAlign.Center;
                }
            }    

            void OnContextLoad(Object sender, EventArgs args)
            {
                SetUEHeader();
                ArrayList lista = new ArrayList();
                GrupaSzkol grupa = dc[typeof(GrupaSzkol)] as GrupaSzkol;
                Soneta.Business.View view = grupa.Uczestnicy;
                view.Sort = "Uczestnik.Nazwisko,Uczestnik.Imie";
                ZgłoszenieUczestnikInfoWorker info = new ZgłoszenieUczestnikInfoWorker();
                Currency totWartość = Currency.Zero;
                Currency totZafakturowane = Currency.Zero;
                Currency totZapłacone = Currency.Zero;
                Currency totDoZafakturowania = Currency.Zero;
                Currency totDoZapłaty = Currency.Zero;
                foreach (ZgloszenieUczestnik zgl in view)
                {
                    // Skreślonych też drukujemy
                    // if (zgl.StatusZgloszenia == StatusZgloszenia.Skreślone) continue;
                    // Dodanie wiersza "nagłówkowego"
                    lp++;
                    info.Zgłoszenie = zgl;
                    Currency wartosc = Currency.Zero;
                    Currency zafakturowane = Currency.Zero;
                    Currency zaplacone = Currency.Zero;
                    Currency dozaplaty = Currency.Zero;
                    Currency dozafakturowania = Currency.Zero;

                    try { wartosc = info.WartośćZapotrzebowan; }
                    catch { }
                    try { zafakturowane = info.KwotaPłatności; }
                    catch { }
                    try { zaplacone = info.Rozliczono; }
                    catch { }
                    try { dozaplaty = info.DoRozliczenia; }
                    catch { }
                    try { dozafakturowania = info.DoZafakturowania; }
                    catch { }

                    lista.Add(new Item(
                        lp,
                        zgl.Uczestnik.NazwiskoImie + (zgl.StatusZgloszenia!= StatusZgloszenia.Aktywne ? String.Format(" ({0})", zgl.StatusZgloszenia) : ""),
                        zgl.Platnik.Nazwa + (zgl.Platnik.NIP!="" ? String.Format(" NIP: {0}", zgl.Platnik.NIP) : ""),
                        wartosc,
                        "",
                        Date.MinValue,
                        "",
                        zafakturowane,
                        zaplacone,
                        dozaplaty,
                        dozafakturowania
                        ));

                    // Dodanie listy faktur
                    foreach (DokumentHandlowy dok in zgl.DokumentyHan)
                    {
                        //if (dok.Kategoria != KategoriaHandlowa.Sprzedaż && dok.Kategoria!= KategoriaHandlowa.KorektaSprzedaży && dok.Kategoria!= KategoriaHandlowa.FakturaWewnętrzna) continue;
                        // zmiana warunku - uzaleznienie do płatności
                        if (dok.Definicja.KierunekPlatnosci == Soneta.Core.KierunekPlatnosci.Brak) continue;
                        DokumentZgłoszenieInfoWorker dokinfo = new DokumentZgłoszenieInfoWorker(dok, zgl);
                        // Ze względu na prawa do kasy - numery wpłat pobierane warunkowo
                        string nrwplat = "";
                        try
                        {
                            nrwplat = dokinfo.NumeryWpłat;
                        }
                        catch
                        {
                            nrwplat = "(brak praw)";
                        }
                        lista.Add(new Item(
                            0,
                            "",
                            "",
                            Currency.Zero,
                            dok.Numer.Pelny,
                            dok.Data,
                            nrwplat,//dokinfo.NumeryWpłat,
                            dokinfo.KwotaPłatności,
                            dokinfo.Rozliczono,
                            dokinfo.DoRozliczenia,
                            Currency.Zero
                            ));
                    }
                    // Wiersz podsumowania:
                    lista.Add(new Item(
                        -1,
                        "",
                        "",
                        wartosc,
                        "",
                        Date.MinValue,
                        "",
                        zafakturowane,
                        zaplacone,
                        dozaplaty,
                        dozafakturowania
                        ));
                    totWartość += wartosc;
                    totZafakturowane += zafakturowane;
                    totZapłacone += zaplacone;
                    totDoZafakturowania += dozafakturowania;
                    totDoZapłaty += dozaplaty;
                    
                }
                // Wiersz podsumowania:
                lista.Add(new Item(
                    -2,
                    "",
                    "",
                    totWartość,
                    "",
                    Date.MinValue,
                    "",
                    totZafakturowane,
                    totZapłacone,
                    totDoZapłaty,
                    totDoZafakturowania
                    ));
                
                GridZestawienie.DataSource = lista;
                ReportHeader["TODAY"] = Date.Today.ToString();

            }

            void Msg(object o)
            {
            }    
 
		</script>
	</HEAD>
	<BODY>
		<FORM method="post" runat="server">
			<ea:DataContext id="dc" Landscape="true" runat="server" OnContextLoad="OnContextLoad"  TypeName="Soneta.CzlonkowieSzkolenia.GrupaSzkol,Soneta.CzlonkowieSzkolenia"></ea:DataContext>
<eb:ReportHeader runat="server" Title="Rozliczenie faktur i wpłat|{0}|od {1} do {2}|Data wykonania %TODAY%" FirstHeader="true" ID="ReportHeader" DataMember0="." DataMember1="DataOd" DataMember2="DataDo"/>

<ea:SectionMarker runat="server" SectionType="Body"></ea:SectionMarker>
  <ea:Grid runat="server" ID="GridZestawienie">
    <Columns>
    <ea:GridColumn ID="GridColumn1" runat="server" Align="Right" Caption="Lp." DataMember="Lp" Width="4" />
    <ea:GridColumn ID="GridColumn2" runat="server" Align="Left" Caption="Imię i nazwisko" DataMember="ImieNazwisko" />
    <ea:GridColumn ID="GridColumn3" runat="server" Align="Left" Caption="Płatnik" DataMember="Platnik" />
    <ea:GridColumn ID="GridColumn4" runat="server" Align="Right" Caption="Wartość" DataMember="Wartosc" Width="13"/>
    <ea:GridColumn ID="GridColumn5" runat="server" Align="Right" Caption="Faktura" 
            DataMember="NrFa" Width="25"/>
    <ea:GridColumn ID="GridColumn6" runat="server" Align="Center" Caption="Data" DataMember="Data" Width="11"/>
    <ea:GridColumn ID="GridColumn7" runat="server" Align="Left" Caption="Wpłata" DataMember="NrKp" Width="20"/>
    <ea:GridColumn ID="GridColumn8" runat="server" Align="Right" Caption="Zafakturowane" DataMember="Zafakturowane" Width="13"/>
    <ea:GridColumn ID="GridColumn9" runat="server" Align="Right" Caption="Zapłacone" DataMember="Zaplacone" Width="13"/>
    <ea:GridColumn ID="GridColumn10" runat="server" Align="Right" Caption="Do zapłaty" DataMember="DoZaplaty" Width="13"/>
    <ea:GridColumn ID="GridColumn11" runat="server" Align="Right" Caption="Do zafakturowania" DataMember="DoZafakturowania" Width="13"/>
    </Columns>
  </ea:Grid>

<eb:ReportFooter runat="server" ></eb:ReportFooter>
		</FORM>
	</BODY>
</HTML>

