﻿<%@Page Language="c#" AutoEventWireup="false" CodePage="1200" %>
<%@Register tagprefix="ea" namespace="Soneta.Web" assembly="Soneta.Web" %>

<%@ Import namespace="Soneta.Deklaracje" %>
<%@ Import namespace="Soneta.Deklaracje.PIT" %>


<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >


<html>
<head>
	<title>IFT-2 (7)</title>
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
	<script runat="server">

		private void OnContextLoad(object sender, EventArgs e)
		{
            var dekx = (Deklaracja)dc[typeof(Deklaracja)];
            if (dekx as Soneta.Deklaracje.CIT.IFT2_7 == null)
                throw new InvalidOperationException("Report IFT-2 (7) can only be printed for IFT-2 declaration in version 7.");
            var dekl = (Soneta.Deklaracje.CIT.IFT2_7)dekx;

			var roczna = (Boolean)dekl.Bloki["0"]["Roczna"];
			FrameNazwaDekl.Text = roczna ? "<strike>IFT-2</strike>/IFT-2R<.INDEXUP>*)<./>" : "IFT-2/<strike>IFT-2R</strike><.INDEXUP>*)<./>";
			FrameNrDokumentu.EditValue = dekl.GetNumerUpo();
		}

	</script>
</head>

<body leftmargin="0" rightmargin="0">
	<form id="IFT_2_5" method="post" runat="server">
		<ea:datacontext ID="dc" style="z-index: 0; left: 0; position: absolute; top: 0" runat="server" PageZoom="102.50%" PageHeight="1000" LeftMargin="15" TypeName="Soneta.Deklaracje.Deklaracja,Soneta.Deklaracje" OnContextLoad="OnContextLoad"></ea:datacontext>
		<ea:deklaracjaheader ID="DeklaracjaHeader1" style="z-index: 100; left: 0; position: absolute; top: 0px" runat="server" StylNagłówka="Caption" Caption="POLA JASNE WYPEŁNIA PODATNIK, POLA CIEMNE WYPEŁNIA URZĄD SKARBOWY. WYPEŁNIĆ NA MASZYNIE, KOMPUTEROWO LUB RĘCZNIE, DUŻYMI,<br>DRUKOWANYMI LITERAMI, CZARNYM LUB NIEBIESKIM KOLOREM. &amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;<b><i>Składanie w wersji elektronicznej:  www.portalpodatkowy.mf.gov.pl</i></b>"></ea:deklaracjaheader>
	
		<!-- PAGE 1 CONTENTS -->

		<ea:framelabel id="FrameNIPPlatnika" style="z-index: 100; left: 0px; position: absolute; top: 24px; right: 375px; width: 343px;" runat="server" DataMember="0.Nip" ValueStyle="n13" number="1" height="28px" text="Identyfikator podatkowy NIP płatnika/podmiotu <i>[Tax Identification Number of tax remitter/entity]</i>"></ea:framelabel>
		<ea:framelabel id="FrameNrDokumentu" style="z-index: 100; left: 343px; position: absolute; top: 24px; right: 249px; width: 224px;" runat="server" Text="Nr dokumentu <i>[Document no]</i>" ValueStyle="LeftBottom" height="28px" number="2" framestyle="SmallBoldGray"></ea:framelabel>
		<ea:framelabel id="FrameLabel23" style="z-index: 100; left: 567px; position: absolute; top: 24px" runat="server" text="Status <i>[Status]</i>" Width="84px" Height="28px" Number="3" FrameStyle="SmallBoldGray"></ea:framelabel>
		<ea:framelabel id="FrameNazwaDekl" style="Z-INDEX: 100; LEFT: 0px; POSITION: absolute; TOP: 54px" runat="server" Height="14px" Width="210px" FrameBorderStyle="None" FrameStyle="BigBold"></ea:framelabel>
		<ea:framelabel id="FrameLabel36" style="Z-INDEX: 100; LEFT: 0px; POSITION: absolute; TOP: 74px" runat="server" Height="77px" Width="651px" Text="<font size=2> INFORMACJA O WYSOKOŚCI PRZYCHODU (DOCHODU) UZYSKANEGO<br>PRZEZ PODATNIKÓW PODATKU DOCHODOWEGO OD OSÓB PRAWNYCH NIEMAJĄCYCH<br>SIEDZIBY LUB ZARZĄDU NA TERYTORIUM RZECZYPOSPOLITEJ POLSKIEJ<br><i><font size=2>[INFORMATION ON REVENUE (INCOME) DERIVED BY LEGAL PERSONS HAVING NO SEAT<br>OR BOARD OF MANAGEMENT ON THE TERRITORY OF THE REPUBLIC OF POLAND]</font></i>" FrameBorderStyle="None" HorizontalAlign="Center" FrameStyle="BigBold"></ea:framelabel>
		<ea:framelabel id="Framelabel1" style="Z-INDEX: 100; LEFT: 42px; POSITION: absolute; TOP: 155px" runat="server" Height="34px" Width="120px" Text="<font size=2>ZA OKRES<br><i>[FOR PERIOD]</i>" FrameBorderStyle="None" HorizontalAlign="Right" FrameStyle="BigBold"></ea:framelabel>
		<ea:framelabel id="Framelabel120" style="Z-INDEX: 100; LEFT: 175px; POSITION: absolute; TOP: 160px" runat="server" DataMember="Okres.From" ValueStyle="DateWithoutInfo" Number="4" Height="28px" Width="217px" Text="Od <.NORMAL>(dzień-miesiąc-rok)</.> <i><b>[From</b> <.NORMAL>(day-month-year)</.><b>]</b></i>"></ea:framelabel>
		<ea:framelabel id="Framelabel121" style="Z-INDEX: 100; LEFT: 392px; POSITION: absolute; TOP: 160px" runat="server" DataMember="Okres.To" ValueStyle="DateWithoutInfo" Height="28px" Width="217px" Text="Do <.NORMAL>(dzień-miesiąc-rok)</.> <i><b>[To</b> <.NORMAL>(day-month-year)</.><b>]</b></i>" Number="5"></ea:framelabel>
		<!-- objaśnienia -->
		<ea:FrameLabel ID="FrameLabel24" Style="z-index: 100; left: 0px; position: absolute; top: 188px; height: 140px;" runat="server" Width="651px" FrameStyle="SmallBoldYellow" FrameBorderStyle="DoubleBottom"></ea:FrameLabel>
		<ea:FrameLabel ID="FrameLabel25" Style="z-index: 100; left: 7px; position: absolute; top: 189px" runat="server" Height="14px" Width="91px" Text="Podstawa prawna:" FrameBorderStyle="None" FrameStyle="SmallYellow"></ea:FrameLabel>
		<ea:FrameLabel ID="FrameLabel26" Style="z-index: 100; left: 110px; position: absolute; top: 189px" runat="server" Height="21px" Width="534px" Text='&#10;Art.26 ust.3, 3b - 3d i 6 ustawy z dnia 15 lutego 1992 r. o podatku dochodowym od osób prawnych (Dz. U. z 2014 r. poz. 851, z późn. zm.), zwanej dalej "ustawą".' FrameBorderStyle="None" FrameStyle="SmallYellow"></ea:FrameLabel>
		<ea:FrameLabel ID="Framelabel137" Style="z-index: 100; left: 7px; position: absolute; top: 207px" runat="server" Height="14px" Width="91px" Text="<i>[Legal basis:</i>" FrameBorderStyle="None" FrameStyle="SmallYellow"></ea:FrameLabel>
		<ea:FrameLabel ID="Framelabel138" Style="z-index: 100; left: 110px; position: absolute; top: 207px" runat="server" Height="21px" Width="534px" Text="&lt;i&gt;Art.26 par. 3, 3b - 3d and 6 of the Act of 15 February 1992 on legal persons' income tax (Dz. U. 2014, item 851 with subsequent amendments), hereinafter referred to as &quot;the Act&quot;.]&lt;/i&gt;" FrameBorderStyle="None" FrameStyle="SmallYellow"></ea:FrameLabel>
		<ea:FrameLabel ID="FrameLabel27" Style="z-index: 100; left: 7px; position: absolute; top: 228px" runat="server" Height="14px" Width="91px" Text="Składający:" FrameBorderStyle="None" FrameStyle="SmallYellow"></ea:FrameLabel>
		<ea:FrameLabel ID="FrameLabel28" Style="z-index: 100; left: 110px; position: absolute; top: 228px" runat="server" Height="14px" Width="534px" Text='Płatnik zryczałtowanego podatku dochodowego od osób prawnych/podmiot zobowiązany do sporządzenia informacji (zwany dalej "podmiotem").' FrameBorderStyle="None" FrameStyle="SmallYellow"></ea:FrameLabel>
		<ea:FrameLabel ID="Framelabel139" Style="z-index: 100; left: 7px; position: absolute; top: 239px" runat="server" Height="14px" Width="91px" Text="<i>[Submitted by:</i>" FrameBorderStyle="None" FrameStyle="SmallYellow"></ea:FrameLabel>
		<ea:FrameLabel ID="Framelabel140" Style="z-index: 100; left: 110px; position: absolute; top: 239px" runat="server" Height="14px" Width="534px" Text='<i>Tax remitter of lump-sum income tax on legal persons/entity liable to fill out and pass on this form (hereinafter referred to as "entity").]</i>' FrameBorderStyle="None" FrameStyle="SmallYellow"></ea:FrameLabel>
		<ea:FrameLabel ID="FrameLabel30" Style="z-index: 100; left: 7px; position: absolute; top: 253px" runat="server" Height="14px" Width="91px" Text="Termin składania:" FrameBorderStyle="None" FrameStyle="SmallYellow"></ea:FrameLabel>
		<ea:FrameLabel ID="FrameLabel31" Style="z-index: 100; left: 110px; position: absolute; top: 253px" runat="server" Height="21px" Width="534px" Text="Do końca trzeciego miesiąca roku następującego po roku podatkowym albo w razie zaprzestania działalności przed upływem tego terminu do dnia zaprzestania działalności lub na wniosek podatnika w terminie 14 dni od dnia złożenia wniosku." FrameBorderStyle="None" FrameStyle="SmallYellow"></ea:FrameLabel>
		<ea:FrameLabel ID="Framelabel141" Style="z-index: 100; left: 7px; position: absolute; top: 271px" runat="server" Height="14px" Width="119px" Text="<i>[Time limit for submitting:</i>" FrameBorderStyle="None" FrameStyle="SmallYellow"></ea:FrameLabel>
		<ea:FrameLabel ID="Framelabel142" Style="z-index: 100; left: 110px; position: absolute; top: 271px" runat="server" Height="21px" Width="534px" Text="<i>By the last day of the third month of the year following the tax year or in the case of cessation of conducting activity before that date - till the day of cessation of conducting activity or at the request of taxpayer within 14 days of such a request.]</i>" FrameBorderStyle="None" FrameStyle="SmallYellow"></ea:FrameLabel>
		<ea:FrameLabel ID="FrameLabel32" Style="z-index: 100; left: 7px; position: absolute; top: 293px" runat="server" Height="14px" Width="91px" Text="Otrzymuje:" FrameBorderStyle="None" FrameStyle="SmallYellow"></ea:FrameLabel>
		<ea:FrameLabel ID="FrameLabel33" Style="z-index: 100; left: 110px; position: absolute; top: 293px" runat="server" Height="21px" Width="534px" Text="Podatnik, o którym mowa w art. 3 ust. 2 ustawy, oraz urząd skarbowy, właściwy w sprawach opodatkowania osób zagranicznych. </i>" FrameBorderStyle="None" FrameStyle="SmallYellow"></ea:FrameLabel>
		<ea:FrameLabel ID="Framelabel143" Style="z-index: 100; left: 7px; position: absolute; top: 303px" runat="server" Height="14px" Width="91px" Text="<i>[Obtained by:</i>" FrameBorderStyle="None" FrameStyle="SmallYellow"></ea:FrameLabel>
		<ea:FrameLabel ID="Framelabel144" Style="z-index: 100; left: 110px; position: absolute; top: 303px" runat="server" Height="14px" Width="539px" Text="<i>[Taxpayer referred to in Art. 3 par. 2 of the Act and a tax office, competent for taxation of foreign persons.] </i>" FrameBorderStyle="None" FrameStyle="SmallYellow"></ea:FrameLabel>
		<!-- BLOK A -->
		<ea:FrameLabel ID="FrameLabel17" Style="z-index: 99; left: 0px; position: absolute; top: 328px" runat="server" Height="98px" Width="651px" Text="A. <FONT SIZE=1> MIEJSCE I CEL SKŁADANIA INFORMACJI <i>[PLACE AND PURPOSE OF FURNISHING THIS DOCUMENT]</i>" FrameBorderStyle="DoubleBottom" FrameStyle="BigYellowBold"></ea:FrameLabel>
		<ea:FrameLabel ID="FrameLabel18" Style="z-index: 101; left: 28px; position: absolute; top: 349px" runat="server" DataMember="A.UrzadSkarb" Number="6" Height="42px" Width="623px" Text="Nazwa i adres urzędu skarbowego właściwego w sprawach opodatkowania osób zagranicznych <.INDEXUP>1)<./><i>[Name and address of the tax office competent for taxation of foreign persons]</i> <.INDEXUP>1)<./>" ValueStyle="Center"></ea:FrameLabel>
		<ea:FrameLabel ID="Framelabel134" Style="z-index: 101; left: 28px; position: absolute; top: 390px" runat="server" Number="7" Height="28px" Width="623px" Text="Cel złożenia formularza &lt;.Normal&gt;(zaznaczyć właściwy kwadrat)&lt;./&gt; &lt;i&gt;[Purpose of submitting the form &lt;.Normal&gt;(tick right box)&lt;./&gt;]&lt;/i&gt;"> </ea:FrameLabel>
		<ea:CheckLabel ID="Checklabel3" Style="z-index: 101; left: 140px; position: absolute; top: 400px" runat="server" DataMember="A.Korekta" Number="1" Height="7px" Width="217px" Text="złożenie informacji <i>[submitting the information]</i>" ComparedValue="False" NumberAlignLeft="False"></ea:CheckLabel>
		<ea:CheckLabel ID="Checklabel4" Style="z-index: 101; left: 364px; position: absolute; top: 400px" runat="server" DataMember="A.Korekta" Number="2" Height="14px" Width="224px" Text="korekta informacji &lt;i&gt;[correction of the information] <span style='FONT-SIZE: smaller; POSITION: relative; TOP: -4px;'>2)</span>&lt;/i&gt;" NumberAlignLeft="False"></ea:CheckLabel>
		<!-- BLOK B -->
		<ea:FrameLabel ID="FrameLabel2" Style="z-index: 98; left: 0px; position: absolute; top: 426px" runat="server" Height="42px" Width="651px" Text="B. &lt;font size=2&gt;DANE PŁATNIKA /PODMIOTU (WYPŁACAJĄCEGO NALEŻNOŚĆ)&lt;br&gt;&lt;i&gt;[IDENTIFICATION DATA OF TAX REMITTER /ENTITY NATURAL PERSON (LIABLE TO MAKE THE PAYMENT)]&lt;/i&gt;" FrameStyle="BigYellowBold" > </ea:FrameLabel>
		<ea:FrameLabel ID="FrameLabel3" Style="z-index: 110; left: 0px; position: absolute; top: 468px" runat="server" Height="91px" Width="651px" Text="B.1. DANE IDENTYFIKACYJNE <i>[IDENTIFICATION DATA]</i>" FrameStyle="BigYellow"></ea:FrameLabel>
		<ea:FrameLabel ID="FrameLabel4" Style="z-index: 110; left: 28px; position: absolute; top: 489px" runat="server" Number="8" Height="28px" Width="623px" Text="Rodzaj płatnika/podmiotu <.Normal>(zaznaczyć właściwy kwadrat)<./> <i>[Type of tax remitter/entity <.Normal>(tick right box)<./>]</i>"></ea:FrameLabel>
		<ea:CheckLabel ID="CheckLabel1" Style="z-index: 110; left: 56px; position: absolute; top: 498px" runat="server" DataMember="B1.OsobaFiz" Number="1" Height="7px" Width="350px" Text="płatnik/podmiot niebędący osobą fizyczną <i>[tax remitter/entity other than natural person]</i>" ComparedValue="False" NumberAlignLeft="False"></ea:CheckLabel>
		<ea:CheckLabel ID="CheckLabel2" Style="z-index: 110; left: 441px; position: absolute; top: 498px" runat="server" DataMember="B1.OsobaFiz" Number="2" Height="14px" Width="189px" Text="osoba fizyczna <i>[natural person]</i>" NumberAlignLeft="False"></ea:CheckLabel>
		<ea:FrameLabel ID="FrameLabel5" Style="z-index: 110; left: 28px; position: absolute; top: 517px" runat="server" DataMember="B1.Nazwa" Number="9" Height="42px" Width="623px" Text="Nazwa pełna, REGON* / Nazwisko, pierwsze imię, data urodzenia, ** &lt;i&gt;[Full name, REGON* / Family name, first name, date of birth **]&lt;/i&gt;"></ea:FrameLabel>
		<ea:FrameLabel ID="FrameLabel6" Style="z-index: 110; left: 0px; position: absolute; top: 559px" runat="server" Height="133px" Width="651px" Text="B.2. ADRES SIEDZIBY/ZAMIESZKANIA <i>[FULL ADDRESS]</i>" FrameStyle="BigYellow"></ea:FrameLabel>
		<ea:FrameLabel ID="FrameLabel7" Style="z-index: 110; left: 28px; position: absolute; top: 580px" runat="server" DataMember="B2.Kraj" Number="10" Height="28px" Width="210px" Text="Kraj <i>[Country]</i>"> </ea:FrameLabel>
		<ea:FrameLabel ID="FrameLabel8" Style="z-index: 110; left: 238px; position: absolute; top: 580px" runat="server" DataMember="B2.Wojew" Number="11" Height="28px" Width="413px" Text="Województwo <i>[Province]</i>"></ea:FrameLabel>
		<ea:FrameLabel ID="FrameLabel9" Style="z-index: 110; left: 28px; position: absolute; top: 608px" runat="server" DataMember="B2.Powiat" Number="12" Height="28px" Width="315px" Text="Powiat <i>[District]</i>"></ea:FrameLabel>
		<ea:FrameLabel ID="FrameLabel10" Style="z-index: 110; left: 343px; position: absolute; top: 608px" runat="server" DataMember="B2.Gmina" Number="13" Height="28px" Width="308px" Text="Gmina <i>[Commune]</i>"></ea:FrameLabel>
		<ea:FrameLabel ID="FrameLabel11" Style="z-index: 110; left: 28px; position: absolute; top: 636px" runat="server" DataMember="B2.Ulica" Number="14" Height="28px" Width="357px" Text="Ulica <i>[Street]</i>"></ea:FrameLabel>
		<ea:FrameLabel ID="FrameLabel12" Style="z-index: 110; left: 385px; position: absolute; top: 636px" runat="server" DataMember="B2.NrDomu" Number="15" Height="28px" Width="140px" Text="Nr domu <i>[Building number]</i>" ValueStyle="Center"></ea:FrameLabel>
		<ea:FrameLabel ID="FrameLabel13" Style="z-index: 110; left: 525px; position: absolute; top: 636px" runat="server" DataMember="B2.NrLokalu" Number="16" Height="28px" Width="126px" Text="Nr lokalu <i>[Flat number]</i>" ValueStyle="Center"></ea:FrameLabel>
		<ea:FrameLabel ID="FrameLabel14" Style="z-index: 110; left: 28px; position: absolute; top: 664px" runat="server" DataMember="B2.Miejsc" Number="17" Height="28px" Width="238px" Text="Miejscowość <i>[Locality]</i>"> </ea:FrameLabel>
		<ea:FrameLabel ID="FrameLabel15" Style="z-index: 110; left: 266px; position: absolute; top: 664px" runat="server" DataMember="B2.KodPoczt" ValueStyle="PostalCode" Number="18" Height="28px" Width="147px" Text="Kod pocztowy <i>[Postal code]</i>" ></ea:FrameLabel>
		<ea:FrameLabel ID="FrameLabel16" Style="z-index: 110; left: 413px; position: absolute; top: 664px" runat="server" DataMember="B2.Poczta" Number="19" Height="28px" Width="238px" Text="Poczta <i>[Post office]</i>"></ea:FrameLabel>
		<!-- uwagi i objaśnienia -->
		<ea:framelabel id="Framelabel127" style="Z-INDEX: 164; LEFT: 0px; POSITION: absolute; TOP: 707px" runat="server" Height="18px" Width="651px" Text="*) Niepotrzebne skreślić. IFT-2 jest sporządzany na wniosek podatnika. IFT-2R jest sporządzany za cały rok podatkowy. <i>[Delete as appropriate. IFT-2 shall be issued at the request of taxpayer. IFT-2R shall be issued for the whole tax year].</i>" FrameBorderStyle="None" FrameStyle="Small"></ea:framelabel>
		<ea:framelabel id="FrameLabel136" style="Z-INDEX: 120; LEFT: 250px; POSITION: absolute; TOP: 775px" runat="server" Width="307px" Height="35px" Text="&lt;font STYLE='font-size: 7pt;'&gt;&lt;b&gt;Objaśnienia [Explanations]&lt;/b&gt;" FrameStyle="Small" FrameBorderStyle="None"></ea:framelabel>
		<ea:framelabel id="FrameLabel234" style="Z-INDEX: 120; LEFT: 0px; POSITION: absolute; TOP: 798px" runat="server" Height="49px" Width="651px" Text="1) Ilekroć w informacji jest mowa o urzędzie skarbowym – oznacza to właściwy dla podatnika urząd skarbowy, o którym mowa w przepisach ustawy.|&lt;i&gt;[Whenever in information the tax office is referred to, it means that it is a competent tax office for the taxpayer, referred to in the Act.].&lt;/i&gt;" FrameBorderStyle="None" FrameStyle="Small"></ea:framelabel>
		<ea:framelabel id="Framelabel135" style="Z-INDEX: 120; LEFT: 0px; POSITION: absolute; TOP: 823px;" runat="server" Height="49px" Text="2) Zgodnie z art.81 ustawy z dnia 29 sierpnia 1997 r. - Ordynacja podatkowa (Dz.U. z 2015 r. poz. 613, z późn. zm.).&lt;i&gt; [Pursuant to Art.81 of the Act of 29 August 1997 - Tax Ordinance (Dz. U. 2015 item 613 with subsequent amendments).]&lt;/i&gt;" Width="651px" FrameStyle="Small" FrameBorderStyle="None"></ea:FrameLabel>
		<ea:framelabel id="Framelabel128" style="Z-INDEX: 120; LEFT: 0px; POSITION: absolute; TOP: 848px; " runat="server" Height="35px" Width="651px" Text="3) W poz.25 należy podać numer służący identyfikacji dla celów podatkowych uzyskany w państwie, w którym odbiorca ma siedzibę, a w przypadku braku takiego numeru - należy podać inny numer identyfikacyjny nadany w kraju, w którym odbiorca ma siedzibę. &lt;i&gt;[In column 25, tax identification number or - in the case of lack of such a number - other identification number obtained in country of recipient's residence shall be indicated.]&lt;/i&gt;" FrameBorderStyle="None" FrameStyle="Small"></ea:framelabel>
		<ea:framelabel id="FrameLabel133" style="Z-INDEX: 120; LEFT: 0px; POSITION: absolute; TOP: 883px;" Height="35px" runat="server" Width="651px" Text="4) Wiersze od D.1 do D.7 wypełnia się w przypadku, gdy znajduje zastosowanie właściwa umowa o unikaniu podwójnego opodatkowania. Wiersz D.8 wypełnia się w przypadku, gdy umowa o unikaniu podwójnego opodatkowania nie znajduje zastosowania &lt;i&gt;[Lines from D.1 to D.7 shall be filled in if specific tax convention is applicable. Line D.8 shall be filled in if tax convention is not applicable.]&lt;/i&gt;" FrameBorderStyle="None" FrameStyle="Small"></ea:framelabel>
		<ea:framelabel id="FrameLabel147" style="Z-INDEX: 120; LEFT: 0px; POSITION: absolute; TOP: 918px" runat="server" Width="627px" Height="21px" Text="5) W wierszu „Miesiące” - cyfry od 1 do 23 oznaczają kolejne miesiące roku podatkowego, w tym również u płatnika, którego rok podatkowy jest inny niż kalendarzowy. &lt;i&gt;[In a line “Months” - numbers from 1 to 23 refer to subseqent months of the tax year, including also a tax remitter whose tax year in different than the calendar year.]&lt;/i&gt;" FrameStyle="Small" FrameBorderStyle="None"></ea:framelabel>
		<ea:framelabel id="Framelabel131" style="Z-INDEX: 120; LEFT: 0px; POSITION: absolute; TOP: 943px" runat="server" Text="6) Poz.114 należy wypełnić w przypadku sporządzania informacji na wniosek podatnika (IFT-2). &lt;i&gt;[Column 114 shall be filled in if information is issued at the request of the taxpayer (IFT-2).]&lt;/i&gt;" Width="651px" Height="21px" FrameStyle="Small" FrameBorderStyle="None"></ea:framelabel>

		<!-- PAGE 1/2 -->

		<ea:deklaracjafooter id="footer1" style="z-index: 165; left: 483px; position: absolute; top: 975px" runat="server" Height="15px" Width="56px" Symbol="IFT-2/IFT-2R" PageNumber="1" PageTotal="3" Version="7" TitleWidth="130"></ea:deklaracjafooter>
		<ea:deklaracjaheader id="DeklaracjaHeader3" style="z-index: 100; left: 0; position: absolute; top: 1000px" runat="server" StylNagłówka="Caption" Caption="POLA JASNE WYPEŁNIA PODATNIK, POLA CIEMNE WYPEŁNIA URZĄD SKARBOWY. WYPEŁNIĆ NA MASZYNIE, KOMPUTEROWO LUB RĘCZNIE, DUŻYMI,<br>DRUKOWANYMI LITERAMI, CZARNYM LUB NIEBIESKIM KOLOREM. &amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;<b><i>Składanie w wersji elektronicznej:  www.portalpodatkowy.mf.gov.pl</i></b>"></ea:deklaracjaheader>

		<!-- PAGE 2 CONTENTS -->
		<!-- BLOK C -->
		<ea:framelabel id="Framelabel19" style="Z-INDEX: 130; LEFT: 0px; POSITION: absolute; TOP: 1024px;" runat="server" Height="35px" Width="651px" Text="C. DANE PODATNIKA (ODBIORCY NALEŻNOŚCI) <i>[IDENTIFICATION DATA OF TAXPAYER (RECIPIENT)]</i>" FrameStyle="BigYellowBold"></ea:framelabel>
		<ea:framelabel id="FrameLabel20" style="Z-INDEX: 130; LEFT: 0px; POSITION: absolute; TOP: 1059px; " runat="server" Height="189px" Width="651px" Text="C.1. DANE IDENTYFIKACYJNE <i>[IDENTIFICATION DATA]</i>" FrameStyle="BigYellow"></ea:framelabel>
		<ea:framelabel id="Framelabel29" style="Z-INDEX: 130; LEFT: 28px; POSITION: absolute; TOP: 1080px" runat="server" DataMember="C1.Nip" Number="20" Height="28px" Width="623px" Text="Identyfikator podatkowy NIP <i>[Tax Identification Number NIP]</i>"></ea:framelabel>
		<ea:framelabel id="Framelabel145" style="Z-INDEX: 130; LEFT: 28px; POSITION: absolute; TOP: 1108px" runat="server" DataMember="C1.NazwaPelna" Number="21" Height="56px" Width="623px" Text="Nazwa pełna <i>[Full name]</i>"></ea:framelabel>
		<ea:framelabel id="Framelabel146" style="Z-INDEX: 130; LEFT: 28px; POSITION: absolute; TOP: 1164px" runat="server" DataMember="C1.NazwaSkrocona" Number="22" Height="28px" Width="308px" Text="Nazwa skrócona <i>[Short name]</i>"></ea:framelabel>
		<ea:framelabel id="Framelabel148" style="Z-INDEX: 130; LEFT: 336px; POSITION: absolute; TOP: 1164px;" runat="server" DataMember="C1.RozpoczecieDzialalnosci" Number="23" Height="28px" Width="315px" ValueStyle="DateWithoutInfo" Text="Data rozpoczęcia działalności (dzien-miesiąc-rok)|<i>[Foundation date (day-month-year)]</i>"></ea:framelabel>
		<ea:FrameLabel ID="Framelabel22" Style="z-index: 130; left: 28px; position: absolute; top: 1192px" runat="server" Number="24" Height="28px" Width="623px" Text="Rodzaj identyfikacji <.Normal>(zaznaczyć właściwy kwadrat):<./><i> [Type of identification <.Normal>(tick right box):<./>]</i>"> </ea:FrameLabel>
		<ea:CheckLabel ID="Checklabel5" Style="z-index: 130; left: 140px; position: absolute; top: 1202px" runat="server" DataMember="C1.IdentyfikacjaPodatkowa" Number="1" Height="14px" Width="203px" Text="podatkowej <i>[for tax purpose]</i>" NumberAlignLeft="False"></ea:CheckLabel>
		<ea:CheckLabel ID="Checklabel6" Style="z-index: 130; left: 364px; position: absolute; top: 1202px" runat="server" DataMember="C1.IdentyfikacjaInna" Number="2" Height="14px" Width="210px" Text="innej <i>[other]</i>" NumberAlignLeft="False"></ea:CheckLabel>
		<ea:framelabel id="Framelabel149" style="Z-INDEX: 130; LEFT: 28px; POSITION: absolute; TOP: 1220px; " runat="server" DataMember="C1.NrIdentyfikacyjny"  Number="25"  Height="28px" Width="350px" Text="Numer identyfikacyjny podatnika <i>[Taxpayer identification number]</i> <.NORMAL><span style='FONT-SIZE: smaller; POSITION: relative; TOP: -4px;'>3)</span><./>"></ea:framelabel>
		<ea:framelabel id="Framelabel150" style="Z-INDEX: 130; LEFT: 378px; POSITION: absolute; TOP: 1220px; " runat="server" DataMember="C1.KodKraju" Number="26"  Height="28px" Width="273px" Text="Kod kraju wydania <i>[Country code]</i>"></ea:framelabel>
		<ea:framelabel id="FrameLabel153" style="Z-INDEX: 130; LEFT: 0px; POSITION: absolute; TOP: 1248px" runat="server" Height="84px" Width="651px" Text="C.2. ADRES SIEDZIBY <i>[SEAT ADDRESS]</i>" FrameBorderStyle="DoubleBottom" FrameStyle="BigYellow"></ea:framelabel>
		<ea:framelabel id="Framelabel154" style="Z-INDEX: 130; LEFT: 28px; POSITION: absolute; TOP: 1268px" runat="server" DataMember="C2.Kraj" Number="27" Height="28px" Width="175px" Text="Kraj <i>[Country]</i>"></ea:framelabel>
		<ea:framelabel id="Framelabel155" style="Z-INDEX: 130; LEFT: 203px; POSITION: absolute; TOP: 1268px" runat="server" DataMember="C2.Miejsc" Number="28" Height="28px" Width="301px" Text="Miejscowość <i>[Locality]</i>"></ea:framelabel>
		<ea:framelabel id="Framelabel156" style="Z-INDEX: 130; LEFT: 504px; POSITION: absolute; TOP: 1268px" runat="server" DataMember="C2.KodPoczt" Number="29" Height="28px" Width="147px" Text="Kod pocztowy <i>[Postal code]</i>" ></ea:framelabel>
		<ea:framelabel id="Framelabel157" style="Z-INDEX: 130; LEFT: 28px; POSITION: absolute; TOP: 1296px" runat="server" DataMember="C2.Ulica" Number="30" Height="28px" Width="343px" Text="Ulica <i>[Street]</i>"></ea:framelabel>
		<ea:framelabel id="Framelabel158" style="Z-INDEX: 130; LEFT: 371px; POSITION: absolute; TOP: 1296px;" runat="server" DataMember="C2.NrDomu" Number="31" Height="28px" Width="140px" Text="Nr domu <i>[Building number]</i>" ></ea:framelabel>
		<ea:framelabel id="Framelabel159" style="Z-INDEX: 130; LEFT: 511px; POSITION: absolute; TOP: 1296px" runat="server" DataMember="C2.NrLokalu" Number="32" Height="28px" Width="140px" Text="Nr lokalu <i>[Flat number]</i>" ></ea:framelabel>
				
		<!-- BLOK D -->
		<ea:framelabel id="FrameLabel21" style="Z-INDEX: 110; LEFT: 0; POSITION: absolute; TOP: 1332px" runat="server" Height="574px" Width="651px" Text="D. <font size=2>RODZAJE PRZYCHODÓW (DOCHODÓW) I WYSOKOŚĆ POBRANEGO ZRYCZAŁTOWANEGO<br>PODATKU <i>[TYPE OF REVENUE (INCOME) AND AMOUNT OF TAX WITHHELD] <.INDEXUP><.NORMAL>4)<./></i>" FrameStyle="BigYellowBold"></ea:framelabel>
		<ea:framelabel id="FrameLabel34" style="Z-INDEX: 140; LEFT: 42px; POSITION: absolute; TOP: 1369px" runat="server" Height="49px" Width="56px" Text="Symbol||<i>[Code]</i>" HorizontalAlign="Center" FrameStyle="SmallBoldYellow"></ea:framelabel>
		<ea:framelabel id="FrameLabel56" style="Z-INDEX: 140; LEFT: 98px; POSITION: absolute; TOP: 1369px" runat="server" Height="49px" Width="161px" Text="Rodzaj przychodu (dochodu)||<i>[Type of revenue (income)]</i>" HorizontalAlign="Center" FrameStyle="SmallBoldYellow"></ea:framelabel>
		<ea:framelabel id="Framelabel103" style="Z-INDEX: 140; LEFT: 259px; POSITION: absolute; TOP: 1369px; right: 481px;" runat="server" Height="49px" Width="112px" Text="Kwota dochodu zwolnionego z opodatkowania<br><i>[Amount of income exempted from taxation]</i>" HorizontalAlign="Center" FrameStyle="SmallBoldYellow"></ea:framelabel>
		<ea:framelabel id="FrameLabel57" style="Z-INDEX: 140; LEFT: 371px; POSITION: absolute; TOP: 1369px" runat="server" Height="49px" Width="112px" Text="Kwota dochodu podlegającego opodatkowaniu<br><i>[Amount of taxable income]</i>" HorizontalAlign="Center" FrameStyle="SmallBoldYellow"></ea:framelabel>
		<ea:framelabel id="FrameLabel58" style="Z-INDEX: 140; LEFT: 483px; POSITION: absolute; TOP: 1369px" runat="server" Height="49px" Width="56px" Text="Stawka|podatku|w %|<i>[Rate of tax %]</i>" HorizontalAlign="Center" FrameStyle="SmallBoldYellow"></ea:framelabel>
		<ea:framelabel id="FrameLabel59" style="Z-INDEX: 140; LEFT: 539px; POSITION: absolute; TOP: 1369px" runat="server" Height="49px" Width="113px" Text="Kwota|pobranego podatku|<i>[Amount of tax withheld]</i>|g= e x f" HorizontalAlign="Center" FrameStyle="SmallBoldYellow"></ea:framelabel>
		<ea:framelabel id="FrameLabel104" style="Z-INDEX: 140; LEFT: 0; POSITION: absolute; TOP: 1418px" runat="server" Height="14px" Width="42px" Text="a" HorizontalAlign="Center" FrameStyle="SmallYellow"></ea:framelabel>
		<ea:framelabel id="FrameLabel105" style="Z-INDEX: 140; LEFT: 42px; POSITION: absolute; TOP: 1418px" runat="server" Height="14px" Width="56px" Text="b" HorizontalAlign="Center" FrameStyle="SmallYellow"></ea:framelabel>
		<ea:framelabel id="FrameLabel106" style="Z-INDEX: 140; LEFT: 98px; POSITION: absolute; TOP: 1418px" runat="server" Height="14px" Width="161px" Text="c" HorizontalAlign="Center" FrameStyle="SmallYellow"></ea:framelabel>
		<ea:framelabel id="FrameLabel107" style="Z-INDEX: 140; LEFT: 259px; POSITION: absolute; TOP: 1418px" runat="server" Height="14px" Width="112px" Text="d" HorizontalAlign="Center" FrameStyle="SmallYellow"></ea:framelabel>
		<ea:framelabel id="FrameLabel108" style="Z-INDEX: 140; LEFT: 371px; POSITION: absolute; TOP: 1418px" runat="server" Height="14px" Width="112px" Text="e" HorizontalAlign="Center" FrameStyle="SmallYellow"></ea:framelabel>
		<ea:framelabel id="FrameLabel109" style="Z-INDEX: 140; LEFT: 483px; POSITION: absolute; TOP: 1418px" runat="server" Height="14px" Width="56px" Text="f" HorizontalAlign="Center" FrameStyle="SmallYellow"></ea:framelabel>
		<ea:framelabel id="FrameLabel110" style="Z-INDEX: 140; LEFT: 539px; POSITION: absolute; TOP: 1418px" runat="server" Height="14px" Width="112px" Text="g" HorizontalAlign="Center" FrameStyle="SmallYellow"></ea:framelabel>
		<!-- D1 -->
		<ea:framelabel id="FrameLabel37" style="Z-INDEX: 140; LEFT: 0px; POSITION: absolute; TOP: 1432px" runat="server" Height="84px" Width="42px" Text="D.1" HorizontalAlign="Center" FrameStyle="BigYellowBold"></ea:framelabel>
		<ea:framelabel id="FrameLabel47" style="Z-INDEX: 140; LEFT: 42px; POSITION: absolute; TOP: 1432px; right: 1313px;" runat="server" Height="84px" Width="56px" Text="8" HorizontalAlign="Center" FrameStyle="BigYellowBold"></ea:framelabel>
		<ea:framelabel id="FrameLabel60" style="Z-INDEX: 140; LEFT: 98px; POSITION: absolute; TOP: 1432px" runat="server" Height="84px" Width="161px" Text="Opłaty za wywóz ładunków i pasażerów przyjętych do przewozu w portach polskich przez zagraniczne przedsiębiorstwa morskiej żeglugi handlowej<br><i>[Charges for the expedition of goods and passengers admitted for transportation in the Polish harbours by foreign enterprises of maritime navigation]</i>" FrameStyle="SmallBoldYellow"></ea:framelabel>
		<ea:framelabel id="Framelabel102" style="Z-INDEX: 140; LEFT: 259px; POSITION: absolute; TOP: 1432px" runat="server" DataMember="D.1Zwolniony" ValueStyle="ForceZl" Number="33"  Height="84px" Width="112px"></ea:framelabel>
		<ea:framelabel id="Framelabel69" style="Z-INDEX: 140; LEFT: 371px; POSITION: absolute; TOP: 1432px" runat="server" DataMember="D.1Kwota" ValueStyle="ForceZl" Number="34" Height="84px" Width="112px"></ea:framelabel>
		<ea:framelabel id="Framelabel70" style="Z-INDEX: 140; LEFT: 483px; POSITION: absolute; TOP: 1432px" runat="server" DataMember="D.1Stawka" ValueStyle="Percent" Number="35" Height="84px" Width="56px"></ea:framelabel>
		<ea:framelabel id="Framelabel71" style="Z-INDEX: 140; LEFT: 539px; POSITION: absolute; TOP: 1432px" runat="server" DataMember="D.1Podatek" ValueStyle="ForceZl" Number="36" Height="84px" Width="112px"></ea:framelabel>
		<!-- D2 -->
		<ea:framelabel id="FrameLabel38" style="Z-INDEX: 140; LEFT: 0px; POSITION: absolute; TOP: 1516px" runat="server" Height="54px" Width="42px" Text="D.2" HorizontalAlign="Center" FrameStyle="BigYellowBold"></ea:framelabel>
		<ea:framelabel id="FrameLabel48" style="Z-INDEX: 140; LEFT: 42px; POSITION: absolute; TOP: 1516px" runat="server" Height="54px" Width="56px" Text="8" HorizontalAlign="Center" FrameStyle="BigYellowBold"></ea:framelabel>
		<ea:framelabel id="FrameLabel61" style="Z-INDEX: 140; LEFT: 98px; POSITION: absolute; TOP: 1516px" runat="server" Height="54px" Width="161px" Text="Przychody uzyskane na terytorium RP przez zagraniczne przedsiębiorstwa żeglugi powietrznej<br><i>[Profits obtained by foreign air transport enterprises]</i>" FrameStyle="SmallBoldYellow"></ea:framelabel>
		<ea:framelabel id="Framelabel111" style="Z-INDEX: 140; LEFT: 259px; POSITION: absolute; TOP: 1516px" runat="server" DataMember="D.2Zwolniony" ValueStyle="ForceZl" Number="37" Height="54px" Width="112px"></ea:framelabel>
		<ea:framelabel id="Framelabel72" style="Z-INDEX: 140; LEFT: 371px; POSITION: absolute; TOP: 1516px" runat="server" DataMember="D.2Kwota" ValueStyle="ForceZl" Number="38" Height="54px" Width="112px"></ea:framelabel>
		<ea:framelabel id="Framelabel80" style="Z-INDEX: 140; LEFT: 483px; POSITION: absolute; TOP: 1516px" runat="server" DataMember="D.2Stawka" ValueStyle="Percent" Number="39" Height="54px" Width="56px"></ea:framelabel>
		<ea:framelabel id="Framelabel89" style="Z-INDEX: 140; LEFT: 539px; POSITION: absolute; TOP: 1516px" runat="server" DataMember="D.2Podatek" ValueStyle="ForceZl" Number="40" Height="54px"  Width="113px"></ea:framelabel>
		<!-- D3 -->
		<ea:framelabel id="FrameLabel39" style="Z-INDEX: 140; LEFT: 0px; POSITION: absolute; TOP: 1570px" runat="server" Height="28px" Width="42px" Text="D.3" HorizontalAlign="Center" FrameStyle="BigYellowBold"></ea:framelabel>
		<ea:framelabel id="FrameLabel49" style="Z-INDEX: 140; LEFT: 42px; POSITION: absolute; TOP: 1570px" runat="server" Height="28px" Width="56px" Text="10" HorizontalAlign="Center" FrameStyle="BigYellowBold"></ea:framelabel>
		<ea:framelabel id="FrameLabel62" style="Z-INDEX: 140; LEFT: 98px; POSITION: absolute; TOP: 1570px" runat="server" Height="28px" Width="161px" Text="Dywidendy i inne przychody (dochody) z tytułu udziału w zyskach osób prawnych <i>[Dividends]</i>" FrameStyle="SmallBoldYellow"></ea:framelabel>
		<ea:framelabel id="Framelabel112" style="Z-INDEX: 140; LEFT: 259px; POSITION: absolute; TOP: 1570px" runat="server" DataMember="D.3Zwolniony" ValueStyle="ForceZl" Number="41" Height="28px" Width="112px"></ea:framelabel>
		<ea:framelabel id="Framelabel73" style="Z-INDEX: 140; LEFT: 371px; POSITION: absolute; TOP: 1570px" runat="server" DataMember="D.3Kwota" ValueStyle="ForceZl" Number="42" Height="28px" Width="112px"></ea:framelabel>
		<ea:framelabel id="Framelabel82" style="Z-INDEX: 140; LEFT: 483px; POSITION: absolute; TOP: 1570px" runat="server" DataMember="D.3Stawka" ValueStyle="Percent" Number="43" Height="28px" Width="56px"></ea:framelabel>
		<ea:framelabel id="Framelabel90" style="Z-INDEX: 140; LEFT: 539px; POSITION: absolute; TOP: 1570px" runat="server" DataMember="D.3Podatek" ValueStyle="ForceZl" Number="44" Height="28px"  Width="112px"></ea:framelabel>
		<!-- D4 -->
		<ea:framelabel id="FrameLabel40" style="Z-INDEX: 140; LEFT: 0px; POSITION: absolute; TOP: 1598px" runat="server" Height="28px" Width="42px" Text="D.4" HorizontalAlign="Center" FrameStyle="BigYellowBold"></ea:framelabel>
		<ea:framelabel id="FrameLabel50" style="Z-INDEX: 140; LEFT: 42px; POSITION: absolute; TOP: 1598px" runat="server" Height="28px" Width="56px" Text="11" HorizontalAlign="Center" FrameStyle="BigYellowBold"></ea:framelabel>
		<ea:framelabel id="FrameLabel63" style="Z-INDEX: 140; LEFT: 98px; POSITION: absolute; TOP: 1598px" runat="server" Height="28px" Width="161px" Text="Odsetki<br><i>[Interest]</i>" FrameStyle="SmallBoldYellow"></ea:framelabel>
		<ea:framelabel id="Framelabel113" style="Z-INDEX: 140; LEFT: 259px; POSITION: absolute; TOP: 1598px" runat="server" DataMember="D.4Zwolniony" ValueStyle="ForceZl" Number="45" Height="28px" Width="112px"></ea:framelabel>
		<ea:framelabel id="Framelabel74" style="Z-INDEX: 140; LEFT: 371px; POSITION: absolute; TOP: 1598px" runat="server" DataMember="D.4Kwota" ValueStyle="ForceZl" Number="46" Height="28px" Width="112px"></ea:framelabel>
		<ea:framelabel id="Framelabel83" style="Z-INDEX: 140; LEFT: 483px; POSITION: absolute; TOP: 1598px" runat="server" DataMember="D.4Stawka" ValueStyle="Percent" Number="47" Height="28px" Width="56px"></ea:framelabel>
		<ea:framelabel id="Framelabel91" style="Z-INDEX: 140; LEFT: 539px; POSITION: absolute; TOP: 1598px" runat="server" DataMember="D.4Podatek" ValueStyle="ForceZl" Number="48" Height="28px" Width="112px"></ea:framelabel>
		<!-- D5 -->
		<ea:framelabel id="FrameLabel42" style="Z-INDEX: 140; LEFT: 0px; POSITION: absolute; TOP: 1626px" runat="server" Height="28px" Width="42px" Text="D.5" HorizontalAlign="Center" FrameStyle="BigYellowBold"></ea:framelabel>
		<ea:framelabel id="FrameLabel51" style="Z-INDEX: 140; LEFT: 42px; POSITION: absolute; TOP: 1626px" runat="server" Height="28px" Width="56px" Text="12" HorizontalAlign="Center" FrameStyle="BigYellowBold"></ea:framelabel>
		<ea:framelabel id="FrameLabel64" style="Z-INDEX: 140; LEFT: 98px; POSITION: absolute; TOP: 1626px" runat="server" Height="28px" Width="161px" Text="Opłaty licencyjne<br><i>[Royalties]</i>" FrameStyle="SmallBoldYellow"></ea:framelabel>
		<ea:framelabel id="Framelabel114" style="Z-INDEX: 140; LEFT: 259px; POSITION: absolute; TOP: 1626px" runat="server" DataMember="D.5Zwolniony" ValueStyle="ForceZl" Number="49"  Height="28px" Width="112px"></ea:framelabel>
		<ea:framelabel id="Framelabel75" style="Z-INDEX: 140; LEFT: 371px; POSITION: absolute; TOP: 1626px" runat="server" DataMember="D.5Kwota" ValueStyle="ForceZl" Number="50" Height="28px" Width="112px"></ea:framelabel>
		<ea:framelabel id="Framelabel84" style="Z-INDEX: 140; LEFT: 483px; POSITION: absolute; TOP: 1626px" runat="server" DataMember="D.5Stawka" ValueStyle="Percent" Number="51" Height="28px" Width="56px"></ea:framelabel>
		<ea:framelabel id="Framelabel92" style="Z-INDEX: 140; LEFT: 539px; POSITION: absolute; TOP: 1626px" runat="server" DataMember="D.5Podatek" ValueStyle="ForceZl" Number="52" Height="28px"  Width="112px"></ea:framelabel>
		<!-- D6 -->
		<ea:framelabel id="FrameLabel43" style="Z-INDEX: 140; LEFT: 0px; POSITION: absolute; TOP: 1654px" runat="server" Height="42px" Width="42px" Text="D.6" HorizontalAlign="Center" FrameStyle="BigYellowBold"></ea:framelabel>
		<ea:framelabel id="FrameLabel52" style="Z-INDEX: 140; LEFT: 42px; POSITION: absolute; TOP: 1654px" runat="server" Height="42px" Width="56px" Text="17" HorizontalAlign="Center" FrameStyle="BigYellowBold"></ea:framelabel>
		<ea:framelabel id="FrameLabel65" style="Z-INDEX: 140; LEFT: 98px; POSITION: absolute; TOP: 1654px" runat="server" Height="42px" Width="161px" Text="Działalność widowiskowa, rozrywkowa lub sportowa<br><i>[Income derived by artists, musicians and by athletes]</i>" FrameStyle="SmallBoldYellow"></ea:framelabel>
		<ea:framelabel id="Framelabel115" style="Z-INDEX: 140; LEFT: 259px; POSITION: absolute; TOP: 1654px" runat="server" DataMember="D.6Zwolniony" ValueStyle="ForceZl" Number="53" Height="42px" Width="112px"></ea:framelabel>
		<ea:framelabel id="Framelabel76" style="Z-INDEX: 140; LEFT: 371px; POSITION: absolute; TOP: 1654px" runat="server" DataMember="D.6Kwota" ValueStyle="ForceZl" Number="54" Height="42px" Width="112px"></ea:framelabel>
		<ea:framelabel id="Framelabel85" style="Z-INDEX: 140; LEFT: 483px; POSITION: absolute; TOP: 1654px" runat="server" DataMember="D.6Stawka" ValueStyle="Percent" Number="55" Height="42px" Width="56px"></ea:framelabel>
		<ea:framelabel id="Framelabel93" style="Z-INDEX: 140; LEFT: 539px; POSITION: absolute; TOP: 1654px" runat="server" DataMember="D.6Podatek" ValueStyle="ForceZl" Number="56" Height="42px" Width="112px"></ea:framelabel>
		<!-- D7 -->
		<ea:framelabel id="Framelabel41" style="Z-INDEX: 140; LEFT: 0px; POSITION: absolute; TOP: 1696px" runat="server" Height="168px" Width="42px" Text="D.7" HorizontalAlign="Center" FrameStyle="BigYellowBold"></ea:framelabel>
		<ea:framelabel id="FrameLabel53" style="Z-INDEX: 140; LEFT: 42px; POSITION: absolute; TOP: 1696px" runat="server" Height="168px" Width="56px" Text="98" HorizontalAlign="Center" FrameStyle="BigYellowBold"></ea:framelabel>
		<ea:framelabel id="Framelabel97" style="Z-INDEX: 140; LEFT: 98px; POSITION: absolute; TOP: 1696px" runat="server" Height="168px" Width="161px" Text="Przychody z tytułu świadczeń: doradczych, księgowych, badania rynku, usług prawnych, usług reklamowych, zarządzania i kontroli, przetwarzania danych, usług rekrutacji pracowników i pozyskiwania personelu, gwarancji i poręczeń oraz świadczeń o podobnym charakterze, z wyłączeniem świadczeń wymienionych w poz. D.4, D.5 i D.6<br><i>[Profits from performances in consulting, accounting, market research, legal services, marketing services, management and control, data processing, recruitment services, guaranties and suretyships and other performances of the similar nature except those listed in lines D.4, D.5, D.6]</i>" FrameStyle="SmallBoldYellow"></ea:framelabel>
		<ea:framelabel id="Framelabel116" style="Z-INDEX: 140; LEFT: 259px; POSITION: absolute; TOP: 1696px" runat="server" DataMember="D.7Zwolniony" ValueStyle="ForceZl" Number="57" Height="168px" Width="112px"></ea:framelabel>
		<ea:framelabel id="Framelabel77" style="Z-INDEX: 140; LEFT: 371px; POSITION: absolute; TOP: 1696px" runat="server" DataMember="D.7Kwota" ValueStyle="ForceZl" Number="58" Height="168px"  Width="112px"></ea:framelabel>
		<ea:framelabel id="Framelabel86" style="Z-INDEX: 140; LEFT: 483px; POSITION: absolute; TOP: 1696px" runat="server" DataMember="D.7Stawka" ValueStyle="Percent" Number="59" Height="168px" Width="56px"></ea:framelabel>
		<ea:framelabel id="Framelabel94" style="Z-INDEX: 140; LEFT: 539px; POSITION: absolute; TOP: 1696px" runat="server" DataMember="D.7Podatek" ValueStyle="ForceZl" Number="60" Height="168px" Width="112px"></ea:framelabel>
		<!-- D8 -->
		<ea:framelabel id="FrameLabel44" style="Z-INDEX: 140; LEFT: 0px; POSITION: absolute; TOP: 1864px" runat="server" Height="42px" Width="42px" Text="D.8" HorizontalAlign="Center" FrameStyle="BigYellowBold"></ea:framelabel>
		<ea:framelabel id="Framelabel81" style="Z-INDEX: 140; LEFT: 42px; POSITION: absolute; TOP: 1864px" runat="server" Height="42px" Width="56px" Text="99" HorizontalAlign="Center" FrameStyle="BigYellowBold"></ea:framelabel>
		<ea:framelabel id="FrameLabel66" style="Z-INDEX: 140; LEFT: 98px; POSITION: absolute; TOP: 1864px" runat="server" Height="42px" Width="161px" Text="Przychód określony zgodnie z art. 21|i 22 ustawy|<i>[Income determined pursuant to Articles 21 and 22 of the Act]</i>" FrameStyle="SmallBoldYellow"></ea:framelabel>
		<ea:framelabel id="Framelabel117" style="Z-INDEX: 140; LEFT: 259px; POSITION: absolute; TOP: 1864px" runat="server" DataMember="D.8Zwolniony" ValueStyle="ForceZl" Number="61" Height="42px" Width="112px"></ea:framelabel>
		<ea:framelabel id="Framelabel98" style="Z-INDEX: 140; LEFT: 371px; POSITION: absolute; TOP: 1864px" runat="server" DataMember="D.8Kwota" ValueStyle="ForceZl" Number="62" Height="42px" Width="112px"></ea:framelabel>
		<ea:framelabel id="Framelabel99" style="Z-INDEX: 140; LEFT: 483px; POSITION: absolute; TOP: 1864px" runat="server" DataMember="D.8Stawka" ValueStyle="Percent" Number="63" Height="42px" Width="56px"></ea:framelabel>
		<ea:framelabel id="Framelabel101" style="Z-INDEX: 140; LEFT: 539px; POSITION: absolute; TOP: 1864px" runat="server" DataMember="D.8Podatek" ValueStyle="ForceZl" Number="64" Height="42px"  Width="112px"></ea:framelabel>

		<!-- PAGE 2/3 -->

		<ea:deklaracjafooter id="Deklaracjafooter1" style="z-index: 165; left: 0; position: absolute; top: 1975px" runat="server" Height="15px" Width="56px" Symbol="IFT-2/IFT-2R" PageNumber="2" PageTotal="3" Version="7" TitleWidth="130"></ea:deklaracjafooter>
		<ea:deklaracjaheader id="DeklaracjaHeader4" style="z-index: 100; left: 0; position: absolute; top: 2000px" runat="server" StylNagłówka="Caption" Caption="POLA JASNE WYPEŁNIA PODATNIK, POLA CIEMNE WYPEŁNIA URZĄD SKARBOWY. WYPEŁNIĆ NA MASZYNIE, KOMPUTEROWO LUB RĘCZNIE, DUŻYMI,<br>DRUKOWANYMI LITERAMI, CZARNYM LUB NIEBIESKIM KOLOREM. &amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;<b><i>Składanie w wersji elektronicznej:  www.portalpodatkowy.mf.gov.pl</i></b>"></ea:deklaracjaheader>
	
		<!-- PAGE 3 CONTENTS -->
		<!-- BLOK E -->
		<ea:framelabel id="FrameLabel45" style="Z-INDEX: 150; LEFT: 0; POSITION: absolute; TOP: 2024px" runat="server" Height="119px" Width="651px" Text="E. <FONT SIZE=2>ZOBOWIĄZANIA PODATKOWE Z TYTUŁU WYPŁAT, O KTÓRYCH MOWA W ART. 21 UST. 1|USTAWY, ORAZ Z TYTUŁU UDZIAŁU W ZYSKACH OSÓB PRAWNYCH, O KTÓRYCH MOWA|W ART. 22 UST. 1 USTAWY <SPAN style='font-weight:normal'>- część E wypełnia się, jeżeli formularz jest sporządzany za rok|podatkowy (IFT-2R).</SPAN>|<i>[TAX OBLIGATION RESULTING FROM PAYMENTS DETERMINED IN ART. 21 PAR. 1 OF THE ACT|AND FROM INCOME DETERMINED IN ART. 22 PAR. 1 OF THE ACT <SPAN style='font-weight:normal'>- part E shall be filled in if the|form is issued for the whole tax year (IFT-2R).]</SPAN></i>" FrameStyle="BigYellowBold"></ea:framelabel>
		<ea:framelabel id="Framelabel233" style="Z-INDEX: 150; LEFT: 3px; POSITION: absolute; TOP: 2123px" runat="server" Text="Kwoty wypłat i należnego podatku podaje się po zaokrągleniu do pełnych złotych. <i>[Amounts of income and tax should be rounded off to full zlotys.]</i>" Width="637px" Height="14px" FrameStyle="Small" FrameBorderStyle="None"></ea:framelabel>
		<ea:framelabel id="FrameLabel35" style="Z-INDEX: 150; LEFT: 0; POSITION: absolute; TOP: 2143px" runat="server" Height="42px" Width="651px" Text="SUMA KWOT POBRANEGO PODATKU W POSZCZEGÓLNYCH MIESIĄCACH|<i>[TOTAL AMOUNT OF TAX WITHHELD IN EACH MONTH]</i>" FrameStyle="BigYellow"></ea:framelabel>
		<!-- ROW1 -->
		<ea:framelabel id="FrameLabel46" style="Z-INDEX: 150; LEFT: 0; POSITION: absolute; TOP: 2185px" runat="server" Height="21px" Width="147px" Text="Miesiące <i>[Months]</i> <.INDEXUP>5)</.>" HorizontalAlign="Center" VerticalAlign="Middle" FrameStyle="MiddleBoldYellow"></ea:framelabel>
		<ea:framelabel id="FrameLabel54" style="Z-INDEX: 150; LEFT: 147px; POSITION: absolute; TOP: 2185px" runat="server" Height="21px" Width="84px" Text="1" HorizontalAlign="Center" VerticalAlign="Middle" FrameStyle="MiddleBoldYellow"></ea:framelabel>
		<ea:framelabel id="FrameLabel55" style="Z-INDEX: 150; LEFT: 231px; POSITION: absolute; TOP: 2185px" runat="server" Height="21px" Width="84px" Text="2" HorizontalAlign="Center" VerticalAlign="Middle" FrameStyle="MiddleBoldYellow"></ea:framelabel>
		<ea:framelabel id="FrameLabel67" style="Z-INDEX: 150; LEFT: 315px; POSITION: absolute; TOP: 2185px" runat="server" Height="21px" Width="84px" Text="3" HorizontalAlign="Center" VerticalAlign="Middle" FrameStyle="MiddleBoldYellow"></ea:framelabel>
		<ea:framelabel id="FrameLabel68" style="Z-INDEX: 150; LEFT: 399px; POSITION: absolute; TOP: 2185px" runat="server" Height="21px" Width="84px" Text="4" HorizontalAlign="Center" VerticalAlign="Middle" FrameStyle="MiddleBoldYellow"></ea:framelabel>
		<ea:framelabel id="FrameLabel78" style="Z-INDEX: 150; LEFT: 483px; POSITION: absolute; TOP: 2185px" runat="server" Height="21px" Width="84px" Text="5" HorizontalAlign="Center" VerticalAlign="Middle" FrameStyle="MiddleBoldYellow"></ea:framelabel>
		<ea:framelabel id="FrameLabel79" style="Z-INDEX: 150; LEFT: 567px; POSITION: absolute; TOP: 2185px" runat="server" Height="21px" Width="84px" Text="6" HorizontalAlign="Center" VerticalAlign="Middle" FrameStyle="MiddleBoldYellow"></ea:framelabel>
		<ea:framelabel id="FrameLabel87" style="Z-INDEX: 150; LEFT: 0px; POSITION: absolute; TOP: 2206px" runat="server" Height="49px" Width="147px" Text="Kwota dochodu|podlegającego|opodatkowaniu|<i>[Amount of taxable|income]</i>" HorizontalAlign="Center" FrameStyle="MiddleBoldYellow"></ea:framelabel>
		<ea:framelabel id="Framelabel95" style="Z-INDEX: 150; LEFT: 147px; POSITION: absolute; TOP: 2206px" runat="server" DataMember="E.1Dochod" ValueStyle="ForceZl" Number="65" Height="49px" Width="84px"></ea:framelabel>
		<ea:framelabel id="Framelabel96" style="Z-INDEX: 150; LEFT: 231px; POSITION: absolute; TOP: 2206px" runat="server" DataMember="E.2Dochod" ValueStyle="ForceZl" Number="66" Height="49px" Width="84px"></ea:framelabel>
		<ea:framelabel id="Framelabel100" style="Z-INDEX: 150; LEFT: 315px; POSITION: absolute; TOP: 2206px" runat="server" DataMember="E.3Dochod" ValueStyle="ForceZl" Number="67" Height="49px" Width="84px"></ea:framelabel>
		<ea:framelabel id="Framelabel118" style="Z-INDEX: 150; LEFT: 399px; POSITION: absolute; TOP: 2206px" runat="server" DataMember="E.4Dochod" ValueStyle="ForceZl" Number="68" Height="49px" Width="84px"></ea:framelabel>
		<ea:framelabel id="Framelabel119" style="Z-INDEX: 150; LEFT: 483px; POSITION: absolute; TOP: 2206px" runat="server" DataMember="E.5Dochod" ValueStyle="ForceZl" Number="69" Height="49px" Width="84px"></ea:framelabel>
		<ea:framelabel id="Framelabel88" style="Z-INDEX: 150; LEFT: 567px; POSITION: absolute; TOP: 2206px" runat="server" DataMember="E.6Dochod" ValueStyle="ForceZl" Number="70" Height="49px" Width="84px"></ea:framelabel>
		<ea:framelabel id="FrameLabel122" style="Z-INDEX: 150; LEFT: 0px; POSITION: absolute; TOP: 2255px" runat="server" Height="28px" Width="147px" Text="Kwota pobranego podatku|<i>[Amount of tax withheld]</i>" HorizontalAlign="Center" FrameStyle="MiddleBoldYellow"></ea:framelabel>
		<ea:framelabel id="Framelabel123" style="Z-INDEX: 150; LEFT: 147px; POSITION: absolute; TOP: 2255px" runat="server" DataMember="E.1Podatek" ValueStyle="ForceZl" Number="71" Height="28px" Width="84px"></ea:framelabel>
		<ea:framelabel id="Framelabel124" style="Z-INDEX: 150; LEFT: 231px; POSITION: absolute; TOP: 2255px" runat="server" DataMember="E.2Podatek" ValueStyle="ForceZl" Number="72" Height="28px" Width="84px"></ea:framelabel>
		<ea:framelabel id="Framelabel125" style="Z-INDEX: 150; LEFT: 315px; POSITION: absolute; TOP: 2255px" runat="server" DataMember="E.3Podatek" ValueStyle="ForceZl" Number="73" Height="28px" Width="84px"></ea:framelabel>
		<ea:framelabel id="Framelabel126" style="Z-INDEX: 150; LEFT: 399px; POSITION: absolute; TOP: 2255px" runat="server" DataMember="E.4Podatek" ValueStyle="ForceZl" Number="74" Height="28px" Width="84px"></ea:framelabel>
		<ea:framelabel id="Framelabel129" style="Z-INDEX: 150; LEFT: 483px; POSITION: absolute; TOP: 2255px" runat="server" DataMember="E.5Podatek" ValueStyle="ForceZl" Number="75" Height="28px" Width="84px"></ea:framelabel>
		<ea:framelabel id="Framelabel130" style="Z-INDEX: 150; LEFT: 567px; POSITION: absolute; TOP: 2255px" runat="server" DataMember="E.6Podatek" ValueStyle="ForceZl" Number="76" Height="28px" Width="84px"></ea:framelabel>
		<!-- ROW2 -->
		<ea:framelabel id="FrameLabel151" style="Z-INDEX: 150; LEFT: 0; POSITION: absolute; TOP: 2283px" runat="server" Height="21px" Width="147px" Text="Miesiące <i>[Months]</i> <.INDEXUP>5)</.>" HorizontalAlign="Center" VerticalAlign="Middle" FrameStyle="MiddleBoldYellow"></ea:framelabel>
		<ea:framelabel id="FrameLabel152" style="Z-INDEX: 150; LEFT: 147px; POSITION: absolute; TOP: 2283px" runat="server" Height="21px" Width="84px" Text="7" HorizontalAlign="Center" VerticalAlign="Middle" FrameStyle="MiddleBoldYellow"></ea:framelabel>
		<ea:framelabel id="FrameLabel160" style="Z-INDEX: 150; LEFT: 231px; POSITION: absolute; TOP: 2283px" runat="server" Height="21px" Width="84px" Text="8" HorizontalAlign="Center" VerticalAlign="Middle" FrameStyle="MiddleBoldYellow"></ea:framelabel>
		<ea:framelabel id="FrameLabel161" style="Z-INDEX: 150; LEFT: 315px; POSITION: absolute; TOP: 2283px" runat="server" Height="21px" Width="84px" Text="9" HorizontalAlign="Center" VerticalAlign="Middle" FrameStyle="MiddleBoldYellow"></ea:framelabel>
		<ea:framelabel id="FrameLabel162" style="Z-INDEX: 150; LEFT: 399px; POSITION: absolute; TOP: 2283px" runat="server" Height="21px" Width="84px" Text="10" HorizontalAlign="Center" VerticalAlign="Middle" FrameStyle="MiddleBoldYellow"></ea:framelabel>
		<ea:framelabel id="FrameLabel163" style="Z-INDEX: 150; LEFT: 483px; POSITION: absolute; TOP: 2283px" runat="server" Height="21px" Width="84px" Text="11" HorizontalAlign="Center" VerticalAlign="Middle" FrameStyle="MiddleBoldYellow"></ea:framelabel>
		<ea:framelabel id="FrameLabel164" style="Z-INDEX: 150; LEFT: 567px; POSITION: absolute; TOP: 2283px" runat="server" Height="21px" Width="84px" Text="12" HorizontalAlign="Center" VerticalAlign="Middle" FrameStyle="MiddleBoldYellow"></ea:framelabel>
		<ea:framelabel id="FrameLabel165" style="Z-INDEX: 150; LEFT: 0px; POSITION: absolute; TOP: 2304px" runat="server" Height="49px" Width="147px" Text="Kwota dochodu|podlegającego|opodatkowaniu|<i>[Amount of taxable|income]</i>" HorizontalAlign="Center" FrameStyle="MiddleBoldYellow"></ea:framelabel>
		<ea:framelabel id="Framelabel166" style="Z-INDEX: 150; LEFT: 147px; POSITION: absolute; TOP: 2304px" runat="server" DataMember="E.7Dochod" ValueStyle="ForceZl" Number="77" Height="49px" Width="84px"></ea:framelabel>
		<ea:framelabel id="Framelabel167" style="Z-INDEX: 150; LEFT: 231px; POSITION: absolute; TOP: 2304px" runat="server" DataMember="E.8Dochod" ValueStyle="ForceZl" Number="78" Height="49px" Width="84px"></ea:framelabel>
		<ea:framelabel id="Framelabel168" style="Z-INDEX: 150; LEFT: 315px; POSITION: absolute; TOP: 2304px" runat="server" DataMember="E.9Dochod" ValueStyle="ForceZl" Number="79" Height="49px" Width="84px"></ea:framelabel>
		<ea:framelabel id="Framelabel169" style="Z-INDEX: 150; LEFT: 399px; POSITION: absolute; TOP: 2304px" runat="server" DataMember="E.10Dochod" ValueStyle="ForceZl" Number="80" Height="49px" Width="84px"></ea:framelabel>
		<ea:framelabel id="Framelabel170" style="Z-INDEX: 150; LEFT: 483px; POSITION: absolute; TOP: 2304px" runat="server" DataMember="E.11Dochod" ValueStyle="ForceZl" Number="81" Height="49px" Width="84px"></ea:framelabel>
		<ea:framelabel id="Framelabel171" style="Z-INDEX: 150; LEFT: 567px; POSITION: absolute; TOP: 2304px" runat="server" DataMember="E.12Dochod" ValueStyle="ForceZl" Number="82" Height="49px" Width="84px"></ea:framelabel>
		<ea:framelabel id="FrameLabel172" style="Z-INDEX: 150; LEFT: 0px; POSITION: absolute; TOP: 2353px" runat="server" Height="28px" Width="147px" Text="Kwota pobranego podatku|<i>[Amount of tax withheld]</i>" HorizontalAlign="Center" FrameStyle="MiddleBoldYellow"></ea:framelabel>
		<ea:framelabel id="Framelabel173" style="Z-INDEX: 150; LEFT: 147px; POSITION: absolute; TOP: 2353px" runat="server" DataMember="E.7Podatek" ValueStyle="ForceZl" Number="83" Height="28px" Width="84px"></ea:framelabel>
		<ea:framelabel id="Framelabel174" style="Z-INDEX: 150; LEFT: 231px; POSITION: absolute; TOP: 2353px" runat="server" DataMember="E.8Podatek" ValueStyle="ForceZl" Number="84" Height="28px" Width="84px"></ea:framelabel>
		<ea:framelabel id="Framelabel175" style="Z-INDEX: 150; LEFT: 315px; POSITION: absolute; TOP: 2353px" runat="server" DataMember="E.9Podatek" ValueStyle="ForceZl" Number="85" Height="28px" Width="84px"></ea:framelabel>
		<ea:framelabel id="Framelabel176" style="Z-INDEX: 150; LEFT: 399px; POSITION: absolute; TOP: 2353px" runat="server" DataMember="E.10Podatek" ValueStyle="ForceZl" Number="86" Height="28px" Width="84px"></ea:framelabel>
		<ea:framelabel id="Framelabel177" style="Z-INDEX: 150; LEFT: 483px; POSITION: absolute; TOP: 2353px" runat="server" DataMember="E.11Podatek" ValueStyle="ForceZl" Number="87" Height="28px" Width="84px"></ea:framelabel>
		<ea:framelabel id="Framelabel178" style="Z-INDEX: 150; LEFT: 567px; POSITION: absolute; TOP: 2353px" runat="server" DataMember="E.12Podatek" ValueStyle="ForceZl" Number="88" Height="28px" Width="84px"></ea:framelabel>
		<!-- ROW3 -->
		<ea:framelabel id="FrameLabel179" style="Z-INDEX: 150; LEFT: 0; POSITION: absolute; TOP: 2381px" runat="server" Height="21px" Width="147px" Text="Miesiące <i>[Months]</i> <.INDEXUP>5)</.>" HorizontalAlign="Center" VerticalAlign="Middle" FrameStyle="MiddleBoldYellow"></ea:framelabel>
		<ea:framelabel id="FrameLabel180" style="Z-INDEX: 150; LEFT: 147px; POSITION: absolute; TOP: 2381px" runat="server" Height="21px" Width="84px" Text="13" HorizontalAlign="Center" VerticalAlign="Middle" FrameStyle="MiddleBoldYellow"></ea:framelabel>
		<ea:framelabel id="FrameLabel181" style="Z-INDEX: 150; LEFT: 231px; POSITION: absolute; TOP: 2381px" runat="server" Height="21px" Width="84px" Text="14" HorizontalAlign="Center" VerticalAlign="Middle" FrameStyle="MiddleBoldYellow"></ea:framelabel>
		<ea:framelabel id="FrameLabel182" style="Z-INDEX: 150; LEFT: 315px; POSITION: absolute; TOP: 2381px" runat="server" Height="21px" Width="84px" Text="15" HorizontalAlign="Center" VerticalAlign="Middle" FrameStyle="MiddleBoldYellow"></ea:framelabel>
		<ea:framelabel id="FrameLabel183" style="Z-INDEX: 150; LEFT: 399px; POSITION: absolute; TOP: 2381px" runat="server" Height="21px" Width="84px" Text="16" HorizontalAlign="Center" VerticalAlign="Middle" FrameStyle="MiddleBoldYellow"></ea:framelabel>
		<ea:framelabel id="FrameLabel184" style="Z-INDEX: 150; LEFT: 483px; POSITION: absolute; TOP: 2381px" runat="server" Height="21px" Width="84px" Text="17" HorizontalAlign="Center" VerticalAlign="Middle" FrameStyle="MiddleBoldYellow"></ea:framelabel>
		<ea:framelabel id="FrameLabel185" style="Z-INDEX: 150; LEFT: 567px; POSITION: absolute; TOP: 2381px" runat="server" Height="21px" Width="84px" Text="18" HorizontalAlign="Center" VerticalAlign="Middle" FrameStyle="MiddleBoldYellow"></ea:framelabel>
		<ea:framelabel id="FrameLabel186" style="Z-INDEX: 150; LEFT: 0px; POSITION: absolute; TOP: 2402px" runat="server" Height="49px" Width="147px" Text="Kwota dochodu|podlegającego|opodatkowaniu|<i>[Amount of taxable|income]</i>" HorizontalAlign="Center" FrameStyle="MiddleBoldYellow"></ea:framelabel>
		<ea:framelabel id="Framelabel187" style="Z-INDEX: 150; LEFT: 147px; POSITION: absolute; TOP: 2402px" runat="server" DataMember="E.13Dochod" ValueStyle="ForceZl" Number="89" Height="49px" Width="84px"></ea:framelabel>
		<ea:framelabel id="Framelabel188" style="Z-INDEX: 150; LEFT: 231px; POSITION: absolute; TOP: 2402px" runat="server" DataMember="E.14Dochod" ValueStyle="ForceZl" Number="90" Height="49px" Width="84px"></ea:framelabel>
		<ea:framelabel id="Framelabel189" style="Z-INDEX: 150; LEFT: 315px; POSITION: absolute; TOP: 2402px" runat="server" DataMember="E.15Dochod" ValueStyle="ForceZl" Number="91" Height="49px" Width="84px"></ea:framelabel>
		<ea:framelabel id="Framelabel190" style="Z-INDEX: 150; LEFT: 399px; POSITION: absolute; TOP: 2402px" runat="server" DataMember="E.16Dochod" ValueStyle="ForceZl" Number="92" Height="49px" Width="84px"></ea:framelabel>
		<ea:framelabel id="Framelabel191" style="Z-INDEX: 150; LEFT: 483px; POSITION: absolute; TOP: 2402px" runat="server" DataMember="E.17Dochod" ValueStyle="ForceZl" Number="93" Height="49px" Width="84px"></ea:framelabel>
		<ea:framelabel id="Framelabel192" style="Z-INDEX: 150; LEFT: 567px; POSITION: absolute; TOP: 2402px" runat="server" DataMember="E.18Dochod" ValueStyle="ForceZl" Number="94" Height="49px" Width="84px"></ea:framelabel>
		<ea:framelabel id="FrameLabel193" style="Z-INDEX: 150; LEFT: 0px; POSITION: absolute; TOP: 2451px" runat="server" Height="28px" Width="147px" Text="Kwota pobranego podatku|<i>[Amount of tax withheld]</i>" HorizontalAlign="Center" FrameStyle="MiddleBoldYellow"></ea:framelabel>
		<ea:framelabel id="Framelabel194" style="Z-INDEX: 150; LEFT: 147px; POSITION: absolute; TOP: 2451px" runat="server" DataMember="E.13Podatek" ValueStyle="ForceZl" Number="95" Height="28px" Width="84px"></ea:framelabel>
		<ea:framelabel id="Framelabel195" style="Z-INDEX: 150; LEFT: 231px; POSITION: absolute; TOP: 2451px" runat="server" DataMember="E.14Podatek" ValueStyle="ForceZl" Number="96" Height="28px" Width="84px"></ea:framelabel>
		<ea:framelabel id="Framelabel196" style="Z-INDEX: 150; LEFT: 315px; POSITION: absolute; TOP: 2451px" runat="server" DataMember="E.15Podatek" ValueStyle="ForceZl" Number="97" Height="28px" Width="84px"></ea:framelabel>
		<ea:framelabel id="Framelabel197" style="Z-INDEX: 150; LEFT: 399px; POSITION: absolute; TOP: 2451px" runat="server" DataMember="E.16Podatek" ValueStyle="ForceZl" Number="98" Height="28px" Width="84px"></ea:framelabel>
		<ea:framelabel id="Framelabel198" style="Z-INDEX: 150; LEFT: 483px; POSITION: absolute; TOP: 2451px" runat="server" DataMember="E.17Podatek" ValueStyle="ForceZl" Number="99" Height="28px" Width="84px"></ea:framelabel>
		<ea:framelabel id="Framelabel199" style="Z-INDEX: 150; LEFT: 567px; POSITION: absolute; TOP: 2451px" runat="server" DataMember="E.18Podatek" ValueStyle="ForceZl" Number="100" Height="28px" Width="84px"></ea:framelabel>
		<!-- ROW4 -->
		<ea:framelabel id="FrameLabel200" style="Z-INDEX: 150; LEFT: 0; POSITION: absolute; TOP: 2479px" runat="server" Height="21px" Width="147px" Text="Miesiące <i>[Months]</i> <.INDEXUP>5)</.>" HorizontalAlign="Center" VerticalAlign="Middle" FrameStyle="MiddleBoldYellow"></ea:framelabel>
		<ea:framelabel id="FrameLabel201" style="Z-INDEX: 150; LEFT: 147px; POSITION: absolute; TOP: 2479px" runat="server" Height="21px" Width="84px" Text="19" HorizontalAlign="Center" VerticalAlign="Middle" FrameStyle="MiddleBoldYellow"></ea:framelabel>
		<ea:framelabel id="FrameLabel202" style="Z-INDEX: 150; LEFT: 231px; POSITION: absolute; TOP: 2479px" runat="server" Height="21px" Width="84px" Text="20" HorizontalAlign="Center" VerticalAlign="Middle" FrameStyle="MiddleBoldYellow"></ea:framelabel>
		<ea:framelabel id="FrameLabel203" style="Z-INDEX: 150; LEFT: 315px; POSITION: absolute; TOP: 2479px" runat="server" Height="21px" Width="84px" Text="21" HorizontalAlign="Center" VerticalAlign="Middle" FrameStyle="MiddleBoldYellow"></ea:framelabel>
		<ea:framelabel id="FrameLabel204" style="Z-INDEX: 150; LEFT: 399px; POSITION: absolute; TOP: 2479px" runat="server" Height="21px" Width="84px" Text="22" HorizontalAlign="Center" VerticalAlign="Middle" FrameStyle="MiddleBoldYellow"></ea:framelabel>
		<ea:framelabel id="FrameLabel205" style="Z-INDEX: 150; LEFT: 483px; POSITION: absolute; TOP: 2479px" runat="server" Height="21px" Width="84px" Text="23" HorizontalAlign="Center" VerticalAlign="Middle" FrameStyle="MiddleBoldYellow"></ea:framelabel>
		<ea:framelabel id="FrameLabel206" style="Z-INDEX: 150; LEFT: 567px; POSITION: absolute; TOP: 2479px" runat="server" Height="21px" Width="84px" Text="Razem" HorizontalAlign="Center" VerticalAlign="Middle" FrameStyle="MiddleBoldYellow"></ea:framelabel>
		<ea:framelabel id="FrameLabel207" style="Z-INDEX: 150; LEFT: 0px; POSITION: absolute; TOP: 2500px" runat="server" Height="49px" Width="147px" Text="Kwota dochodu|podlegającego|opodatkowaniu|<i>[Amount of taxable|income]</i>" HorizontalAlign="Center" FrameStyle="MiddleBoldYellow"></ea:framelabel>
		<ea:framelabel id="Framelabel208" style="Z-INDEX: 150; LEFT: 147px; POSITION: absolute; TOP: 2500px" runat="server" DataMember="E.19Dochod" ValueStyle="ForceZl" Number="101" Height="49px" Width="84px"></ea:framelabel>
		<ea:framelabel id="Framelabel209" style="Z-INDEX: 150; LEFT: 231px; POSITION: absolute; TOP: 2500px" runat="server" DataMember="E.20Dochod" ValueStyle="ForceZl" Number="102" Height="49px" Width="84px"></ea:framelabel>
		<ea:framelabel id="Framelabel210" style="Z-INDEX: 150; LEFT: 315px; POSITION: absolute; TOP: 2500px" runat="server" DataMember="E.21Dochod" ValueStyle="ForceZl" Number="103" Height="49px" Width="84px"></ea:framelabel>
		<ea:framelabel id="Framelabel211" style="Z-INDEX: 150; LEFT: 399px; POSITION: absolute; TOP: 2500px" runat="server" DataMember="E.22Dochod" ValueStyle="ForceZl" Number="104" Height="49px" Width="84px"></ea:framelabel>
		<ea:framelabel id="Framelabel212" style="Z-INDEX: 150; LEFT: 483px; POSITION: absolute; TOP: 2500px" runat="server" DataMember="E.23Dochod" ValueStyle="ForceZl" Number="105" Height="49px" Width="84px"></ea:framelabel>
		<ea:framelabel id="Framelabel213" style="Z-INDEX: 150; LEFT: 567px; POSITION: absolute; TOP: 2500px" runat="server" DataMember="E.RazemDochod" ValueStyle="ForceZl" Number="106" Height="49px" Width="84px"></ea:framelabel>
		<ea:framelabel id="FrameLabel214" style="Z-INDEX: 150; LEFT: 0px; POSITION: absolute; TOP: 2549px" runat="server" Height="28px" Width="147px" Text="Kwota pobranego podatku|<i>[Amount of tax withheld]</i>" HorizontalAlign="Center" FrameStyle="MiddleBoldYellow"></ea:framelabel>
		<ea:framelabel id="Framelabel215" style="Z-INDEX: 150; LEFT: 147px; POSITION: absolute; TOP: 2549px" runat="server" DataMember="E.19Podatek" ValueStyle="ForceZl" Number="107" Height="28px" Width="84px"></ea:framelabel>
		<ea:framelabel id="Framelabel216" style="Z-INDEX: 150; LEFT: 231px; POSITION: absolute; TOP: 2549px" runat="server" DataMember="E.20Podatek" ValueStyle="ForceZl" Number="108" Height="28px" Width="84px"></ea:framelabel>
		<ea:framelabel id="Framelabel217" style="Z-INDEX: 150; LEFT: 315px; POSITION: absolute; TOP: 2549px" runat="server" DataMember="E.21Podatek" ValueStyle="ForceZl" Number="109" Height="28px" Width="84px"></ea:framelabel>
		<ea:framelabel id="Framelabel218" style="Z-INDEX: 150; LEFT: 399px; POSITION: absolute; TOP: 2549px" runat="server" DataMember="E.22Podatek" ValueStyle="ForceZl" Number="110" Height="28px" Width="84px"></ea:framelabel>
		<ea:framelabel id="Framelabel219" style="Z-INDEX: 150; LEFT: 483px; POSITION: absolute; TOP: 2549px" runat="server" DataMember="E.23Podatek" ValueStyle="ForceZl" Number="111" Height="28px" Width="84px"></ea:framelabel>
		<ea:framelabel id="Framelabel220" style="Z-INDEX: 150; LEFT: 567px; POSITION: absolute; TOP: 2549px" runat="server" DataMember="E.RazemPodatek" ValueStyle="ForceZl" Number="112" Height="28px" Width="84px"></ea:framelabel>

		<!-- BLOK F -->
		<ea:framelabel id="FrameLabel221" style="Z-INDEX: 160; LEFT: 0; POSITION: absolute; TOP: 2577px" runat="server" Height="70px" Width="651px" Text="F. INFORMACJE UZUPEŁNIAJĄCE <i>[SUPPLEMENTARY INFORMATION]</i>" FrameBorderStyle="DoubleHeader" FrameStyle="BigYellowBold"></ea:framelabel>
		<ea:framelabel id="FrameLabel222" style="Z-INDEX: 160; LEFT: 28px; POSITION: absolute; TOP: 2605px" runat="server" Height="42px" Width="343px" Text="Rok podatkowy płatnika może nie pokrywać się z rokiem kalendarzowym|i trwać nie dłużej niż 23 miesiące|<i>[The tax year of a tax remitter can be determined differently then as the calendar year and can last maximum 23 months.]</i>" FrameStyle="SmallBoldYellow"></ea:framelabel>
		<ea:framelabel id="Framelabel223" style="Z-INDEX: 160; LEFT: 371px; POSITION: absolute; TOP: 2605px" runat="server" DataMember="F.MiesiecyWRokPodatkowy" ValueStyle="CenterBottom" Number="113" Height="42px" Width="280px" Text="Liczba miesięcy składających się na rok podatkowy płatnika|<i>[Number of month of a tax remitter's tax year]</i>"></ea:framelabel>
		<!-- BLOK G -->
		<ea:framelabel id="Framelabel224" style="Z-INDEX: 170; LEFT: 0px; POSITION: absolute; TOP: 2647px" runat="server" Text="G. INFORMACJE DODATKOWE <i>[ADDITIONAL INFORMATION]</i>" Width="651px" Height="70px" FrameStyle="BigYellowBold" FrameBorderStyle="DoubleHeader"></ea:framelabel>
		<ea:framelabel id="Framelabel225" style="Z-INDEX: 170; LEFT: 28px; POSITION: absolute; TOP: 2675px; right: 1087px;" runat="server" Width="294px" Height="42px" Number="114" ValueStyle="DateWithoutInfo" DataMember="G.DataZłożenia" Text="Data złożenia wniosku przed podatnika <.Normal>(dzień-miesiąc-rok)<./>|<i>[Date of submitting the request by the taxpayer <.Normal>(day-month-year)<./>]</i> <.INDEXUP>6)<./>"></ea:framelabel>
		<ea:framelabel id="Framelabel226" style="Z-INDEX: 170; LEFT: 322px; POSITION: absolute; TOP: 2675px" runat="server" Width="329px" Height="42px" Number="115" ValueStyle="DateWithoutInfo" DataMember="G.DataPrzekazania" Text="Data przekazania lub przesłania informacji podatnikowi <.Normal>(dzień-miesiąc-rok)<./>|<i>[Date of conveying or sending information to remitter's <.Normal>(day-month-year)<./>]</i>"></ea:framelabel>
		<!-- BLOK H -->
		<ea:framelabel id="FrameLabel227" style="Z-INDEX: 180; LEFT: 0px; POSITION: absolute; TOP: 2717px" runat="server" Height="168px" Width="651px" Text="H. <FONT SIZE=2> PŁATNIK/PODMIOT LUB OSOBY UPOWAŻNIONE PRZEZ PŁATNIKA/PODMIOT<br/><i>[TAX REMITTER/ENTITY OR HIS AUTHORIZED REPRESENTATIVE]</i>" FrameBorderStyle="DoubleHeader" FrameStyle="BigYellowBold"></ea:framelabel>
		<ea:framelabel id="FrameLabel228" style="Z-INDEX: 180; LEFT: 28px; POSITION: absolute; TOP: 2759px" runat="server" DataMember="H.Imię" Number="116" Height="28px" Width="280px" Text="Imię <i>[Name]</i>"></ea:framelabel>
		<ea:framelabel id="FrameLabel229" style="Z-INDEX: 180; LEFT: 308px; POSITION: absolute; TOP: 2759px" runat="server" DataMember="H.Nazwisko" Number="117" Height="28px" Width="343px" Text="Nazwisko <i>[Family name]</i>"></ea:framelabel>
		<ea:framelabel id="FrameLabel230" style="Z-INDEX: 180; LEFT: 28px; POSITION: absolute; TOP: 2787px" runat="server" DataMember="H.Data" ValueStyle="DateWithoutInfo" Number="118" Height="49px" Width="280px" Text="Data sporządzenia informacji <.Normal>(dzień-miesiąc-rok)<./><br><i>[Date of filling in the form <.Normal>(day-month-year)<./>]</i>"></ea:framelabel>
		<ea:framelabel id="FrameLabel231" style="Z-INDEX: 180; LEFT: 308px; POSITION: absolute; TOP: 2787px" runat="server" DataMember="H.Podpis" Number="119" Height="49px" Width="343px"  Text="Podpis i pieczątka osoby odpowiedzialnej za treść informacji&lt;br&gt;&lt;i&gt;[Signature and seal of person responsible for contents of information]&lt;/i&gt;"></ea:framelabel>
		<ea:framelabel id="Framelabel232" style="Z-INDEX: 180; LEFT: 28px; POSITION: absolute; TOP: 2836px" runat="server" DataMember="H.Podpis" Number="120" Height="49px" Width="623px" Text="Podpisy i pieczątki osoby / osób uprawnionych lub upoważnionych do reprezentowania płatnika / podmiotu &lt;br&gt;&lt;i&gt;[Signature and seal of authorised person(s)]&lt;/i&gt;"></ea:framelabel>
	
		<!-- PAGE 3 CONCLUSION -->
	
		<ea:framelabel id="FrameLabel235" style="Z-INDEX: 190; LEFT: 250px; POSITION: absolute; TOP: 2900px" runat="server" Width="307px" Height="35px" Text="&lt;font STYLE='font-size: 7pt; font-weight:bold;'&gt;Pouczenie &lt;i&gt;[Caution]&lt;/i&gt;&lt;/font&gt;" FrameStyle="Small" FrameBorderStyle="None"></ea:framelabel>
		<ea:framelabel id="FrameLabel236" style="Z-INDEX: 190; LEFT: 0px; POSITION: absolute; TOP: 2915px" runat="server" Height="49px" Width="651px" Text="Za uchybienie obowiązkom płatnika/podmiotu grozi odpowiedzialność przewidziana w Kodeksie karnym skarbowym.&lt;br/&gt;&lt;i&gt;[The infringement of tax remitter’s / entity’s duties shall be subject to the sanctions provided for the Fiscal Penal Code.]&lt;/i&gt;" FrameBorderStyle="None" FrameStyle="Small"></ea:framelabel>
		
		<ea:deklaracjafooter id="Deklaracjafooter2" style="z-index: 165; left: 483px; position: absolute; top: 2975px" runat="server" Height="15px" Width="56px" Symbol="IFT-2/IFT-2R" PageNumber="3" PageTotal="3" Version="7" TitleWidth="130"></ea:deklaracjafooter>
	</form>
</body>
</html>
