﻿
<%@ Page Language="C#" AutoEventWireup="false" CodePage="1200" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Core" %>
<%@ Import Namespace="Soneta.Deklaracje" %>
<%@ Import Namespace="Soneta.Deklaracje.CIT" %>
<%@ Import Namespace="Soneta.Deklaracje.PIT" %>

<script runat="server">

	bool _roczna;

	private void OnContextLoad(Object sender, EventArgs args)
	{
		var dek = (IFT2) dc[typeof (IFT2)];
		_roczna = dek.Roczna;
		ORD_ZU.Visible = dek.TreśćUzasadnienia != "";


		bool osobaFizyczna = (bool) dek.Bloki["B1"]["OsobaFiz"];
		string[] nazwa = PIT.DaneFirmy((string) dek.Bloki["B1"]["Nazwa"], osobaFizyczna);

		if (osobaFizyczna)
		{
			OsobaNieFizyczna.Visible = false;
			if (nazwa.Length > 0)
				Nazwisko.EditValue = nazwa[0].Trim();
			if (nazwa.Length > 1)
				ImiePierwsze.EditValue = nazwa[1].Trim();
			if (nazwa.Length > 2)
				DataUrodzenia.EditValue = nazwa[2].Trim();
		}
		else
		{
			OsobaFizyczna.Visible = false;
			if (nazwa.Length > 0)
				NazwaPelna.EditValue = nazwa[0].Trim();
		}

		var kraj = ((string) dek.Bloki["B2"]["Kraj"]).ToUpper();
		if (kraj == "" || kraj == "POLSKA")
			AdresZagrPl.Visible = false;
		else
			AdresPolPl.Visible = false;

		var blokC1 = dek.Bloki["C1"];
		if ((bool) blokC1["IdentyfikacjaPodatkowa"])
		{
			RodzajIdentyfikacji.EditValue = 1;
		}
		else if ((bool) blokC1["IdentyfikacjaInna"])
		{
			RodzajIdentyfikacji.EditValue = 2;
		}

		if ((bool) blokC1["PodmiotyPowiazaneTak"])
			PodmiotyPowiazane.EditValue = 1;
		else if ((bool) blokC1["PodmiotyPowiazaneNie"])
			PodmiotyPowiazane.EditValue = 2;
		else
			PodmiotyPowiazane.EditValue = 0;

		var blokC2 = dek.Bloki["C2"];
		var kodKraju2 = GetKodKraju(dek.Session, (string) blokC2["Kraj"]);

		Podmiot2KodKraju.EditValue = kodKraju2;

		if (kodKraju2 == "" || kodKraju2 == "PL")
			PokazujNIP.Visible = true;
		else
			PokazujNIP.Visible = false;

		if (_roczna)
		{
			BlokiQR.Visible = true;
			DataZlozenia.Visible = false;
		}
		else
		{
			BlokiQR.Visible = false;
			DataZlozenia.Visible = true;
		}

		decimal d33 = ((decimal) dek.GetWartoscPola("D", "1Zwolniony"));
		decimal d34 = ((decimal) dek.GetWartoscPola("D", "1Kwota"));
		decimal d35 = ((decimal) dek.GetWartoscPola("D", "1Podatek"));
				  
		decimal d36 = ((decimal) dek.GetWartoscPola("D", "2Zwolniony"));
		decimal d37 = ((decimal) dek.GetWartoscPola("D", "2Kwota"));
		decimal d38 = ((decimal) dek.GetWartoscPola("D", "2Podatek"));
				  
		decimal d39 = ((decimal) dek.GetWartoscPola("D", "3Zwolniony"));
		decimal d40 = ((decimal) dek.GetWartoscPola("D", "3Kwota"));
		decimal d41 = ((decimal) dek.GetWartoscPola("D", "3Podatek"));
				  
		decimal d42 = ((decimal) dek.GetWartoscPola("D", "4Zwolniony"));
		decimal d43 = ((decimal) dek.GetWartoscPola("D", "4Kwota"));
		decimal d44 = ((decimal) dek.GetWartoscPola("D", "4Podatek"));
				  
		decimal d45 = ((decimal) dek.GetWartoscPola("D", "5Zwolniony"));
		decimal d46 = ((decimal) dek.GetWartoscPola("D", "5Kwota"));
		decimal d47 = ((decimal) dek.GetWartoscPola("D", "5Podatek"));
				  
		decimal d48 = ((decimal) dek.GetWartoscPola("D", "6Zwolniony"));
		decimal d49 = ((decimal) dek.GetWartoscPola("D", "6Kwota"));
		decimal d50 = ((decimal) dek.GetWartoscPola("D", "6Podatek"));

		decimal d51 = ((decimal) dek.GetWartoscPola("D", "7Zwolniony"));
		decimal d52 = ((decimal) dek.GetWartoscPola("D", "7Kwota"));
		decimal d53 = ((decimal) dek.GetWartoscPola("D", "7Podatek"));

		decimal d54 = ((decimal) dek.GetWartoscPola("D", "8Zwolniony"));
		decimal d55 = ((decimal) dek.GetWartoscPola("D", "8Kwota"));
		decimal d56 = ((decimal) dek.GetWartoscPola("D", "8Podatek"));
		decimal d57 = ((decimal) dek.GetWartoscPola("D", "8PodatekArt26"));

		decimal d58 = ((decimal) dek.GetWartoscPola("D", "9Zwolniony"));
		decimal d59 = ((decimal) dek.GetWartoscPola("D", "9Kwota"));
		decimal d60 = ((decimal) dek.GetWartoscPola("D", "9Podatek"));
		decimal d61 = ((decimal) dek.GetWartoscPola("D", "9PodatekArt26"));

		decimal d62 = ((decimal) dek.GetWartoscPola("D", "10Zwolniony"));
		decimal d63 = ((decimal) dek.GetWartoscPola("D", "10Kwota"));
		decimal d64 = ((decimal) dek.GetWartoscPola("D", "10Podatek"));
		decimal d65 = ((decimal) dek.GetWartoscPola("D", "10PodatekArt26"));

		decimal d66 = ((decimal) dek.GetWartoscPola("D", "11Zwolniony"));
		decimal d67 = ((decimal) dek.GetWartoscPola("D", "11Kwota"));
		decimal d68 = ((decimal) dek.GetWartoscPola("D", "11Podatek"));

		decimal d69 = ((decimal) dek.GetWartoscPola("D", "12Zwolniony"));
		decimal d70 = ((decimal) dek.GetWartoscPola("D", "12Kwota"));
		decimal d71 = ((decimal) dek.GetWartoscPola("D", "12Podatek"));

		//  Ukrywanie pozycji edeklaracji
		if (d33 > 0 || d34 > 0 || d35 > 0)
			Widocznosc33_35.Visible = true;
		else
			Widocznosc33_35.Visible = false;

		if (d36 > 0 || d37 > 0 || d38 > 0)
			Widocznosc36_38.Visible = true;
		else
			Widocznosc36_38.Visible = false;

		if (d39 > 0 || d40 > 0 || d41 > 0)
			Widocznosc39_41.Visible = true;
		else
			Widocznosc39_41.Visible = false;

		if (d42 > 0 || d43 > 0 || d44 > 0)
			Widocznosc42_44.Visible = true;
		else
			Widocznosc42_44.Visible = false;

		if (d45 > 0 || d46 > 0 || d47 > 0)
			Widocznosc45_47.Visible = true;
		else
			Widocznosc45_47.Visible = false;

		if (d48 > 0 || d49 > 0 || d50 > 0)
			Widocznosc48_50.Visible = true;
		else
			Widocznosc48_50.Visible = false;

		if (d51 > 0 || d52 > 0 || d53 > 0)
			Widocznosc51_53.Visible = true;
		else
			Widocznosc51_53.Visible = false;

		if (d54 > 0 || d55 > 0 || d56 > 0 || d57 > 0)
			Widocznosc54_57.Visible = true;
		else
			Widocznosc54_57.Visible = false;

		if (d58 > 0 || d59 > 0 || d60 > 0 || d61 > 0)
			Widocznosc58_61.Visible = true;
		else
			Widocznosc58_61.Visible = false;

		if (d62 > 0 || d63 > 0 || d64 > 0 || d65 > 0)
			Widocznosc62_65.Visible = true;
		else
			Widocznosc62_65.Visible = false;

		if (d66 > 0 || d67 > 0 || d68 > 0)
			Widocznosc66_68.Visible = true;
		else
			Widocznosc66_68.Visible = false;

		if (d69 > 0 || d70 > 0 || d71 > 0)
			Widocznosc69_71.Visible = true;
		else
			Widocznosc69_71.Visible = false;
	}
	

	private static string GetKodKraju(Session session, string nazwaKraju)
	{
		var krajTbl = session.Get<CoreModule>().KrajeTbl.WgNazwa[nazwaKraju];
		return krajTbl != null ? krajTbl.Kod2 : "";
	}




</script>
<ea:datacontext id="dc" runat="server" TypeName="Soneta.Deklaracje.CIT.IFT2,Soneta.Deklaracje" OnContextLoad="OnContextLoad"></ea:datacontext>
<?xml version="1.0" encoding="UTF-8"?>
<%if (_roczna) { %>
<Deklaracja
	xmlns="http://crd.gov.pl/wzor/2025/10/27/13953/"
	xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
	xsi:schemaLocation="http://crd.gov.pl/wzor/2025/10/27/13953/ http://crd.gov.pl/wzor/2025/10/27/13953/schemat.xsd"
	xmlns:etd="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2022/09/13/eD/DefinicjeTypy/"
	xmlns:zzu="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2022/09/13/eD/ORDZU/"
	xmlns:kus="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2022/01/05/eD/KodyUrzedowSkarbowych/"
	xmlns:kk="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2023/09/06/eD/KodyKrajow/"
	xmlns:tns="http://crd.gov.pl/wzor/2025/10/27/13953/" >
<%} else {%>
<Deklaracja
	xmlns="http://crd.gov.pl/wzor/2025/10/27/13948/"
	xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
	xsi:schemaLocation="http://crd.gov.pl/wzor/2025/10/27/13948/ http://crd.gov.pl/wzor/2025/10/27/13948/schemat.xsd"
	xmlns:etd="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2022/09/13/eD/DefinicjeTypy/"
	xmlns:zzu="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2022/09/13/eD/ORDZU/" 
	xmlns:kus="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2022/01/05/eD/KodyUrzedowSkarbowych/"
	xmlns:kk="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2023/09/06/eD/KodyKrajow/"
	xmlns:tns="http://crd.gov.pl/wzor/2025/10/27/13948/" >
<%}%>
	<Naglowek>
<%if (_roczna) { %>
		<KodFormularza kodSystemowy="IFT-2R (12)" kodPodatku="CIT" rodzajZobowiazania="Z" wersjaSchemy="1-0E">IFT-2/IFT-2R</KodFormularza>
<%} else {%>
		<KodFormularza kodSystemowy="IFT-2 (12)" kodPodatku="CIT" rodzajZobowiazania="Z" wersjaSchemy="1-0E">IFT-2/IFT-2R</KodFormularza>
<%}%>
		<WariantFormularza>12</WariantFormularza>
		<CelZlozenia poz="P_7"><ea:XmlDataLabel runat="server" DataMember="A.Korekta"><ValuesMap><ea:ValuesPair Key="False" Value="1" /><ea:ValuesPair Key="True" Value="2"/></ValuesMap></ea:XmlDataLabel></CelZlozenia>
		<OkresOd poz="P_4"><ea:XmlDataLabel runat="server" DataMember="0.Od" XSDType="TData" ></ea:XmlDataLabel></OkresOd>
		<OkresDo poz="P_5"><ea:XmlDataLabel runat="server" DataMember="0.Do" XSDType="TData" ></ea:XmlDataLabel></OkresDo>
		<ea:XmlDataLabel ElementName="KodUrzedu" runat="server" DataMember="X.KodUrzeduSkarbowego" />
	</Naglowek>
	<Podmiot1 rola="Płatnik/Podmiot (Wypłacający Należność)">
		<ea:Section ID="OsobaFizyczna" runat="server"><OsobaFizyczna>
			<ea:XmlDataLabel ElementName="tns:NIP" runat="server" DataMember="0.Nip" XSDType="TNrNIP"/>
			<ea:XmlDataLabel ElementName="tns:ImiePierwsze" ID="ImiePierwsze" runat="server" XSDType="TImie" />
			<ea:XmlDataLabel ElementName="tns:Nazwisko" ID="Nazwisko" runat="server" XSDType="TNazwisko" />
			<ea:XmlDataLabel ElementName="tns:DataUrodzenia" ID="DataUrodzenia" runat="server" XSDType="TData" />
		</OsobaFizyczna></ea:Section>
		<ea:Section ID="OsobaNieFizyczna" runat="server"><OsobaNiefizyczna>
			<ea:XmlDataLabel ElementName="NIP" runat="server" DataMember="0.Nip" XSDType="TNrNIP"/>
			<ea:XmlDataLabel ElementName="PelnaNazwa" ID="NazwaPelna" runat="server" XSDType="TZnakowy" />
		</OsobaNiefizyczna></ea:Section>
		<AdresZamieszkaniaSiedziby rodzajAdresu="RAD">
			<ea:Section ID="AdresPolPl" runat="server">
			<tns:AdresPol>
				<tns:KodKraju>PL</tns:KodKraju>
				<ea:XmlDataLabel ElementName="tns:Wojewodztwo" runat="server" DataMember="B2.Wojew" XSDType="TJednAdmin" />
				<ea:XmlDataLabel ElementName="tns:Powiat" runat="server" DataMember="B2.Powiat" XSDType="TJednAdmin"/>
				<ea:XmlDataLabel ElementName="tns:Gmina" runat="server" DataMember="B2.Gmina" XSDType="TJednAdmin"/>
				<ea:XmlDataLabel ElementName="tns:Ulica" runat="server" HideEmptyOrZero="true" DataMember="B2.Ulica" XSDType="TUlica"/>
				<ea:XmlDataLabel ElementName="tns:NrDomu" runat="server" DataMember="B2.NrDomu" XSDType="TNrBudynku"/>
				<ea:XmlDataLabel ElementName="tns:NrLokalu" runat="server" HideEmptyOrZero="true" DataMember="B2.NrLokalu" XSDType="TNrLokalu"/>
				<ea:XmlDataLabel ElementName="tns:Miejscowosc" runat="server" DataMember="B2.Miejsc" XSDType="TMiejscowosc"/>
				<ea:XmlDataLabel ElementName="tns:KodPocztowy" runat="server" DataMember="B2.KodPoczt" XSDType="TKodPocztowy"/>
			</tns:AdresPol>
			</ea:Section>
			<ea:Section ID="AdresZagrPl" runat="server">
			<AdresZagr>
				<ea:XmlDataLabel ElementName="KodKraju" runat="server" DataMember="B2.KodKrajuPl" XSDType="TTekstowy"/>
				<ea:XmlDataLabel ElementName="KodPocztowy" runat="server" DataMember="B2.KodPoczt" XSDType="TKodPocztowy" HideEmptyOrZero="true"/>
				<ea:XmlDataLabel ElementName="Miejscowosc" runat="server" DataMember="B2.Miejsc" XSDType="TMiejscowosc"/>
				<ea:XmlDataLabel ElementName="Ulica" runat="server" DataMember="B2.Ulica" XSDType="TUlica" HideEmptyOrZero="true"/>
				<ea:XmlDataLabel ElementName="NrDomu" runat="server" DataMember="B2.NrDomu" XSDType="TNrBudynku" HideEmptyOrZero="true"/>
				<ea:XmlDataLabel ElementName="NrLokalu" runat="server" DataMember="B2.NrLokalu" XSDType="TNrLokalu" HideEmptyOrZero="true"/>
			</AdresZagr>
			</ea:Section>
		</AdresZamieszkaniaSiedziby>
	</Podmiot1>
	<Podmiot2 rola="Podatnik (Odbiorca Należności)">
		<OsobaNieFizZagr>
			<ea:XmlDataLabel ElementName="tns:PelnaNazwa" runat="server" DataMember="C1.NazwaPelna" XSDType="TZnakowy"/>
			<ea:XmlDataLabel ElementName="tns:SkroconaNazwa" runat="server" DataMember="C1.NazwaSkrocona" XSDType="TZnakowy"/>
				 <ea:Section ID="PokazujNIP" runat="server">
			<ea:XmlDataLabel ElementName="tns:NIP" runat="server" DataMember="C1.Nip" XSDType="TNrNIP" HideEmptyOrZero="false"/>
						  </ea:Section>
			<ea:XmlDataLabel ElementName="DataRozpoczeciaDzialalnosci" PozAttribute="P_22" runat="server" DataMember="C1.RozpoczecieDzialalnosci" XSDType="TData" HideEmptyOrZero="True"/>

			<ea:XmlDataLabel ID="RodzajIdentyfikacji" ElementName="RodzajIdentyfikacji" PozAttribute="P_23" runat="server" XSDType="TCalkowity"/>
			<ea:XmlDataLabel ElementName="NumerIdentyfikacyjnyPodatnika" PozAttribute="P_24" runat="server" DataMember="C1.NrIdentyfikacyjny" XSDType="TZnakowy"/>
			<ea:XmlDataLabel ElementName="tns:KodKrajuWydania" PozAttribute="P_25" runat="server" DataMember="C1.KodKraju" XSDType="TZnakowy"/>
		</OsobaNieFizZagr>
		<AdresSiedziby rodzajAdresu="RAD">
			<ea:XmlDataLabel ElementName="KodKraju" ID="Podmiot2KodKraju" runat="server" XSDType="TTekstowy"/>
			<ea:XmlDataLabel ElementName="KodPocztowy" runat="server" DataMember="C2.KodPoczt" XSDType="TKodPocztowy" HideEmptyOrZero="true"/>
			<ea:XmlDataLabel ElementName="Miejscowosc" ID="pit_miejscZagr" runat="server" DataMember="C2.Miejsc" XSDType="TMiejscowosc"/>
			<ea:XmlDataLabel ElementName="Ulica" runat="server" DataMember="C2.Ulica" XSDType="TUlica" HideEmptyOrZero="true"/>
			<ea:XmlDataLabel ElementName="NrDomu" runat="server" DataMember="C2.NrDomu" XSDType="TNrBudynku" HideEmptyOrZero="true"/>
			<ea:XmlDataLabel ElementName="NrLokalu" runat="server" DataMember="C2.NrLokalu" XSDType="TNrLokalu" HideEmptyOrZero="true"/>
		</AdresSiedziby>
	</Podmiot2>
	<PozycjeSzczegolowe>
		<ea:XmlDataLabel ElementName="P_26" runat="server" ID="PodmiotyPowiazane" XSDType="TWybor1" HideEmptyOrZero="true"/>
		<ea:Section ID="Widocznosc33_35" runat="server">
			<ea:XmlDataLabel ElementName="P_33" runat="server" DataMember="D.1Zwolniony" XSDType="TKwotaC" HideEmptyOrZero="false"/>
			<ea:XmlDataLabel ElementName="P_34" runat="server" DataMember="D.1Kwota" XSDType="TKwotaC" HideEmptyOrZero="false"/>
			<ea:XmlDataLabel ElementName="P_35" runat="server" DataMember="D.1Podatek" XSDType="TKwotaC" HideEmptyOrZero="false"/>
			<P_E typ ="G" >
				<ea:XmlDataLabel ElementName="P_E1" runat="server" DataMember="E.1Stawka" XSDType="TProcentowy" HideEmptyOrZero="false"/>
				<ea:XmlDataLabel ElementName="P_E2" runat="server" DataMember="E.1Zwolniony" XSDType="TKwotaC" HideEmptyOrZero="false"/>
				<ea:XmlDataLabel ElementName="P_E3" runat="server" DataMember="E.1Kwota" XSDType="TKwotaC" HideEmptyOrZero="false"/>
				<ea:XmlDataLabel ElementName="P_E4" runat="server" DataMember="E.1Podatek" XSDType="TKwotaC" HideEmptyOrZero="false"/>
			</P_E>
			<P_E typ ="G" >
				<ea:XmlDataLabel ElementName="P_E1" runat="server" DataMember="E.2Stawka" XSDType="TProcentowy" HideEmptyOrZero="false"/>
				<ea:XmlDataLabel ElementName="P_E2" runat="server" DataMember="E.2Zwolniony" XSDType="TKwotaC" HideEmptyOrZero="false"/>
				<ea:XmlDataLabel ElementName="P_E3" runat="server" DataMember="E.2Kwota" XSDType="TKwotaC" HideEmptyOrZero="false"/>
				<ea:XmlDataLabel ElementName="P_E4" runat="server" DataMember="E.2Podatek" XSDType="TKwotaC" HideEmptyOrZero="false"/>
			</P_E>
			
		</ea:Section>

		<ea:Section ID="Widocznosc36_38" runat="server">
			<ea:XmlDataLabel ElementName="P_36" runat="server" DataMember="D.2Zwolniony" XSDType="TKwotaC" HideEmptyOrZero="false"/>
			<ea:XmlDataLabel ElementName="P_37" runat="server" DataMember="D.2Kwota" XSDType="TKwotaC" HideEmptyOrZero="false"/>
			<ea:XmlDataLabel ElementName="P_38" runat="server" DataMember="D.2Podatek" XSDType="TKwotaC" HideEmptyOrZero="false"/>
			<P_F typ ="G" >
				<ea:XmlDataLabel ElementName="P_F1" runat="server" DataMember="F.1Stawka" XSDType="TProcentowy" HideEmptyOrZero="false"/>
				<ea:XmlDataLabel ElementName="P_F2" runat="server" DataMember="F.1Zwolniony" XSDType="TKwotaC" HideEmptyOrZero="false"/>
				<ea:XmlDataLabel ElementName="P_F3" runat="server" DataMember="F.1Kwota" XSDType="TKwotaC" HideEmptyOrZero="false"/>
				<ea:XmlDataLabel ElementName="P_F4" runat="server" DataMember="F.1Podatek" XSDType="TKwotaC" HideEmptyOrZero="false"/>
			</P_F>
			<P_F typ ="G" >
				<ea:XmlDataLabel ElementName="P_F1" runat="server" DataMember="F.2Stawka" XSDType="TProcentowy" HideEmptyOrZero="false"/>
				<ea:XmlDataLabel ElementName="P_F2" runat="server" DataMember="F.2Zwolniony" XSDType="TKwotaC" HideEmptyOrZero="false"/>
				<ea:XmlDataLabel ElementName="P_F3" runat="server" DataMember="F.2Kwota" XSDType="TKwotaC" HideEmptyOrZero="false"/>
				<ea:XmlDataLabel ElementName="P_F4" runat="server" DataMember="F.2Podatek" XSDType="TKwotaC" HideEmptyOrZero="false"/>
			</P_F>
		</ea:Section>

		<ea:Section ID="Widocznosc39_41" runat="server">
			<ea:XmlDataLabel ElementName="P_39" runat="server" DataMember="D.3Zwolniony" XSDType="TKwotaC" HideEmptyOrZero="false"/>
			<ea:XmlDataLabel ElementName="P_40" runat="server" DataMember="D.3Kwota" XSDType="TKwotaC" HideEmptyOrZero="false"/>
			<ea:XmlDataLabel ElementName="P_41" runat="server" DataMember="D.3Podatek" XSDType="TKwotaC" HideEmptyOrZero="false"/>
			<P_G typ ="G" >
				<ea:XmlDataLabel ElementName="P_G1" runat="server" DataMember="G.1Stawka" XSDType="TProcentowy" HideEmptyOrZero="false"/>
				<ea:XmlDataLabel ElementName="P_G2" runat="server" DataMember="G.1Zwolniony" XSDType="TKwotaC" HideEmptyOrZero="false"/>
				<ea:XmlDataLabel ElementName="P_G3" runat="server" DataMember="G.1Kwota" XSDType="TKwotaC" HideEmptyOrZero="false"/>
				<ea:XmlDataLabel ElementName="P_G4" runat="server" DataMember="G.1Podatek" XSDType="TKwotaC" HideEmptyOrZero="false"/>
			</P_G>
			<P_G typ ="G" >
				<ea:XmlDataLabel ElementName="P_G1" runat="server" DataMember="G.2Stawka" XSDType="TProcentowy" HideEmptyOrZero="false"/>
				<ea:XmlDataLabel ElementName="P_G2" runat="server" DataMember="G.2Zwolniony" XSDType="TKwotaC" HideEmptyOrZero="false"/>
				<ea:XmlDataLabel ElementName="P_G3" runat="server" DataMember="G.2Kwota" XSDType="TKwotaC" HideEmptyOrZero="false"/>
				<ea:XmlDataLabel ElementName="P_G4" runat="server" DataMember="G.2Podatek" XSDType="TKwotaC" HideEmptyOrZero="false"/>
			</P_G>
		</ea:Section>

		<ea:Section ID="Widocznosc42_44" runat="server">
			<ea:XmlDataLabel ElementName="P_42" runat="server" DataMember="D.4Zwolniony" XSDType="TKwotaC" HideEmptyOrZero="false"/>
			<ea:XmlDataLabel ElementName="P_43" runat="server" DataMember="D.4Kwota" XSDType="TKwotaC" HideEmptyOrZero="false"/>
			<ea:XmlDataLabel ElementName="P_44" runat="server" DataMember="D.4Podatek" XSDType="TKwotaC" HideEmptyOrZero="false"/>
			<P_H typ ="G" >
				<ea:XmlDataLabel ElementName="P_H1" runat="server" DataMember="H.1Stawka" XSDType="TProcentowy" HideEmptyOrZero="false"/>
				<ea:XmlDataLabel ElementName="P_H2" runat="server" DataMember="H.1Zwolniony" XSDType="TKwotaC" HideEmptyOrZero="false"/>
				<ea:XmlDataLabel ElementName="P_H3" runat="server" DataMember="H.1Kwota" XSDType="TKwotaC" HideEmptyOrZero="false"/>
				<ea:XmlDataLabel ElementName="P_H4" runat="server" DataMember="H.1Podatek" XSDType="TKwotaC" HideEmptyOrZero="false"/>
			</P_H>
			<P_H typ ="G" >
				<ea:XmlDataLabel ElementName="P_H1" runat="server" DataMember="H.2Stawka" XSDType="TProcentowy" HideEmptyOrZero="false"/>
				<ea:XmlDataLabel ElementName="P_H2" runat="server" DataMember="H.2Zwolniony" XSDType="TKwotaC" HideEmptyOrZero="false"/>
				<ea:XmlDataLabel ElementName="P_H3" runat="server" DataMember="H.2Kwota" XSDType="TKwotaC" HideEmptyOrZero="false"/>
				<ea:XmlDataLabel ElementName="P_H4" runat="server" DataMember="H.2Podatek" XSDType="TKwotaC" HideEmptyOrZero="false"/>
			</P_H>
		</ea:Section>

		<ea:Section ID="Widocznosc45_47" runat="server">
			<ea:XmlDataLabel ElementName="P_45" runat="server" DataMember="D.5Zwolniony" XSDType="TKwotaC" HideEmptyOrZero="false"/>
			<ea:XmlDataLabel ElementName="P_46" runat="server" DataMember="D.5Kwota" XSDType="TKwotaC" HideEmptyOrZero="false"/>
			<ea:XmlDataLabel ElementName="P_47" runat="server" DataMember="D.5Podatek" XSDType="TKwotaC" HideEmptyOrZero="false"/>
			<P_I typ ="G" >
				<ea:XmlDataLabel ElementName="P_I1" runat="server" DataMember="I.1Stawka" XSDType="TProcentowy" HideEmptyOrZero="false"/>
				<ea:XmlDataLabel ElementName="P_I2" runat="server" DataMember="I.1Zwolniony" XSDType="TKwotaC" HideEmptyOrZero="false"/>
				<ea:XmlDataLabel ElementName="P_I3" runat="server" DataMember="I.1Kwota" XSDType="TKwotaC" HideEmptyOrZero="false"/>
				<ea:XmlDataLabel ElementName="P_I4" runat="server" DataMember="I.1Podatek" XSDType="TKwotaC" HideEmptyOrZero="false"/>
			</P_I>
			<P_I typ ="G" >
				<ea:XmlDataLabel ElementName="P_I1" runat="server" DataMember="I.2Stawka" XSDType="TProcentowy" HideEmptyOrZero="false"/>
				<ea:XmlDataLabel ElementName="P_I2" runat="server" DataMember="I.2Zwolniony" XSDType="TKwotaC" HideEmptyOrZero="false"/>
				<ea:XmlDataLabel ElementName="P_I3" runat="server" DataMember="I.2Kwota" XSDType="TKwotaC" HideEmptyOrZero="false"/>
				<ea:XmlDataLabel ElementName="P_I4" runat="server" DataMember="I.2Podatek" XSDType="TKwotaC" HideEmptyOrZero="false"/>
			</P_I>
		</ea:Section>

		<ea:Section ID="Widocznosc48_50" runat="server">
			<ea:XmlDataLabel ElementName="P_48" runat="server" DataMember="D.6Zwolniony" XSDType="TKwotaC" HideEmptyOrZero="false"/>
			<ea:XmlDataLabel ElementName="P_49" runat="server" DataMember="D.6Kwota" XSDType="TKwotaC" HideEmptyOrZero="false"/>
			<ea:XmlDataLabel ElementName="P_50" runat="server" DataMember="D.6Podatek" XSDType="TKwotaC" HideEmptyOrZero="false"/>
			<P_J typ ="G" >
				<ea:XmlDataLabel ElementName="P_J1" runat="server" DataMember="J.1Stawka" XSDType="TProcentowy" HideEmptyOrZero="false"/>
				<ea:XmlDataLabel ElementName="P_J2" runat="server" DataMember="J.1Zwolniony" XSDType="TKwotaC" HideEmptyOrZero="false"/>
				<ea:XmlDataLabel ElementName="P_J3" runat="server" DataMember="J.1Kwota" XSDType="TKwotaC" HideEmptyOrZero="false"/>
				<ea:XmlDataLabel ElementName="P_J4" runat="server" DataMember="J.1Podatek" XSDType="TKwotaC" HideEmptyOrZero="false"/>
			</P_J>
			<P_J typ ="G" >
				<ea:XmlDataLabel ElementName="P_J1" runat="server" DataMember="J.2Stawka" XSDType="TProcentowy" HideEmptyOrZero="false"/>
				<ea:XmlDataLabel ElementName="P_J2" runat="server" DataMember="J.2Zwolniony" XSDType="TKwotaC" HideEmptyOrZero="false"/>
				<ea:XmlDataLabel ElementName="P_J3" runat="server" DataMember="J.2Kwota" XSDType="TKwotaC" HideEmptyOrZero="false"/>
				<ea:XmlDataLabel ElementName="P_J4" runat="server" DataMember="J.2Podatek" XSDType="TKwotaC" HideEmptyOrZero="false"/>
			</P_J>
		</ea:Section>

		<ea:Section ID="Widocznosc51_53" runat="server">
			<ea:XmlDataLabel ElementName="P_51" runat="server" DataMember="D.7Zwolniony" XSDType="TKwotaC" HideEmptyOrZero="false"/>
			<ea:XmlDataLabel ElementName="P_52" runat="server" DataMember="D.7Kwota" XSDType="TKwotaC" HideEmptyOrZero="false"/>
			<ea:XmlDataLabel ElementName="P_53" runat="server" DataMember="D.7Podatek" XSDType="TKwotaC" HideEmptyOrZero="false"/>
			<P_K typ ="G" >
				<ea:XmlDataLabel ElementName="P_K1" runat="server" DataMember="K.1Stawka" XSDType="TProcentowy" HideEmptyOrZero="false"/>
				<ea:XmlDataLabel ElementName="P_K2" runat="server" DataMember="K.1Zwolniony" XSDType="TKwotaC" HideEmptyOrZero="false"/>
				<ea:XmlDataLabel ElementName="P_K3" runat="server" DataMember="K.1Kwota" XSDType="TKwotaC" HideEmptyOrZero="false"/>
				<ea:XmlDataLabel ElementName="P_K4" runat="server" DataMember="K.1Podatek" XSDType="TKwotaC" HideEmptyOrZero="false"/>
			</P_K>
			<P_K typ ="G" >
				<ea:XmlDataLabel ElementName="P_K1" runat="server" DataMember="K.2Stawka" XSDType="TProcentowy" HideEmptyOrZero="false"/>
				<ea:XmlDataLabel ElementName="P_K2" runat="server" DataMember="K.2Zwolniony" XSDType="TKwotaC" HideEmptyOrZero="false"/>
				<ea:XmlDataLabel ElementName="P_K3" runat="server" DataMember="K.2Kwota" XSDType="TKwotaC" HideEmptyOrZero="false"/>
				<ea:XmlDataLabel ElementName="P_K4" runat="server" DataMember="K.2Podatek" XSDType="TKwotaC" HideEmptyOrZero="false"/>
			</P_K>
		</ea:Section>

		<ea:Section ID="Widocznosc54_57" runat="server">
			<ea:XmlDataLabel ElementName="P_54" runat="server" DataMember="D.8Zwolniony" XSDType="TKwotaC" HideEmptyOrZero="false"/>
			<ea:XmlDataLabel ElementName="P_55" runat="server" DataMember="D.8Kwota" XSDType="TKwotaC" HideEmptyOrZero="false"/>
			<ea:XmlDataLabel ElementName="P_56" runat="server" DataMember="D.8Podatek" XSDType="TKwotaC" HideEmptyOrZero="false"/>
			<ea:XmlDataLabel ElementName="P_57" runat="server" DataMember="D.8PodatekArt26" XSDType="TKwotaC" HideEmptyOrZero="false"/>
			<P_L typ ="G" >
				<ea:XmlDataLabel ElementName="P_L1" runat="server" DataMember="L.1Stawka" XSDType="TProcentowy" HideEmptyOrZero="false"/>
				<ea:XmlDataLabel ElementName="P_L2" runat="server" DataMember="L.1Zwolniony" XSDType="TKwotaC" HideEmptyOrZero="false"/>
				<ea:XmlDataLabel ElementName="P_L3" runat="server" DataMember="L.1Kwota" XSDType="TKwotaC" HideEmptyOrZero="false"/>
				<ea:XmlDataLabel ElementName="P_L4" runat="server" DataMember="L.1Podatek" XSDType="TKwotaC" HideEmptyOrZero="false"/>
				<ea:XmlDataLabel ElementName="P_L5" runat="server" DataMember="L.1PodatekArt26" XSDType="TKwotaC" HideEmptyOrZero="false"/>
			</P_L>
			<P_L typ ="G" >
				<ea:XmlDataLabel ElementName="P_L1" runat="server" DataMember="L.2Stawka" XSDType="TProcentowy" HideEmptyOrZero="false"/>
				<ea:XmlDataLabel ElementName="P_L2" runat="server" DataMember="L.2Zwolniony" XSDType="TKwotaC" HideEmptyOrZero="false"/>
				<ea:XmlDataLabel ElementName="P_L3" runat="server" DataMember="L.2Kwota" XSDType="TKwotaC" HideEmptyOrZero="false"/>
				<ea:XmlDataLabel ElementName="P_L4" runat="server" DataMember="L.2Podatek" XSDType="TKwotaC" HideEmptyOrZero="false"/>
				<ea:XmlDataLabel ElementName="P_L5" runat="server" DataMember="L.2PodatekArt26" XSDType="TKwotaC" HideEmptyOrZero="false"/>
			</P_L>
		</ea:Section>

		<ea:Section ID="Widocznosc58_61" runat="server">
			<ea:XmlDataLabel ElementName="P_58" runat="server" DataMember="D.9Zwolniony" XSDType="TKwotaC" HideEmptyOrZero="false"/>
			<ea:XmlDataLabel ElementName="P_59" runat="server" DataMember="D.9Kwota" XSDType="TKwotaC" HideEmptyOrZero="false"/>
			<ea:XmlDataLabel ElementName="P_60" runat="server" DataMember="D.9Podatek" XSDType="TKwotaC" HideEmptyOrZero="false"/>
			<ea:XmlDataLabel ElementName="P_61" runat="server" DataMember="D.9PodatekArt26" XSDType="TKwotaC" HideEmptyOrZero="false"/>
			<P_M typ ="G" >
				<ea:XmlDataLabel ElementName="P_M1" runat="server" DataMember="M.1Stawka" XSDType="TProcentowy" HideEmptyOrZero="false"/>
				<ea:XmlDataLabel ElementName="P_M2" runat="server" DataMember="M.1Zwolniony" XSDType="TKwotaC" HideEmptyOrZero="false"/>
				<ea:XmlDataLabel ElementName="P_M3" runat="server" DataMember="M.1Kwota" XSDType="TKwotaC" HideEmptyOrZero="false"/>
				<ea:XmlDataLabel ElementName="P_M4" runat="server" DataMember="M.1Podatek" XSDType="TKwotaC" HideEmptyOrZero="false"/>
				<ea:XmlDataLabel ElementName="P_M5" runat="server" DataMember="M.1PodatekArt26" XSDType="TKwotaC" HideEmptyOrZero="false"/>
			</P_M>
			<P_M typ ="G" >
				<ea:XmlDataLabel ElementName="P_M1" runat="server" DataMember="M.2Stawka" XSDType="TProcentowy" HideEmptyOrZero="false"/>
				<ea:XmlDataLabel ElementName="P_M2" runat="server" DataMember="M.2Zwolniony" XSDType="TKwotaC" HideEmptyOrZero="false"/>
				<ea:XmlDataLabel ElementName="P_M3" runat="server" DataMember="M.2Kwota" XSDType="TKwotaC" HideEmptyOrZero="false"/>
				<ea:XmlDataLabel ElementName="P_M4" runat="server" DataMember="M.2Podatek" XSDType="TKwotaC" HideEmptyOrZero="false"/>
				<ea:XmlDataLabel ElementName="P_M5" runat="server" DataMember="M.2PodatekArt26" XSDType="TKwotaC" HideEmptyOrZero="false"/>
			</P_M>
		</ea:Section>

		<ea:Section ID="Widocznosc62_65" runat="server">
			<ea:XmlDataLabel ElementName="P_62" runat="server" DataMember="D.10Zwolniony" XSDType="TKwotaC" HideEmptyOrZero="false"/>
			<ea:XmlDataLabel ElementName="P_63" runat="server" DataMember="D.10Kwota" XSDType="TKwotaC" HideEmptyOrZero="false"/>
			<ea:XmlDataLabel ElementName="P_64" runat="server" DataMember="D.10Podatek" XSDType="TKwotaC" HideEmptyOrZero="false"/>
			<ea:XmlDataLabel ElementName="P_65" runat="server" DataMember="D.10PodatekArt26" XSDType="TKwotaC" HideEmptyOrZero="false"/>
			<P_N typ ="G" >
				<ea:XmlDataLabel ElementName="P_N1" runat="server" DataMember="N.1Stawka" XSDType="TProcentowy" HideEmptyOrZero="false"/>
				<ea:XmlDataLabel ElementName="P_N2" runat="server" DataMember="N.1Zwolniony" XSDType="TKwotaC" HideEmptyOrZero="false"/>
				<ea:XmlDataLabel ElementName="P_N3" runat="server" DataMember="N.1Kwota" XSDType="TKwotaC" HideEmptyOrZero="false"/>
				<ea:XmlDataLabel ElementName="P_N4" runat="server" DataMember="N.1Podatek" XSDType="TKwotaC" HideEmptyOrZero="false"/>
				<ea:XmlDataLabel ElementName="P_N5" runat="server" DataMember="N.1PodatekArt26" XSDType="TKwotaC" HideEmptyOrZero="false"/>
			</P_N>
			<P_N typ ="G" >
				<ea:XmlDataLabel ElementName="P_N1" runat="server" DataMember="N.2Stawka" XSDType="TProcentowy" HideEmptyOrZero="false"/>
				<ea:XmlDataLabel ElementName="P_N2" runat="server" DataMember="N.2Zwolniony" XSDType="TKwotaC" HideEmptyOrZero="false"/>
				<ea:XmlDataLabel ElementName="P_N3" runat="server" DataMember="N.2Kwota" XSDType="TKwotaC" HideEmptyOrZero="false"/>
				<ea:XmlDataLabel ElementName="P_N4" runat="server" DataMember="N.2Podatek" XSDType="TKwotaC" HideEmptyOrZero="false"/>
				<ea:XmlDataLabel ElementName="P_N5" runat="server" DataMember="N.2PodatekArt26" XSDType="TKwotaC" HideEmptyOrZero="false"/>
			</P_N>
		</ea:Section>

		<ea:Section ID="Widocznosc66_68" runat="server">
			<ea:XmlDataLabel ElementName="P_66" runat="server" DataMember="D.11Zwolniony" XSDType="TKwotaC" HideEmptyOrZero="false"/>
			<ea:XmlDataLabel ElementName="P_67" runat="server" DataMember="D.11Kwota" XSDType="TKwotaC" HideEmptyOrZero="false"/>
			<ea:XmlDataLabel ElementName="P_68" runat="server" DataMember="D.11Podatek" XSDType="TKwotaC" HideEmptyOrZero="false"/>
			<P_O typ ="G" >
				<ea:XmlDataLabel ElementName="P_O1" runat="server" DataMember="O.1Stawka" XSDType="TProcentowy" HideEmptyOrZero="false"/>
				<ea:XmlDataLabel ElementName="P_O2" runat="server" DataMember="O.1Zwolniony" XSDType="TKwotaC" HideEmptyOrZero="false"/>
				<ea:XmlDataLabel ElementName="P_O3" runat="server" DataMember="O.1Kwota" XSDType="TKwotaC" HideEmptyOrZero="false"/>
				<ea:XmlDataLabel ElementName="P_O4" runat="server" DataMember="O.1Podatek" XSDType="TKwotaC" HideEmptyOrZero="false"/>
			</P_O>
			<P_O typ ="G" >
				<ea:XmlDataLabel ElementName="P_O1" runat="server" DataMember="O.2Stawka" XSDType="TProcentowy" HideEmptyOrZero="false"/>
				<ea:XmlDataLabel ElementName="P_O2" runat="server" DataMember="O.2Zwolniony" XSDType="TKwotaC" HideEmptyOrZero="false"/>
				<ea:XmlDataLabel ElementName="P_O3" runat="server" DataMember="O.2Kwota" XSDType="TKwotaC" HideEmptyOrZero="false"/>
				<ea:XmlDataLabel ElementName="P_O4" runat="server" DataMember="O.2Podatek" XSDType="TKwotaC" HideEmptyOrZero="false"/>
			</P_O>
		</ea:Section>

		<ea:Section ID="Widocznosc69_71" runat="server">
			<ea:XmlDataLabel ElementName="P_69" runat="server" DataMember="D.12Zwolniony" XSDType="TKwotaC" HideEmptyOrZero="false"/>
			<ea:XmlDataLabel ElementName="P_70" runat="server" DataMember="D.12Kwota" XSDType="TKwotaC" HideEmptyOrZero="false"/>
			<ea:XmlDataLabel ElementName="P_71" runat="server" DataMember="D.12Podatek" XSDType="TKwotaC" HideEmptyOrZero="false"/>
			<P_P typ ="G" >
				<ea:XmlDataLabel ElementName="P_P1" runat="server" DataMember="P.1Stawka" XSDType="TProcentowy" HideEmptyOrZero="false"/>
				<ea:XmlDataLabel ElementName="P_P2" runat="server" DataMember="P.1Zwolniony" XSDType="TKwotaC" HideEmptyOrZero="false"/>
				<ea:XmlDataLabel ElementName="P_P3" runat="server" DataMember="P.1Kwota" XSDType="TKwotaC" HideEmptyOrZero="false"/>
				<ea:XmlDataLabel ElementName="P_P4" runat="server" DataMember="P.1Podatek" XSDType="TKwotaC" HideEmptyOrZero="false"/>
			</P_P>
			<P_P typ ="G" >
				<ea:XmlDataLabel ElementName="P_P1" runat="server" DataMember="P.2Stawka" XSDType="TProcentowy" HideEmptyOrZero="false"/>
				<ea:XmlDataLabel ElementName="P_P2" runat="server" DataMember="P.2Zwolniony" XSDType="TKwotaC" HideEmptyOrZero="false"/>
				<ea:XmlDataLabel ElementName="P_P3" runat="server" DataMember="P.2Kwota" XSDType="TKwotaC" HideEmptyOrZero="false"/>
				<ea:XmlDataLabel ElementName="P_P4" runat="server" DataMember="P.2Podatek" XSDType="TKwotaC" HideEmptyOrZero="false"/>
			</P_P>
		</ea:Section>


		<ea:Section ID="BlokiQR" runat="server">
			<ea:XmlDataLabel ElementName="P_72" runat="server" DataMember="Q.1Dochod" XSDType="TKwotaC" HideEmptyOrZero="true"/>
			<ea:XmlDataLabel ElementName="P_78" runat="server" DataMember="Q.1Podatek" XSDType="TKwotaC" HideEmptyOrZero="true"/>

			<ea:XmlDataLabel ElementName="P_73" runat="server" DataMember="Q.2Dochod" XSDType="TKwotaC" HideEmptyOrZero="true"/>
			<ea:XmlDataLabel ElementName="P_79" runat="server" DataMember="Q.2Podatek" XSDType="TKwotaC" HideEmptyOrZero="true"/>

			<ea:XmlDataLabel ElementName="P_74" runat="server" DataMember="Q.3Dochod" XSDType="TKwotaC" HideEmptyOrZero="true"/>
			<ea:XmlDataLabel ElementName="P_80" runat="server" DataMember="Q.3Podatek" XSDType="TKwotaC" HideEmptyOrZero="true"/>

			<ea:XmlDataLabel ElementName="P_75" runat="server" DataMember="Q.4Dochod" XSDType="TKwotaC" HideEmptyOrZero="true"/>
			<ea:XmlDataLabel ElementName="P_81" runat="server" DataMember="Q.4Podatek" XSDType="TKwotaC" HideEmptyOrZero="true"/>

			<ea:XmlDataLabel ElementName="P_76" runat="server" DataMember="Q.5Dochod" XSDType="TKwotaC" HideEmptyOrZero="true"/>
			<ea:XmlDataLabel ElementName="P_82" runat="server" DataMember="Q.5Podatek" XSDType="TKwotaC" HideEmptyOrZero="true"/>

			<ea:XmlDataLabel ElementName="P_77" runat="server" DataMember="Q.6Dochod" XSDType="TKwotaC" HideEmptyOrZero="true"/>
			<ea:XmlDataLabel ElementName="P_83" runat="server" DataMember="Q.6Podatek" XSDType="TKwotaC" HideEmptyOrZero="true"/>

			<ea:XmlDataLabel ElementName="P_84" runat="server" DataMember="Q.7Dochod" XSDType="TKwotaC" HideEmptyOrZero="true"/>
			<ea:XmlDataLabel ElementName="P_90" runat="server" DataMember="Q.7Podatek" XSDType="TKwotaC" HideEmptyOrZero="true"/>

			<ea:XmlDataLabel ElementName="P_85" runat="server" DataMember="Q.8Dochod" XSDType="TKwotaC" HideEmptyOrZero="true"/>
			<ea:XmlDataLabel ElementName="P_91" runat="server" DataMember="Q.8Podatek" XSDType="TKwotaC" HideEmptyOrZero="true"/>

			<ea:XmlDataLabel ElementName="P_86" runat="server" DataMember="Q.9Dochod" XSDType="TKwotaC" HideEmptyOrZero="true"/>
			<ea:XmlDataLabel ElementName="P_92" runat="server" DataMember="Q.9Podatek" XSDType="TKwotaC" HideEmptyOrZero="true"/>

			<ea:XmlDataLabel ElementName="P_87" runat="server" DataMember="Q.10Dochod" XSDType="TKwotaC" HideEmptyOrZero="true"/>
			<ea:XmlDataLabel ElementName="P_93" runat="server" DataMember="Q.10Podatek" XSDType="TKwotaC" HideEmptyOrZero="true"/>

			<ea:XmlDataLabel ElementName="P_88" runat="server" DataMember="Q.11Dochod" XSDType="TKwotaC" HideEmptyOrZero="true"/>
			<ea:XmlDataLabel ElementName="P_94" runat="server" DataMember="Q.11Podatek" XSDType="TKwotaC" HideEmptyOrZero="true"/>

			<ea:XmlDataLabel ElementName="P_89" runat="server" DataMember="Q.12Dochod" XSDType="TKwotaC" HideEmptyOrZero="true"/>
			<ea:XmlDataLabel ElementName="P_95" runat="server" DataMember="Q.12Podatek" XSDType="TKwotaC" HideEmptyOrZero="true"/>

			<ea:XmlDataLabel ElementName="P_96" runat="server" DataMember="Q.13Dochod" XSDType="TKwotaC" HideEmptyOrZero="true"/>
			<ea:XmlDataLabel ElementName="P_102" runat="server" DataMember="Q.13Podatek" XSDType="TKwotaC" HideEmptyOrZero="true"/>

			<ea:XmlDataLabel ElementName="P_97" runat="server" DataMember="Q.14Dochod" XSDType="TKwotaC" HideEmptyOrZero="true"/>
			<ea:XmlDataLabel ElementName="P_103" runat="server" DataMember="Q.14Podatek" XSDType="TKwotaC" HideEmptyOrZero="true"/>

			<ea:XmlDataLabel ElementName="P_98" runat="server" DataMember="Q.15Dochod" XSDType="TKwotaC" HideEmptyOrZero="true"/>
			<ea:XmlDataLabel ElementName="P_104" runat="server" DataMember="Q.15Podatek" XSDType="TKwotaC" HideEmptyOrZero="true"/>

			<ea:XmlDataLabel ElementName="P_99" runat="server" DataMember="Q.16Dochod" XSDType="TKwotaC" HideEmptyOrZero="true"/>
			<ea:XmlDataLabel ElementName="P_105" runat="server" DataMember="Q.16Podatek" XSDType="TKwotaC" HideEmptyOrZero="true"/>

			<ea:XmlDataLabel ElementName="P_100" runat="server" DataMember="Q.17Dochod" XSDType="TKwotaC" HideEmptyOrZero="true"/>
			<ea:XmlDataLabel ElementName="P_106" runat="server" DataMember="Q.17Podatek" XSDType="TKwotaC" HideEmptyOrZero="true"/>

			<ea:XmlDataLabel ElementName="P_101" runat="server" DataMember="Q.18Dochod" XSDType="TKwotaC" HideEmptyOrZero="true"/>
			<ea:XmlDataLabel ElementName="P_107" runat="server" DataMember="Q.18Podatek" XSDType="TKwotaC" HideEmptyOrZero="true"/>

			<ea:XmlDataLabel ElementName="P_108" runat="server" DataMember="Q.19Dochod" XSDType="TKwotaC" HideEmptyOrZero="true"/>
			<ea:XmlDataLabel ElementName="P_114" runat="server" DataMember="Q.19Podatek" XSDType="TKwotaC" HideEmptyOrZero="true"/>

			<ea:XmlDataLabel ElementName="P_109" runat="server" DataMember="Q.20Dochod" XSDType="TKwotaC" HideEmptyOrZero="true"/>
			<ea:XmlDataLabel ElementName="P_115" runat="server" DataMember="Q.20Podatek" XSDType="TKwotaC" HideEmptyOrZero="true"/>

			<ea:XmlDataLabel ElementName="P_110" runat="server" DataMember="Q.21Dochod" XSDType="TKwotaC" HideEmptyOrZero="true"/>
			<ea:XmlDataLabel ElementName="P_116" runat="server" DataMember="Q.21Podatek" XSDType="TKwotaC" HideEmptyOrZero="true"/>

			<ea:XmlDataLabel ElementName="P_111" runat="server" DataMember="Q.22Dochod" XSDType="TKwotaC" HideEmptyOrZero="true"/>
			<ea:XmlDataLabel ElementName="P_117" runat="server" DataMember="Q.22Podatek" XSDType="TKwotaC" HideEmptyOrZero="true"/>

			<ea:XmlDataLabel ElementName="P_112" runat="server" DataMember="Q.23Dochod" XSDType="TKwotaC" HideEmptyOrZero="true"/>
			<ea:XmlDataLabel ElementName="P_118" runat="server" DataMember="Q.23Podatek" XSDType="TKwotaC" HideEmptyOrZero="true"/>

			<ea:XmlDataLabel ElementName="P_113" runat="server" DataMember="Q.RazemDochod" XSDType="TKwotaC" HideEmptyOrZero="false"/>
			<ea:XmlDataLabel ElementName="P_119" runat="server" DataMember="Q.RazemPodatek" XSDType="TKwotaC" HideEmptyOrZero="false"/>

			<ea:XmlDataLabel ElementName="P_120" runat="server" DataMember="R.MiesiecyWRokPodatkowy" XSDType="TCalkowity" />
		</ea:Section>

		<ea:XmlDataLabel ElementName="P_121" ID="DataZlozenia" runat="server" DataMember="S.DataZłożenia" XSDType="TData" HideEmptyOrZero="true"/>

		<ea:XmlDataLabel ElementName="P_122" runat="server" DataMember="S.DataPrzekazania" XSDType="TData" HideEmptyOrZero="true"/>

		<ea:XmlDataLabel ElementName="P_128" runat="server" DataMember="U.Telefon" XSDType="TZnakowy" HideEmptyOrZero="true"/>

		<ea:XmlDataLabel ElementName="P_129" runat="server" DataMember="U.Email" XSDType="TZnakowy" HideEmptyOrZero="true"/>
	</PozycjeSzczegolowe>
	<Pouczenie>1</Pouczenie>

	<ea:Section ID="ORD_ZU" runat="server">
	<Zalaczniki>
	<zzu:Zalacznik_ORD-ZU>
		<zzu:Naglowek>
			<zzu:KodFormularza kodSystemowy="ORD-ZU (3)" wersjaSchemy="10-0E">ORD-ZU</zzu:KodFormularza>
			<zzu:WariantFormularza>3</zzu:WariantFormularza>
		</zzu:Naglowek>
		<zzu:PozycjeSzczegolowe>
			<ea:XmlDataLabel ElementName="zzu:P_13" runat="server" DataMember="TreśćUzasadnienia" XSDType="TTekstowy"/>
		</zzu:PozycjeSzczegolowe>
	</zzu:Zalacznik_ORD-ZU>
	</Zalaczniki>
	</ea:Section>
</Deklaracja>
