﻿<%@ Page Language="C#" AutoEventWireup="false" CodePage="1200" %>

<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Deklaracje" %>


<script runat="server">
	Soneta.Deklaracje.VAT.VAT8_12 dek;

	void OnContextLoad(Object sender, EventArgs args)
	{
		dek = (Soneta.Deklaracje.VAT.VAT8_12)dc[typeof(Soneta.Deklaracje.VAT.VAT8_12)];

		ORD_ZU.Visible = dek.TreśćUzasadnienia != "";
		ZAL.Visible = ORD_ZU.Visible;
        WariantFormularza.EditValue = 12;
	
		string[] nazwa = Soneta.Deklaracje.PIT.PIT.DaneFirmy((string)dek.Bloki["B1"]["Nazwa"], (bool)dek.Bloki["B1"]["OsobaFiz"]);
		if((bool)dek.Bloki["B1"]["OsobaFiz"])
		{
			OsobaNieFizyczna.Visible = false;
			if (nazwa.Length > 0)
				Nazwisko.EditValue = nazwa[0].Trim();
			if (nazwa.Length > 1)
				ImiePierwsze.EditValue = nazwa[1].Trim();
			if (nazwa.Length > 2)
				DataUrodzenia.EditValue = nazwa[2].Trim();
		}
		else
		{
			OsobaFizyczna.Visible = false;
			if (nazwa.Length > 0)
				NazwaPelna.EditValue = nazwa[0].Trim();
		}

	if ((decimal)dek.Bloki["C"]["WewnwspolNabycieTowarowPodstawa"] == 0 && (decimal)dek.Bloki["C"]["WewnwspolNabycieTowarowPodatek"] == 0)
	  S_10_11.Visible = false;
	if ((decimal)dek.Bloki["C"]["ImportUslugNieNabPodstawa"] == 0 && (decimal)dek.Bloki["C"]["ImportUslugNieNabPodatek"] == 0)
	  S_12_13.Visible = false;
	if ((decimal)dek.Bloki["C"]["ImportUslugNabPodstawa"] == 0 && (decimal)dek.Bloki["C"]["ImportUslugNabPodatek"] == 0)
	  S_14_15.Visible = false;
	if ((decimal)dek.Bloki["C"]["DostawaTowarowPodstawa"] == 0 && (decimal)dek.Bloki["C"]["DostawaTowarowPodatek"] == 0)
	  S_16_17.Visible = false;
	if ((decimal)dek.Bloki["C"]["SwiadczeniwUslugPodstawa"] == 0 && (decimal)dek.Bloki["C"]["SwiadczeniwUslugPodatek"] == 0)
	  S_18_19.Visible = false;
    }
</script>


<ea:datacontext id="dc" runat="server" typename="Soneta.Deklaracje.VAT.VAT8_12,Soneta.Deklaracje" oncontextload="OnContextLoad" />
<?xml version="1.0" encoding="UTF-8" ?>
<Deklaracja
	xmlns="http://crd.gov.pl/wzor/2025/02/25/13695/"
	xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
	xsi:schemaLocation="http://crd.gov.pl/wzor/2025/02/25/13695/ http://crd.gov.pl/wzor/2025/02/25/13695/schemat.xsd"
	xmlns:etd="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2022/09/13/eD/DefinicjeTypy/"
	xmlns:kus="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2022/01/05/eD/KodyUrzedowSkarbowych/"
	xmlns:zzu="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2022/09/13/eD/ORDZU/" >
	<Naglowek>
		<KodFormularza kodSystemowy="VAT-8 (12)" kodPodatku="VAT" rodzajZobowiazania="Z" wersjaSchemy="1-0E">VAT-8</KodFormularza>
		<ea:XmlDataLabel ID="WariantFormularza" ElementName="WariantFormularza" runat="server" />
		<CelZlozenia poz="P_7"><ea:XmlDataLabel runat="server" DataMember="A.Korekta"><ValuesMap><ea:ValuesPair Key="False" Value="1" /><ea:ValuesPair Key="True" Value="2"/></ValuesMap></ea:XmlDataLabel></CelZlozenia>
		<Rok><ea:XmlDataLabel runat="server" DataMember="0.Rok" /></Rok>
		<Miesiac><ea:XmlDataLabel runat="server" DataMember="0.Miesiąc" /></Miesiac>
		<KodUrzedu><ea:XmlDataLabel runat="server" DataMember="DOD.KodUrzeduSkarbowego" /></KodUrzedu>
	</Naglowek>

	<Podmiot1 rola="Podatnik">
		<ea:Section ID="OsobaFizyczna" runat="server">
			<etd:OsobaFizyczna>
				<ea:XmlDataLabel runat="server" ElementName="etd:NIP" DataMember="0.Nip" XSDType="TNrNIP" />
				<ea:XmlDataLabel ID="ImiePierwsze" runat="server" ElementName="etd:ImiePierwsze" XSDType="TImie" />
				<ea:XmlDataLabel ID="Nazwisko" runat="server" ElementName="etd:Nazwisko" XSDType="TNazwisko" />
				<ea:XmlDataLabel ID="DataUrodzenia" runat="server" ElementName="etd:DataUrodzenia" XSDType="TData" />
			</etd:OsobaFizyczna>
		</ea:Section>
		<ea:Section ID="OsobaNieFizyczna" runat="server">
			<etd:OsobaNiefizyczna>
				<ea:XmlDataLabel runat="server" ElementName="etd:NIP" DataMember="0.Nip" XSDType="TNrNIP" />
				<ea:XmlDataLabel runat="server" ElementName="etd:PelnaNazwa" ID="NazwaPelna"  XSDType="TZnakowy" />
			</etd:OsobaNiefizyczna>
		</ea:Section>
	</Podmiot1>

	<PozycjeSzczegolowe>
		<ea:Section ID="S_10_11" runat="server">
			  <ea:XmlDataLabel ElementName="P_10" runat="server" DataMember="C.WewnwspolNabycieTowarowPodstawa" XSDType="TKwotaC" />
			  <ea:XmlDataLabel ElementName="P_11" runat="server" DataMember="C.WewnwspolNabycieTowarowPodatek" XSDType="TKwotaC" />
		</ea:Section>
		<ea:Section ID="S_12_13" runat="server">
			  <ea:XmlDataLabel ElementName="P_12" runat="server" DataMember="C.ImportUslugNieNabPodstawa" XSDType="TKwotaC" />
			  <ea:XmlDataLabel ElementName="P_13" runat="server" DataMember="C.ImportUslugNieNabPodatek" XSDType="TKwotaC" />
		</ea:Section>
		<ea:Section ID="S_14_15" runat="server">
			  <ea:XmlDataLabel ElementName="P_14" runat="server" DataMember="C.ImportUslugNabPodstawa" XSDType="TKwotaC" />
			  <ea:XmlDataLabel ElementName="P_15" runat="server" DataMember="C.ImportUslugNabPodatek" XSDType="TKwotaC" />
		</ea:Section>
		<ea:Section ID="S_16_17" runat="server">
			  <ea:XmlDataLabel ElementName="P_16" runat="server" DataMember="C.DostawaTowarowPodstawa" XSDType="TKwotaC" />
			  <ea:XmlDataLabel ElementName="P_17" runat="server" DataMember="C.DostawaTowarowPodatek" XSDType="TKwotaC" />
		</ea:Section>
		<ea:Section ID="S_18_19" runat="server">
			  <ea:XmlDataLabel ElementName="P_18" runat="server" DataMember="C.SwiadczeniwUslugPodstawa" XSDType="TKwotaC" />
			  <ea:XmlDataLabel ElementName="P_19" runat="server" DataMember="C.SwiadczeniwUslugPodatek" XSDType="TKwotaC" />
		</ea:Section>

		<ea:XmlDataLabel ElementName="P_20" runat="server" DataMember="C.NabycieSrodkowTransPodatek" XSDType="TKwotaC" />
		<ea:XmlDataLabel ElementName="P_21" runat="server" DataMember="C.NabycieTowarowPodatek" XSDType="TKwotaC" />
		<ea:XmlDataLabel ElementName="P_22" runat="server" DataMember="C.NadwyzkaWplatDoRoliczeniaPoprzMc" XSDType="TKwotaC" />
		<ea:XmlDataLabel ElementName="P_23" runat="server" DataMember="C.PodatekDoZaplaty" XSDType="TKwotaC" />
		<ea:XmlDataLabel ElementName="P_24" runat="server" DataMember="C.NadwyzkaWplatDoRoliczenia" XSDType="TKwotaC" />
		<ea:XmlDataLabel ElementName="P_25" runat="server" DataMember="D.Obnizenie108D" HideEmptyOrZero="true"><ValuesMap><ea:ValuesPair Key="True" Value="1" /><ea:ValuesPair Key="False" Value="0"/></ValuesMap></ea:XmlDataLabel>
		<ea:XmlDataLabel ElementName="P_28" runat="server" DataMember="E.Email" XSDType="TZnakowy" HideEmptyOrZero="true" />
		<ea:XmlDataLabel ElementName="P_29" runat="server" DataMember="E.Telefon" XSDType="TZnakowy" HideEmptyOrZero="true" />
		<ea:XmlDataLabel ElementName="P_30" runat="server" DataMember="E.Data" XSDType="TData" HideEmptyOrZero="true" />
	</PozycjeSzczegolowe>

	<Pouczenia>1</Pouczenia>

	<ea:Section ID="ZAL" runat="server">
		<Zalaczniki>
		<ea:Section ID="ORD_ZU" runat="server">
			<zzu:Zalacznik_ORD-ZU>
				<zzu:Naglowek>
					<zzu:KodFormularza kodSystemowy="ORD-ZU (3)"  wersjaSchemy="10-0E">ORD-ZU</zzu:KodFormularza>
					<zzu:WariantFormularza>3</zzu:WariantFormularza>
				</zzu:Naglowek>
				<zzu:PozycjeSzczegolowe>
					<zzu:P_13><ea:XmlDataLabel runat="server" DataMember="TreśćUzasadnienia" XSDType="TTekstowy"/></zzu:P_13>
				</zzu:PozycjeSzczegolowe>
			</zzu:Zalacznik_ORD-ZU>
		</ea:Section>
	</Zalaczniki>
</ea:Section>
</Deklaracja>
