﻿<%@ Page Language="C#" AutoEventWireup="false" CodePage="1200" %>

<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Deklaracje" %>
<%@ Import Namespace="Soneta.Deklaracje.VAT" %>
<script runat="server">
    void OnBeforeRowKGrupa1(object sender, EventArgs e)
    {
        if (((VATUEGrupaKorekta)KGrupa1.CurrentRow).BKwota == 0)
            KGrupa1BKod.Visible = KGrupa1BNIP.Visible = KGrupa1BKwota.Visible = KGrupa1BTrojstronna.Visible = false;
        else
            KGrupa1BKod.Visible = KGrupa1BNIP.Visible = KGrupa1BKwota.Visible = KGrupa1BTrojstronna.Visible = true;

        if (((VATUEGrupaKorekta)KGrupa1.CurrentRow).JKwota == 0)
            KGrupa1JKod.Visible = KGrupa1JNIP.Visible = KGrupa1JKwota.Visible = KGrupa1JTrojstronna.Visible = false;
        else
            KGrupa1JKod.Visible = KGrupa1JNIP.Visible = KGrupa1JKwota.Visible = KGrupa1JTrojstronna.Visible = true;
    }

    void OnBeforeRowKGrupa2(object sender, EventArgs e)
    {
        if (((VATUEGrupaKorekta)KGrupa2.CurrentRow).BKwota == 0)
            KGrupa2BKod.Visible = KGrupa2BNIP.Visible = KGrupa2BKwota.Visible = KGrupa2BTrojstronna.Visible = false;
        else
            KGrupa2BKod.Visible = KGrupa2BNIP.Visible = KGrupa2BKwota.Visible = KGrupa2BTrojstronna.Visible = true;

        if (((VATUEGrupaKorekta)KGrupa2.CurrentRow).JKwota == 0)
            KGrupa2JKod.Visible = KGrupa2JNIP.Visible = KGrupa2JKwota.Visible = KGrupa2JTrojstronna.Visible = false;
        else
            KGrupa2JKod.Visible = KGrupa2JNIP.Visible = KGrupa2JKwota.Visible = KGrupa2JTrojstronna.Visible = true;
    }

    void OnBeforeRowKGrupa3(object sender, EventArgs e)
    {
        if (((VATUEGrupaKorekta)KGrupa3.CurrentRow).BKwota == 0)
            KGrupa3BKod.Visible = KGrupa3BNIP.Visible = KGrupa3BKwota.Visible = false;
        else
            KGrupa3BKod.Visible = KGrupa3BNIP.Visible = KGrupa3BKwota.Visible = true;

        if (((VATUEGrupaKorekta)KGrupa3.CurrentRow).JKwota == 0)
            KGrupa3JKod.Visible = KGrupa3JNIP.Visible = KGrupa3JKwota.Visible = false;
        else
            KGrupa3JKod.Visible = KGrupa3JNIP.Visible = KGrupa3JKwota.Visible = true;
    }

    VATUE_2 dek = null;

    void OnContextLoad(Object sender, EventArgs args)
    {
        dek = (VATUE_2)dc[typeof(VATUE_2)];

        string[] nazwa = Soneta.Deklaracje.PIT.PIT.DaneFirmy((string)dek.Bloki["B1"]["Nazwa"], (bool)dek.Bloki["B1"]["OsobaFiz"]);
        if ((bool)dek.Bloki["B1"]["OsobaFiz"])
        {
            OsobaNieFizyczna.Visible = false;
            if (nazwa.Length > 0)
                Nazwisko.EditValue = nazwa[0].Trim();
            if (nazwa.Length > 1)
                ImiePiersze.EditValue = nazwa[1].Trim();
            if (nazwa.Length > 2)
                DataUrodzenia.EditValue = nazwa[2].Trim();
            if (nazwa.Length > 3)
                PESEL.EditValue = nazwa[3].Trim();
        }
        else
        {
            OsobaFizyczna.Visible = false;
            if (nazwa.Length > 0)
                NazwaPelna.EditValue = nazwa[0].Trim();
            if (nazwa.Length > 1)
                REGON.EditValue = nazwa[1].Trim();
        }

        string kraj = (string)dek.Bloki["B2"]["Kraj"];
        if (!string.IsNullOrEmpty(kraj) && kraj.ToLower() != "polska")
        {
            AdresPolski.Visible = false;
            AdresZagranicznyKodKraju.EditValue = Soneta.Core.Adres.KodKrajuWgNazwy(kraj, dc.Session);
        }
        else
            AdresZagraniczny.Visible = false;

        if (dek.Korekta)
        {
            Grupa1.Visible = Grupa2.Visible = Grupa3.Visible = false;
            KGrupa1.DataSource = dek.GetGrupyKorektyDostaw();
            KGrupa2.DataSource = dek.GetGrupyKorektyNabyc();
            KGrupa3.DataSource = dek.GetGrupyKorektyUslug();
        }
        else
        {
            KGrupa1.Visible = KGrupa2.Visible = KGrupa3.Visible = false;
            Grupa1.DataSource = dek.GetGrupyDostaw();
            Grupa2.DataSource = dek.GetGrupyNabyc();
            Grupa3.DataSource = dek.GetGrupyUslug();
        }

    }
	
</script>
<ea:datacontext id="dc" runat="server" TypeName="Soneta.Deklaracje.VAT.VATUE_2,Soneta.Deklaracje" OnContextLoad="OnContextLoad"></ea:datacontext>
<?xml version="1.0" encoding="UTF-8" ?>
<%if (dek.Korekta)
  {%>
<Deklaracja xmlns="http://crd.gov.pl/wzor/2011/10/19/687/" xmlns:etd="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2011/06/21/eD/DefinicjeTypy/">
<%}
  else
  {%>
<Deklaracja xmlns="http://crd.gov.pl/wzor/2011/10/25/690/" xmlns:etd="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2011/06/21/eD/DefinicjeTypy/">
<%} %>
	<Naglowek>
<%if (dek.Korekta)
  {%>	
		<KodFormularza kodSystemowy="VATUEK (2)" wersjaSchemy="1-1E">VAT-UEK</KodFormularza>
<%}
  else
  {%>		
		<KodFormularza kodSystemowy="VAT-UE (2)" wersjaSchemy="1-1E">VAT-UE</KodFormularza>		
<%} %>		
		<WariantFormularza>2</WariantFormularza>
		<Rok><ea:XmlDataLabel ID="DataLabel2" runat="server" DataMember="0.Rok"></ea:XmlDataLabel></Rok>		
<%if (dek.Kwartalna)
  {%>			
		<Kwartal><ea:XmlDataLabel ID="Kwartal" runat="server" DataMember="0.Kwartal"></ea:XmlDataLabel></Kwartal>
<%} %>						
<%if (dek.Miesieczna)
  {%>			
		<Miesiac><ea:XmlDataLabel ID="Miesiac" runat="server"  DataMember="0.Miesiac"></ea:XmlDataLabel></Miesiac>
<%} %>								
		<CelZlozenia>1</CelZlozenia>
		<KodUrzedu><ea:XmlDataLabel ID="DataLabel4" runat="server" DataMember="DOD.KodUrzeduSkarbowego"></ea:XmlDataLabel></KodUrzedu>
	</Naglowek>
	<Podmiot1 rola="Podatnik">
		<ea:Section ID="OsobaFizyczna" runat="server"><etd:OsobaFizyczna>
			<ea:XmlDataLabel ID="XmlDataLabel1" runat="server" ElementName="etd:NIP" DataMember="0.Nip" XSDType="TNrNIP"></ea:XmlDataLabel>
			<etd:ImiePierwsze><ea:XmlDataLabel ID="ImiePiersze" runat="server" XSDType="TImie"></ea:XmlDataLabel></etd:ImiePierwsze>
			<etd:Nazwisko><ea:XmlDataLabel ID="Nazwisko" runat="server" XSDType="TNazwisko"></ea:XmlDataLabel></etd:Nazwisko>
			<etd:DataUrodzenia><ea:XmlDataLabel ID="DataUrodzenia" runat="server" XSDType="TData"></ea:XmlDataLabel></etd:DataUrodzenia>
			<ea:XmlDataLabel ID="PESEL" runat="server" ElementName="etd:PESEL" HideEmptyOrZero="true"></ea:XmlDataLabel>
		</etd:OsobaFizyczna></ea:Section>
		<ea:Section ID="OsobaNieFizyczna" runat="server"><etd:OsobaNiefizyczna>
			<ea:XmlDataLabel ID="XmlDataLabel2" runat="server" ElementName="etd:NIP" DataMember="0.Nip" XSDType="TNrNIP"></ea:XmlDataLabel>
			<etd:PelnaNazwa><ea:XmlDataLabel ID="NazwaPelna" runat="server" XSDType="TZnakowy"></ea:XmlDataLabel></etd:PelnaNazwa>
            <ea:XmlDataLabel ID="REGON" runat="server" ElementName="etd:REGON" XSDType="TNrREGON" HideEmptyOrZero="true"></ea:XmlDataLabel>
		</etd:OsobaNiefizyczna></ea:Section>
		<etd:AdresZamieszkaniaSiedziby rodzajAdresu="RAD">
			<ea:Section ID="AdresPolski" runat="server"><etd:AdresPol>
				<etd:KodKraju>PL</etd:KodKraju>
				<etd:Wojewodztwo><ea:XmlDataLabel ID="XmlDataLabel3" runat="server" DataMember="B2.Wojew" XSDType="TJednAdmin"></ea:XmlDataLabel></etd:Wojewodztwo>
				<etd:Powiat><ea:XmlDataLabel ID="XmlDataLabel4" runat="server" DataMember="B2.Powiat" XSDType="TJednAdmin"></ea:XmlDataLabel></etd:Powiat>
				<etd:Gmina><ea:XmlDataLabel ID="XmlDataLabel5" runat="server" DataMember="B2.Gmina" XSDType="TJednAdmin"></ea:XmlDataLabel></etd:Gmina>
				<ea:XmlDataLabel ID="XmlDataLabel6" runat="server" ElementName="etd:Ulica" HideEmptyOrZero="true" DataMember="B2.Ulica" XSDType="TUlica"></ea:XmlDataLabel>
				<etd:NrDomu><ea:XmlDataLabel ID="XmlDataLabel7" runat="server" DataMember="B2.NrDomu" XSDType="TNrBudynku"></ea:XmlDataLabel></etd:NrDomu>
				<ea:XmlDataLabel ID="XmlDataLabel8" runat="server" ElementName="etd:NrLokalu" HideEmptyOrZero="true" DataMember="B2.NrLokalu" XSDType="TNrLokalu"></ea:XmlDataLabel>
				<etd:Miejscowosc><ea:XmlDataLabel ID="XmlDataLabel9" runat="server" DataMember="B2.Miejsc" XSDType="TMiejscowosc"></ea:XmlDataLabel></etd:Miejscowosc>
				<etd:KodPocztowy><ea:XmlDataLabel ID="XmlDataLabel10" runat="server" DataMember="B2.KodPoczt" XSDType="TKodPocztowy"></ea:XmlDataLabel></etd:KodPocztowy>
				<etd:Poczta><ea:XmlDataLabel ID="XmlDataLabel11" runat="server" DataMember="B2.Poczta" XSDType="TMiejscowosc"></ea:XmlDataLabel></etd:Poczta>
			</etd:AdresPol></ea:Section>
			<ea:Section ID="AdresZagraniczny" runat="server"><etd:AdresZagr>
				<etd:KodKraju><ea:XmlDataLabel ID="AdresZagranicznyKodKraju" runat="server"></ea:XmlDataLabel></etd:KodKraju>
				<etd:KodPocztowy><ea:XmlDataLabel runat="server" DataMember="B2.KodPoczt" XSDType="TKodPocztowy"></ea:XmlDataLabel></etd:KodPocztowy>
				<etd:Miejscowosc><ea:XmlDataLabel runat="server" DataMember="B2.Miejsc" XSDType="TMiejscowosc"></ea:XmlDataLabel></etd:Miejscowosc>
				<ea:XmlDataLabel runat="server" ElementName="etd:Ulica" HideEmptyOrZero="true" DataMember="B2.Ulica" XSDType="TUlica"></ea:XmlDataLabel>
				<ea:XmlDataLabel runat="server" ElementName="etd:NrDomu" HideEmptyOrZero="true" DataMember="B2.NrDomu" XSDType="TNrBudynku"></ea:XmlDataLabel>
				<ea:XmlDataLabel runat="server" ElementName="etd:NrLokalu" HideEmptyOrZero="true" DataMember="B2.NrLokalu" XSDType="TNrLokalu"></ea:XmlDataLabel>
			</etd:AdresZagr></ea:Section>
		</etd:AdresZamieszkaniaSiedziby>
	</Podmiot1>	
	<PozycjeSzczegolowe>
		<ea:DataRepeater ID="Grupa1" runat="server" WithSections="False">
			<Grupa1>
				<P_Da><ea:XmlDataLabel ID="Grupa1Kod" runat="server" DataMember="Kod" XSDType="TZnakowy"></ea:XmlDataLabel></P_Da> 
				<P_Db><ea:XmlDataLabel ID="Grupa1NIP" runat="server" DataMember="Nip" XSDType="TNrVatUE"></ea:XmlDataLabel></P_Db> 
				<P_Dc><ea:XmlDataLabel ID="Grupa1Kwota" runat="server" DataMember="Kwota"  XSDType="TKwotaC"></ea:XmlDataLabel></P_Dc> 
				<P_Dd><ea:XmlDataLabel ID="Grupa1Trojstronna" runat="server" DataMember="Trojstronna"><ValuesMap><ea:ValuesPair Key="False" Value="1" /><ea:ValuesPair Key="True" Value="2"/></ValuesMap></ea:XmlDataLabel></P_Dd> 
			</Grupa1>
		</ea:DataRepeater>
		<ea:DataRepeater ID="Grupa2" runat="server" WithSections="False">
			<Grupa2>
				<P_Na><ea:XmlDataLabel ID="Grupa2Kod" runat="server" DataMember="Kod" XSDType="TZnakowy"></ea:XmlDataLabel></P_Na> 
				<P_Nb><ea:XmlDataLabel ID="Grupa2NIP" runat="server" DataMember="Nip" XSDType="TNrVatUE"></ea:XmlDataLabel></P_Nb> 
				<P_Nc><ea:XmlDataLabel ID="Grupa2Kwota" runat="server" DataMember="Kwota"  XSDType="TKwotaC"></ea:XmlDataLabel></P_Nc> 
				<P_Nd><ea:XmlDataLabel ID="Grupa2Trojstronna" runat="server" DataMember="Trojstronna"><ValuesMap><ea:ValuesPair Key="False" Value="1" /><ea:ValuesPair Key="True" Value="2"/></ValuesMap></ea:XmlDataLabel></P_Nd> 
			</Grupa2>
		</ea:DataRepeater>		
		<ea:DataRepeater ID="Grupa3" runat="server" WithSections="False">
			<Grupa3>
				<P_Ua><ea:XmlDataLabel ID="Grupa3Kod" runat="server" DataMember="Kod" XSDType="TZnakowy"></ea:XmlDataLabel></P_Ua> 
				<P_Ub><ea:XmlDataLabel ID="Grupa3NIP" runat="server" DataMember="Nip" XSDType="TNrVatUE"></ea:XmlDataLabel></P_Ub> 
				<P_Uc><ea:XmlDataLabel ID="Grupa3Kwota" runat="server" DataMember="Kwota"  XSDType="TKwotaC"></ea:XmlDataLabel></P_Uc> 
			</Grupa3>
		</ea:DataRepeater>				
		<ea:DataRepeater ID="KGrupa1" runat="server" WithSections="False" OnBeforeRow="OnBeforeRowKGrupa1">
			<Grupa1>
				<ea:XmlDataLabel ID="KGrupa1BKod" runat="server" DataMember="BKod" ElementName="P_DBa" XSDType="TZnakowy"></ea:XmlDataLabel>
				<ea:XmlDataLabel ID="KGrupa1BNIP" runat="server" DataMember="BNip" ElementName="P_DBb" XSDType="TNrVatUE"></ea:XmlDataLabel>
				<ea:XmlDataLabel ID="KGrupa1BKwota" runat="server" DataMember="BKwota"  ElementName="P_DBc" XSDType="TKwotaC"></ea:XmlDataLabel>
				<ea:XmlDataLabel ID="KGrupa1BTrojstronna" runat="server" DataMember="BTrojstronna" ElementName="P_DBd"><ValuesMap><ea:ValuesPair Key="False" Value="1" /><ea:ValuesPair Key="True" Value="2"/></ValuesMap></ea:XmlDataLabel>
				<ea:XmlDataLabel ID="KGrupa1JKod" runat="server" DataMember="JKod" ElementName="P_DJa" XSDType="TZnakowy"></ea:XmlDataLabel>
				<ea:XmlDataLabel ID="KGrupa1JNIP" runat="server" DataMember="JNip" ElementName="P_DJb" XSDType="TNrVatUE"></ea:XmlDataLabel>
				<ea:XmlDataLabel ID="KGrupa1JKwota" runat="server" DataMember="JKwota" ElementName="P_DJc" XSDType="TKwotaC"></ea:XmlDataLabel>
				<ea:XmlDataLabel ID="KGrupa1JTrojstronna" runat="server" DataMember="JTrojstronna" ElementName="P_DJd" ><ValuesMap><ea:ValuesPair Key="False" Value="1" /><ea:ValuesPair Key="True" Value="2"/></ValuesMap></ea:XmlDataLabel>		
			</Grupa1>
		</ea:DataRepeater>
		<ea:DataRepeater ID="KGrupa2" runat="server" WithSections="False"  OnBeforeRow="OnBeforeRowKGrupa2">
			<Grupa2>
				<ea:XmlDataLabel ID="KGrupa2BKod" runat="server" DataMember="BKod" ElementName="P_NBa" XSDType="TZnakowy"></ea:XmlDataLabel>
				<ea:XmlDataLabel ID="KGrupa2BNIP" runat="server" DataMember="BNip" ElementName="P_NBb" XSDType="TNrVatUE"></ea:XmlDataLabel>
				<ea:XmlDataLabel ID="KGrupa2BKwota" runat="server" DataMember="BKwota" ElementName="P_NBc" XSDType="TKwotaC"></ea:XmlDataLabel>
				<ea:XmlDataLabel ID="KGrupa2BTrojstronna" runat="server" DataMember="BTrojstronna" ElementName="P_NBd"><ValuesMap><ea:ValuesPair Key="False" Value="1" /><ea:ValuesPair Key="True" Value="2"/></ValuesMap></ea:XmlDataLabel>
				<ea:XmlDataLabel ID="KGrupa2JKod" runat="server" DataMember="JKod" ElementName="P_NJa" XSDType="TZnakowy"></ea:XmlDataLabel> 
				<ea:XmlDataLabel ID="KGrupa2JNIP" runat="server" DataMember="JNip" ElementName="P_NJb" XSDType="TNrVatUE"></ea:XmlDataLabel> 
				<ea:XmlDataLabel ID="KGrupa2JKwota" runat="server" DataMember="JKwota" ElementName="P_NJc" XSDType="TKwotaC"></ea:XmlDataLabel>
				<ea:XmlDataLabel ID="KGrupa2JTrojstronna" runat="server" DataMember="JTrojstronna" ElementName="P_NJd"><ValuesMap><ea:ValuesPair Key="False" Value="1" /><ea:ValuesPair Key="True" Value="2"/></ValuesMap></ea:XmlDataLabel> 				
			</Grupa2>
		</ea:DataRepeater>				
		<ea:DataRepeater ID="KGrupa3" runat="server" WithSections="False"  OnBeforeRow="OnBeforeRowKGrupa3">
			<Grupa3>
				<ea:XmlDataLabel ID="KGrupa3BKod" runat="server" DataMember="BKod" ElementName="P_UBa" XSDType="TZnakowy"></ea:XmlDataLabel>
				<ea:XmlDataLabel ID="KGrupa3BNIP" runat="server" DataMember="BNip" ElementName="P_UBb" XSDType="TNrVatUE"></ea:XmlDataLabel>
				<ea:XmlDataLabel ID="KGrupa3BKwota" runat="server" DataMember="BKwota" ElementName="P_UBc" XSDType="TKwotaC"></ea:XmlDataLabel>
				<ea:XmlDataLabel ID="KGrupa3JKod" runat="server" DataMember="JKod" ElementName="P_UJa" XSDType="TZnakowy"></ea:XmlDataLabel> 
				<ea:XmlDataLabel ID="KGrupa3JNIP" runat="server" DataMember="JNip" ElementName="P_UJb" XSDType="TNrVatUE"></ea:XmlDataLabel> 
				<ea:XmlDataLabel ID="KGrupa3JKwota" runat="server" DataMember="JKwota" ElementName="P_UJc" XSDType="TKwotaC"></ea:XmlDataLabel>
			</Grupa3>
		</ea:DataRepeater>						
	</PozycjeSzczegolowe>
	<Oswiadczenie>Oświadczam, że są mi znane przepisy Kodeksu karnego skarbowego o odpowiedzialności za podanie danych niezgodnych z rzeczywistością.</Oswiadczenie>	
</Deklaracja>
