﻿<%@ Page Language="C#" AutoEventWireup="false" CodePage="1200" %>

<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Core" %>
<%@ Import Namespace="Soneta.Deklaracje" %>
<%@ Import Namespace="Soneta.Deklaracje.VAT" %>
<%@ Import Namespace="System.Collections.Generic" %>
<%@ Import Namespace="System.Globalization" %>
<%@ Import Namespace="System.Linq" %>
<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="System" %>


<script runat="server">
	Soneta.Deklaracje.VAT.VIUDO_1 dek;

	private struct PozycjaC2
    {
        public string KodKraju { get; set; }
        public string RodzajDostaw { get; set; }
        public string RodzajStawki { get; set; }
        public string Stawka { get; set; }
        public string PodstawaOpodatkowania { get; set; }
        public string KwotaPodatku { get; set; }
    }

	private struct PozycjaC3
    {
        public string KodKraju { get; set; }
        public string RodzajDostaw { get; set; }
        public string RodzajStawki { get; set; }
        public string Stawka { get; set; }
        public string PodstawaOpodatkowania { get; set; }
        public string KwotaPodatku { get; set; }
        public string NIPUE { get; set; }
        public string KodKrajuWydaniaAttr { get; set; }
        public string KodKrajuWydania { get; set; }
    }
	
	private struct PozycjaC5
    {
        public string KodKraju { get; set; }
        public int Rok { get; set; }
        public int Kwartal { get; set; }
        public string KwotaPodatkuZKorekt { get; set; }
    }

	private struct PozycjaC6
    {
        public string KodKraju { get; set; }
        public string PodatekNalezny { get; set; }
    }

	private string PrzytnijString(string tekst)
	{
		if(tekst.Length > 100)
			return tekst.Substring(0,100);
		return tekst;
	}

	void OnContextLoad(Object sender, EventArgs args)
	{
		dek = (Soneta.Deklaracje.VAT.VIUDO_1)dc[typeof(Soneta.Deklaracje.VAT.VIUDO_1)];
		CoreModule core = CoreModule.GetInstance(dc);

		KodUS.EditValue = 1436;
        WariantFormularza.EditValue = 1;
        DataWypelnienia.EditValue = dek.Data.ToString("yyyy-MM-dd");

		var pozycje = new List<VIUDO_1_Pozycja>();
		var pozycjeC6 = new List<PozycjaC6>();
		Dictionary<string, List<PozycjaC2>> pozycjeC2 = new Dictionary<string, List<PozycjaC2>>();
		Dictionary<string, List<PozycjaC3>> pozycjeC3 = new Dictionary<string, List<PozycjaC3>>();
		Dictionary<string, List<PozycjaC5>> pozycjeC5 = new Dictionary<string, List<PozycjaC5>>();
		
		string[] nazwa = ((string)dek.Bloki["B"]["Nazwa"]).Split(',');
        if (nazwa.Length > 2)
        {
            OsobaNieFizyczna.Visible = false;
			if (nazwa.Length > 0)
				Nazwisko.EditValue = nazwa[0].Trim();
			if (nazwa.Length > 1)
				ImiePierwsze.EditValue = nazwa[1].Trim();
        }
        else
        {
            OsobaFizyczna.Visible = false;
            if (nazwa.Length > 0)
                NazwaPelna.EditValue = PrzytnijString(nazwa[0].Trim());
        }

		foreach (Deklaracja z in dek.Deklaracje){
			if (z is VIUDO_1_Pozycja)
				pozycje.Add((VIUDO_1_Pozycja)z);
		}

		foreach(var p in pozycje)
		{

			if(p.Blok == "C2"){
				var kodKraju = GetKodKraju(dek.Session, p.Panstwo);
				if (!pozycjeC2.ContainsKey(kodKraju))
					pozycjeC2.Add(kodKraju, new List<PozycjaC2>());

				pozycjeC2[kodKraju].Add(new PozycjaC2
				{
					KodKraju =  kodKraju,
					RodzajDostaw = p.RodzajDostaw == Soneta.Deklaracje.VAT.VIUDO_Pozycja.RodzajDostawy.Usluga ? "SERVICES" : "GOODS",
					RodzajStawki = CaptionAttribute.EnumToString(p.RodzajStawki).ToUpper(),
					Stawka = GetDotSeparator(p.StawkaPodatkuVAT),
					PodstawaOpodatkowania = GetDotSeparator(p.PodstawaOpodatkowania.Value),
					KwotaPodatku = GetDotSeparator(p.KwotaPodatku.Value)
				});
			}

			if(p.Blok == "C3"){
				var kodKraju = GetKodKraju(dek.Session, p.Panstwo);
				if (!pozycjeC3.ContainsKey(kodKraju))
					pozycjeC3.Add(kodKraju, new List<PozycjaC3>());

				var substringKodKraju = p.NipUE != null && p.NipUE.Length >=2 ? p.NipUE.Substring(0,2) : string.Empty;
				string substringNIPUE;
				string substringKodKrajuWydania;

				if (substringKodKraju != string.Empty && substringKodKraju.All(char.IsLetter))
				{
					substringNIPUE = p.NipUE.Substring(2);
					substringKodKrajuWydania = substringKodKraju;
				}
				else
				{
					substringNIPUE = p.NipUE;
					substringKodKrajuWydania = string.Empty;
				}

				pozycjeC3[kodKraju].Add(new PozycjaC3
				{
					KodKraju = kodKraju,
					RodzajDostaw = p.RodzajDostaw == Soneta.Deklaracje.VAT.VIUDO_Pozycja.RodzajDostawy.Usluga ? "SERVICES" : "GOODS",
					RodzajStawki = CaptionAttribute.EnumToString(p.RodzajStawki).ToUpper(),
					Stawka = GetDotSeparator(p.StawkaPodatkuVAT),
					PodstawaOpodatkowania = GetDotSeparator(p.PodstawaOpodatkowania.Value),
					KwotaPodatku = GetDotSeparator(p.KwotaPodatku.Value),
					NIPUE = p.NipUE.All(char.IsLetter) ? null : substringNIPUE,
					KodKrajuWydaniaAttr = string.Format("issuedBy=\"{0}\"", substringKodKrajuWydania),
					KodKrajuWydania = substringKodKrajuWydania
				});
			}

			if(p.Blok == "C5"){
				var kodKraju = GetKodKraju(dek.Session, p.Panstwo);
				if (!pozycjeC5.ContainsKey(kodKraju))
					pozycjeC5.Add(kodKraju, new List<PozycjaC5>());

				pozycjeC5[kodKraju].Add(new PozycjaC5
				{
					KodKraju =  kodKraju,
					Rok = p.Rok,
					Kwartal = (int)p.Kwartal,
					KwotaPodatkuZKorekt = GetDotSeparator(p.KwotaPodatkuZKorekt.Value)
				});
			}
				
		}

		foreach(var p in dek.C6Tablica)
		{
			pozycjeC6.Add(new PozycjaC6
			{
				KodKraju = GetKodKraju(dek.Session, p.Panstwo),
				PodatekNalezny = GetDotSeparator(p.PodatekNalezny.Value)
			});
		}
		SumaPodatek.EditValue = GetDotSeparator(pozycje.Sum(x => x.KwotaPodatku.Value));
		C2SumaUslug.EditValue = CheckEmptyOrZero(dek.C2SumaUslug.Value) ? null : GetDotSeparator(dek.C2SumaUslug.Value);
		C2SumaTowarow.EditValue =  GetDotSeparator(dek.C2SumaTowarow.Value);
		C3SumaUslug.EditValue = GetDotSeparator(dek.C3SumaUslug.Value);
		C3SumaTowarow.EditValue = GetDotSeparator(dek.C3SumaTowarow.Value);

		SecC2SumaUslug.Visible = !CheckEmptyOrZero(dek.C2SumaUslug.Value);
		SecC2SumaTowarow.Visible = !CheckEmptyOrZero(dek.C2SumaTowarow.Value);
		SecC3SumaUslug.Visible = !CheckEmptyOrZero(dek.C3SumaUslug.Value);
		SecC3SumaTowarow.Visible = !CheckEmptyOrZero(dek.C3SumaTowarow.Value);

		
		C2.DataSource = pozycjeC2;
		C3.DataSource = pozycjeC3;
		C5.DataSource = pozycjeC5;
		Saldo.DataSource = pozycjeC6;

		Dostawy.Visible = pozycjeC2.Count != 0 || pozycjeC3.Count != 0;
		Korekty.Visible = pozycjeC5.Count != 0;
		Podatek.Visible = Dostawy.Visible || Korekty.Visible;

		PodatekNaleznySuma.EditValue = GetDotSeparator(dek.PodatekNalezny.Value);
		ZakresDat.Visible = ((Date)dek.Bloki["C1"]["TerminRozpoczecia"]) != Date.Empty && ((Date)dek.Bloki["C1"]["TerminZakonczenia"]) != Date.Empty; 
	}

	private static string GetKodKraju(Session session, string nazwaKraju)
	{
		var krajTbl = session.Get<CoreModule>().KrajeTbl.WgNazwa[nazwaKraju];
		var kodKraju = krajTbl != null ? krajTbl.Kod2 : "";
		if(kodKraju == "GR")
			kodKraju = "EL";

		return kodKraju;
	}

	private static string GetDotSeparator(decimal value)
	{		
		return value.ToString(System.Globalization.CultureInfo.InvariantCulture);
	}
	private static bool CheckEmptyOrZero(decimal value)
	{
		var v = GetDotSeparator(value);
		if (string.IsNullOrEmpty(v))
			return true;

		if (v == "0" || v == "0.00")
			return true;

		return false;
	}
</script>


<ea:datacontext id="dc" runat="server" typename="Soneta.Deklaracje.VAT.VIUDO_1,Soneta.Deklaracje" oncontextload="OnContextLoad" />
<?xml version="1.0" encoding="UTF-8" ?>
<Deklaracja
	xmlns="http://crd.gov.pl/wzor/2021/08/09/10797/"
	xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
	xsi:schemaLocation="http://crd.gov.pl/wzor/2021/08/09/10797/ http://crd.gov.pl/wzor/2021/08/09/10797/schemat.xsd"
	xmlns:etd="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2020/03/11/eD/DefinicjeTypy/"
	xmlns:oss="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2021/03/12/eD/DefinicjeTypyOss/" >
	<Naglowek>
		<KodFormularza kodSystemowy="VIU-DO (1)" kodPodatku="VIU" rodzajZobowiazania="Z" wersjaSchemy="1-0E">VIU-DO</KodFormularza>


		<ea:XmlDataLabel ID="WariantFormularza" ElementName="WariantFormularza" runat="server" />
		<ea:XmlDataLabel runat="server" ID="DataWypelnienia" ElementName="DataWypelnienia" />
		<CelZlozenia><ea:XmlDataLabel runat="server" DataMember="A.WersjaRobocza"><ValuesMap><ea:ValuesPair Key="False" Value="1" /><ea:ValuesPair Key="True" Value="2"/></ValuesMap></ea:XmlDataLabel></CelZlozenia>
		<Rok><ea:XmlDataLabel runat="server" DataMember="0.Rok" /></Rok>
		<Kwartal><ea:XmlDataLabel runat="server" DataMember="0.Kwartal" /></Kwartal>
		<KodUrzedu><ea:XmlDataLabel runat="server" ID="KodUS" /></KodUrzedu>
	</Naglowek>

	<Podmiot1 rola="Podatnik">
		<ea:Section ID="OsobaFizyczna" runat="server">
			<oss:OsobaFizyczna>
				<ea:XmlDataLabel runat="server" ElementName="oss:NIP" DataMember="B.NIP" XSDType="TNrNIP"></ea:XmlDataLabel>
				<ea:XmlDataLabel runat="server" ElementName="oss:ImiePierwsze" ID="ImiePierwsze" XSDType="TImie"></ea:XmlDataLabel>
				<ea:XmlDataLabel runat="server" ElementName="oss:Nazwisko" ID="Nazwisko" XSDType="TNazwisko"></ea:XmlDataLabel>
			</oss:OsobaFizyczna>
		</ea:Section>
		<ea:Section ID="OsobaNieFizyczna" runat="server">
			<oss:OsobaNiefizyczna>
				<ea:XmlDataLabel runat="server" ElementName="oss:NIP" DataMember="B.NIP" XSDType="TNrNIP"></ea:XmlDataLabel>
				<ea:XmlDataLabel runat="server" ElementName="oss:PelnaNazwa" ID="NazwaPelna" XSDType="TZnakowy"></ea:XmlDataLabel>       
			</oss:OsobaNiefizyczna>
		</ea:Section>
	</Podmiot1>
	<PozycjeSzczegolowe>
		<ea:Section ID="ZakresDat" runat="server">
			<Period>
				<ea:XmlDataLabel ElementName="oss:StartDate" runat="server" DataMember="C1.TerminRozpoczecia" XSDType="TData"/>
				<ea:XmlDataLabel ElementName="oss:EndDate" runat="server" DataMember="C1.TerminZakonczenia" XSDType="TData"/>

			</Period>
		</ea:Section>
		<ea:Section ID="Podatek" runat="server">
		<VATReturnMSCON>
			<ea:Section ID="Dostawy" runat="server">
				<Supplies>
					<ea:DataRepeater ID="C2" runat="server" WithSections="False">
						<MSIDSupplies>
							<ea:XmlDataLabel ElementName="MSCONCountryCode" runat="server" DataMember="Key"  />
							<MSIDSupply>
								<ea:DataRepeater runat="server" WithSections="False" DataMember="Value">
										<oss:OSSVATReturnDetail>
											<oss:SupplyType><ea:XmlDataLabel runat="server" DataMember="RodzajDostaw"/></oss:SupplyType>
											<ea:Section ConditionValue="PODSTAWOWA" DataMember="RodzajStawki" runat="server"><oss:VATRate type="STANDARD"><ea:XmlDataLabel runat="server" DataMember="Stawka"/></oss:VATRate></ea:Section>
											<ea:Section ConditionValue="OBNIŻONA" DataMember="RodzajStawki" runat="server"><oss:VATRate type="REDUCED"><ea:XmlDataLabel runat="server" DataMember="Stawka" /></oss:VATRate></ea:Section>
											<oss:TaxableAmount currency="EUR"><ea:XmlDataLabel runat="server" DataMember="PodstawaOpodatkowania" /></oss:TaxableAmount>
											<oss:VATAmount currency="EUR"><ea:XmlDataLabel runat="server" DataMember="KwotaPodatku"/></oss:VATAmount>
										</oss:OSSVATReturnDetail>
								</ea:DataRepeater>
							</MSIDSupply>
						</MSIDSupplies>
					</ea:DataRepeater>
					<ea:Section ID="SecC2SumaUslug" runat="server">
						<GrandTotalMSIDServices currency="EUR"><ea:XmlDataLabel runat="server" ID="C2SumaUslug"/></GrandTotalMSIDServices>
					</ea:Section>
					<ea:Section ID="SecC2SumaTowarow" runat="server">
						<GrandTotalMSIDGoods currency="EUR"><ea:XmlDataLabel runat="server" ID="C2SumaTowarow"/></GrandTotalMSIDGoods>
					</ea:Section>
					<ea:DataRepeater ID="C3" runat="server" WithSections="False">
						<MSESTSupplies>
							<ea:XmlDataLabel ElementName="MSCONCountryCode" runat="server" DataMember="Key"  />
								<ea:DataRepeater runat="server" WithSections="False" DataMember="Value">
									<MSESTSupply>
											<VATReturnDetails>
												<ea:Section ConditionValue="IS NOT NULL" DataMember="NIPUE" runat="server">
													<EUTraderID>
														<ea:Section ConditionValue="IS NOT NULL" DataMember="NIPUE" runat="server"><ea:XmlDataLabel ElementName="oss:VATIdentificationNumber" CustomAttributes="KodKrajuWydaniaAttr" runat="server" DataMember="NIPUE" /></ea:Section>
														<ea:Section ConditionValue="IS NULL" DataMember="NIPUE" runat="server"><ea:XmlDataLabel ElementName="oss:TaxReferenceNumber" CustomAttributes="KodKrajuWydaniaAttr" runat="server" /></ea:Section>
													</EUTraderID>
												</ea:Section>
												<ea:Section ConditionValue="IS NULL" DataMember="NIPUE" runat="server">
													<ea:XmlDataLabel ElementName="CountryCode" runat="server" DataMember="KodKrajuWydania" />
												</ea:Section>
												<OSSVATReturnDetail>
													<oss:SupplyType><ea:XmlDataLabel runat="server" DataMember="RodzajDostaw"/></oss:SupplyType>
													<ea:Section ConditionValue="PODSTAWOWA" DataMember="RodzajStawki" runat="server"><oss:VATRate type="STANDARD"><ea:XmlDataLabel runat="server" DataMember="Stawka"/></oss:VATRate></ea:Section>
													<ea:Section ConditionValue="OBNIŻONA" DataMember="RodzajStawki" runat="server"><oss:VATRate type="REDUCED"><ea:XmlDataLabel runat="server" DataMember="Stawka" /></oss:VATRate></ea:Section>
													<oss:TaxableAmount currency="EUR"><ea:XmlDataLabel runat="server" DataMember="PodstawaOpodatkowania" /></oss:TaxableAmount>
													<oss:VATAmount currency="EUR"><ea:XmlDataLabel runat="server" DataMember="KwotaPodatku"/></oss:VATAmount>
												</OSSVATReturnDetail>
											</VATReturnDetails>
									</MSESTSupply>
								</ea:DataRepeater>
						</MSESTSupplies>
					</ea:DataRepeater>
					<ea:Section ID="SecC3SumaUslug" runat="server">
						<GrandTotalMSESTServices currency="EUR"><ea:XmlDataLabel  runat="server" ID="C3SumaUslug"/></GrandTotalMSESTServices>
					</ea:Section>
					<ea:Section ID="SecC3SumaTowarow" runat="server">
						<GrandTotalMSESTGoods currency="EUR"><ea:XmlDataLabel runat="server" ID="C3SumaTowarow" /></GrandTotalMSESTGoods>
					</ea:Section>
					<GrandTotal currency="EUR"><ea:XmlDataLabel runat="server" ID="SumaPodatek" /></GrandTotal>
				</Supplies>
			</ea:Section>
			<ea:Section ID="Korekty" runat="server">
				<ea:DataRepeater ID="C5" runat="server" WithSections="False">					
					<Corrections>
							<ea:XmlDataLabel ElementName="MSCONCountryCode" runat="server" DataMember="Key"  />
							<MSCONCorrections>
								<ea:DataRepeater runat="server" WithSections="False" DataMember="Value">									
									<oss:Correction>
										<oss:Period>
											<ea:XmlDataLabel ElementName="oss:Year" runat="server" DataMember="Rok"  />
											<ea:XmlDataLabel ElementName="oss:Quarter" runat="server" DataMember="Kwartal"  />
										</oss:Period>
										<oss:TotalVATAmountCorrection currency="EUR"><ea:XmlDataLabel runat="server" DataMember="KwotaPodatkuZKorekt"/></oss:TotalVATAmountCorrection>
									</oss:Correction>
								</ea:DataRepeater>
							</MSCONCorrections>
					</Corrections>
				</ea:DataRepeater>
			</ea:Section>
		</VATReturnMSCON>
		</ea:Section>
		<ea:DataRepeater ID="Saldo" runat="server" WithSections="False">
			<MSCONBalance>
				<ea:XmlDataLabel ElementName="MSCONCountryCode" runat="server" DataMember="KodKraju"  />
				<BalanceOfVATDue currency="EUR"><ea:XmlDataLabel runat="server" DataMember="PodatekNalezny" /></BalanceOfVATDue>
			</MSCONBalance>
		</ea:DataRepeater>
		<TotalAmountOfVATDue currency="EUR"><ea:XmlDataLabel runat="server" ID="PodatekNaleznySuma" /></TotalAmountOfVATDue>

	</PozycjeSzczegolowe>
	<Pouczenie1>Za podanie nieprawdy lub zatajenie prawdy i przez to narażenie podatku na uszczuplenie grozi odpowiedzialność przewidziana w Kodeksie karnym skarbowym.</Pouczenie1>
	<Pouczenie2>W przypadku niewpłacenia w obowiązującym terminie kwoty podatku VAT należnej Rzeczpospolitej Polskiej lub wpłacenia jej w niepełnej wysokości, niniejsza deklaracja stanowi podstawę do wystawienia tytułu wykonawczego, zgodnie z art. 3a § 1 pkt 1 ustawy z dnia 17 czerwca 1966 r. o postępowaniu egzekucyjnym w administracji (Dz. U. z 2020 r. poz. 1427, z późn. zm.).</Pouczenie2>

</Deklaracja>
