﻿<%@ Page Language="c#" CodePage="1200" %>

<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Import Namespace="Soneta.Core" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Business.App" %>
<%@ Import Namespace="Soneta.Handel" %>
<%@ Import Namespace="Soneta.Handel.Forms" %>
<%@ Import Namespace="Soneta.Kasa" %>
<%@ Import Namespace="Soneta.Magazyny" %>
<%@ Import Namespace="Soneta.Waluty" %>
<%@ Import Namespace="Soneta.Types" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <title>Sprzedaż</title>
    <script runat="server">

    ParametryWydrukuDokumentu parametry;
    [Context]
    public ParametryWydrukuDokumentu Parametry {
        get { return parametry; }
        set { parametry = value; }
    }
    
    void OnContextLoad(Object sender, EventArgs args) {
        DataRepeater1.DataSource = (IEnumerable)Parametry;
        DokumentHandlowy dokument = Parametry.Dokument;
        DataRepeaterKWPZ.DataSource = new object[] {dokument};
        DataLabel19.EditValue = dokument.LiczonaOd == SposobLiczeniaVAT.OdNetto ? dokument.Suma.NettoCy : dokument.Suma.BruttoCy;

        if (dokument.DokumentKorygowany != null)
        {
            DataRepeater.Visible = false;
            DataRepeaterKWPZ.Visible = false;
            DataRepeaterKorekta.DataSource = new object[] { dokument };
        }
        else
        {
            if (dokument.Definicja.JestKWPZ)
            {
                DataRepeater.Visible = false;
                DataRepeaterKorekta.Visible = false;
                DataLabel19.EditValue = dokument.WartośćWCenieZakupu;
            }
            else
            {
                DataRepeater.DataSource = new object[] { dokument };
                DataRepeaterKorekta.Visible = false;
                DataRepeaterKWPZ.Visible = false;
            }
        }
        
        dc.AdditionalFooterInfo = dokument.Definicja.InformacjeKRS;
        
        SectionDokumentHandlowy.Visible = dokument.DokumentHandlowyNumer!="";
        SectionMagazyn.Visible = dokument.Magazyn!=null && dokument.MagazynDo==null;
        SectionMagazynDo.Visible = dokument.MagazynDo!=null;
    
        //Formatujemy informację o podmiocie
        if (dokument.Kontrahent==null)
            SectionKontrahent.Visible = false;
        else {
            if (dokument.Wydruk.JestOdbiorca)
                kto2.EditValue = "Kontrahent";
            else
                kto2.EditValue = dokument.Definicja.DostawcaOdbiorca;
        }
    
        //Składamy opis do dokumentu
        string opis = "";
        if (dokument.Opis!="")
            opis += "<p>" + dokument.Opis + "</p>";
        if (dokument.Wydruk.OpisWydruku!="")
            opis += "<p>" + dokument.Wydruk.OpisWydruku + "</p>";
        Opis.EditValue = opis;
    
        //Formatujemy podpisy
        stPodpis.Caption = "<font size=1>Dokument wystawił: </font><font size=2>"+dokument.Wydruk.UprawnionyDoWystawienia.FullName+"</font><br><br><font size=1>..................................................<br>Podpis osoby uprawnionej do wystawienia dokumentu</font>";
        stOsoba.Caption = "<font size=2>"+dokument.Osoba+"</font><br><br><font size=1>..................................................<br>Podpis osoby upoważnionej do otrzymania dokumentu</font>";

        if (dokument.Definicja.CenaWartosc0)
        {
            Grid.ShowSum = GridKWPZ.ShowSum = Grid2.ShowSum = Grid3.ShowSum = Soneta.Web.GridSumMode.Never;
            CenaColumn.Visible = CenaColumn2.Visible = CenaColumn3.Visible = false;
            WartoscColumn.Visible = WartoscColumn3.Visible = WartoscColumn3.Visible = false;   
        
        }

        Grid_RabatP.Visible = Grid_CenaPrzedRabatem.Visible = dokument.JestRabat && Parametry.Rabat
            && !dokument.Definicja.CenaWartosc0;

        DataLabel15.EditValue = dokument.LiczonaOd == SposobLiczeniaVAT.OdNetto ? dokument.Suma.Netto : dokument.Suma.Brutto;
    }

            
    void Grid_BeforeRow(Object sender, RowEventArgs args)
    {
        if(!section15.Visible) 
            if((args.Row as PozycjaDokHandlowego).WartoscCy.Symbol != "PLN")
                section15.Visible = true;
    }

    void Grid2_BeforeRow(Object sender, RowEventArgs args)
    {
        PozycjaDokHandlowego pozycja = (PozycjaDokHandlowego)args.Row;
        if (!pozycja.Dokument.Definicja.DrukujTylkoRoznicePrzedKorekta)
            return;

        args.VisibleRow = pozycja.Korygowana;
    }

    void Grid3_BeforeRow(Object sender, RowEventArgs args)
    {
        PozycjaDokHandlowego pozycja = (PozycjaDokHandlowego)args.Row;
        if (!pozycja.Dokument.Definicja.DrukujTylkoRoznicePoKorekcie)
            return;

        args.VisibleRow = pozycja.Korygowana;
    }
    
    void DataRepeater1_BeforeRow(Object sender, EventArgs args) {
        //Formatujemy nagłówek dokumentu.
        //Może być za każdym razem inny
        KopiaDokumentu kopia = (KopiaDokumentu)DataRepeater1.CurrentRow;
        DokumentHandlowy dokument = kopia.Dokument;
        string title = dokument.Definicja.TytulWydruku;
        if (title!="")
            title += " ";
        title += dokument.Numer;
        if (dokument.Wydruk.OpisStanu!="")
            title += "|" + dokument.Wydruk.OpisStanu;

        title += "|</STRONG>Data i miejsce wystawienia:<STRONG> " + dokument.Data + ", " + (dokument.Wydruk.JestOddzial ? dokument.Wydruk.PieczatkaOddziału.Adres.Miejscowosc : CoreModule.GetInstance(dokument).Config.Firma.AdresSiedziby.Miejscowosc);
        title += "|</STRONG>Data operacji:<STRONG> " + dokument.DataOperacji;
    
        ReportHeader1.Title = title;

        string bn = dokument.LiczonaOd == SposobLiczeniaVAT.OdBrutto || dokument.LiczonaOd == SposobLiczeniaVAT.OdBruttoMinusNetto ?
            " brutto" : dokument.LiczonaOd == SposobLiczeniaVAT.OdNetto ?
            " netto" : "";
        CenaColumn.Caption = CenaColumn2.Caption = "Cena " + bn;
        WartoscColumn.Caption = WartoscColumn2.Caption = "Wartość " + bn;
        CenaColumn3.Caption = "Cena " + bn;
        WartoscColumn3.Caption = "Zmiana wartości " + bn;        
    }    
    </script>
    <meta content="Microsoft Visual Studio 7.0" name="GENERATOR" />
    <meta content="C#" name="CODE_LANGUAGE" />
    <meta content="JavaScript" name="vs_defaultClientScript" />
    <meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema" />
</head>
<body>
    <form id="Sprzedaż" method="post" runat="server">
        <ea:DataContext ID="dc" runat="server" TypeName="Soneta.Handel.DokumentHandlowy,Soneta.Handel" OnContextLoad="OnContextLoad"></ea:DataContext>

        <ea:DataRepeater ID="DataRepeater1" runat="server" OnBeforeRow="DataRepeater1_BeforeRow" RowTypeName="Soneta.Handel.KopiaDokumentu,Soneta.Handel" Width="100%">
            <ea:SectionMarker ID="SectionMarker1" runat="server"></ea:SectionMarker>
            <ea:PageBreak ID="PageBreak1" runat="server" BreakFirstTimes="False" ResetPageCounter="true"></ea:PageBreak>
            <cc1:ReportHeader id="ReportHeader1" title="Magazyn" runat="server"></cc1:ReportHeader>

            <ea:Section ID="SectionDokumentHandlowy" runat="server" Width="100%">
                <em>Dokument handlowy: </em>
                <ea:DataLabel ID="DataLabel11" runat="server" DataMember="Dokument.DokumentHandlowyNumer" EncodeHTML="True"></ea:DataLabel>
                <em>&nbsp;z dnia:</em>
                <ea:DataLabel ID="DataLabel13" runat="server" DataMember="Dokument.DokumentHandlowyData" EncodeHTML="True"></ea:DataLabel>
                <br />
            </ea:Section>

            <ea:Section ID="SectionMagazyn" runat="server" Width="100%">
                <em>Magazyn: </em>
                <ea:DataLabel ID="DataLabel1" runat="server" DataMember="Dokument.Magazyn" EncodeHTML="True"></ea:DataLabel>
                <br />
            </ea:Section>

            <ea:Section ID="SectionMagazynDo" runat="server" Width="100%">
                <em>Z magazynu: </em>
                <ea:DataLabel ID="DataLabel2" runat="server" DataMember="Dokument.Magazyn" EncodeHTML="True"></ea:DataLabel>
                <em>Do magazynu: </em>
                <ea:DataLabel ID="DataLabel3" runat="server" DataMember="Dokument.MagazynDo" EncodeHTML="True"></ea:DataLabel>
                <br />
            </ea:Section>

            <ea:Section ID="SectionKontrahent" runat="server" Width="100%">
                <em>
                    <table id="Table1" cellspacing="0" width="100%">
                        <tr>
                            <td valign="top">
                                <!-- Oddział firmy -->
                                <ea:Section ID="OddzialFirmy" runat="server" DataMember="Dokument.Wydruk.JestOddzial">
                                    <em style="text-decoration: underline;">Oddział:</em>
                                    <div style="font-size: 13px; left: 10px; font-family: Tahoma; position: relative;">
                                        <ea:DataLabel ID="DataLabel42" runat="server" EncodeHTML="True" DataMember="Dokument.Wydruk.PieczatkaOddziału.Nazwa"></ea:DataLabel>
                                        <br />
                                        <ea:DataLabel ID="DataLabel44" runat="server" EncodeHTML="True" Bold="false" DataMember="Dokument.Wydruk.PieczatkaOddziału.Adres.Linia1"></ea:DataLabel>
                                        <br />
                                        <ea:DataLabel ID="DataLabel45" runat="server" EncodeHTML="True" Bold="false" DataMember="Dokument.Wydruk.PieczatkaOddziału.Adres.Linia2"></ea:DataLabel>
                                    </div>
                                </ea:Section>
                                <!-- Oddział firmy -->
                            </td>
                            <td valign="top">
                                <em style="text-decoration: underline;">
                                    <ea:DataLabel ID="kto2" runat="server" Bold="False" Font-Italic="True" EncodeHTML="True"></ea:DataLabel>
                                    :
                                </em>
                                <br />
                                <div style="font-size: 13px; left: 10px; font-family: Tahoma; position: relative">
                                    <ea:DataLabel ID="DataLabel4" runat="server" DataMember="Dokument.DaneKontrahenta.NazwaFormatowana" EncodeHTML="True"></ea:DataLabel>
                                    <br />
                                    <ea:DataLabel ID="DataLabel5" runat="server" Bold="False" DataMember="Dokument.DaneKontrahenta.Adres.Linia1" EncodeHTML="True"></ea:DataLabel>
                                    <br />
                                    <ea:DataLabel ID="DataLabel6" runat="server" Bold="False" DataMember="Dokument.DaneKontrahenta.Adres.Linia2" EncodeHTML="True"></ea:DataLabel>
                                    <br />
                                    NIP:
                                    <ea:DataLabel ID="DataLabel12" runat="server" Bold="False" DataMember="Dokument.DaneKontrahenta.EuVAT"></ea:DataLabel>
                                </div>
                                <ea:Section ID="sectionOdbiorca" runat="server" DataMember="Dokument.Wydruk.JestOdbiorca">
                                    <em style="text-decoration: underline;">
                                        <ea:DataLabel ID="kto" runat="server" Bold="False" Font-Italic="True" DataMember="Dokument.Definicja.DostawcaOdbiorca" EncodeHTML="True"></ea:DataLabel>
                                        :
                                    </em>
                                    <div style="font-size: 13px; left: 10px; font-family: Tahoma; position: relative">
                                        <ea:DataLabel ID="DataLabel10" runat="server" DataMember="Dokument.DaneOdbiorcy.NazwaFormatowana" EncodeHTML="True"></ea:DataLabel>
                                        <br />
                                        <ea:DataLabel ID="DataLabel9" runat="server" Bold="False" DataMember="Dokument.DaneOdbiorcy.Adres.Linia1" EncodeHTML="True"></ea:DataLabel>
                                        <br />
                                        <ea:DataLabel ID="DataLabel8" runat="server" Bold="False" DataMember="Dokument.DaneOdbiorcy.Adres.Linia2" EncodeHTML="True"></ea:DataLabel>
                                        <br />
                                        NIP:
                                        <ea:DataLabel ID="DataLabel7" runat="server" Bold="False" DataMember="Dokument.DaneOdbiorcy.EuVAT"></ea:DataLabel>
                                    </div>
                                </ea:Section>
                                <ea:Section ID="sectionMiejsceDostawy" runat="server" DataMember="Dokument.Wydruk.JestOdbiorcaMiejsceDostawy">
                                    <em style="text-decoration: underline;">Miejsce dostawy:</em>
                                    <div style="font-size: 13px; left: 10px; font-family: tahoma; position: relative">
                                        <ea:DataLabel ID="DataLabel16" runat="server" DataMember="Dokument.OdbiorcaMiejsceDostawy.Nazwa" EncodeHTML="True"></ea:DataLabel>
                                        <br />
                                        <ea:DataLabel ID="DataLabel17" runat="server" Bold="False" DataMember="Dokument.OdbiorcaMiejsceDostawy.Adres.Linia1" EncodeHTML="True"></ea:DataLabel>
                                        <br />
                                        <ea:DataLabel ID="DataLabel18" runat="server" Bold="False" DataMember="Dokument.OdbiorcaMiejsceDostawy.Adres.Linia2" EncodeHTML="True"></ea:DataLabel>
                                        <br />
                                    </div>
                                </ea:Section>
                            </td>
                        </tr>
                    </table>
                </em>
            </ea:Section>
                
        <!-- kwpz -->
            
        <ea:DataRepeater ID="DataRepeaterKWPZ" runat="server" Width="100%">
            <ea:SectionMarker ID="SectionMarkerKWPZ" runat="server">
            </ea:SectionMarker>
            <div style="margin: 10px 0px 5px 0px">
                <ea:Grid ID="GridKWPZ" runat="server" RowTypeName="Soneta.Handel.PozycjaDokHandlowego,Soneta.Handel"
                         DataMember="Wydruk.PozycjeRazem" RowsInRow="2" GroupData0="Workers.WydrukPozycji.SekcjaDokumentuMag" GroupLine="{0}"
                         ColumnSumFontBold="false" OnBeforeRow="Grid_BeforeRow">
                    <Columns>
                        <ea:GridColumn Width="4" Align="Right" DataMember="Lp" Caption="Lp." RowSpan="2" runat="server"></ea:GridColumn>
                        <ea:GridColumn Width="20" DataMember="Towar.Kod" Caption="Kod towaru" RowSpan="2" runat="server" EncodeHTML="True"></ea:GridColumn>
                        <ea:GridColumn DataMember="NazwaPierwszaLinia" Total="Info" Caption="Nazwa towaru" runat="server" EncodeHTML="True"></ea:GridColumn>
                        <ea:GridColumn DataMember="NazwaResztaLinii" Caption=" " runat="server"></ea:GridColumn>
                        <ea:GridColumn Width="10" RightBorder="None" Align="Right" DataMember="Ilosc.Value" Caption="Ilość" ID="GridColumn9" RowSpan="2" runat="server"></ea:GridColumn>
                        <ea:GridColumn Width="5" Align="Center" DataMember="Ilosc.Symbol" Caption="jm." RowSpan="2" runat="server"></ea:GridColumn>
                        <ea:GridColumn Width="15" Align="Right" DataMember="WartośćWCenieZakupu" Caption="Zmiana kosztu własnego" RowSpan="2" runat="server"></ea:GridColumn>
                    </Columns>
                </ea:Grid>
            </div>
            <ea:SectionMarker ID="SectionMarker1KWPZ" runat="server" SectionType="Footer">
            </ea:SectionMarker>
        </ea:DataRepeater>

            <!-- nie korekta -->

            <ea:DataRepeater ID="DataRepeater" runat="server" Width="100%">
                <ea:SectionMarker ID="SectionMarker2" runat="server">
                </ea:SectionMarker>
                <div style="margin: 10px 0px 5px 0px">
                    <ea:Grid ID="Grid" runat="server" RowTypeName="Soneta.Handel.PozycjaDokHandlowego,Soneta.Handel"
                        DataMember="Wydruk.PozycjeRazem" RowsInRow="2" GroupData0="Workers.WydrukPozycji.SekcjaDokumentuMag" GroupLine="{0}"
                        ColumnSumFontBold="false" OnBeforeRow="Grid_BeforeRow">
                        <Columns>
                            <ea:GridColumn Width="4" Align="Right" DataMember="Lp" Caption="Lp." RowSpan="2" runat="server"></ea:GridColumn>
                            <ea:GridColumn Width="20" DataMember="Towar.Kod" Caption="Kod towaru" RowSpan="2" runat="server" EncodeHTML="True"></ea:GridColumn>
                            <ea:GridColumn DataMember="NazwaPierwszaLinia" Total="Info" Caption="Nazwa towaru" runat="server" EncodeHTML="True"></ea:GridColumn>
                            <ea:GridColumn DataMember="NazwaResztaLinii" Caption=" " runat="server"></ea:GridColumn>
                            <ea:GridColumn ID="Grid_CenaPrzedRabatem" runat="server" DataMember="Cena" Width="15" RowSpan="2" Caption="Cena przed rabatem" Align="Right"></ea:GridColumn>
                            <ea:GridColumn ID="Grid_RabatP" runat="server" DataMember="Rabat" Width="10" RowSpan="2" Caption="Rabat %" Align="Right"></ea:GridColumn>
                            <ea:GridColumn ID="CenaColumn" Width="15" Align="Right" DataMember="CenaPoRabacie" Caption="Cena" RowSpan="2" runat="server"></ea:GridColumn>
                            <ea:GridColumn Width="10" RightBorder="None" Align="Right" DataMember="Ilosc.Value" Caption="Ilość" ID="IloscColumn" RowSpan="2" runat="server"></ea:GridColumn>
                            <ea:GridColumn Width="5" Align="Center" DataMember="Ilosc.Symbol" Caption="jm." RowSpan="2" runat="server"></ea:GridColumn>
                            <ea:GridColumn ID="WartoscColumn" Width="15" Align="Right" Total="Sum" DataMember="WartoscCy" Caption="Wartość" SumFontBold="False" RowSpan="2" runat="server"></ea:GridColumn>
                        </Columns>
                    </ea:Grid>
                </div>
                <ea:SectionMarker ID="SectionMarker3" runat="server" SectionType="Footer">
                </ea:SectionMarker>
            </ea:DataRepeater>

            <!-- korekta -->

            <ea:DataRepeater ID="DataRepeaterKorekta" runat="server" Width="100%">
                <ea:SectionMarker ID="SectionMarker4" runat="server">
                </ea:SectionMarker>
                <div style="margin: 10px 0px 5px 0px">
                    <em>Przed korektą:</em>
                    <ea:Grid ID="Grid2" runat="server" DataMember="Pozycje" RowsInRow="2"
                        RowTypeName="Soneta.Handel.PozycjaDokHandlowego,Soneta.Handel" OnBeforeRow="Grid2_BeforeRow">
                        <Columns>
                            <ea:GridColumn ID="GridColumn1" runat="server" Width="4" Align="Right" DataMember="#" Caption="Lp." RowSpan="2" EncodeHTML="True"></ea:GridColumn>
                            <ea:GridColumn ID="GridColumn12" Width="20" DataMember="PozycjaKorygowana.Towar.Kod" Caption="Kod towaru" RowSpan="2" runat="server" EncodeHTML="True"></ea:GridColumn>
                            <ea:GridColumn ID="GridColumn13" DataMember="PozycjaKorygowana.NazwaPierwszaLinia" Total="Info" Caption="Nazwa towaru" runat="server" EncodeHTML="True"></ea:GridColumn>
                            <ea:GridColumn ID="GridColumn14" DataMember="PozycjaKorygowana.NazwaResztaLinii" Caption=" " runat="server"></ea:GridColumn>
                            <ea:GridColumn ID="CenaColumn2" Width="15" Align="Right" DataMember="PozycjaKorygowana.CenaPoRabacie" Caption="Cena" RowSpan="2" runat="server"></ea:GridColumn>
                            <ea:GridColumn Width="10" RightBorder="None" Align="Right" DataMember="PozycjaKorygowana.Ilosc.Value" Caption="Ilość" ID="GridColumn3" RowSpan="2" runat="server"></ea:GridColumn>
                            <ea:GridColumn ID="GridColumn15" Width="5" Align="Center" DataMember="PozycjaKorygowana.Ilosc.Symbol" Caption="jm." RowSpan="2" runat="server"></ea:GridColumn>
                            <ea:GridColumn ID="WartoscColumn2" Width="16" Align="Right" DataMember="PozycjaKorygowana.WartoscCy" Total="Sum" Caption="Wartość" SumFontBold="False" RowSpan="2" runat="server"></ea:GridColumn>
                        </Columns>
                    </ea:Grid>
                </div>
                <div style="margin: 10px 0px 5px 0px">
                    <em>Korekta:</em>
                    <ea:Grid ID="Grid3" runat="server" DataMember="Pozycje" RowsInRow="2" RowTypeName="Soneta.Handel.PozycjaDokHandlowego,Soneta.Handel" OnBeforeRow="Grid3_BeforeRow">
                        <Columns>
                            <ea:GridColumn ID="GridColumn2" runat="server" Width="4" Align="Right" DataMember="#" Caption="Lp." RowSpan="2" EncodeHTML="True"></ea:GridColumn>
                            <ea:GridColumn ID="GridColumn4" Width="20" DataMember="Towar.Kod" Caption="Kod towaru" RowSpan="2" runat="server" EncodeHTML="True"></ea:GridColumn>
                            <ea:GridColumn ID="GridColumn5" DataMember="NazwaPierwszaLinia" Total="Info" Caption="Nazwa towaru" runat="server" EncodeHTML="True"></ea:GridColumn>
                            <ea:GridColumn ID="GridColumn16" DataMember="NazwaResztaLinii" Caption=" " runat="server"></ea:GridColumn>
                            <ea:GridColumn ID="CenaColumn3" Width="15" Align="Right" DataMember="CenaPoRabacie" Caption="Cena" RowSpan="2" runat="server"></ea:GridColumn>
                            <ea:GridColumn Width="10" RightBorder="None" Align="Right" DataMember="ZmianaIlości.Value" Caption="Zmiana ilości" ID="GridColumn18" RowSpan="2" runat="server"></ea:GridColumn>
                            <ea:GridColumn ID="GridColumn19" Width="5" Align="Center" DataMember="Ilosc.Symbol" Caption="jm." RowSpan="2" runat="server"></ea:GridColumn>
                            <ea:GridColumn ID="WartoscColumn3" Width="15" Align="Right" DataMember="ZmianaWartościCy" Total="Sum" Caption="Zmiana wartości" SumFontBold="False" RowSpan="2" runat="server"></ea:GridColumn>
                            <ea:GridColumn runat="server" ID="RodzajKorektyCol" DataMember="RodzajKorektyOpis" Width="16" Caption="Zmiana" RowSpan="2" Align="Center"></ea:GridColumn>
                        </Columns>
                    </ea:Grid>
                </div>
                <ea:SectionMarker ID="SectionMarker5" runat="server" SectionType="Footer">
                </ea:SectionMarker>
            </ea:DataRepeater>

            <ea:Section runat="server" DataMember="Dokument.Korekta">
                <div style="text-align: right; margin: 4px 15px 4px 0px">
                    <b>Wartość <%=Parametry.Dokument.LiczonaOd == SposobLiczeniaVAT.OdNetto ? "netto" : "brutto" %> korekty: </b>
                    <ea:DataLabel ID="DataLabel19" runat="server" Bold="True">
                    </ea:DataLabel>
                </div>
            </ea:Section>

            <div style="margin: 5px 0px 10px 0px">
                Podsumowanie ilości:
                <ea:DataLabel ID="DataLabel14" runat="server" Bold="False" DataMember="Dokument.Wydruk.PodsumowanieIlości">
                </ea:DataLabel>
                <br />

                <ea:Section ID="section15" runat="server" Visible="false">
                    Podsumowanie <%=Parametry.Dokument.LiczonaOd == SposobLiczeniaVAT.OdNetto ? "netto" : "brutto" %> w PLN:
                    <ea:DataLabel ID="DataLabel15" runat="server" Bold="False">
                    </ea:DataLabel>
                    <br />
                </ea:Section>
            </div>

            <ea:Section ID="sectionNumeryNadrzednych" runat="server" DataMember="Dokument.Wydruk.CzyDrukowacNumeryPowiazanych">
                <div style="margin: 5px 0px 5px 0px">
                    <em>Dokumenty powiązane:</em>
                    <div style="font-size: 13px; left: 10px; font-family: Tahoma; position: relative">
                        <ea:DataLabel ID="labelNumeryNadrzednych" runat="server" DataMember="Dokument.Wydruk.NumeryNadrzędneZK" Bold="False">
                        </ea:DataLabel>
                        <ea:DataLabel ID="labelNumeryPodrzednych" runat="server" DataMember="Dokument.Wydruk.NumeryPodrzędneBK" Bold="False">
                        </ea:DataLabel>
                    </div>
                </div>
            </ea:Section>

            <ea:Section runat="server" DataMember="Dokument.Wydruk.CzyDrukowacNumeryKorekt">
                <div style="margin: 5px 0px 5px 0px">
                    <em>Poprzednie korekty:</em>
                    <div style="font-size: 13px; left: 10px; font-family: Tahoma; position: relative">
                        <ea:DataLabel runat="server" DataMember="Dokument.Wydruk.NumeryPoprzednichKorekt"
                            Bold="false">
                        </ea:DataLabel>
                    </div>
                </div>
            </ea:Section>

            <ea:DataLabel ID="Opis" runat="server" Bold="False"></ea:DataLabel>

            <cc1:ReportFooter id="ReportFooter1" runat="server" Height="105px" TheEnd="False">
                <subtitles>
					<cc1:FooterSubtitle runat="server" Caption="Operator" ID="stPodpis" SubtitleType="CenterText" Width="50"></cc1:FooterSubtitle>
					<cc1:FooterSubtitle runat="server" Caption="Osoba" ID="stOsoba" SubtitleType="CenterText" Width="50"></cc1:FooterSubtitle>
			  </subtitles>
            </cc1:ReportFooter>
            <ea:SectionMarker ID="SectionMarker6" runat="server" SectionType="Footer"></ea:SectionMarker>
        </ea:DataRepeater>
    </form>
</body>
</html>

