﻿using System;
using System.Collections;
using System.Web.UI;
using Soneta.Core;
using Soneta.Kadry;
using Soneta.Business;
using Soneta.Types;
using Soneta.Tools;
using Soneta.Kasa;
using Soneta.Kalend;
using System.Diagnostics;
using System.Collections.Generic;
using Soneta.Web;
using Soneta.Deklaracje;
using System.Web.UI.HtmlControls;
using Soneta.Core.Web;
using Soneta.Place;

namespace ASP {

    public partial class RMUA : System.Web.UI.Page {

        public static string tabhead = "<TABLE cellSpacing=\"0\" cellPadding=\"0\" height=\"8px\"><TR><TD></TD></TR></TABLE>" +
            "<TABLE cellSpacing=\"0\" cellPadding=\"0\" width=\"100%\">" +
            "<TR>" +
            "<TD><FONT face=\"Arial\" size=\"1\"><b>Zestawienie wypłaconych świadczeń i wynagrodzeń za czas absencji chorobowej oraz rodzaje i okresy przerw w opłacaniu składek:</b></FONT></TD>" +
            "</TR>" +
            "</TABLE>" +
            "<TABLE cellSpacing=\"0\" cellPadding=\"0\" width=\"100%\" style=\"BORDER:silver 1px solid\">" +
            "<TR>" +
            "<TD width=\"60%\" Align=\"Center\" style=\"BORDER-RIGHT:silver 1px solid\"><FONT face=\"Arial\" size=\"1\">Kod przerwy świadczenia</FONT></TD>" +
            "<TD width=\"10%\" Align=\"Center\" style=\"BORDER-RIGHT:silver 1px solid\"><FONT face=\"Arial\" size=\"1\">Okres od</FONT></TD>" +
            "<TD width=\"10%\" Align=\"Center\" style=\"BORDER-RIGHT:silver 1px solid\"><FONT face=\"Arial\" size=\"1\">Okres do</FONT></TD>" +
            "<TD width=\"10%\" Align=\"Center\" style=\"BORDER-RIGHT:silver 1px solid\"><FONT face=\"Arial\" size=\"1\">Liczba dni zasiłkowych</FONT></TD>" +
            "<TD width=\"10%\" Align=\"Center\"><FONT face=\"Arial\" size=\"1\">Kwota</FONT></TD>" +
            "</TR>" +
            "</TABLE>";

        public static string tabrow = "<TABLE cellSpacing=\"0\" cellPadding=\"0\" width=\"100%\" border=\"0\">" +
            "<TR>" +
            "<TD width=\"60%\" Align=\"Left\" style=\"BORDER-RIGHT:silver 1px solid; BORDER-LEFT:silver 1px solid; BORDER-BOTTOM:silver 1px solid\"><FONT face=\"Arial\" size=\"1\">#1#</FONT></TD>" +
            "<TD width=\"10%\" Align=\"Right\" style=\"BORDER-RIGHT:silver 1px solid; BORDER-BOTTOM:silver 1px solid\"><FONT face=\"Arial\" size=\"1\"><b>#2#</b></FONT></TD>" +
            "<TD width=\"10%\" Align=\"Right\" style=\"BORDER-RIGHT:silver 1px solid; BORDER-BOTTOM:silver 1px solid\"><FONT face=\"Arial\" size=\"1\"><b>#3#</b></FONT></TD>" +
            "<TD width=\"10%\" Align=\"Center\" style=\"BORDER-RIGHT:silver 1px solid; BORDER-BOTTOM:silver 1px solid\"><FONT face=\"Arial\" size=\"1\"><b>#4#</b></FONT></TD>" +
            "<TD width=\"10%\" Align=\"Right\" style=\"BORDER-RIGHT:silver 1px solid; BORDER-BOTTOM:silver 1px solid\"><FONT face=\"Arial\" size=\"1\"><b>#5#</b></FONT></TD>" +
            "</TR>" +
            "</TABLE>";

        public static string datarow = "<TABLE cellSpacing=\"0\" cellPadding=\"0\" height=\"8px\"><TR><TD></TD></TR></TABLE>" +
            "<TABLE cellSpacing=\"0\" cellPadding=\"0\" width=\"100%\">" +
            "<TR>" +
            "<TD><FONT face=\"Arial\" size=\"1\"><b>Zestawienie należnych składek na ubezpieczenia społeczne i ubezpieczenie zdrowotne</b></FONT></TD>" +
            "</TR>" +
            "</TABLE>" +
            "<TABLE cellSpacing=\"0\" cellPadding=\"0\" width=\"70%\">" +
            "<TR>" +
            "<TD width=\"50%\"><FONT face=\"Arial\" size=\"1\">Kod tytułu ubezpieczenia:</FONT></TD>" +
            "<TD width=\"50%\"><FONT face=\"Arial\" size=\"1\"><b>#KodTyUb#</b></FONT></TD>" +
            "</TR>" +
            "<TR>" +
            "<TD width=\"50%\"><FONT face=\"Arial\" size=\"1\">Wymiar czasu pracy:</FONT></TD>" +
            "<TD width=\"50%\"><FONT face=\"Arial\" size=\"1\"><b>#WmEtat#</b></FONT></TD>" +
            "</TR>" +
            "<TR>" +
            "<TD width=\"50%\"><FONT face=\"Arial\" size=\"1\">Kod oddziału NFZ:</FONT></TD>" +
            "<TD width=\"50%\"><FONT face=\"Arial\" size=\"1\"><b>#KodNFZ#</b></FONT></TD>" +
            "</TR>" +
            "</TABLE>";

        public static string deschead = "<TABLE cellSpacing=\"0\" cellPadding=\"0\" width=\"100%\" style=\"BORDER:silver 1px solid\">" +
            "<TR>" +
            "<TD width=\"5.4%\"  Align=\"Center\" style=\"BORDER-RIGHT:silver 1px solid\" rowspan=\"2\"><FONT face=\"Arial\" size=\"1\">mc</FONT></TD>" +
            "<TD width=\"25.8%\" Align=\"Center\" style=\"BORDER-RIGHT:silver 1px solid; BORDER-BOTTOM:silver 1px solid\" colspan=\"3\"><FONT face=\"Arial\" size=\"1\">Podstawa wymiaru składek</FONT></TD>" +
            "<TD width=\"60.2%\" Align=\"Center\" style=\"BORDER-RIGHT:silver 1px solid; BORDER-BOTTOM:silver 1px solid\" colspan=\"7\"><FONT face=\"Arial\" size=\"1\">Ubezpieczenie</FONT></TD>" +
            "<TD width=\"8.6%\"  Align=\"Center\" rowspan=\"2\"><FONT face=\"Arial\" size=\"1\">Łączna kwota składek</FONT></TD>" +
            "</TR>" +
            "<TR>" +
            "<TD width=\"8.6%\" Align=\"Center\" style=\"BORDER-RIGHT:silver 1px solid\"><FONT face=\"Arial\" size=\"1\">em. i rn.</FONT></TD>" +
            "<TD width=\"8.6%\" Align=\"Center\" style=\"BORDER-RIGHT:silver 1px solid\"><FONT face=\"Arial\" size=\"1\">chor.wyp.</FONT></TD>" +
            "<TD width=\"8.6%\" Align=\"Center\" style=\"BORDER-RIGHT:silver 1px solid\"><FONT face=\"Arial\" size=\"1\">zdrowotne</FONT></TD>" +
            "<TD width=\"8.6%\" Align=\"Center\" style=\"BORDER-RIGHT:silver 1px solid\"><FONT face=\"Arial\" size=\"1\">emer.pł.</FONT></TD>" +
            "<TD width=\"8.6%\" Align=\"Center\" style=\"BORDER-RIGHT:silver 1px solid\"><FONT face=\"Arial\" size=\"1\">emer.ub.</FONT></TD>" +
            "<TD width=\"8.6%\" Align=\"Center\" style=\"BORDER-RIGHT:silver 1px solid\"><FONT face=\"Arial\" size=\"1\">rent.pł.</FONT></TD>" +
            "<TD width=\"8.6%\" Align=\"Center\" style=\"BORDER-RIGHT:silver 1px solid\"><FONT face=\"Arial\" size=\"1\">rent.ub.</FONT></TD>" +
            "<TD width=\"8.6%\" Align=\"Center\" style=\"BORDER-RIGHT:silver 1px solid\"><FONT face=\"Arial\" size=\"1\">chorob.</FONT></TD>" +
            "<TD width=\"8.6%\" Align=\"Center\" style=\"BORDER-RIGHT:silver 1px solid\"><FONT face=\"Arial\" size=\"1\">wypadk.</FONT></TD>" +
            "<TD width=\"8.6%\" Align=\"Center\" style=\"BORDER-RIGHT:silver 1px solid\"><FONT face=\"Arial\" size=\"1\">zdrowot.</FONT></TD>" +
            "</TR>" +
            "</TABLE>";

        public static string descrow = "<TABLE cellSpacing=\"0\" cellPadding=\"0\" width=\"100%\" border=\"0\">" +
            "<TR>" +
            "<TD width=\"5.4%\" Align=\"Center\" style=\"BORDER-RIGHT:silver 1px solid; BORDER-LEFT:silver 1px solid; BORDER-BOTTOM:silver 1px solid\"><FONT face=\"Arial\" size=\"1\"><b>#OkresR#</b></FONT></TD>" +
            "<TD width=\"8.6%\" Align=\"Right\" style=\"BORDER-RIGHT:silver 1px solid; BORDER-BOTTOM:silver 1px solid\"><FONT face=\"Arial\" size=\"1\"><b>#UbEmRenP1#</b></FONT></TD>" +
            "<TD width=\"8.6%\" Align=\"Right\" style=\"BORDER-RIGHT:silver 1px solid; BORDER-BOTTOM:silver 1px solid\"><FONT face=\"Arial\" size=\"1\"><b>#UbChrWypP1#</b></FONT></TD>" +
            "<TD width=\"8.6%\" Align=\"Right\" style=\"BORDER-RIGHT:silver 1px solid; BORDER-BOTTOM:silver 1px solid\"><FONT face=\"Arial\" size=\"1\"><b>#UbZdrP#</b></FONT></TD>" +
            "<TD width=\"8.6%\" Align=\"Right\" style=\"BORDER-RIGHT:silver 1px solid; BORDER-BOTTOM:silver 1px solid\"><FONT face=\"Arial\" size=\"1\"><b>#UbEmPl#</b></FONT></TD>" +
            "<TD width=\"8.6%\" Align=\"Right\" style=\"BORDER-RIGHT:silver 1px solid; BORDER-BOTTOM:silver 1px solid\"><FONT face=\"Arial\" size=\"1\"><b>#UbEmUb#</b></FONT></TD>" +
            "<TD width=\"8.6%\" Align=\"Right\" style=\"BORDER-RIGHT:silver 1px solid; BORDER-BOTTOM:silver 1px solid\"><FONT face=\"Arial\" size=\"1\"><b>#UbRenPl#</b></FONT></TD>" +
            "<TD width=\"8.6%\" Align=\"Right\" style=\"BORDER-RIGHT:silver 1px solid; BORDER-BOTTOM:silver 1px solid\"><FONT face=\"Arial\" size=\"1\"><b>#UbRenUb#</b></FONT></TD>" +
            "<TD width=\"8.6%\" Align=\"Right\" style=\"BORDER-RIGHT:silver 1px solid; BORDER-BOTTOM:silver 1px solid\"><FONT face=\"Arial\" size=\"1\"><b>#UbChr#</b></FONT></TD>" +
            "<TD width=\"8.6%\" Align=\"Right\" style=\"BORDER-RIGHT:silver 1px solid; BORDER-BOTTOM:silver 1px solid\"><FONT face=\"Arial\" size=\"1\"><b>#UbWyp#</b></FONT></TD>" +
            "<TD width=\"8.6%\" Align=\"Right\" style=\"BORDER-RIGHT:silver 1px solid; BORDER-BOTTOM:silver 1px solid\"><FONT face=\"Arial\" size=\"1\"><b>#UbZdrUb#</b></FONT></TD>" +
            "<TD width=\"8.6%\" Align=\"Right\" style=\"BORDER-RIGHT:silver 1px solid; BORDER-BOTTOM:silver 1px solid\"><FONT face=\"Arial\" size=\"1\"><b>#SumaUb#</b></FONT></TD>" +
            "</TR>" +
            "</TABLE>";

        public static string sumrow = "<TABLE cellSpacing=\"0\" cellPadding=\"0\" height=\"8px\"><TR><TD></TD></TR></TABLE>" +
            "<TABLE cellSpacing=\"0\" cellPadding=\"0\" width=\"100%\">" +
            "<TR>" +
            "<TD width=\"90%\"><FONT face=\"Arial\" size=\"1\">Informacja o przekroczeniu rocznej podstawy wymiaru składek na ubezpieczenia emerytalne i rentowe:</FONT></TD>" +
            "<TD width=\"10%\" Align=\"Right\"><FONT face=\"Arial\" size=\"1\"><b>#KodPrzek#</b></FONT></TD>" +
            "</TR>" +
            "<TR>" +
            "<TD width=\"90%\"><FONT face=\"Arial\" size=\"1\">Kwota obniżenia podstawy wymiaru składek na ubezpieczenia społeczne z tytułu opłacania składki w ramach pracowniczego programu emerytalnego:</FONT></TD>" +
            "<TD width=\"10%\" Align=\"Right\"><FONT face=\"Arial\" size=\"1\"><b>#KwotaObn#</b></FONT></TD>" +
            "</TR>" +
            "<TR>" +
            "<TD width=\"90%\"><FONT face=\"Arial\" size=\"1\">Łączna kwota składek:</FONT></TD>" +
            "<TD width=\"10%\" Align=\"Right\"><FONT face=\"Arial\" size=\"1\"><b>#SumaSumUb#</b></FONT></TD>" +
            "</TR>" +
            "</TABLE>" +
            "#PrzerwyL#";

        public static string plecKobieta = "Pani";

        public static string plecMezczyzna = "Pan";

        public static string kobietaMiejsce = "zamieszkała";

        public static string mezczyznaMiejsce = "zamieszkały";

        public static string infoMiesieczna = "Informacja miesięczna dla osoby ubezpieczonej ";

        public static string infoRoczna = "Informacja roczna dla osoby ubezpieczonej ";

        public class Params : ContextBase {
            public Params(Context context) : base(context) {
            }

            bool naliczone = false;
            [Caption("Tylko naliczone")]
            public bool Naliczone {
                get { return naliczone; }
                set {
                    naliczone = value;
                    OnChanged(EventArgs.Empty);
                }
            }
        }

        Params pars;
        [Context]
        public Params Pars {
            set { pars = value; }
        }
  
        string NBSP(string ss) {
            return ss == "" ? empty : ss;
        }

        void LiczDaneFirmy() {
            CoreModule core = CoreModule.GetInstance(dc);
            DeklaracjeModule dek = DeklaracjeModule.GetInstance(dc);
            IPieczątkaFirmy pf = ReportHeader.GetPieczątka(dc);
            string nip = pf.NIP;
            string regon = pf.REGON;
            string nazwask = pf.NazwaSkrócona;
            NIP.EditValue = NBSP(nip);
            REGON.EditValue = NBSP("");
            PESEL.EditValue = NBSP("");
            DOKUMENT.EditValue = NBSP("");
            NAZWASK.EditValue = NBSP(nazwask);
            if (regon != "")
                REGON.EditValue = NBSP(regon);
            if (nip == "" || regon == "")
                if (core.Config.Firma.DaneEwidencyjne.OsobaFizyczna) {
                    string pesel = core.Config.Firma.DaneEwidencyjne.PESEL;
                    if (pesel == "") {
                        Wlasciciel wls = dek.Config.ZUS.Ogólne.DaneWłaściciela;
                        if (wls != null) {
                            pesel = NBSP(wls.Last.PESEL);
                            if (pesel == "")
                                DOKUMENT.EditValue = NBSP(wls.Last.Dokument.SeriaNumer);
                        }
                    }
                    if (pesel != "")
                        PESEL.EditValue = NBSP(pesel);
                }
        }

        void LiczDanePracownika(Pracownik p, Date data) {
            PracHistoria ph = p[data];
            switch (ph.Plec) {
                case PłećOsoby.Kobieta:
                    PracZam.EditValue = kobietaMiejsce;
                    PracPlec.EditValue = plecKobieta;
                    break;
                case PłećOsoby.Mężczyzna:
                    PracZam.EditValue = mezczyznaMiejsce;
                    PracPlec.EditValue = plecMezczyzna;
                    break;
            }
            PracNazw.EditValue = ph.Nazwisko;
            PracImie.EditValue = ph.Imie;
            PracAdres1.EditValue = ph.Adres.Linia1;
            PracAdres2.EditValue = ph.Adres.Linia2;
            PracPesel.EditValue = ph.PESEL;
        }

        string[] bloki = {
                "DSMRMUA",
                "DLMRMUA",
                "DMMRMUA",
                "DKMRMUA",
                "DJMRMUA",
                "DCMRMUA",
                "DPMRMUA",
                "DRMRMUA",
                "DWMRMUA",
                "DZMRMUA",
                "DTMRMUA",
                "DGMRMUA" };
        
        Soneta.Deklaracje.ZUS.RMUA rmua = null;

        void IlePrzerw(YearMonth ym, ref List<string> lista) {
            string nazwa = bloki[ym.Month - 1];
            BlokDeklaracji blok = rmua.Bloki[nazwa];
            string przerwy = (string)blok["Przerwy"];
            string[] linie = przerwy.Split('#');
            foreach (string linia in linie) {
                string[] elementy = linia.Split('|');
                if (elementy.Length != 6)
                    continue;
                string t = elementy[0];
                if (!lista.Contains(t))
                    lista.Add(t);
            }
        }

        void IleDeklaracji(YearMonth ym, ref List<string> lista) {
            string nazwa = bloki[ym.Month - 1];
            BlokDeklaracji blok = rmua.Bloki[nazwa];
            string t = (string)blok["Tyub"];
            if (t == "") {
                IlePrzerw(ym, ref lista);
                if (lista.Count == 0 && !pars.Naliczone)
                    lista.Add(empty);
                return;
            }
            lista.AddRange(t.Split('#'));
            IlePrzerw(ym, ref lista);
        }

        class Dek {
            public YearMonth ym;
            public string tu;
            public Dek(YearMonth ym, string tu) {
                this.ym = ym;
                this.tu = tu;
            }
        }

        protected void OnContextLoad(Object sender, EventArgs args) {
            rmua = (Soneta.Deklaracje.ZUS.RMUA)dc[typeof(Soneta.Deklaracje.ZUS.RMUA)];

            bool miesieczna = rmua.IsDeklaracjaMiesieczna;
            ReportHeader1["TYTUL"] = (miesieczna ? infoMiesieczna : infoRoczna) + rmua.Pracownik.NazwiskoImię;
            NumerDok.EditValue = GetNumerDok(rmua);
            
            LiczDaneFirmy();
            LiczDanePracownika(rmua.Pracownik, rmua.Data);

            YearMonth ym;
            List<Dek> lista = new List<Dek>();
            List<string> tyub = new List<string>();
            if (miesieczna) {
                tyub.Clear();
                ym = rmua.RokMiesiac;
                IleDeklaracji(ym, ref tyub);
                if (!pars.Naliczone || tyub.Count > 0)
                    foreach (string tu in tyub)
                        lista.Add(new Dek(ym, tu));
            }
            else
                for (int i = 1; i <= 12; i++) {
                    tyub.Clear();
                    ym = new YearMonth(rmua.Rok, i);
                    IleDeklaracji(ym, ref tyub);
                    if (!pars.Naliczone || tyub.Count > 0)
                        foreach (string tu in tyub)
                            lista.Add(new Dek(ym, tu));
                }

            DataRepeater1.DataSource = lista;
        }

        string GetNumerDok(Soneta.Deklaracje.ZUS.RMUA rmua) {
            if (rmua.IsDeklaracjaMiesieczna)
                return string.Format("{0} {1}/{2}", rmua.Numer.Numer, rmua.RokMiesiac.Month, rmua.Rok);
            else
                return string.Format("{0} {1}", rmua.Numer.Numer, rmua.Rok);
        }

        int GetBlokNr(object value, string tyub) {
            string t = value.ToString();
            string[] b = t.Split('#');
            for (int i = 0; i < b.Length; i++)
                if (b[i] == tyub)
                    return i;
            return -1;
        }

        decimal sum = 0;
        string zero = "0,00";
        string empty = "&nbsp;";
        string przerwy = "";
        string prev = "";
        
        string GetBlok(object value, int nr, bool format = true) {
            string t = value.ToString();
            string[] b = t.Split('#');
            string v = "";
            if (nr != -1 && b.Length > nr)
                v = b[nr];
            if (v == "")
                v = format ? zero : empty;
            return v;
        }

        string GetTyub(string t) {
            int ty = 0;
            try {
                ty = int.Parse(t);
            }
            catch {
                return t;
            }
            TytulUbezpieczenia tyub = new TytulUbezpieczenia(ty);
            if (tyub == null)
                return t;
            return tyub.ToString();
        }

        protected void DataRepeater1_BeforeRow(Object sender, EventArgs args) {
            string sp = System.Globalization.CultureInfo.CurrentUICulture.NumberFormat.NumberDecimalSeparator;
            Dek dek = (Dek)DataRepeater1.CurrentRow;

            YearMonth ym = dek.ym;
            string tyub = dek.tu;
            string nazwa = bloki[ym.Month - 1];
            BlokDeklaracji blok = rmua.Bloki[nazwa];
            List<string> sumaSkl = new List<string>();
            bool fix = false, fix1 = false, fix2 = false;

            string t = "", e = "", n = "";

            int nr = GetBlokNr(blok["Tyub"], tyub);
            e = GetBlok(blok["WmEtat"], nr, false);
            if (tyub != empty) {
                t = GetTyub(tyub);
                PracHistoria ph = rmua.Pracownik[ym.LastDay];
                n = ph.OddzialNFZ != null ? ph.OddzialNFZ.Kod : "";
                fix = t.StartsWith("1211") || t.StartsWith("1240");
                fix1 = (GetBlok(blok["UbEmPl"], nr) != zero ||
                        GetBlok(blok["UbRenPl"], nr) != zero ||
                        GetBlok(blok["UbChrPl"], nr) != zero ||
                        GetBlok(blok["UbWyp"], nr) != zero ||
                        GetBlok(blok["UbZdrPl"], nr) != zero);
                fix2 = GetBlok(blok["UbZdr"], nr) != zero;
            }

            string row = "";
            string pv = t + e + n;
            if (prev != pv) {
                row += datarow;
                row += deschead;
                prev = pv;
            }
            row += descrow;

            row = row.Replace("#OkresR#", string.Format("{0}", ym.Month));
            row = row.Replace("#KodTyUb#", t);
            row = row.Replace("#WmEtat#", e != empty ? e : "");
            row = row.Replace("#KodNFZ#", n);

            row = row.Replace("#UbEmRenP1#", GetBlok(blok["UbEmRenP"], nr));
            row = row.Replace("#UbEmRenP2#", GetBlok(blok["UbEmRenP"], nr));
            row = row.Replace("#UbEmUb#", GetBlok(blok["UbEmUb"], nr));
            row = row.Replace("#UbRenUb#", GetBlok(blok["UbRenUb"], nr));
            row = row.Replace("#UbChrWypP1#", GetBlok(blok["UbChrWypP"], nr));
            row = row.Replace("#UbChrWypP2#", GetBlok(blok["UbWypP"], nr));
            row = row.Replace("#UbChr#", GetBlok(blok["UbChr"], nr));
            row = row.Replace("#UbWypUb#", GetBlok(blok["UbWypUb"], nr));
            row = row.Replace("#UbZdrP#", GetBlok(blok["UbZdrP"], nr));
            row = row.Replace("#UbEmFK#", GetBlok(blok["UbEmerFK"], nr));
            row = row.Replace("#UbRenFK#", GetBlok(blok["UbRentFK"], nr));
            row = row.Replace("#UbChrFK#", GetBlok(blok["UbChorFK"], nr));
            row = row.Replace("#UbWypFK#", GetBlok(blok["UbWypadFK"], nr));
            row = row.Replace("#UbZdrFK#", GetBlok(blok["UbZdrowFK"], nr));

            sumaSkl.Add(GetBlok(blok["UbEmUb"], nr));
            sumaSkl.Add(GetBlok(blok["UbRenUb"], nr));
            sumaSkl.Add(GetBlok(blok["UbChr"], nr));
            sumaSkl.Add(GetBlok(blok["UbWypUb"], nr));
            if (fix && fix1) {
                row = row.Replace("#UbEmBp#", GetBlok(blok["UbEmPl"], nr));
                row = row.Replace("#UbRenBp#", GetBlok(blok["UbRenPl"], nr));
                row = row.Replace("#UbChrBp#", GetBlok(blok["UbChrPl"], nr));
                row = row.Replace("#UbWypBp#", GetBlok(blok["UbWyp"], nr));
                row = row.Replace("#UbEmPl#", GetBlok(blok["UbEmerBp"], nr));
                row = row.Replace("#UbRenPl#", GetBlok(blok["UbRentBp"], nr));
                row = row.Replace("#UbChrPl#", GetBlok(blok["UbChorBp"], nr));
                row = row.Replace("#UbWyp#", GetBlok(blok["UbWypadBp"], nr));
                row = row.Replace("#UbZdrPl#", GetBlok(blok["UbZdrowBp"], nr));
                sumaSkl.Add(GetBlok(blok["UbEmerBp"], nr));
                sumaSkl.Add(GetBlok(blok["UbRentBp"], nr));
                sumaSkl.Add(GetBlok(blok["UbChorBp"], nr));
                sumaSkl.Add(GetBlok(blok["UbWypadBp"], nr));
                sumaSkl.Add(GetBlok(blok["UbZdrowBp"], nr));
                sumaSkl.Add(GetBlok(blok["UbEmPl"], nr));
                sumaSkl.Add(GetBlok(blok["UbRenPl"], nr));
                sumaSkl.Add(GetBlok(blok["UbChrPl"], nr));
                sumaSkl.Add(GetBlok(blok["UbWyp"], nr));
            }
            else {
                row = row.Replace("#UbEmPl#", GetBlok(blok["UbEmPl"], nr));
                row = row.Replace("#UbRenPl#", GetBlok(blok["UbRenPl"], nr));
                row = row.Replace("#UbChrPl#", GetBlok(blok["UbChrPl"], nr));
                row = row.Replace("#UbWyp#", GetBlok(blok["UbWyp"], nr));
                row = row.Replace("#UbZdrPl#", GetBlok(blok["UbZdrPl"], nr));
                row = row.Replace("#UbEmBp#", GetBlok(blok["UbEmerBp"], nr));
                row = row.Replace("#UbRenBp#", GetBlok(blok["UbRentBp"], nr));
                row = row.Replace("#UbChrBp#", GetBlok(blok["UbChorBp"], nr));
                row = row.Replace("#UbWypBp#", GetBlok(blok["UbWypadBp"], nr));
                sumaSkl.Add(GetBlok(blok["UbEmPl"], nr));
                sumaSkl.Add(GetBlok(blok["UbRenPl"], nr));
                sumaSkl.Add(GetBlok(blok["UbChrPl"], nr));
                sumaSkl.Add(GetBlok(blok["UbWyp"], nr));
                sumaSkl.Add(GetBlok(blok["UbZdrPl"], nr));
                sumaSkl.Add(GetBlok(blok["UbEmerBp"], nr));
                sumaSkl.Add(GetBlok(blok["UbRentBp"], nr));
                sumaSkl.Add(GetBlok(blok["UbChorBp"], nr));
                sumaSkl.Add(GetBlok(blok["UbWypadBp"], nr));
            }
            string ubb = zero, ubz = zero;
            if (fix && fix2) {
                ubb = GetBlok(blok["UbZdr"], nr);
                row = row.Replace("#UbZdrBp#", ubb);
                row = row.Replace("#UbZdrUb#", ubz);
            }
            else {
                if (fix && fix1)
                    ubb = GetBlok(blok["UbZdrPl"], nr);
                else
                    ubb = GetBlok(blok["UbZdrowBp"], nr);
                ubz = GetBlok(blok["UbZdr"], nr);
                row = row.Replace("#UbZdrBp#", ubb);
                row = row.Replace("#UbZdrUb#", ubz);
            }
            sumaSkl.Add(ubb);
            sumaSkl.Add(ubz);

            decimal suma = 0;
            foreach (string skl in sumaSkl) {
                string sk = "";
                for (int ii = 0; ii < skl.Length; ii++)
                    if (skl[ii] != 0xa0) sk += skl[ii];
                suma += Convert.ToDecimal(sk.Replace(",", sp));
            }
            sum += suma;
            row = row.Replace("#SumaUb#", (string.Format("{0:n}", suma)).Replace(".", ","));

            DataRow.EditValue = row;

            row = sumrow;
            row = row.Replace("#KodPrzek#", GetBlok(blok["KodPrzek"], nr, false));
            row = row.Replace("#KwotaObn#", GetBlok(blok["KwotaObn"], nr));
            przerwy += Przerwy(blok, tyub);
            row = row.Replace("#PrzerwyL#", przerwy != "" ? tabhead + przerwy : "");
            row = row.Replace("#SumaSumUb#", (string.Format("{0:n}", sum)).Replace(".", ","));

            SumRow.EditValue = row;
        }

        string Przerwy(BlokDeklaracji blok, string tyub) {
            string sp = System.Globalization.CultureInfo.CurrentUICulture.NumberFormat.NumberDecimalSeparator;
            string row, rows = "";

            string przerwy = (string)blok["Przerwy"];
            string[] linie = przerwy.Split('#');
            foreach (string linia in linie) {
                string[] elementy = linia.Split('|');
                if (elementy.Length != 6)
                    continue;
                string t = elementy[0];
                if (tyub != t)
                    continue;
                row = tabrow;
                row = row.Replace("#1#", KodRSA(elementy[1]));
                row = row.Replace("#2#", elementy[3].Substring(0, 10));
                row = row.Replace("#3#", elementy[3].Substring(13, 10));
                row = row.Replace("#4#", elementy[4]);
                string kw = "", str = elementy[5];
                for (int ii = 0; ii < str.Length; ii++)
                    if (str[ii] != 0xa0) kw += str[ii];
                decimal kwota = Convert.ToDecimal(kw.Replace(",", sp));
                row = row.Replace("#5#", (string.Format("{0:n}", kwota)).Replace(".", ","));
                rows += row;
            }

            return rows;
        }

        string KodRSA(string element) {
            string opis = element;
            try {
                int kod = int.Parse(element);
                KodRSA rsa = PlaceModule.GetInstance(dc).KodyRSA.WgKodu[kod];
                if (rsa != null)
                    opis = rsa.Opis;
            }
            catch { }
            return opis;
        }
    }
}
