﻿<%@ Page language="c#" codePage="1200" AutoEventWireup="false"%>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Ksiega" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="System.Collections.Generic" %>
<%@ Import Namespace="System.Linq" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<meta http-equiv="Content-Type" content="text/html; charset=unicode">
        <title>Dekret</title>
		<script runat="server">
            
    void Dekret_OnLoad(Object sender, EventArgs args){
        DekretBase dekret  = (DekretBase)DataContext1.Get(typeof(DekretBase));
        
        string tytul = "Dekret";
        if(dekret.Typ==TypDziennika.BO)
          tytul = tytul + " BO";
        ReportHeader1.Title = 
          string.Format(ReportHeader1.Title,
            tytul, dekret.Numer, dekret.Data, dekret.Bufor ? "Tak" : "Nie", 
            dekret.Ewidencja.NumerDokumentu, dekret.Ewidencja.DataDokumentu, HttpUtility.HtmlEncode(dekret.Opis),
            dekret.Winien, dekret.Ma);

        List<ReportItem> list = new List<ReportItem>();
        
        ReportItem bSum = new ReportItem() { Symbol = "Suma:", Bold = true };
        ReportItem pbSum = new ReportItem() { Symbol = "Suma pozabilansowych:", Bold = true };
        foreach (ZapisKsiegowy zapis in dekret.Zapisy) {
            list.Add(new ReportItem() {
                Lp = zapis.Lp.ToString(),
                Grupa = zapis.Grupa.ToString(),
                Symbol = zapis.Konto.Symbol,
                Winien = zapis.Winien.Value,
                Ma = zapis.Ma.Value,
                Opis = zapis.Opis
            });
            if (zapis.Konto.PozaBilansowe) {
                pbSum.Winien += zapis.Winien.Value;
                pbSum.Ma += zapis.Ma.Value;
            }
            else {
                bSum.Winien += zapis.Winien.Value;
                bSum.Ma += zapis.Ma.Value;
            }
        }
        if (bSum.Winien != 0 || bSum.Ma != 0) list.Add(bSum);
        if (pbSum.Winien != 0 || pbSum.Ma != 0) list.Add(pbSum);
        Grid1.DataSource = list;        
    }

    public class ReportItem
    {
        public ReportItem()
        {
            Winien = Ma = 0m;
        }

        public bool Bold { get; set; }
        public string Lp { get; set; }
        public string Grupa { get; set; }
        public string Symbol { get; set; }
        public decimal Winien { get; set; }
        public decimal Ma { get; set; }
        public string Opis { get; set; }
    }

    protected void Grid1_BeforeRow(object sender, RowEventArgs args)
    {
        var item = args.Row as ReportItem;
        if (item.Bold) {
            ColSymbol.EditValue = "<b>" + item.Symbol + "</b>";
            ColWinien.EditValue = "<b>" + String.Format(ColWinien.Format, item.Winien) + "</b>";
            ColMa.EditValue = "<b>" + String.Format(ColWinien.Format, item.Ma) + "</b>";
        }
        else {
            ColSymbol.EditValue = item.Symbol;
            ColWinien.EditValue = String.Format(ColWinien.Format, item.Winien);
            ColMa.EditValue = String.Format(ColWinien.Format, item.Ma);
        }
    }
</script>
		<meta content="Microsoft Visual Studio 7.0" name="GENERATOR">
		<meta content="C#" name="CODE_LANGUAGE">
		<meta content="JavaScript" name="vs_defaultClientScript">
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<body>
		<form id="Dekret" method="post" runat="server" onload="Dekret_OnLoad">
			<P><ea:datacontext id="DataContext1" runat="server" TypeName="Soneta.Ksiega.DekretBase, Soneta.Ksiega"></ea:datacontext>
				<cc1:ReportHeader id="ReportHeader1" title="{0} | Numer: {1}, Data: {2},  Bufor : {3} | Nr dokumentu: {4}, Data dokumentu: {5} | Opis: {6} | Winien: {7}, Ma: {8}"
					runat="server"></cc1:ReportHeader><BR>
				<ea:grid id="Grid1" runat="server" OnBeforeRow="Grid1_BeforeRow">
					<Columns>
						<ea:GridColumn Width="7" Align="Center" DataMember="Lp" Caption="Lp."></ea:GridColumn>
						<ea:GridColumn Width="7" Align="Center" DataMember="Grupa" Caption="Gr."></ea:GridColumn>
						<ea:GridColumn ID="ColSymbol" Width="30" Caption="Symbol konta"></ea:GridColumn>
						<ea:GridColumn ID="ColWinien" Width="20" Align="Right" Caption="Winien" Format="{0:n}"></ea:GridColumn>
						<ea:GridColumn ID="ColMa" Width="20" Align="Right" Caption="Ma" Format="{0:n}"></ea:GridColumn>
						<ea:GridColumn DataMember="Opis"></ea:GridColumn>
					</Columns>
				</ea:grid>
				<cc1:ReportFooter id="ReportFooter1" runat="server">
					<Subtitles>
						<cc1:FooterSubtitle SubtitleType="Operator"></cc1:FooterSubtitle>
					</Subtitles>
				</cc1:ReportFooter></P>
		</form>
	</body>
</HTML>

