﻿<%@ import Namespace="Soneta.Business" %>
<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="Soneta.Kadry" %>
<%@ import Namespace="Soneta.Place" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Page Language="c#" autoeventwireup="false" CodePage="1200" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<title>Wypłaty gotówkowe</title>
		<script runat="server">

    int lp = 0;
    static int emptyLines = 0;    
    
    void grid_BeforeRow(object sender, RowEventArgs args) {
        Wyplata wyp = (Wyplata)args.Row;
        Currency gotowka = wyp.Wartosc-wyp.Inne;
        args.VisibleRow = gotowka!=0m;
        if (args.VisibleRow) {
            colGotowka.EditValue = gotowka;
            colLP.EditValue = ++lp;
        }

        for (int i = 0; i < emptyLines; i++)
            colBottom.AddLine();
    }

            protected void dc_ContextLoad(object sender, EventArgs e) {
                Row[] rows = (Row[])dc[typeof(Row[])];
                ArrayList wypłaty = new ArrayList();
                bool bufor = false;
                string listy = "";
                foreach (ListaPlac lista in rows) {
                    bufor |= lista.Bufor;
                    foreach (Wyplata w in lista.Wyplaty)
                        wypłaty.Add(w);
                    if (listy != "")
                        listy += "; ";
                    listy += "<b>" + lista.Numer.NumerPelny + "</b>";
                }

                if (bufor)
                    ReportHeader["BUFOR"] = "Lista nie została zatwierdzona!|";
                else
                    ReportHeader["BUFOR"] = "";

                Opis.EditValue = "<font size=\"2\">Listy płac: " + listy + "</font>";
                wypłaty.Sort();
                Grid.DataSource = wypłaty;

                if (emptyLines == 0) {
                    Grid.RowsInRow = 2;
                    colBottom.Visible = false;
                }
            }
		    
</script>
		<meta content="C#" name="CODE_LANGUAGE">
		<meta content="JavaScript" name="vs_defaultClientScript">
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<body>
		<form method="post" runat="server">
			<ea:DataContext id="dc" runat="server" OnContextLoad="dc_ContextLoad"></ea:DataContext>
			<eb:ReportHeader NagłówekOddziału="NagłówekOddziału" id="ReportHeader" title="Wypłaty gotówkowe|%BUFOR%</strong>Typ: <strong>{0}|</strong>Okres: <strong>{1}" runat="server" DataMember1="ListyPlacViewInfo+Params.Okres" DataMember0="ListyPlacViewInfo+Params.Typ"></eb:ReportHeader>
            <ea:DataLabel ID="Opis" runat="server" Bold="False">
            </ea:DataLabel>
			<ea:Grid id="Grid" runat="server" RowTypeName="Soneta.Place.Wyplata,Soneta.KadryPlace" OnBeforeRow="grid_BeforeRow" RowsInRow="3">
				<Columns>
					<ea:GridColumn Width="4" Align="Right" Caption="LP." ID="colLP" RowSpan="2" runat="server" BottomBorder="Single"></ea:GridColumn>
                    <ea:GridColumn ID="colBottom" runat="server" ColSpan="4">
                    </ea:GridColumn>
					<ea:GridColumn DataMember="Pracownik.NazwiskoImię" Caption="Nazwisko i imię" runat="server" Format="&lt;b&gt;{0}&lt;/b&gt;"></ea:GridColumn>
					<ea:GridColumn DataMember="PracHistoria.PESEL" Total="Info" Caption="PESEL" runat="server" BottomBorder="Single"></ea:GridColumn>
					<ea:GridColumn Width="18" Align="Right" Total="Sum" Caption="Kwota|(got&#243;wka)" Format="{0:n}"
						ID="colGotowka" RowSpan="2" runat="server" BottomBorder="Single"></ea:GridColumn>
					<ea:GridColumn Width="24" Align="Center" Caption="Podpis" Format="............................"
						RowSpan="2" runat="server" VAlign="Bottom" BottomBorder="Single"></ea:GridColumn>
				</Columns>
			</ea:Grid>
			<eb:ReportFooter id="ReportFooter" runat="server">
				<Subtitles>
					<eb:FooterSubtitle SubtitleType="Operator"></eb:FooterSubtitle>
					<eb:FooterSubtitle Caption="Sporządził"></eb:FooterSubtitle>
					<eb:FooterSubtitle Caption="Gł&#243;wny księgowy"></eb:FooterSubtitle>
					<eb:FooterSubtitle Caption="Kierownik jednostki"></eb:FooterSubtitle>
				</Subtitles>
			</eb:ReportFooter>
		</form>
	</body>
</HTML>
